/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.crosstabLogic;

import java.util.Vector;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTAggInfo;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptCTHdDBTitleField;
import jet.report.JetRptCTHdLabelField;
import jet.report.JetRptCTHdTextField;
import jet.report.JetRptField;
import jet.report.JetRptObject;

public class CrosstableGeometryState {
    public static final int SCALE = 1;
    public static final int DefaultMinGridCellLength = 300;
    public int columnSize = 0;
    public int rowSize = 0;
    public int aggInfoSize = 0;
    public int[] rowWidths;
    public int[] colHeights;
    public int[] aggHeightList;
    public int[] aggWidthList;
    public int[] aggTitleWidths;
    public int[] aggTitleHeights;
    public int[] rowHeights;
    public int[] colWidthes;
    public int boundaryValue;
    public boolean isVertical;
    public boolean has_M_Label = false;
    public boolean has_D_Label = false;
    public boolean hasSpecialAgg = false;
    public int aggBreakNumber = 0;
    public boolean isRepeatAgg = false;
    public int vGap;
    public int hGap;

    public CrosstableGeometryState(JetRptCTCrossTab jetRptCTCrossTab) {
        this.aggBreakNumber(jetRptCTCrossTab);
    }

    public CrosstableGeometryState(JetRptCTCrossTab jetRptCTCrossTab, boolean bl) {
        this.aggHeightList(jetRptCTCrossTab, bl);
    }

    private void SEDU() {
        this.columnSize = 0;
        this.rowSize = 0;
        this.aggInfoSize = 0;
        this.rowWidths = null;
        this.colHeights = null;
        this.aggHeightList = null;
        this.aggWidthList = null;
        this.aggTitleWidths = null;
        this.aggTitleHeights = null;
        this.boundaryValue = 0;
        this.isVertical = false;
        this.has_M_Label = false;
        this.has_D_Label = false;
        this.aggBreakNumber = 0;
        this.isRepeatAgg = false;
        this.vGap = 0;
        this.hGap = 0;
    }

    private CrosstableGeometryState aggBreakNumber(JetRptCTCrossTab jetRptCTCrossTab) {
        return this.aggHeightList(jetRptCTCrossTab, false);
    }

    private CrosstableGeometryState aggHeightList(JetRptCTCrossTab jetRptCTCrossTab, boolean bl) {
        int n;
        this.SEDU();
        int n2 = jetRptCTCrossTab.boundaryValue.get();
        this.boundaryValue = n2 > 0 ? n2 : -1;
        this.isVertical = jetRptCTCrossTab.verticalLayout.get();
        this.isRepeatAgg = jetRptCTCrossTab.repeatAgg.get();
        this.vGap = jetRptCTCrossTab.vGap.getUnit();
        this.hGap = jetRptCTCrossTab.hGap.getUnit();
        int n3 = 0;
        boolean bl2 = true;
        Vector vector = jetRptCTCrossTab.getChildren();
        for (n = 0; n < vector.size(); ++n) {
            int n4;
            JetRptObject jetRptObject;
            Object e = vector.elementAt(n);
            if (e instanceof JetRptCTAggField) {
                jetRptObject = (JetRptCTAggField)e;
                n4 = ((JetRptCTAggField)jetRptObject).getIndex();
                if (n4 > n3) {
                    n3 = n4;
                }
                if (!((JetRptCTAggField)jetRptObject).isBlank()) {
                    bl2 = false;
                }
            }
            if (e instanceof JetRptCTHdDBField) {
                jetRptObject = (JetRptCTHdDBField)e;
                n4 = ((JetRptCTHdDBField)jetRptObject).isXheader.get() ? 1 : 0;
                int n5 = ((JetRptCTHdDBField)jetRptObject).depth.get();
                if (n4 != 0) {
                    if (n5 < this.columnSize) continue;
                    this.columnSize = n5 + 1;
                    continue;
                }
                if (n5 < this.rowSize) continue;
                this.rowSize = n5 + 1;
                continue;
            }
            if (e instanceof JetRptCTAggInfo) {
                jetRptObject = (JetRptCTAggInfo)e;
                n4 = ((JetRptCTAggInfo)jetRptObject).index.get();
                if (n4 < this.aggInfoSize) continue;
                this.aggInfoSize = n4 + 1;
                continue;
            }
            if (e instanceof JetRptCTHdLabelField) {
                this.has_M_Label = true;
                continue;
            }
            if (!(e instanceof JetRptCTHdDBTitleField)) continue;
            this.has_D_Label = true;
        }
        this.aggInfoSize = n3 + 1;
        this.aggBreakNumber = this.boundaryValue();
        this.rowWidths = new int[this.rowSize == 0 ? 1 : this.rowSize];
        this.colHeights = new int[this.columnSize == 0 ? 1 : this.columnSize];
        this.rowHeights = new int[this.rowSize == 0 ? 1 : this.rowSize + 1];
        this.colWidthes = new int[this.columnSize == 0 ? 1 : this.columnSize + 1];
        if (this.aggInfoSize == 0) {
            this.aggWidthList = new int[0];
            this.aggHeightList = new int[0];
            this.aggTitleHeights = new int[0];
            this.aggTitleWidths = new int[0];
        } else {
            n = 0;
            if (this.has_D_Label || this.has_M_Label) {
                n = 1;
            }
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    this.aggWidthList = new int[(this.columnSize + 1) * this.aggBreakNumber];
                    this.aggHeightList = new int[(this.rowSize + 1) * this.boundaryValue];
                    this.aggTitleWidths = new int[this.aggBreakNumber * n];
                    this.aggTitleHeights = new int[0];
                } else {
                    this.aggWidthList = new int[this.columnSize + 1];
                    this.aggHeightList = new int[(this.rowSize + 1) * this.aggInfoSize];
                    this.aggTitleWidths = new int[1 * n];
                    this.aggTitleHeights = new int[0];
                }
            } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggWidthList = new int[(this.columnSize + 1) * this.boundaryValue];
                this.aggHeightList = new int[(this.rowSize + 1) * this.aggBreakNumber];
                this.aggTitleWidths = new int[0];
                this.aggTitleHeights = new int[this.aggBreakNumber * n];
            } else {
                this.aggWidthList = new int[(this.columnSize + 1) * this.aggInfoSize];
                this.aggHeightList = new int[this.rowSize + 1];
                this.aggTitleWidths = new int[0];
                this.aggTitleHeights = new int[1 * n];
            }
        }
        n = 0;
        boolean bl3 = false;
        for (int i = 0; i < vector.size(); ++i) {
            int n6;
            JetRptField jetRptField;
            Object e = vector.elementAt(i);
            if (e instanceof JetRptCTHdDBField) {
                jetRptField = (JetRptCTHdDBField)e;
                n6 = jetRptField.depth.get();
                if (jetRptField.isXheader.get()) {
                    bl3 = true;
                    this.colHeights[n6] = jetRptField.height.getUnit();
                    continue;
                }
                n = 1;
                this.rowWidths[n6] = jetRptField.width.getUnit();
                continue;
            }
            if (e instanceof JetRptCTAggField && (!((JetRptCTAggField)e).isBlank() || ((JetRptCTAggField)e).width.get() > 0 && ((JetRptCTAggField)e).height.get() > 0 || bl2)) {
                jetRptField = (JetRptCTAggField)e;
                n6 = ((JetRptCTAggField)jetRptField).index.get();
                int n7 = ((JetRptCTAggField)jetRptField).xdepth.get();
                int n8 = ((JetRptCTAggField)jetRptField).ydepth.get();
                if (bl) {
                    if (this.getAggFieldWidth(n7, n6) < ((JetRptCTAggField)jetRptField).width.getUnit()) {
                        this.setAggFieldWidth(n7, n6, ((JetRptCTAggField)jetRptField).width.getUnit());
                    }
                    if (this.getAggFieldHeight(n8, n6) >= ((JetRptCTAggField)jetRptField).height.getUnit()) continue;
                    this.setAggFieldHeight(n8, n6, ((JetRptCTAggField)jetRptField).height.getUnit());
                    continue;
                }
                this.setAggFieldWidth(n7, n6, ((JetRptCTAggField)jetRptField).width.getUnit());
                this.setAggFieldHeight(n8, n6, ((JetRptCTAggField)jetRptField).height.getUnit());
                continue;
            }
            if (e instanceof JetRptCTHdLabelField) {
                jetRptField = (JetRptCTHdLabelField)e;
                n6 = ((JetRptCTHdLabelField)jetRptField).index.get();
                this.setVerticalAggTitleWidht(n6, ((JetRptCTHdLabelField)jetRptField).width.getUnit());
                this.setHorizontalAggTitleHeight(n6, ((JetRptCTHdLabelField)jetRptField).height.getUnit());
                continue;
            }
            if (!(e instanceof JetRptCTHdTextField)) continue;
            jetRptField = (JetRptCTHdTextField)e;
            n6 = ((JetRptCTHdTextField)jetRptField).depth.get();
            if (n6 != 0) continue;
            if (((JetRptCTHdTextField)jetRptField).isXheader.get()) {
                if (bl3) continue;
                this.colHeights[n6] = ((JetRptCTHdTextField)jetRptField).height.getUnit();
                continue;
            }
            if (n != 0) continue;
            this.rowWidths[n6] = ((JetRptCTHdTextField)jetRptField).width.getUnit();
        }
        this.aggInfoSize();
        return this;
    }

    private void aggInfoSize() {
        int[][] nArray = this.aggTitleHeights();
        int[][] nArray2 = this.aggWidthList();
        this.aggTitleWidths(nArray);
        this.arraycopy(nArray2);
    }

    private int[][] aggTitleHeights() {
        int[][] nArray = new int[this.colWidthes.length][this.aggInfoSize];
        for (int i = 0; i < this.columnSize + 1; ++i) {
            for (int j = 0; j < this.aggInfoSize; ++j) {
                nArray[i][j] = this.getAggFieldWidth(i, j);
            }
        }
        return nArray;
    }

    private void aggTitleWidths(int[][] nArray) {
        for (int i = 0; i < this.colWidthes.length; ++i) {
            int n;
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    for (n = 0; n < this.boundaryValue; ++n) {
                        this.colWidthes[i] = this.colWidthes[i] + nArray[i][n];
                    }
                    continue;
                }
                this.colWidthes[i] = nArray[i][0];
                continue;
            }
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                for (n = 0; n < this.aggBreakNumber; ++n) {
                    if (n % this.boundaryValue != 0) continue;
                    this.colWidthes[i] = this.colWidthes[i] + nArray[i][n];
                }
                continue;
            }
            this.colWidthes[i] = nArray[i][0];
        }
    }

    private int[][] aggWidthList() {
        int[][] nArray = new int[this.rowHeights.length][this.aggInfoSize];
        for (int i = 0; i < this.rowSize + 1; ++i) {
            for (int j = 0; j < this.aggInfoSize; ++j) {
                nArray[i][j] = this.getAggFieldHeight(i, j);
            }
        }
        return nArray;
    }

    private void arraycopy(int[][] nArray) {
        for (int i = 0; i < this.rowHeights.length; ++i) {
            int n;
            if (this.isVertical) {
                if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                    for (n = 0; n < this.aggBreakNumber; ++n) {
                        if (n % this.boundaryValue != 0 || nArray[i][n] <= this.rowHeights[i]) continue;
                        this.rowHeights[i] = nArray[i][n];
                    }
                    continue;
                }
                for (n = 0; n < this.aggInfoSize; ++n) {
                    if (nArray[i][n] <= this.rowHeights[i]) continue;
                    this.rowHeights[i] = nArray[i][n];
                }
                continue;
            }
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                for (n = 0; n < this.boundaryValue; ++n) {
                    if (nArray[i][n] <= this.rowHeights[i]) continue;
                    this.rowHeights[i] = nArray[i][n];
                }
                continue;
            }
            this.rowHeights[i] = nArray[i][0];
        }
    }

    public int getColCTDBFieldWidth(int n) {
        int n2 = 0;
        int n3 = this.columnSize - 1 - n;
        for (int i = 0; i <= n3; ++i) {
            if (i > 0) {
                n2 += this.hGap * 2;
            }
            int n4 = this.colWidthes.length - 1 - i;
            n2 += this.colWidthes[n4];
        }
        return n2;
    }

    public int getColCTTextFieldWidth(int n) {
        return this.colWidthes[n];
    }

    public int getRowCTDBFieldHeight(int n) {
        int n2 = 0;
        int n3 = this.rowSize - 1 - n;
        for (int i = 0; i <= n3; ++i) {
            if (i > 0) {
                n2 += this.hGap * 2;
            }
            int n4 = this.rowHeights.length - 1 - i;
            n2 += this.rowHeights[n4];
        }
        return n2;
    }

    public int getRowCTTextFieldHeight(int n) {
        return this.rowHeights[n];
    }

    private int boundaryValue() {
        int n = 0;
        n = this.aggInfoSize / this.boundaryValue;
        if (this.aggInfoSize % this.boundaryValue != 0) {
            ++n;
        }
        return n;
    }

    public int getAggFieldWidth(int n, int n2) {
        int n3 = 0;
        n3 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggWidthList[n * this.aggBreakNumber + n2 / this.boundaryValue] : this.aggWidthList[n]) : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggWidthList[n * this.boundaryValue + n2 % this.boundaryValue] : this.aggWidthList[n * this.aggInfoSize + n2]);
        return n3;
    }

    public void setAggFieldWidth(int n, int n2, int n3) {
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggWidthList[n * this.aggBreakNumber + n2 / this.boundaryValue] = n3;
            } else {
                this.aggWidthList[n] = n3;
            }
        } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
            this.aggWidthList[n * this.boundaryValue + n2 % this.boundaryValue] = n3;
        } else {
            this.aggWidthList[n * this.aggInfoSize + n2] = n3;
        }
        this.aggTitleWidths(this.aggTitleHeights());
    }

    public int getAggFieldHeight(int n, int n2) {
        int n3 = 0;
        n3 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggHeightList[n * this.boundaryValue + n2 % this.boundaryValue] : this.aggHeightList[n * this.aggInfoSize + n2]) : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggHeightList[n * this.aggBreakNumber + n2 / this.boundaryValue] : this.aggHeightList[n]);
        return n3;
    }

    public void setAggFieldHeight(int n, int n2, int n3) {
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggHeightList[n * this.boundaryValue + n2 % this.boundaryValue] = n3;
            } else {
                this.aggHeightList[n * this.aggInfoSize + n2] = n3;
            }
        } else if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
            this.aggHeightList[n * this.aggBreakNumber + n2 / this.boundaryValue] = n3;
        } else {
            this.aggHeightList[n] = n3;
        }
        this.arraycopy(this.aggWidthList());
    }

    public int getVerticalAggTitleWidth(int n) {
        int n2 = 0;
        if (this.aggTitleWidths.length > 0) {
            n2 = this.isVertical ? (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggTitleWidths[n / this.boundaryValue] : this.aggTitleWidths[0]) : -1;
        }
        return n2;
    }

    public void setVerticalAggTitleWidht(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggTitleWidths[n / this.boundaryValue] = n2;
            } else {
                this.aggTitleWidths[0] = n2;
            }
        }
    }

    public int getHorizontalAggTitleHeight(int n) {
        int n2 = 0;
        if (this.aggTitleHeights.length > 0) {
            n2 = this.isVertical ? -1 : (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg ? this.aggTitleHeights[n / this.boundaryValue] : this.aggTitleHeights[0]);
        }
        return n2;
    }

    public void setHorizontalAggTitleHeight(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (!this.isVertical) {
            if (this.boundaryValue > 0 && this.boundaryValue < this.aggInfoSize && !this.isRepeatAgg) {
                this.aggTitleHeights[n / this.boundaryValue] = n2;
            } else {
                this.aggTitleHeights[0] = n2;
            }
        }
    }

    public int getRowCTDBFieldWidth(int n) {
        return this.rowWidths[n];
    }

    public void setRowCTDBFieldWidth(int n, int n2) {
        this.rowWidths[n] = n2;
    }

    public int getColCTDBFieldHeight(int n) {
        return this.colHeights[n];
    }

    public void setColCTDBFieldHeight(int n, int n2) {
        this.colHeights[n] = n2;
    }

    public void setRowHeaderWidth(int n) {
        int n2 = n - this.columnSize(this.rowWidths);
        this.elementAt(this.rowWidths, 0, this.rowWidths.length - 1, n2);
    }

    public void setColHeaderHeight(int n) {
        int n2 = n - this.columnSize(this.colHeights);
        this.elementAt(this.colHeights, 0, this.colHeights.length - 1, n2);
    }

    public void setAggBodyWidth(int n) {
        int n2 = n - this.columnSize(this.aggWidthList);
        this.elementAt(this.aggWidthList, 0, this.aggWidthList.length - 1, n2);
    }

    public void setAggBodyHeight(int n) {
        int n2 = n - this.columnSize(this.aggHeightList);
        this.elementAt(this.aggHeightList, 0, this.aggHeightList.length - 1, n2);
    }

    public void setVerticalAggTitleListWidth(int n) {
        int n2 = n - this.columnSize(this.aggTitleWidths);
        this.elementAt(this.aggTitleWidths, 0, this.aggTitleWidths.length - 1, n2);
    }

    public void setHorizontalAggTitleListHeight(int n) {
        int n2 = n - this.columnSize(this.aggTitleHeights);
        this.elementAt(this.aggTitleHeights, 0, this.aggTitleHeights.length - 1, n2);
    }

    private int colHeights(int n) {
        int n2;
        if (this.isRepeatAgg && !this.isVertical) {
            for (n2 = 0; n2 < this.colHeights.length + 1; ++n2) {
                for (int i = 0; i < this.aggInfoSize; ++i) {
                    n -= 2 * this.hGap;
                }
            }
        } else {
            n -= (this.colHeights.length + 1) * 2 * this.hGap;
        }
        if (this.rowSize == 0) {
            n -= this.hGap * 2;
        } else {
            for (n2 = 0; n2 < this.rowWidths.length; ++n2) {
                n -= this.hGap * 2;
            }
        }
        if (this.aggTitleWidths.length > 0 && this.isVertical) {
            n -= this.hGap * 2;
        }
        return n;
    }

    public void setCrosstableWidth(int n) {
        int n2;
        n = this.colHeights(n);
        int[] nArray = new int[this.rowWidths.length + this.aggTitleWidths.length + this.aggWidthList.length];
        System.arraycopy(this.rowWidths, 0, nArray, 0, this.rowWidths.length);
        if (this.aggTitleWidths.length > 0) {
            System.arraycopy(this.aggTitleWidths, 0, nArray, this.rowWidths.length, this.aggTitleWidths.length);
        }
        System.arraycopy(this.aggWidthList, 0, nArray, this.rowWidths.length + this.aggTitleWidths.length, this.aggWidthList.length);
        int n3 = n - this.columnSize(nArray);
        this.elementAt(nArray, 0, nArray.length - 1, n3);
        int n4 = 0;
        for (n2 = 0; n2 < this.rowWidths.length; ++n2) {
            this.rowWidths[n2] = nArray[n4++];
        }
        for (n2 = 0; n2 < this.aggTitleWidths.length; ++n2) {
            this.aggTitleWidths[n2] = nArray[n4++];
        }
        for (n2 = 0; n2 < this.aggWidthList.length; ++n2) {
            this.aggWidthList[n2] = nArray[n4++];
        }
        nArray = null;
    }

    private int colWidthes(int n) {
        int n2;
        if (this.isRepeatAgg && this.isVertical) {
            for (n2 = 0; n2 < this.rowWidths.length + 1; ++n2) {
                for (int i = 0; i < this.aggInfoSize; ++i) {
                    n -= 2 * this.vGap;
                }
            }
        } else {
            n -= (this.rowWidths.length + 1) * 2 * this.vGap;
        }
        if (this.columnSize == 0) {
            n -= this.vGap * 2;
        } else {
            for (n2 = 0; n2 < this.colHeights.length; ++n2) {
                n -= this.vGap * 2;
            }
        }
        if (this.aggTitleHeights.length > 0 && !this.isVertical) {
            n -= 2 * this.vGap;
        }
        return n;
    }

    public void setCrosstableHeight(int n) {
        int n2;
        n = this.colWidthes(n);
        int[] nArray = new int[this.colHeights.length + this.aggTitleHeights.length + this.aggHeightList.length];
        System.arraycopy(this.colHeights, 0, nArray, 0, this.colHeights.length);
        if (this.aggTitleHeights.length > 0) {
            System.arraycopy(this.aggTitleHeights, 0, nArray, this.colHeights.length, this.aggTitleHeights.length);
        }
        System.arraycopy(this.aggHeightList, 0, nArray, this.colHeights.length + this.aggTitleHeights.length, this.aggHeightList.length);
        int n3 = n - this.columnSize(nArray);
        this.elementAt(nArray, 0, nArray.length - 1, n3);
        int n4 = 0;
        for (n2 = 0; n2 < this.colHeights.length; ++n2) {
            this.colHeights[n2] = nArray[n4++];
        }
        for (n2 = 0; n2 < this.aggTitleHeights.length; ++n2) {
            this.aggTitleHeights[n2] = nArray[n4++];
        }
        for (n2 = 0; n2 < this.aggHeightList.length; ++n2) {
            this.aggHeightList[n2] = nArray[n4++];
        }
        nArray = null;
    }

    public int getRowHeaderWidth() {
        int n = 0;
        for (int i = 0; i < this.rowWidths.length; ++i) {
            n += this.hGap * 2 + this.rowWidths[i];
        }
        return n;
    }

    public int getRowHeaderTextWidth(int n) {
        int n2 = 0;
        for (int i = this.rowWidths.length - 1; i >= 0; --i) {
            n2 += this.hGap * 2 + this.rowWidths[i];
            if (++n == this.rowWidths.length) break;
        }
        return n2;
    }

    public int getColHeaderTextHeight(int n) {
        int n2 = 0;
        for (int i = this.colHeights.length - 1; i >= 0; --i) {
            n2 += this.hGap * 2 + this.colHeights[i];
            if (++n == this.colHeights.length) break;
        }
        return n2;
    }

    public int getColHeaderHeight() {
        int n = 0;
        for (int i = 0; i < this.colHeights.length; ++i) {
            n += this.vGap * 2 + this.colHeights[i];
        }
        return n;
    }

    public int getVerticalAggTitleListWidth() {
        int n = 0;
        if (this.aggTitleWidths.length > 0 && this.isVertical) {
            n += 2 * this.hGap + this.columnSize(this.aggTitleWidths);
        }
        return n;
    }

    public int getHorizontalAggTitleListHeight() {
        int n = 0;
        if (this.aggTitleHeights.length > 0 && !this.isVertical) {
            n += 2 * this.vGap + this.columnSize(this.aggTitleHeights);
        }
        return n;
    }

    public int getAggBodyWidth() {
        int n = 0;
        if (this.aggInfoSize == 0) {
            for (int i = 0; i < this.colHeights.length + 1; ++i) {
                n += 2 * this.hGap + 4800;
            }
        } else if (this.isRepeatAgg && !this.isVertical) {
            int n2 = 0;
            int n3 = this.colHeights.length + 1;
            if (this.columnSize == 0) {
                n3 = this.colHeights.length;
            }
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < this.aggInfoSize; ++j) {
                    n2 = this.getAggFieldWidth(i, j);
                    if (n2 == 0) {
                        n2 = 4800;
                    }
                    n += 2 * this.hGap + n2;
                }
            }
        } else {
            n += this.columnSize(this.aggWidthList) + (this.colHeights.length + 1) * 2 * this.hGap;
        }
        return n;
    }

    public int getAggBodyHeight() {
        int n = 0;
        if (this.aggInfoSize == 0) {
            for (int i = 0; i < this.rowWidths.length + 1; ++i) {
                n += 2 * this.vGap + 1037;
            }
        } else if (this.isRepeatAgg && this.isVertical) {
            int n2 = 0;
            int n3 = this.rowWidths.length + 1;
            if (this.rowSize == 0) {
                n3 = this.rowWidths.length;
            }
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < this.aggInfoSize; ++j) {
                    n2 = this.getAggFieldHeight(i, j);
                    if (n2 == 0) {
                        n2 = 1037;
                    }
                    n += 2 * this.vGap + n2;
                }
            }
        } else {
            n += this.columnSize(this.aggHeightList) + (this.rowWidths.length + 1) * 2 * this.vGap;
        }
        return n;
    }

    public int getCrosstabWidth() {
        return this.getRowHeaderWidth() + this.getVerticalAggTitleListWidth() + this.getAggBodyWidth();
    }

    public int getCrosstabHeight() {
        return this.getColHeaderHeight() + this.getHorizontalAggTitleListHeight() + this.getAggBodyHeight();
    }

    private int columnSize(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    private int depth(int[] nArray) {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private void elementAt(int[] nArray, int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < nArray.length) {
            int n4 = 0;
            int n5 = 0;
            if (n3 > 0) {
                block0: while (n3 >= 1) {
                    for (int i = n; i <= n2; ++i) {
                        n5 = nArray[i];
                        if (n5 > 0) {
                            nArray[i] = n5 + 1;
                            --n3;
                        }
                        if (n3 < 1) continue block0;
                    }
                }
            } else if (n3 < 0) {
                block2: while (n3 <= -1) {
                    for (int i = n; i <= n2; ++i) {
                        n5 = nArray[i];
                        if (n5 > 0) {
                            n4 = nArray[i] - 1;
                            if (n4 < 300) {
                                n4 = 300;
                            }
                            nArray[i] = n4;
                            ++n3;
                        }
                        if (n3 > -1) continue block2;
                    }
                }
            }
            nArray[nArray.length - 1] = nArray[nArray.length - 1] + n3;
        }
    }
}

