/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject;

import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import jet.report.JetRptCTAggField;
import jet.report.JetRptCTDBField;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.resourceLogic.validation.ValidationTools;
import jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject.JetRptObjectDataMatchValidationContext;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.businesslogic.BLNode;

public class DBFieldInCrossTableValidator
extends Validator {
    @Override
    protected ValidationError check(ValidationContext validationContext) {
        JetRptObjectDataMatchValidationContext jetRptObjectDataMatchValidationContext = (JetRptObjectDataMatchValidationContext)validationContext;
        if (!(jetRptObjectDataMatchValidationContext.getJetRptObject() instanceof JetRptCTDBField)) {
            return NoError.getInstance();
        }
        JetRptCTDBField jetRptCTDBField = (JetRptCTDBField)jetRptObjectDataMatchValidationContext.getJetRptObject();
        JetUFormula jetUFormula = null;
        String string = jetRptCTDBField.blColumnName.get();
        String string2 = jetRptCTDBField.getFldName();
        if (!jetRptObjectDataMatchValidationContext.getDataSetInfo().isQueryInfo()) {
            Scope scope;
            BLNode bLNode;
            if (string != null && !string.equals("") && (bLNode = (scope = jetRptObjectDataMatchValidationContext.getDataSetInfo().getScope()).getBLNodeByQualifiedDisplayName(string)) instanceof JetRptFlyFormula) {
                jetUFormula = ((JetRptFlyFormula)bLNode).getJetUFormula();
                if (jetRptCTDBField instanceof JetRptCTAggField) {
                    int n = ((JetRptCTAggField)jetRptCTDBField).getUseTypeValue();
                    if (n == 0) {
                        if (((JetRptFlyFormula)bLNode).getRoleType() != 1 || !ValidationTools.checkOnTheFlyFormulaRoleValidate(scope, (JetRptFlyFormula)bLNode, 1, jetRptObjectDataMatchValidationContext.getResourceStore())) {
                            return new FormulaInCrossTableCanNotSummaryError(jetRptCTDBField.getInstName());
                        }
                        if (jetUFormula != null && !jetUFormula.canSummary()) {
                            return new FormulaInCrossTableCanNotSummaryError(jetUFormula.getInstName());
                        }
                    } else if (!(n != 1 || ((JetRptFlyFormula)bLNode).getRoleType() == 3 && ValidationTools.checkOnTheFlyFormulaRoleValidate(scope, (JetRptFlyFormula)bLNode, 3, jetRptObjectDataMatchValidationContext.getResourceStore()))) {
                        return new FormulaInCrossTableCanNotSummaryError(jetRptCTDBField.getInstName());
                    }
                } else if (((JetRptFlyFormula)bLNode).getRoleType() != 2 || !ValidationTools.checkOnTheFlyFormulaRoleValidate(scope, (JetRptFlyFormula)bLNode, 2, jetRptObjectDataMatchValidationContext.getResourceStore())) {
                    return new FormulaInCrossTableCanNotGroupError(jetRptCTDBField.getInstName());
                }
            }
        } else if (string2 != null && !string2.equals("")) {
            JetUResourceEntity jetUResourceEntity = ObjectLogicFactory.getDataSetLogic().getResourceByName(jetRptObjectDataMatchValidationContext.getDataSetInfo().getUniverse(), jetRptObjectDataMatchValidationContext.getJetRptDataSet(), string2);
            if (jetUResourceEntity instanceof JetUFormula) {
                jetUFormula = (JetUFormula)jetUResourceEntity;
            }
            if (jetUFormula != null && !jetUFormula.canSummary()) {
                return new FormulaInCrossTableCanNotSummaryError(jetUFormula.getInstName());
            }
        }
        return NoError.getInstance();
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError instanceof FormulaInCrossTableCanNotSummaryError) {
            throw new FormulaInCrossTableCanNotSummaryException();
        }
        if (validationError instanceof FormulaInCrossTableCanNotGroupError) {
            throw new FormulaInCrossTableCanNotGroupException();
        }
    }

    public class FormulaInCrossTableCanNotGroupException
    extends ValidationException {
        private static final long serialVersionUID = -6723164513999587529L;
    }

    public class FormulaInCrossTableCanNotGroupError
    extends ValidationError {
        private String SEDU;

        public FormulaInCrossTableCanNotGroupError(String string) {
            this.SEDU = string;
            this.errorMessage = string + " is an on the fly formula and can't be dimention, so it can't be placed in cross table. ";
        }

        public final String getFormulaName() {
            return this.SEDU;
        }
    }

    public class FormulaInCrossTableCanNotSummaryException
    extends ValidationException {
        private static final long serialVersionUID = 6344602108609886038L;
    }

    public class FormulaInCrossTableCanNotSummaryError
    extends ValidationError {
        private String SEDU;

        public FormulaInCrossTableCanNotSummaryError(String string) {
            this.SEDU = string;
            this.errorMessage = string + " is a formula and can't do summary, so it can't be placed in cross table. ";
        }

        public final String getFormulaName() {
            return this.SEDU;
        }
    }
}

