/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject;

import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import java.util.Hashtable;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.report.JetRptObject;
import jet.report.JetRptParamForm;
import jet.report.JetRptRefParameterField;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ReportLogic;
import jet.reportLogic.objectLogic.resourceLogic.validation.jetrptobject.JetRptObjectDataMatchValidationContext;
import jet.reportset.JetRptReport;
import jet.universe.JetUUniverse;

public class ParamControlValidator
extends Validator {
    @Override
    protected ValidationError check(ValidationContext validationContext) {
        JetRptObjectDataMatchValidationContext jetRptObjectDataMatchValidationContext = (JetRptObjectDataMatchValidationContext)validationContext;
        JetRptReport jetRptReport = jetRptObjectDataMatchValidationContext.getDataSetInfo().getReport();
        JetRptObject jetRptObject = jetRptObjectDataMatchValidationContext.getJetRptObject();
        if (jetRptObject instanceof JetRptRefParameterField) {
            JetRptRefParameterField jetRptRefParameterField = (JetRptRefParameterField)jetRptObject;
            JetRptParamForm jetRptParamForm = this.containsKey(jetRptRefParameterField);
            if (jetRptParamForm != null && jetRptParamForm.isTargetOthers()) {
                return NoError.getInstance();
            }
            if (jetRptReport != null && !this.SEDU(jetRptObjectDataMatchValidationContext.getDataSetInfo().getUniverse(), jetRptRefParameterField.param.get(), jetRptReport)) {
                return new ParamNotUsedInRptError(jetRptReport.getInstName(), jetRptRefParameterField.param.get());
            }
        }
        return NoError.getInstance();
    }

    private boolean SEDU(JetUUniverse jetUUniverse, String string, JetRptReport jetRptReport) {
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        Hashtable hashtable = reportLogic.getParameters(jetUUniverse, jetRptReport, true, true);
        return hashtable.containsKey(string);
    }

    private JetRptParamForm containsKey(JetRptRefParameterField jetRptRefParameterField) {
        JetContainable jetContainable = jetRptRefParameterField.getParent();
        while (jetContainable != null) {
            if (jetContainable instanceof JetRptParamForm) {
                return (JetRptParamForm)jetContainable;
            }
            JetObject jetObject = (JetObject)((Object)jetContainable);
            jetContainable = jetObject.getParent();
        }
        return null;
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError instanceof ParamNotUsedInRptError) {
            throw new ParamNotUsedInRptException();
        }
    }

    public class ParamNotUsedInRptException
    extends ValidationException {
        private static final long serialVersionUID = 961076341321060269L;
    }

    public class ParamNotUsedInRptError
    extends ValidationError {
        private String SEDU;
        private String append;

        public ParamNotUsedInRptError(String string, String string2) {
            this.SEDU = string2;
            this.append = string;
            this.errorMessage = string2 + " not used in " + string;
        }
    }
}

