/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.objectinfo;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import java.util.List;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.resourceLogic.validation.DataSetInfo;
import jet.reportLogic.objectLogic.resourceLogic.validation.ValidationTools;
import jet.reportLogic.objectLogic.resourceLogic.validation.objectinfo.DisplayFieldInfoDataMatchValidationContext;
import jet.universe.businesslogic.BLNode;

public class DisplayFieldInfoChartValidator
extends Validator {
    @Override
    protected ValidationError check(ValidationContext validationContext) {
        DisplayFieldInfoDataMatchValidationContext displayFieldInfoDataMatchValidationContext = (DisplayFieldInfoDataMatchValidationContext)validationContext;
        DataSetInfo dataSetInfo = displayFieldInfoDataMatchValidationContext.getDataSetInfo();
        List list = dataSetInfo.getAllBlNames();
        String string = displayFieldInfoDataMatchValidationContext.getDisplayFieldInfo().getBLName();
        if (string != null) {
            if (!string.trim().equals("") && !list.contains(string.trim().toUpperCase())) {
                return new MappingNameNotFoundError(string);
            }
            Scope scope = displayFieldInfoDataMatchValidationContext.getDataSetInfo().getScope();
            BLNode bLNode = scope.getBLNodeByQualifiedDisplayName(string);
            if (bLNode == null) {
                return new MappingNameNotFoundError(string);
            }
            if (bLNode instanceof JetRptFlyFormula ? !this.SEDU(scope, (JetRptFlyFormula)bLNode, displayFieldInfoDataMatchValidationContext.getResourceStore()) : bLNode.getElementType() != 4 && bLNode.getElementType() != 7) {
                return new BLNodeCanNotBeGroupError(bLNode.getDisplayName());
            }
        }
        return NoError.getInstance();
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError instanceof MappingNameNotFoundError) {
            throw new MappingNameNotFoundException();
        }
        if (validationError instanceof BLNodeCanNotBeGroupError) {
            throw new BLNodeCanNotBeGroupException();
        }
    }

    private boolean SEDU(Scope scope, JetRptFlyFormula jetRptFlyFormula, ResourceStore resourceStore) {
        boolean bl = jetRptFlyFormula.getRoleType() == 2 && ValidationTools.checkOnTheFlyFormulaRoleValidate(scope, jetRptFlyFormula, 2, resourceStore) || jetRptFlyFormula.getRoleType() == 1 && ValidationTools.checkOnTheFlyFormulaRoleValidate(scope, jetRptFlyFormula, 1, resourceStore);
        return bl;
    }

    public class BLNodeCanNotBeGroupException
    extends ValidationException {
        private static final long serialVersionUID = 6325993513692042702L;
    }

    public class BLNodeCanNotBeGroupError
    extends ValidationError {
        private String SEDU;

        public BLNodeCanNotBeGroupError(String string) {
            this.SEDU = string;
            this.errorMessage = string + " can not be a group.";
        }

        public final String getMappingName() {
            return this.SEDU;
        }
    }

    public class MappingNameNotFoundException
    extends ValidationException {
        private static final long serialVersionUID = 2771180493461574496L;
    }

    public class MappingNameNotFoundError
    extends ValidationError {
        private String SEDU;

        public MappingNameNotFoundError(String string) {
            this.SEDU = string;
            this.errorMessage = string + " not found.";
        }

        public final String getLostMappingName() {
            return this.SEDU;
        }
    }
}

