/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.objectinfo;

import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import com.jinfonet.validation.Validator;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.formula.SpecFormulaInfo;
import jet.report.specialFunc.SpecialFunction;
import jet.reportLogic.objectInfo.DetailInfo;
import jet.reportLogic.objectInfo.FooterInfo;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectInfo.HeaderInfo;
import jet.reportLogic.objectInfo.TableInfo;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.resourceLogic.validation.objectinfo.DisplayFieldInfoDataMatchValidationContext;
import jet.rptengine.JGroupInitializer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;

public class DisplayFieldInfoInTableValidator
extends Validator {
    @Override
    protected ValidationError check(ValidationContext validationContext) {
        DisplayFieldInfoDataMatchValidationContext displayFieldInfoDataMatchValidationContext = (DisplayFieldInfoDataMatchValidationContext)validationContext;
        if (!(displayFieldInfoDataMatchValidationContext.getDisplayFieldInfo().getRoot() instanceof TableInfo)) {
            return NoError.getInstance();
        }
        String string = displayFieldInfoDataMatchValidationContext.getDisplayFieldInfo().getFieldName();
        if (string == null) {
            return NoError.getInstance();
        }
        JetUResourceEntity jetUResourceEntity = ObjectLogicFactory.getDataSetLogic().getResourceByName(displayFieldInfoDataMatchValidationContext.getDataSetInfo().getUniverse(), displayFieldInfoDataMatchValidationContext.getJetRptDataSet(), string);
        if (jetUResourceEntity instanceof JetUSummary) {
            JetUSummary jetUSummary = (JetUSummary)jetUResourceEntity;
            String string2 = jetUSummary.getGroupByFld();
            boolean bl = jetUSummary.getFormulaInfo().aggdesc.isDynamicSummary();
            Object object = displayFieldInfoDataMatchValidationContext.getDisplayFieldInfo().getParent();
            if (object instanceof HeaderInfo && ((HeaderInfo)object).getHeaderType() == 1 || object instanceof FooterInfo && ((FooterInfo)object).getFooterType() == 1) {
                GroupInfo groupInfo = object instanceof HeaderInfo ? (GroupInfo)((HeaderInfo)object).getParent() : (GroupInfo)((FooterInfo)object).getParent();
                String string3 = groupInfo.getGroupFieldName();
                if (!bl) {
                    if (string2 != null && !string2.trim().equals("") && !string3.trim().toUpperCase().equals(string2.trim().toUpperCase())) {
                        return new StaticSummaryNotMatchInGroupPanelError(string, string3, string2);
                    }
                    SpecialFunction specialFunction = groupInfo.getSpecialFunction();
                    if (specialFunction != null) {
                        SpecFormulaInfo specFormulaInfo = JGroupInitializer.buildSpecFormulaInfo(specialFunction);
                        String string4 = SumrySpecKeyTool.getSpecKey(specFormulaInfo);
                        String string5 = jetUSummary.getSpecFuncKey();
                        if (string5.trim().length() > 0 && !string4.equals(string5)) {
                            return new StaticSummaryNotMatchInGroupPanelError(string, string4, string5);
                        }
                    }
                } else {
                    int n;
                    int n2 = Integer.parseInt(string2);
                    if (n2 > 0) {
                        return new DynamicSummaryInSectionObjectMustLessThanZeroError(string);
                    }
                    if (n2 < 0 && n2 < 0 - (n = this.SEDU(groupInfo))) {
                        return new DynamicSummaryNotMatchInGroupPanelError(string, n2, 0 - n);
                    }
                }
            } else if (object instanceof HeaderInfo && ((HeaderInfo)object).getHeaderType() == 2 || object instanceof FooterInfo && ((FooterInfo)object).getFooterType() == 2 || object instanceof DetailInfo) {
                if (bl && Integer.parseInt(string2) == 0) {
                    return NoError.getInstance();
                }
                if (string2 != null && !string2.trim().equals("")) {
                    return new CanNotContainSummaryError(string);
                }
            }
        }
        return NoError.getInstance();
    }

    private int SEDU(GroupInfo groupInfo) {
        int n = 0;
        Object object = groupInfo.getParent();
        while (object != null && !(object instanceof TableInfo) && object instanceof GroupInfo) {
            ++n;
            object = ((GroupInfo)object).getParent();
        }
        return n + 1;
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError instanceof StaticSummaryNotMatchInGroupPanelError) {
            throw new StaticSummaryNotMatchInGroupPanelException();
        }
        if (validationError instanceof DynamicSummaryNotMatchInGroupPanelError) {
            throw new DynamicSummaryNotMatchInGroupPanelException();
        }
        if (validationError instanceof CanNotContainSummaryError) {
            throw new CanNotContainSummaryException();
        }
        if (validationError instanceof DynamicSummaryInSectionObjectMustLessThanZeroError) {
            throw new DynamicSummaryInSectionObjectMustLessThanZeroException();
        }
    }

    public class DynamicSummaryInSectionObjectMustLessThanZeroException
    extends ValidationException {
        private static final long serialVersionUID = -6136489307361566647L;
    }

    public class DynamicSummaryInSectionObjectMustLessThanZeroError
    extends ValidationError {
        private String SEDU;

        public DynamicSummaryInSectionObjectMustLessThanZeroError(String string) {
            this.SEDU(string);
            this.errorMessage = string + " is summary and can't be placed here.";
        }

        private void SEDU(String string) {
            this.SEDU = string;
        }

        public String getMappingName() {
            return this.SEDU;
        }
    }

    public class CanNotContainSummaryException
    extends ValidationException {
        private static final long serialVersionUID = 3328040403184233786L;
    }

    public class CanNotContainSummaryError
    extends ValidationError {
        private String SEDU;

        public CanNotContainSummaryError(String string) {
            this.SEDU(string);
            this.errorMessage = string + " is summary and can't be placed here.";
        }

        private void SEDU(String string) {
            this.SEDU = string;
        }

        public String getMappingName() {
            return this.SEDU;
        }
    }

    public class DynamicSummaryNotMatchInGroupPanelException
    extends ValidationException {
        private static final long serialVersionUID = 8082850847366315703L;
    }

    public class DynamicSummaryNotMatchInGroupPanelError
    extends ValidationError {
        private String SEDU;
        private int append;
        private int toString;

        public DynamicSummaryNotMatchInGroupPanelError(String string, int n, int n2) {
            this.errorMessage(n2);
            this.append(n);
            this.SEDU(string);
            this.errorMessage = "The " + string + " is dynamic summary and it's level is  " + n + ",but the minimal allowed level is " + n2;
        }

        private void SEDU(String string) {
            this.SEDU = string;
        }

        public String getMappingName() {
            return this.SEDU;
        }

        private void append(int n) {
            this.append = n;
        }

        public int getCurrentLevel() {
            return this.append;
        }

        private void errorMessage(int n) {
            this.toString = n;
        }

        public int getAllowedMinLevel() {
            return this.toString;
        }
    }

    public class StaticSummaryNotMatchInGroupPanelException
    extends ValidationException {
        private static final long serialVersionUID = 6528253715570834425L;
    }

    public class StaticSummaryNotMatchInGroupPanelError
    extends ValidationError {
        private String SEDU;
        private String append;
        private String toString;

        public StaticSummaryNotMatchInGroupPanelError(String string, String string2, String string3) {
            this.SEDU(string2);
            this.append(string3);
            this.errorMessage(string);
            this.errorMessage = "The " + string + " summary's group by " + string3 + ",but the required group by is " + string2;
        }

        private void SEDU(String string) {
            this.SEDU = string;
        }

        public String getRequiredGroupByFieldName() {
            return this.SEDU;
        }

        private void append(String string) {
            this.append = string;
        }

        public String getCurrentFieldName() {
            return this.append;
        }

        private void errorMessage(String string) {
            this.toString = string;
        }

        public String getMappingName() {
            return this.toString;
        }
    }
}

