/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.validator;

import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import jet.JRException;
import jet.icontrols.QueryInfo;
import jet.reportLogic.objectLogic.resourceLogic.validation.context.DatasetValidationContext;
import jet.reportLogic.objectLogic.resourceLogic.validation.result.ValidationResult;
import jet.reportLogic.objectLogic.resourceLogic.validation.validator.ExtValidator;
import jet.reportset.JCannotFoundDatasourceException;
import jet.universe.JetUDatabase;
import jet.universe.JetUQueriable;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.exception.CannotFindQuery;

public class DatasetValidator
extends ExtValidator {
    private ValidationResult SEDU = null;

    private ValidationResult SEDU(ValidationContext validationContext) {
        QueryInfo queryInfo;
        ValidationResult validationResult = new ValidationResult();
        DatasetValidationContext datasetValidationContext = (DatasetValidationContext)validationContext;
        JetUUniverse jetUUniverse = datasetValidationContext.getDataSetInfo().getUniverse();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase((queryInfo = datasetValidationContext.getQueryInfo()).getDatasourceName());
        if (jetUDatabase == null) {
            validationResult.addException(new JCannotFoundDatasourceException(215001, (Object[])new String[]{queryInfo.getDatasourceName()}, null));
        } else if (queryInfo.getDataResoureType() == 0) {
            JetUQueriable jetUQueriable = jetUDatabase.getQueriableByResourceName(queryInfo.getQueryName());
            if (jetUQueriable == null) {
                validationResult.addException(new CannotFindQuery(queryInfo.getQueryName()));
            }
        } else if (queryInfo.getDataResoureType() == 2) {
            UnifiedBusinessView unifiedBusinessView = jetUDatabase.getBusinessView(queryInfo.getBLName());
            if (unifiedBusinessView == null) {
                validationResult.addException(new JRException(215006, (Object[])new String[]{queryInfo.getBLName()}, null));
            }
        } else {
            validationResult.addException(new JRException(215007, (Object[])new Integer[]{queryInfo.getDataResoureType()}, null));
        }
        return validationResult;
    }

    @Override
    public ValidationError check(ValidationContext validationContext) {
        if (!this.checkSupported(validationContext)) {
            return new ExtValidator.UnsupportedValidationError(this, "unsupported ValidationContext!");
        }
        this.SEDU = this.SEDU(validationContext);
        if (this.SEDU.hasException()) {
            InvalidQueryInfoError invalidQueryInfoError = new InvalidQueryInfoError();
            return invalidQueryInfoError;
        }
        return NoError.getInstance();
    }

    @Override
    protected boolean supportedContext(ValidationContext validationContext) {
        return validationContext instanceof DatasetValidationContext;
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError != null && validationError instanceof InvalidQueryInfoError) {
            throw new ValidationException((Throwable)this.SEDU.getExceptions().get(0));
        }
    }

    private class InvalidQueryInfoError
    extends ValidationError {
        private InvalidQueryInfoError() {
        }
    }
}

