/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.resourceLogic.validation.validator;

import com.jinfonet.util.JRLog;
import com.jinfonet.validation.NoError;
import com.jinfonet.validation.ValidationContext;
import com.jinfonet.validation.ValidationError;
import com.jinfonet.validation.ValidationException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jet.controls.JetObject;
import jet.ireport.IDataContainer;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.resourceLogic.ParseResource;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportLogic.objectLogic.resourceLogic.validation.ResourceNamesInfo;
import jet.reportLogic.objectLogic.resourceLogic.validation.ScopeInfo;
import jet.reportLogic.objectLogic.resourceLogic.validation.context.IResourceValidationContext;
import jet.reportLogic.objectLogic.resourceLogic.validation.result.ResourceResult;
import jet.reportLogic.objectLogic.resourceLogic.validation.result.ValidationResult;
import jet.reportLogic.objectLogic.resourceLogic.validation.validator.ExtValidator;
import jet.universe.UniverseToolkit;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.InvalidEntityException;

public class ResourceValidator
extends ExtValidator {
    private ResourceResult SEDU;
    private ScopeInfo add;
    ParseResource parser;

    private ResourceResult SEDU(ValidationContext validationContext) {
        ResourceResult resourceResult;
        this.SEDU = resourceResult = new ResourceResult();
        IResourceValidationContext iResourceValidationContext = (IResourceValidationContext)validationContext;
        this.add = iResourceValidationContext.getScopeInfo();
        Scope scope = this.add.getScope();
        this.parser = ResourceTool.getResourceTool(scope.getCatalog(), scope.getReport(), scope.getDataSourceName(), scope.getQueryName(), scope.getBVName(), scope.getScopeType());
        List list = iResourceValidationContext.getResourceNames();
        if (list != null) {
            for (ResourceNamesInfo resourceNamesInfo : list) {
                if (resourceNamesInfo.getNameScope() == 1) {
                    JetObject jetObject = (JetObject)((Object)this.add.getDataContainer());
                    ValidationResult validationResult = this.equalsIgnoreCase(scope, jetObject, resourceNamesInfo.getRscnames(), resourceNamesInfo.getNametype() == 1);
                    List list2 = validationResult.getExceptions();
                    if (list2 == null) continue;
                    for (Exception exception : list2) {
                        resourceResult.addException(exception);
                    }
                    continue;
                }
                if (resourceNamesInfo.getNametype() == 0) {
                    try {
                        this.add(scope, resourceNamesInfo.getRscnames());
                    }
                    catch (InvalidEntityException invalidEntityException) {
                        resourceResult.addException(invalidEntityException);
                    }
                    catch (CannotFindQuery cannotFindQuery) {
                        resourceResult.addException(cannotFindQuery);
                    }
                    continue;
                }
                try {
                    this.containsKey(scope, resourceNamesInfo.getRscnames());
                }
                catch (InvalidEntityException invalidEntityException) {
                    resourceResult.addException(invalidEntityException);
                }
                catch (Exception exception) {
                    resourceResult.addException(exception);
                }
            }
        }
        return resourceResult;
    }

    private void add(Scope scope, List list) throws InvalidEntityException, CannotFindQuery {
        List[] listArray;
        CheckedRscInfo checkedRscInfo = this.checkSupported(list, 0);
        List list2 = checkedRscInfo.unknown;
        if (list2 != null && list2.size() > 0) {
            this.parser.parseMappingNames(list2, false, false);
            listArray = this.parser.getInvalidRscNames(false, false);
            List list3 = listArray[0];
            List list4 = listArray[1];
            List list5 = listArray[2];
            if (list3.size() > 0) {
                InvalidEntityException invalidEntityException = new InvalidEntityException();
                for (int i = 0; i < list4.size(); ++i) {
                    invalidEntityException.addInvalidEntity((String)list4.get(i), (Short)list5.get(i));
                }
                this.addException(list2, list3, 0);
                throw invalidEntityException;
            }
            this.addException(list2, null, 0);
        }
        if (checkedRscInfo.invalid.size() > 0) {
            listArray = new InvalidEntityException();
            this.addAll((InvalidEntityException)listArray, checkedRscInfo.invalid, (short)3);
            throw listArray;
        }
    }

    private void addAll(InvalidEntityException invalidEntityException, List list, short s) {
        if (list == null || list.size() == 0) {
            return;
        }
        Hashtable hashtable = invalidEntityException.getInvalidEntities();
        for (String string : list) {
            if (hashtable != null && hashtable.containsKey(string)) continue;
            invalidEntityException.addInvalidEntity(string, s);
        }
    }

    private void addException(List list, List arrayList, int n) {
        if (list == null) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (String string : list) {
            if (this.append(arrayList, string)) continue;
            arrayList2.add(string);
        }
        this.add.updateResourceNames(arrayList2, arrayList, n);
        this.addInvalidEntity(list, arrayList);
    }

    private void addInvalidEntity(List list, List list2) {
        if (list2 == null) {
            return;
        }
        for (String string : list2) {
            if (!this.append(list, string)) continue;
            this.SEDU.addResouce(string, 2);
        }
    }

    private void addResouce(List list, List list2, JetObject jetObject) {
        if (list == null || jetObject == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 == null || list2.size() == 0) {
            arrayList.addAll(list);
        } else {
            for (String string : list) {
                if (this.append(list2, string)) continue;
                arrayList.add(string);
            }
        }
        this.add.updateCTFNames(jetObject, arrayList, list2);
        this.addInvalidEntity(list, list2);
    }

    private boolean append(List list, String string) {
        if (list == null || string == null) {
            return false;
        }
        for (String string2 : list) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private CheckedRscInfo checkSupported(List list, int n) {
        CheckedRscInfo checkedRscInfo = new CheckedRscInfo();
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (UniverseToolkit.isBuildinParameterName(string)) {
                    checkedRscInfo.valid.add(string);
                    arrayList.add(string);
                    continue;
                }
                if (this.add.validName(string, n)) {
                    checkedRscInfo.valid.add(string);
                    continue;
                }
                if (this.add.invalidName(string, n)) {
                    checkedRscInfo.invalid.add(string);
                    continue;
                }
                checkedRscInfo.unknown.add(string);
            }
            this.add.updateResourceNames(arrayList, null, 0);
        }
        return checkedRscInfo;
    }

    private void containsKey(Scope scope, List list) throws InvalidEntityException, CannotFindQuery {
        if (list == null) {
            return;
        }
        CheckedRscInfo checkedRscInfo = this.checkSupported(list, 1);
        List list2 = checkedRscInfo.unknown;
        if (list2 != null && list2.size() > 0) {
            this.parser.parseBlDisplayColumns(list2, false);
            List[] listArray = this.parser.getInvalidRscNames(true, false);
            List list3 = listArray[0];
            List list4 = listArray[1];
            List list5 = listArray[2];
            if (list3.size() > 0) {
                InvalidEntityException invalidEntityException = new InvalidEntityException();
                for (int i = 0; i < list4.size(); ++i) {
                    invalidEntityException.addInvalidEntity((String)list4.get(i), (Short)list5.get(i));
                }
                this.addException(list2, list3, 1);
                throw invalidEntityException;
            }
            this.addException(list2, null, 1);
            if (checkedRscInfo.invalid.size() > 0) {
                InvalidEntityException invalidEntityException = new InvalidEntityException();
                this.addAll(invalidEntityException, checkedRscInfo.invalid, (short)4);
                throw invalidEntityException;
            }
        }
    }

    private ValidationResult equalsIgnoreCase(Scope scope, JetObject jetObject, List list, boolean bl) {
        InvalidEntityException invalidEntityException = new InvalidEntityException();
        IDataContainer iDataContainer = ObjectLogicFactory.getDataContainerLogic().getNearestDataContainer(jetObject);
        ValidationResult validationResult = new ValidationResult();
        if (list != null && list.size() != 0) {
            this.parser.parseCompRscs(iDataContainer, list, bl, false, false);
            List[] listArray = this.parser.getInvalidRscNames(bl, true);
            List list2 = listArray[0];
            List list3 = listArray[1];
            List list4 = listArray[2];
            if (list2.size() > 0) {
                for (int i = 0; i < list3.size(); ++i) {
                    invalidEntityException.addInvalidEntity((String)list3.get(i), (Short)list4.get(i));
                }
                this.addResouce(list, list2, jetObject);
                validationResult.addException(invalidEntityException);
            } else {
                this.addResouce(list, null, jetObject);
            }
        }
        return validationResult;
    }

    @Override
    public ValidationError check(ValidationContext validationContext) {
        if (!this.checkSupported(validationContext)) {
            return new ExtValidator.UnsupportedValidationError("unsupported ValidationContext!");
        }
        this.SEDU = this.SEDU(validationContext);
        if (this.SEDU.hasException()) {
            Object object;
            if (JRLog.isTrace(6)) {
                object = this.SEDU.getExceptions();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Exception exception = (Exception)iterator.next();
                    JRLog.trace(6, "Validation error: " + exception.getMessage());
                }
            }
            object = new InvalidResourceError();
            return object;
        }
        return NoError.getInstance();
    }

    public ResourceResult getResult() {
        return this.SEDU;
    }

    @Override
    protected boolean supportedContext(ValidationContext validationContext) {
        return validationContext instanceof IResourceValidationContext;
    }

    @Override
    protected void handleValidationError(ValidationError validationError) throws ValidationException {
        if (validationError != null) {
            throw new ValidationException((Throwable)this.SEDU.getExceptions().get(0));
        }
    }

    private class InvalidResourceError
    extends ValidationError {
        private InvalidResourceError() {
        }
    }

    private class CheckedRscInfo {
        List unknown = new ArrayList();
        List valid = new ArrayList();
        List invalid = new ArrayList();

        private CheckedRscInfo() {
        }
    }
}

