/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import jet.reportLogic.objectLogic.tabularLogic.GridColumn;

public class Columns
extends ArrayList {
    public int hCellSpacing = 0;

    public Columns() {
    }

    public Columns(int n) {
        super(n);
        for (int i = 0; i < n; ++i) {
            this.add(new GridColumn());
        }
    }

    public GridColumn getGridColumn(int n) {
        return (GridColumn)this.get(n);
    }

    public void setGridColumnWidthAt(int n, int n2) {
        this.getGridColumn(n).setWidth(n2);
    }

    public int getGridColumnWidthAt(int n) {
        return this.getGridColumn(n).getWidth();
    }

    public int getGridColumnWidthBetween(int n, int n2) {
        int n3 = 0;
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            for (int i = n; i <= n2; ++i) {
                n3 += this.getGridColumnWidthAt(i);
            }
            n3 += this.hCellSpacing * (n2 - n);
        }
        return n3;
    }

    public int getTotalWidth() {
        return this.getGridColumnWidthBetween(0, this.size() - 1) + this.hCellSpacing * 2;
    }

    public void deleteKeepTotalWidth(int n) {
        if (n >= -1 && n < this.size()) {
            GridColumn gridColumn = (GridColumn)this.remove(n);
            int n2 = this.size();
            if (n2 > 0) {
                int n3 = gridColumn.getWidth();
                this.resizeTotalWidth(n3 + this.hCellSpacing);
            }
        }
    }

    public void delete(int n) {
        if (n >= -1 && n < this.size()) {
            GridColumn gridColumn = (GridColumn)this.remove(n);
        }
    }

    public void addKeepTotalWidth(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridColumn(n2));
            } else {
                this.add(n, new GridColumn(n2));
            }
            this.resizeTotalWidth(-(n2 + this.hCellSpacing));
        }
    }

    @Override
    public void add(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridColumn(n2));
            } else {
                this.add(n, new GridColumn(n2));
            }
        }
    }

    public void resizeTotalWidth(int n) {
        this.resizeWidthBetween(0, this.size() - 1, n);
    }

    public void resizeWidthBetween(int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n2 - n + 1;
            int n5 = 0;
            if (n3 > 0) {
                int n6;
                int n7 = n4 * 1;
                int n8 = n3 / n7;
                for (n6 = n; n6 <= n2; ++n6) {
                    n5 = this.getGridColumnWidthAt(n6) + n8 * 1;
                    this.setGridColumnWidthAt(n6, n5);
                }
                n3 -= n8 * n7;
                block1: while (n3 >= 1) {
                    for (n6 = n; n6 <= n2; ++n6) {
                        n5 = this.getGridColumnWidthAt(n6) + 1;
                        this.setGridColumnWidthAt(n6, n5);
                        if (--n3 < 1) continue block1;
                    }
                }
            } else if (n3 < 0) {
                int n9;
                int n10 = n4 * 1;
                int n11 = -(n3 / n10);
                for (n9 = n; n9 <= n2; ++n9) {
                    n5 = this.getGridColumnWidthAt(n9) - n11 * 1;
                    if (n5 < 600) {
                        n5 = 600;
                    }
                    this.setGridColumnWidthAt(n9, n5);
                }
                n3 += n11 * n10;
                block4: while (n3 <= -1) {
                    for (n9 = n; n9 <= n2; ++n9) {
                        n5 = this.getGridColumnWidthAt(n9) - 1;
                        if (n5 < 600) {
                            n5 = 600;
                        }
                        this.setGridColumnWidthAt(n9, n5);
                        if (++n3 > -1) continue block4;
                    }
                }
            }
            this.setGridColumnWidthAt(this.size() - 1, this.getGridColumnWidthAt(this.size() - 1) + n3);
        }
    }
}

