/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import jet.reportLogic.objectLogic.tabularLogic.GridRow;

public class Rows
extends ArrayList {
    public int vCellSpacing = 0;

    public Rows() {
    }

    public Rows(int n) {
        super(n);
        for (int i = 0; i < n; ++i) {
            this.add(new GridRow());
        }
    }

    public GridRow getGridRow(int n) {
        return (GridRow)this.get(n);
    }

    public int getGridRowHeightAt(int n) {
        return this.getGridRow(n).getHeight();
    }

    public int getGridRowHeightBetween(int n, int n2) {
        int n3 = 0;
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            for (int i = n; i <= n2; ++i) {
                n3 += this.getGridRowHeightAt(i);
            }
            n3 += this.vCellSpacing * (n2 - n);
        }
        return n3;
    }

    public int getTotalHeight() {
        return this.getGridRowHeightBetween(0, this.size() - 1) + this.vCellSpacing * 2;
    }

    public void addGridRow(GridRow gridRow) {
        this.add(gridRow);
    }

    public void setGridRowHeightAt(int n, int n2) {
        this.getGridRow(n).setHeight(n2);
    }

    public void deleteKeepTotalHeight(int n) {
        if (n >= -1 && n < this.size()) {
            GridRow gridRow = (GridRow)this.remove(n);
            int n2 = this.size();
            if (n2 > 0) {
                int n3 = gridRow.getHeight();
                this.resizeTotalHeight(n3 + this.vCellSpacing);
            }
        }
    }

    public void delete(int n) {
        if (n >= -1 && n < this.size()) {
            GridRow gridRow = (GridRow)this.remove(n);
        }
    }

    public void addKeepTotalHeight(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridRow(n2));
            } else {
                this.add(n, new GridRow(n2));
            }
            this.resizeTotalHeight(-(n2 + this.vCellSpacing));
        }
    }

    @Override
    public void add(int n, int n2) {
        if (n >= -1 && n <= this.size()) {
            if (n == -1) {
                this.add(new GridRow(n2));
            } else {
                this.add(n, new GridRow(n2));
            }
        }
    }

    public void resizeTotalHeight(int n) {
        this.resizeHeightBetween(0, this.size() - 1, n);
    }

    public void resizeHeightBetween(int n, int n2, int n3) {
        if (n2 >= n && n >= 0 && n2 < this.size()) {
            int n4 = n2 - n + 1;
            int n5 = 0;
            if (n3 > 0) {
                int n6;
                int n7 = n4 * 1;
                int n8 = n3 / n7;
                for (n6 = n; n6 <= n2; ++n6) {
                    n5 = this.getGridRowHeightAt(n6) + n8 * 1;
                    this.setGridRowHeightAt(n6, n5);
                }
                n3 -= n8 * n7;
                block1: while (n3 >= 1) {
                    for (n6 = n; n6 <= n2; ++n6) {
                        n5 = this.getGridRowHeightAt(n6) + 1;
                        this.setGridRowHeightAt(n6, n5);
                        if (--n3 < 1) continue block1;
                    }
                }
            } else if (n3 < 0) {
                int n9;
                int n10 = n4 * 1;
                int n11 = -(n3 / n10);
                for (n9 = n; n9 <= n2; ++n9) {
                    n5 = this.getGridRowHeightAt(n9) - n11 * 1;
                    if (n5 < 600) {
                        n5 = 600;
                    }
                    this.setGridRowHeightAt(n9, n5);
                }
                n3 += n11 * n10;
                block4: while (n3 <= -1) {
                    for (n9 = n; n9 <= n2; ++n9) {
                        n5 = this.getGridRowHeightAt(n9) - 1;
                        if (n5 < 600) {
                            n5 = 600;
                        }
                        this.setGridRowHeightAt(n9, n5);
                        if (++n3 > -1) continue block4;
                    }
                }
            }
            this.setGridRowHeightAt(this.size() - 1, this.getGridRowHeightAt(this.size() - 1) + n3);
        }
    }
}

