/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.objectLogic.tabularLogic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.reportLogic.objectLogic.tabularLogic.Columns;
import jet.reportLogic.objectLogic.tabularLogic.GridCell;
import jet.reportLogic.objectLogic.tabularLogic.GridColumn;
import jet.reportLogic.objectLogic.tabularLogic.GridRow;
import jet.reportLogic.objectLogic.tabularLogic.IdHandler;
import jet.reportLogic.objectLogic.tabularLogic.Rows;
import jet.reportLogic.objectLogic.tabularLogic.TabularCell;
import jet.reportLogic.objectLogic.tabularLogic.TabularTree;
import jet.util.IntKeyHashtable;
import jet.util.IntSet;
import jet.util.IntVector;

public class Tabular {
    private int SEDU;
    private IntKeyHashtable abs = new IntKeyHashtable();
    private static final boolean add = true;
    private static final boolean addAll = false;
    private IdHandler addElement = new IdHandler(0);
    private Rows addElements = null;
    private Columns addGridCell = null;
    private int addKeepTotalHeight = 0;
    private int addKeepTotalWidth = 0;
    private int addTabularCell = 0;
    private int addTabularCells = 0;
    public static final int SCALE = 1;
    public static final int SHRINK_DEGREE = 1;
    public static final int DefaultGridCellHeigth = 9000;
    public static final int DefaultGridCellWidth = 9000;
    public static final int DefaultMinGridCellLength = 600;
    private static int append = 20;
    int address = -1;

    public Tabular() {
        this.addElements = new Rows();
        this.addGridCell = new Columns();
    }

    public int getBaseMergeCellId() {
        return this.SEDU;
    }

    public Tabular(int n, int n2) {
        this.addElements = new Rows(n);
        this.addGridCell = new Columns(n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                n3 = this.addElement.generateAddress();
                this.abs.put(n3, new TabularCell(n3, new GridCell(j, i)));
            }
        }
    }

    public void markAddress(int n) {
        this.addElement.markMaxAddress(n);
    }

    protected void setAddress(int n) {
        this.address = n;
    }

    protected int getAddress() {
        return this.address;
    }

    public boolean addTabularCell(TabularCell tabularCell) {
        int n = tabularCell.getAddress();
        if (this.abs.containsKey(n)) {
            return false;
        }
        this.abs.put(n, tabularCell);
        return true;
    }

    public TabularCell getTabularCell(int n) {
        return (TabularCell)this.abs.get(n);
    }

    public IntVector getTabularCells() {
        return this.abs.keys();
    }

    public int getTabularCellAmount() {
        return this.getTabularCells().size();
    }

    public int getColumnNum() {
        return this.addGridCell.size();
    }

    public int getRowNum() {
        return this.addElements.size();
    }

    protected int getMaxX() {
        return this.getColumnNum() - 1;
    }

    protected int getMaxY() {
        return this.getRowNum() - 1;
    }

    public int getGridWidth(int n) {
        return this.getMaxX(n) - this.getMinX(n) + 1;
    }

    public int getGridHeight(int n) {
        return this.getMaxY(n) - this.getMinY(n) + 1;
    }

    public int getTabularCellWidth(int n) {
        int n2 = this.getMinX(n);
        int n3 = this.getMaxX(n);
        return this.addGridCell.getGridColumnWidthBetween(n2, n3);
    }

    public int getTabualrCellHorizontalDistance(int n) {
        int n2 = this.getMinX(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += this.addGridCell.getGridColumnWidthAt(i);
        }
        return n3 += this.addGridCell.hCellSpacing * (n2 + 1);
    }

    public int getTabularCellVerticalDistance(int n) {
        int n2 = this.getMinY(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += this.addElements.getGridRowHeightAt(i);
        }
        return n3 += this.addElements.vCellSpacing * (n2 + 1);
    }

    public int getTabulaHeight() {
        return this.addElements.getTotalHeight() + this.addKeepTotalHeight + this.addKeepTotalWidth;
    }

    public int getTabularWidth() {
        return this.addGridCell.getTotalWidth() + this.addTabularCell + this.addTabularCells;
    }

    public int getTabularCellHeight(int n) {
        int n2 = this.getMinY(n);
        int n3 = this.getMaxY(n);
        return this.addElements.getGridRowHeightBetween(n2, n3);
    }

    protected int getMaxX(IntVector intVector) {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        for (int i = 0; i < intVector.size(); ++i) {
            n2 = this.getTabularCell(intVector.elementAt(i)).getMaxX();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected int getMaxY(IntVector intVector) {
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        for (int i = 0; i < intVector.size(); ++i) {
            n2 = this.getTabularCell(intVector.elementAt(i)).getMaxY();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    protected int getMinX(IntVector intVector) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < intVector.size(); ++i) {
            n2 = this.getTabularCell(intVector.elementAt(i)).getMinX();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    protected int getMinY(IntVector intVector) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < intVector.size(); ++i) {
            n2 = this.getTabularCell(intVector.elementAt(i)).getMinY();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public int getMaxX(int n) {
        return this.getTabularCell(n).getMaxX();
    }

    public int getMaxY(int n) {
        return this.getTabularCell(n).getMaxY();
    }

    public int getMinX(int n) {
        return this.getTabularCell(n).getMinX();
    }

    public int getMinY(int n) {
        return this.getTabularCell(n).getMinY();
    }

    protected TabularCell remove(int n) {
        return (TabularCell)this.abs.remove(n);
    }

    public int findTabularCellByCell(int n, int n2, IntVector intVector) {
        TabularCell tabularCell = null;
        for (int i = 0; i < intVector.size(); ++i) {
            tabularCell = this.getTabularCell(intVector.elementAt(i));
            if (!tabularCell.containGridCell(n, n2)) continue;
            return tabularCell.getAddress();
        }
        return -1;
    }

    public TabularTree generateTtree() {
        TabularTree tabularTree = new TabularTree();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = null;
        boolean bl = false;
        int n = this.getMaxX(intVector);
        int n2 = this.getMaxY(intVector);
        for (int i = 0; i <= n2; ++i) {
            bl = true;
            for (int j = 0; j <= n; ++j) {
                int n3 = this.findTabularCellByCell(j, i, intVector);
                if (bl && !tabularTree.contain(n3)) {
                    bl = false;
                    intVector2 = new IntVector();
                    tabularTree.addTabularCells(intVector2);
                    intVector2.addElement(n3);
                    continue;
                }
                if (tabularTree.contain(n3)) continue;
                intVector2.addElement(n3);
            }
        }
        return tabularTree;
    }

    public void changeTotalWidth(int n) {
        this.addGridCell.resizeTotalWidth(n);
    }

    public void changeTotalHeight(int n) {
        this.addElements.resizeTotalHeight(n);
    }

    public void changeTabularCellWidth(int n, int n2) {
        this.changeTabularCellWidth(n, n2, false);
    }

    public void changeTabularCellWidth(int n, int n2, boolean bl) {
        int n3 = this.getMaxX();
        int n4 = this.getMaxX(n);
        if (n2 > 0) {
            if (n3 != n4 && n2 > this.addGridCell.getGridColumnWidthAt(n4 + 1) - 600) {
                n2 = this.addGridCell.getGridColumnWidthAt(n4 + 1) - 600;
            }
        } else if (n2 < 0 && Math.abs(n2) > this.addGridCell.getGridColumnWidthAt(n4) - 600) {
            n2 = -(this.addGridCell.getGridColumnWidthAt(n4) - 600);
        }
        this.addGridCell.resizeWidthBetween(n4, n4, n2);
        if (!bl && n3 != n4) {
            int n5 = n4 + 1;
            this.addGridCell.resizeWidthBetween(n5, n5, -n2);
        }
    }

    public void changeTabularCellsWidth(int[] nArray, int n) {
        for (int n2 : nArray) {
            int n3 = this.getTabularCellWidth(n2);
            int n4 = n - n3;
            int n5 = this.getMaxX();
            int n6 = this.getMaxX(n2);
            if (n4 > 0) {
                if (n5 != n6 && n4 > this.addGridCell.getGridColumnWidthAt(n6 + 1) - 600) {
                    n4 = this.addGridCell.getGridColumnWidthAt(n6 + 1) - 600;
                }
            } else if (n4 < 0 && Math.abs(n4) > this.addGridCell.getGridColumnWidthAt(n6) - 600) {
                n4 = -(this.addGridCell.getGridColumnWidthAt(n6) - 600);
            }
            this.addGridCell.resizeWidthBetween(n6, n6, n4);
        }
    }

    private void SEDU(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        int n4 = this.getMaxX();
        if (n4 == (n3 = this.getMaxX(n))) {
            this.addGridCell.resizeWidthBetween(n3, n3, n2);
        } else {
            int n5 = this.getMaxY(n);
            int n6 = this.getMinY(n);
            IntVector intVector = this.getTabularCells();
            int n7 = n3;
            ArrayList<TabularCell> arrayList = new ArrayList<TabularCell>();
            arrayList.add(this.getTabularCell(n));
            List list = this.add(n7 + 1, n6, n5, intVector);
            this.abs(arrayList, list, n2);
        }
    }

    public void changeTabularCellsWidth(int[] nArray, int n, int n2) {
        List<TabularCell> list;
        TabularCell tabularCell;
        Hashtable<Integer, List<TabularCell>> hashtable = new Hashtable<Integer, List<TabularCell>>();
        for (int n3 : nArray) {
            tabularCell = this.getTabularCell(n3);
            int n4 = n2 == 0 ? tabularCell.getMinX() : tabularCell.getMaxX();
            list = (List)hashtable.get(n4);
            if (list == null) {
                list = new ArrayList();
                hashtable.put(n4, list);
            }
            list.add(tabularCell);
        }
        Object object = new ArrayList(hashtable.keySet());
        List<TabularCell> list2 = new ArrayList();
        list = new ArrayList();
        int n5 = -1;
        IntVector intVector = this.getTabularCells();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            int n6;
            Object[] objectArray2;
            Integer n7 = (Integer)iterator.next();
            List list3 = (List)hashtable.get(n7);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Object[] objectArray2 : list3) {
                int n8 = objectArray2.getMinY();
                arrayList.add(n8);
            }
            Object[] objectArray3 = arrayList.toArray(new Integer[0]);
            Arrays.sort(objectArray3);
            int n9 = -1;
            objectArray2 = objectArray3;
            int n10 = objectArray2.length;
            for (int i = 0; i < n10; ++i) {
                int n11 = (Integer)objectArray2[i];
                tabularCell = this.getTabularCell(this.findTabularCellByCell(n7, n11, intVector));
                if (n9 == -1) {
                    n5 = n11;
                }
                if (n9 == -1 || n11 == n9 + 1) {
                    if (n2 == 0) {
                        list.add(tabularCell);
                    } else {
                        list2.add(tabularCell);
                    }
                    n9 = tabularCell.getMaxY();
                    continue;
                }
                n6 = n9;
                if (n2 == 0) {
                    list2 = this.add(n7 - 1, n5, n6, intVector);
                } else {
                    list = this.add(n7 + 1, n5, n6, intVector);
                }
                this.abs(list2, list, n);
                list2.clear();
                list.clear();
                n5 = n11;
                n9 = tabularCell.getMaxY();
            }
            n6 = n9;
            if (n2 == 0) {
                list2 = this.add(n7 - 1, n5, n6, intVector);
            } else {
                list = this.add(n7 + 1, n5, n6, intVector);
            }
            this.abs(list2, list, n);
        }
    }

    private void abs(List list, List list2, int n) {
        Object object;
        boolean bl = this.addAll(list, list2, true);
        if (!bl) {
            return;
        }
        IntVector intVector = new IntVector();
        IntVector intVector2 = new IntVector();
        for (TabularCell tabularCell : list2) {
            intVector.addElement(tabularCell.getAddress());
        }
        for (TabularCell tabularCell : list) {
            intVector2.addElement(tabularCell.getAddress());
        }
        int n2 = -1;
        int n3 = -1;
        if (n > 0) {
            Object object2;
            object = this.addElement(list2, true);
            int n4 = ((TabularCellInfo)object).borderlen;
            if (n > n4) {
                n = n4 - 600;
            }
            if (n <= 0) {
                return;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            for (int i = 0; i < intVector.size(); ++i) {
                TabularCell tabularCell;
                TabularCell tabularCell2;
                int n5;
                int n6 = intVector.elementAt(i);
                if (i == 0) {
                    int n7 = this.getTabularCellWidth(n6);
                    double d = n7 == 0 ? 0.0 : (double)n / (double)n7;
                    double[] dArray = new double[]{d, 1.0 - d};
                    object2 = this.cell(n6, dArray, false, true);
                    n5 = object2[((int[])object2).length - 1];
                    tabularCell2 = this.getTabularCell(n5);
                    nArray[1] = tabularCell2.getMinX();
                    nArray2[1] = tabularCell2.getMaxX();
                    tabularCell = (TabularCell)list2.get(i);
                    nArray[0] = tabularCell.getMinX();
                    nArray2[0] = tabularCell.getMaxX();
                    n2 = nArray[0];
                    n3 = nArray2[1];
                } else {
                    object2 = this.address(n6, nArray, nArray2);
                    n5 = object2[((int[])object2).length - 1];
                    tabularCell2 = this.getTabularCell(n5);
                    tabularCell = (TabularCell)list2.get(i);
                }
                tabularCell.setAddress(n5);
                this.abs.put(n5, tabularCell);
                tabularCell2.setAddress(n6);
                this.abs.put(n6, tabularCell2);
                arrayList.add(n5);
            }
            IntVector intVector3 = new IntVector();
            if (list.size() > 1) {
                int n8 = -1;
                if (arrayList.size() > 1) {
                    n8 = this.merge(intVector3, true, false);
                } else if (arrayList.size() == 1) {
                    n8 = (Integer)arrayList.get(0);
                }
                int[] nArray3 = new int[list.size()];
                int[] nArray4 = new int[list.size()];
                int n9 = 0;
                for (TabularCell tabularCell : list) {
                    nArray3[n9] = tabularCell.getMinY();
                    nArray4[n9] = tabularCell.getMaxY();
                    ++n9;
                }
                Object object3 = this.addTabularCells(n8, nArray3, nArray4);
                for (int i = 0; i < intVector2.size(); ++i) {
                    intVector3 = new IntVector();
                    intVector3.addElement(intVector2.elementAt(i));
                    if (i == 0) {
                        intVector3.addElement(n8);
                    } else {
                        intVector3.addElement((int)object3[i - 1]);
                    }
                    this.merge(intVector3, true, false);
                }
            } else if (list.size() == 1) {
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    int n10 = (Integer)object2.next();
                    intVector3.addElement(n10);
                }
                intVector3.addElement(intVector2.elementAt(0));
                if (intVector3.size() > 1) {
                    this.merge(intVector3, true, false);
                }
            }
        } else if (n < 0) {
            Object object4;
            object = this.addElement(list, true);
            int n11 = ((TabularCellInfo)object).borderlen;
            if (-n > n11) {
                n = -(n11 - 600);
            }
            if (n >= 0) {
                return;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray = new int[2];
            int[] nArray5 = new int[2];
            for (int i = 0; i < intVector2.size(); ++i) {
                int n12;
                int n13 = intVector2.elementAt(i);
                if (i == 0) {
                    int n14 = this.getTabularCellWidth(n13);
                    double d = n14 == 0 ? 0.0 : -((double)n) / (double)n14;
                    double[] dArray = new double[]{1.0 - d, d};
                    object4 = this.cell(n13, dArray, false, true);
                    n12 = object4[((int[])object4).length - 1];
                    TabularCell tabularCell = this.getTabularCell(n12);
                    nArray[1] = tabularCell.getMinX();
                    nArray5[1] = tabularCell.getMaxX();
                    TabularCell tabularCell3 = (TabularCell)list.get(i);
                    nArray[0] = tabularCell3.getMinX();
                    nArray5[0] = tabularCell3.getMaxX();
                    n2 = nArray[0];
                    n3 = nArray5[1];
                } else {
                    object4 = this.address(n13, nArray, nArray5);
                    n12 = object4[((int[])object4).length - 1];
                }
                arrayList.add(n12);
            }
            IntVector intVector4 = new IntVector();
            if (list2.size() > 1) {
                int n15 = -1;
                if (arrayList.size() > 1) {
                    n15 = this.merge(intVector4, true, false);
                } else if (arrayList.size() == 1) {
                    n15 = (Integer)arrayList.get(0);
                }
                int[] nArray6 = new int[list2.size()];
                int[] nArray7 = new int[list2.size()];
                int n16 = 0;
                for (TabularCell tabularCell : list2) {
                    nArray6[n16] = tabularCell.getMinY();
                    nArray7[n16] = tabularCell.getMaxY();
                    ++n16;
                }
                Object object5 = this.addTabularCells(n15, nArray6, nArray7);
                for (int i = 0; i < intVector.size(); ++i) {
                    intVector4 = new IntVector();
                    int n17 = intVector.elementAt(i);
                    intVector4.addElement(n17);
                    if (i == 0) {
                        intVector4.addElement(n15);
                    } else {
                        intVector4.addElement((int)object5[i - 1]);
                    }
                    int n18 = this.merge(intVector4, true, false);
                    TabularCell tabularCell = this.getTabularCell(n18);
                    tabularCell.setAddress(n17);
                    this.abs.put(n17, tabularCell);
                    this.abs.remove(n18);
                }
            } else if (list2.size() == 1) {
                int n19;
                object4 = arrayList.iterator();
                while (object4.hasNext()) {
                    n19 = (Integer)object4.next();
                    intVector4.addElement(n19);
                }
                int n20 = intVector.elementAt(0);
                intVector4.addElement(n20);
                if (intVector4.size() > 1) {
                    n19 = this.merge(intVector4, true, false);
                    TabularCell tabularCell = this.getTabularCell(n19);
                    tabularCell.setAddress(n20);
                    this.abs.put(n20, tabularCell);
                    this.abs.remove(n19);
                }
            }
        } else {
            return;
        }
    }

    private List add(int n, int n2, int n3, IntVector intVector) {
        ArrayList<TabularCell> arrayList = new ArrayList<TabularCell>();
        TabularCell tabularCell = null;
        block0: for (int i = 0; i < intVector.size(); ++i) {
            tabularCell = this.getTabularCell(intVector.elementAt(i));
            for (int j = n2; j <= n3; ++j) {
                if (!tabularCell.containGridCell(n, j)) continue;
                arrayList.add(tabularCell);
                continue block0;
            }
        }
        return arrayList;
    }

    private boolean addAll(List list, List list2, boolean bl) {
        int n;
        int n2;
        TabularCell tabularCell;
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < list.size(); ++n3) {
            tabularCell = (TabularCell)list.get(n3);
            n2 = tabularCell.getAddress();
            n = bl ? this.getTabularCellHeight(n2) : this.getTabularCellWidth(tabularCell.getAddress());
            n4 += n;
        }
        for (n3 = 0; n3 < list2.size(); ++n3) {
            tabularCell = (TabularCell)list2.get(n3);
            n2 = tabularCell.getAddress();
            n = bl ? this.getTabularCellHeight(n2) : this.getTabularCellWidth(n2);
            n5 += n;
        }
        return n4 != 0 && n4 == n5;
    }

    private TabularCellInfo addElement(List list, boolean bl) {
        TabularCell tabularCell = null;
        int n = -1;
        for (TabularCell tabularCell2 : list) {
            int n2 = bl ? this.getTabularCellWidth(tabularCell2.getAddress()) : this.getTabularCellHeight(tabularCell2.getAddress());
            if (n >= 0 && n >= n2) continue;
            n = n2;
            tabularCell = tabularCell2;
        }
        TabularCellInfo tabularCellInfo = new TabularCellInfo();
        tabularCellInfo.cell = tabularCell;
        tabularCellInfo.borderlen = n;
        return tabularCellInfo;
    }

    private List addElements(int n, int n2, int n3, IntVector intVector) {
        ArrayList<TabularCell> arrayList = new ArrayList<TabularCell>();
        TabularCell tabularCell = null;
        block0: for (int i = 0; i < intVector.size(); ++i) {
            tabularCell = this.getTabularCell(intVector.elementAt(i));
            for (int j = n2; j <= n3; ++j) {
                if (!tabularCell.containGridCell(j, n)) continue;
                arrayList.add(tabularCell);
                continue block0;
            }
        }
        return arrayList;
    }

    public void changeTabularCellHeight(int n, int n2) {
        this.changeTabularCellHeight(n, n2, true);
    }

    public void changeTabularCellHeight(int n, int n2, boolean bl) {
        int n3;
        int n4 = this.getMaxY(n);
        if (n2 < 0 && Math.abs(n2) > this.addElements.getGridRowHeightAt(n4) - 600) {
            n2 = -(this.addElements.getGridRowHeightAt(n4) - 600);
        }
        this.addElements.resizeHeightBetween(n4, n4, n2);
        if (!bl && (n3 = this.getMaxY()) != n4) {
            int n5 = n4 + 1;
            this.addElements.resizeHeightBetween(n5, n5, -n2);
        }
    }

    public void changeTabularCellsHeight(int[] nArray, int n) {
        for (int n2 : nArray) {
            int n3 = this.getTabularCellHeight(n2);
            int n4 = n - n3;
            int n5 = this.getMaxY();
            int n6 = this.getMaxY(n2);
            if (n4 > 0) {
                if (n5 != n6 && n4 > this.addElements.getGridRowHeightAt(n6 + 1) - 600) {
                    n4 = this.addElements.getGridRowHeightAt(n6 + 1) - 600;
                }
            } else if (n4 < 0 && Math.abs(n4) > this.addElements.getGridRowHeightAt(n6) - 600) {
                n4 = -(this.addElements.getGridRowHeightAt(n6) - 600);
            }
            this.addElements.resizeHeightBetween(n6, n6, n4);
        }
    }

    private void addGridCell(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        int n4 = this.getMaxY();
        if (n4 == (n3 = this.getMaxY(n))) {
            this.addElements.resizeHeightBetween(n3, n3, n2);
        } else {
            int n5 = this.getMaxX(n);
            int n6 = this.getMinX(n);
            IntVector intVector = this.getTabularCells();
            ArrayList<TabularCell> arrayList = new ArrayList<TabularCell>();
            arrayList.add(this.getTabularCell(n));
            List list = this.addElements(n3 + 1, n6, n5, intVector);
            this.addKeepTotalHeight(arrayList, list, n2);
        }
    }

    public void changeTabularCellsHeight(int[] nArray, int n, int n2) {
        List<TabularCell> list;
        TabularCell tabularCell;
        Hashtable<Integer, List<TabularCell>> hashtable = new Hashtable<Integer, List<TabularCell>>();
        for (int n3 : nArray) {
            tabularCell = this.getTabularCell(n3);
            int n4 = n2 == 0 ? tabularCell.getMinY() : tabularCell.getMaxY();
            list = (List)hashtable.get(n4);
            if (list == null) {
                list = new ArrayList();
                hashtable.put(n4, list);
            }
            list.add(tabularCell);
        }
        Object object = new ArrayList(hashtable.keySet());
        List<TabularCell> list2 = new ArrayList();
        list = new ArrayList();
        int n5 = -1;
        IntVector intVector = this.getTabularCells();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            int n6;
            Object[] objectArray2;
            Integer n7 = (Integer)iterator.next();
            List list3 = (List)hashtable.get(n7);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Object[] objectArray2 : list3) {
                int n8 = objectArray2.getMinX();
                arrayList.add(n8);
            }
            Object[] objectArray3 = arrayList.toArray(new Integer[0]);
            Arrays.sort(objectArray3);
            int n9 = -1;
            objectArray2 = objectArray3;
            int n10 = objectArray2.length;
            for (int i = 0; i < n10; ++i) {
                int n11 = (Integer)objectArray2[i];
                tabularCell = this.getTabularCell(this.findTabularCellByCell(n11, (int)n7, intVector));
                if (n9 == -1) {
                    n5 = n11;
                }
                if (n9 == -1 || n11 == n9 + 1) {
                    if (n2 == 0) {
                        list.add(tabularCell);
                    } else {
                        list2.add(tabularCell);
                    }
                    n9 = tabularCell.getMaxX();
                    continue;
                }
                n6 = n9;
                if (n2 == 0) {
                    list2 = this.addElements(n7 - 1, n5, n6, intVector);
                } else {
                    list = this.addElements(n7 + 1, n5, n6, intVector);
                }
                this.abs(list2, list, n);
                list2.clear();
                list.clear();
                n5 = n11;
                n9 = tabularCell.getMaxX();
            }
            n6 = n9;
            if (n2 == 0) {
                list2 = this.addElements(n7 - 1, n5, n6, intVector);
            } else {
                list = this.addElements(n7 + 1, n5, n6, intVector);
            }
            this.addKeepTotalHeight(list2, list, n);
        }
    }

    private void addKeepTotalHeight(List list, List list2, int n) {
        boolean bl = this.addAll(list, list2, false);
        if (!bl) {
            return;
        }
        IntVector intVector = new IntVector();
        IntVector intVector2 = new IntVector();
        for (TabularCell tabularCell : list2) {
            intVector.addElement(tabularCell.getAddress());
        }
        for (TabularCell tabularCell : list) {
            intVector2.addElement(tabularCell.getAddress());
        }
        int n2 = -1;
        int n3 = -1;
        if (n > 0) {
            Object object;
            TabularCellInfo tabularCellInfo = this.addElement(list2, false);
            int n4 = tabularCellInfo.borderlen;
            if (n > n4) {
                n = n4 - 600;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            for (int i = 0; i < intVector.size(); ++i) {
                TabularCell tabularCell;
                TabularCell tabularCell2;
                int n5;
                int n6 = intVector.elementAt(i);
                if (i == 0) {
                    int n7 = this.getTabularCellHeight(n6);
                    double d = n7 == 0 ? 0.0 : (double)n / (double)n7;
                    double[] dArray = new double[]{d, 1.0 - d};
                    object = this.contain(n6, dArray, false, true);
                    n5 = object[((int[])object).length - 1];
                    tabularCell2 = (TabularCell)list2.get(i);
                    tabularCell = this.getTabularCell(n5);
                    nArray[0] = tabularCell2.getMinY();
                    nArray2[0] = tabularCell2.getMaxY();
                    nArray[1] = tabularCell.getMinY();
                    nArray2[1] = tabularCell.getMaxY();
                    n2 = nArray[0];
                    n3 = nArray2[1];
                } else {
                    object = this.addTabularCells(n6, nArray, nArray2);
                    n5 = object[((int[])object).length - 1];
                    tabularCell2 = (TabularCell)list2.get(i);
                    tabularCell = this.getTabularCell(n5);
                }
                tabularCell2.setAddress(n5);
                this.abs.put(n5, tabularCell2);
                tabularCell.setAddress(n6);
                this.abs.put(n6, tabularCell);
                arrayList.add(n5);
            }
            IntVector intVector3 = new IntVector();
            if (list.size() > 1) {
                int n8 = -1;
                if (arrayList.size() > 1) {
                    n8 = this.merge(intVector3, true, false);
                } else if (arrayList.size() == 1) {
                    n8 = (Integer)arrayList.get(0);
                }
                int[] nArray3 = new int[list.size()];
                int[] nArray4 = new int[list.size()];
                int n9 = 0;
                for (TabularCell tabularCell : list) {
                    nArray3[n9] = tabularCell.getMinX();
                    nArray4[n9] = tabularCell.getMaxX();
                    ++n9;
                }
                Object object2 = this.address(n8, nArray3, nArray4);
                for (int i = 0; i < intVector2.size(); ++i) {
                    intVector3 = new IntVector();
                    intVector3.addElement(intVector2.elementAt(i));
                    if (i == 0) {
                        intVector3.addElement(n8);
                    } else {
                        intVector3.addElement((int)object2[i - 1]);
                    }
                    this.merge(intVector3, true, false);
                }
            } else if (list.size() == 1) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    int n10 = (Integer)object.next();
                    intVector3.addElement(n10);
                }
                intVector3.addElement(intVector2.elementAt(0));
                if (intVector3.size() > 1) {
                    this.merge(intVector3, true, false);
                }
            }
        } else if (n < 0) {
            Object object;
            TabularCellInfo tabularCellInfo = this.addElement(list, false);
            int n11 = tabularCellInfo.borderlen;
            if (-n > n11) {
                n = -(n11 - 600);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray = new int[2];
            int[] nArray5 = new int[2];
            for (int i = 0; i < intVector2.size(); ++i) {
                int n12;
                int n13 = intVector2.elementAt(i);
                if (i == 0) {
                    int n14 = this.getTabularCellHeight(n13);
                    double d = n14 == 0 ? 0.0 : -((double)n) / (double)n14;
                    double[] dArray = new double[]{1.0 - d, d};
                    object = this.contain(n13, dArray, false, true);
                    n12 = object[((int[])object).length - 1];
                    TabularCell tabularCell = (TabularCell)list.get(i);
                    TabularCell tabularCell3 = this.getTabularCell(n12);
                    nArray[0] = tabularCell.getMinY();
                    nArray5[0] = tabularCell.getMaxY();
                    nArray[1] = tabularCell3.getMinY();
                    nArray5[1] = tabularCell3.getMaxY();
                    n2 = nArray[0];
                    n3 = nArray5[1];
                } else {
                    object = this.addTabularCells(n13, nArray, nArray5);
                    n12 = object[((int[])object).length - 1];
                }
                arrayList.add(n12);
            }
            IntVector intVector4 = new IntVector();
            if (list2.size() > 1) {
                int n15 = -1;
                if (arrayList.size() > 1) {
                    n15 = this.merge(intVector4, true, false);
                } else if (arrayList.size() == 1) {
                    n15 = (Integer)arrayList.get(0);
                }
                int[] nArray6 = new int[list2.size()];
                int[] nArray7 = new int[list2.size()];
                int n16 = 0;
                for (TabularCell tabularCell : list2) {
                    nArray6[n16] = tabularCell.getMinX();
                    nArray7[n16] = tabularCell.getMaxX();
                    ++n16;
                }
                Object object3 = this.address(n15, nArray6, nArray7);
                for (int i = 0; i < intVector.size(); ++i) {
                    intVector4 = new IntVector();
                    int n17 = intVector.elementAt(i);
                    intVector4.addElement(n17);
                    if (i == 0) {
                        intVector4.addElement(n15);
                    } else {
                        intVector4.addElement((int)object3[i - 1]);
                    }
                    int n18 = this.merge(intVector4, true, false);
                    TabularCell tabularCell = this.getTabularCell(n18);
                    tabularCell.setAddress(n17);
                    this.abs.put(n17, tabularCell);
                    this.abs.remove(n18);
                }
            } else if (list2.size() == 1) {
                int n19;
                object = arrayList.iterator();
                while (object.hasNext()) {
                    n19 = (Integer)object.next();
                    intVector4.addElement(n19);
                }
                int n20 = intVector.elementAt(0);
                intVector4.addElement(n20);
                if (intVector4.size() > 1) {
                    n19 = this.merge(intVector4, true, false);
                    TabularCell tabularCell = this.getTabularCell(n19);
                    tabularCell.setAddress(n20);
                    this.abs.put(n20, tabularCell);
                    this.abs.remove(n19);
                }
            }
        } else {
            return;
        }
    }

    private int addKeepTotalWidth(int[] nArray, int n, int n2) {
        for (int n3 : nArray) {
            TabularCell tabularCell = this.getTabularCell(n3);
            if (tabularCell == null || tabularCell.getMinX() != n || tabularCell.getMaxX() != n2) continue;
            return n3;
        }
        return -1;
    }

    private int addTabularCell(int[] nArray, int n, int n2) {
        for (int n3 : nArray) {
            TabularCell tabularCell = this.getTabularCell(n3);
            if (tabularCell == null || tabularCell.getMinY() != n || tabularCell.getMaxY() != n2) continue;
            return n3;
        }
        return -1;
    }

    public boolean isMergable(IntVector intVector) {
        int n;
        int n2 = 0;
        for (n = 0; n < intVector.size(); ++n) {
            n2 += this.getTabularCell(intVector.elementAt(n)).getGridCellAmount();
        }
        n = (this.getMaxX(intVector) - this.getMinX(intVector) + 1) * (this.getMaxY(intVector) - this.getMinY(intVector) + 1);
        return n2 == n;
    }

    public int merge(IntVector intVector) {
        return this.merge(intVector, true);
    }

    public int merge(IntVector intVector, boolean bl) {
        return this.merge(intVector, bl, true);
    }

    public int merge(IntVector intVector, boolean bl, boolean bl2) {
        if (this.isMergable(intVector)) {
            int n;
            int n2 = this.getMinX(intVector);
            TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(n2, n = this.getMinY(intVector), intVector));
            if (tabularCell != null) {
                for (int i = 0; i < intVector.size(); ++i) {
                    if (intVector.elementAt(i) == tabularCell.getAddress()) continue;
                    this.get(tabularCell, this.getTabularCell(intVector.elementAt(i)));
                    GridCell[] gridCellArray = this.remove(intVector.elementAt(i)).getGridCellArray();
                    for (int j = 0; j < gridCellArray.length; ++j) {
                        tabularCell.addGridCell(gridCellArray[j]);
                    }
                }
                if (bl) {
                    this.deleteGridColumn(bl2);
                }
                this.SEDU = tabularCell.getAddress();
                return tabularCell.getAddress();
            }
            return -1;
        }
        return -1;
    }

    public ArrayList getRowGroup() {
        ArrayList<IntVector> arrayList = new ArrayList<IntVector>();
        int n = this.getMaxX();
        int n2 = this.getMaxY();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = new IntVector();
        for (int i = 0; i <= n2; ++i) {
            for (int j = 0; j <= n; ++j) {
                int n3 = this.findTabularCellByCell(j, i, intVector);
                if (intVector2.indexOf(n3) != -1) continue;
                intVector2.addElement(n3);
            }
            if (!this.isMergable(intVector2)) continue;
            arrayList.add(intVector2);
            intVector2 = new IntVector();
        }
        return arrayList;
    }

    public ArrayList getColumnGroup() {
        ArrayList<IntVector> arrayList = new ArrayList<IntVector>();
        int n = this.getMaxX();
        int n2 = this.getMaxY();
        IntVector intVector = this.getTabularCells();
        IntVector intVector2 = new IntVector();
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                int n3 = this.findTabularCellByCell(i, j, intVector);
                if (intVector2.indexOf(n3) != -1) continue;
                intVector2.addElement(n3);
            }
            if (!this.isMergable(intVector2)) continue;
            arrayList.add(intVector2);
            intVector2 = new IntVector();
        }
        return arrayList;
    }

    public void moveColumnGroup(IntVector intVector, IntVector intVector2) {
        int n = this.getMinX(intVector);
        int n2 = this.getMaxX(intVector);
        int n3 = this.getMinX(intVector2);
        int n4 = this.getMaxX(intVector2);
        int n5 = this.getMaxY();
        IntVector intVector3 = new IntVector();
        if (n > n3) {
            int n6;
            int n7;
            intVector3.addElements(intVector2, false);
            for (n7 = 0; n7 <= n5; ++n7) {
                for (n6 = n4 + 1; n6 < n; ++n6) {
                    int n8 = this.findTabularCellByCell(n6, n7, this.getTabularCells());
                    if (intVector3.indexOf(n8) != -1) continue;
                    intVector3.addElement(n8);
                }
            }
            n7 = n - n3;
            for (n6 = 0; n6 < intVector.size(); ++n6) {
                this.getTabularCell(intVector.elementAt(n6)).decreaseAllGridOnX(n7);
            }
            n7 = n2 - n + 1;
            for (n6 = 0; n6 < intVector3.size(); ++n6) {
                this.getTabularCell(intVector3.elementAt(n6)).increaseAllGridOnX(n7);
            }
        } else {
            int n9;
            int n10;
            intVector3.addElements(intVector2, false);
            for (n10 = 0; n10 <= n5; ++n10) {
                for (n9 = n2 + 1; n9 < n3; ++n9) {
                    int n11 = this.findTabularCellByCell(n9, n10, this.getTabularCells());
                    if (intVector3.indexOf(n11) != -1) continue;
                    intVector3.addElement(n11);
                }
            }
            n10 = n4 - n2;
            for (n9 = 0; n9 < intVector.size(); ++n9) {
                this.getTabularCell(intVector.elementAt(n9)).increaseAllGridOnX(n10);
            }
            n10 = n2 - n + 1;
            for (n9 = 0; n9 < intVector3.size(); ++n9) {
                this.getTabularCell(intVector3.elementAt(n9)).decreaseAllGridOnX(n10);
            }
        }
    }

    public void moveRowGroup(IntVector intVector, IntVector intVector2) {
        int n = this.getMinY(intVector);
        int n2 = this.getMaxY(intVector);
        int n3 = this.getMinY(intVector2);
        int n4 = this.getMaxY(intVector2);
        int n5 = this.getMaxX();
        IntVector intVector3 = new IntVector();
        if (n > n3) {
            int n6;
            int n7;
            intVector3.addElements(intVector2, false);
            for (n7 = 0; n7 <= n5; ++n7) {
                for (n6 = n4 + 1; n6 < n; ++n6) {
                    int n8 = this.findTabularCellByCell(n7, n6, this.getTabularCells());
                    if (intVector3.indexOf(n8) != -1) continue;
                    intVector3.addElement(n8);
                }
            }
            n7 = n - n3;
            for (n6 = 0; n6 < intVector.size(); ++n6) {
                this.getTabularCell(intVector.elementAt(n6)).decreaseAllGridOnY(n7);
            }
            n7 = n2 - n + 1;
            for (n6 = 0; n6 < intVector3.size(); ++n6) {
                this.getTabularCell(intVector3.elementAt(n6)).increaseAllGridOnY(n7);
            }
        } else {
            int n9;
            int n10;
            for (n10 = 0; n10 <= n5; ++n10) {
                for (n9 = n2 + 1; n9 < n3; ++n9) {
                    int n11 = this.findTabularCellByCell(n10, n9, this.getTabularCells());
                    if (intVector3.indexOf(n11) != -1) continue;
                    intVector3.addElement(n11);
                }
            }
            n10 = n3 - n2 - 1;
            for (n9 = 0; n9 < intVector.size(); ++n9) {
                this.getTabularCell(intVector.elementAt(n9)).increaseAllGridOnY(n10);
            }
            n10 = n2 - n + 1;
            for (n9 = 0; n9 < intVector3.size(); ++n9) {
                this.getTabularCell(intVector3.elementAt(n9)).decreaseAllGridOnY(n10);
            }
        }
    }

    public int[] split(int n, int n2, int n3) {
        IntSet intSet = new IntSet();
        int[] nArray = this.decreaseAllGridOnY(n, n2).toArray();
        for (int i = 0; i < nArray.length; ++i) {
            intSet.addAll(this.delete(nArray[i], n3).toArray());
        }
        intSet.remove(n);
        return intSet.toArray();
    }

    public int[] split(int n, double[] dArray, double[] dArray2) {
        IntSet intSet = new IntSet();
        if (dArray != null) {
            intSet.addAll(this.cell(n, dArray, true, false));
        }
        int[] nArray = intSet.toArray();
        if (dArray2 != null) {
            int n2;
            int[] nArray2 = this.contain(n, dArray2, true, false);
            intSet.addAll(nArray2);
            int[] nArray3 = new int[nArray2.length + 1];
            int[] nArray4 = new int[nArray2.length + 1];
            TabularCell tabularCell = this.getTabularCell(n);
            nArray3[0] = tabularCell.getMinY();
            nArray4[0] = tabularCell.getMaxY();
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                tabularCell = this.getTabularCell(nArray2[n2]);
                nArray3[n2 + 1] = tabularCell.getMinY();
                nArray4[n2 + 1] = tabularCell.getMaxY();
            }
            for (n2 = 0; n2 < nArray.length; ++n2) {
                intSet.addAll(this.addTabularCells(nArray[n2], nArray3, nArray4));
            }
        }
        return intSet.toArray();
    }

    private int[] addTabularCells(int n, int[] nArray, int[] nArray2) {
        TabularCell tabularCell;
        IntSet intSet = new IntSet();
        TabularCell[] tabularCellArray = new TabularCell[nArray.length];
        tabularCellArray[0] = tabularCell = this.getTabularCell(n);
        GridCell[] gridCellArray = tabularCell.getGridCellArray();
        Hashtable hashtable = this.append(gridCellArray, nArray, nArray2);
        int n2 = tabularCell.getMinY();
        for (int n3 : nArray) {
            List list;
            if (n3 == n2 || (list = (List)hashtable.get(n3)) == null) continue;
            TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
            this.addTabularCell(tabularCell2);
            for (GridCell gridCell : list) {
                tabularCell.removeGridCell(gridCell);
                tabularCell2.addGridCell(gridCell);
            }
            intSet.add(tabularCell2.getAddress());
        }
        return intSet.toArray();
    }

    private int[] address(int n, int[] nArray, int[] nArray2) {
        TabularCell tabularCell;
        IntSet intSet = new IntSet();
        TabularCell[] tabularCellArray = new TabularCell[nArray.length];
        tabularCellArray[0] = tabularCell = this.getTabularCell(n);
        GridCell[] gridCellArray = tabularCell.getGridCellArray();
        Hashtable hashtable = this.borderlen(gridCellArray, nArray, nArray2);
        int n2 = tabularCell.getMinX();
        for (int n3 : nArray) {
            List list;
            if (n3 == n2 || (list = (List)hashtable.get(n3)) == null) continue;
            TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
            this.addTabularCell(tabularCell2);
            for (GridCell gridCell : list) {
                tabularCell.removeGridCell(gridCell);
                tabularCell2.addGridCell(gridCell);
            }
            intSet.add(tabularCell2.getAddress());
        }
        return intSet.toArray();
    }

    private Hashtable append(GridCell[] gridCellArray, int[] nArray, int[] nArray2) {
        Hashtable<Integer, ArrayList<GridCell>> hashtable = new Hashtable<Integer, ArrayList<GridCell>>();
        for (GridCell gridCell : gridCellArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > gridCell.y || gridCell.y > nArray2[i]) continue;
                ArrayList<GridCell> arrayList = (ArrayList<GridCell>)hashtable.get(nArray[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<GridCell>();
                    hashtable.put(nArray[i], arrayList);
                }
                arrayList.add(gridCell);
            }
        }
        return hashtable;
    }

    private Hashtable borderlen(GridCell[] gridCellArray, int[] nArray, int[] nArray2) {
        Hashtable<Integer, ArrayList<GridCell>> hashtable = new Hashtable<Integer, ArrayList<GridCell>>();
        for (GridCell gridCell : gridCellArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > gridCell.x || gridCell.x > nArray2[i]) continue;
                ArrayList<GridCell> arrayList = (ArrayList<GridCell>)hashtable.get(nArray[i]);
                if (arrayList == null) {
                    arrayList = new ArrayList<GridCell>();
                    hashtable.put(nArray[i], arrayList);
                }
                arrayList.add(gridCell);
            }
        }
        return hashtable;
    }

    private int[] cell(int n, double[] dArray, boolean bl, boolean bl2) {
        IntSet intSet = new IntSet();
        TabularCell tabularCell = this.getTabularCell(n);
        int n2 = tabularCell.getMinX();
        int n3 = tabularCell.getMaxX();
        Columns columns = this.getColumns();
        double d = columns.getGridColumnWidthBetween(n2, n3);
        double d2 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray != null) {
            for (double d3 : dArray) {
                if (d3 <= 0.0) continue;
                if ((d2 += d3) >= 1.0) break;
                arrayList.add(d * d3);
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        Double[] doubleArray = arrayList.toArray(new Double[0]);
        int n4 = n;
        int n5 = n2;
        Vector<GridColumn> vector = new Vector<GridColumn>();
        block1: for (int i = 0; i < doubleArray.length; ++i) {
            n4 = tabularCell.getAddress();
            n5 = tabularCell.getMinX();
            n3 = tabularCell.getMaxX();
            d5 = doubleArray[i];
            d4 = 0.0;
            for (int j = n5; j <= n3; ++j) {
                double d6 = columns.getGridColumnWidthAt(j);
                double d7 = (d4 += d6) - d5;
                if (bl2 && Math.abs(d7) <= (double)append) {
                    d5 = d4;
                    if (i < doubleArray.length - 1) {
                        doubleArray[i + 1] = doubleArray[i + 1] + d7;
                    }
                }
                if (d4 < d5) continue;
                if (d4 == d5) {
                    tabularCell = this.changeTotalHeight(n4, j);
                    if (tabularCell == null) continue block1;
                    intSet.add(tabularCell.getAddress());
                    continue block1;
                }
                this.changeTotalWidth(j, (d6 - d7) / d6, false);
                tabularCell = this.changeTotalHeight(n4, j);
                GridColumn gridColumn = columns.getGridColumn(j);
                if (!vector.contains(gridColumn)) {
                    vector.add(gridColumn);
                }
                if (!vector.contains(gridColumn = columns.getGridColumn(j + 1))) {
                    vector.add(gridColumn);
                }
                if (tabularCell == null) continue block1;
                intSet.add(tabularCell.getAddress());
                continue block1;
            }
        }
        if (bl) {
            Vector<Integer> vector2 = new Vector<Integer>();
            for (GridColumn gridColumn : vector) {
                vector2.add(this.addGridCell.indexOf(gridColumn));
            }
            this.clear(vector2);
        }
        return intSet.toArray();
    }

    private TabularCell changeTotalHeight(int n, int n2) {
        int n3 = this.getMaxX(n);
        int n4 = this.getMinX(n);
        if (n2 < n4 || n2 >= n3) {
            return null;
        }
        TabularCell tabularCell = this.getTabularCell(n);
        TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
        GridCell[] gridCellArray = tabularCell.getGridCellArray();
        for (int i = 0; i < gridCellArray.length; ++i) {
            if (gridCellArray[i].x < n2 + 1) continue;
            tabularCell.removeGridCell(gridCellArray[i]);
            tabularCell2.addGridCell(gridCellArray[i]);
        }
        this.addTabularCell(tabularCell2);
        return tabularCell2;
    }

    private GridColumn changeTotalWidth(int n, double d, boolean bl) {
        if (d == 0.0 || d >= 1.0) {
            return null;
        }
        Columns columns = this.getColumns();
        GridColumn gridColumn = columns.getGridColumn(n);
        double d2 = gridColumn.getDoubleWidth();
        double d3 = d2 * d;
        double d4 = d2 - d3;
        this.getColumnNum(n, false);
        if (bl) {
            if (d3 < 600.0) {
                d3 = 600.0;
            }
            gridColumn.setDoubleWidth(d3);
            gridColumn = columns.getGridColumn(n + 1);
            if (d4 < 600.0) {
                d4 = 600.0;
            }
            gridColumn.setDoubleWidth(d4);
        } else {
            gridColumn.setDoubleWidth(d3);
            gridColumn = columns.getGridColumn(n + 1);
            gridColumn.setDoubleWidth(d4);
        }
        return gridColumn;
    }

    private void clear(List list) {
        Hashtable hashtable = this.decreaseAllGridOnX(list, true);
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            List list2 = (List)hashtable.get(n);
            for (TabularCell tabularCell : list2) {
                int n2 = this.getTabularCellWidth(tabularCell.getAddress());
                if (n2 >= 600) continue;
                int n3 = this.getMinX(tabularCell.getAddress());
                int n4 = this.getMaxX(tabularCell.getAddress());
                GridColumn gridColumn = this.addGridCell.getGridColumn(n4);
                double d = 600 - this.addGridCell.getGridColumnWidthBetween(n3, n4 - 1);
                gridColumn.setDoubleWidth(d);
                continue block0;
            }
        }
    }

    private int[] contain(int n, double[] dArray, boolean bl, boolean bl2) {
        IntSet intSet = new IntSet();
        TabularCell tabularCell = this.getTabularCell(n);
        int n2 = tabularCell.getMinY();
        int n3 = tabularCell.getMaxY();
        Rows rows = this.getRows();
        double d = rows.getGridRowHeightBetween(n2, n3);
        double d2 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (dArray != null) {
            for (double d3 : dArray) {
                if (d3 <= 0.0) continue;
                if ((d2 += d3) >= 1.0) break;
                arrayList.add(d * d3);
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        Double[] doubleArray = arrayList.toArray(new Double[0]);
        int n4 = n;
        int n5 = n2;
        Vector<GridRow> vector = new Vector<GridRow>();
        block1: for (int i = 0; i < doubleArray.length; ++i) {
            n4 = tabularCell.getAddress();
            n5 = tabularCell.getMinY();
            n3 = tabularCell.getMaxY();
            d5 = doubleArray[i];
            d4 = 0.0;
            for (int j = n5; j <= n3; ++j) {
                double d6 = rows.getGridRowHeightAt(j);
                double d7 = (d4 += d6) - d5;
                if (bl2 && Math.abs(d7) <= (double)append) {
                    d5 = d4;
                    if (i < doubleArray.length - 1) {
                        doubleArray[i + 1] = doubleArray[i + 1] + d7;
                    }
                }
                if (d4 < d5) continue;
                if (d4 == d5) {
                    tabularCell = this.containGridCell(n4, j);
                    if (tabularCell == null) continue block1;
                    intSet.add(tabularCell.getAddress());
                    continue block1;
                }
                this.contains(j, (d6 - d7) / d6, false);
                tabularCell = this.containGridCell(n4, j);
                GridRow gridRow = rows.getGridRow(j);
                if (!vector.contains(gridRow)) {
                    vector.add(gridRow);
                }
                if (!vector.contains(gridRow = rows.getGridRow(j + 1))) {
                    vector.add(gridRow);
                }
                if (tabularCell == null) continue block1;
                intSet.add(tabularCell.getAddress());
                continue block1;
            }
        }
        if (bl) {
            Vector<Integer> vector2 = new Vector<Integer>();
            for (GridRow gridRow : vector) {
                vector2.add(rows.indexOf(gridRow));
            }
            this.containsKey(vector2);
        }
        return intSet.toArray();
    }

    private TabularCell containGridCell(int n, int n2) {
        int n3 = this.getMaxY(n);
        int n4 = this.getMinY(n);
        if (n2 < n4 || n2 >= n3) {
            return null;
        }
        TabularCell tabularCell = this.getTabularCell(n);
        TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
        GridCell[] gridCellArray = tabularCell.getGridCellArray();
        for (int i = 0; i < gridCellArray.length; ++i) {
            if (gridCellArray[i].y < n2 + 1) continue;
            tabularCell.removeGridCell(gridCellArray[i]);
            tabularCell2.addGridCell(gridCellArray[i]);
        }
        this.addTabularCell(tabularCell2);
        return tabularCell2;
    }

    private GridRow contains(int n, double d, boolean bl) {
        if (d == 0.0 || d >= 1.0) {
            return null;
        }
        Rows rows = this.getRows();
        GridRow gridRow = rows.getGridRow(n);
        double d2 = gridRow.getDoubleHeight();
        double d3 = d2 * d;
        double d4 = d2 - d3;
        this.getCrossTabularCells(n, false);
        if (bl) {
            if (d3 < 600.0) {
                d3 = 600.0;
            }
            gridRow.setDoubleHeight(d3);
            gridRow = rows.getGridRow(n + 1);
            if (d4 < 600.0) {
                d4 = 600.0;
            }
            gridRow.setDoubleHeight(d4);
        } else {
            gridRow.setDoubleHeight(d3);
            gridRow = rows.getGridRow(n + 1);
            gridRow.setDoubleHeight(d4);
        }
        return gridRow;
    }

    private void containsKey(Vector vector) {
        Hashtable hashtable = this.decreaseAllGridOnX(vector, false);
        Iterator iterator = vector.iterator();
        block0: while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            List list = (List)hashtable.get(n);
            for (TabularCell tabularCell : list) {
                int n2 = this.getTabularCellHeight(tabularCell.getAddress());
                if (n2 >= 600) continue;
                int n3 = this.getMinY(tabularCell.getAddress());
                int n4 = this.getMaxY(tabularCell.getAddress());
                GridRow gridRow = this.addElements.getGridRow(n4);
                double d = 600 - this.addElements.getGridRowHeightBetween(n3, n4 - 1);
                gridRow.setDoubleHeight(d);
                continue block0;
            }
        }
    }

    private Hashtable decreaseAllGridOnX(List list, boolean bl) {
        Hashtable<Integer, ArrayList<TabularCell>> hashtable = new Hashtable<Integer, ArrayList<TabularCell>>();
        IntVector intVector = this.getTabularCells();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (int i = 0; i < intVector.size(); ++i) {
                int n2;
                int n3;
                int n4 = intVector.elementAt(i);
                TabularCell tabularCell = this.getTabularCell(n4);
                if (bl) {
                    n3 = this.getMinX(n4);
                    n2 = this.getMaxX(n4);
                } else {
                    n3 = this.getMinY(n4);
                    n2 = this.getMaxY(n4);
                }
                if (n < n3 || n > n2) continue;
                ArrayList<TabularCell> arrayList = (ArrayList<TabularCell>)hashtable.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<TabularCell>();
                    hashtable.put(n, arrayList);
                }
                arrayList.add(tabularCell);
            }
        }
        return hashtable;
    }

    private IntSet decreaseAllGridOnY(int n, int n2) {
        IntSet intSet = new IntSet();
        intSet.add(n);
        TabularCell tabularCell = this.getTabularCell(n);
        while (n2 > 1) {
            int n3;
            int n4 = this.getMaxY(n);
            int n5 = this.getMinY(n);
            TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            if (n4 - n5 != 0) {
                for (n3 = 0; n3 < gridCellArray.length; ++n3) {
                    if (gridCellArray[n3].y != n4) continue;
                    tabularCell.removeGridCell(gridCellArray[n3]);
                    tabularCell2.addGridCell(gridCellArray[n3]);
                }
            } else {
                this.addElements.addKeepTotalHeight(n4 + 1, this.getTabulaHeight() / this.addElements.size() + 1);
                this.generateTtree(false, n4 + 1, 1);
                for (n3 = 0; n3 <= this.getMaxX(); ++n3) {
                    int n6 = this.findTabularCellByCell(n3, n4, this.getTabularCells());
                    if (n6 != n) {
                        this.getTabularCell(n6).addGridCell(new GridCell(n3, n4 + 1));
                        continue;
                    }
                    tabularCell2.addGridCell(new GridCell(n3, n4 + 1));
                }
            }
            this.addTabularCell(tabularCell2);
            intSet.add(tabularCell2.getAddress());
            --n2;
        }
        return intSet;
    }

    private IntSet delete(int n, int n2) {
        IntSet intSet = new IntSet();
        intSet.add(n);
        TabularCell tabularCell = this.getTabularCell(n);
        while (n2 > 1) {
            int n3;
            int n4 = this.getMaxX(n);
            int n5 = this.getMinX(n);
            TabularCell tabularCell2 = new TabularCell(this.addElement.generateAddress());
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            if (n4 - n5 != 0) {
                for (n3 = 0; n3 < gridCellArray.length; ++n3) {
                    if (gridCellArray[n3].x != n4) continue;
                    tabularCell.removeGridCell(gridCellArray[n3]);
                    tabularCell2.addGridCell(gridCellArray[n3]);
                }
            } else {
                this.addGridCell.addKeepTotalWidth(n4 + 1, this.getTabularWidth() / this.addGridCell.size() + 1);
                this.generateTtree(true, n4 + 1, 1);
                for (n3 = 0; n3 <= this.getMaxY(); ++n3) {
                    int n6 = this.findTabularCellByCell(n4, n3, this.getTabularCells());
                    if (n6 != n) {
                        this.getTabularCell(n6).addGridCell(new GridCell(n4 + 1, n3));
                        continue;
                    }
                    tabularCell2.addGridCell(new GridCell(n4 + 1, n3));
                }
            }
            this.addTabularCell(tabularCell2);
            intSet.add(tabularCell2.getAddress());
            --n2;
        }
        return intSet;
    }

    private void deleteGridColumn(boolean bl) {
        this.deleteGridRow(true, bl);
        this.deleteGridRow(false, bl);
    }

    private void deleteGridRow(boolean bl, boolean bl2) {
        int n = this.deleteKeepTotalHeight(bl);
        if (n != -1) {
            this.findTabularCellByCell(bl, n, bl2);
            this.deleteGridRow(bl, bl2);
        }
    }

    private int deleteKeepTotalHeight(boolean bl) {
        int n = this.getMaxY();
        int n2 = this.getMaxX();
        IntSet intSet = new IntSet();
        if (bl) {
            for (int i = 0; i <= n2; ++i) {
                intSet.clear();
                for (int j = 0; j <= n; ++j) {
                    TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(i, j, this.getTabularCells()));
                    intSet.add(tabularCell.getAddress());
                }
                if (!this.deleteKeepTotalWidth(bl, intSet)) continue;
                return i;
            }
        } else {
            for (int i = 0; i <= n; ++i) {
                intSet.clear();
                for (int j = 0; j <= n2; ++j) {
                    TabularCell tabularCell = this.getTabularCell(this.findTabularCellByCell(j, i, this.getTabularCells()));
                    intSet.add(tabularCell.getAddress());
                }
                if (!this.deleteKeepTotalWidth(bl, intSet)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean deleteKeepTotalWidth(boolean bl, IntSet intSet) {
        int n;
        int[] nArray = intSet.toArray();
        for (n = 0; n < nArray.length; ++n) {
            if (!(bl ? this.getMaxX(nArray[n]) - this.getMinX(nArray[n]) == 0 : this.getMaxY(nArray[n]) - this.getMinY(nArray[n]) == 0)) continue;
            return false;
        }
        n = this.doubleValue(intSet, bl);
        return n > 1;
    }

    private int doubleValue(IntSet intSet, boolean bl) {
        int[] nArray = intSet.toArray();
        IntSet intSet2 = null;
        IntSet intSet3 = null;
        if (bl) {
            intSet2 = this.elementAt(this.getMinX(nArray[0]), this.getMaxX(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                intSet3 = this.elementAt(this.getMinX(nArray[i]), this.getMaxX(nArray[i]));
                intSet2.retainAll(intSet3.toArray());
            }
        } else {
            intSet2 = this.elementAt(this.getMinY(nArray[0]), this.getMaxY(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                intSet3 = this.elementAt(this.getMinY(nArray[i]), this.getMaxY(nArray[i]));
                intSet2.retainAll(intSet3.toArray());
            }
        }
        return intSet2.size();
    }

    private IntSet elementAt(int n, int n2) {
        IntSet intSet = new IntSet(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            intSet.add(i);
        }
        return intSet;
    }

    private void findTabularCellByCell(boolean bl, int n, boolean bl2) {
        Object object;
        int n2;
        IntVector intVector = this.getTabularCells();
        for (n2 = 0; n2 < intVector.size(); ++n2) {
            object = this.getTabularCell(intVector.elementAt(n2));
            if (bl) {
                ((TabularCell)object).removeGridCellX(n);
                continue;
            }
            ((TabularCell)object).removeGridCellY(n);
        }
        if (bl) {
            if (bl2) {
                this.addGridCell.deleteKeepTotalWidth(n);
            } else {
                n2 = this.addGridCell.getGridColumn(n).getWidth();
                object = this.addGridCell.getGridColumn(n + 1);
                ((GridColumn)object).setWidth(((GridColumn)object).getWidth() + n2);
                this.addGridCell.delete(n);
            }
            this.generateAddress(bl, n + 1, 1);
        } else {
            if (bl2) {
                this.addElements.deleteKeepTotalHeight(n);
            } else {
                n2 = this.addElements.getGridRow(n).getHeight();
                object = this.addElements.getGridRow(n + 1);
                ((GridRow)object).setHeight(((GridRow)object).getHeight() + n2);
                this.addElements.delete(n);
            }
            this.generateAddress(bl, n + 1, 1);
        }
    }

    private void generateAddress(boolean bl, int n, int n2) {
        IntVector intVector = this.getTabularCells();
        for (int i = 0; i < intVector.size(); ++i) {
            TabularCell tabularCell = this.getTabularCell(intVector.elementAt(i));
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            for (int j = 0; j < gridCellArray.length; ++j) {
                if (bl) {
                    if (gridCellArray[j].x < n) continue;
                    gridCellArray[j].x -= n2;
                    continue;
                }
                if (gridCellArray[j].y < n) continue;
                gridCellArray[j].y -= n2;
            }
        }
    }

    private void generateTtree(boolean bl, int n, int n2) {
        IntVector intVector = this.getTabularCells();
        for (int i = 0; i < intVector.size(); ++i) {
            TabularCell tabularCell = this.getTabularCell(intVector.elementAt(i));
            GridCell[] gridCellArray = tabularCell.getGridCellArray();
            for (int j = 0; j < gridCellArray.length; ++j) {
                if (bl) {
                    if (gridCellArray[j].x < n) continue;
                    gridCellArray[j].x += n2;
                    continue;
                }
                if (gridCellArray[j].y < n) continue;
                gridCellArray[j].y += n2;
            }
        }
    }

    private void get(TabularCell tabularCell, TabularCell tabularCell2) {
        tabularCell.getSons().addAll(tabularCell2.getSons());
        tabularCell2.getSons().removeAllElements();
    }

    public int[] getCrossTabularCells(boolean bl, int n) {
        int n2 = 0;
        IntVector intVector = this.getTabularCells();
        IntSet intSet = new IntSet();
        if (bl) {
            for (int i = 0; i < this.addElements.size(); ++i) {
                n2 = this.findTabularCellByCell(n, i, intVector);
                intSet.add(n2);
            }
        } else {
            for (int i = 0; i < this.addGridCell.size(); ++i) {
                n2 = this.findTabularCellByCell(i, n, intVector);
                intSet.add(n2);
            }
        }
        return intSet.toArray();
    }

    public Rows getRows() {
        return this.addElements;
    }

    public Columns getColumns() {
        return this.addGridCell;
    }

    public int[] insertColumn(int n, boolean bl) {
        return this.insertColumn(n, bl, true);
    }

    public int[] insertColumn(int n, boolean bl, boolean bl2) {
        int n2 = bl ? this.getMinX(n) : this.getMaxX(n);
        return this.getAddress(n2, bl, bl2);
    }

    public int[] insertGridColumn(int n, boolean bl) {
        return this.getAddress(n, bl, true);
    }

    private int[] getAddress(int n, boolean bl, boolean bl2) {
        IntSet intSet = new IntSet();
        int n2 = n;
        int[] nArray = this.getCrossTabularCells(true, n2);
        if (!bl) {
            ++n2;
        }
        if (bl2) {
            this.addGridCell.addKeepTotalWidth(n2, this.getTabularWidth() / this.addGridCell.size() + 1);
        } else {
            this.addGridCell.add(n2, 9000);
        }
        this.generateTtree(true, n2, 1);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n4 = this.getMinY(n3);
            int n5 = this.getMaxY(n3);
            int n6 = this.getMinX(n3);
            int n7 = this.getMaxX(n3);
            if (n6 < n2 && n2 < n7) {
                for (int j = n4; j <= n5; ++j) {
                    this.getTabularCell(n3).addGridCell(new GridCell(n2, j));
                }
                continue;
            }
            TabularCell tabularCell = new TabularCell(this.addElement.generateAddress());
            for (int j = n4; j <= n5; ++j) {
                tabularCell.addGridCell(new GridCell(n2, j));
                this.addTabularCell(tabularCell);
                intSet.add(tabularCell.getAddress());
            }
        }
        return intSet.toArray();
    }

    private void getColumnNum(int n, boolean bl) {
        int n2 = n;
        if (!bl) {
            ++n2;
        }
        int[] nArray = this.getCrossTabularCells(true, n);
        this.addGridCell.add(n2, 9000);
        this.generateTtree(true, n2, 1);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n4 = this.getMinY(n3);
            int n5 = this.getMaxY(n3);
            for (int j = n4; j <= n5; ++j) {
                this.getTabularCell(n3).addGridCell(new GridCell(n2, j));
            }
        }
    }

    public int[] insertRow(int n, boolean bl) {
        return this.insertRow(n, bl, true);
    }

    public int[] insertRow(int n, boolean bl, boolean bl2) {
        int n2 = bl ? this.getMinY(n) : this.getMaxY(n);
        return this.getColumns(n2, bl, bl2);
    }

    public int[] insertGridRow(int n, boolean bl) {
        return this.getColumns(n, bl, true);
    }

    private int[] getColumns(int n, boolean bl, boolean bl2) {
        IntSet intSet = new IntSet();
        int n2 = n;
        int[] nArray = this.getCrossTabularCells(false, n2);
        if (!bl) {
            ++n2;
        }
        if (bl2) {
            this.addElements.addKeepTotalHeight(n2, this.getTabulaHeight() / (this.addElements.size() + 1));
        } else {
            this.addElements.add(n2, 9000);
        }
        this.generateTtree(false, n2, 1);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n4 = this.getMinX(n3);
            int n5 = this.getMaxX(n3);
            int n6 = this.getMinY(n3);
            int n7 = this.getMaxY(n3);
            if (n6 < n2 && n2 < n7) {
                for (int j = n4; j <= n5; ++j) {
                    this.getTabularCell(n3).addGridCell(new GridCell(j, n2));
                }
                continue;
            }
            TabularCell tabularCell = new TabularCell(this.addElement.generateAddress());
            for (int j = n4; j <= n5; ++j) {
                tabularCell.addGridCell(new GridCell(j, n2));
                this.addTabularCell(tabularCell);
                intSet.add(tabularCell.getAddress());
            }
        }
        return intSet.toArray();
    }

    private void getCrossTabularCells(int n, boolean bl) {
        IntSet intSet = new IntSet();
        int n2 = n;
        if (!bl) {
            ++n2;
        }
        int[] nArray = this.getCrossTabularCells(false, n);
        this.addElements.add(n2, 9000);
        this.generateTtree(false, n2, 1);
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 = nArray[i];
            int n4 = this.getMinX(n3);
            int n5 = this.getMaxX(n3);
            for (int j = n4; j <= n5; ++j) {
                this.getTabularCell(n3).addGridCell(new GridCell(j, n2));
            }
        }
    }

    public void appandRow() {
        int n = this.getMaxY();
        this.addElements.addKeepTotalHeight(-1, this.getTabulaHeight() / this.addElements.size() + 1);
        ++n;
        for (int i = 0; i <= this.getMaxX(); ++i) {
            TabularCell tabularCell = new TabularCell(this.addElement.generateAddress());
            tabularCell.addGridCell(new GridCell(i, n));
            this.addTabularCell(tabularCell);
        }
    }

    public void appandColumn() {
        int n = this.getMaxX();
        this.addGridCell.addKeepTotalWidth(-1, this.getTabularWidth() / this.addGridCell.size() + 1);
        ++n;
        for (int i = 0; i <= this.getMaxY(); ++i) {
            TabularCell tabularCell = new TabularCell(this.addElement.generateAddress());
            tabularCell.addGridCell(new GridCell(n, i));
            this.addTabularCell(tabularCell);
        }
    }

    public void deleteColumn(int n) {
        int n2 = this.getMinX(n);
        this.deleteGridColumn(n2);
    }

    public void deleteRow(int n) {
        int n2 = this.getMinY(n);
        this.deleteGridRow(n2);
    }

    public void deleteColumnGroup(IntVector intVector) {
        int n;
        int n2 = this.getMinX(intVector);
        for (int i = n = this.getMaxX(intVector); i >= n2; --i) {
            this.deleteGridColumn(i);
        }
    }

    public void deleteRowGroup(IntVector intVector) {
        int n;
        int n2 = this.getMinY(intVector);
        for (int i = n = this.getMaxY(intVector); i >= n2; --i) {
            this.deleteGridRow(i);
        }
    }

    public void deleteGridRow(int n) {
        if (this.getRowNum() == 1) {
            return;
        }
        int n2 = n;
        this.addElements.deleteKeepTotalHeight(n2);
        int[] nArray = this.getCrossTabularCells(false, n2);
        for (int i = 0; i < nArray.length; ++i) {
            TabularCell tabularCell = this.getTabularCell(nArray[i]);
            tabularCell.removeGridCellY(n2);
            if (tabularCell.getGridCellAmount() != 0) continue;
            this.remove(nArray[i]);
        }
        this.generateAddress(false, n2, 1);
    }

    public void deleteGridColumn(int n) {
        if (this.getColumnNum() == 1) {
            return;
        }
        int n2 = n;
        this.addGridCell.deleteKeepTotalWidth(n2);
        int[] nArray = this.getCrossTabularCells(true, n2);
        for (int i = 0; i < nArray.length; ++i) {
            TabularCell tabularCell = this.getTabularCell(nArray[i]);
            tabularCell.removeGridCellX(n2);
            if (tabularCell.getGridCellAmount() != 0) continue;
            this.remove(nArray[i]);
        }
        this.generateAddress(true, n2, 1);
    }

    public int getBottomBorder() {
        return this.addKeepTotalWidth;
    }

    public void setBottomBorder(int n) {
        this.addKeepTotalWidth = n;
        this.changeTotalHeight(-n);
    }

    public int getLeftBorder() {
        return this.addTabularCell;
    }

    public void setLeftBorder(int n) {
        this.addTabularCell = n;
        this.changeTotalWidth(-n);
    }

    public int getRightBorder() {
        return this.addTabularCells;
    }

    public void setRightBorder(int n) {
        this.addTabularCells = n;
        this.changeTotalWidth(-n);
    }

    public int getTopBorder() {
        return this.addKeepTotalHeight;
    }

    public void setTopBorder(int n) {
        this.addKeepTotalHeight = n;
        this.changeTotalHeight(-n);
    }

    public String toString() {
        TabularTree tabularTree = this.generateTtree();
        String string = "row :: " + this.getRowNum() + "    column :: " + this.getColumnNum() + "\n";
        for (int i = 0; i < tabularTree.getRowSize(); ++i) {
            IntVector intVector = tabularTree.getRow(i);
            for (int j = 0; j < intVector.size(); ++j) {
                string = string + this.getTabularCell(intVector.elementAt(j)).toString();
                string = string + "(w = " + this.getTabularCellWidth(intVector.elementAt(j)) + " ,h = " + this.getTabularCellHeight(intVector.elementAt(j)) + ")";
                string = string + " -- ";
            }
            string = string + "\n";
        }
        return string;
    }

    private class TabularCellInfo {
        TabularCell cell = null;
        int borderlen = 0;

        private TabularCellInfo() {
        }
    }
}

