/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.service;

import com.jinfonet.resstore.ResourceStore;
import java.util.LinkedList;
import java.util.Vector;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.ActionResultInfo;
import jet.reportLogic.action.Creatable;
import jet.reportLogic.builder.ActionBuilder;
import jet.reportLogic.service.ActionTool;

public class ActionManager {
    protected Queue undoStack;
    protected Queue redoStack;
    private ResourceStore SEDU = null;
    private Vector access$000 = null;

    public ActionManager(int n) {
        this.undoStack = new Queue(n);
        this.redoStack = new Queue(n);
    }

    public ActionManager(int n, int n2) {
        this.undoStack = new Queue(n);
        this.redoStack = new Queue(n2);
    }

    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    public boolean canRedo() {
        return !this.redoStack.empty();
    }

    public boolean isUndoableAction(Action action) {
        return action.isUndoable();
    }

    public boolean isRedoableAction(Action action) {
        return action.isRedoable();
    }

    public Vector doAction(Action action) {
        Vector vector = action.doAction(this.SEDU());
        Vector<Action> vector2 = new Vector<Action>();
        vector2.add(action);
        if (action.isUndoable()) {
            this.undoStack.push(vector2);
            this.redoStack.clear();
        }
        this.access$000 = vector2;
        return vector;
    }

    public Vector doActionForRstInfo(Action action) {
        this.doAction(action);
        return action.getActionResultInfo();
    }

    public Vector doAction(Vector vector) {
        if (this.undoStack.contains(vector)) {
            vector = (Vector)vector.clone();
        }
        Vector vector2 = new Vector();
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector3 = ((Action)vector.get(i)).doAction(this.SEDU());
            if (!((Action)vector.get(i)).isUndoable()) {
                bl = false;
            }
            for (int j = 0; j < vector3.size(); ++j) {
                if (vector2.contains(vector3.get(j))) continue;
                vector2.add(vector3.get(j));
            }
        }
        if (bl) {
            this.undoStack.push(vector);
            this.redoStack.clear();
        }
        this.access$000 = vector;
        return vector2;
    }

    public Vector doActionForRstInfo(Vector vector) {
        if (this.undoStack.contains(vector)) {
            vector = (Vector)vector.clone();
        }
        Vector vector2 = new Vector();
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            ((Action)vector.get(i)).doAction(this.SEDU());
            Vector vector3 = ((Action)vector.get(i)).getActionResultInfo();
            if (!((Action)vector.get(i)).isUndoable()) {
                bl = false;
            }
            for (int j = 0; j < vector3.size(); ++j) {
                ActionTool.mergeResultInfo(vector2, (ActionResultInfo)vector3.get(j));
            }
        }
        if (bl) {
            this.undoStack.push(vector);
            this.redoStack.clear();
        }
        this.access$000 = vector;
        return vector2;
    }

    public Vector appendActionForRstInfo(Action action) {
        this.appendAction(action);
        return action.getActionResultInfo();
    }

    public Vector appendAction(Action action) {
        if (this.access$000 == null) {
            return this.doAction(action);
        }
        Vector vector = action.doAction(this.SEDU());
        this.access$000.add(action);
        if (!action.isUndoable() && this.undoStack.contains(this.access$000)) {
            this.undoStack.remove(this.access$000);
        }
        return vector;
    }

    public Vector doSerialActions(Vector vector) {
        Vector<Action> vector2 = new Vector<Action>();
        Vector vector3 = new Vector();
        boolean bl = true;
        for (int i = 0; i < vector.size(); ++i) {
            ActionBuilder actionBuilder = (ActionBuilder)vector.get(i);
            Action action = actionBuilder.build();
            if (action.getAtomicActionCount() <= 0) continue;
            Vector vector4 = action.doAction(this.SEDU());
            vector2.add(action);
            if (!action.isUndoable()) {
                bl = false;
            }
            for (int j = 0; j < vector4.size(); ++j) {
                if (vector3.contains(vector4.get(j))) continue;
                vector3.add(vector4.get(j));
            }
        }
        if (bl) {
            this.undoStack.push(vector2);
            this.redoStack.clear();
        }
        return vector3;
    }

    public Object doCreatingAction(Action action) {
        if (action.getAtomicAction(0) instanceof Creatable) {
            ((Creatable)((Object)action.getAtomicAction(0))).create();
            return ((Creatable)((Object)action.getAtomicAction(0))).getCreation();
        }
        return null;
    }

    public Vector undoAction() {
        this.access$000 = null;
        if (this.canUndo()) {
            Vector vector = null;
            Object object = this.undoStack.pop();
            if (object instanceof Action) {
                vector = ((Action)object).undo(this.SEDU());
                if (((Action)object).isRedoable()) {
                    this.redoStack.push(object);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                for (int i = vector2.size() - 1; i >= 0; --i) {
                    object = (Action)vector2.get(i);
                    if (!((Action)object).isUndoable()) continue;
                    Vector vector3 = ((Action)object).undo(this.SEDU());
                    if (!((Action)vector2.get(i)).isRedoable()) {
                        bl = false;
                    }
                    for (int j = 0; j < vector3.size(); ++j) {
                        if (vector.contains(vector3.get(j))) continue;
                        vector.add(vector3.get(j));
                    }
                }
                if (bl) {
                    this.redoStack.push(vector2);
                }
            }
            return vector;
        }
        return null;
    }

    public Vector redoAction() {
        if (this.canRedo()) {
            Vector vector = null;
            Object object = this.redoStack.pop();
            if (object instanceof Action) {
                vector = ((Action)object).redo(this.SEDU());
                if (((Action)object).isUndoable()) {
                    this.undoStack.push(object);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                for (int i = 0; i < vector2.size(); ++i) {
                    object = (Action)vector2.get(i);
                    if (!((Action)object).isRedoable()) continue;
                    Vector vector3 = ((Action)object).redo(this.SEDU());
                    if (!((Action)vector2.get(i)).isUndoable()) {
                        bl = false;
                    }
                    for (int j = 0; j < vector3.size(); ++j) {
                        if (vector.contains(vector3.get(j))) continue;
                        vector.add(vector3.get(j));
                    }
                }
                if (bl) {
                    this.undoStack.push(vector2);
                }
            }
            return vector;
        }
        return null;
    }

    public void clearStack() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public int getStackSize() {
        return this.undoStack.SEDU;
    }

    public void registActionGroup() {
        this.access$000 = null;
    }

    private ResourceStore SEDU() {
        return this.SEDU;
    }

    public void setResourceStore(ResourceStore resourceStore) {
        this.SEDU = resourceStore;
    }

    class Queue
    extends LinkedList {
        private int SEDU = 0;
        private int clear = 0;

        Queue(int n) {
            this.SEDU = n;
        }

        int getCurrentPos() {
            return this.clear;
        }

        boolean empty() {
            return this.clear == 0;
        }

        @Override
        public void clear() {
            super.clear();
            this.clear = 0;
        }

        @Override
        public void push(Object object) {
            if (this.clear < this.SEDU) {
                this.add(object);
                ++this.clear;
            } else {
                Object e = this.removeFirst();
                if (e instanceof Action) {
                    ((Action)e).destroy();
                }
                this.add(object);
            }
        }

        @Override
        public Object pop() {
            if (this.clear > 0) {
                return this.remove(--this.clear);
            }
            return null;
        }
    }
}

