/*
 * Decompiled with CFR 0.152.
 */
package jet.reportLogic.service;

import java.util.Vector;
import jet.reportLogic.action.Action;
import jet.reportLogic.action.ActionResultInfo;
import jet.reportLogic.service.ActionContext;
import jet.reportLogic.service.ActionManager;
import jet.reportLogic.service.ActionTool;
import jet.rptservice.api.infocenter.IReportViewCenter;

public class ActionManagerForService
extends ActionManager {
    private ActionManager.Queue SEDU;
    private ActionManager.Queue appendActionForRstInfo;

    public ActionManagerForService(int n) {
        super(n);
        this.SEDU = new ActionManager.Queue(n);
        this.appendActionForRstInfo = new ActionManager.Queue(n);
    }

    public ActionManagerForService(int n, int n2) {
        super(n, n2);
        this.SEDU = new ActionManager.Queue(n);
        this.appendActionForRstInfo = new ActionManager.Queue(n2);
    }

    public Vector doAction(Action action, IReportViewCenter iReportViewCenter) {
        Vector vector = super.doAction(action);
        if (action.isUndoable()) {
            this.SEDU.push(this.SEDU(iReportViewCenter));
            this.appendActionForRstInfo.clear();
        }
        return vector;
    }

    public Vector doAction(Vector vector, IReportViewCenter iReportViewCenter) {
        Vector vector2 = super.doAction(vector);
        if (this.undoStack.contains(vector)) {
            this.SEDU.push(this.SEDU(iReportViewCenter));
            this.appendActionForRstInfo.clear();
        }
        return vector2;
    }

    public Vector doActionForRstInfo(Action action, IReportViewCenter iReportViewCenter) {
        this.doAction(action, iReportViewCenter);
        return action.getActionResultInfo();
    }

    public Vector doActionForRstInfo(Vector vector, IReportViewCenter iReportViewCenter) {
        this.doAction(vector, iReportViewCenter);
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Action action = (Action)vector.get(i);
            Vector vector3 = action.getActionResultInfo();
            for (int j = 0; j < vector3.size(); ++j) {
                ActionTool.mergeResultInfo(vector2, (ActionResultInfo)vector3.get(j));
            }
        }
        return vector2;
    }

    public Vector appendActionForRstInfo(Action action, IReportViewCenter iReportViewCenter) {
        Vector vector = this.appendActionForRstInfo(action);
        if (this.undoStack.getCurrentPos() > this.SEDU.getCurrentPos()) {
            this.SEDU.push(this.SEDU(iReportViewCenter));
            this.appendActionForRstInfo.clear();
        } else if (this.undoStack.getCurrentPos() < this.SEDU.getCurrentPos()) {
            this.SEDU.remove(this.appendActionForRstInfo.getCurrentPos() - 1);
        }
        return vector;
    }

    public Vector undoActionForRstInfo() {
        if (this.canUndo()) {
            Vector vector = null;
            Object object = this.undoStack.pop();
            ActionContext actionContext = (ActionContext)this.SEDU.pop();
            if (object instanceof Action) {
                ((Action)object).undo();
                vector = ((Action)object).getActionResultInfo();
                if (((Action)object).isRedoable()) {
                    this.redoStack.push(object);
                    this.appendActionForRstInfo.push(actionContext);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                for (int i = vector2.size() - 1; i >= 0; --i) {
                    object = (Action)vector2.get(i);
                    if (!((Action)object).isUndoable()) continue;
                    ((Action)object).undo();
                    Vector vector3 = ((Action)object).getActionResultInfo();
                    if (!((Action)vector2.get(i)).isRedoable()) {
                        bl = false;
                    }
                    for (int j = 0; j < vector3.size(); ++j) {
                        ActionTool.mergeResultInfo(vector, (ActionResultInfo)vector3.get(j));
                    }
                }
                if (bl) {
                    this.redoStack.push(vector2);
                    this.appendActionForRstInfo.push(actionContext);
                }
            }
            ActionTool.processParentRstInfo(vector);
            return vector;
        }
        return null;
    }

    public Vector redoActionForRstInfo() {
        if (this.canRedo()) {
            Vector vector = null;
            Object object = this.redoStack.pop();
            ActionContext actionContext = (ActionContext)this.appendActionForRstInfo.pop();
            if (object instanceof Action) {
                ((Action)object).redo();
                vector = ((Action)object).getActionResultInfo();
                if (((Action)object).isUndoable()) {
                    this.undoStack.push(object);
                    this.SEDU.push(actionContext);
                }
            } else {
                boolean bl = true;
                Vector vector2 = (Vector)object;
                vector = new Vector();
                for (int i = 0; i < vector2.size(); ++i) {
                    object = (Action)vector2.get(i);
                    if (!((Action)object).isRedoable()) continue;
                    ((Action)object).redo();
                    Vector vector3 = ((Action)object).getActionResultInfo();
                    if (!((Action)vector2.get(i)).isUndoable()) {
                        bl = false;
                    }
                    for (int j = 0; j < vector3.size(); ++j) {
                        ActionTool.mergeResultInfo(vector, (ActionResultInfo)vector3.get(j));
                    }
                }
                if (bl) {
                    this.undoStack.push(vector2);
                    this.SEDU.push(actionContext);
                }
            }
            ActionTool.processParentRstInfo(vector);
            return vector;
        }
        return null;
    }

    public IReportViewCenter getUndoActionRVC() {
        if (this.canUndo()) {
            return ((ActionContext)this.SEDU.get(this.undoStack.getCurrentPos() - 1)).getIReportViewCenter();
        }
        return null;
    }

    public IReportViewCenter getRedoActionRVC() {
        if (this.canRedo()) {
            return ((ActionContext)this.appendActionForRstInfo.get(this.redoStack.getCurrentPos() - 1)).getIReportViewCenter();
        }
        return null;
    }

    @Override
    public void clearStack() {
        super.clearStack();
        this.SEDU.clear();
        this.appendActionForRstInfo.clear();
    }

    private ActionContext SEDU(IReportViewCenter iReportViewCenter) {
        return new ActionContext(null, iReportViewCenter);
    }
}

