/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.ZipToolkit;
import jet.ie.io.PJFDataOutput;
import jet.rptengine.DSObjectRecycler;
import jet.rptengine.JCommunicator;
import jet.rptengine.SynRecord;
import jet.rptengine.creator.ExecuteEnv;
import jet.util.JRInterruptedException;

public class JDataStream
extends DataStream {
    private JRecord GZip;
    int id;
    DSObjectRecycler recycler = new DSObjectRecycler();
    JCommunicator comm;
    private JRecord I;
    private DSPage LAYOUTSWAP;

    public JDataStream() {
    }

    public JDataStream(Communicator communicator, int n, int n2) {
        super(communicator, n2);
        this.id = n;
        this.comm = (JCommunicator)communicator;
        ExecuteEnv executeEnv = this.comm.getReportEngine(0).getStreamEngine().getExecuteEnv();
        this.GZip = new SynRecord(this.dbBuffer, executeEnv);
    }

    public void close() {
    }

    @Override
    public void clearMem() {
        super.clearMem();
        if (this.recycler != null) {
            this.recycler.emptyRecycler();
        }
    }

    @Override
    public JRecord getSynRecord(int n) {
        this.GZip.setPosition(n);
        this.GZip.refresh(false);
        return this.GZip;
    }

    @Override
    public JRecord getSynRecord2(int n) {
        if (this.I == null) {
            ExecuteEnv executeEnv = this.comm.getReportEngine(0).getStreamEngine().getExecuteEnv();
            this.I = new SynRecord(this.dbBuffer, executeEnv);
        }
        this.I.setPosition(n);
        this.I.refresh(false);
        return this.I;
    }

    public DSObjectRecycler getRecycler() {
        return this.recycler;
    }

    public void setID(int n) {
        this.id = n;
    }

    public String toString() {
        return super.toString() + '@' + this.id;
    }

    public void addPage(DSPage dSPage) {
        block2: {
            try {
                this.cachePage(dSPage);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, iOException);
            }
        }
    }

    @Override
    protected void cachePage(DSPage dSPage) throws IOException {
        int n;
        if (this.cachedPages.size() >= this.cacheSize) {
            n = this.LRU.removeLastElement();
            DSPage dSPage2 = (DSPage)this.cachedPages.remove(n);
            if (this.getPageEntry(n) == null) {
                if (this.bufFile == null) {
                    this.createTempFile();
                }
                long l = this.bufFile.length();
                this.bufFile.seek(l);
                this.out.reset(this.bufFile.length());
                RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage2.length());
                PJFDataOutput pJFDataOutput = new PJFDataOutput(randomByteArrayOutputStream);
                pJFDataOutput.setOutStatus(PJFDataOutput.LAYOUTSWAP);
                dSPage2.write(pJFDataOutput);
                byte[] byArray = randomByteArrayOutputStream.toByteArray();
                if (this.isCacheZip()) {
                    byArray = ZipToolkit.GZip(byArray);
                }
                this.out.write(byArray);
                randomByteArrayOutputStream.close();
                this.pageEntries.put(n, l);
                this.pageLengthes.put(n, (int)(this.bufFile.length() - l));
                if (this.comm.getCacheSection()) {
                    this.recycler.dumpDSPage(dSPage2);
                }
            }
        }
        n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
        this.LRU.insertElementAt(n, 0);
    }

    public DSPage getFastPassPage(int n) {
        DSPage dSPage = null;
        Communicator communicator = this.getCommunicator();
        if (communicator instanceof JCommunicator && ((JCommunicator)communicator).isFastPass() && (dSPage = (DSPage)this.cachedPages.get(n)) != null) {
            this.cachedPages.remove(n);
        }
        this.LAYOUTSWAP = dSPage;
        return dSPage;
    }

    public synchronized void addFastPassPage(DSPage dSPage) {
        Communicator communicator;
        if (this.cachedPages.size() >= this.cacheSize && (communicator = this.getCommunicator()) instanceof JCommunicator && ((JCommunicator)communicator).isFastPass()) {
            while (this.cachedPages.size() >= this.cacheSize) {
                try {
                    this.wait();
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, exception);
                }
            }
        }
        int n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
    }
}

