/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.creator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.report.JetRptGroupPanel;

class SecurityInfo {
    String sid;
    int length;
    int[] pages;
    Hashtable groups;

    SecurityInfo(String string) {
        this.sid = string;
    }

    SecurityInfo(String string, SecurityInfo securityInfo) {
        this(string);
        if (securityInfo.length > 0) {
            this.length = securityInfo.length;
            this.pages = new int[this.length];
            System.arraycopy(securityInfo.pages, 0, this.pages, 0, this.length);
        }
        if (securityInfo.groups != null) {
            this.groups = (Hashtable)securityInfo.groups.clone();
        }
    }

    void insert(int n) {
        if (this.pages == null) {
            this.pages = new int[4];
        } else if (this.length == this.pages.length) {
            int[] nArray = new int[this.length + this.length];
            System.arraycopy(this.pages, 0, nArray, 0, this.length);
            this.pages = nArray;
        }
        if (this.length == 0) {
            this.pages[this.length++] = n;
        } else {
            int n2 = this.length;
            while (--n2 >= 0) {
                if (this.pages[n2] == n) {
                    return;
                }
                if (this.pages[n2] >= n) continue;
                if (n2 == this.length - 1) {
                    this.pages[this.length++] = n;
                } else {
                    System.arraycopy(this.pages, ++n2, this.pages, n2 + 1, this.length - n2);
                    this.pages[n2] = n;
                    ++this.length;
                }
                return;
            }
            System.arraycopy(this.pages, 0, this.pages, 1, this.length);
            this.pages[0] = n;
            ++this.length;
        }
    }

    void add(int n) {
        if (this.indexOf(n) == -1) {
            if (this.pages == null) {
                this.pages = new int[4];
            }
            if (this.length == this.pages.length) {
                int[] nArray = new int[this.length + this.length];
                System.arraycopy(this.pages, 0, nArray, 0, this.length);
                this.pages = nArray;
            }
            this.pages[this.length++] = n;
        }
    }

    void add(JetRptGroupPanel jetRptGroupPanel, Object object) {
        Vector<Object> vector;
        if (this.groups == null) {
            this.groups = new Hashtable();
        }
        if ((vector = (Vector<Object>)this.groups.get(jetRptGroupPanel)) == null) {
            vector = new Vector<Object>();
            this.groups.put(jetRptGroupPanel, vector);
        }
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }

    void remove(int n) {
        int n2 = this.length;
        while (--n2 >= 0) {
            if (this.pages[n2] != n) continue;
            if (n2 < this.length - 1) {
                System.arraycopy(this.pages, n2 + 1, this.pages, n2, this.length - n2);
            }
            --this.length;
            break;
        }
    }

    int[] getPages() {
        int[] nArray = new int[this.length];
        if (this.length != 0) {
            System.arraycopy(this.pages, 0, nArray, 0, this.length);
        }
        return nArray;
    }

    Hashtable getGroups() {
        return this.groups;
    }

    int indexOf(int n) {
        int n2 = this.length;
        while (--n2 >= 0) {
            if (this.pages[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    void merge(SecurityInfo securityInfo) {
        for (int i = 0; i < securityInfo.length; ++i) {
            this.insert(securityInfo.pages[i]);
        }
        if (securityInfo.groups != null) {
            Enumeration enumeration = securityInfo.groups.keys();
            while (enumeration.hasMoreElements()) {
                JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)enumeration.nextElement();
                Vector vector = (Vector)securityInfo.groups.get(jetRptGroupPanel);
                for (int i = 0; i < vector.size(); ++i) {
                    this.add(jetRptGroupPanel, vector.elementAt(i));
                }
            }
        }
    }
}

