/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.layoutManager;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.datastream.DSParagraph;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.exception.UserException;
import jet.report.JRObjectTemplate;
import jet.report.JetRptDataContainer;
import jet.report.JetRptRectangle;
import jet.report.JetRptSectionObject;
import jet.report.table.JetRptNewTable;
import jet.report.tabular.JetRptTabular;
import jet.rptengine.creator.AbstractCreator;
import jet.rptengine.creator.BreakStateProcessor;
import jet.rptengine.creator.ExecuteEnv;
import jet.rptengine.creator.JDSSectionObjectCreator;
import jet.rptengine.layoutManager.FlowPropertyProcessor;
import jet.rptengine.layoutManager.LayoutManager;
import jet.rptengine.layoutManager.Line;
import jet.rptengine.layoutManager.ParagraphLine;
import jet.rptengine.layoutManager.ReportBodyLayoutManager;
import jet.rptengine.layoutManager.SpaceManager;
import jet.rptengine.layoutManager.SubReportBodyLayoutManager;
import jet.rptservice.api.exception.JRScheduleException;
import jet.table.TableCreator;
import jet.util.EngineErrorListener;

public class BasicFlowLayoutManager
extends LayoutManager {
    protected Line floatL;
    protected Line blockL;
    protected ParagraphLine inlineL;
    protected int[] lineInfo = new int[3];
    protected Vector elements = new Vector();
    protected Vector floatElements = new Vector();
    protected Vector components = new Vector();
    protected int lineX;
    protected int lineY;
    protected int width;
    protected int maxX;
    protected JRObjectTemplate template;
    protected boolean breaking = false;
    protected int containerHeight = -1;
    protected int containerWidth = -1;

    public BasicFlowLayoutManager() {
        this.spaceManager = new SpaceManager();
    }

    public void init() {
        this.breaking = false;
    }

    @Override
    public void setAvailableSpace(int n, int n2, int n3, int n4) {
        this.spaceManager.init(n, n2, n3, n4);
        this.containerHeight = n4;
        this.containerWidth = n3;
    }

    @Override
    public boolean add(JRObjectResult jRObjectResult) {
        this.components.add(jRObjectResult);
        return !this.layoutComp(jRObjectResult);
    }

    protected boolean layoutComp(JRObjectResult jRObjectResult) {
        this.template = (JRObjectTemplate)jRObjectResult.getTemplate();
        if (FlowPropertyProcessor.isFloat(this.template)) {
            this.floatLayout(jRObjectResult);
        } else if (FlowPropertyProcessor.isBlock(this.template)) {
            if (this.blockLayout(jRObjectResult)) {
                this.breaking = true;
                return true;
            }
        } else if (FlowPropertyProcessor.isInline(this.template)) {
            if (this.inlineLayout(jRObjectResult)) {
                this.breaking = true;
                return true;
            }
        } else if (JRLog.isError(3)) {
            JRLog.error(3, "");
        }
        return false;
    }

    protected boolean inlineLayout(JRObjectResult jRObjectResult) {
        this.lineY = this.spaceManager.getFlowPosition();
        if (this.lineY == -1 || this.lineY >= this.containerHeight) {
            this.breaking = true;
            return true;
        }
        if (this.inlineL == null) {
            this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
            this.lineX = this.lineInfo[0];
            this.width = this.lineInfo[2];
            this.inlineL = new ParagraphLine(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
            this.inlineL.setEnv(this.env);
        }
        if (this.inlineL.isEmpty()) {
            this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
            this.lineX = this.lineInfo[0];
            this.width = this.lineInfo[2];
            this.inlineL.init(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
        }
        if (this.inlineL.addElement(jRObjectResult)) {
            if (this.inlineL.isBreaking()) {
                this.breaking = true;
                return true;
            }
            this.inlineL.setLineOver(true);
            this.inlineL.dealWithLine(true);
            this.setMaxX(this.inlineL);
            this.addComp(this.inlineL);
            this.spaceManager.setFlowPosition(this.inlineL.getLineHeight());
            Vector vector = this.inlineL.getElements();
            Vector vector2 = this.inlineL.getUnProcessComps();
            this.processFloat(vector, vector2);
            while (vector2 != null && vector2.size() != 0) {
                this.lineY = this.spaceManager.getFlowPosition();
                if (this.lineY == -1 || this.lineY >= this.containerHeight) {
                    this.breaking = true;
                    return true;
                }
                this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
                this.lineX = this.lineInfo[0];
                this.width = this.lineInfo[2];
                this.inlineL.init(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
                if (!this.inlineL.addElement()) break;
                if (this.inlineL.isBreaking()) {
                    this.breaking = true;
                    return true;
                }
                this.inlineL.setLineOver(true);
                this.inlineL.dealWithLine(true);
                this.setMaxX(this.inlineL);
                this.addComp(this.inlineL);
                this.spaceManager.setFlowPosition(this.inlineL.getLineHeight());
                vector = this.inlineL.getElements();
                vector2 = this.inlineL.getUnProcessComps();
                this.processFloat(vector, vector2);
            }
        }
        this.breaking = false;
        return false;
    }

    public void processFloat(Vector vector, Vector vector2) {
        if (vector2.size() > 0) {
            int n;
            JRObjectResult jRObjectResult = this.inlineL.getElement(vector.size() - 1);
            if (vector.size() + vector2.size() + this.floatElements.size() == this.components.size() && this.inlineL.children.size() != vector.size()) {
                jRObjectResult = this.inlineL.getElement(vector.size());
            }
            int n2 = this.components.indexOf(jRObjectResult);
            int n3 = this.floatElements.size();
            for (n = 0; n < n3 && this.components.indexOf(this.floatElements.get(0)) < n2; ++n) {
                this.inlineL.setEndline(true);
                this.floatLayout((JRObjectResult)this.floatElements.get(0));
                this.inlineL.setEndline(false);
                this.floatElements.removeElementAt(0);
            }
            for (n = 0; n < n2; ++n) {
                this.components.removeElementAt(0);
            }
            if (jRObjectResult == vector.get(vector.size() - 1)) {
                this.components.removeElementAt(0);
            } else {
                this.components.set(0, vector2.get(0));
            }
        } else {
            for (int i = 0; i < this.floatElements.size(); ++i) {
                this.floatLayout((JRObjectResult)this.floatElements.get(i));
            }
            this.floatElements.clear();
            this.components.clear();
        }
    }

    protected void floatLayout(JRObjectResult jRObjectResult) {
        this.template = (JRObjectTemplate)jRObjectResult.getTemplate();
        if (this.inlineL == null || this.inlineL.isEmpty() || this.inlineL.getEndline()) {
            switch (this.template.clear.intValue()) {
                case 2: {
                    this.lineY = this.spaceManager.getMaxY();
                    break;
                }
                case 0: {
                    this.lineY = this.spaceManager.getLeftMaxY();
                    break;
                }
                case 1: {
                    this.lineY = this.spaceManager.getRightMaxY();
                    break;
                }
                case 3: {
                    this.lineY = this.spaceManager.getFlowPosition();
                }
            }
            if (this.lineY < this.spaceManager.getFlowPosition()) {
                this.lineY = this.spaceManager.getFlowPosition();
            }
            if (this.lineY >= this.containerHeight) {
                this.elements.add(jRObjectResult);
            } else {
                this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
                this.lineX = this.lineInfo[0];
                this.width = this.lineInfo[2];
                this.floatL = new Line(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
                while (!this.floatL.addElement(jRObjectResult, true)) {
                    if (this.width >= this.containerWidth) {
                        this.floatL.addElement(jRObjectResult, false);
                        break;
                    }
                    this.lineInfo = this.spaceManager.getNextAvailableY();
                    this.lineY = this.lineInfo[1];
                    if (this.lineY == -1) {
                        this.spaceManager.setY(this.lineY);
                        this.elements.add(jRObjectResult);
                        break;
                    }
                    this.lineX = this.lineInfo[0];
                    this.width = this.lineInfo[2];
                    this.floatL = new Line(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
                    this.spaceManager.setY(this.lineY);
                }
                if (this.lineY != -1) {
                    int n;
                    this.floatL.setLineOver(true);
                    this.floatL.dealWithLine(false);
                    this.setMaxX(this.floatL);
                    boolean bl = FlowPropertyProcessor.isFloatLeft(this.template);
                    if (!bl) {
                        n = this.lineX + this.width;
                        this.lineX = n - ((JRVisiableResult)jRObjectResult).getWidth();
                        if (this.lineX < 0) {
                            this.lineX = 0;
                        }
                        ((JRVisiableResult)jRObjectResult).setX(this.lineX);
                    } else {
                        this.lineX += ((JRVisiableResult)jRObjectResult).getWidth();
                    }
                    n = ((JRVisiableResult)jRObjectResult).getY() + ((JRVisiableResult)jRObjectResult).getHeight();
                    this.spaceManager.setFloatInfo(bl, this.lineX, this.lineY, n);
                    this.addComp(this.floatL);
                }
            }
        } else {
            this.floatElements.add(jRObjectResult);
        }
    }

    protected boolean blockLayout(JRObjectResult jRObjectResult) {
        if (this.inlineL != null && !this.inlineL.isEmpty()) {
            if (this.inlineL.finishLine()) {
                this.breaking = true;
                return true;
            }
            this.inlineL.setLineOver(true);
            this.inlineL.dealWithLine(true);
            this.setMaxX(this.inlineL);
            this.addComp(this.inlineL);
            this.spaceManager.setFlowPosition(this.inlineL.getLineHeight());
            this.inlineL.removeAllElements();
        }
        this.components.clear();
        if (!this.floatElements.isEmpty()) {
            for (int i = 0; i < this.floatElements.size(); ++i) {
                this.floatLayout((JRObjectResult)this.floatElements.get(i));
            }
            this.floatElements.clear();
        }
        switch (((JRObjectTemplate)jRObjectResult.getTemplate()).clear.intValue()) {
            case 2: {
                this.lineY = this.spaceManager.getMaxY();
                break;
            }
            case 0: {
                this.lineY = this.spaceManager.getLeftMaxY();
                break;
            }
            case 1: {
                this.lineY = this.spaceManager.getRightMaxY();
                break;
            }
            case 3: {
                this.lineY = this.spaceManager.getFlowPosition();
            }
        }
        if (this.lineY < this.spaceManager.getFlowPosition()) {
            this.lineY = this.spaceManager.getFlowPosition();
        }
        if (this.lineY == -1 || this.lineY >= this.containerHeight) {
            this.components.add(jRObjectResult);
            this.breaking = true;
            return true;
        }
        this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
        this.lineX = this.lineInfo[0];
        this.width = this.lineInfo[2];
        this.blockL = new Line(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
        while (!this.blockL.addElement(jRObjectResult, true)) {
            if (this.width == this.containerWidth) {
                this.blockL.addElement(jRObjectResult, false);
                break;
            }
            this.lineInfo = this.spaceManager.getNextAvailableY();
            this.lineY = this.lineInfo[1];
            if (this.lineY == -1) {
                this.components.add(jRObjectResult);
                this.breaking = true;
                return true;
            }
            this.lineX = this.lineInfo[0];
            this.width = this.lineInfo[2];
            this.blockL = new Line(this.lineX, this.lineY, this.width, this.containerHeight - this.lineY);
        }
        this.blockL.setLineOver(true);
        this.blockL.dealWithLine(false);
        this.setMaxX(this.blockL);
        this.addComp(this.blockL);
        if (this.blockL.isBreaking()) {
            this.breaking = true;
            return true;
        }
        this.spaceManager.setY(this.lineY);
        this.spaceManager.setFlowPosition(this.blockL.getLineHeight());
        this.breaking = false;
        return false;
    }

    @Override
    public int[] getContainerPosition(JRObjectTemplate jRObjectTemplate) {
        int[] nArray = new int[4];
        if (FlowPropertyProcessor.isFloat(jRObjectTemplate)) {
            if (JRLog.isError(3)) {
                JRLog.error(3, 3300005, jRObjectTemplate, (Throwable)new Exception("the template error ,pls check !  the component:  " + jRObjectTemplate + " can not be float!"));
            }
        } else if (FlowPropertyProcessor.isBlock(jRObjectTemplate)) {
            int n;
            if (this.inlineL != null && !this.inlineL.isEmpty()) {
                if (this.inlineL.finishLine()) {
                    return null;
                }
                this.inlineL.setLineOver(true);
                this.inlineL.dealWithLine(true);
                this.setMaxX(this.inlineL);
                this.addComp(this.inlineL);
                this.spaceManager.setFlowPosition(this.inlineL.getLineHeight());
            }
            this.components.clear();
            if (!this.floatElements.isEmpty()) {
                for (n = 0; n < this.floatElements.size(); ++n) {
                    this.floatLayout((JRObjectResult)this.floatElements.get(n));
                }
                this.floatElements.clear();
            }
            switch (jRObjectTemplate.clear.intValue()) {
                case 2: {
                    this.lineY = this.spaceManager.getMaxY();
                    break;
                }
                case 0: {
                    this.lineY = this.spaceManager.getLeftMaxY();
                    break;
                }
                case 1: {
                    this.lineY = this.spaceManager.getRightMaxY();
                    break;
                }
                case 3: {
                    this.lineY = this.spaceManager.getFlowPosition();
                }
            }
            if (this.lineY < this.spaceManager.getFlowPosition()) {
                this.lineY = this.spaceManager.getFlowPosition();
            }
            if (this.lineY == -1 || this.lineY >= this.containerHeight) {
                return null;
            }
            if (jRObjectTemplate instanceof JetRptSectionObject && ((JetRptSectionObject)jRObjectTemplate).horizontal.get() || jRObjectTemplate instanceof JetRptNewTable && ((JetRptNewTable)jRObjectTemplate).horizontal.get()) {
                int n2 = jRObjectTemplate instanceof JetRptNewTable ? jRObjectTemplate.iNWidth : jRObjectTemplate.iNHeight;
                if (n2 > this.containerHeight - this.lineY && this.lineY > 0) {
                    return null;
                }
                this.lineX = this.spaceManager.getLMaxX(this.lineY);
                return new int[]{this.lineX, this.lineY, this.containerWidth - this.lineX, this.containerHeight - this.lineY};
            }
            switch (jRObjectTemplate.getObjectType()) {
                case 33: 
                case 34: 
                case 46: 
                case 262178: 
                case 262181: {
                    this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
                    this.lineX = this.lineInfo[0];
                    this.width = this.lineInfo[2];
                    break;
                }
                default: {
                    int n3 = jRObjectTemplate.iNWidth;
                    n = this.containerWidth - this.spaceManager.getBorderLeftWidth() - this.spaceManager.getBorderRightWidth();
                    if (n3 >= n) {
                        if (this.spaceManager.getFlowPosition() >= this.containerHeight - this.spaceManager.getBorderBottomWidth()) {
                            return null;
                        }
                        this.lineInfo[0] = this.spaceManager.getBorderLeftWidth();
                        this.lineInfo[1] = this.spaceManager.getFlowPosition();
                        this.width = n;
                        if (JRLog.isError(3)) {
                            JRLog.trace(3, 3300009, new Object[]{jRObjectTemplate, new Integer(this.width)});
                            break;
                        }
                    } else {
                        this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
                        this.width = this.lineInfo[2];
                        if (n3 > this.width) {
                            this.lineInfo = this.spaceManager.getNextAvailableY(n3);
                            this.lineY = this.lineInfo[1];
                            this.width = this.lineInfo[2];
                            if (this.lineY >= this.containerHeight - this.spaceManager.getBorderBottomWidth()) {
                                return null;
                            } else {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                }
            }
        } else if (FlowPropertyProcessor.isInline(jRObjectTemplate)) {
            this.lineY = this.spaceManager.getFlowPosition();
            if (this.lineY == -1 || this.lineY >= this.containerHeight - this.spaceManager.getBorderBottomWidth()) {
                return null;
            }
            this.lineInfo = this.spaceManager.calAvailableWidth(this.lineY, 0, 0);
        } else if (JRLog.isError(3)) {
            JRLog.error(3, 3300006, (Throwable)new Exception("no such element"));
        }
        this.spaceManager.setY(this.lineY);
        nArray[0] = this.lineInfo[0];
        nArray[1] = this.lineInfo[1];
        if (this.env.isLogicPage()) {
            nArray[2] = this.containerWidth - this.spaceManager.getBorderLeftWidth() - this.spaceManager.getBorderRightWidth();
            nArray[3] = this.containerHeight - this.spaceManager.getBorderBottomWidth() - this.spaceManager.getBorderTopWidth();
        } else {
            nArray[2] = jRObjectTemplate.getObjectType() != 262179 && jRObjectTemplate.getObjectType() != 34 && jRObjectTemplate.getObjectType() != 262178 && (jRObjectTemplate.getObjectType() != 46 || (Boolean)((JetRptTabular)jRObjectTemplate).getPropertyByName("HorizontalAutoSize").getObject() == false) && (jRObjectTemplate.getObjectType() & 0x100) != 256 ? jRObjectTemplate.iNWidth : this.width;
            nArray[3] = this.containerHeight - this.lineInfo[1] - this.spaceManager.getBorderBottomWidth();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 6300050, new Object[]{jRObjectTemplate, new Integer(nArray[0]), new Integer(nArray[1]), new Integer(nArray[2]), new Integer(nArray[3])});
        }
        return nArray;
    }

    @Override
    public void finish() throws JRStopEngineException {
        if (!(this.inlineL == null || this.inlineL.isOver() && this.inlineL.isEmpty())) {
            this.inlineL.setLineOver(true);
            this.inlineL.dealWithLine(true);
            this.setMaxX(this.inlineL);
            this.addComp(this.inlineL);
            this.spaceManager.setFlowPosition(this.inlineL.getLineHeight());
            this.components.clear();
        }
        if (!this.floatElements.isEmpty()) {
            for (int i = 0; i < this.floatElements.size(); ++i) {
                this.floatLayout((JRObjectResult)this.floatElements.get(i));
            }
            this.floatElements.clear();
        }
    }

    protected void addComp(Line line) {
        Vector vector = line.getElements();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            this.template = (JRObjectTemplate)jRObjectResult.getTemplate();
            if (FlowPropertyProcessor.isRelative(this.template)) {
                int n = this.template.x.getUnit();
                int n2 = this.template.y.getUnit();
                ((JRVisiableResult)jRObjectResult).setX(((JRVisiableResult)jRObjectResult).getX() + n);
                ((JRVisiableResult)jRObjectResult).setY(((JRVisiableResult)jRObjectResult).getY() + n2);
            }
            this.currentResult.add(jRObjectResult);
        }
    }

    @Override
    public boolean isFinished() {
        return this.elements.size() == 0;
    }

    public boolean afterBreak() {
        int n;
        this.init();
        Vector vector = (Vector)this.elements.clone();
        Vector vector2 = (Vector)this.components.clone();
        this.elements.clear();
        this.components.clear();
        if (!vector.isEmpty()) {
            for (n = 0; n < vector.size(); ++n) {
                this.add((JRObjectResult)vector.get(n));
            }
        }
        if (!vector2.isEmpty()) {
            for (n = 0; n < vector2.size(); ++n) {
                if (!this.add((JRObjectResult)vector2.get(n))) continue;
                ++n;
                while (n < vector2.size()) {
                    this.components.add((JRObjectResult)vector2.get(n));
                    ++n;
                }
                vector2.clear();
                this.breaking = true;
                return true;
            }
        }
        vector2.clear();
        this.breaking = false;
        return false;
    }

    @Override
    public void rollback(int n, int n2) {
        this.spaceManager.rollbackSpace(n, n2);
        this.spaceManager.setFlowPosition(n2);
    }

    public void rollback(int n) {
        this.spaceManager.setFlowPosition(n);
    }

    @Override
    public void rollbackAllSpace() {
        this.spaceManager.setY(this.containerHeight);
        this.spaceManager.setMaxX(this.containerWidth);
    }

    @Override
    public void rollback(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult == null) {
            return;
        }
        if (!(jRVisiableResult instanceof DSParagraph)) {
            this.spaceManager.setFlowPosition(jRVisiableResult.getHeight());
        }
        this.spaceManager.setMaxX(jRVisiableResult.getX() + jRVisiableResult.getWidth());
    }

    @Override
    public void rollback(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult == null) {
            return;
        }
        if (!(jRVisiableResult instanceof DSParagraph)) {
            this.spaceManager.setFlowPosition(jRVisiableResult.getHeight() + n);
        }
        this.spaceManager.setMaxX(jRVisiableResult.getX() + jRVisiableResult.getWidth());
    }

    public void setMaxX(Line line) {
        int n = line.getLineEndX();
        if (this.maxX < n) {
            this.maxX = n;
        }
        this.spaceManager.setMaxX(this.maxX);
    }

    public boolean processChildCreator() throws UserException, JRScheduleException, DSException, JRStopEngineException {
        boolean bl = false;
        if (this.afterBreak()) {
            bl = true;
        }
        while (this.childCreators.size() > 0) {
            JRVisiableResult jRVisiableResult;
            AbstractCreator abstractCreator;
            block21: {
                EngineErrorListener engineErrorListener;
                abstractCreator = (AbstractCreator)this.childCreators.get(0);
                int[] nArray = this.getContainerPosition(abstractCreator.getTemplate());
                if (nArray == null) {
                    bl = true;
                    break;
                }
                abstractCreator.layoutManager.setAvailableSpace(nArray[0], nArray[1], nArray[2], nArray[3]);
                jRVisiableResult = null;
                try {
                    jRVisiableResult = abstractCreator.doLayout(false);
                    if (this.isSuppressEmpty() && this.isSonsEmpty()) {
                        if (abstractCreator instanceof JDSSectionObjectCreator || abstractCreator instanceof TableCreator) {
                            if (!abstractCreator.env.isNoRecord()) {
                                this.setSonsEmpty(false);
                            }
                        } else {
                            this.setSonsEmpty(false);
                        }
                    }
                    if (!(this instanceof SubReportBodyLayoutManager) || !(abstractCreator instanceof JDSSectionObjectCreator) && !(abstractCreator instanceof TableCreator)) break block21;
                    if (jRVisiableResult == null) {
                        ((SubReportBodyLayoutManager)this).getVDataContainer().addElement(abstractCreator.getTemplate());
                    } else {
                        ((SubReportBodyLayoutManager)this).getVDataContainer().removeElement(abstractCreator.getTemplate());
                    }
                }
                catch (JRStopEngineException jRStopEngineException) {
                    throw jRStopEngineException;
                }
                catch (UserException userException) {
                    if (this instanceof ReportBodyLayoutManager && !(this instanceof SubReportBodyLayoutManager) && abstractCreator.getTemplate() instanceof JetRptDataContainer) {
                        throw userException;
                    }
                    engineErrorListener = this.env.getRptListener();
                    engineErrorListener.noteError(Thread.currentThread(), userException, 0, userException.getMessage());
                    if (JRLog.isError(2)) {
                        JRLog.error(2, userException);
                    }
                    this.childCreators.remove(0);
                    continue;
                }
                catch (JRScheduleException jRScheduleException) {
                    if (this instanceof ReportBodyLayoutManager && !(this instanceof SubReportBodyLayoutManager) && abstractCreator.getTemplate() instanceof JetRptDataContainer) {
                        throw jRScheduleException;
                    }
                    engineErrorListener = this.env.getRptListener();
                    engineErrorListener.noteError(Thread.currentThread(), jRScheduleException, 0, jRScheduleException.getMessage());
                    if (JRLog.isError(2)) {
                        JRLog.error(2, jRScheduleException);
                    }
                    this.childCreators.remove(0);
                    continue;
                }
                catch (DSException dSException) {
                    if (this instanceof ReportBodyLayoutManager && !(this instanceof SubReportBodyLayoutManager) && abstractCreator.getTemplate() instanceof JetRptDataContainer) {
                        throw dSException;
                    }
                    engineErrorListener = this.env.getRptListener();
                    engineErrorListener.noteError(Thread.currentThread(), dSException, 0, dSException.getMessage());
                    if (JRLog.isError(2)) {
                        JRLog.error(2, dSException);
                    }
                    this.childCreators.remove(0);
                    continue;
                }
            }
            if (null != jRVisiableResult) {
                this.env.updateSecurity(abstractCreator);
            }
            if (!BreakStateProcessor.dealWithStateCode(jRVisiableResult, abstractCreator, this, false)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void breaking(boolean bl) throws UserException, DSException, JRStopEngineException, JRScheduleException {
        this.absManager.setAvailableWidth(this.spaceManager.getContainerWidth());
        this.absManager.setAvailableHeight(this.spaceManager.getContainerHeight());
        this.absManager.setLayoutManager(this);
        this.absManager.doLayout(bl);
    }

    public void add(AbstractCreator abstractCreator) {
    }

    public void init(JetRptRectangle jetRptRectangle, ExecuteEnv executeEnv) {
        this.env = executeEnv;
    }

    @Override
    public boolean isUpdateable(JRObjectTemplate jRObjectTemplate) {
        return false;
    }

    public void updateSpaceManagerInfo(int n, int n2, int n3, int n4) {
        this.spaceManager.setX(n);
        this.spaceManager.setY(n2);
    }
}

