/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.util;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.query.JCrossTableQuery;
import jet.dataengine.api.query.JCubeViewQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataservice.api.FCValLstQuery;
import jet.dataservice.api.JDataChannel;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JFilterCtrlInfo;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.DataFragment;
import jet.icontrols.QueryInfo;
import jet.rptengine.util.OSFWithDcManager;
import jet.rptengine.util.OnScreenFilterEntriesInfo;
import jet.rptservice.IQueryIDFetcher;

public class DataChannelManager {
    private Map SEDU = new HashMap();
    private JDataService add;
    private IQueryIDFetcher append;

    private void SEDU(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "[DataChannelManager]" + string);
        }
    }

    public void updateQueryIDFetcher(IQueryIDFetcher iQueryIDFetcher) {
        this.append = iQueryIDFetcher;
    }

    public DataChannelManager(JDataService jDataService, IQueryIDFetcher iQueryIDFetcher) {
        this.add = jDataService;
        this.append = iQueryIDFetcher;
    }

    public void closeAllDataChannels() {
        Vector<Integer> vector = new Vector<Integer>();
        for (JDataChannel jDataChannel : this.SEDU.values()) {
            vector.add(new Integer(jDataChannel.getChannelId()));
            this.add.destroy(jDataChannel);
        }
        this.SEDU.clear();
        this.SEDU("[Close All DataChannels] {" + vector + "}");
    }

    public void closeAllUnusedDataChannels(OSFWithDcManager oSFWithDcManager) {
        Vector<DcCollection> vector = new Vector<DcCollection>();
        for (DcCollection dcCollection : this.SEDU.keySet()) {
            boolean bl = false;
            for (QueryInfo queryInfo : oSFWithDcManager.queryInfoToOsfDcs.keySet()) {
                List list = (List)oSFWithDcManager.queryInfoToOsfDcs.get(queryInfo);
                for (OSFWithDcManager.OsfsDcsPair osfsDcsPair : list) {
                    List list2 = osfsDcsPair.getDcInstNames();
                    DcCollection dcCollection2 = new DcCollection(list2);
                    if (!dcCollection.equals(dcCollection2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (bl) continue;
            vector.add(dcCollection);
        }
        for (DcCollection dcCollection : vector) {
            JDataChannel jDataChannel = (JDataChannel)this.SEDU.get(dcCollection);
            this.SEDU("[Close All Unused DataChannels] dcs={" + dcCollection + "} dataChannel=" + jDataChannel.getChannelId());
            this.add.destroy(jDataChannel);
            this.SEDU.remove(dcCollection);
        }
    }

    private JDataChannel add(List list) throws DSException {
        DcCollection dcCollection = new DcCollection(list);
        if (!this.SEDU.containsKey(dcCollection)) {
            this.SEDU.put(dcCollection, this.add.createDataChannel());
        }
        JDataChannel jDataChannel = (JDataChannel)this.SEDU.get(dcCollection);
        Vector<Integer> vector = new Vector<Integer>();
        Vector<IExpression> vector2 = new Vector<IExpression>();
        for (String string : list) {
            int[] nArray;
            for (int n : nArray = this.append.getGroupQueryIDs(string)) {
                JQuery jQuery = this.add.getQuery(n);
                int n2 = -1;
                if (jQuery instanceof JGroupQuery) {
                    n2 = ((JGroupQuery)jQuery).getBaseId();
                    vector2.add(((JGroupQuery)jQuery).getDhtmlFilter());
                } else if (jQuery instanceof JCrossTableQuery) {
                    n2 = ((JCrossTableQuery)jQuery).getBaseId();
                    vector2.add(((JCrossTableQuery)jQuery).getDhtmlFilter());
                } else if (jQuery instanceof JCubeViewQuery) {
                    n2 = ((JCubeViewQuery)jQuery).getBaseId();
                }
                vector.add(new Integer(n2));
            }
        }
        if (vector.size() > 0) {
            Object object = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = (Integer)vector.get(i);
            }
            jDataChannel.setComponetQueryIds((int[])object);
            jDataChannel.setDhtmlFilters(vector2.toArray(new IExpression[((Object)object).length]));
            this.SEDU("[GetDataChannel] dcInstNames={" + list + "} " + "DataChannelID=" + jDataChannel.getChannelId() + " ComponentQueryIDs={" + vector + "}" + " DhtmlFilters={" + vector2 + "}");
        } else {
            this.SEDU("[GetDataChannel] dcInstNames={" + list + "} " + "; No query id exists, return null");
            jDataChannel = null;
        }
        return jDataChannel;
    }

    public boolean isEmpty(OSFWithDcManager.OsfsDcsPair osfsDcsPair, IExpression iExpression, Vector vector, Vector vector2) throws DSException {
        JDataChannel jDataChannel = this.add(osfsDcsPair.getDcInstNames());
        if (jDataChannel == null) {
            this.SEDU("[isEmpty] OsfDcsPair=" + osfsDcsPair + " No query id exists, so no data channel, just return true");
            return true;
        }
        jDataChannel.setOnScreenFlt(iExpression);
        List list = osfsDcsPair.getOSFBindMappingNames();
        jDataChannel.setColumns(list.toArray(new String[0]));
        JDataChannel[] jDataChannelArray = new JDataChannel[]{jDataChannel};
        String[] stringArray = vector2.toArray(new String[0]);
        JFilterCtrlInfo jFilterCtrlInfo = new JFilterCtrlInfo(jDataChannelArray, stringArray, null, false);
        String[] stringArray2 = vector.toArray(new String[0]);
        jFilterCtrlInfo.setAllowqualifyName(stringArray2);
        boolean bl = this.add.isEmpty(jFilterCtrlInfo);
        this.SEDU("[isEmpty] OsfDcsPair=" + osfsDcsPair + " OnScreenFilter=" + iExpression + " Columns={" + list + "} DataChannelID=" + jDataChannel.getChannelId() + " allowMappingNames = " + vector2 + " allowQualifyNames = " + vector + " Result=" + bl);
        return bl;
    }

    public JDbBufferData[] getFCValueList(int n) throws DSException {
        this.SEDU("[getFCValueList] begin: fcQryId=" + n);
        JDbBufferData[] jDbBufferDataArray = this.add.getFCValueList(n);
        this.SEDU("[getFCValueList] for fcQryId =" + n + " Result=" + jDbBufferDataArray);
        return jDbBufferDataArray;
    }

    public DataFragment getFCValueList(int n, AdapterInfo adapterInfo) throws DSException {
        this.SEDU("[getFCValueList] begin: fcQryId = " + n + ";\tAdapterInfo=" + adapterInfo);
        DataFragment dataFragment = this.add.getFCValueList(n, adapterInfo);
        this.SEDU("[getFCValueList] for fcQryId = " + n + "; AdapterInfo=" + adapterInfo + " Result=" + dataFragment);
        return dataFragment;
    }

    public void unregistFCQry(int n) throws DSException {
        this.SEDU("[unregistFCQry] begin: fcQryId = " + n);
        this.add.unregistFCQry(n);
    }

    public int registFCQry(List list, String string, boolean bl, int n) throws DSException {
        this.SEDU("[registFCQry] begin: Column=" + string + "; bIncludeNull=" + bl + "; osfEntriesInfos=" + list + "; resultDataType " + n);
        int n2 = -1;
        Vector<JFilterCtrlInfo> vector = new Vector<JFilterCtrlInfo>();
        for (int i = 0; i < list.size(); ++i) {
            OnScreenFilterEntriesInfo onScreenFilterEntriesInfo = (OnScreenFilterEntriesInfo)list.get(i);
            HashMap hashMap = onScreenFilterEntriesInfo.getPairsWithExp();
            JDataChannel[] jDataChannelArray = this.append(hashMap);
            if (jDataChannelArray.length == 0) {
                this.SEDU("[registFCQry] ***** " + i + " *******  \t\n" + onScreenFilterEntriesInfo + " \t\n *************  get data channels has no query id");
                continue;
            }
            JFilterCtrlInfo jFilterCtrlInfo = new JFilterCtrlInfo(jDataChannelArray, onScreenFilterEntriesInfo.getMappingNames(), onScreenFilterEntriesInfo.getSpecFormulaInfos(), onScreenFilterEntriesInfo.hasDenyColumn());
            vector.add(jFilterCtrlInfo);
            if (!JRLog.isTrace(6)) continue;
            Vector<Integer> vector2 = new Vector<Integer>();
            for (int j = 0; j < jDataChannelArray.length; ++j) {
                vector2.add(new Integer(jDataChannelArray[j].getChannelId()));
            }
            this.SEDU("[registFCQry] ***** " + i + " *******  \t\n" + onScreenFilterEntriesInfo + " \t\n dataChannels=(" + vector2 + ")");
        }
        if (vector.size() == 0) {
            this.SEDU("[registFCQry] return -1 , for Column=" + string + "; bIncludeNull=" + bl + "; resultDataType=" + n + ",  because getting data channels has no query id for it.");
            return n2;
        }
        FCValLstQuery fCValLstQuery = new FCValLstQuery(vector.toArray(new JFilterCtrlInfo[0]), string, bl, false, n);
        n2 = this.add.registFCQry(fCValLstQuery);
        this.SEDU("[registFCQry] Column=" + string + "; bIncludeNull=" + bl + "; resultDataType=" + n + ", return register fcQueryId =" + n2);
        return n2;
    }

    private JDataChannel[] append(Map map) throws DSException {
        String string = "pairsWithExp={";
        Vector<JDataChannel> vector = new Vector<JDataChannel>();
        for (Object object : map.keySet()) {
            if (((OSFWithDcManager.OsfsDcsPair)object).getOSFBindMappingNames().size() == 0) {
                this.SEDU("[getDataChannels]" + string + "no match OSFBindMappingNames for the OsfsDcsPair: ={" + object + "}, so need not get DataChannels for it.");
                continue;
            }
            JDataChannel jDataChannel = this.add(((OSFWithDcManager.OsfsDcsPair)object).getDcInstNames());
            if (jDataChannel == null) continue;
            jDataChannel.setColumns(((OSFWithDcManager.OsfsDcsPair)object).getOSFBindMappingNames().toArray(new String[0]));
            IExpression iExpression = (IExpression)map.get(object);
            jDataChannel.setOnScreenFlt(iExpression);
            vector.add(jDataChannel);
            string = string + "OsfDcsPair=" + object + " OnScreenFilter=" + iExpression;
        }
        string = string + "}";
        Vector vector2 = new Vector();
        for (JDataChannel jDataChannel : vector) {
            vector2.add(new Integer(jDataChannel.getChannelId()));
        }
        this.SEDU("[getDataChannels]" + string + "DataChannelIDs={" + vector2 + "}");
        return vector.toArray(new JDataChannel[0]);
    }

    private class DcCollection {
        private final List SEDU;

        public DcCollection(List list) {
            this.SEDU = list == null ? new ArrayList(0) : new ArrayList(list);
            Collections.sort(this.SEDU);
        }

        public int hashCode() {
            return this.SEDU == null ? 0 : ((Object)this.SEDU).hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof DcCollection)) {
                return false;
            }
            return ((Object)this.SEDU).equals(((DcCollection)object).SEDU);
        }

        public String toString() {
            return this.SEDU == null ? "null" : this.SEDU.toString();
        }
    }
}

