/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.util;

import com.jinfonet.api.datatypes.Types;
import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.query.AggregationKey;
import jet.dataengine.api.query.CTFormula;
import jet.dataengine.api.query.HeaderLevel;
import jet.dataengine.api.schema.olap.CubeViewFactory;
import jet.dataengine.api.schema.olap.query.querycoremodel.CubeViewModel;
import jet.dataengine.api.schema.olap.query.querycoremodel.SortInfo;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.ParaGroupModel;
import jet.dataservice.api.JDenyListProvider;
import jet.formula.Aggregation;
import jet.formula.FormulaInfo;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.application.cm.MeasureExpression;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.ireport.osf.OnScreenFilter;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptBreakContainer;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptColumn;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptObject;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubLink;
import jet.report.JetRptTemplatibleContainer;
import jet.report.chart.JetRptChartGroupRect;
import jet.report.chart.JetRptChartPaper;
import jet.report.chart.JetRptChartPlatform;
import jet.report.crosstabFormula.JetRptCTFormula;
import jet.report.filter.JetFilterExpression;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.report.vct.JetRptVCTDisplayType;
import jet.report.vct.JetRptVCTFilters;
import jet.report.vct.JetRptVCTGroup;
import jet.report.vct.JetRptVCTLegend;
import jet.report.vct.JetRptVCTLegendPattern;
import jet.report.vct.JetRptVCTObject;
import jet.report.vct.JetRptVCTSorter;
import jet.report.vct.JetRptVCTSorters;
import jet.report.vct.disp.JetRptVCTDispTypeAuto;
import jet.report.vct.header.JetRptVCTAxisDB;
import jet.report.vct.header.JetRptVCTDBHeader;
import jet.reportLogic.objectLogic.JetFilterExpressionToolKit;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnScreenFilterLogic;
import jet.reportLogic.objectLogic.ReportLogic;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportset.DataSet;
import jet.reportset.JetRptReport;
import jet.rptengine.MappingFldsParseTool;
import jet.rptengine.RptFormulaContainer;
import jet.rptengine.util.OnScreenFilterTool;
import jet.rptservice.api.ISecurityProvider;
import jet.rptservice.impl.Edge_MapInfoImpl;
import jet.rptservice.impl.LegendIndexTableImpl;
import jet.rptservice.impl.Template_dataInfoMapImpl;
import jet.rptservice.pub.ColumnNameDataResourceTypeInfo;
import jet.rptservice.pub.EdgeDimInfo;
import jet.rptservice.pub.EdgeInfo;
import jet.rptservice.pub.EdgeMeasureInfo;
import jet.rptservice.pub.EdgeSortInfo;
import jet.rptservice.pub.EngineConstantDef;
import jet.rptservice.pub.LegendInfo;
import jet.rptservice.pub.MappingNamesourceDesc;
import jet.rptservice.pub.VCTInfo;
import jet.rptservice.util.GroupStructionInfo;
import jet.rptservice.util.MappingNameCollection;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.ResourceLocator;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.universe.businesslogic.impl.DataElement;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.Measure;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.util.StringTools;
import jet.va.base.Edge_MapInfo;

public class EngineTools {
    public static String Prefix__MeasureMappingName = "##^^##MEASURE_";

    public static String printContainerInfor(IDataContainer iDataContainer) {
        if (iDataContainer == null) {
            return null;
        }
        return " DataContainer[" + iDataContainer.getClass() + "; InstanceName:" + iDataContainer.getInstNameDirectly() + "; HashCode:" + iDataContainer.hashCode() + "] ";
    }

    public static String printObject(Object object) {
        if (object == null) {
            return null;
        }
        return " Object[className:" + object.getClass() + "; HashCode:" + object.hashCode() + "] ";
    }

    public static MappingNamesourceDesc addMappingFld(JetObject jetObject, String string, QueryInfo queryInfo, boolean bl, String string2, boolean bl2, Hashtable hashtable, int n) {
        MappingNamesourceDesc mappingNamesourceDesc = null;
        if (string != null && string.trim().length() > 0) {
            int n2 = string.indexOf(ReportTools.RuntimeColName_DELIMITER);
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            mappingNamesourceDesc = new MappingNamesourceDesc();
            if (jetObject != null && jetObject instanceof JetRptObject) {
                mappingNamesourceDesc.setObjInstName(jetObject.getInstName());
            }
            mappingNamesourceDesc.setPropName(string2);
            mappingNamesourceDesc.setbBL(bl);
            mappingNamesourceDesc.setQueryInfo(queryInfo);
            mappingNamesourceDesc.setbUnderDetailPanelSupressedTrue(bl2);
            mappingNamesourceDesc.setUseType(n);
            if (hashtable != null) {
                Vector<MappingNamesourceDesc> vector = (Vector<MappingNamesourceDesc>)hashtable.get(string.toUpperCase());
                if (vector == null) {
                    vector = new Vector<MappingNamesourceDesc>();
                    hashtable.put(string.toUpperCase(), vector);
                }
                vector.addElement(mappingNamesourceDesc);
            }
        }
        return mappingNamesourceDesc;
    }

    public static int getDataTypeForColumName(JetUUniverse jetUUniverse, IReport iReport, String string, String string2, int n, String string3, String string4) {
        BLNode bLNode;
        int n2 = 0;
        Scope scope = new Scope(iReport, jetUUniverse, string, string2, string3, n);
        if (n == 0) {
            JetUResourceEntity jetUResourceEntity = scope.getResourceEntity(string4, false);
            if (jetUResourceEntity != null) {
                n2 = ObjectLogicFactory.getDataSetLogic().getDataSqlType(jetUResourceEntity);
            }
        } else if (n == 2 && (bLNode = scope.getBLNodeByQualifiedDisplayName(string4)) != null && bLNode instanceof DataElementInfo) {
            n2 = ObjectLogicFactory.getDataSetLogic().getDataSqlType(jetUUniverse, scope, (DataElementInfo)bLNode);
        }
        return Types.sqlTypeToType(n2);
    }

    public static JetUResourceEntity getRefResourceEntityForQualifyDisplayName(JetUUniverse jetUUniverse, IReport iReport, String string, String string2, int n, String string3, String string4) {
        String string5 = null;
        JetUResourceEntity jetUResourceEntity = null;
        Scope scope = new Scope(iReport, jetUUniverse, string, string2, string3, n);
        BLNode bLNode = scope.getBLNodeByQualifiedDisplayName(string4);
        if (bLNode != null) {
            int n2 = bLNode.getElementType();
            switch (n2) {
                case 4: {
                    Dimension dimension = (Dimension)bLNode;
                    string5 = dimension.getRefMappingName();
                    jetUResourceEntity = scope.getResourceEntity(string5, false);
                    break;
                }
                case 5: {
                    if (bLNode instanceof JetRptFlyMeasure) {
                        JetRptFlyMeasure jetRptFlyMeasure = (JetRptFlyMeasure)bLNode;
                        string5 = jetRptFlyMeasure.getRefMappingName();
                        jetUResourceEntity = scope.getResourceEntity(string5, false);
                        break;
                    }
                    Measure measure = (Measure)bLNode;
                    string5 = measure.getRefMappingName();
                    jetUResourceEntity = scope.getResourceEntity(string5, false);
                    break;
                }
                case 7: {
                    if (bLNode instanceof JetRptFormula) {
                        JetRptFormula jetRptFormula = (JetRptFormula)((Object)bLNode);
                        string5 = ((DataElementInfo)((Object)jetRptFormula)).getRefMappingName();
                        jetUResourceEntity = scope.getResourceEntity(string5, false);
                        break;
                    }
                    if (bLNode instanceof JetRptFlyFormula) {
                        JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)bLNode;
                        string5 = jetRptFlyFormula.getRefMappingName();
                        jetUResourceEntity = jetRptFlyFormula.getJetUFormula();
                        break;
                    }
                    DetailInfo detailInfo = (DetailInfo)bLNode;
                    string5 = detailInfo.getRefMappingName();
                    jetUResourceEntity = scope.getResourceEntity(string5, false);
                    break;
                }
            }
        }
        return jetUResourceEntity;
    }

    public static boolean validIntValueOverflow(int n, String string) {
        boolean bl = true;
        long l = 0L;
        switch (n) {
            case 4: {
                l = Long.parseLong(string);
                if (l <= Integer.MAX_VALUE) break;
                bl = false;
                break;
            }
            case 5: {
                l = Long.parseLong(string);
                if (l <= 32767L) break;
                bl = false;
                break;
            }
            case -6: {
                l = Long.parseLong(string);
                if (l <= 127L) break;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean hasParameterLinks(List list, boolean bl) {
        boolean bl2 = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                JetRptSubLink jetRptSubLink = (JetRptSubLink)list.get(i);
                String string2 = jetRptSubLink.sNSubColumn.toUpperCase();
                if (string2.equalsIgnoreCase(string = bl ? jetRptSubLink.sNMainColumn.toUpperCase() : jetRptSubLink.blMainColumn.get().toUpperCase())) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public static Vector[] getSubColNameInSubLinks(List list, int n) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string;
                JetRptSubLink jetRptSubLink = (JetRptSubLink)list.get(i);
                if (n != 0) {
                    string = jetRptSubLink.blSubColumn.get();
                    if (StringTools.nullOrAllSpaces(string)) {
                        string = jetRptSubLink.sNSubColumn;
                        vectorArray[0].addElement(string);
                        continue;
                    }
                    vectorArray[1].addElement(string);
                    continue;
                }
                string = jetRptSubLink.sNSubColumn;
                vectorArray[0].addElement(string);
            }
        }
        return vectorArray;
    }

    public static boolean isSuppressTrue(JetRptDetailPanel jetRptDetailPanel) {
        boolean bl = false;
        String string = PropertyNames.getDefinitionName(PropertyNames.Suppressed);
        JetProperty jetProperty = jetRptDetailPanel.nameToProperty(string);
        if (!jetProperty.isChagneByFmtt() && !jetProperty.isChangeByBL() && !jetProperty.isChangeByOther() && ((JetBoolean)jetProperty).get()) {
            bl = true;
        }
        return bl;
    }

    public static boolean isUnderDetailPSuppressTrue(JetObject jetObject) {
        boolean bl = false;
        if (jetObject != null) {
            for (JetObject jetObject2 = (JetObject)((Object)jetObject.getParent()); jetObject2 != null; jetObject2 = (JetObject)((Object)jetObject2.getParent())) {
                if (!(jetObject2 instanceof JetRptDetailPanel) || !EngineTools.isSuppressTrue((JetRptDetailPanel)jetObject2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static Hashtable converInstanceNameToRptObject(Hashtable hashtable, JetObject jetObject) {
        Hashtable<String, Object> hashtable2 = null;
        if (hashtable != null) {
            hashtable2 = new Hashtable<String, Object>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                JetRptObject jetRptObject;
                String string;
                String string2 = (String)enumeration.nextElement();
                Object v = hashtable.get(string2);
                if (v instanceof Vector) {
                    Vector<JetRptObject> vector = new Vector<JetRptObject>();
                    for (int i = 0; i < ((Vector)v).size(); ++i) {
                        string = (String)((Vector)v).elementAt(i);
                        jetRptObject = (JetRptObject)jetObject.nameToObject(string);
                        vector.addElement(jetRptObject);
                    }
                    hashtable2.put(string2, vector);
                    continue;
                }
                string = (String)v;
                jetRptObject = (JetRptObject)jetObject.nameToObject(string);
                hashtable2.put(string2, jetRptObject);
            }
        }
        return hashtable2;
    }

    public static Vector[] getResourceListFromJetFilterExpression(JetFilterExpression jetFilterExpression) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        if (jetFilterExpression != null) {
            List[] listArray = JetFilterExpressionToolKit.getFilterGroupedResourceListDetail(jetFilterExpression);
            for (int i = 0; i < listArray.length; ++i) {
                List list = listArray[i];
                if (i == JetFilterExpressionToolKit.REF_DBFIELD_QUALIFED) {
                    for (String string : list) {
                        vectorArray[1].addElement(string);
                    }
                    continue;
                }
                if (i != JetFilterExpressionToolKit.RES_DBFIELD && i != JetFilterExpressionToolKit.RES_FORMULA && i != JetFilterExpressionToolKit.RES_PARAMETER) continue;
                for (String string : list) {
                    vectorArray[0].addElement(string);
                }
            }
        }
        return vectorArray;
    }

    public static Vector[] getResourceListFromIExpression(IExpression iExpression) throws ConditionException, DSException {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        if (iExpression != null) {
            Vector vector = ExpressionToolKit.getALLRefForChildren(iExpression);
            for (int i = 0; i < vector.size(); ++i) {
                String[] stringArray = (String[])vector.elementAt(i);
                String string = stringArray.getName();
                int n = 0;
                int n2 = stringArray.expressionType();
                if (ExpressionToolKit.isReference(n2) || ExpressionToolKit.isDataContainerReference(n2)) {
                    n = ((IReference)stringArray).isQualifyName() ? 1 : 0;
                } else if (ExpressionToolKit.isFormula(n2) || ExpressionToolKit.isDataContainerFormula(n2)) {
                    n = ((IFormula)stringArray).isQualifyName() ? 1 : 0;
                }
                if (n == 0) {
                    vectorArray[0].addElement(string);
                    continue;
                }
                vectorArray[1].addElement(string);
            }
            String[] stringArray = ExpressionToolKit.getDependentParNames(iExpression);
            if (stringArray != null) {
                for (String string : stringArray) {
                    vectorArray[0].addElement(string);
                }
            }
        }
        return vectorArray;
    }

    public static Vector getAllParameterNames(IExpression iExpression, Scope scope) throws DSException, ConditionException {
        Vector<String> vector = new Vector<String>();
        if (iExpression == null) {
            return vector;
        }
        String[] stringArray = ExpressionToolKit.getDependentParNames(iExpression);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].toUpperCase();
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        Vector vector2 = ExpressionToolKit.getALLRefForChildren(iExpression);
        for (int i = 0; i < vector2.size(); ++i) {
            IVariableExpression iVariableExpression = (IVariableExpression)vector2.elementAt(i);
            String string = iVariableExpression.getName();
            boolean bl = false;
            int n = iVariableExpression.expressionType();
            if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isDataContainerReference(n)) {
                bl = ((IReference)iVariableExpression).isQualifyName();
            } else if (ExpressionToolKit.isFormula(n) || ExpressionToolKit.isDataContainerFormula(n)) {
                bl = ((IFormula)iVariableExpression).isQualifyName();
            }
            Vector vector3 = EngineTools.getParamNameList(scope, string, bl);
            if (vector3 == null || vector3.size() <= 0) continue;
            for (int j = 0; j < vector3.size(); ++j) {
                String string2 = ((String)vector3.get(j)).toUpperCase();
                if (vector.contains(string2)) continue;
                vector.add(string2);
            }
        }
        return vector;
    }

    public static Vector getParamNameList(Scope scope, String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        JetUResourceEntity jetUResourceEntity = scope.getResourceEntity(string, bl);
        JetUFormula jetUFormula = null;
        if (jetUResourceEntity instanceof JetUFormula) {
            jetUFormula = (JetUFormula)jetUResourceEntity;
        } else if (jetUResourceEntity instanceof JetUParameter && !vector.contains(string.toUpperCase())) {
            vector.addElement(string.toUpperCase());
        }
        if (jetUFormula != null) {
            EngineTools.getParamNameList(scope, jetUFormula, false, vector);
        }
        return vector;
    }

    public static void getParamNameList(Scope scope, JetUFormulaInterface jetUFormulaInterface, boolean bl, Vector vector) {
        String string;
        int n;
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        Vector vector2 = formulaInfo.refParameter;
        Vector vector3 = formulaInfo.refFormula;
        for (n = 0; n < vector2.size(); ++n) {
            string = ((String)vector2.elementAt(n)).toUpperCase();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
        n = vector3.size();
        for (int i = 0; i < n; ++i) {
            string = (String)vector3.elementAt(i);
            Vector vector4 = EngineTools.getParamNameList(scope, string, false);
            for (Object object : vector4) {
                if (vector.contains(object)) continue;
                vector.addElement(object);
            }
        }
        Vector vector5 = formulaInfo.getAllRefMeasures();
        if (vector5 != null) {
            for (int i = 0; i < vector5.size(); ++i) {
                Object object;
                string = (String)vector5.elementAt(i);
                Vector vector6 = EngineTools.getParamNameList(scope, string, false);
                object = vector6.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    if (vector.contains(string2)) continue;
                    vector.addElement(string2);
                }
            }
        }
    }

    public static boolean isRunningTotal(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string, boolean bl, JetRptReport jetRptReport, List list) {
        Object object;
        boolean bl2 = false;
        Object object2 = ReportTools.getResourceObject(jetUUniverse, jetRptReport, queryInfo, string, bl, list, null);
        Object var8_8 = null;
        if (object2 instanceof BLNode) {
            object = (BLNode)object2;
            int n = object.getElementType();
            if (n == 7 || n == 4) {
                if (object2 instanceof JetRptFlyFormula) {
                    string = ((JetRptFlyFormula)object2).getMappingName().toUpperCase();
                    object2 = ((JetRptFlyFormula)object2).getJetUFormula();
                } else {
                    string = ((DataElementInfo)object).getRefMappingName().toUpperCase();
                    object2 = ReportTools.getResourceObject(jetUUniverse, jetRptReport, queryInfo, string, false, list, null);
                }
            } else if (n == 5) {
                return EngineTools.isRunningTotal((MeasureInfo)object, jetUUniverse, queryInfo, true, jetRptReport, list);
            }
        }
        if (object2 instanceof JetUFormula) {
            object = (JetUFormula)object2;
            return ((JetUFormula)object).getFormulaInfo().isRefRunningTotal();
        }
        return bl2;
    }

    private static boolean isRunningTotal(MeasureInfo measureInfo, JetUUniverse jetUUniverse, QueryInfo queryInfo, boolean bl, JetRptReport jetRptReport, List list) {
        String string = measureInfo.getAggFunction();
        int n = Aggregation.getFunctionCode(string);
        if (Aggregation.isRunningTotal(n)) {
            return true;
        }
        String string2 = measureInfo.getRefMappingName().toUpperCase();
        return EngineTools.isRunningTotal(jetUUniverse, queryInfo, string2, false, jetRptReport, list);
    }

    public static int getDisplayRoundingMode(IDataContainer iDataContainer, JetUUniverse jetUUniverse) {
        String string;
        JetUDatabase jetUDatabase;
        int n = -1;
        DataSet dataSet = ReportTools.getDataSet((JetRptObject)((Object)iDataContainer));
        if (dataSet != null && (jetUDatabase = jetUUniverse.getDatabase(string = dataSet.getDataSourceName())) != null) {
            n = jetUDatabase.getDisplayRoundingMode();
        }
        return n;
    }

    public static VCTInfo createVCTEdgeInfo(JetRptVCTObject jetRptVCTObject, Scope scope) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        VCTInfo vCTInfo;
        String string;
        block18: {
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object122;
            string = "[EngineTools_VCT]";
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, string + "***createVCTEdgeInfo ... begin *** for vct = " + jetRptVCTObject);
            }
            vCTInfo = new VCTInfo();
            vCTInfo.setDisplayTypeScope(jetRptVCTObject.getDisplayTypeScope());
            JetRptVCTGroup jetRptVCTGroup = jetRptVCTObject.getVCTGroup(true);
            List list = jetRptVCTGroup.getAllDBHeaders();
            for (Object object122 : list) {
                object11 = ((JetRptVCTDBHeader)object122).getBlColumnName();
                object10 = null;
                object9 = new EdgeDimInfo((String)object11, (EdgeSortInfo)object10);
                vCTInfo.addColDimEdgeInfo((EdgeDimInfo)object9);
            }
            JetRptVCTGroup jetRptVCTGroup2 = jetRptVCTObject.getVCTGroup(false);
            object122 = jetRptVCTGroup2.getAllDBHeaders();
            object11 = object122.iterator();
            while (object11.hasNext()) {
                object10 = (JetRptVCTDBHeader)object11.next();
                object9 = ((JetRptVCTDBHeader)object10).getBlColumnName();
                object8 = null;
                object7 = new EdgeDimInfo((String)object9, (EdgeSortInfo)object8);
                vCTInfo.addRowDimEdgeInfo((EdgeDimInfo)object7);
            }
            object11 = jetRptVCTGroup.getAllVCTAxisDBs();
            object10 = object11.iterator();
            while (object10.hasNext()) {
                object9 = (JetRptVCTAxisDB)object10.next();
                object8 = ((JetRptVCTAxisDB)object9).getBlColumnName();
                object7 = scope.getBLNodeByQualifiedDisplayName((String)object8);
                if (!(object7 instanceof MeasureInfo)) continue;
                object6 = ((MeasureInfo)object7).getRefMappingName();
                int n = Aggregation.getFunctionCode(((MeasureInfo)object7).getAggFunction());
                EdgeMeasureInfo edgeMeasureInfo = new EdgeMeasureInfo((String)object8, (String)object6, n);
                vCTInfo.addColMeasureEdgeInfo(edgeMeasureInfo);
            }
            object10 = jetRptVCTGroup2.getAllVCTAxisDBs();
            object9 = object10.iterator();
            while (object9.hasNext()) {
                object8 = (JetRptVCTAxisDB)object9.next();
                object7 = ((JetRptVCTAxisDB)object8).getBlColumnName();
                object6 = scope.getBLNodeByQualifiedDisplayName((String)object7);
                if (!(object6 instanceof MeasureInfo)) continue;
                String string2 = ((MeasureInfo)object6).getRefMappingName();
                int n = Aggregation.getFunctionCode(((MeasureInfo)object6).getAggFunction());
                object5 = new EdgeMeasureInfo((String)object7, string2, n);
                vCTInfo.addRowMeasureEdgeInfo((EdgeMeasureInfo)object5);
            }
            object9 = jetRptVCTObject.getDisplayTypes();
            for (int i = 0; i < object9.size(); ++i) {
                object7 = (JetRptVCTDisplayType)object9.get(i);
                if (object7 instanceof JetRptVCTDispTypeAuto && (object6 = jetRptVCTObject.getCalculatedAutoDispType((JetRptVCTDispTypeAuto)object7)) != null) {
                    object7 = object6;
                }
                object6 = ((JetRptTemplatibleContainer)object7).getChildren();
                Vector<Object> vector = new Vector<Object>();
                Iterator iterator = ((Vector)object6).iterator();
                while (iterator.hasNext()) {
                    object5 = (JetObject)iterator.next();
                    if (!(object5 instanceof JetRptVCTLegend)) continue;
                    object4 = (JetRptVCTLegend)object5;
                    object3 = new Vector();
                    int n = ((JetRptVCTLegend)object4).getLegendType();
                    object2 = ((JetRptTemplatibleContainer)object4).getChildren();
                    Object object13 = ((Vector)object2).iterator();
                    while (object13.hasNext()) {
                        String string3;
                        object = (JetObject)object13.next();
                        if (!(object instanceof JetRptVCTLegendPattern)) continue;
                        JetRptVCTLegendPattern jetRptVCTLegendPattern = (JetRptVCTLegendPattern)object;
                        String string4 = jetRptVCTLegendPattern.getBlColumnName();
                        BLNode bLNode = scope.getBLNodeByQualifiedDisplayName(string4);
                        if (bLNode instanceof MeasureInfo) {
                            string3 = ((MeasureInfo)bLNode).getRefMappingName();
                            int n2 = Aggregation.getFunctionCode(((MeasureInfo)bLNode).getAggFunction());
                            EdgeMeasureInfo edgeMeasureInfo = new EdgeMeasureInfo(string4, string3, n2);
                            ((Vector)object3).addElement(edgeMeasureInfo);
                            continue;
                        }
                        string3 = null;
                        EdgeDimInfo edgeDimInfo = new EdgeDimInfo(string4, (EdgeSortInfo)((Object)string3));
                        ((Vector)object3).addElement(edgeDimInfo);
                    }
                    object13 = new LegendInfo(n, (Vector)object3);
                    vector.addElement(object13);
                }
                vCTInfo.addLegendInfos(i, vector);
            }
            JetRptVCTFilters jetRptVCTFilters = jetRptVCTObject.getVCTFilterContainer();
            if (jetRptVCTFilters != null) {
                try {
                    object7 = OnScreenFilterTool.buildOnScreenFilterExpression_VCT(scope, jetRptVCTFilters.getAllVCTFilters(), jetRptVCTObject);
                    vCTInfo.setVCTFilter((IExpression)object7);
                }
                catch (ConditionException conditionException) {
                    if (!JRLog.isError(2)) break block18;
                    JRLog.error(2, conditionException);
                }
            }
        }
        object7 = jetRptVCTObject.getVCTSorterContainer();
        object6 = ((JetRptVCTSorters)object7).getAllVCTSorters();
        ListIterator listIterator = object6.listIterator();
        while (listIterator.hasNext()) {
            JetRptVCTSorter jetRptVCTSorter = (JetRptVCTSorter)listIterator.next();
            object5 = jetRptVCTSorter.getBLSortFieldName();
            object4 = new EdgeSortInfo();
            ((EdgeSortInfo)object4).setSortOrder(jetRptVCTSorter.getSortOrder());
            ((EdgeSortInfo)object4).setSortByOther(jetRptVCTSorter.isSortByOther());
            if (jetRptVCTSorter.isSortByOther()) {
                object3 = jetRptVCTSorter.getBLSortByFldName();
                BLNode bLNode = scope.getBLNodeByQualifiedDisplayName((String)object3);
                if (bLNode instanceof MeasureInfo) {
                    object2 = ((MeasureInfo)bLNode).getRefMappingName();
                    int n = Aggregation.getFunctionCode(((MeasureInfo)bLNode).getAggFunction());
                    object = new AggregationKey(n, (String)object2);
                    ((AggregationKey)object).setMeasureName((String)object3);
                    ((EdgeSortInfo)object4).setSortByOtherFld((AggregationKey)object);
                }
                ((EdgeSortInfo)object4).setGivenMem(jetRptVCTSorter.getGivenMember());
            }
            ((EdgeSortInfo)object4).setCustomizeOrder(jetRptVCTSorter.isCustomizedOrder());
            if (jetRptVCTSorter.isCustomizedOrder()) {
                ((EdgeSortInfo)object4).setCustValueList(jetRptVCTSorter.getCustomizedValueList());
            }
            vCTInfo.addSortInfos((String)object5, (EdgeSortInfo)object4);
            if (!JRLog.isTrace(5)) continue;
            JRLog.trace(5, string + "***createVCTEdgeInfo ... collect sortInfo *** for name = " + (String)object5 + ", " + "sortInfo = " + object4);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createVCTEdgeInfo ... end *** for vct = " + jetRptVCTObject + ", vctInfo = " + vCTInfo);
        }
        return vCTInfo;
    }

    public static CubeViewModel createCubeViewModel(VCTInfo vCTInfo, IExpression iExpression, List list) throws DSException, ConditionException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Integer> hashMap;
        Object object5;
        HashMap<Object, Integer> hashMap2;
        Object object62;
        String string = "[EngineTools_VCT]";
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createCubeViewModel ... begin *** for vctInfo = " + vCTInfo + " , envFilter = " + iExpression);
        }
        CubeViewModel cubeViewModel = CubeViewFactory.createCubeViewModel();
        Template_dataInfoMapImpl template_dataInfoMapImpl = new Template_dataInfoMapImpl();
        template_dataInfoMapImpl.setDisplayTypeScope(vCTInfo.getDisplayTypeScope());
        Edge_MapInfoImpl edge_MapInfoImpl = new Edge_MapInfoImpl();
        HashMap<Object, Integer> hashMap3 = new HashMap<Object, Integer>();
        HashMap<String, Integer> hashMap4 = new HashMap<String, Integer>();
        Vector vector = vCTInfo.getColDimEdgeInfo();
        if (vector != null) {
            int n = 0;
            for (Object object62 : vector) {
                String string2 = ((EdgeInfo)object62).getQualifyDisplayName().toUpperCase();
                hashMap2 = EngineTools.GROUPINFO_CHART_CATEGORY(vCTInfo.getSortInfo(string2));
                cubeViewModel.addDimensionOnColumnEdge(((EdgeInfo)object62).getQualifyDisplayName().toUpperCase(), (SortInfo)((Object)hashMap2));
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnColumnEdge... name = " + string2 + ", " + "sInfo = " + hashMap2);
                }
                int n2 = EngineTools.GroupInfo_DELIMITER(hashMap4, ((EdgeInfo)object62).getQualifyDisplayName());
                object5 = ((EdgeInfo)object62).getQualifyDisplayName() + n2;
                hashMap3.put(object5, new Integer(n++));
                hashMap4.put(((EdgeInfo)object62).getQualifyDisplayName(), new Integer(n2));
            }
        }
        edge_MapInfoImpl.setDimensionMapTable(hashMap3);
        HashMap<String, Integer> hashMap5 = new HashMap<String, Integer>();
        HashMap hashMap6 = new HashMap();
        object62 = vCTInfo.getColMeasureEdgeInfo();
        if (object62 != null) {
            int n = 0;
            hashMap2 = new Vector();
            Iterator iterator = ((Vector)object62).iterator();
            while (iterator.hasNext()) {
                object5 = (EdgeMeasureInfo)iterator.next();
                hashMap = new AggregationKey(((EdgeMeasureInfo)object5).getAggFunction(), ((EdgeMeasureInfo)object5).getBasedFieldName());
                ((AggregationKey)((Object)hashMap)).setMeasureName(((EdgeInfo)object5).getQualifyDisplayName().toUpperCase());
                ((Vector)((Object)hashMap2)).addElement(hashMap);
                int n3 = EngineTools.GroupInfo_DELIMITER(hashMap6, ((EdgeInfo)object5).getQualifyDisplayName());
                object4 = ((EdgeInfo)object5).getQualifyDisplayName() + n3;
                hashMap5.put((String)object4, new Integer(n++));
                hashMap6.put(((EdgeInfo)object5).getQualifyDisplayName(), new Integer(n3));
            }
            cubeViewModel.addDimensionOnColumnEdge("Measure", (List)((Object)hashMap2));
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnColumnEdge...  for measure, name = " + "Measure" + ", " + "vecAggKeys = " + hashMap2);
            }
        }
        edge_MapInfoImpl.setMeasureMapTable(hashMap5);
        template_dataInfoMapImpl.setEdge_MapInfo((short)0, new Edge_MapInfo[]{edge_MapInfoImpl});
        Edge_MapInfoImpl edge_MapInfoImpl2 = new Edge_MapInfoImpl();
        hashMap2 = new HashMap<Object, Integer>();
        HashMap<String, Integer> hashMap7 = new HashMap<String, Integer>();
        vector = vCTInfo.getRowDimEdgeInfo();
        if (vector != null) {
            int n = 0;
            for (EdgeDimInfo edgeDimInfo : vector) {
                object4 = edgeDimInfo.getQualifyDisplayName().toUpperCase();
                object3 = EngineTools.GROUPINFO_CHART_CATEGORY(vCTInfo.getSortInfo((String)object4));
                cubeViewModel.addDimensionOnRowEdge((String)object4, (SortInfo)object3);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnRowEdge... name = " + (String)object4 + ", " + "sInfo = " + object3);
                }
                int n4 = EngineTools.GroupInfo_DELIMITER(hashMap7, edgeDimInfo.getQualifyDisplayName());
                object2 = edgeDimInfo.getQualifyDisplayName() + n4;
                hashMap2.put(object2, new Integer(n++));
                hashMap7.put(edgeDimInfo.getQualifyDisplayName(), new Integer(n4));
            }
        }
        edge_MapInfoImpl2.setDimensionMapTable(hashMap2);
        HashMap<Object, Integer> hashMap8 = new HashMap<Object, Integer>();
        hashMap = new HashMap<String, Integer>();
        object62 = vCTInfo.getRowMeasureEdgeInfo();
        if (object62 != null) {
            int n = 0;
            object4 = new Vector();
            object3 = ((Vector)object62).iterator();
            while (object3.hasNext()) {
                EdgeMeasureInfo edgeMeasureInfo = (EdgeMeasureInfo)object3.next();
                object2 = new AggregationKey(edgeMeasureInfo.getAggFunction(), edgeMeasureInfo.getBasedFieldName());
                ((AggregationKey)object2).setMeasureName(edgeMeasureInfo.getQualifyDisplayName().toUpperCase());
                ((Vector)object4).addElement(object2);
                int n5 = EngineTools.GroupInfo_DELIMITER(hashMap, edgeMeasureInfo.getQualifyDisplayName());
                object = edgeMeasureInfo.getQualifyDisplayName() + n5;
                hashMap8.put(object, new Integer(n++));
                hashMap.put(edgeMeasureInfo.getQualifyDisplayName(), new Integer(n5));
            }
            cubeViewModel.addDimensionOnRowEdge("Measure", (List)object4);
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnRowEdge... for measure, name = " + "Measure" + ", " + "vecAggKeys = " + object4);
            }
        }
        edge_MapInfoImpl2.setMeasureMapTable(hashMap8);
        template_dataInfoMapImpl.setEdge_MapInfo((short)1, new Edge_MapInfo[]{edge_MapInfoImpl2});
        Hashtable hashtable = vCTInfo.getAllLegendInfos();
        if (hashtable != null) {
            object4 = new Edge_MapInfo[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (Integer)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(object2);
                object = new Edge_MapInfoImpl();
                int n6 = 0;
                int n7 = 0;
                HashMap<String, Integer> hashMap9 = new HashMap<String, Integer>();
                HashMap<String, Integer> hashMap10 = new HashMap<String, Integer>();
                LegendIndexTableImpl legendIndexTableImpl = new LegendIndexTableImpl();
                legendIndexTableImpl.setDisplayTypeIndex((Integer)object2);
                HashMap<String, Integer> hashMap11 = new HashMap<String, Integer>();
                HashMap<String, Integer> hashMap12 = new HashMap<String, Integer>();
                for (int i = 0; i < vector2.size(); ++i) {
                    LegendInfo legendInfo = (LegendInfo)vector2.elementAt(i);
                    Vector vector3 = legendInfo.getLegendEdgeInfos();
                    Vector<Integer> vector4 = new Vector<Integer>();
                    Vector<Integer> vector5 = new Vector<Integer>();
                    boolean bl = false;
                    int n8 = legendInfo.getLegendType();
                    if (n8 == 1 || n8 == 4) {
                        bl = true;
                        ++n;
                    }
                    Vector<Object> vector6 = null;
                    for (EdgeInfo edgeInfo : vector3) {
                        Object object7;
                        EdgeInfo edgeInfo2;
                        if (edgeInfo instanceof EdgeMeasureInfo) {
                            edgeInfo2 = (EdgeMeasureInfo)edgeInfo;
                            if (vector6 == null) {
                                vector6 = new Vector<Object>();
                            }
                            object7 = new AggregationKey(((EdgeMeasureInfo)edgeInfo2).getAggFunction(), ((EdgeMeasureInfo)edgeInfo2).getBasedFieldName());
                            ((AggregationKey)object7).setMeasureName(edgeInfo2.getQualifyDisplayName().toUpperCase());
                            vector6.addElement(object7);
                            int n9 = EngineTools.GroupInfo_DELIMITER(hashMap11, edgeInfo2.getQualifyDisplayName());
                            String string3 = edgeInfo2.getQualifyDisplayName() + n9;
                            hashMap9.put(string3, new Integer(n6));
                            hashMap11.put(edgeInfo2.getQualifyDisplayName(), new Integer(n9));
                            vector4.addElement(n6);
                            ++n6;
                            continue;
                        }
                        if (!(edgeInfo instanceof EdgeDimInfo)) continue;
                        edgeInfo2 = (EdgeDimInfo)edgeInfo;
                        object7 = edgeInfo2.getQualifyDisplayName().toUpperCase();
                        SortInfo sortInfo = EngineTools.GROUPINFO_CHART_CATEGORY(vCTInfo.getSortInfo((String)object7));
                        if (bl) {
                            cubeViewModel.addDimensionOnLegendEdge((String)object7, sortInfo, n);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnLegendEdge... name = " + (String)object7 + ", " + "sInfo = " + sortInfo + " , which is before apply filter: indentifyKey = " + n);
                            }
                        } else {
                            cubeViewModel.addDimensionOnLegendEdge((String)object7, sortInfo);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnLegendEdge... name = " + (String)object7 + ", " + "sInfo = " + sortInfo);
                            }
                        }
                        int n10 = EngineTools.GroupInfo_DELIMITER(hashMap12, edgeInfo2.getQualifyDisplayName());
                        String string4 = edgeInfo2.getQualifyDisplayName() + n10;
                        hashMap10.put(string4, new Integer(n7));
                        hashMap12.put(edgeInfo2.getQualifyDisplayName(), new Integer(n10));
                        vector5.addElement(n7);
                        ++n7;
                    }
                    if (vector6 != null) {
                        if (bl) {
                            cubeViewModel.addDimensionOnLegendEdge("Measure", vector6, n);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnRowEdge... for measure, name = " + "Measure" + ", " + "vecAggKeys = " + vector6 + " , which is before apply filter: indentifyKey = " + n);
                            }
                        } else {
                            cubeViewModel.addDimensionOnLegendEdge("Measure", vector6);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnRowEdge... for measure, name = " + "Measure" + ", " + "vecAggKeys = " + vector6);
                            }
                        }
                    }
                    legendIndexTableImpl.addLegendBindDimIndexList(EngineTools.GROUPINFO_CHART_MOTION(n8), EngineTools.GROUPINFO_CHART_SERIES(vector5));
                    legendIndexTableImpl.addLegendBindMeaIndexList(EngineTools.GROUPINFO_CHART_MOTION(n8), EngineTools.GROUPINFO_CHART_SERIES(vector4));
                }
                ((Edge_MapInfoImpl)object).setDimensionMapTable(hashMap10);
                ((Edge_MapInfoImpl)object).setMeasureMapTable(hashMap9);
                ((Edge_MapInfoImpl)object).setLegendMap(legendIndexTableImpl);
                object4[((Integer)object2).intValue()] = object;
            }
            template_dataInfoMapImpl.setEdge_MapInfo((short)2, (Edge_MapInfo[])object4);
        }
        cubeViewModel.setTemplate_DataInfoTable(template_dataInfoMapImpl);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createCubeViewModel*** dataInfoMap... " + template_dataInfoMapImpl);
        }
        object4 = vCTInfo.getVCTFilter();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createCubeViewModel*** vctFilter for vct is: " + vCTInfo.getVCTFilter());
        }
        if (iExpression != null) {
            object4 = object4 == null ? iExpression : ExpressionToolKit.buildAndExpression((IExpression)object4, iExpression);
        }
        cubeViewModel.setDimensionFilter((IExpression)object4);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createCubeViewModel*** dimFilter ***: " + object4);
        }
        if (list != null) {
            for (String string5 : list) {
                cubeViewModel.addDimensionOnOCFilter(string5);
                if (!JRLog.isTrace(5)) continue;
                JRLog.trace(5, string + "***createCubeViewModel*** addDimensionOnOCFilter... for dimension, name = " + string5);
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, string + "***createCubeViewModel ... end *** for vctInfo = " + vCTInfo);
        }
        return cubeViewModel;
    }

    private static SortInfo GROUPINFO_CHART_CATEGORY(EdgeSortInfo edgeSortInfo) {
        String string = "[EngineTools_VCT]";
        SortInfo sortInfo = null;
        if (edgeSortInfo != null) {
            int n;
            int n2 = n = edgeSortInfo.getSortOrder() != 2 ? 0 : 1;
            if (!edgeSortInfo.isCustomizeOrder()) {
                if (edgeSortInfo.isSortByOther()) {
                    sortInfo = CubeViewFactory.createSortInfo(n, edgeSortInfo.getSortByOther(), new TreeMap(edgeSortInfo.getGivenMem()));
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, string + " \t\tcreateSortInfoForCubeViewModel...(sortByOther):" + " sortOrder = " + GroupModel.getStringForOrder(n) + ", sortBy = " + edgeSortInfo.getSortByOther() + ", givenMem = " + edgeSortInfo.getGivenMem());
                    }
                } else {
                    sortInfo = CubeViewFactory.createSortInfo(n);
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, string + " \t\tcreateSortInfoForCubeViewModel...(sortNormal):" + " sortOrder = " + GroupModel.getStringForOrder(n));
                    }
                }
            } else {
                sortInfo = CubeViewFactory.createSortInfo(n, edgeSortInfo.getCustValueList());
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, string + " \t\tcreateSortInfoForCubeViewModel...(customizeOrder):" + " sortOrder = " + GroupModel.getStringForOrder(n) + ", custValueList = " + edgeSortInfo.getCustValueList());
                }
            }
        }
        return sortInfo;
    }

    private static short GROUPINFO_CHART_MOTION(int n) {
        short s = -1;
        switch (n) {
            case 0: {
                s = 16;
                break;
            }
            case 1: {
                s = 17;
                break;
            }
            case 3: {
                s = 18;
                break;
            }
            case 5: {
                s = 19;
                break;
            }
            case 2: {
                s = 20;
                break;
            }
            case 4: {
                s = 21;
            }
        }
        return s;
    }

    private static int[] GROUPINFO_CHART_SERIES(Vector vector) {
        int[] nArray = null;
        if (vector != null) {
            nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray[i] = (Integer)vector.elementAt(i);
            }
        }
        return nArray;
    }

    private static int GroupInfo_DELIMITER(HashMap hashMap, String string) {
        Integer n = (Integer)hashMap.get(string);
        int n2 = 0;
        n2 = n != null ? n + 1 : 0;
        return n2;
    }

    public static IDataContainer getDataContainer(JetObject jetObject) {
        if (jetObject == null) {
            return null;
        }
        if (jetObject instanceof IDataContainer && ObjectLogicFactory.getDataContainerLogic().isBindDataContainer(jetObject)) {
            return (IDataContainer)((Object)jetObject);
        }
        JetObject jetObject2 = (JetObject)((Object)ObjectLogicFactory.getDataContainerLogic().getDataContainer(jetObject, true));
        return EngineTools.getDataContainer(jetObject2);
    }

    public static String getLinkObjectKey(JetObject jetObject) {
        JetObject jetObject2 = jetObject;
        while (jetObject2 != null && (!(jetObject2 instanceof IDataContainer) || ReportTools.isRealDataInherit((IDataContainer)((Object)jetObject2)))) {
            jetObject2 = (JetObject)((Object)ObjectLogicFactory.getDataContainerLogic().getDataContainer((JetRptObject)jetObject2, true));
        }
        String string = "";
        if (jetObject2 != null) {
            string = jetObject2.getInstName();
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, "EngineTools.getLinkObjectKey(...):  Can not find root non-dataInherit data container. object is: " + EngineTools.printObject(jetObject));
        }
        return string;
    }

    public static Vector[] collectResourceListFromSubLinks(List list, int n) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        boolean bl = false;
        if (n == 2) {
            bl = true;
        }
        for (int i = 0; i < list.size(); ++i) {
            JetRptSubLink jetRptSubLink = (JetRptSubLink)list.get(i);
            String string = null;
            boolean bl2 = false;
            if (!bl) {
                string = jetRptSubLink.getMainColumn();
                bl2 = false;
            } else {
                bl2 = true;
                string = jetRptSubLink.blMainColumn.get();
                if (StringTools.nullOrAllSpaces(string)) {
                    string = jetRptSubLink.getMainColumn();
                    bl2 = false;
                }
            }
            if (!bl2) {
                vectorArray[0].addElement(string);
                continue;
            }
            vectorArray[1].addElement(string);
        }
        return vectorArray;
    }

    public static Vector createHeaderInfo(Vector vector, Vector vector2, Hashtable hashtable, Hashtable hashtable2, ResourceLocator resourceLocator, HashSet hashSet, RecordModelInfo recordModelInfo) {
        Vector<HeaderLevel> vector3 = new Vector<HeaderLevel>();
        HeaderLevel headerLevel = null;
        for (JetRptCTHdDBField jetRptCTHdDBField : vector) {
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            String string2 = null;
            int n = jetRptCTHdDBField.getIndex();
            if (vector2 != null && n < vector2.size()) {
                string2 = (String)vector2.get(n);
            }
            Vector<Object> vector4 = new Vector<Object>();
            Vector[] vectorArray = (Vector[])hashtable.get(jetRptCTHdDBField.getInstName());
            if (vectorArray != null && vectorArray[EngineConstantDef.TYPE_CONTROL] != null) {
                object4 = vectorArray[EngineConstantDef.TYPE_CONTROL].iterator();
                while (object4.hasNext()) {
                    string = (String)object4.next();
                    object3 = (JetRptCTFormula)resourceLocator.getRptCTFormulaByDisplayName(string);
                    object2 = ((JetRptAbstractFormula)object3).getJetUFormula().getRptFormula();
                    object = new CTFormula((JetRptFormula)object2);
                    vector4.addElement(object);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0 && (object4 = (Vector)hashtable2.get(jetRptCTHdDBField.getInstName())) != null) {
                for (int i = 0; i < ((Vector)object4).size(); ++i) {
                    object3 = (JetRptFormula)((Vector)object4).get(i);
                    object2 = new CTFormula((JetRptFormula)object3);
                    vector4.addElement(object2);
                }
            }
            boolean bl = false;
            if (resourceLocator.getDataResourceType() != 0 && jetRptCTHdDBField.blColumnName != null && hashSet != null && hashSet.contains(jetRptCTHdDBField.blColumnName.get())) {
                bl = true;
            }
            string = jetRptCTHdDBField.runtimeColumnName.get();
            object3 = null;
            if (recordModelInfo != null) {
                object2 = recordModelInfo.getColDescs();
                for (int i = 0; i < ((DbColDesc[])object2).length; ++i) {
                    if (!object2[i].getColName().equalsIgnoreCase(string)) continue;
                    object3 = (DbColDesc)object2[i].clone();
                    break;
                }
            } else {
                object2 = resourceLocator.getUniverse();
                object = new QueryInfoImpl("", resourceLocator.getDataSourceName(), resourceLocator.getQueryName(), resourceLocator.getBlName(), resourceLocator.getDataResourceType());
                object3 = EngineTools.getSQLType((JetUUniverse)object2, (QueryInfo)object, string);
            }
            headerLevel = new HeaderLevel(string, (DbColDesc)object3, bl, string2, jetRptCTHdDBField.sortOrder.get(), vector4);
            vector3.addElement(headerLevel);
        }
        return vector3;
    }

    public static Vector[] sortCtfFormulaRelations(ResourceLocator resourceLocator, Vector vector, Vector vector2) {
        Vector[] vectorArray;
        Vector vector3 = EngineTools.I(resourceLocator, vector2);
        Vector<JetRptCTFormula> vector4 = new Vector<JetRptCTFormula>();
        if (vector != null && resourceLocator != null) {
            int n;
            vectorArray = new Vector();
            for (n = 0; n < vector.size(); ++n) {
                JetRptCTFormula jetRptCTFormula = (JetRptCTFormula)resourceLocator.getRptCTFormulaByDisplayName((String)vector.get(n));
                vectorArray.add(jetRptCTFormula);
            }
            while (EngineTools.KEYNAME_CATEGORY((Vector)vectorArray)) {
            }
            for (n = 0; n < vectorArray.size(); ++n) {
                vector4.add((JetRptCTFormula)vectorArray.get(n));
            }
        }
        vectorArray = new Vector[]{vector4, vector3};
        return vectorArray;
    }

    private static Vector I(ResourceLocator resourceLocator, Vector vector) {
        Vector<MeasureInfo> vector2 = new Vector<MeasureInfo>();
        if (vector != null && resourceLocator != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                BLNode bLNode = resourceLocator.getBLNodeByMappingName(string);
                MeasureInfo measureInfo = (MeasureInfo)bLNode;
                vector2.add(measureInfo);
            }
        }
        return vector2;
    }

    private static boolean KEYNAME_CATEGORY(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JetRptCTFormula jetRptCTFormula = (JetRptCTFormula)vector.get(i);
            for (int j = i + 1; j < n; ++j) {
                JetRptCTFormula jetRptCTFormula2 = (JetRptCTFormula)vector.get(j);
                if (!EngineTools.KEYNAME_MOTION(jetRptCTFormula, jetRptCTFormula2)) continue;
                vector.remove(i);
                vector.insertElementAt(jetRptCTFormula, j);
                return true;
            }
        }
        return false;
    }

    private static boolean KEYNAME_MOTION(JetRptCTFormula jetRptCTFormula, JetRptCTFormula jetRptCTFormula2) {
        Vector vector = jetRptCTFormula.getJetUFormula().formulainfo.refMeasureExpression;
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            MeasureExpression measureExpression = (MeasureExpression)vector.get(i);
            if (measureExpression.getMeasureType() != 2 || !(string = measureExpression.getMeasureName()).equalsIgnoreCase(jetRptCTFormula2.getMappingName())) continue;
            return true;
        }
        return false;
    }

    public static JetRptObject getGroupTemplateGUIInfo(JetObject jetObject) {
        Object object;
        Object object2;
        JetObject jetObject2;
        Object object3;
        JRObjectTemplate jRObjectTemplate;
        int n = -1;
        if (jetObject instanceof JRObjectTemplate && !(jetObject instanceof JetRptChartPlatform)) {
            jRObjectTemplate = (JRObjectTemplate)jetObject;
            n = jRObjectTemplate.iNRecordLocation;
        }
        jRObjectTemplate = null;
        JetRptSection jetRptSection = null;
        if (n == 1 || n == 2) {
            object3 = null;
            jetObject2 = jetObject;
            while (jetObject2 != null) {
                if (jetObject2 instanceof JetRptSectionObject) {
                    object3 = (JetRptSectionObject)jetObject2;
                    break;
                }
                jetObject2 = (JetObject)((Object)ObjectLogicFactory.getDataContainerLogic().getDataContainer(jetObject2, true));
            }
            if (object3 != null) {
                object2 = ((JetRptSectionObject)object3).getPage();
                object = ((JetRptBreakContainer)object2).getHeaders();
                if (((Vector)object).size() > 0) {
                    jRObjectTemplate = (JetRptSection)((Vector)object).firstElement();
                }
                if (((Vector)(object = ((JetRptBreakContainer)object2).getFooters())).size() > 0) {
                    jetRptSection = (JetRptSection)((Vector)object).firstElement();
                }
            }
        }
        object3 = null;
        switch (n) {
            case 1: {
                object3 = jRObjectTemplate;
                break;
            }
            case 2: {
                object3 = jetRptSection;
                break;
            }
            default: {
                object3 = EngineTools.getGroupTemplateByObject(jetObject);
            }
        }
        if (jetObject instanceof JetRptChartPlatform && ((JetRptChartPlatform)jetObject).getDefinition().isHeatMapChart()) {
            jetObject2 = ((JetRptChartPlatform)jetObject).getPaper();
            object = object2 = ((JetRptChartPaper)jetObject2).getGroupRectangle();
            while (object != null) {
                object2 = object;
                object = ((JetRptChartGroupRect)object2).getNextChartGroupRect();
            }
            if (object2 != null) {
                object3 = object2;
            }
        }
        return object3;
    }

    public static String getBreakContainerInstanceName(JetRptObject jetRptObject) {
        String string = null;
        if (jetRptObject != null) {
            if (jetRptObject instanceof JetRptSection) {
                string = ((JetObject)((Object)jetRptObject.getParent())).getInstName();
            } else if (jetRptObject instanceof JetRptBreakContainer) {
                string = jetRptObject.getInstName();
            }
        }
        return string;
    }

    public static String getTemplateUIInfo(JetObject jetObject) {
        IDataContainer iDataContainer = EngineTools.getDataContainer(jetObject);
        JetRptObject jetRptObject = EngineTools.getGroupTemplateGUIInfo(jetObject);
        return EngineTools.getTemplateUIInfoWithGroupUI(iDataContainer, jetRptObject);
    }

    public static String getTemplateUIInfoWithGroupUI(IDataContainer iDataContainer, JetRptObject jetRptObject) {
        String string = null;
        if (jetRptObject != null) {
            string = EngineTools.getBreakContainerInstanceName(jetRptObject);
        }
        if (string == null) {
            string = iDataContainer.getInstName();
        }
        return string;
    }

    public static String getTemplateUIInfo(IDataContainer iDataContainer, String string) {
        String string2 = null;
        string2 = string != null && string.trim().length() > 0 ? iDataContainer.getInstName() + EngineConstantDef.GroupInfo_DELIMITER + string : iDataContainer.getInstName();
        return string2;
    }

    public static JetRptObject getGroupTemplateByObject(JetObject jetObject) {
        JetRptObject jetRptObject = null;
        boolean bl = true;
        JetObject jetObject2 = jetObject;
        while (jetObject2 != null && !(jetObject2 instanceof JetRptSection) && !(jetObject2 instanceof JetRptBreakContainer) && !(jetObject2 instanceof JetRptColumn) && bl) {
            if (!((jetObject2 = (JetObject)((Object)jetObject2.getParent())) instanceof IDataContainer) || jetObject2 instanceof JetRptSection || ReportTools.isRealDataInherit((IDataContainer)((Object)jetObject2))) continue;
            bl = false;
        }
        if (jetObject2 != null) {
            if (jetObject2 instanceof JetRptSection) {
                jetRptObject = (JetRptSection)jetObject2;
            } else if (jetObject2 instanceof JetRptBreakContainer) {
                Vector vector = ((JetRptBreakContainer)jetObject2).getHeaders();
                jetRptObject = vector != null && vector.size() > 0 ? (JetRptSection)vector.elementAt(0) : (JetRptBreakContainer)jetObject2;
            } else if (jetObject2 instanceof JetRptColumn) {
                jetRptObject = null;
            }
        }
        return jetRptObject;
    }

    public static String getGroupInfoKey(GroupStructionInfo groupStructionInfo) {
        String string = null;
        String string2 = groupStructionInfo.getKeyName();
        if (string2 != null) {
            if (string2.endsWith(GroupStructionInfo.KEYNAME_SERIES)) {
                string = EngineConstantDef.GROUPINFO_CHART_SERIES;
            } else if (string2.endsWith(GroupStructionInfo.KEYNAME_CATEGORY)) {
                string = EngineConstantDef.GROUPINFO_CHART_CATEGORY;
            } else if (string2.endsWith(GroupStructionInfo.KEYNAME_MOTION)) {
                string = EngineConstantDef.GROUPINFO_CHART_MOTION;
            }
        }
        return string;
    }

    public static boolean hasSameCatalog(JetUUniverse jetUUniverse, JetUUniverse jetUUniverse2) {
        boolean bl = false;
        if (jetUUniverse2 == null && jetUUniverse == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "EngineTools.hasSameCatalog(...):  oldUni = " + jetUUniverse2 + "; uni = " + jetUUniverse + "; ret = " + true);
            }
            return true;
        }
        if (jetUUniverse2 != null && jetUUniverse != null) {
            String string = jetUUniverse2.getFullFileName();
            String string2 = jetUUniverse.getFullFileName();
            long l = new File(string).lastModified();
            long l2 = new File(string2).lastModified();
            if (string.equals(string2) && l == l2) {
                bl = true;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "EngineTools.hasSameCatalog(...):  path(old) = " + string + " ; current path = " + string2 + "; lastMT = " + l + "; tempLastMT" + "; so ret = " + bl);
            }
            return bl;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "EngineTools.hasSameCatalog(...):  oldUni = " + jetUUniverse2 + "; uni = " + jetUUniverse + "; ret = " + bl);
        }
        return bl;
    }

    public static Hashtable getAllParamsForValueChange(IReport iReport, JetUUniverse jetUUniverse) {
        Hashtable hashtable = new Hashtable();
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        List[] listArray = reportLogic.getOnParameterValueChangeResourceMap(iReport);
        if (listArray != null) {
            List list = listArray[0];
            List list2 = listArray[1];
            for (int i = 0; i < list.size(); ++i) {
                QueryInfo queryInfo = (QueryInfo)list.get(i);
                String string = (String)list2.get(i);
                boolean bl = queryInfo.getDataResoureType() == 2;
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                List list3 = ResourceTool.getParameterNames(jetUUniverse, iReport, queryInfo, vector, bl, false);
                String string2 = queryInfo.getDatasourceName();
                if (list3 == null || list3.isEmpty()) continue;
                Hashtable<String, ParamDesc> hashtable2 = (Hashtable<String, ParamDesc>)hashtable.get(string2);
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable<String, ParamDesc>();
                    hashtable.put(string2, hashtable2);
                }
                for (String string3 : list3) {
                    Object object;
                    if (hashtable2.containsKey(string3.toUpperCase()) || !((object = ReportTools.getResourceObject(jetUUniverse, iReport, queryInfo, string3, false, null, null)) instanceof JetUParameter)) continue;
                    hashtable2.put(string3.toUpperCase(), ((JetUParameter)object).getParamDesc());
                }
            }
        }
        return hashtable;
    }

    public static int getBusinessType(int n) {
        int n2 = -1;
        if (n == 2) {
            n2 = 3;
        }
        return n2;
    }

    public static HashSet getDenyList(JDenyListProvider jDenyListProvider, CatalogKey catalogKey, QueryInfo queryInfo, ISecurityProvider iSecurityProvider) {
        String string = queryInfo.getDatasourceName();
        String string2 = queryInfo.getQueryName();
        String string3 = queryInfo.getBLName();
        int n = queryInfo.getDataResoureType();
        int n2 = EngineTools.getBusinessType(n);
        MemberSecurityEntry memberSecurityEntry = null;
        if (iSecurityProvider != null) {
            memberSecurityEntry = iSecurityProvider.getMemberSecurity(queryInfo);
        }
        if (jDenyListProvider != null) {
            return jDenyListProvider.getDenyList(catalogKey, string, string3, memberSecurityEntry);
        }
        return null;
    }

    public static Vector getAllGroupModel(GroupModel groupModel) {
        Vector vector = new Vector();
        EngineTools.KEYNAME_SERIES(groupModel, vector);
        return vector;
    }

    private static void KEYNAME_SERIES(GroupModel groupModel, Vector vector) {
        if (groupModel != null) {
            Vector vector2 = null;
            for (GroupModel groupModel2 = groupModel; groupModel2 != null; groupModel2 = groupModel2.nextGroupModel()) {
                vector.addElement(groupModel2);
                if (!(groupModel2 instanceof ParaGroupModel) || (vector2 = ((ParaGroupModel)groupModel2).getSiblings()) == null) continue;
                for (int i = 0; i < vector2.size(); ++i) {
                    EngineTools.KEYNAME_SERIES((GroupModel)vector2.elementAt(i), vector);
                }
            }
        }
    }

    public static String getMappingNameForMeasureQualifyDisName(String string) {
        return Prefix__MeasureMappingName + string;
    }

    public static String getQualifyDisNameForMeasureMappingName(String string) {
        String string2;
        String string3 = string;
        int n = Prefix__MeasureMappingName.length();
        if (string.length() >= n && (string2 = string.substring(0, n)).equalsIgnoreCase(Prefix__MeasureMappingName)) {
            return string.substring(n);
        }
        return string3;
    }

    public static Vector[] getColNameResouceInfoByIExpression(IExpression iExpression) {
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        if (iExpression == null) {
            return vectorArray;
        }
        Vector vector = ExpressionToolKit.getRefChildren(iExpression);
        Vector vector2 = ExpressionToolKit.getFormulaChildren(iExpression);
        Vector vector3 = ExpressionToolKit.getParameterChildren(iExpression);
        Vector vector4 = new Vector();
        if (vector != null) {
            vector4.addAll(vector);
        }
        if (vector2 != null) {
            vector4.addAll(vector2);
        }
        if (vector3 != null) {
            vector4.addAll(vector3);
        }
        for (int i = 0; i < vector4.size(); ++i) {
            boolean bl;
            String string;
            block14: {
                Object e = vector4.get(i);
                string = null;
                bl = false;
                try {
                    IVariableExpression iVariableExpression;
                    if (e instanceof IReference) {
                        iVariableExpression = (IReference)e;
                        string = iVariableExpression.getName().trim();
                        if (iVariableExpression.isQualifyName()) {
                            bl = true;
                        }
                    } else if (e instanceof IFormula) {
                        iVariableExpression = (IFormula)e;
                        string = iVariableExpression.getName().trim();
                    } else if (e instanceof IParameter) {
                        iVariableExpression = (IParameter)e;
                        string = iVariableExpression.getName().trim();
                    }
                }
                catch (ConditionException conditionException) {
                    if (!JRLog.isError(3)) break block14;
                    JRLog.error(3, "get mappingName information from Exception: " + e + "  error ! " + conditionException.getMessage());
                }
            }
            if (!bl) {
                if (vectorArray[0].contains(string)) continue;
                vectorArray[0].addElement(string);
                continue;
            }
            if (vectorArray[1].contains(string)) continue;
            vectorArray[1].addElement(string);
        }
        return vectorArray;
    }

    public static Vector getMappingNameByIExpression(IExpression iExpression, JetRptReport jetRptReport, JetUUniverse jetUUniverse, String string, String string2, int n, String string3) {
        Vector<Object> vector = new Vector<Object>();
        if (iExpression == null) {
            return vector;
        }
        Vector[] vectorArray = EngineTools.getColNameResouceInfoByIExpression(iExpression);
        Scope scope = new Scope(jetRptReport, jetUUniverse, string, string2, string3, n);
        if (vectorArray != null) {
            String string4;
            int n2;
            Vector vector2;
            if (vectorArray[0] != null) {
                vector2 = vectorArray[0];
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    string4 = (String)vector2.elementAt(n2);
                    vector.add(string4);
                }
            }
            if (vectorArray[1] != null) {
                vector2 = vectorArray[1];
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    Object object;
                    JetObject jetObject;
                    string4 = (String)vector2.elementAt(n2);
                    BLNode bLNode = scope.getBLNodeByQualifiedDisplayName(string4);
                    if (bLNode instanceof JetRptFlyFormula) {
                        jetObject = (JetRptFlyFormula)bLNode;
                        object = ((JetRptAbstractFormula)jetObject).getJetUFormula();
                        vector.add(((JetRptAbstractFormula)jetObject).getMappingName());
                        continue;
                    }
                    if (!(bLNode instanceof DataElement)) continue;
                    jetObject = (DataElement)bLNode;
                    object = ((DataElement)jetObject).getRefMappingName();
                    vector.add(object);
                }
            }
        }
        return vector;
    }

    public static Vector buildColNameDataResourceTypeInfo(Vector[] vectorArray, QueryInfo queryInfo, String string) {
        Vector<ColumnNameDataResourceTypeInfo> vector = new Vector<ColumnNameDataResourceTypeInfo>();
        if (vectorArray != null) {
            ColumnNameDataResourceTypeInfo columnNameDataResourceTypeInfo;
            if (vectorArray[0] != null) {
                for (String string2 : vectorArray[0]) {
                    columnNameDataResourceTypeInfo = new ColumnNameDataResourceTypeInfo(string2, queryInfo, false, string);
                    vector.add(columnNameDataResourceTypeInfo);
                }
            }
            if (vectorArray[1] != null) {
                for (String string2 : vectorArray[1]) {
                    columnNameDataResourceTypeInfo = new ColumnNameDataResourceTypeInfo(string2, queryInfo, true, string);
                    vector.add(columnNameDataResourceTypeInfo);
                }
            }
        }
        return vector;
    }

    public static String getQueryName(JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        if (queryInfo == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "EngineTools.getQueryName() is null. for queryInfo is null. ");
            }
            return null;
        }
        String string = queryInfo.getQueryName();
        String string2 = queryInfo.getDatasourceName();
        int n = queryInfo.getDataResoureType();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "EngineTools.getQueryName()..., queryInfo: " + queryInfo + "dataSourceName: " + string2 + " queryName: " + string + " blName: " + queryInfo.getBLName() + " dataResourceType: " + queryInfo.getDataResoureType() + ", for universe = " + jetUUniverse);
        }
        if (n == 2) {
            Scope scope = new Scope(null, jetUUniverse, queryInfo);
            UnifiedBusinessView unifiedBusinessView = scope.getBusinessView();
            if (unifiedBusinessView != null) {
                JetUDemandQuery jetUDemandQuery = unifiedBusinessView.getQuery();
                if (jetUDemandQuery != null) {
                    string = jetUDemandQuery.getResourceName();
                } else {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "EngineTools.getQueryName(...) is empty!  Can not get JetUDemandQuery for ubv: queryInfo is:  " + queryInfo);
                    }
                    string = "";
                }
            } else {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "EngineTools.getQueryName(...) is empty!  Can not get UnifiedBusinessView for ubv: queryInfo is:  " + queryInfo);
                }
                string = "";
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "EngineTools.getQueryName(...) return " + string + ".  queryInfo is:  " + queryInfo + ", universe = " + jetUUniverse);
        }
        return string;
    }

    public static DbColDesc getSQLType(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string) {
        String string2 = queryInfo.getDatasourceName();
        String string3 = EngineTools.getQueryName(jetUUniverse, queryInfo);
        return jetUUniverse.getSQLType(string2, string3, string);
    }

    public static Vector getDirectMappingnames(JetUUniverse jetUUniverse, IReport iReport, IDataContainer iDataContainer, List list, Vector vector, Hashtable hashtable, Hashtable hashtable2) {
        Vector<String> vector2 = new Vector<String>();
        DataSet dataSet = ReportTools.getDataSet((JetRptObject)((Object)iDataContainer));
        if (vector != null) {
            for (ColumnNameDataResourceTypeInfo columnNameDataResourceTypeInfo : vector) {
                String string = columnNameDataResourceTypeInfo.getColumnName();
                if (string == null || string.trim().length() <= 0) continue;
                boolean bl = false;
                QueryInfo queryInfo = columnNameDataResourceTypeInfo.getQueryInfo() == null ? dataSet.getQueryInfo() : columnNameDataResourceTypeInfo.getQueryInfo();
                Object object = ReportTools.getResourceObject(jetUUniverse, iReport, queryInfo, string, columnNameDataResourceTypeInfo.isBLColumName(), list, hashtable2);
                if (object instanceof BLNode) {
                    BLNode bLNode = (BLNode)object;
                    int n = bLNode.getElementType();
                    if (n == 7 || n == 4 || n == 7 || n == 4) {
                        if (object instanceof JetRptFlyFormula) {
                            string = ((JetRptFlyFormula)object).getMappingName().toUpperCase();
                            object = ((JetRptFlyFormula)object).getJetUFormula();
                        } else {
                            string = ((DataElementInfo)bLNode).getRefMappingName().toUpperCase();
                            object = ReportTools.getResourceObject(jetUUniverse, iReport, queryInfo, string, false, list, hashtable2);
                        }
                    } else if (n == 5 || n == 5) {
                        MeasureInfo measureInfo = (MeasureInfo)bLNode;
                        bl = true;
                        string = measureInfo.getMappingName();
                        hashtable.put(string, measureInfo);
                    }
                }
                if (vector2.contains(string.toUpperCase())) continue;
                vector2.addElement(string.toUpperCase());
            }
        }
        return vector2;
    }

    public static MappingNameCollection getAllMappingNamesCollectInfo(JetUUniverse jetUUniverse, IReport iReport, IDataContainer iDataContainer, List list, Vector vector) {
        MappingNameCollection mappingNameCollection;
        block4: {
            mappingNameCollection = new MappingNameCollection();
            DataSet dataSet = ReportTools.getDataSet((JetRptObject)((Object)iDataContainer));
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Vector vector2 = EngineTools.getDirectMappingnames(jetUUniverse, iReport, iDataContainer, list, vector, hashtable, hashtable2);
            if (vector2.size() > 0) {
                try {
                    MappingFldsParseTool mappingFldsParseTool = new MappingFldsParseTool(jetUUniverse, iReport, dataSet.getQueryInfo(), vector2, null, new Vector(), dataSet.getDatasetType(), hashtable2);
                    mappingFldsParseTool.setDynamicSummary(hashtable);
                    Scope scope = new Scope(null, iReport, dataSet);
                    mappingFldsParseTool.setHtOnTheFlyFlms(ReportTools.getHtJetRptFlyFormulaCollection(scope));
                    mappingFldsParseTool.setOnTheFlyParameter(ReportTools.getOnTheFlyParameterCollection(scope));
                    mappingFldsParseTool.setIgnoreParaRefPara(true);
                    mappingFldsParseTool.initialize();
                    Hashtable hashtable3 = new Hashtable();
                    mappingFldsParseTool.prepareStart(hashtable3);
                    Hashtable hashtable4 = mappingFldsParseTool.getHtDbFields();
                    String string = null;
                    Object object = hashtable4.keys();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        mappingNameCollection.addDbField(string.toUpperCase());
                    }
                    object = mappingFldsParseTool.getFormulaContainer();
                    mappingNameCollection.setRptFormulaContainer((RptFormulaContainer)object);
                    mappingNameCollection.setParamBuff(mappingFldsParseTool.getParamsBuff());
                }
                catch (Throwable throwable) {
                    if (!JRLog.isError(2)) break block4;
                    JRLog.error(2, throwable);
                }
            }
        }
        return mappingNameCollection;
    }

    public static Hashtable getHtDcToOnScreenFilters(List list, JetUUniverse jetUUniverse, IReport iReport) {
        Hashtable<String, Vector<OnScreenFilter>> hashtable = new Hashtable<String, Vector<OnScreenFilter>>();
        if (list != null) {
            for (OnScreenFilter onScreenFilter : list) {
                OnScreenFilterLogic onScreenFilterLogic = ObjectLogicFactory.getOnScreenFilterLogic();
                List list2 = onScreenFilterLogic.getOnScreenFilterAppliedTo(jetUUniverse, onScreenFilter, iReport, true);
                for (IDataContainer iDataContainer : list2) {
                    String string = iDataContainer.getInstName();
                    Vector<OnScreenFilter> vector = (Vector<OnScreenFilter>)hashtable.get(string);
                    if (vector == null) {
                        vector = new Vector<OnScreenFilter>();
                        hashtable.put(string, vector);
                    }
                    vector.add(onScreenFilter);
                }
            }
        }
        return hashtable;
    }
}

