/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.util.simpleLayout.paragraphLayoutImpl;

import java.util.Vector;
import jet.rptengine.util.simpleLayout.paragraphLayout.ParagraphContent;
import jet.rptengine.util.simpleLayout.paragraphLayout.ParagraphSimpleLine;
import jet.rptengine.util.simpleLayout.paragraphLayoutImpl.ParagraphControlSymbol;
import jet.rptengine.util.simpleLayout.paragraphLayoutImpl.ParagraphSimpleText;

public class ParagraphSimpleLineImpl
implements ParagraphSimpleLine {
    private Vector SEDU = new Vector();
    public boolean spacingType = true;
    public float spacingLine = 0.0f;

    @Override
    public Vector getElements() {
        return this.SEDU;
    }

    @Override
    public int getLineHeight() {
        if (this.SEDU != null && this.SEDU.size() > 0) {
            int[] nArray = ParagraphSimpleLineImpl.getMaxObjectsHeight(this.SEDU);
            int n = Math.max(nArray[0], nArray[0] - nArray[1] + nArray[2]);
            return n;
        }
        return 0;
    }

    @Override
    public int getMaxLineHeight() {
        return this.getLineSpacing();
    }

    public void addLineElement(ParagraphContent paragraphContent) {
        this.SEDU.add(paragraphContent);
    }

    public static int[] getMaxObjectsHeight(Vector vector) {
        int[] nArray = new int[3];
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof ParagraphSimpleText) {
                nArray[0] = Math.max(nArray[0], ((ParagraphSimpleText)vector.elementAt(i)).getTextHeight());
                nArray[1] = Math.max(nArray[1], ((ParagraphSimpleText)vector.elementAt(i)).getTextBaseLineY());
                continue;
            }
            if (vector.elementAt(i) instanceof ParagraphControlSymbol) {
                nArray[0] = Math.max(nArray[0], ((ParagraphControlSymbol)vector.elementAt(i)).getTabHeight());
                continue;
            }
            nArray[2] = Math.max(nArray[2], ((ParagraphContent)vector.elementAt(i)).getHeight());
        }
        return nArray;
    }

    public void setSpacingLineInfo(boolean bl, float f) {
        this.spacingType = bl;
        this.spacingLine = f;
    }

    public int getLineSpacing() {
        int n = this.getLineHeight();
        int n2 = this.getLineTextHeight();
        if (this.spacingType) {
            return (int)((float)n + (float)n2 * (this.spacingLine - 1.0f));
        }
        if (this.spacingLine > 0.0f) {
            if ((float)n > this.spacingLine) {
                return n;
            }
            return (int)this.spacingLine;
        }
        return (int)Math.abs(this.spacingLine);
    }

    public int getLineTextHeight() {
        if (this.SEDU != null && this.SEDU.size() > 0) {
            return ParagraphSimpleLineImpl.getMaxTextHeight(this.SEDU);
        }
        return 0;
    }

    public static int getMaxTextHeight(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof ParagraphSimpleText)) continue;
            n = Math.max(n, ((ParagraphSimpleText)vector.elementAt(i)).getTextHeight());
        }
        return n;
    }
}

