/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.util.simpleLayout.paragraphLayoutImpl;

import guitools.toolkit.Unit;
import java.awt.Font;
import jet.datastream.ParagraphTools;
import jet.report.JetRptObject;
import jet.rptengine.util.simpleLayout.paragraphLayout.ParagraphContent;
import jet.util.FontSets;

public class ParagraphSimpleText
implements ParagraphContent {
    private String SEDU;
    private Font convertPixelToUnit = null;
    private Font convertUnitToPixel = null;
    private int getFont = 0;
    private int getLeading;
    private boolean getText = true;
    private boolean getTextBaseLineY;
    private int getWidth = -1;
    private int getWidthBeforeFirstDecimalUsePrecision = -1;
    private JetRptObject getWrapPostionUsePrecision;
    private int x;
    private int y;
    private int lastBreakPos;
    private int length;

    public ParagraphSimpleText() {
    }

    public ParagraphSimpleText(String string, Font font) {
        this.SEDU = string;
        this.convertPixelToUnit = font;
    }

    public String getText() {
        String string = this.getLeading == 0 ? this.SEDU.substring(this.getFont) : this.SEDU.substring(this.getFont, this.getLeading + this.getFont);
        return string;
    }

    @Override
    public int getWidth() {
        return this.lastBreakPos;
    }

    @Override
    public int getHeight() {
        return this.length;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public String getAllText() {
        return this.SEDU;
    }

    public void setFont(Font font) {
        this.convertPixelToUnit = font;
    }

    public void setFontWhenScript(Font font) {
        this.convertUnitToPixel = font;
    }

    public void setStartCharNum(int n) {
        this.getFont = n;
    }

    public int getStartCharNum() {
        return this.getFont;
    }

    public void setSplitWidth(int n) {
        this.getLeading = n;
    }

    public int getSplitWidth() {
        return this.getLeading;
    }

    public String getSplitText() {
        if (this.getLeading == 0) {
            return this.SEDU.substring(this.getFont);
        }
        return this.SEDU.substring(this.getFont, this.getLeading + this.getFont);
    }

    public int getTextWidth() {
        if (this.getTextBaseLineY) {
            return this.getWidth();
        }
        if (this.convertUnitToPixel == null) {
            return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.convertPixelToUnit, this.getText));
        }
        return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.convertUnitToPixel, this.getText));
    }

    public int getScriptTextH() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.convertUnitToPixel, this.getText)));
    }

    public int getTextHeight() {
        if (this.getWidth == -1 && this.convertPixelToUnit != null) {
            this.getWidth = Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.convertPixelToUnit, this.getText)));
        }
        return this.getWidth;
    }

    public int getTextHeightWhenScript() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.convertPixelToUnit, this.getText)));
    }

    public int getBeforeDecimalWidth() {
        if (this.convertUnitToPixel == null) {
            return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.convertPixelToUnit, this.getText));
        }
        return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.convertUnitToPixel, this.getText));
    }

    public int[] getWrapPostion(int n) {
        if (this.convertUnitToPixel == null) {
            return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.convertPixelToUnit, Unit.convertUnitToPixel(n), this.getText);
        }
        return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.convertUnitToPixel, Unit.convertUnitToPixel(n), this.getText);
    }

    public int getWrapPostion() {
        return ParagraphTools.lastBreakPos(0, this.getText().length(), this.getText());
    }

    private Font SEDU(int n) {
        Font font = FontSets.getFont("Arial", 1, n);
        return font;
    }

    public Font getTextFont() {
        return this.convertPixelToUnit;
    }

    public Font getScriptFont() {
        return this.convertUnitToPixel;
    }

    @Override
    public JetRptObject getTemplate() {
        return this.getWrapPostionUsePrecision;
    }

    public void setTemplate(JetRptObject jetRptObject) {
        this.getWrapPostionUsePrecision = jetRptObject;
    }

    public void setX(int n) {
        this.x = n;
    }

    public boolean getPrecision() {
        return this.getText;
    }

    public void isHighPrecision(boolean bl) {
        this.getText = bl;
    }

    public void setText(String string) {
        this.SEDU = string;
    }

    public void setScript(boolean bl, boolean bl2) {
    }

    public int getTextBaseLineY() {
        if (this.getWidthBeforeFirstDecimalUsePrecision == -1) {
            this.getWidthBeforeFirstDecimalUsePrecision = (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.convertPixelToUnit));
        }
        return this.getWidthBeforeFirstDecimalUsePrecision;
    }

    public int getScriptBaseLineY() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.convertUnitToPixel));
    }

    public int getTextLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.convertPixelToUnit));
    }

    public int getScriptLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.convertUnitToPixel));
    }
}

