/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.api;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.List;
import jet.formula.JavaFormula;
import jet.icontrols.QueryInfo;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnTheFlyFormulaMeasureLogic;
import jet.reportset.JetRptReport;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.IReportFormulaProvider;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.MemoryCacheReportFormulaProvider;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUFormula;

public class IReportFormulaProviderFactory {
    public static IReportFormulaProvider createProvider(JetRptReport jetRptReport, QueryInfo queryInfo, ResourceStore resourceStore) {
        return new _TemplateReportFormulaProvider(jetRptReport, queryInfo, resourceStore);
    }

    public static IReportFormulaProvider createProvider(JReportEngine jReportEngine, QueryInfo queryInfo, ResourceStore resourceStore) {
        return new _JEngineReportFormulaProvider(jReportEngine, queryInfo, resourceStore);
    }

    public static MemoryCacheReportFormulaProvider createMemoryCacheProvider(JetRptReport jetRptReport, QueryInfo queryInfo, ResourceStore resourceStore) {
        return new MemoryCacheReportFormulaProvider(IReportFormulaProviderFactory.createProvider(jetRptReport, queryInfo, resourceStore));
    }

    public static MemoryCacheReportFormulaProvider createMemoryCacheProvider(JReportEngine jReportEngine, QueryInfo queryInfo, ResourceStore resourceStore) {
        return new MemoryCacheReportFormulaProvider(IReportFormulaProviderFactory.createProvider(jReportEngine, queryInfo, resourceStore));
    }

    private static Hashtable SEDU(JetRptReport jetRptReport, QueryInfo queryInfo) {
        if (queryInfo.getDataResoureType() != 2) {
            return null;
        }
        Scope scope = new Scope(jetRptReport, null, queryInfo);
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        Hashtable<String, JetUFormula> hashtable = null;
        if (list != null && !list.isEmpty()) {
            hashtable = new Hashtable<String, JetUFormula>();
            for (JetRptAbstractFormula jetRptAbstractFormula : list) {
                JetUFormula jetUFormula = jetRptAbstractFormula.getJetUFormula();
                String string = ((JetRptFlyFormula)jetRptAbstractFormula).getQualifyDisplayName().toUpperCase();
                hashtable.put(string, jetUFormula);
            }
        }
        return hashtable;
    }

    private static JavaFormula error(JetRptReport jetRptReport, QueryInfo queryInfo, ResourceStore resourceStore) throws JRScheduleException {
        if (queryInfo.getDataResoureType() != 2) {
            return null;
        }
        Scope scope = new Scope(jetRptReport, null, queryInfo);
        scope.setResourceStore(resourceStore);
        Class clazz = ReportTools.loadOnTheFlyJavaFormulaClass(scope);
        return IReportFormulaProviderFactory.getDataResoureType(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JavaFormula getDataResoureType(Class clazz) throws JRScheduleException {
        JavaFormula javaFormula = null;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            if (clazz != null) {
                javaFormula = (JavaFormula)clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        finally {
            if (reflectiveOperationException != null && JRLog.isError(2)) {
                JRLog.error(2, reflectiveOperationException);
            }
        }
        return javaFormula;
    }

    private static class _JEngineReportFormulaProvider
    implements IReportFormulaProvider {
        private JReportEngine SEDU;
        private QueryInfo access$200;
        ResourceStore rs;

        private _JEngineReportFormulaProvider(JReportEngine jReportEngine, QueryInfo queryInfo, ResourceStore resourceStore) {
            this.SEDU = jReportEngine;
            this.access$200 = queryInfo;
            this.rs = resourceStore;
        }

        private JetRptReport SEDU() {
            return this.SEDU.getReportViewCenter().getOriReportView();
        }

        @Override
        public Hashtable getFlyFormulas() {
            return IReportFormulaProviderFactory.SEDU(this.SEDU(), this.access$200);
        }

        @Override
        public JavaFormula getFlyJavaFormula() throws JRScheduleException {
            return IReportFormulaProviderFactory.error(this.SEDU(), this.access$200, this.rs);
        }
    }

    private static class _TemplateReportFormulaProvider
    implements IReportFormulaProvider {
        private JetRptReport SEDU;
        private QueryInfo access$200;
        ResourceStore rs;

        private _TemplateReportFormulaProvider(JetRptReport jetRptReport, QueryInfo queryInfo, ResourceStore resourceStore) {
            this.SEDU = jetRptReport;
            this.access$200 = queryInfo;
            this.rs = resourceStore;
        }

        @Override
        public Hashtable getFlyFormulas() {
            return IReportFormulaProviderFactory.SEDU(this.SEDU, this.access$200);
        }

        @Override
        public JavaFormula getFlyJavaFormula() throws JRScheduleException {
            return IReportFormulaProviderFactory.error(this.SEDU, this.access$200, this.rs);
        }
    }
}

