/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.api;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import jet.dataengine.api.DSException;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.RptSetDirectInfo;
import jet.rptservice.api.RptSetFullInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.exception.JRTemplateParseException;
import jet.rptservice.pub.DataContainerDirectInfo;
import jet.rptservice.pub.DataSetFullInfo;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.pub.PrincipalAttributes;
import jet.rptservice.pub.ReportDirectInfo;
import jet.rptservice.pub.ReportFullInfo;
import jet.rptservice.util.MemoryCacheQueryParameterProvider;
import jet.rptservice.util.QueryParameterProvider;
import jet.rptservice.util.ReportTemplateDirectParseTool;
import jet.rptservice.util.ReportTemplateFullParseTool;
import jet.universe.JetUUniverse;

public class RptSetInfoFactory {
    public static final RptSetDirectInfo createRptSetDirectInfo(PrincipalAttributes principalAttributes) throws JRScheduleException {
        return new RptSetDirectInfoImpl(principalAttributes);
    }

    public static final RptSetFullInfo createRptSetFullInfo(RptSetDirectInfo rptSetDirectInfo, JetUUniverse jetUUniverse) throws JRScheduleException {
        return new RptSetFullInfoImpl(rptSetDirectInfo, jetUUniverse);
    }

    private static class RptSetFullInfoImpl
    implements RptSetFullInfo {
        private RptSetDirectInfo SEDU;
        private Hashtable containsKey;
        private Hashtable fullParseOne;
        private Hashtable fullParseTwo;
        private MemoryCacheQueryParameterProvider get = new MemoryCacheQueryParameterProvider(new QueryParameterProvider(null, false));

        public RptSetFullInfoImpl(RptSetDirectInfo rptSetDirectInfo, JetUUniverse jetUUniverse) throws JRScheduleException {
            this.SEDU = rptSetDirectInfo;
            this.refreshDataSetInfos(jetUUniverse);
            String[] stringArray = this.getReportNames();
            if (stringArray != null && stringArray.length > 0) {
                this.fullParseOne = new Hashtable();
                for (int i = 0; i < stringArray.length; ++i) {
                    ReportDirectInfo reportDirectInfo = this.SEDU.getReportDirectInfo(stringArray[i]);
                    ReportFullInfo reportFullInfo = this.containsKey(jetUUniverse, stringArray[i], reportDirectInfo);
                    this.fullParseOne.put(stringArray[i], reportFullInfo);
                }
            }
        }

        private String[] SEDU(String[] stringArray) {
            if (stringArray == null) {
                return null;
            }
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i] == null ? null : stringArray[i].toUpperCase();
            }
            return stringArray2;
        }

        private ReportFullInfo containsKey(JetUUniverse jetUUniverse, String string, ReportDirectInfo reportDirectInfo) throws JRScheduleException {
            Hashtable hashtable = new Hashtable();
            ReportTemplateFullParseTool reportTemplateFullParseTool = new ReportTemplateFullParseTool(jetUUniverse, this.SEDU.getReportSet().getReport(string), this.SEDU.getReportDirectInfo(string), hashtable, this.get);
            reportTemplateFullParseTool.fullParseOne();
            reportTemplateFullParseTool.fullParseTwo(new Hashtable());
            return reportTemplateFullParseTool.getreportFullInfo();
        }

        @Override
        public RptSetDirectInfo cloneIt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataSetFullInfo getDataSetInfo(String string) {
            return this.containsKey == null ? null : (DataSetFullInfo)this.containsKey.get(string);
        }

        @Override
        public String[] getQueryParamNames(String string, String string2) {
            String[] stringArray = null;
            if (this.fullParseTwo != null) {
                KeyDataSourceQuery keyDataSourceQuery = new KeyDataSourceQuery(string, string2);
                stringArray = (String[])this.fullParseTwo.get(keyDataSourceQuery);
            }
            return stringArray;
        }

        @Override
        public ReportFullInfo getReportFullInfo(String string) {
            return this.fullParseOne == null ? null : (ReportFullInfo)this.fullParseOne.get(string);
        }

        @Override
        public void refreshReportFullInfo(String string, JetUUniverse jetUUniverse) throws JRScheduleException {
            if (this.fullParseOne == null) {
                this.fullParseOne = new Hashtable();
            }
            ReportDirectInfo reportDirectInfo = this.SEDU.getReportDirectInfo(string);
            ReportFullInfo reportFullInfo = this.containsKey(jetUUniverse, string, reportDirectInfo);
            this.fullParseOne.put(string, reportFullInfo);
        }

        @Override
        public void refreshDataSetInfos(JetUUniverse jetUUniverse) throws JRScheduleException {
            String[] stringArray = this.getUsedDataSetNames(this.getReportNames());
            if (stringArray != null && stringArray.length > 0) {
                if (this.containsKey == null) {
                    this.containsKey = new Hashtable();
                }
                if (this.fullParseTwo == null) {
                    this.fullParseTwo = new Hashtable();
                }
                JetRptReportSet jetRptReportSet = this.SEDU.getReportSet();
                for (int i = 0; i < stringArray.length; ++i) {
                    JetRptDataSet jetRptDataSet = jetRptReportSet.getDataSet(stringArray[i]);
                    DataSetFullInfo dataSetFullInfo = (DataSetFullInfo)this.containsKey.get(stringArray[i]);
                    if (dataSetFullInfo == null) {
                        dataSetFullInfo = new DataSetFullInfo(jetRptDataSet, jetUUniverse);
                        this.containsKey.put(stringArray[i], dataSetFullInfo);
                    } else {
                        dataSetFullInfo.refresh(jetRptDataSet, jetUUniverse);
                    }
                    String string = dataSetFullInfo.getDataSourceName();
                    String string2 = dataSetFullInfo.getQueryName();
                    KeyDataSourceQuery keyDataSourceQuery = new KeyDataSourceQuery(string, string2);
                    if (this.fullParseTwo.containsKey(keyDataSourceQuery)) continue;
                    String[] stringArray2 = null;
                    try {
                        stringArray2 = this.get.getQueryParamNames(jetUUniverse, string, string2);
                    }
                    catch (DSException dSException) {
                        JRScheduleException jRScheduleException = new JRScheduleException(220085, (Object[])new String[]{string, string2}, (Throwable)dSException);
                        throw jRScheduleException;
                    }
                    if (stringArray2 == null) continue;
                    stringArray2 = this.SEDU(stringArray2);
                    this.fullParseTwo.put(keyDataSourceQuery, stringArray2);
                }
            }
        }

        @Override
        public String getCurrentReportName() {
            return this.SEDU.getCurrentReportName();
        }

        @Override
        public String[] getDataSetNames() {
            return this.SEDU.getDataSetNames();
        }

        @Override
        public ReportDirectInfo getReportDirectInfo(String string) throws JRTemplateParseException {
            return this.SEDU.getReportDirectInfo(string);
        }

        @Override
        public String[] getReportNames() {
            return this.SEDU.getReportNames();
        }

        @Override
        public JetRptReportSet getReportSet() {
            return this.SEDU.getReportSet();
        }

        @Override
        public PrincipalAttributes getRptSetAttributes() {
            return this.SEDU.getRptSetAttributes();
        }

        @Override
        public int getStatus(String string) {
            return this.SEDU.getStatus(string);
        }

        @Override
        public String[] getUsedDataSetNames(String[] stringArray) throws JRTemplateParseException {
            return this.SEDU.getUsedDataSetNames(stringArray);
        }

        @Override
        public String[] getRawQueryDataSetNames(String[] stringArray) throws JRTemplateParseException {
            return this.SEDU.getRawQueryDataSetNames(stringArray);
        }

        @Override
        public void refreshReportDirectInfo(String string) throws JRTemplateParseException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void refreshDataSetInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clearMem() {
            this.get.reset();
        }
    }

    private static class RptSetDirectInfoImpl
    implements RptSetDirectInfo {
        private PrincipalAttributes SEDU;
        private Vector add;
        private Vector addAll;
        private Hashtable append;

        private RptSetDirectInfoImpl() {
        }

        private RptSetDirectInfoImpl(PrincipalAttributes principalAttributes) throws JRScheduleException {
            this.SEDU = principalAttributes;
            this.refreshDataSetInfo();
            JetRptReportSet jetRptReportSet = (JetRptReportSet)principalAttributes.getPrincipal();
            String[] stringArray = jetRptReportSet.getAllReportsName();
            if (stringArray != null && stringArray.length > 0) {
                this.addAll = new Vector();
                this.addAll.addAll(Arrays.asList(stringArray));
                this.append = new Hashtable();
                for (int i = 0; i < stringArray.length; ++i) {
                    JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
                    this.append.put(stringArray[i], this.SEDU(this, stringArray[i]));
                }
            }
        }

        private ReportDirectInfo SEDU(RptSetDirectInfo rptSetDirectInfo, String string) throws JRTemplateParseException {
            ReportTemplateDirectParseTool reportTemplateDirectParseTool = new ReportTemplateDirectParseTool(rptSetDirectInfo, string);
            reportTemplateDirectParseTool.directParse();
            ReportDirectInfo reportDirectInfo = reportTemplateDirectParseTool.getReportDirectInfo();
            return reportDirectInfo;
        }

        @Override
        public RptSetDirectInfo cloneIt() {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "RptSetDirectInfoImpl.cloneIt()..., this: " + this);
            }
            RptSetDirectInfoImpl rptSetDirectInfoImpl = new RptSetDirectInfoImpl();
            JetRptReportSet jetRptReportSet = this.getReportSet();
            JetRptReportSet jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
            jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
            jetRptReportSet2.createNamingSystem();
            PrincipalAttributes principalAttributes = new PrincipalAttributes(jetRptReportSet2);
            principalAttributes.setDiskPath(this.SEDU.getDiskPath());
            principalAttributes.setServerPath(this.SEDU.getServerPath());
            rptSetDirectInfoImpl.SEDU = principalAttributes;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "clone report set, ori rptSetAttr: " + this.SEDU + " new rptSetPropSet: " + rptSetDirectInfoImpl.SEDU);
            }
            if (this.add != null) {
                rptSetDirectInfoImpl.add = new Vector();
                rptSetDirectInfoImpl.add.addAll(this.add);
            }
            if (this.addAll != null) {
                rptSetDirectInfoImpl.addAll = new Vector();
                rptSetDirectInfoImpl.addAll.addAll(this.addAll);
            }
            if (this.append != null) {
                rptSetDirectInfoImpl.append = new Hashtable();
                if (!this.append.isEmpty()) {
                    for (String string : this.append.keySet()) {
                        ReportDirectInfo reportDirectInfo = (ReportDirectInfo)this.append.get(string);
                        rptSetDirectInfoImpl.append.put(string, reportDirectInfo.cloneIt(rptSetDirectInfoImpl));
                    }
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of RptSetDirectInfoImpl.cloneIt(), return: " + rptSetDirectInfoImpl);
            }
            return rptSetDirectInfoImpl;
        }

        @Override
        public String getCurrentReportName() {
            return this.getReportSet().getCurReportId();
        }

        @Override
        public String[] getDataSetNames() {
            return this.add == null ? null : this.add.toArray(new String[this.add.size()]);
        }

        @Override
        public ReportDirectInfo getReportDirectInfo(String string) throws JRTemplateParseException {
            ReportDirectInfo reportDirectInfo;
            ReportDirectInfo reportDirectInfo2 = reportDirectInfo = this.append == null ? null : (ReportDirectInfo)this.append.get(string);
            if (reportDirectInfo == null) {
                JetRptReport jetRptReport = this.getReportSet().getReport(string);
                if (jetRptReport == null) {
                    return null;
                }
                if (this.append == null) {
                    this.append = new Hashtable();
                    reportDirectInfo = this.SEDU(this, string);
                    this.append.put(string, reportDirectInfo);
                }
            }
            return reportDirectInfo;
        }

        @Override
        public void refreshReportDirectInfo(String string) throws JRTemplateParseException {
            if (this.append == null) {
                this.append = new Hashtable();
            }
            JetRptReport jetRptReport = this.getReportSet().getReport(string);
            ReportDirectInfo reportDirectInfo = this.SEDU(this, string);
            this.append.put(string, reportDirectInfo);
        }

        @Override
        public void refreshDataSetInfo() {
            String[] stringArray = this.getReportSet().getDataSetIds();
            if (this.add == null) {
                this.add = new Vector();
            } else {
                this.add.clear();
            }
            if (stringArray != null && stringArray.length > 0) {
                this.add.addAll(Arrays.asList(stringArray));
            }
        }

        @Override
        public String[] getReportNames() {
            return this.getReportSet().getAllReportsName();
        }

        @Override
        public JetRptReportSet getReportSet() {
            return (JetRptReportSet)this.SEDU.getPrincipal();
        }

        @Override
        public PrincipalAttributes getRptSetAttributes() {
            return this.SEDU;
        }

        @Override
        public int getStatus(String string) {
            JetRptReport jetRptReport = this.getReportSet().getReport(string);
            return jetRptReport.getStatus();
        }

        @Override
        public String[] getUsedDataSetNames(String[] stringArray) throws JRTemplateParseException {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ReportDirectInfo reportDirectInfo = this.getReportDirectInfo(stringArray[i]);
                    String[] stringArray2 = reportDirectInfo.getAllDataContainerName();
                    if (stringArray2 == null) continue;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string;
                        DataContainerDirectInfo dataContainerDirectInfo = reportDirectInfo.getContainerDirectInfo(stringArray2[j]);
                        if (dataContainerDirectInfo == null || (string = dataContainerDirectInfo.getDataSetName()) == null || arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public String[] getRawQueryDataSetNames(String[] stringArray) throws JRTemplateParseException {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ReportDirectInfo reportDirectInfo = this.getReportDirectInfo(stringArray[i]);
                    String[] stringArray2 = reportDirectInfo.getAllDataContainerName();
                    if (stringArray2 == null) continue;
                    for (int j = 0; j < stringArray2.length; ++j) {
                        DataContainerDirectInfo dataContainerDirectInfo = reportDirectInfo.getContainerDirectInfo(stringArray2[j]);
                        if (dataContainerDirectInfo == null) continue;
                        String string = dataContainerDirectInfo.getDataSetName();
                        if (string == null) {
                            string = "virtual\u0007dataset\u0007name";
                        }
                        if (string == null || arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        @Override
        public void clearMem() {
            if (this.append != null) {
                for (String string : this.append.keySet()) {
                    ReportDirectInfo reportDirectInfo = (ReportDirectInfo)this.append.get(string);
                }
                this.append.clear();
            }
            if (this.addAll != null) {
                this.addAll.clear();
            }
            if (this.add != null) {
                this.add.clear();
            }
            this.SEDU = null;
        }
    }
}

