/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.api.design;

import com.jinfonet.util.JRLog;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUHDSTable;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUProcedure;
import jet.universe.JetUQuery;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUXMLConnection;

public class QueryCategory {
    private static final int SEDU = -1;
    private static final int append = 1;
    private static final int equals = 2;
    private static final int getClass = 3;
    private static final int getConnection = 4;
    private static final int getDatabase = 5;
    private static final int getDriver = -2;
    private static final int getName = 21;
    private static final int getQueriableByResourceName = 22;
    private static final int isFileQuery = 23;
    private int isHDS = -2;
    private int isJDBC = -1;

    public QueryCategory(JetUUniverse jetUUniverse, String string, String string2) {
        Object object;
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "database is null, invalid data source name: " + string);
            }
            return;
        }
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection instanceof JetUXMLConnection) {
            this.isHDS = 23;
        } else if (jetUConnection instanceof JetUJDBCConnection) {
            object = ((JetUJDBCConnection)jetUConnection).getDriver();
            this.isHDS = object != null && "com.jinfonet.jdbc.obj.ObjectDriver".equals(object.getClass().getName()) ? 22 : 21;
        }
        object = jetUDatabase.getQueriableByResourceName(string2);
        if (object instanceof JetUQuery) {
            this.isJDBC = 3;
        } else if (object instanceof JetUProcedure) {
            this.isJDBC = 4;
        } else if (object instanceof JetUUserDataSource) {
            this.isJDBC = 1;
        } else if (object instanceof JetUFileQuery) {
            this.isJDBC = 5;
        } else if (object instanceof JetUHDSTable) {
            this.isJDBC = 2;
        }
    }

    public boolean isUDS() {
        return this.isJDBC == 1;
    }

    public boolean isHDS() {
        return this.isJDBC == 2;
    }

    public boolean isPSQL() {
        return this.isJDBC == 3;
    }

    public boolean isStoreProcedure() {
        return this.isJDBC == 4;
    }

    public boolean isFileQuery() {
        return this.isJDBC == 5;
    }

    public boolean isJDBC() {
        return this.isHDS == 21;
    }

    public boolean isOOJdbc() {
        return this.isHDS == 22;
    }

    public boolean isXMLDataSource() {
        return this.isHDS == 23;
    }

    public String toString() {
        String string;
        String string2 = this.isJDBC() ? "jdbc" : (this.isOOJdbc() ? "ooJdbc" : (string = this.isXMLDataSource() ? "xml" : "invalid"));
        String string3 = this.isUDS() ? "uds" : (this.isHDS() ? "hds" : (this.isPSQL() ? "psql" : (this.isStoreProcedure() ? "store procedure" : (this.isFileQuery() ? "file" : "invalid"))));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("data source type: ").append(string).append(" query type: ").append(string3);
        return stringBuffer.toString();
    }
}

