/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.design;

import com.jinfonet.util.JRLog;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import jet.icontrols.QueryInfo;
import jet.reportset.JetRptDataSet;
import jet.rptservice.api.infocenter.IDataSetCenter;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.accessor.cube.subject.RptDimension;
import jet.rptservice.engine.accessor.cube.subject.RptMeasure;
import jet.rptservice.util.Tools;

public class BackupDataSetInfo {
    private JetRptDataSet SEDU;
    private int[] addElement = new int[]{0, 1, 2, 3, 4};
    String[][] mappingNames;
    CubeModel cubeModel = null;
    private boolean append = false;
    private boolean deepDupWithName = false;
    private boolean equals = false;
    private boolean get = false;

    BackupDataSetInfo(IDataSetCenter iDataSetCenter) {
        this.SEDU = (JetRptDataSet)iDataSetCenter.getDataSet().deepDupWithName();
        this.mappingNames = new String[this.addElement.length][];
        for (int i = 0; i < this.mappingNames.length; ++i) {
            this.mappingNames[i] = iDataSetCenter.getMappingNames(this.addElement[i]);
            Arrays.sort(this.mappingNames[i]);
        }
        this.cubeModel = iDataSetCenter.getCubeModel();
        this.append = iDataSetCenter.needRefresh();
        this.deepDupWithName = iDataSetCenter.needRefreshCube();
        this.equals = iDataSetCenter.needInitQuery();
        this.get = iDataSetCenter.needInitCubeQuery();
    }

    boolean needRefresh() {
        return this.append;
    }

    boolean needRefreshCube() {
        return this.deepDupWithName;
    }

    boolean needInitCubeQuery() {
        return this.get;
    }

    boolean needInitRawQuery() {
        return this.equals;
    }

    public boolean equalsForRawData(IDataSetCenter iDataSetCenter) {
        QueryInfo queryInfo;
        JRLog.trace(6, "ActionExecutor.equalsForRawData()..., dataSet: " + iDataSetCenter.getDataSet().getName());
        String[][] stringArrayArray = new String[this.addElement.length][];
        for (int i = 0; i < stringArrayArray.length; ++i) {
            stringArrayArray[i] = iDataSetCenter.getMappingNames(this.addElement[i]);
            Arrays.sort(stringArrayArray[i]);
            if (this.get(stringArrayArray[i], this.mappingNames[i])) continue;
            JRLog.trace(6, "mapping names don't equal, type: " + this.addElement[i]);
            JRLog.trace(6, "before do action: " + Tools.toString(this.mappingNames[i]));
            JRLog.trace(6, "after do action: " + Tools.toString(stringArrayArray[i]));
            return false;
        }
        JetRptDataSet jetRptDataSet = iDataSetCenter.getDataSet();
        if (this.SEDU.maxRecords.get() != jetRptDataSet.maxRecords.get()) {
            JRLog.trace(6, "maxRecords don't equal, before do action: " + this.SEDU.maxRecords.get() + " after do action: " + jetRptDataSet.maxRecords.get());
            return false;
        }
        if (this.SEDU.maxPageNumber.get() != jetRptDataSet.maxPageNumber.get()) {
            JRLog.trace(6, "maxPageNumber don't equal, before do action: " + this.SEDU.maxPageNumber.get() + " after do action: " + jetRptDataSet.maxPageNumber.get());
            return false;
        }
        if (this.SEDU.recordsPerPage.get() != jetRptDataSet.recordsPerPage.get()) {
            JRLog.trace(6, "recordsPerPage don't equal, before do action: " + this.SEDU.recordsPerPage.get() + " after do action: " + jetRptDataSet.recordsPerPage.get());
            return false;
        }
        QueryInfo queryInfo2 = this.SEDU.getQueryInfo();
        if (!queryInfo2.isEquals(queryInfo = jetRptDataSet.getQueryInfo())) {
            JRLog.trace(6, "query info don't equal, before do action: " + queryInfo2 + " after do action: " + queryInfo);
            return false;
        }
        JRLog.trace(6, "End of ActionExecutor.equalsForRawData()..., return true.");
        return true;
    }

    public boolean equalsForCube(IDataSetCenter iDataSetCenter) {
        CubeModel cubeModel = iDataSetCenter.getCubeModel();
        if (this.cubeModel == null && cubeModel != null) {
            return false;
        }
        if (this.cubeModel != null && cubeModel == null) {
            return false;
        }
        if (this.cubeModel == null && cubeModel == null) {
            return true;
        }
        if (!this.SEDU(this.cubeModel.getDimensions(), cubeModel.getDimensions())) {
            return false;
        }
        return this.addElement(this.cubeModel.getMeasures(), cubeModel.getMeasures());
    }

    private boolean SEDU(RptDimension[] rptDimensionArray, RptDimension[] rptDimensionArray2) {
        String[] stringArray;
        String[] stringArray2;
        if (rptDimensionArray == null && rptDimensionArray2 != null) {
            return false;
        }
        if (rptDimensionArray != null && rptDimensionArray2 == null) {
            return false;
        }
        if (rptDimensionArray == null && rptDimensionArray2 == null) {
            return true;
        }
        if (rptDimensionArray.length != rptDimensionArray2.length) {
            return false;
        }
        String[] stringArray3 = this.append(rptDimensionArray);
        if (!this.get(stringArray3, stringArray2 = this.append(rptDimensionArray2))) {
            return false;
        }
        String[] stringArray4 = this.cubeModel(rptDimensionArray);
        return this.get(stringArray4, stringArray = this.cubeModel(rptDimensionArray2));
    }

    private boolean addElement(RptMeasure[] rptMeasureArray, RptMeasure[] rptMeasureArray2) {
        String[] stringArray;
        String[] stringArray2;
        if (rptMeasureArray == null && rptMeasureArray2 != null) {
            return false;
        }
        if (rptMeasureArray != null && rptMeasureArray2 == null) {
            return false;
        }
        if (rptMeasureArray == null && rptMeasureArray2 == null) {
            return true;
        }
        if (rptMeasureArray.length != rptMeasureArray2.length) {
            return false;
        }
        String[] stringArray3 = this.deepDupWithName(rptMeasureArray);
        if (!this.get(stringArray3, stringArray2 = this.deepDupWithName(rptMeasureArray2))) {
            return false;
        }
        String[] stringArray4 = this.equals(rptMeasureArray);
        return this.get(stringArray4, stringArray = this.equals(rptMeasureArray2));
    }

    private String[] append(RptDimension[] rptDimensionArray) {
        Object[] objectArray = new String[rptDimensionArray.length];
        for (int i = 0; i < rptDimensionArray.length; ++i) {
            objectArray[i] = rptDimensionArray[i].getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] cubeModel(RptDimension[] rptDimensionArray) {
        Object[] objectArray = new String[rptDimensionArray.length];
        for (int i = 0; i < rptDimensionArray.length; ++i) {
            objectArray[i] = rptDimensionArray[i].getmappingName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] deepDupWithName(RptMeasure[] rptMeasureArray) {
        Object[] objectArray = new String[rptMeasureArray.length];
        for (int i = 0; i < rptMeasureArray.length; ++i) {
            objectArray[i] = rptMeasureArray[i].getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[] equals(RptMeasure[] rptMeasureArray) {
        Object[] objectArray = new String[rptMeasureArray.length];
        for (int i = 0; i < rptMeasureArray.length; ++i) {
            objectArray[i] = rptMeasureArray[i].getmappingName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private boolean get(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        if (stringArray.length == 0) {
            return true;
        }
        List list = this.getCubeModel(stringArray);
        List list2 = this.getCubeModel(stringArray2);
        return ((Object)list).equals(list2);
    }

    private List getCubeModel(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }
}

