/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.design.helper;

import com.jinfonet.util.JRLog;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.DSException;
import jet.dataengine.api.GoProcessor;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.group.GroupTool;
import jet.dataengine.api.group.pls.JGroupTreePLS;
import jet.dataengine.api.group.pls.PLSCascade;
import jet.dataengine.api.group.pls.PLSGrant;
import jet.dataengine.api.group.pls.PLSGroup;
import jet.dataengine.api.group.pls.PLSInfo;
import jet.dataengine.api.group.pls.PLSProcessor;
import jet.dataengine.api.group.pls.PLSRole;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.ParaGroupModel;
import jet.dataengine.valuelist.ValueListLoader;
import jet.dataengine8.dbbuffer.DbBufferDataAdapterRelation;
import jet.datastream.DSTemplatible;
import jet.formula.ExecutableJavaFormula;
import jet.formula.JavaFormula;
import jet.formula.JavaFormulaContainer;
import jet.formula.JetRptFormula;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.table.JetRptNewTable;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.rptengine.JCommunicator;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.IDataResultInfo;
import jet.rptservice.api.IDynamicConnectionInfo;
import jet.rptservice.api.IDynamicQueryInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.design.BrowseInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.helper.AbstractHelper;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.infocenter.DataSetCenter;
import jet.rptservice.engine.infocenter.GoToInfo;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.impl.ValueListLoaderOptionImpl;
import jet.rptservice.util.DataTools;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.Tools;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.dsdriver.UDSDriver;
import jet.universe.dsdriver.UDSDriverFormatException;
import jet.util.ScheduleTools;

public class DataHelper
extends AbstractHelper {
    public static final int BROWSE_TYPE_GO_TO = 0;
    public static final int BROWSE_TYPE_GO_DOWN = 1;
    public static final int BROWSE_TYPE_GO_UP = 2;
    private static final String SEDU = "CatalogQuery";

    public DataHelper(JRptSetEngine jRptSetEngine) {
        super(jRptSetEngine);
    }

    public static Group[] getGroupTrees(JReportEngine jReportEngine, JetRptObject jetRptObject) throws JRStopEngineException, JRScheduleException {
        IDataContainer iDataContainer = jReportEngine.getReportViewCenter().getQueryDataContainer(jetRptObject);
        if (iDataContainer == null) {
            return null;
        }
        List list = jReportEngine.getCurQueryIds(iDataContainer);
        if (list == null || list.isEmpty()) {
            return null;
        }
        Group[] groupArray = new Group[list.size()];
        for (int i = 0; i < groupArray.length; ++i) {
            groupArray[i] = DataHelper.getGroupTree(jReportEngine, iDataContainer, i);
        }
        return DataHelper.SEDU(groupArray);
    }

    private static Group[] SEDU(Group[] groupArray) {
        return groupArray;
    }

    static JDbBufferCursor getCursor(JReportEngine jReportEngine, String string) throws JRScheduleException {
        JetRptObject jetRptObject = (JetRptObject)jReportEngine.getReport().nameToObject(string);
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        IDataContainer iDataContainer = reportViewCenter.getQueryDataContainer(jetRptObject);
        DataSet dataSet = ReportTools.getDataSet((JetObject)((Object)iDataContainer));
        JCommunicator jCommunicator = jReportEngine.getCommunicator();
        JDbBufferCursor jDbBufferCursor = null;
        if (dataSet.getMappingListSrc() == 3) {
            int n = DataHelper.Z(jetRptObject, iDataContainer);
            jDbBufferCursor = jCommunicator.getDbBuffer(n, jReportEngine);
        } else {
            jDbBufferCursor = jCommunicator.getDbBuffer((DSTemplatible)((Object)iDataContainer));
        }
        return jDbBufferCursor;
    }

    private static final int Z(JetRptObject jetRptObject, IDataContainer iDataContainer) throws JRScheduleException {
        return DataHelper.access$000(jetRptObject, iDataContainer, jetRptObject.getInstName());
    }

    private static final int access$000(JetRptObject jetRptObject, IDataContainer iDataContainer, String string) throws JRScheduleException {
        if (jetRptObject == null || jetRptObject == iDataContainer) {
            throw new JRScheduleException(220071, (Object[])new String[]{string, iDataContainer.getInstName()}, null);
        }
        if (jetRptObject instanceof JetRptSection) {
            return ((JetRptSection)jetRptObject).getBranchIdx();
        }
        return DataHelper.access$000((JetRptObject)((Object)jetRptObject.getParent()), iDataContainer, string);
    }

    private Group access$002(Group group) {
        Group group2 = group.getParent();
        if (group2 == null) {
            return group;
        }
        Vector vector = group2.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Group group3 = (Group)vector.get(i);
            Vector vector2 = group3.getSiblings();
            if (vector2 == null || !vector2.contains(group)) continue;
            return group3;
        }
        return group;
    }

    private PLSInfo[] access$100(Group group) throws DSException {
        ArrayList arrayList = new ArrayList();
        this.access$102(group.getGroupModel(), arrayList);
        PLSInfo[] pLSInfoArray = null;
        if (!arrayList.isEmpty()) {
            pLSInfoArray = arrayList.toArray(new PLSInfo[arrayList.size()]);
        }
        return pLSInfoArray;
    }

    private void access$102(GroupModel groupModel, ArrayList arrayList) throws DSException {
        PLSInfo pLSInfo = this.add(groupModel);
        if (pLSInfo != null) {
            arrayList.add(pLSInfo);
        }
        if (groupModel.nextGroupModel() != null) {
            this.access$102(groupModel.nextGroupModel(), arrayList);
        }
    }

    private PLSInfo add(GroupModel groupModel) throws DSException {
        Object object = groupModel.getModelCreater();
        if (object != null && object instanceof JetRptGroupPanel) {
            JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)object;
            if (!jetRptGroupPanel.isSecurity()) {
                return null;
            }
            PLSGrant pLSGrant = this.addJavaFormula(jetRptGroupPanel);
            PLSGroup pLSGroup = this.bFCascade(jetRptGroupPanel);
            PLSRole pLSRole = this.bFGrant(jetRptGroupPanel);
            PLSCascade pLSCascade = this.append(jetRptGroupPanel);
            return new PLSInfo(groupModel.getGroupIndex(), pLSGrant, pLSGroup, pLSRole, pLSCascade);
        }
        return null;
    }

    private PLSGrant addJavaFormula(JetRptGroupPanel jetRptGroupPanel) {
        String string = null;
        boolean bl = jetRptGroupPanel.bFGrant;
        if (bl) {
            if (jetRptGroupPanel.cFGrant != null && jetRptGroupPanel.cFGrant.length() > 0) {
                string = jetRptGroupPanel.cFGrant.toUpperCase();
            }
        } else {
            string = jetRptGroupPanel.sNGrant;
        }
        return string == null ? null : new PLSGrant(bl, string);
    }

    private PLSCascade append(JetRptGroupPanel jetRptGroupPanel) {
        String string = null;
        boolean bl = jetRptGroupPanel.bFCascade;
        string = bl ? jetRptGroupPanel.cFCascade : String.valueOf(jetRptGroupPanel.bNCascade);
        return new PLSCascade(bl, string);
    }

    private PLSGroup bFCascade(JetRptGroupPanel jetRptGroupPanel) {
        JetString jetString = (JetString)jetRptGroupPanel.getPropertyByName("Groups");
        String string = null;
        boolean bl = jetString.isChangeByOther();
        if (bl) {
            string = ((String)jetString.getChangeByObject()).toUpperCase();
        } else if (!jetString.isNull() && jetString.get().length() > 0) {
            string = jetString.get();
        }
        return string == null ? null : new PLSGroup(bl, string);
    }

    private PLSRole bFGrant(JetRptGroupPanel jetRptGroupPanel) {
        JetString jetString = (JetString)jetRptGroupPanel.getPropertyByName("Roles");
        String string = null;
        boolean bl = jetString.isChangeByOther();
        if (bl) {
            string = ((String)jetString.getChangeByObject()).toUpperCase();
        } else if (!jetString.isNull() && jetString.get().length() > 0) {
            string = jetString.get();
        }
        return string == null ? null : new PLSRole(bl, string);
    }

    private BrowseInfo[] bNCascade(List list, int n) {
        BrowseInfo[] browseInfoArray = null;
        if (list == null || list.isEmpty()) {
            browseInfoArray = new BrowseInfo[]{};
        } else {
            switch (n) {
                case 0: {
                    browseInfoArray = new BrowseInfo[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        Group group = (Group)list.get(i);
                        JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)group.getGroupModel().getModelCreater();
                        String string = null;
                        if (jetRptGroupPanel != null) {
                            string = jetRptGroupPanel.getInstName();
                        }
                        browseInfoArray[i] = new BrowseInfo(group.getGroupValue(), DataTools.getGroupNodeIndex(group, true), string, group.getGroupModel().getGroupIndex());
                    }
                    break;
                }
                case 1: {
                    browseInfoArray = new BrowseInfo[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        Group group = (Group)list.get(i);
                        JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)group.getGroupModel().getModelCreater();
                        String string = null;
                        if (jetRptGroupPanel != null) {
                            string = jetRptGroupPanel.getInstName();
                        }
                        browseInfoArray[i] = new BrowseInfo(group.groupNumber(), group.getGroupValue(), string);
                    }
                    break;
                }
                case 2: {
                    browseInfoArray = new BrowseInfo[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        Group group = (Group)list.get(i);
                        JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)group.getGroupModel().getModelCreater();
                        String string = null;
                        if (jetRptGroupPanel != null) {
                            string = jetRptGroupPanel.getInstName();
                        }
                        browseInfoArray[i] = new BrowseInfo(group.getGroupValue(), group.getGroupPath(true), string);
                    }
                    break;
                }
                default: {
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, "invalid browse type: " + n);
                    }
                    browseInfoArray = new BrowseInfo[]{};
                }
            }
        }
        return browseInfoArray;
    }

    private GroupModel cFCascade(GroupModel groupModel, IDataContainer iDataContainer) {
        Vector vector;
        Object object;
        Tools.logTrace(6, "DesignService.getRootGroupModel()...");
        if (!iDataContainer.isInheritDataSet()) {
            return groupModel;
        }
        GroupModel groupModel2 = groupModel;
        GroupModel groupModel3 = null;
        Object var5_5 = null;
        if (iDataContainer instanceof JetRptSectionObject) {
            object = (JetRptSectionObject)iDataContainer;
            vector = ((JetRptSectionObject)object).getGroupPanels();
            if (vector != null && vector.size() > 0) {
                var5_5 = vector.firstElement();
            }
        } else if (iDataContainer instanceof JetRptNewTable) {
            object = (JetRptNewTable)iDataContainer;
            vector = ((JetRptNewTable)object).getGroups();
            if (vector != null && vector.size() > 0) {
                var5_5 = vector.firstElement();
            }
        } else {
            return null;
        }
        if (var5_5 != null) {
            object = null;
            do {
                if ((object = groupModel2.getModelCreater()) == null || !(object instanceof JetRptGroupPanel) || object != var5_5) continue;
                groupModel3 = groupModel2.prevGroupModel();
                break;
            } while ((groupModel2 = groupModel2.nextToMe()) != null);
        }
        return groupModel3;
    }

    private int[] cFGrant(GroupModel groupModel, boolean bl) {
        int n = groupModel.getGroupIndex();
        if (!bl || !(groupModel instanceof ParaGroupModel)) {
            return new int[]{n};
        }
        Vector vector = ((ParaGroupModel)groupModel).getSiblings();
        int n2 = vector == null ? 0 : vector.size();
        int[] nArray = new int[n2 + 1];
        nArray[0] = n;
        for (int i = 0; i < n2; ++i) {
            nArray[i + 1] = ((GroupModel)vector.elementAt(i)).getGroupIndex();
        }
        return nArray;
    }

    private Group clone(Group group, int[] nArray) {
        Group group2;
        for (group2 = group; group2 != null; group2 = group2.getParent()) {
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (group2.getGroupModel().getGroupIndex() != nArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return group2;
    }

    private void contains(Group group, GroupInfo groupInfo, int[][] nArray) {
        groupInfo.SEDU = group;
        int n = nArray == null ? 0 : nArray[0].length;
        GroupInfo.access$102(groupInfo, new int[2][n + 1]);
        for (int i = 0; i < n; ++i) {
            ((GroupInfo)groupInfo).I[0][i] = nArray[0][i];
            ((GroupInfo)groupInfo).I[1][i] = nArray[1][i];
        }
        ((GroupInfo)groupInfo).I[0][n] = group.getBranchIdx();
        ((GroupInfo)groupInfo).I[1][n] = group.groupNumber();
    }

    private void createCursor(Group group, Group group2, GroupInfo groupInfo, ArrayList arrayList, int n, boolean bl) {
        Object object;
        int n2;
        Vector vector;
        boolean bl2 = true;
        if (group == group2) {
            bl = true;
            bl2 = false;
        }
        if ((vector = group.getChildren()) != null) {
            int n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Group group3 = (Group)vector.get(n2);
                object = new GroupInfo();
                this.contains(group3, (GroupInfo)object, groupInfo.I);
                if (group3.getGroupModel().getGroupIndex() == n && bl && group3.isAvail()) {
                    arrayList.add(object);
                }
                this.createCursor(group3, group2, (GroupInfo)object, arrayList, n, bl);
            }
        }
        if (!bl2) {
            return;
        }
        Vector vector2 = group.getSiblings();
        if (vector2 != null) {
            n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                object = (Group)vector2.get(i);
                GroupInfo groupInfo2 = new GroupInfo();
                int[][] nArray = this.createRecord(groupInfo.I);
                this.contains((Group)object, groupInfo2, nArray);
                if (object.getGroupModel().getGroupIndex() == n && bl && object.isAvail()) {
                    arrayList.add(groupInfo2);
                }
                this.createCursor((Group)object, group2, groupInfo2, arrayList, n, bl);
            }
        }
    }

    private int[][] createRecord(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray[0].length;
        int[][] nArray2 = new int[2][n - 1];
        for (int i = 0; i < n - 1; ++i) {
            nArray2[0][i] = nArray[0][i];
            nArray2[1][i] = nArray[1][i];
        }
        return nArray2;
    }

    private boolean dataDriver(IDataContainer iDataContainer) {
        boolean bl = false;
        if (iDataContainer instanceof JetRptSectionObject) {
            bl = ((JetRptSectionObject)iDataContainer).isSecurity();
        } else if (iDataContainer instanceof JetRptNewTable) {
            bl = ((JetRptNewTable)iDataContainer).isSecurity();
        }
        return bl;
    }

    private Group doProcess(Group group) {
        Vector vector = group.getChildren();
        if (vector != null) {
            return (Group)vector.get(0);
        }
        return null;
    }

    private GroupModel elementAt(GroupModel groupModel, int n) {
        if (groupModel instanceof ParaGroupModel) {
            ParaGroupModel paraGroupModel = (ParaGroupModel)groupModel;
            if (paraGroupModel.getBranchIdx() == n) {
                return paraGroupModel.nextGroupModel();
            }
            Vector vector = paraGroupModel.getSiblings();
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    ParaGroupModel paraGroupModel2 = (ParaGroupModel)vector.get(i);
                    if (paraGroupModel2.getBranchIdx() != n) continue;
                    return paraGroupModel2.nextGroupModel();
                }
                return null;
            }
            return null;
        }
        return groupModel.nextGroupModel();
    }

    private List equals(Group group, int[][] nArray, int n) throws DSException {
        PLSInfo[] pLSInfoArray = this.access$100(group);
        JGroupTreePLS jGroupTreePLS = new JGroupTreePLS(group, pLSInfoArray);
        Group group2 = group.peek(nArray, true);
        Group group3 = this.access$002(group2);
        GroupModel groupModel = this.elementAt(group3.getGroupModel(), n);
        int n2 = groupModel.getGroupIndex();
        int n3 = groupModel instanceof ParaGroupModel ? ((ParaGroupModel)groupModel).getBranchIdx() : -1;
        ArrayList arrayList = PLSProcessor.getGroupByValueList(jGroupTreePLS, n3, n2, this.mainRptSetEngine.getUserName(), this.mainRptSetEngine.getSecurityData());
        return arrayList;
    }

    private List firstElement(Group group, int[][] nArray, int n) throws DSException {
        Group group2 = group.peek(nArray, true);
        Group group3 = this.access$002(group2);
        if (group3.getBranchIdx() == n) {
            return group3.getChildren();
        }
        Vector vector = group3.getSiblings();
        if (vector != null) {
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                Group group4 = (Group)vector.get(i);
                if (group4.getBranchIdx() != n) continue;
                return group4.getChildren();
            }
            return null;
        }
        return null;
    }

    private BrowseInfo[] get(Group group, int[][] nArray, IDataContainer iDataContainer) throws DSException {
        boolean bl = false;
        Group group2 = group.peek(nArray, true);
        Group group3 = group2.getParent();
        GroupModel groupModel = this.cFCascade(group.getGroupModel(), iDataContainer);
        int[] nArray2 = this.cFGrant(groupModel, true);
        Group group4 = this.clone(group2, nArray2);
        ArrayList<GroupInfo> arrayList = new ArrayList<GroupInfo>();
        int n = group3.getGroupModel().getGroupIndex();
        GroupInfo groupInfo = new GroupInfo();
        this.contains(group, groupInfo, null);
        if (group.getGroupModel().getGroupIndex() == n && bl) {
            arrayList.add(groupInfo);
        }
        this.createCursor(group, group4, groupInfo, arrayList, n, bl);
        int n2 = arrayList.size();
        BrowseInfo[] browseInfoArray = new BrowseInfo[n2];
        for (int i = 0; i < n2; ++i) {
            GroupInfo groupInfo2 = (GroupInfo)arrayList.get(i);
            Group group5 = groupInfo2.SEDU;
            int[][] nArray3 = groupInfo2.I;
            JetRptGroupPanel jetRptGroupPanel = (JetRptGroupPanel)group5.getGroupModel().getModelCreater();
            String string = null;
            if (jetRptGroupPanel != null) {
                string = jetRptGroupPanel.getInstName();
            }
            browseInfoArray[i] = new BrowseInfo(groupInfo2.SEDU.getGroupValue(), nArray3, string);
        }
        return browseInfoArray;
    }

    private List getAllFomulasValidToQuery(Group group, int[][] nArray, IDataContainer iDataContainer) throws DSException {
        Group group2 = group.peek(nArray, true);
        Group group3 = group2.getParent();
        int n = group3.getGroupModel().getGroupIndex();
        int n2 = group3.getBranchIdx();
        PLSInfo[] pLSInfoArray = this.access$100(group);
        JGroupTreePLS jGroupTreePLS = new JGroupTreePLS(group, pLSInfoArray);
        ArrayList arrayList = PLSProcessor.getGroupByValueList(jGroupTreePLS, n2, n, this.mainRptSetEngine.getUserName(), this.mainRptSetEngine.getSecurityData());
        return arrayList;
    }

    private List getBV(Group group, int[][] nArray, int n) throws DSException {
        Group group2 = group.peek(nArray, true);
        Group group3 = this.access$002(group2);
        if (group3.getBranchIdx() == n) {
            return group3.getChildren();
        }
        Vector vector = group3.getSiblings();
        if (vector != null) {
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                Group group4 = (Group)vector.get(i);
                if (group4.getBranchIdx() != n) continue;
                return group4.getChildren();
            }
            return null;
        }
        return null;
    }

    private List getBlName(Group group, int[][] nArray, int n) throws DSException {
        PLSInfo[] pLSInfoArray = this.access$100(group);
        Group group2 = group.peek(nArray, true);
        JGroupTreePLS jGroupTreePLS = new JGroupTreePLS(group2, pLSInfoArray);
        Group group3 = this.access$002(group2);
        GroupModel groupModel = this.elementAt(group3.getGroupModel(), n);
        int n2 = groupModel.getGroupIndex();
        int n3 = groupModel instanceof ParaGroupModel ? ((ParaGroupModel)groupModel).getBranchIdx() : -1;
        ArrayList arrayList = PLSProcessor.getGroupByValueList(jGroupTreePLS, n3, n2, this.mainRptSetEngine.getUserName(), this.mainRptSetEngine.getSecurityData());
        return arrayList;
    }

    public BrowseInfo[] getGoToValues(String string, String string2, String string3, int n, int[][] nArray, int n2) throws DSException, JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataHelper.getGoToValues()..., rptName: " + string + " engineKeyword: " + string2 + " sectionName: " + string3 + " groupTreeIndex: " + n + " groupNodeIndex: " + Tools.toString(nArray) + " branchIndex: " + n2);
        }
        ReportViewCenter reportViewCenter = this.getRptViewCenter(string);
        ReportViewCenter reportViewCenter2 = DataHelper.getRptViewCenter(reportViewCenter, string2);
        JReportEngine jReportEngine = reportViewCenter2.getReportViewEngine();
        JetRptReport jetRptReport = jReportEngine.getReport();
        IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(string3));
        boolean bl = this.dataDriver(iDataContainer);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Has page level formula: " + bl);
        }
        Group group = DataHelper.getGroupTree(jReportEngine, iDataContainer, n);
        List list = null;
        list = bl ? this.equals(group, nArray, n2) : this.firstElement(group, nArray, n2);
        BrowseInfo[] browseInfoArray = this.bNCascade(list, 0);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataHelper.getGoToValues(), return values: " + (browseInfoArray == null ? "null" : String.valueOf(browseInfoArray.length)));
        }
        return browseInfoArray;
    }

    public BrowseInfo[] getGoUpValues(String string, String string2, String string3, int n, int[][] nArray) throws DSException, JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataHelper.getGoUpValues()..., rptName: " + string + " engineKeyword: " + string2 + " sectionName: " + string3 + " groupTreeIndex: " + n + " groupNodeIndex: " + Tools.toString(nArray));
        }
        ReportViewCenter reportViewCenter = this.getRptViewCenter(string);
        ReportViewCenter reportViewCenter2 = DataHelper.getRptViewCenter(reportViewCenter, string2);
        JReportEngine jReportEngine = reportViewCenter2.getReportViewEngine();
        JetRptReport jetRptReport = jReportEngine.getReport();
        IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(string3));
        boolean bl = this.dataDriver(iDataContainer);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Has page level formula: " + bl);
        }
        Group group = DataHelper.getGroupTree(jReportEngine, iDataContainer, n);
        BrowseInfo[] browseInfoArray = null;
        if (bl) {
            List list = this.getAllFomulasValidToQuery(group, nArray, iDataContainer);
            browseInfoArray = this.bNCascade(list, 2);
        } else {
            browseInfoArray = this.get(group, nArray, iDataContainer);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataHelper.getGoUpValues(), return values: " + (browseInfoArray == null ? "null" : String.valueOf(browseInfoArray.length)));
        }
        return browseInfoArray;
    }

    public BrowseInfo[] getGoDownBranches(String string, String string2, String string3, int n, int[][] nArray) throws DSException, JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DesignServiceImpl.getGoDownBranches()..., rptName: " + string + " engineKeyword: " + string2 + " sectionName: " + string3 + " groupTreeIndex: " + n + " groupNodeIndex: " + Tools.toString(nArray));
        }
        ReportViewCenter reportViewCenter = this.getRptViewCenter(string);
        ReportViewCenter reportViewCenter2 = DataHelper.getRptViewCenter(reportViewCenter, string2);
        JReportEngine jReportEngine = reportViewCenter2.getReportViewEngine();
        JetRptReport jetRptReport = jReportEngine.getReport();
        IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(string3));
        BrowseInfo[] browseInfoArray = new BrowseInfo[]{};
        Group group = DataHelper.getGroupTree(jReportEngine, iDataContainer, n);
        Group group2 = group.peek(nArray, true);
        Group group3 = this.access$002(group2);
        Vector vector = group3.getSiblings();
        if (vector != null) {
            int n2;
            Group group4 = this.doProcess(group3);
            ArrayList<BrowseInfo> arrayList = new ArrayList<BrowseInfo>();
            if (group4 != null) {
                arrayList.add(new BrowseInfo(group4.getGroupByName(), group4.getBranchIdx()));
            }
            int n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Group group5 = (Group)vector.get(n2);
                Group group6 = this.doProcess(group5);
                if (group6 == null) continue;
                arrayList.add(new BrowseInfo(group6.getGroupByName(), group6.getBranchIdx()));
            }
            n2 = arrayList.size();
            browseInfoArray = new BrowseInfo[n2];
            for (int i = 0; i < n2; ++i) {
                browseInfoArray[i] = (BrowseInfo)arrayList.get(i);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of DesignServiceImpl.getGoDownBranches(), return: " + Tools.toString(browseInfoArray));
            }
            return browseInfoArray;
        }
        Group group7 = this.doProcess(group3);
        if (group7 != null) {
            browseInfoArray = new BrowseInfo[]{new BrowseInfo(group7.getGroupByName(), group7.getBranchIdx())};
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of DesignServiceImpl.getGoDownBranches(), return: " + Tools.toString(browseInfoArray));
            }
            return browseInfoArray;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DesignServiceImpl.getGoDownBranches(), return: " + Tools.toString(browseInfoArray));
        }
        return browseInfoArray;
    }

    public BrowseInfo[] getGoDownValues(String string, String string2, String string3, int n, int[][] nArray, int n2) throws DSException, JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataHelper.getGoDownValues()..., rptName: " + string + " engineKeyword: " + string2 + " sectionName: " + string3 + " groupTreeIndex: " + n + " groupNodeIndex: " + Tools.toString(nArray) + " branchIndex: " + n2);
        }
        ReportViewCenter reportViewCenter = this.getRptViewCenter(string);
        ReportViewCenter reportViewCenter2 = DataHelper.getRptViewCenter(reportViewCenter, string2);
        JReportEngine jReportEngine = reportViewCenter2.getReportViewEngine();
        JetRptReport jetRptReport = jReportEngine.getReport();
        IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(string3));
        boolean bl = this.dataDriver(iDataContainer);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Has page level formula: " + bl);
        }
        List list = null;
        Group group = DataHelper.getGroupTree(jReportEngine, iDataContainer, n);
        list = bl ? this.getBlName(group, nArray, n2) : this.getBV(group, nArray, n2);
        BrowseInfo[] browseInfoArray = this.bNCascade(list, 1);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataHelper.getGoDownValues(), return values: " + (browseInfoArray == null ? "null" : String.valueOf(browseInfoArray.length)));
        }
        return browseInfoArray;
    }

    public ResultSet getGoToActionResultSet(String string, String string2, String string3, int n, int[] nArray, DbValue[] dbValueArray, boolean bl) throws DSException, JRScheduleException, JRStopEngineException {
        JReportEngine jReportEngine = this.mainRptSetEngine.getReportViewEngine(string, string2);
        IDataContainer iDataContainer = (IDataContainer)((Object)jReportEngine.getReport().nameToObject(string3));
        JGroupQuery jGroupQuery = DataHelper.getGroupQuery(jReportEngine, iDataContainer, n);
        int n2 = jGroupQuery.getGroupQueryId();
        GoToInfo goToInfo = new GoToInfo(nArray, dbValueArray, bl);
        ResultSet resultSet = GroupTool.getDataFromGroup(this.mainRptSetEngine.getDataService(), n2, goToInfo);
        goToInfo = jReportEngine.getReportViewCenter().getGotoInfo(string3);
        if (goToInfo == null) {
            goToInfo = new GoToInfo();
        }
        GoProcessor goProcessor = new GoProcessor();
        Group group = DataHelper.getGroupTree(jReportEngine, iDataContainer, n);
        goProcessor.doProcess(goToInfo, group, null, false);
        return resultSet;
    }

    public ValueListLoader getValueListLoader(JReportEngine jReportEngine, QueryInfo queryInfo, String string, boolean bl, int n) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        ValueListLoaderOptionImpl valueListLoaderOptionImpl = this.getCFFormulas(jReportEngine, queryInfo.getDatasourceName(), queryInfo.getQueryName(), string, bl, n);
        JavaFormula javaFormula = valueListLoaderOptionImpl.getJavaFormula();
        reportSetCenter.prepareJavaFormula(javaFormula, queryInfo);
        ValueListLoader valueListLoader = new ValueListLoader(valueListLoaderOptionImpl);
        return valueListLoader;
    }

    public ValueListLoader getValueListLoader(JReportEngine jReportEngine, String string, String string2, boolean bl, int n, boolean bl2) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        ValueListLoaderOptionImpl valueListLoaderOptionImpl = this.getBranchIdx(jReportEngine, string, string2, bl, n, bl2);
        JavaFormula javaFormula = valueListLoaderOptionImpl.getJavaFormula();
        DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(string);
        QueryInfo queryInfo = dataSetCenter.getDataSet().getQueryInfo();
        reportSetCenter.prepareJavaFormula(javaFormula, queryInfo);
        ValueListLoader valueListLoader = new ValueListLoader(valueListLoaderOptionImpl);
        return valueListLoader;
    }

    private ValueListLoaderOptionImpl getBranchIdx(JReportEngine jReportEngine, String string, String string2, boolean bl, int n, boolean bl2) {
        ArrayList arrayList;
        Object object;
        Object object2;
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(string);
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        String string3 = jetRptDataSet.getDataSourceName();
        String string4 = jetRptDataSet.getQueryName();
        int n2 = jetRptDataSet.getDataResourceType();
        if (!"virtual\u0007dataset\u0007name".equals(string) && n2 != 0) {
            object2 = jRptSetEngine.getUniverse().getBV(string3, jetRptDataSet.getBlName());
            object = ((UnifiedBusinessView)object2).getQuery();
            string4 = ((JetUDemandQuery)object).getResourceName();
        }
        object2 = this.getCFFormulas(jReportEngine, string3, string4, string2, bl, n);
        object = this.getCatalogKey(jReportEngine, string3, string4);
        if (object != null && !((Hashtable)object).isEmpty()) {
            ((ValueListLoaderOptionImpl)object2).setRptFormulas((Hashtable)object);
        }
        if ((arrayList = this.getChangeByObject(jReportEngine, string)) != null && !arrayList.isEmpty()) {
            JavaFormulaContainer javaFormulaContainer = (JavaFormulaContainer)((ValueListLoaderOptionImpl)object2).getJavaFormula();
            for (JavaFormula javaFormula : arrayList) {
                javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
            }
        }
        if (bl2) {
            this.getChildren(jReportEngine, string);
        }
        return object2;
    }

    private ValueListLoaderOptionImpl getCFFormulas(JReportEngine jReportEngine, String string, String string2, String string3, boolean bl, int n) {
        JetRptFormula[] jetRptFormulaArray;
        ValueListLoaderOptionImpl valueListLoaderOptionImpl = new ValueListLoaderOptionImpl(this.mainRptSetEngine.getDataService(), this.mainRptSetEngine.getCatalogKey(), string, string2, new String[]{string3}, this.mainRptSetEngine.getUserName(), this.mainRptSetEngine.getEngineEnv().getResourceStore());
        valueListLoaderOptionImpl.setDistinct(bl);
        valueListLoaderOptionImpl.setMaxRecordCount(n);
        valueListLoaderOptionImpl.setUniverse(this.mainRptSetEngine.getUniverse());
        Hashtable hashtable = this.mainRptSetEngine.getParamsBuffer();
        if (hashtable != null && !hashtable.isEmpty()) {
            valueListLoaderOptionImpl.setParameters(new Vector(hashtable.values()));
        }
        if ((jetRptFormulaArray = this.getCFJavaFormula(string, string2)) != null) {
            valueListLoaderOptionImpl.setFormulas(jetRptFormulaArray);
        }
        JavaFormula javaFormula = this.getCell(jReportEngine, string);
        JavaFormulaContainer javaFormulaContainer = new JavaFormulaContainer();
        javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        valueListLoaderOptionImpl.setJavaFormula(javaFormulaContainer);
        this.getConnection(valueListLoaderOptionImpl, string, string2);
        return valueListLoaderOptionImpl;
    }

    private JetRptFormula[] getCFJavaFormula(String string, String string2) {
        JetUUniverse jetUUniverse = this.mainRptSetEngine.getUniverse();
        JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
        if (jetUDatabase == null) {
            return null;
        }
        Vector vector = jetUDatabase.getAllFomulasValidToQuery(string2);
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        JetRptFormula[] jetRptFormulaArray = new JetRptFormula[vector.size()];
        for (int i = 0; i < jetRptFormulaArray.length; ++i) {
            jetRptFormulaArray[i] = ((JetUFormula)vector.get(i)).getRptFormula();
        }
        return jetRptFormulaArray;
    }

    private Hashtable getCatalogKey(JReportEngine jReportEngine, String string, String string2) {
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        String[] stringArray = reportSetCenter.getDataSetNames();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(stringArray[i]);
            JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
            if (!string.equals(jetRptDataSet.getDataSourceName()) || !string2.equals(jetRptDataSet.getQueryName())) continue;
            String string3 = jetRptDataSet.getName();
            Hashtable hashtable2 = reportViewCenter.getCFFormulas(string3);
            if (hashtable2 != null && !hashtable2.isEmpty()) {
                hashtable.putAll(hashtable2);
            }
            if ((hashtable2 = reportViewCenter.getFlyFormulas(string3)) == null || hashtable2.isEmpty()) continue;
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    private JavaFormula getCell(JReportEngine jReportEngine, String string) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        JavaFormula javaFormula = reportSetCenter.getJavaFormula(string);
        return javaFormula;
    }

    private ArrayList getChangeByObject(JReportEngine jReportEngine, String string) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(string);
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        QueryInfo queryInfo = jetRptDataSet.getQueryInfo();
        ArrayList<JavaFormula> arrayList = new ArrayList<JavaFormula>();
        JavaFormula javaFormula = jReportEngine.getCFJavaFormula(queryInfo.getDatasourceName());
        if (javaFormula != null) {
            arrayList.add(javaFormula);
        }
        if (queryInfo.getDataResoureType() == 2 && (javaFormula = jReportEngine.getFlyJavaFormula(queryInfo)) != null) {
            arrayList.add(javaFormula);
        }
        return arrayList;
    }

    private void getChildren(JReportEngine jReportEngine, String string) {
        Object object;
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
        String string2 = reportSetCenter.getDataDriver(string);
        if (string2 == null) {
            object = reportSetCenter.getDataSetCenter(string);
            JetRptDataSet jetRptDataSet = ((DataSetCenter)object).getDataSet();
            string2 = jetRptDataSet.dataDriver.get();
        }
        if (string2 != null && string2.length() > 0 && !string2.equals(SEDU)) {
            object = null;
            try {
                object = this.getCommunicator(string2);
            }
            catch (UDSDriverFormatException uDSDriverFormatException) {
                JRLog.trace(5, uDSDriverFormatException);
                return;
            }
        }
    }

    private String getCommunicator(String string) throws UDSDriverFormatException {
        UDSDriver uDSDriver = null;
        uDSDriver = new UDSDriver(string);
        String[] stringArray = uDSDriver.getParams();
        return stringArray[stringArray.length - 1];
    }

    private void getConnection(ValueListLoaderOptionImpl valueListLoaderOptionImpl, String string, String string2) {
        Vector vector;
        JetUDatabase jetUDatabase;
        JetUUniverse jetUUniverse;
        EngineEnv engineEnv = this.mainRptSetEngine.getEngineEnv();
        IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider = null;
        if (engineEnv != null) {
            iRuntimeQueryInfoProvider = engineEnv.getRuntimeQueryInfoProvider();
        }
        if (iRuntimeQueryInfoProvider == null) {
            return;
        }
        IDynamicQueryInfo iDynamicQueryInfo = iRuntimeQueryInfoProvider.getDynamicQueryInfo(string, string2);
        if (ScheduleTools.isValid(iDynamicQueryInfo)) {
            jetUUniverse = this.mainRptSetEngine.getUniverse();
            int n = iDynamicQueryInfo.getType();
            switch (n) {
                case 1: {
                    valueListLoaderOptionImpl.setResultSet(iDynamicQueryInfo.getResultSet());
                    break;
                }
            }
        }
        if ((jetUDatabase = (jetUUniverse = this.mainRptSetEngine.getUniverse()).getDatabase(string)) != null && (vector = jetUDatabase.getConnections()) != null && !vector.isEmpty()) {
            for (JetUConnection jetUConnection : vector) {
                DatabaseMetadataInfo databaseMetadataInfo;
                String string3 = jetUConnection.getResourceName();
                IDynamicConnectionInfo iDynamicConnectionInfo = iRuntimeQueryInfoProvider.getDynamicConnectionInfo(string, string3);
                if (ScheduleTools.isValid(iDynamicConnectionInfo)) {
                    int n = iDynamicQueryInfo.getType();
                    switch (n) {
                        case 1: {
                            Connection connection = iDynamicConnectionInfo.getConnection();
                            valueListLoaderOptionImpl.setConnection(string3, connection);
                            break;
                        }
                        case 2: {
                            Object object;
                            String string4 = iDynamicConnectionInfo.getJdbcDriver();
                            String string5 = iDynamicConnectionInfo.getUrl();
                            if (jetUConnection instanceof JetUJDBCConnection) {
                                object = (JetUJDBCConnection)jetUConnection;
                                if (string4 == null) {
                                    string4 = ((JetUJDBCConnection)object).getJdbcDriver();
                                }
                                if (string5 == null) {
                                    string5 = ((JetUJDBCConnection)object).getURL();
                                }
                            }
                            valueListLoaderOptionImpl.setJdbcDriverUrl(string3, string5, iDynamicConnectionInfo.getUserId(), iDynamicConnectionInfo.getPassword(), string4);
                            break;
                        }
                        case 3: {
                            Object object = iDynamicConnectionInfo.getConnectionInfoProvider();
                            try {
                                Properties properties = object.getConnectionInfo(string3);
                                valueListLoaderOptionImpl.setConnectionInfo(string3, properties);
                            }
                            catch (RemoteException remoteException) {
                                JRLog.trace(5, remoteException);
                            }
                            break;
                        }
                    }
                }
                if ((databaseMetadataInfo = iRuntimeQueryInfoProvider.getDatabaseMetadataInfo(string, string3)) == null) continue;
                valueListLoaderOptionImpl.setDatabaseMetadataInfo(string3, databaseMetadataInfo);
            }
        }
    }

    public List getValueList(DbBufferDataAdapterRelation dbBufferDataAdapterRelation, String string) {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        try {
            JDbBufferCursor jDbBufferCursor = dbBufferDataAdapterRelation.createCursor();
            JRecord jRecord = jDbBufferCursor.createRecord();
            int n = dbBufferDataAdapterRelation.getRecordModel().indexOfCell(string);
            while (jDbBufferCursor.next()) {
                jRecord.setPosition(jDbBufferCursor.getPosition());
                jRecord.refresh();
                DbValue dbValue = jRecord.getCell(n);
                arrayList.add((DbValue)dbValue.clone());
            }
        }
        catch (DSException dSException) {
            JRLog.trace(5, dSException);
            return null;
        }
        return arrayList;
    }

    public static Group getGroupTree(JReportEngine jReportEngine, IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        IDataResultInfo iDataResultInfo = jReportEngine.getDataResultInfo(iDataContainer, n);
        return iDataResultInfo.getGroupTree();
    }

    public static JGroupQuery getGroupQuery(JReportEngine jReportEngine, IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        JQuery jQuery = jReportEngine.getDataQuery(iDataContainer, n);
        return jQuery instanceof JGroupQuery ? (JGroupQuery)jQuery : null;
    }

    public static boolean isNoRecord(IDataResultInfo iDataResultInfo) {
        boolean bl = true;
        int n = iDataResultInfo.getDataResultType();
        switch (n) {
            case 0: {
                bl = iDataResultInfo.getGroupTree().isNoRecord();
                break;
            }
            case 1: {
                bl = iDataResultInfo.getCrosstabDataResult().isNoRecord();
                break;
            }
        }
        return bl;
    }

    private class GroupInfo {
        private Group SEDU;
        private int[][] I;

        private GroupInfo() {
        }

        static /* synthetic */ int[][] access$102(GroupInfo groupInfo, int[][] nArray) {
            groupInfo.I = nArray;
            return nArray;
        }
    }
}

