/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.design.helper;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.Group;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.ireport.IDataContainer;
import jet.report.JetRptObject;
import jet.report.JetRptParamLink;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.reportLogic.service.DataContainerActionResult;
import jet.reportLogic.service.DataSetActionResult;
import jet.reportLogic.service.ReportActionResult;
import jet.reportLogic.service.ReportSetActionResult;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptOnDemandDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.JCommunicator;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubReportEngine;
import jet.rptservice.api.exception.JRInteractionException;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.BreakPoint;
import jet.rptservice.design.DetailReportScene;
import jet.rptservice.design.Interaction;
import jet.rptservice.design.helper.AbstractHelper;
import jet.rptservice.design.helper.ActionHelper;
import jet.rptservice.design.helper.DataHelper;
import jet.rptservice.design.masterdetail.MasterDetailAPITools;
import jet.rptservice.design.masterdetail.SearchInfo;
import jet.rptservice.design.masterdetail.SeekInfo;
import jet.rptservice.engine.JRSReportEngine;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.JSubRptSetEngine;
import jet.rptservice.engine.infocenter.ActiveMastDetailExecutor;
import jet.rptservice.engine.infocenter.DataContainerNode;
import jet.rptservice.engine.infocenter.DataSetCenter;
import jet.rptservice.engine.infocenter.InactiveMastDetailExecutor;
import jet.rptservice.engine.infocenter.ReportCenter;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.exception.JRSubReportMissedException;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.pub.KeyReportView;
import jet.rptservice.pub.MasterDetailInfo;
import jet.rptservice.util.DataTools;
import jet.rptservice.util.Tools;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLException;
import jet.util.EngineExecuter;
import jet.util.ScheduleTools;

public class ScheduleHelper
extends AbstractHelper {
    public ScheduleHelper(JRptSetEngine jRptSetEngine) {
        super(jRptSetEngine);
    }

    public static void prepareReStartEngine(JReportEngine jReportEngine) {
        ScheduleHelper.prepareReStartEngine(jReportEngine, true);
    }

    public static void prepareReStartEngine(JReportEngine jReportEngine, boolean bl) {
        if (jReportEngine instanceof JSubReportEngine) {
            return;
        }
        JCommunicator jCommunicator = jReportEngine.getCommunicator();
        if (jCommunicator == null || jReportEngine.getStreamEngine() == null) {
            return;
        }
        ScheduleHelper.SEDU(jReportEngine);
        ScheduleHelper.add(jReportEngine);
        if (bl) {
            ScheduleHelper.addJoinName(jReportEngine);
        }
    }

    private static void SEDU(JReportEngine jReportEngine) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        if (jRptSetEngine.isOnDemandReport()) {
            JCommunicator jCommunicator = jReportEngine.getCommunicator();
            try {
                while (!jCommunicator.isEngineFinished() && !jReportEngine.getStreamEngine().isPaused()) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                Tools.logTrace(5, interruptedException);
            }
        } else {
            jReportEngine.waitFinished();
        }
    }

    private static void add(JReportEngine jReportEngine) {
        JCommunicator jCommunicator = jReportEngine.getCommunicator();
        try {
            while (!jCommunicator.isTouchGroupsBreak()) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            Tools.logTrace(5, interruptedException);
        }
    }

    private static void addAll(JReportEngine jReportEngine) {
        jReportEngine.waitFinished();
    }

    private static void addElement(JRptSetEngine jRptSetEngine, String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DesignServiceImpl.waitEngineFinished()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        if (!jRptSetEngine.isRunning()) {
            Tools.logTrace(6, "End of DesignServiceImpl.waitEngineFinished(), no any reports are running.");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = jRptSetEngine.getReportViewEngine(stringArray[i], string);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "wait finished, rptName: " + stringArray[i] + " viewName: " + string);
                }
                ScheduleHelper.addAll(jReportEngine);
            }
        }
        Tools.logTrace(6, "End of DesignServiceImpl.waitEngineFinished().");
    }

    private static void addJoinName(JReportEngine jReportEngine) {
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        if (jRptSetEngine.isOnDemandReport()) {
            jReportEngine.stopLayoutOnly();
        }
    }

    public static boolean syncMasterDetailEngine(JReportEngine jReportEngine) {
        Group[] groupArray;
        Tools.logTrace(6, "ScheduleHelper.syncMasterDetailEngine()...");
        JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
        if (jRptSetEngine.getType() != 2) {
            JRLog.error(1, "Inhibitory invoke, engine type does not match, type: " + jRptSetEngine.getType());
            Tools.logTrace(6, "End of DesignServiceImpl.syncMasterDetailEngine(), return false.");
            return false;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        if (reportViewCenter.getSyncStatus() != 2) {
            Tools.logTrace(6, "master and detail report is already synchnorization.");
            Tools.logTrace(6, "End of ScheduleHelper.syncMasterDetailEngine(), return true.");
            return true;
        }
        if (reportViewCenter.hasCloseMaster()) {
            Tools.logTrace(6, "master report has been closed.");
            Tools.logTrace(6, "End of ScheduleHelper.syncMasterDetailEngine(), return true.");
            return true;
        }
        InactiveMastDetailExecutor inactiveMastDetailExecutor = reportViewCenter.getMasterExecutor();
        ActiveMastDetailExecutor activeMastDetailExecutor = (ActiveMastDetailExecutor)inactiveMastDetailExecutor;
        JReportEngine jReportEngine2 = jRptSetEngine.getParentEngine();
        String string = reportViewCenter.getMasterDetailInfo().getParentComponentName();
        JetRptObject jetRptObject = (JetRptObject)jReportEngine2.getReport().nameToObject(string);
        try {
            groupArray = DataHelper.getGroupTrees(jReportEngine2, jetRptObject);
        }
        catch (JRStopEngineException jRStopEngineException) {
            JRLog.error(1, new JRScheduleException(220042, (Throwable)jRStopEngineException));
            Tools.logTrace(6, jRStopEngineException);
            Tools.logTrace(6, "End of ScheduleHelper.syncMasterDetailEngine(), return false.");
            return false;
        }
        catch (JRScheduleException jRScheduleException) {
            JRLog.error(1, jRScheduleException);
            Tools.logTrace(6, jRScheduleException);
            Tools.logTrace(6, "End of ScheduleHelper.syncMasterDetailEngine(), return false.");
            return false;
        }
        boolean bl = false;
        IDataContainer iDataContainer = jReportEngine2.getReportViewCenter().getQueryDataContainer(jetRptObject);
        JRecord jRecord = activeMastDetailExecutor.current();
        try {
            JDbBufferCursor jDbBufferCursor = DataHelper.getCursor(jReportEngine2, string);
            SearchInfo searchInfo = MasterDetailAPITools.createSearchInfo(groupArray, jetRptObject, iDataContainer, jDbBufferCursor, jRecord);
            if (searchInfo != null) {
                SeekInfo seekInfo = activeMastDetailExecutor.search(searchInfo);
                if (seekInfo != null) {
                    bl = activeMastDetailExecutor.seek(seekInfo);
                    if (bl) {
                        reportViewCenter.setSyncStatus(1);
                    } else {
                        reportViewCenter.setSyncStatus(3);
                        Tools.logTrace(6, "failed to search data.");
                    }
                } else {
                    activeMastDetailExecutor.blockRecord();
                    reportViewCenter.setSyncStatus(3);
                }
            } else {
                Tools.logTrace(6, "!!error schedule logic, should not reach here.");
            }
        }
        catch (JRScheduleException jRScheduleException) {
            JRLog.error(1, jRScheduleException);
            Tools.logTrace(4, jRScheduleException);
        }
        Tools.logTrace(6, "End of ScheduleHelper.syncMasterDetailEngine(), return " + bl);
        return bl;
    }

    public static void notifyDetailEngineClosed(JReportEngine jReportEngine) throws JRStopEngineException, JRScheduleException {
        Tools.logTrace(6, "ScheduleHelper.notifyDetailEngineClose()...");
        JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
        for (int i = -1; i < jSubReportEngineArray.length; ++i) {
            JReportEngine jReportEngine2 = i == -1 ? jReportEngine : jSubReportEngineArray[i];
            ReportViewCenter reportViewCenter = jReportEngine2.getReportViewCenter();
            DetailReportScene detailReportScene = ScheduleHelper.getActiveDetailReportScene(jReportEngine2);
            String[] stringArray = detailReportScene.getParentObjectNames();
            if (stringArray == null || stringArray.length <= 0) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                JReportEngine jReportEngine3 = detailReportScene.getReportEngine(stringArray[j]);
                ReportViewCenter reportViewCenter2 = jReportEngine3.getReportViewCenter();
                MasterDetailInfo masterDetailInfo = reportViewCenter2.getMasterDetailInfo();
                InactiveMastDetailExecutor inactiveMastDetailExecutor = null;
                JRptSetEngine jRptSetEngine = jReportEngine2.getRptSetEngine();
                ResourceStore resourceStore = jRptSetEngine.getEngineEnv().getResourceStore();
                DiskStore diskStore = resourceStore == null ? null : resourceStore.getDiskStore();
                try {
                    inactiveMastDetailExecutor = MasterDetailAPITools.createInactiveExecutor(detailReportScene.getGroups(stringArray[j]), detailReportScene.getPosition(stringArray[j]), (ActiveMastDetailExecutor)reportViewCenter2.getMasterExecutor(), detailReportScene.getCursor(stringArray[j]), diskStore);
                    reportViewCenter2.setMasterExecutor(inactiveMastDetailExecutor);
                    continue;
                }
                catch (JRScheduleException jRScheduleException) {
                    JRLog.trace(4, jRScheduleException);
                }
            }
            reportViewCenter.nodifyDetailReportClose();
        }
        Tools.logTrace(6, "End of ScheduleHelper.notifyDetailEngineClose().");
    }

    public static void notifyDetailEngineRemoved(JReportEngine jReportEngine, DetailReportScene detailReportScene) {
        String[] stringArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.notifyDetailEngineRemoved()..., parentViewEngine: " + jReportEngine + " drs: " + detailReportScene);
        }
        if ((stringArray = detailReportScene.getParentObjectNames()) != null && stringArray.length > 0) {
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            JetRptReport jetRptReport = reportViewCenter.getOriReportView();
            for (int i = 0; i < stringArray.length; ++i) {
                JReportEngine jReportEngine2 = detailReportScene.getReportEngine(stringArray[i]);
                ReportViewCenter reportViewCenter2 = jReportEngine2.getReportViewCenter();
                MasterDetailInfo masterDetailInfo = reportViewCenter2.getMasterDetailInfo();
                if (jetRptReport.nameToObject(masterDetailInfo.getParentComponentName()) != null && jetRptReport.nameToObject(masterDetailInfo.getParentQueryDCName()) != null) continue;
                JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
                ResourceStore resourceStore = jRptSetEngine.getEngineEnv().getResourceStore();
                DiskStore diskStore = resourceStore == null ? null : resourceStore.getDiskStore();
                InactiveMastDetailExecutor inactiveMastDetailExecutor = null;
                try {
                    inactiveMastDetailExecutor = MasterDetailAPITools.createInactiveExecutor(detailReportScene.getGroups(stringArray[i]), detailReportScene.getPosition(stringArray[i]), (ActiveMastDetailExecutor)reportViewCenter2.getMasterExecutor(), detailReportScene.getCursor(stringArray[i]), diskStore);
                    reportViewCenter2.setMasterExecutor(inactiveMastDetailExecutor);
                }
                catch (JRScheduleException jRScheduleException) {
                    JRLog.trace(4, jRScheduleException);
                }
                reportViewCenter.nodifyDetailReportClose(masterDetailInfo.getParentComponentName());
            }
        }
        Tools.logTrace(6, "End of ScheduleHelper.notifyDetailEngineRemoved().");
    }

    public static void closeMasterDetaiExecutors(JReportEngine jReportEngine) {
        JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
        for (int i = -1; i < jSubReportEngineArray.length; ++i) {
            JReportEngine jReportEngine2 = i == -1 ? jReportEngine : jSubReportEngineArray[i];
            InactiveMastDetailExecutor inactiveMastDetailExecutor = jReportEngine2.getReportViewCenter().getMasterExecutor();
            if (inactiveMastDetailExecutor == null) continue;
            inactiveMastDetailExecutor.close();
        }
    }

    private String append(int n) {
        String string = "unknown";
        switch (n) {
            case 0: {
                string = "unconfirmed";
                break;
            }
            case 1: {
                string = "style";
                break;
            }
            case 3: {
                string = "layout";
                break;
            }
            case 7: {
                string = "goto";
                break;
            }
            case 15: {
                string = "browse_data";
                break;
            }
            case 31: {
                string = "sync_data";
                break;
            }
            case 63: {
                string = "whole_data";
                break;
            }
        }
        return string;
    }

    private String[] applyStyleNls(JetRptSubReport jetRptSubReport, DataContainerNode dataContainerNode) {
        Vector vector = new Vector();
        List list = jetRptSubReport.getSubLinkContainers();
        for (int i = 0; list != null && i < list.size(); ++i) {
            JetRptSubLinkContainer jetRptSubLinkContainer = (JetRptSubLinkContainer)list.get(i);
            Vector vector2 = jetRptSubLinkContainer.targetCompInst.get();
            if (vector2 == null) continue;
            vector.removeAll(vector2);
            vector.addAll(vector2);
        }
        return vector.toArray(new String[vector.size()]);
    }

    private String[] asList(List list, DataContainerNode dataContainerNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            DataContainerNode dataContainerNode2 = dataContainerNode.getNode(string);
            if (dataContainerNode2 == null) continue;
            Vector vector = new Vector();
            dataContainerNode2.getDescendant(vector);
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = ((DataContainerNode)vector.elementAt(i)).getContainerName();
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private void blockRecord(JRptSetEngine jRptSetEngine, String string, String string2, Map map, Map map2) {
        if (map == null || !map.containsKey(String.valueOf(0))) {
            return;
        }
        ReportSetActionResult reportSetActionResult = (ReportSetActionResult)map.get(String.valueOf(0));
        ReportActionResult[] reportActionResultArray = reportSetActionResult.getReportActionResults();
        if (reportActionResultArray == null || reportActionResultArray.length == 0) {
            return;
        }
        HashMap hashMap = new HashMap();
        if (map2 != null && !map2.isEmpty()) {
            hashMap.putAll(map2);
        }
        this.chkJoinPath(hashMap, string, string2);
        for (int i = 0; i < reportActionResultArray.length; ++i) {
            String string3;
            String string4;
            if (reportActionResultArray[i].isEmpty() || this.clearCachedDisplayNameValuese(hashMap, string4 = reportActionResultArray[i].getReportName(), string3 = reportActionResultArray[i].getViewName())) continue;
            ReportViewCenter reportViewCenter = (ReportViewCenter)reportActionResultArray[i].getReportViewCenter();
            reportViewCenter.getReportViewEngine().stopLayoutOnly();
            reportViewCenter.setActionRst(reportSetActionResult);
        }
    }

    private void chkJoinPath(Map map, String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        Vector vector = null;
        if (map.containsKey(string)) {
            vector = (Vector)map.get(string);
        } else {
            vector = new Vector();
            map.put(string, vector);
        }
        if (!vector.contains(string2)) {
            vector.addElement(string2);
        }
    }

    private boolean clearCachedDisplayNameValuese(Map map, String string, String string2) {
        Vector vector;
        if (map == null) {
            return false;
        }
        boolean bl = false;
        if (map.containsKey(string) && (vector = (Vector)map.get(string)) != null && vector.contains(string2)) {
            bl = true;
        }
        return bl;
    }

    private boolean clearDataSetCenter(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private int close(int n, int n2) {
        return n | n2;
    }

    private void closeCubeData(JReportEngine jReportEngine, String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DesignServiceImpl.notifyDetailEngineRefresh()..., dcNames: " + Tools.toString(stringArray));
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        for (int i = 0; i < stringArray.length; ++i) {
            IDataContainer iDataContainer = (IDataContainer)((Object)reportViewCenter.getReportView().nameToObject(stringArray[i]));
            reportViewCenter.nodifyDetailReportRefresh(iDataContainer);
        }
        Tools.logTrace(6, "End of DesignServiceImpl.notifyDetailEngineRefresh().");
    }

    private String[] closeQuerysForSelf(DataSetActionResult[] dataSetActionResultArray) {
        if (dataSetActionResultArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dataSetActionResultArray.length; ++i) {
            if (dataSetActionResultArray[i].getOperation() != 2 && (dataSetActionResultArray[i].getOperation() != 3 && dataSetActionResultArray[i].getOperation() != 4 || dataSetActionResultArray[i].getDataLevel() != 3)) continue;
            arrayList.add(dataSetActionResultArray[i].getObjectName());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] closeRawData(DataSetActionResult[] dataSetActionResultArray) {
        if (dataSetActionResultArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dataSetActionResultArray.length; ++i) {
            if (dataSetActionResultArray[i].getOperation() != 3 && dataSetActionResultArray[i].getOperation() != 4 || dataSetActionResultArray[i].getDataLevel() != 1) continue;
            arrayList.add(dataSetActionResultArray[i].getObjectName());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] contains(DataSetActionResult[] dataSetActionResultArray) {
        if (dataSetActionResultArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < dataSetActionResultArray.length; ++i) {
            if (dataSetActionResultArray[i].getOperation() != 2) continue;
            arrayList.add(dataSetActionResultArray[i].getObjectName());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    public void stopInvalidReports(String string, String string2) {
        Vector vector = this.mainRptSetEngine.getAllReportViewEngines();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ReportViewCenter reportViewCenter;
                JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
                String string3 = jReportEngine.getReportViewCenter().getRptCenter().getRptName();
                String string4 = jReportEngine.getReportViewCenter().getViewName();
                if (string3.equals(string) && string4.equals(string2) || !(reportViewCenter = jReportEngine.getReportViewCenter()).isReportValid()) continue;
                jReportEngine.stopLayoutOnly();
            }
        }
    }

    private void containsKey(JSubReportEngine jSubReportEngine, JetRptSubReport jetRptSubReport) {
        ReportSetActionResult reportSetActionResult;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelperget.closeDataInstanceInSubRpt()..., subViewengine: " + jSubReportEngine + " subRpt: " + jetRptSubReport);
        }
        if ((reportSetActionResult = this.createInactiveExecutor(jSubReportEngine, jetRptSubReport)) != null) {
            DataSetActionResult[] dataSetActionResultArray;
            Object object;
            String string;
            ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
            ReportSetCenter reportSetCenter = reportViewCenter.getRptCenter().getRptSetCenter();
            JRptSetEngine jRptSetEngine = reportSetCenter.getRptSetEngine();
            ReportActionResult[] reportActionResultArray = reportSetActionResult.getReportActionResults();
            if (reportActionResultArray != null && reportActionResultArray.length > 0) {
                for (int i = 0; i < reportActionResultArray.length; ++i) {
                    DataContainerActionResult[] dataContainerActionResultArray = reportActionResultArray[i].getDataContainerActionResults();
                    string = reportActionResultArray[i].getReportName();
                    object = reportActionResultArray[i].getViewName();
                    JSubReportEngine jSubReportEngine2 = (JSubReportEngine)jRptSetEngine.getReportViewEngine(string, (String)object);
                    ReportViewCenter reportViewCenter2 = jSubReportEngine2.getReportViewCenter();
                    for (int j = 0; j < dataContainerActionResultArray.length; ++j) {
                        String string2 = dataContainerActionResultArray[j].getObjectName();
                        int n = dataContainerActionResultArray[j].getDataLevel();
                        boolean bl = n == 63;
                        boolean bl2 = n == 15 || bl;
                        this.error(jSubReportEngine2, string2, reportViewCenter2.getRootDataContainer(), bl, bl2);
                    }
                }
            }
            if ((dataSetActionResultArray = reportSetActionResult.getDataSetActionResults()) != null && dataSetActionResultArray.length > 0) {
                for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                    string = dataSetActionResultArray[i].getObjectName();
                    object = reportSetCenter.getDataSetCenter(string);
                    ((DataSetCenter)object).clearCachedDisplayNameValuese();
                }
                this.getActiveDetailReportScene(jRptSetEngine, dataSetActionResultArray);
                this.getActionRst(jRptSetEngine, dataSetActionResultArray);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleHelperget.closeDataInstanceInSubRpt().");
        }
    }

    /*
     * WARNING - void declaration
     */
    private ReportSetActionResult createInactiveExecutor(JSubReportEngine jSubReportEngine, JetRptSubReport jetRptSubReport) {
        Object[] objectArray;
        Object object;
        DataSetActionResult[] dataSetActionResultArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.getSubReportSetActionResult()..., subViewengine: " + jSubReportEngine + " subRpt: " + jetRptSubReport);
        }
        ReportSetActionResult reportSetActionResult = null;
        ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
        ReportSetCenter reportSetCenter = reportViewCenter.getRptCenter().getRptSetCenter();
        JRptSetEngine jRptSetEngine = reportSetCenter.getRptSetEngine();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "subRptSetEngine: " + jRptSetEngine + " subRptSetName: " + jRptSetEngine.getReportSet().getInstName() + " subRptName: " + reportViewCenter.getRptName() + " subViewName: " + reportViewCenter.getViewName());
        }
        ArrayList arrayList = new ArrayList();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        DataContainerNode dataContainerNode = jSubReportEngine.getReportViewCenter().getRootDataContainer();
        String[] stringArray = this.applyStyleNls(jetRptSubReport, dataContainerNode);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "target data containers: " + Tools.toString(stringArray));
        }
        ArrayList<String> arrayList2 = stringArray != null && stringArray.length > 0 ? new ArrayList<String>(Arrays.asList(stringArray)) : new ArrayList<String>();
        List list = this.current(jetRptSubReport);
        if (list.isEmpty()) {
            if (!arrayList2.isEmpty()) {
                this.createSearchInfo(arrayList2, reportViewCenter.getRootDataContainer());
                hashMap.put(this.elementAt(jSubReportEngine), arrayList2);
            }
        } else {
            void var15_18;
            Object object2;
            if (!arrayList2.isEmpty()) {
                hashMap.put(this.elementAt(jSubReportEngine), arrayList2);
            }
            dataSetActionResultArray = jRptSetEngine.getAllReportViewEngines();
            for (JReportEngine stringArray22 : dataSetActionResultArray) {
                Iterator iterator = this.elementAt(stringArray22);
                String[] stringArray2 = stringArray22.getReportViewCenter().getAllDataContainerNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    object = reportViewCenter.getMappingFields(1, stringArray2[i]);
                    ((Vector)object).retainAll(list);
                    if (((Vector)object).isEmpty()) continue;
                    object2 = (List)hashMap.get(iterator);
                    if (object2 == null) {
                        object2 = new ArrayList();
                        hashMap.put(iterator, object2);
                    }
                    if (object2.contains(stringArray2[i])) continue;
                    object2.add(stringArray2[i]);
                }
            }
            objectArray = reportSetCenter.getDataSetNames();
            Object i = null;
            try {
                String[] arrayList4 = ActionHelper.getDataSetNamesUseParameter(reportSetCenter, (String[])objectArray, list.toArray(new String[0]));
            }
            catch (JRScheduleException jRScheduleException) {
                JRLog.trace(4, jRScheduleException);
            }
            if (var15_18 != null && ((void)var15_18).length > 0) {
                arrayList.addAll(Arrays.asList(var15_18));
                for (JReportEngine jReportEngine : dataSetActionResultArray) {
                    Object object3;
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    object = jReportEngine.getReportViewCenter();
                    object2 = ((ReportViewCenter)object).getAllDataContainerNames();
                    Object object4 = ((ReportViewCenter)object).getRootDataContainer();
                    for (int j = 0; j < ((String[])object2).length; ++j) {
                        String string;
                        object3 = ((DataContainerNode)object4).findNodeByName((String)object2[j]);
                        if (object3 == null || (string = ((DataContainerNode)object3).getDataSetName()) == null || !arrayList.contains(string)) continue;
                        arrayList3.add(object2[j]);
                    }
                    KeyReportView keyReportView = this.elementAt(jReportEngine);
                    if (arrayList3.isEmpty()) continue;
                    if (hashMap.containsKey(keyReportView)) {
                        object3 = (List)hashMap.get(keyReportView);
                        arrayList3.removeAll((Collection<?>)object3);
                        arrayList3.addAll((Collection<Object>)object3);
                    }
                    hashMap.put(keyReportView, arrayList3);
                }
            }
            for (JReportEngine jReportEngine : dataSetActionResultArray) {
                KeyReportView keyReportView = this.elementAt(jReportEngine);
                object = (List)hashMap.get(keyReportView);
                this.createSearchInfo((List)object, jReportEngine.getReportViewCenter().getRootDataContainer());
            }
        }
        if (!hashMap.isEmpty() || !arrayList.isEmpty()) {
            dataSetActionResultArray = null;
            objectArray = null;
            if (!arrayList.isEmpty()) {
                void var15_20;
                dataSetActionResultArray = new DataSetActionResult[arrayList.size()];
                boolean bl = false;
                while (var15_20 < arrayList.size()) {
                    dataSetActionResultArray[var15_20] = new DataSetActionResult((String)arrayList.get((int)var15_20), 4, 3);
                    ++var15_20;
                }
            }
            if (!hashMap.isEmpty()) {
                ArrayList<ReportActionResult> arrayList4 = new ArrayList<ReportActionResult>();
                for (KeyReportView keyReportView : hashMap.keySet()) {
                    List list2 = (List)hashMap.get(keyReportView);
                    object = new ArrayList();
                    for (Object object4 : list2) {
                        ((ArrayList)object).add(new DataContainerActionResult((String)object4, 4, 63));
                    }
                    arrayList4.add(new ReportActionResult(((ArrayList)object).toArray(new DataContainerActionResult[0]), reportSetCenter.getReportViewCenter(keyReportView.getRptName(), keyReportView.getViewName())));
                }
                objectArray = arrayList4.toArray(new ReportActionResult[0]);
            }
            reportSetActionResult = new ReportSetActionResult(dataSetActionResultArray, (ReportActionResult[])objectArray);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleHelper.getSubReportSetActionResult(), return: " + reportSetActionResult);
        }
        return reportSetActionResult;
    }

    private void createSearchInfo(List list, DataContainerNode dataContainerNode) {
        if (list != null && !list.isEmpty()) {
            String[] stringArray = this.asList(list, dataContainerNode);
            for (int i = 0; i < stringArray.length; ++i) {
                if (list.contains(stringArray[i])) continue;
                list.add(stringArray[i]);
            }
        }
    }

    private List current(JetRptSubReport jetRptSubReport) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelperget.getDataRelativeParamNames()..., subRpt: " + jetRptSubReport);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = jetRptSubReport.getParameterLinks();
        if (list != null && !list.isEmpty()) {
            for (JetRptParamLink jetRptParamLink : list) {
                String string = jetRptParamLink.getSubColumn().toUpperCase();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleHelperget.getDataRelativeParamNames(), return: " + arrayList);
        }
        return arrayList;
    }

    private KeyReportView elementAt(JReportEngine jReportEngine) {
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        ReportCenter reportCenter = reportViewCenter.getRptCenter();
        return new KeyReportView(reportCenter.getRptName(), reportViewCenter.getViewName());
    }

    private void equals(JReportEngine jReportEngine, IDataContainer iDataContainer, boolean bl, boolean bl2) {
        if (bl) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "close original group query for data container: " + iDataContainer.getInstName());
                }
                jReportEngine.closeQuerysForSelf(iDataContainer.getInstName(), true);
            }
            catch (JRScheduleException jRScheduleException) {
                Tools.logTrace(5, jRScheduleException);
            }
        }
        if (bl2) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "close current group query for data container: " + iDataContainer.getInstName());
                }
                jReportEngine.closeQuerysForSelf(iDataContainer.getInstName(), false);
            }
            catch (JRScheduleException jRScheduleException) {
                Tools.logTrace(5, jRScheduleException);
            }
        }
    }

    private void error(JReportEngine jReportEngine, String string, DataContainerNode dataContainerNode, boolean bl, boolean bl2) {
        block13: {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ScheduleHelperget.closeGroupQueries()..., viewEngine: " + jReportEngine + " dcName: " + string + " root: " + dataContainerNode + " closeOriQueries: " + bl + " closeCurQueries: " + bl2);
            }
            if (bl2) {
                try {
                    String[] stringArray;
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "close current group query for data container: " + string);
                    }
                    jReportEngine.closeQuerysForSelf(string, false);
                    DataContainerNode dataContainerNode2 = dataContainerNode.getNode(string);
                    if (dataContainerNode2 == null || (stringArray = dataContainerNode2.getSubRptInstNames()) == null) break block13;
                    JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
                    JReportEngine jReportEngine2 = jRptSetEngine instanceof JSubRptSetEngine ? ((JSubRptSetEngine)jRptSetEngine).getMainViewEngine() : jReportEngine;
                    JetRptReport jetRptReport = jReportEngine.getReport();
                    for (int i = 0; i < stringArray.length; ++i) {
                        JetRptSubReport jetRptSubReport = (JetRptSubReport)jetRptReport.nameToObject(stringArray[i]);
                        if (jetRptSubReport == null) continue;
                        JSubReportEngine jSubReportEngine = null;
                        try {
                            jSubReportEngine = jReportEngine2.getSubReportEngine(jetRptSubReport);
                        }
                        catch (JRSubReportMissedException jRSubReportMissedException) {
                            Tools.logTrace(5, jRSubReportMissedException);
                        }
                        if (jSubReportEngine == null) continue;
                        this.containsKey(jSubReportEngine, jetRptSubReport);
                    }
                }
                catch (JRScheduleException jRScheduleException) {
                    Tools.logTrace(5, jRScheduleException);
                }
            }
        }
        if (bl) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "close original group query for data container: " + string);
                }
                jReportEngine.closeQuerysForSelf(string, true);
            }
            catch (JRScheduleException jRScheduleException) {
                Tools.logTrace(5, jRScheduleException);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleHelperget.closeGroupQueries().");
        }
    }

    private void findNodeByName(ReportActionResult reportActionResult, ReportViewCenter reportViewCenter) {
        String[] stringArray = reportActionResult.getActionDataContainerNamesWithOp(2);
        this.get(stringArray, reportViewCenter, reportActionResult.getOriDCRootNode());
        DataContainerActionResult[] dataContainerActionResultArray = reportActionResult.getModifyKeepDataContainerActionResults();
        this.getActionDataContainerNamesWithDataLevel(dataContainerActionResultArray, reportViewCenter, reportViewCenter.getRootDataContainer());
        stringArray = reportActionResult.getActionDataContainerNamesWithOp(1);
        this.getActionDataContainerNamesWithOp(stringArray, reportViewCenter);
    }

    private void get(String[] stringArray, ReportViewCenter reportViewCenter, DataContainerNode dataContainerNode) {
        Tools.logTrace(6, "ScheduleHelper.closeRemovedDataInstance()...");
        if (stringArray != null && stringArray.length > 0) {
            JReportEngine jReportEngine = reportViewCenter.getReportViewEngine();
            ScheduleHelper.prepareReStartEngine(jReportEngine);
            for (int i = 0; i < stringArray.length; ++i) {
                Tools.logTrace(6, "handle data container: " + stringArray[i]);
                Tools.logTrace(6, "remove current and original value list.");
                reportViewCenter.removeCurVauleList(stringArray[i]);
                reportViewCenter.removeOriValueList(stringArray[i]);
                this.error(jReportEngine, stringArray[i], dataContainerNode, true, true);
            }
        }
        Tools.logTrace(6, "End of ScheduleHelper.closeRemovedDataInstance().");
    }

    private void getActionDataContainerNamesWithDataLevel(DataContainerActionResult[] dataContainerActionResultArray, ReportViewCenter reportViewCenter, DataContainerNode dataContainerNode) {
        Tools.logTrace(6, "ScheduleHelper.closeExpiredDataInstance()...");
        if (dataContainerActionResultArray != null && dataContainerActionResultArray.length > 0) {
            JReportEngine jReportEngine = reportViewCenter.getReportViewEngine();
            ScheduleHelper.prepareReStartEngine(jReportEngine);
            for (int i = 0; i < dataContainerActionResultArray.length; ++i) {
                String string = dataContainerActionResultArray[i].getObjectName();
                Tools.logTrace(6, "handle data container: " + string);
                if (dataContainerActionResultArray[i].getDataLevel() == 7) {
                    Tools.logTrace(6, "close goto data, do nothing.");
                    continue;
                }
                if (dataContainerActionResultArray[i].getDataLevel() == 15) {
                    Tools.logTrace(6, "close browse data.");
                    reportViewCenter.removeCurVauleList(dataContainerActionResultArray[i].getObjectName());
                    this.error(jReportEngine, string, dataContainerNode, false, true);
                    continue;
                }
                if (dataContainerActionResultArray[i].getDataLevel() == 31) {
                    Tools.logTrace(6, "sync data.");
                    continue;
                }
                if (dataContainerActionResultArray[i].getDataLevel() != 63) continue;
                Tools.logTrace(6, "close whole data.");
                reportViewCenter.removeCurVauleList(dataContainerActionResultArray[i].getObjectName());
                reportViewCenter.removeOriValueList(dataContainerActionResultArray[i].getObjectName());
                this.error(jReportEngine, string, dataContainerNode, true, true);
            }
        }
        Tools.logTrace(6, "End of ScheduleHelper.closeExpiredDataInstance().");
    }

    private void getActionDataContainerNamesWithOp(String[] stringArray, ReportViewCenter reportViewCenter) {
        Tools.logTrace(6, "ScheduleHelper.closeNewDataDataInstance()...");
        if (stringArray != null && stringArray.length > 0) {
            JReportEngine jReportEngine = reportViewCenter.getReportViewEngine();
            ScheduleHelper.prepareReStartEngine(jReportEngine);
        }
        Tools.logTrace(6, "End of ScheduleHelper.closeNewDataDataInstance().");
    }

    private void getActionRst(JRptSetEngine jRptSetEngine, DataSetActionResult[] dataSetActionResultArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.closeRawData()..., dsars: " + Tools.toString(dataSetActionResultArray));
        }
        String[] stringArray = this.closeQuerysForSelf(dataSetActionResultArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "raw data set names: " + Tools.toString(stringArray));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                DataSetCenter dataSetCenter = jRptSetEngine.getReportSetCenter().getDataSetCenter(stringArray[i]);
                dataSetCenter.closeRawData(jRptSetEngine.getDataService());
            }
        }
        Tools.logTrace(6, "End of ScheduleHelper.closeRawData().");
    }

    private void getActiveDetailReportScene(JRptSetEngine jRptSetEngine, DataSetActionResult[] dataSetActionResultArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.closeCubeData()..., dsars: " + Tools.toString(dataSetActionResultArray));
        }
        String[] stringArray = this.closeRawData(dataSetActionResultArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "cube data set names: " + Tools.toString(stringArray));
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            DataSetCenter dataSetCenter = jRptSetEngine.getReportSetCenter().getDataSetCenter(stringArray[i]);
            dataSetCenter.closeCubeData(jRptSetEngine.getDataService());
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ScheduleHelper.closeCubeData().");
        }
    }

    private void getActualDataLevel(JRptSetEngine jRptSetEngine, DataSetActionResult[] dataSetActionResultArray) {
        Tools.logTrace(6, "JRptSetEngine.setDefaultJoinPath()...");
        if (dataSetActionResultArray == null || dataSetActionResultArray.length == 0) {
            return;
        }
        JetUUniverse jetUUniverse = jRptSetEngine.getUniverse();
        for (int i = 0; i < dataSetActionResultArray.length; ++i) {
            JetRptDataSet jetRptDataSet;
            if (dataSetActionResultArray[i].getOperation() != 1 && (dataSetActionResultArray[i].getOperation() != 3 || dataSetActionResultArray[i].getDataLevel() != 3) || (jetRptDataSet = jRptSetEngine.getReportSet().getDataSet(dataSetActionResultArray[i].getObjectName())) == null || jetRptDataSet.getMappingListSrc() != 4) continue;
            String[] stringArray = ((JetRptOnDemandDataSet)jetRptDataSet).getJoinNames().toArray(new String[0]);
            String[] stringArray2 = jRptSetEngine.getDbFieldPass1FormulaNames(jetRptDataSet.getInstName());
            String string = jetRptDataSet.getDataSourceName();
            String string2 = jetRptDataSet.getQueryName();
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jetUUniverse);
            if (keyDataSourceQuery != null) {
                string2 = keyDataSourceQuery.getQueryName();
            }
            String[] stringArray3 = null;
            try {
                stringArray3 = DataTools.chkJoinPath(jetUUniverse, string, string2, stringArray, stringArray2);
            }
            catch (BLException bLException) {
                JRLog.error(2, bLException);
            }
            if (stringArray3 == null || stringArray3.length == 0) continue;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "add join path: " + stringArray3[0]);
            }
            ((JetRptOnDemandDataSet)jetRptDataSet).addJoinName(stringArray3[0]);
        }
        Tools.logTrace(6, "End of JRptSetEngine.setDefaultJoinPath().");
    }

    private boolean getAllDataContainerNames(JRptSetEngine jRptSetEngine, String string, String string2, Map map) throws JRSInvalidParameterException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.applyStyleNls()..., mainRptName: " + string + " mActRst: " + map);
        }
        boolean bl = false;
        JReportEngine jReportEngine = jRptSetEngine.getReportViewEngine(string, string2);
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        if (map != null && !map.isEmpty()) {
            for (String string3 : map.keySet()) {
                ReportSetActionResult reportSetActionResult = (ReportSetActionResult)map.get(string3);
                JReportEngine jReportEngine2 = reportViewCenter.getRptViewEngine(string3);
                ReportViewCenter reportViewCenter2 = jReportEngine2.getReportViewCenter();
                JRptSetEngine jRptSetEngine2 = jReportEngine2.getRptSetEngine();
                String string4 = reportViewCenter2.getRptCenter().getRptName();
                String string5 = reportViewCenter2.getViewName();
                if (!(jRptSetEngine2 instanceof JSubRptSetEngine) && (!string4.equals(string) || !string5.equals(string2))) continue;
                int n = 0;
                DataContainerActionResult[] dataContainerActionResultArray = reportSetActionResult.getDataContainerActionResults(string4, string5);
                if (dataContainerActionResultArray != null && dataContainerActionResultArray.length > 0) {
                    for (int i = 0; i < dataContainerActionResultArray.length; ++i) {
                        n = this.close(n, dataContainerActionResultArray[i].getActualDataLevel());
                    }
                }
                if (n != true) continue;
                JRSReportEngine jRSReportEngine = jRptSetEngine2.getReportEngine(string4);
                bl = bl || jRSReportEngine.applyStyleNls(string5);
            }
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "End of ScheduleHelper.applyStyleNls(), return: " + bl);
        }
        return bl;
    }

    private boolean getAllReportViewEngines(JRptSetEngine jRptSetEngine, String string, String string2) {
        JReportEngine jReportEngine = jRptSetEngine.getReportViewEngine(string, string2);
        return jReportEngine == null ? false : jReportEngine.getCommunicator() != null;
    }

    public void prepareRunInvalidSubReport(String string, String string2) throws JRSInvalidParameterException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.prepareRunInvalidSubReport()..., mainRptName: " + string + " mainViewName: " + string2);
        }
        String[] stringArray = this.mainRptSetEngine.getReportNames();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = this.mainRptSetEngine.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                DataSetActionResult[] dataSetActionResultArray;
                ReportSetActionResult reportSetActionResult;
                if (string.equals(stringArray[i]) && string2.equals(stringArray2[j])) continue;
                HashMap<DataSetActionResult[], ReportSetActionResult> hashMap = new HashMap<DataSetActionResult[], ReportSetActionResult>();
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[j]);
                ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
                JSubReportEngine[] jSubReportEngineArray = reportViewCenter.getAllSubReportEngine();
                for (int k = 0; jSubReportEngineArray != null && k < jSubReportEngineArray.length; ++k) {
                    Object object = jSubReportEngineArray[k].getReportViewCenter();
                    reportSetActionResult = ((ReportViewCenter)object).getActionRst();
                    if (reportSetActionResult == null) continue;
                    dataSetActionResultArray = (DataSetActionResult[])jSubReportEngineArray[k].getRptSetEngine();
                    hashMap.put(dataSetActionResultArray, reportSetActionResult);
                    String string3 = ((ReportViewCenter)object).getRptCenter().getRptName();
                    String string4 = ((ReportViewCenter)object).getViewName();
                    ReportActionResult reportActionResult = reportSetActionResult.getReportActionResult(string3, string4);
                    if (reportActionResult == null || reportActionResult.isEmpty()) continue;
                    String[] stringArray3 = reportActionResult.getActionDataContainerNamesWithOp(4);
                    this.closeCubeData(jSubReportEngineArray[k], stringArray3);
                    this.getActionDataContainerNamesWithDataLevel(reportActionResult.getDataContainerActionResults(), (ReportViewCenter)object, ((ReportViewCenter)object).getRootDataContainer());
                }
                if (hashMap.isEmpty()) continue;
                for (Object object : hashMap.keySet()) {
                    reportSetActionResult = (ReportSetActionResult)hashMap.get(object);
                    dataSetActionResultArray = reportSetActionResult.getDataSetActionResults();
                    this.getActiveDetailReportScene((JRptSetEngine)object, dataSetActionResultArray);
                    this.getActionRst((JRptSetEngine)object, dataSetActionResultArray);
                    this.getActualDataLevel((JRptSetEngine)object, dataSetActionResultArray);
                }
            }
        }
        Tools.logTrace(6, "End of ScheduleHelper.prepareRunInvalidSubReport().");
    }

    public int prepareRunReport(JRptSetEngine jRptSetEngine, String string, String string2, Map map) throws JRSInvalidParameterException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.prepareRunReport()..., mainRptName: " + string + " mActRst: " + map);
        }
        int n = 0;
        JReportEngine jReportEngine = jRptSetEngine.getReportViewEngine(string, string2);
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        if (map != null && !map.isEmpty()) {
            for (String string3 : map.keySet()) {
                String[] stringArray;
                Object[] objectArray;
                ReportSetActionResult reportSetActionResult = (ReportSetActionResult)map.get(string3);
                JReportEngine jReportEngine2 = reportViewCenter.getRptViewEngine(string3);
                ReportViewCenter reportViewCenter2 = jReportEngine2.getReportViewCenter();
                JRptSetEngine jRptSetEngine2 = jReportEngine2.getRptSetEngine();
                String string4 = reportViewCenter2.getRptCenter().getRptName();
                String string5 = reportViewCenter2.getViewName();
                if ((jRptSetEngine2 instanceof JSubRptSetEngine || string4.equals(string) && string5.equals(string2)) && (objectArray = reportSetActionResult.getDataContainerActionResults(string4, string5)) != null && objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        n = this.close(n, ((DataContainerActionResult)objectArray[i]).getActualDataLevel());
                    }
                }
                if ((objectArray = reportSetActionResult.getActionDataContainerNamesWithOp(string4, string5, 2)) == null || objectArray.length > 0) {
                    // empty if block
                }
                if ((stringArray = reportSetActionResult.getActionDataContainerNamesWithDataLevel(string4, string5, 7)) != null) {
                    this.closeCubeData(jReportEngine2, stringArray);
                }
                if ((stringArray = reportSetActionResult.getActionDataContainerNamesWithDataLevel(string4, string5, 15)) != null) {
                    this.closeCubeData(jReportEngine2, stringArray);
                }
                if ((stringArray = reportSetActionResult.getActionDataContainerNamesWithDataLevel(string4, string5, 63)) != null) {
                    this.closeCubeData(jReportEngine2, stringArray);
                }
                Vector vector = jRptSetEngine2.getAllReportViewEngines();
                for (int i = 0; i < vector.size(); ++i) {
                    String string6;
                    JReportEngine jReportEngine3 = (JReportEngine)vector.elementAt(i);
                    ReportViewCenter reportViewCenter3 = jReportEngine3.getReportViewCenter();
                    String string7 = reportViewCenter3.getRptCenter().getRptName();
                    ReportActionResult reportActionResult = reportSetActionResult.getReportActionResult(string7, string6 = reportViewCenter3.getViewName());
                    if (reportActionResult == null) continue;
                    this.findNodeByName(reportActionResult, reportViewCenter3);
                }
                this.getActiveDetailReportScene(jRptSetEngine2, reportSetActionResult.getDataSetActionResults());
                this.getActionRst(jRptSetEngine2, reportSetActionResult.getDataSetActionResults());
                this.getAllSubReportEngine(reportSetActionResult.getDataSetActionResults(), jRptSetEngine2.getReportSetCenter());
                this.getActualDataLevel(jRptSetEngine2, reportSetActionResult.getDataSetActionResults());
            }
            if (n == 1 && (jRptSetEngine.isOnDemandReport() || jRptSetEngine.isDhtmlPipeline())) {
                Tools.logTrace(6, "dhtml ondemand or pipeline, and style action, change to layout action.");
                n = 3;
            }
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "End of ScheduleHelper.prepareRunReport(), return: " + this.append(n));
        }
        return n;
    }

    private void getAllSubReportEngine(DataSetActionResult[] dataSetActionResultArray, ReportSetCenter reportSetCenter) {
        String[] stringArray = this.contains(dataSetActionResultArray);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                reportSetCenter.clearDataSetCenter(stringArray[i]);
            }
        }
    }

    public void runReport(String string, String string2, Map map, int n) throws JRSInvalidParameterException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.runReport()..., mainRptName: " + string + " mainViewName: " + string2 + " mActRst: " + map + " basedDataLevel: " + n);
        }
        this.blockRecord(this.mainRptSetEngine, string, string2, map, null);
        int n2 = n;
        n2 = this.prepareRunReport(this.mainRptSetEngine, string, string2, map);
        boolean bl = false;
        if (n2 == 1) {
            bl = this.getAllDataContainerNames(this.mainRptSetEngine, string, string2, map);
        }
        String[] stringArray = new String[]{string};
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "report data level: " + this.append(n2) + " applyStyleNls: " + bl);
        }
        if (!this.getAllReportViewEngines(this.mainRptSetEngine, string, string2) || n2 != 1 || bl) {
            Tools.logTrace(6, "no export data level, run report.");
            this.mainRptSetEngine.runReport(string, string2, !bl);
            if (!this.mainRptSetEngine.isDhtmlPipeline() && !this.mainRptSetEngine.isOnDemandReport()) {
                vectorArray[0].addElement(string2);
                ScheduleHelper.addElement(this.mainRptSetEngine, stringArray, vectorArray);
            }
        } else {
            Tools.logTrace(6, "style data level, don't run report.");
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "End of ScheduleHelper.runReport().");
        }
    }

    public void runReport(String string, String string2, Map map) throws JRSInvalidParameterException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ScheduleHelper.runReport()..., mainRptName: " + string + " mainViewName: " + string2 + " mActRst: " + map);
        }
        this.runReport(string, string2, map, 1);
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "End of ScheduleHelper.runReport().");
        }
    }

    public Interaction runReport(String[] stringArray, int n, String[] stringArray2, Vector[] vectorArray, String string, String string2, Map map, EngineExecuter engineExecuter) throws JRScheduleException {
        String[] stringArray3;
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DesignService.runReport()..., dataSetName: " + Tools.toString(stringArray));
        }
        JRptSetEngine jRptSetEngine = this.mainRptSetEngine;
        JetRptReportSet jetRptReportSet = jRptSetEngine.getReportSet();
        if (stringArray != null && stringArray.length > 0 && n >= 0 && n < stringArray.length) {
            for (int i = n; i < stringArray.length; ++i) {
                KeyDataSourceQuery keyDataSourceQuery;
                JetRptDataSet jetRptDataSet;
                if ("virtual\u0007dataset\u0007name".equals(stringArray[i]) || (jetRptDataSet = jetRptReportSet.getDataSet(stringArray[i])).getMappingListSrc() != 4 || (keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jRptSetEngine.getUniverse())) == null) continue;
                object = ((JetRptOnDemandDataSet)jetRptDataSet).getJoinNames().toArray(new String[0]);
                stringArray3 = jRptSetEngine.getDbFieldPass1FormulaNames(jetRptDataSet.getInstName());
                Object[] objectArray = null;
                try {
                    objectArray = DataTools.chkJoinPath(jRptSetEngine.getUniverse(), keyDataSourceQuery.getDataSourceName(), keyDataSourceQuery.getQueryName(), object, stringArray3);
                }
                catch (BLException bLException) {
                    throw new JRScheduleException(250005, (Throwable)bLException);
                }
                if (objectArray == null || objectArray.length == 0) continue;
                if (objectArray.length == 1) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "add join path: " + (String)objectArray[0]);
                    }
                    ((JetRptOnDemandDataSet)jetRptDataSet).addJoinName((String)objectArray[0]);
                    continue;
                }
                JRInteractionException jRInteractionException = new JRInteractionException(0, objectArray);
                BreakPoint breakPoint = new BreakPoint(stringArray, i, stringArray2, vectorArray, string, string2, map);
                Interaction interaction = new Interaction(breakPoint, jRInteractionException);
                return interaction;
            }
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                object = (String)vectorArray[i].elementAt(j);
                if (this.clearCachedDisplayNameValuese(hashMap, stringArray2[i], (String)object)) continue;
                this.chkJoinPath(hashMap, stringArray2[i], (String)object);
            }
        }
        this.blockRecord(jRptSetEngine, string, string2, map, hashMap);
        this.prepareRunReport(jRptSetEngine, string, string2, map);
        String[] stringArray4 = stringArray2;
        Vector[] vectorArray2 = vectorArray;
        if (map != null && !Tools.contains(stringArray2, string) && (object = (ReportSetActionResult)map.get(String.valueOf(0))) != null && (stringArray3 = object.getReportActionResult(string, string2)) != null && !stringArray3.isEmpty()) {
            stringArray4 = new String[stringArray2.length + 1];
            vectorArray2 = new Vector[vectorArray.length + 1];
            stringArray4[0] = string;
            vectorArray2[0] = new Vector();
            vectorArray2[0].add(string2);
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray4[i + 1] = stringArray2[i];
                vectorArray2[i + 1] = vectorArray[i];
            }
        }
        jRptSetEngine.runReport(stringArray4, vectorArray2);
        if (!jRptSetEngine.isDhtmlPipeline() && !jRptSetEngine.isOnDemandReport()) {
            ScheduleHelper.addElement(jRptSetEngine, stringArray2, vectorArray);
        }
        return null;
    }

    public static final DetailReportScene getActiveDetailReportScene(JReportEngine jReportEngine) throws JRStopEngineException, JRScheduleException {
        DetailReportScene detailReportScene = new DetailReportScene();
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JReportEngine[] jReportEngineArray = reportViewCenter.getDetailViewEngines();
        if (jReportEngineArray != null) {
            for (int i = 0; i < jReportEngineArray.length; ++i) {
                JReportEngine jReportEngine2 = jReportEngineArray[i];
                ReportViewCenter reportViewCenter2 = jReportEngine2.getReportViewCenter();
                InactiveMastDetailExecutor inactiveMastDetailExecutor = reportViewCenter2.getMasterExecutor();
                if (inactiveMastDetailExecutor == null || !(inactiveMastDetailExecutor instanceof ActiveMastDetailExecutor)) continue;
                ActiveMastDetailExecutor activeMastDetailExecutor = (ActiveMastDetailExecutor)inactiveMastDetailExecutor;
                MasterDetailInfo masterDetailInfo = reportViewCenter2.getMasterDetailInfo();
                String string = masterDetailInfo.getParentComponentName();
                JetRptReport jetRptReport = reportViewCenter.getOriReportView();
                JetRptObject jetRptObject = (JetRptObject)jetRptReport.nameToObject(string);
                IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(masterDetailInfo.getParentQueryDCName()));
                Group[] groupArray = DataHelper.getGroupTrees(jReportEngine, jetRptObject);
                JDbBufferCursor jDbBufferCursor = DataHelper.getCursor(jReportEngine, jetRptObject.getInstName());
                int n = MasterDetailAPITools.getDetailPosition(jetRptObject, iDataContainer);
                detailReportScene.setReportEngine(string, jReportEngine2);
                detailReportScene.setGroups(string, groupArray);
                detailReportScene.setCursor(string, jDbBufferCursor);
                detailReportScene.setPosition(string, n);
            }
        }
        return detailReportScene;
    }
}

