/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.design.masterdetail;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.dbbuffer.DbBufferDataFactory;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.dataengine.api.dbbuffer.RecordComparator;
import jet.dataengine.api.dbbuffer.RecordConvertor;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.group.MContextInfo;
import jet.dataengine.api.group.MOpenExecutor;
import jet.dataengine.api.group.MSInfo;
import jet.dataengine.api.group.MSchInfo;
import jet.dataengine.api.group.MastDetailExeFactory;
import jet.dataengine.api.group.MastDetailExecutor;
import jet.ireport.IDataContainer;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGroupFooterPanel;
import jet.report.JetRptGroupHeaderPanel;
import jet.report.JetRptObject;
import jet.report.JetRptParallelDetailPanel;
import jet.report.conditionallink.JetRptConditionalLinkItem;
import jet.report.table.JetRptTableDetail;
import jet.report.table.JetRptTableFooter;
import jet.report.table.JetRptTableHeader;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.masterdetail.MasterDetailContext;
import jet.rptservice.design.masterdetail.SearchInfo;
import jet.rptservice.design.masterdetail.SearchInfoForDetail;
import jet.rptservice.design.masterdetail.SeekInfo;
import jet.rptservice.design.masterdetail.SeekInfoForDetail;
import jet.rptservice.engine.infocenter.ActiveMastDetailExecutor;
import jet.rptservice.engine.infocenter.InactiveMastDetailExecutor;

public class MasterDetailAPITools {
    public static final int DETAIL_POSITION_HEADER = 1;
    public static final int DETAIL_POSITION_FOOTER = 2;
    public static final int DETAIL_POSITION_DETAIL = 3;

    public static final ActiveMastDetailExecutor createActiveExecutor(Group[] groupArray, int n, int[][] nArray, JetRptObject jetRptObject, IDataContainer iDataContainer, JRecord jRecord, ResourceStore resourceStore) throws JRScheduleException {
        int n2 = -1;
        try {
            n2 = MasterDetailAPITools.getDetailPosition(jetRptObject, iDataContainer);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new JRScheduleException(220063, (Object[])new String[]{jetRptObject == null ? "Null" : jetRptObject.getInstName()}, null);
        }
        ActiveMastDetailExecutorImpl activeMastDetailExecutorImpl = null;
        if (n2 == 1 || n2 == 2) {
            MContextInfo mContextInfo = new MContextInfo(groupArray, n, MasterDetailAPITools.SEDU(n2), nArray);
            mContextInfo.setResourceStore(resourceStore);
            try {
                MOpenExecutor mOpenExecutor = MastDetailExeFactory.createMOpen(mContextInfo);
                JRecord jRecord2 = mOpenExecutor.next();
                activeMastDetailExecutorImpl = new ActiveMastDetailExecutorImpl(n2, mOpenExecutor, jRecord2);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220064, (Throwable)dSException);
            }
        } else {
            ActiveForDetailExecutorImpl activeForDetailExecutorImpl = new ActiveForDetailExecutorImpl(jRecord);
            activeMastDetailExecutorImpl = new ActiveMastDetailExecutorImpl(n2, activeForDetailExecutorImpl, jRecord);
        }
        return activeMastDetailExecutorImpl;
    }

    public static final InactiveMastDetailExecutor createInactiveExecutor(Group[] groupArray, int n, ActiveMastDetailExecutor activeMastDetailExecutor, JDbBufferCursor jDbBufferCursor, DiskStore diskStore) throws JRScheduleException {
        if (activeMastDetailExecutor.isBlockRecord()) {
            return new InactiveMastDetailExecutorImpl(activeMastDetailExecutor.current());
        }
        InactiveMastDetailExecutorImpl inactiveMastDetailExecutorImpl = null;
        if (n == 1 || n == 2) {
            MasterDetailContext masterDetailContext = activeMastDetailExecutor.getContextInfo();
            MContextInfo mContextInfo = masterDetailContext.getHeaderFooterContext();
            MastDetailExecutor mastDetailExecutor = null;
            try {
                mastDetailExecutor = MastDetailExeFactory.createMClose(mContextInfo);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(dSException);
            }
            inactiveMastDetailExecutorImpl = new InactiveMastDetailExecutorImpl(n, mastDetailExecutor, activeMastDetailExecutor.current(), activeMastDetailExecutor.getRecordPosition());
        } else {
            JRecord jRecord = activeMastDetailExecutor.current();
            InactiveForDetailExecutorImpl inactiveForDetailExecutorImpl = null;
            try {
                inactiveForDetailExecutorImpl = new InactiveForDetailExecutorImpl(jDbBufferCursor, jRecord, activeMastDetailExecutor.getRecordPosition(), diskStore);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(dSException);
            }
            inactiveMastDetailExecutorImpl = new InactiveMastDetailExecutorImpl(n, inactiveForDetailExecutorImpl, jRecord, inactiveForDetailExecutorImpl.recPosition);
        }
        return inactiveMastDetailExecutorImpl;
    }

    public static final SearchInfo createSearchInfo(Group[] groupArray, JetRptObject jetRptObject, IDataContainer iDataContainer, JDbBufferCursor jDbBufferCursor, JRecord jRecord) throws JRScheduleException {
        int n = -1;
        try {
            n = MasterDetailAPITools.getDetailPosition(jetRptObject, iDataContainer);
        }
        catch (JRScheduleException jRScheduleException) {
            throw new JRScheduleException(220063, (Object[])new String[]{jetRptObject == null ? "Null" : jetRptObject.getInstName()}, null);
        }
        SearchInfo searchInfo = null;
        searchInfo = n == 1 || n == 2 ? new SearchInfo(groupArray, jetRptObject, iDataContainer, jRecord) : new SearchInfo(jDbBufferCursor, jRecord);
        return searchInfo;
    }

    public static final int getDetailPosition(JetRptObject jetRptObject, IDataContainer iDataContainer) throws JRScheduleException {
        JetRptObject jetRptObject2 = jetRptObject;
        if (jetRptObject instanceof JetRptConditionalLinkItem) {
            jetRptObject2 = (JetRptObject)((Object)((JetRptConditionalLinkItem)jetRptObject).getLinkableOwner());
        }
        if (jetRptObject2 == iDataContainer) {
            return 3;
        }
        if (jetRptObject2 instanceof JetRptGroupHeaderPanel || jetRptObject2 instanceof JetRptTableHeader) {
            return 1;
        }
        if (jetRptObject2 instanceof JetRptGroupFooterPanel || jetRptObject2 instanceof JetRptTableFooter) {
            return 2;
        }
        if (jetRptObject2 instanceof JetRptDetailPanel || jetRptObject2 instanceof JetRptTableDetail || jetRptObject2 instanceof JetRptParallelDetailPanel) {
            return 3;
        }
        return MasterDetailAPITools.getDetailPosition((JetRptObject)((Object)jetRptObject2.getParent()), iDataContainer);
    }

    private static final int SEDU(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            default: {
                JRLog.error(1, "invalid detail position to get type, position: " + n);
            }
        }
        return n2;
    }

    private static class ActiveMastDetailExecutorImpl
    extends InactiveMastDetailExecutorImpl
    implements ActiveMastDetailExecutor {
        public ActiveMastDetailExecutorImpl(int n, MOpenExecutor mOpenExecutor, JRecord jRecord) {
            super(n, mOpenExecutor, jRecord, jRecord.getPosition());
        }

        public ActiveMastDetailExecutorImpl(int n, ActiveForDetailExecutor activeForDetailExecutor, JRecord jRecord) {
            super(n, activeForDetailExecutor, jRecord, jRecord.getPosition());
        }

        @Override
        public int getRecordPosition() {
            return super.getRecordPosition();
        }

        @Override
        public SeekInfo search(SearchInfo searchInfo) throws JRScheduleException {
            Object object;
            Object object2;
            JRLog.trace(6, "ActiveMastDetailExecutorImpl.search()..., searchInfo: " + searchInfo);
            MSchInfo mSchInfo = null;
            boolean bl = false;
            SeekInfo seekInfo = null;
            switch (this.detailPosition) {
                case 1: {
                    JRLog.trace(1, "search in header executor.");
                    bl = true;
                    mSchInfo = searchInfo.getHFSearchInfo(true);
                    break;
                }
                case 2: {
                    JRLog.trace(1, "search in footer executor.");
                    bl = true;
                    mSchInfo = searchInfo.getHFSearchInfo(false);
                    break;
                }
                case 3: {
                    JRLog.trace(1, "search in detail executor.");
                    object2 = searchInfo.getDSearchInfo();
                    object = (ActiveForDetailExecutor)this.executorD;
                    SeekInfoForDetail seekInfoForDetail = object.search((SearchInfoForDetail)object2);
                    if (seekInfoForDetail != null) {
                        JRLog.trace(1, "create seek info for: " + seekInfoForDetail);
                        seekInfo = new SeekInfo(seekInfoForDetail);
                        break;
                    }
                    JRLog.trace(1, "no match record.");
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            if (bl) {
                JRLog.trace(1, "create seek info for header/footer executor.");
                object2 = (MOpenExecutor)this.executorHF;
                try {
                    object = object2.search(mSchInfo);
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(220069, (Throwable)dSException);
                }
                if (object != null) {
                    JRLog.trace(1, "create seek info for: " + object);
                    seekInfo = new SeekInfo((MSInfo)object);
                } else {
                    JRLog.trace(1, "no match record.");
                }
            }
            JRLog.trace(6, "End of ActiveMastDetailExecutorImpl.search(), return: " + seekInfo);
            return seekInfo;
        }

        @Override
        public boolean seek(SeekInfo seekInfo) throws JRScheduleException {
            JRLog.trace(6, "ActiveMastDetailExecutorImpl.seek()..., seekInfo: " + seekInfo);
            boolean bl = false;
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    JRLog.trace(1, "seek in header/footer executor.");
                    MOpenExecutor mOpenExecutor = (MOpenExecutor)this.executorHF;
                    try {
                        bl = mOpenExecutor.seek(seekInfo.getHeaderFooterInfo());
                        break;
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220066, (Throwable)dSException);
                    }
                }
                case 3: {
                    JRLog.trace(1, "seek in detail executor.");
                    ActiveForDetailExecutor activeForDetailExecutor = (ActiveForDetailExecutor)this.executorD;
                    bl = activeForDetailExecutor.seek(seekInfo.getDetailInfo());
                    if (!bl) break;
                    this.currentRecord = this.executorD.current();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            if (bl) {
                this.unblockRecord();
            }
            JRLog.trace(6, "End of ActiveMastDetailExecutorImpl.seek(), return: " + bl);
            return bl;
        }

        @Override
        public MasterDetailContext getContextInfo() {
            MasterDetailContext masterDetailContext = null;
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    MContextInfo mContextInfo = ((MOpenExecutor)this.executorHF).getContextInfo();
                    masterDetailContext = new MasterDetailContext(mContextInfo);
                    break;
                }
            }
            return masterDetailContext;
        }
    }

    private static class InactiveMastDetailExecutorImpl
    implements InactiveMastDetailExecutor {
        private boolean SEDU = false;
        protected int detailPosition = -1;
        protected MastDetailExecutor executorHF;
        protected InactiveForDetailExecutor executorD;
        protected JRecord currentRecord = null;
        protected int recPosition;

        public InactiveMastDetailExecutorImpl(int n, MastDetailExecutor mastDetailExecutor, JRecord jRecord, int n2) {
            this.set(n, jRecord, n2);
            this.executorHF = mastDetailExecutor;
        }

        public InactiveMastDetailExecutorImpl(int n, InactiveForDetailExecutor inactiveForDetailExecutor, JRecord jRecord, int n2) {
            this.set(n, jRecord, n2);
            this.executorD = inactiveForDetailExecutor;
        }

        public InactiveMastDetailExecutorImpl(JRecord jRecord) {
            this.currentRecord = jRecord;
            this.recPosition = this.currentRecord.getPosition();
            this.blockRecord();
        }

        protected void set(int n, JRecord jRecord, int n2) {
            this.detailPosition = n;
            this.currentRecord = jRecord;
            this.recPosition = n2;
        }

        @Override
        public void blockRecord() {
            this.SEDU = true;
        }

        @Override
        public boolean isBlockRecord() {
            return this.SEDU;
        }

        protected void unblockRecord() {
            this.SEDU = false;
        }

        @Override
        public boolean hasPrev() throws JRScheduleException {
            boolean bl = false;
            if (this.SEDU) {
                return bl;
            }
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    try {
                        bl = this.executorHF.hasPrev();
                        break;
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220068, (Throwable)dSException);
                    }
                }
                case 3: {
                    bl = this.executorD.hasPrev();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            return bl;
        }

        @Override
        public boolean hasNext() throws JRScheduleException {
            boolean bl = false;
            if (this.SEDU) {
                return bl;
            }
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    try {
                        bl = this.executorHF.hasNext();
                        break;
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220068, (Throwable)dSException);
                    }
                }
                case 3: {
                    bl = this.executorD.hasNext();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            return bl;
        }

        @Override
        public JRecord prev() throws JRScheduleException {
            JRecord jRecord = null;
            if (this.SEDU) {
                return null;
            }
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    try {
                        jRecord = this.executorHF.prev();
                        break;
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220065, (Throwable)dSException);
                    }
                }
                case 3: {
                    jRecord = this.executorD.prev();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            this.currentRecord = jRecord;
            this.recPosition = this.currentRecord.getPosition();
            return jRecord;
        }

        @Override
        public JRecord next() throws JRScheduleException {
            JRecord jRecord = null;
            if (this.SEDU) {
                return null;
            }
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    try {
                        jRecord = this.executorHF.next();
                        break;
                    }
                    catch (DSException dSException) {
                        throw new JRScheduleException(220065, (Throwable)dSException);
                    }
                }
                case 3: {
                    jRecord = this.executorD.next();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            this.currentRecord = jRecord;
            this.recPosition = this.currentRecord.getPosition();
            return jRecord;
        }

        @Override
        public JRecord current() {
            return this.currentRecord;
        }

        protected int getRecordPosition() {
            return this.recPosition;
        }

        @Override
        public void close() {
            JRLog.trace(1, "InactiveMastDetailExecutorImpl.close()...");
            switch (this.detailPosition) {
                case 1: 
                case 2: {
                    JRLog.trace(1, "for header/footer executor.");
                    try {
                        this.executorHF.close();
                    }
                    catch (DSException dSException) {
                        JRLog.trace(5, dSException);
                    }
                    break;
                }
                case 3: {
                    JRLog.trace(1, "for detail executor.");
                    this.executorD.close();
                    break;
                }
                default: {
                    JRLog.trace(1, "invalid detail position: " + this.detailPosition);
                }
            }
            JRLog.trace(1, "End of InactiveMastDetailExecutorImpl.close().");
        }
    }

    private static class ActiveForDetailExecutorImpl
    extends InactiveForDetailExecutorImpl
    implements ActiveForDetailExecutor {
        ActiveForDetailExecutorImpl(JRecord jRecord) {
            this.record = jRecord;
            this.recPosition = jRecord.getPosition();
        }

        @Override
        public SeekInfoForDetail search(SearchInfoForDetail searchInfoForDetail) {
            JRLog.trace(5, "ActiveForDetailExecutorImpl.search()..., searchInfo: " + searchInfoForDetail);
            JRecord jRecord = searchInfoForDetail.getRecord();
            JRecordModel jRecordModel = jRecord.getRecordModel();
            JRecordModel jRecordModel2 = searchInfoForDetail.getCursor().getRecordModel();
            RecordComparator recordComparator = new RecordComparator(jRecordModel, jRecordModel2);
            JDbBufferCursor jDbBufferCursor = searchInfoForDetail.getCursor();
            SeekInfoForDetail seekInfoForDetail = null;
            try {
                JRecord jRecord2 = jDbBufferCursor.createRecord();
                if (!jDbBufferCursor.first()) {
                    JRLog.trace(5, "End of ActiveForDetailExecutorImpl.search(), can't move cursor to first, return null.");
                    return null;
                }
                jRecord2.setPosition(jDbBufferCursor.getPosition());
                jRecord2.refresh();
                while (true) {
                    if (recordComparator.equal(jRecord, jRecord2)) {
                        int n = jRecord2.getPosition();
                        JRLog.trace(5, "exists match record, position: " + n);
                        seekInfoForDetail = new SeekInfoForDetail(jDbBufferCursor, n);
                        break;
                    }
                    if (jDbBufferCursor.isLast()) {
                        JRLog.trace(5, "no match record.");
                        break;
                    }
                    jDbBufferCursor.next();
                    jRecord2.setPosition(jDbBufferCursor.getPosition());
                    jRecord2.refresh();
                }
            }
            catch (DSException dSException) {
                JRLog.trace(5, dSException);
                JRLog.trace(5, "End of ActiveForDetailExecutorImpl.search(), return -1.");
                return seekInfoForDetail;
            }
            JRLog.trace(5, "End of ActiveForDetailExecutorImpl.search(), return " + seekInfoForDetail);
            return seekInfoForDetail;
        }

        @Override
        public boolean seek(SeekInfoForDetail seekInfoForDetail) {
            JRLog.trace(5, "ActiveForDetailExecutorImpl.seek()..., seekInfo: " + seekInfoForDetail);
            if (seekInfoForDetail == null) {
                JRLog.trace(5, "End of ActiveForDetailExecutorImpl.seek(), seek info is null, return false.");
                return false;
            }
            this.recPosition = seekInfoForDetail.getRecordPosition();
            this.cursor = seekInfoForDetail.getCursor();
            try {
                this.record = this.cursor.createRecord();
                this.cursor.setPosition(this.recPosition);
                this.record.setPosition(this.recPosition);
                this.record.refresh();
            }
            catch (DSException dSException) {
                JRLog.trace(5, dSException);
                JRLog.trace(5, "End of ActiveForDetailExecutorImpl.seek(), return: false.");
                return false;
            }
            JRLog.trace(5, "End of ActiveForDetailExecutorImpl.seek(), return: true");
            return true;
        }

        @Override
        public void close() {
        }
    }

    private static class InactiveForDetailExecutorImpl
    implements InactiveForDetailExecutor {
        protected JRecord record = null;
        private JDbBufferData Refresh = null;
        protected JDbBufferCursor cursor = null;
        protected int recPosition;

        InactiveForDetailExecutorImpl() {
        }

        InactiveForDetailExecutorImpl(JDbBufferCursor jDbBufferCursor, JRecord jRecord, int n, DiskStore diskStore) throws DSException {
            JRecordModel jRecordModel = jRecord.getRecordModel();
            DbBufferDataFactory dbBufferDataFactory = new DbBufferDataFactory();
            this.Refresh = dbBufferDataFactory.createDbBufferData(new RecordModelInfo(jRecordModel.getColDescs()), new _DbBufferConfig(diskStore));
            this.cursor = this.Refresh.createCursor();
            this.record = this.cursor.createRecord();
            this.recPosition = n;
            if (!jDbBufferCursor.first()) {
                return;
            }
            JRecord jRecord2 = jDbBufferCursor.createRecord();
            jRecord2.setPosition(jDbBufferCursor.getPosition());
            jRecord2.refresh();
            RecordConvertor recordConvertor = new RecordConvertor(jRecord2.getRecordModel(), this.record.getRecordModel());
            while (true) {
                recordConvertor.Refresh(jRecord2, this.record);
                this.Refresh.addRecord(this.record);
                if (jDbBufferCursor.getPosition() == jDbBufferCursor.getCurrentEnd()) break;
                jDbBufferCursor.next();
                jRecord2.setPosition(jDbBufferCursor.getPosition());
                jRecord2.refresh();
            }
            this.Refresh.finish();
            this.cursor.setPosition(this.recPosition);
            this.record.setPosition(this.recPosition);
            this.record.refresh();
        }

        private final boolean Refresh(boolean bl) throws JRScheduleException {
            JDbBufferCursor jDbBufferCursor = this.cursor == null ? this.record.getDependCursor() : this.cursor;
            boolean bl2 = false;
            try {
                if (bl) {
                    bl2 = this.recPosition < jDbBufferCursor.getCurrentEnd();
                } else {
                    jDbBufferCursor.setPosition(this.recPosition);
                    bl2 = !jDbBufferCursor.isFirst();
                }
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220070, (Throwable)dSException);
            }
            return bl2;
        }

        private final JRecord SEDU(boolean bl) throws JRScheduleException {
            JDbBufferCursor jDbBufferCursor = this.cursor == null ? this.record.getDependCursor() : this.cursor;
            boolean bl2 = false;
            try {
                jDbBufferCursor.setPosition(this.recPosition);
                bl2 = bl ? jDbBufferCursor.next() : jDbBufferCursor.previous();
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220065, (Throwable)dSException);
            }
            if (!bl2) {
                throw new JRScheduleException(220065);
            }
            try {
                this.recPosition = jDbBufferCursor.getPosition();
                this.record.setPosition(this.recPosition);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220065, (Throwable)dSException);
            }
            this.record.refresh();
            return this.record;
        }

        @Override
        public boolean hasPrev() throws JRScheduleException {
            return this.Refresh(false);
        }

        @Override
        public boolean hasNext() throws JRScheduleException {
            return this.Refresh(true);
        }

        @Override
        public JRecord prev() throws JRScheduleException {
            return this.SEDU(false);
        }

        @Override
        public JRecord next() throws JRScheduleException {
            return this.SEDU(true);
        }

        @Override
        public JRecord current() {
            return this.record;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                try {
                    this.cursor.close();
                }
                catch (DSException dSException) {
                    JRLog.trace(5, dSException);
                }
            }
            if (this.Refresh != null) {
                try {
                    this.Refresh.close();
                }
                catch (DSException dSException) {
                    JRLog.trace(5, dSException);
                }
            }
        }
    }

    private static interface ActiveForDetailExecutor
    extends InactiveForDetailExecutor {
        public SeekInfoForDetail search(SearchInfoForDetail var1);

        public boolean seek(SeekInfoForDetail var1);
    }

    private static interface InactiveForDetailExecutor {
        public boolean hasPrev() throws JRScheduleException;

        public boolean hasNext() throws JRScheduleException;

        public JRecord prev() throws JRScheduleException;

        public JRecord next() throws JRScheduleException;

        public JRecord current();

        public void close();
    }

    private static class _DbBufferConfig
    implements DbBufferConfig {
        private DiskStore SEDU;

        private _DbBufferConfig(DiskStore diskStore) {
            this.SEDU = diskStore;
        }

        @Override
        public DiskStore getDiskStore() {
            return this.SEDU;
        }
    }
}

