/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.Hashtable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SpecialFields;
import jet.exception.InvalidParameterException;
import jet.formula.ExecutableJavaFormula;
import jet.formula.JavaFormula;
import jet.formula.JavaFormulaContainer;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.reportset.JetRptReport;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.util.RawDataQueryEnv;
import jet.server.api.ServerInfo;

public class JEngineRawDataQueryEnv
extends RawDataQueryEnv {
    private JReportEngine SEDU;

    public JEngineRawDataQueryEnv(JReportEngine jReportEngine, QueryInfo queryInfo) {
        super(jReportEngine.getRptSetEngine().getUniverse(), queryInfo);
        this.SEDU = jReportEngine;
    }

    @Override
    protected JetRptReport getReportView() {
        return this.SEDU.getReportViewCenter().getOriReportView();
    }

    @Override
    public CatalogKey getCatalogKey() {
        return this.SEDU.getRptSetEngine().getCatalogKey();
    }

    @Override
    public JavaFormula getJavaFormula() throws JRScheduleException {
        JRptSetEngine jRptSetEngine = this.SEDU.getRptSetEngine();
        JavaFormula javaFormula = jRptSetEngine.getReportSetCenter().getJavaFormula(this.queryInfo.getDatasourceName());
        JavaFormulaContainer javaFormulaContainer = new JavaFormulaContainer();
        javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        javaFormula = this.SEDU.getCFJavaFormula(this.queryInfo.getDatasourceName());
        if (javaFormula != null) {
            javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        }
        if (this.queryInfo.getDataResoureType() == 2 && (javaFormula = this.SEDU.getFlyJavaFormula(this.queryInfo)) != null) {
            javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        }
        jRptSetEngine.getReportSetCenter().prepareJavaFormula(javaFormulaContainer, this.queryInfo);
        return javaFormulaContainer;
    }

    @Override
    public ParameterValueList getParamValues() throws DSException, InvalidParameterException {
        Hashtable hashtable = this.SEDU.getReportEngineEnv().getParameters();
        if (hashtable == null) {
            return null;
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        for (ParamDesc paramDesc : hashtable.values()) {
            parameterValueList.addParameterValue(paramDesc);
        }
        return parameterValueList;
    }

    @Override
    public SpecialFields getSpecialFields() {
        return this.SEDU.getRptSetEngine().getSpecialFields();
    }

    ServerInfo getServerInfo() {
        JRptSetEngine jRptSetEngine = this.SEDU.getRptSetEngine();
        return jRptSetEngine.getServerInfo();
    }
}

