/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.exception.EngingPreinitException;
import jet.ireport.IDataContainer;
import jet.report.JetRptSubReport;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.ContainerInfo;
import jet.rptengine.JEngineInitializer;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubReportEngine;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.JSubRSReportEngine;
import jet.rptservice.engine.JSubRptSetEngine;
import jet.rptservice.engine.infocenter.ReportCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.exception.JRSubReportMissedException;
import jet.rptservice.util.Tools;
import jet.server.api.ServerInfo;
import jet.util.EngineErrorListener;
import jet.util.nls.NLSApplyParam;

public class JRSReportEngine {
    protected JetRptReport report;
    private JRptSetEngine SEDU;
    protected Hashtable htViewEngine = new Hashtable();
    protected ReportCenter rptCenter;
    protected boolean singleThread;

    public JRSReportEngine() {
    }

    public JRSReportEngine(JetRptReport jetRptReport, JRptSetEngine jRptSetEngine) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine()..., rpt = " + jetRptReport + " rptSetEngine = " + jRptSetEngine);
        }
        this.report = jetRptReport;
        this.SEDU = jRptSetEngine;
        Tools.logTrace(6, "End of JRSReportEngine()...");
    }

    public void createViewEngine(JetRptReport jetRptReport, String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "createViewEngine()..., rpt = " + jetRptReport + " rptSetEngine = " + this.SEDU + " viewNames = " + stringArray);
        }
        if (stringArray == null) {
            return;
        }
        String string = this.rptCenter.getRptName();
        for (int i = 0; i < stringArray.length; ++i) {
            JReportEngine jReportEngine;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "JRSReportEngine()..., rpt=" + jetRptReport + " rptView=" + stringArray[i]);
            }
            JetRptReportSet jetRptReportSet = this.rptCenter.getRptSetCenter().getRptSet();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "rptName: " + this.rptCenter.getRptName() + " viewName: " + stringArray[i]);
                JRLog.trace(6, "universe= " + this.SEDU.getUniverse());
            }
            if ((jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[i])) != null) continue;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "new report engine, view name = " + stringArray[i]);
            }
            JetRptReport jetRptReport2 = jetRptReportSet.getReportView(this.rptCenter.getRptName(), stringArray[i]);
            JetRptReport jetRptReport3 = null;
            int n = this.SEDU.genAliasNo();
            String string2 = String.valueOf(n);
            if (!this.SEDU.hasRegisted(jetRptReport2)) {
                this.SEDU.registReportView(jetRptReport2);
                jetRptReport2.setRuntimeReportAlias(string2);
                jetRptReport3 = jetRptReport2;
            } else {
                jetRptReport3 = (JetRptReport)jetRptReport2.deepDupWithName();
                jetRptReport3.createNamingSystem();
                jetRptReport3.afterInit();
                jetRptReport3.setRuntimeReportAlias(string2);
            }
            EngineEnv engineEnv = this.SEDU.getEngineEnv();
            String string3 = engineEnv.getStyleGroup(string);
            ReportViewCenter reportViewCenter = new ReportViewCenter(this.rptCenter, stringArray[i], jetRptReport2);
            reportViewCenter.setReportView(jetRptReport3);
            jReportEngine = new JReportEngine(reportViewCenter, jetRptReport3, null, this.SEDU.getDataService());
            reportViewCenter.setViewEngine(jReportEngine);
            this.htViewEngine.put(stringArray[i], jReportEngine);
            jReportEngine.setSecurityContext(this.SEDU.getSecurityContext());
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "$$$$$$$$$$$isDhtml: " + this.SEDU.isDHTML());
            }
            jReportEngine.setDHTML(this.SEDU.isDHTML());
            jReportEngine.setSecurityData(engineEnv.getSecurityData());
            ServerInfo serverInfo = this.SEDU.getServerInfo();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "set server info to JReportEngine, info: " + serverInfo);
            }
            jReportEngine.setServerInfo(serverInfo);
            jReportEngine.setAllowFFP(this.SEDU.isAllowFFP());
            jReportEngine.setToken(this.SEDU.getCPUToken());
            jReportEngine.setClientName(this.SEDU.getClientName());
            jReportEngine.getSystemVariable().setModifiedDate(this.SEDU.getSysVariable().getModifiedDate());
            if (this.SEDU.getListeners() != null && !this.SEDU.getListeners().isEmpty()) {
                for (int j = 0; j < this.SEDU.getListeners().size(); ++j) {
                    reportViewCenter.getListener().addListener((EngineErrorListener)this.SEDU.getListeners().elementAt(j));
                }
            }
            jReportEngine.addListener(reportViewCenter.getListener());
            reportViewCenter.setEngineKeyWord(String.valueOf(0));
            this.rptCenter.setReportViewCenter(stringArray[i], reportViewCenter);
            reportViewCenter.setStyleGroup(string3);
            if (this.SEDU.isDHTML()) {
                this.applyStyle(stringArray[i], false);
            }
            jReportEngine.setThreadPriority(this.SEDU.getPriority());
        }
        Tools.logTrace(6, "End of createViewEngine()...");
    }

    void applyStyleNls(String string, boolean bl) {
        JSubReportEngine[] jSubReportEngineArray;
        JetRptReport jetRptReport;
        JetRptReport jetRptReport2;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyleNls()..., viewName: " + string + " includeSubRpts: " + bl);
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            return;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JetRptReport jetRptReport3 = jReportEngine.getReportViewCenter().getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "apply style: " + string2);
        }
        if ((jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(this.getRptSetEngine().getUniverse(), jetRptReport3, string2, this.getRptSetEngine().getNLSParam(), true)) != jetRptReport3) {
            jetRptReport2.setAppliedStyle(string2);
        }
        if (jetRptReport2 != (jetRptReport = jReportEngine.getReport())) {
            jetRptReport2.setRuntimeReportAlias(String.valueOf(jetRptReport.getRuntimeReportAlias()));
            jReportEngine.updateRptTemplate(jetRptReport2);
            reportViewCenter.setReportView(jetRptReport2);
        }
        if (bl && (jSubReportEngineArray = reportViewCenter.getAllSubReportEngine()) != null && jSubReportEngineArray.length > 0) {
            for (int i = 0; i < jSubReportEngineArray.length; ++i) {
                ReportViewCenter reportViewCenter2 = jSubReportEngineArray[i].getReportViewCenter();
                ReportCenter reportCenter = reportViewCenter2.getRptCenter();
                JSubRSReportEngine jSubRSReportEngine = (JSubRSReportEngine)reportCenter.getRptSetCenter().getRptSetEngine().getReportEngine(reportCenter.getRptName());
                jSubRSReportEngine.applyStyleNls(reportViewCenter2.getViewName(), false);
            }
        }
        Tools.logTrace(6, "End of JRSReportEngine.applyStyleNls().");
    }

    protected void applyStyle(String string, boolean bl) {
        JSubReportEngine[] jSubReportEngineArray;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyle()..., viewName: " + string + " includeSubRpts: " + bl);
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            return;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JetRptReport jetRptReport = jReportEngine.getReportViewCenter().getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "apply style: " + string2);
        }
        JetRptReport jetRptReport2 = ObjectLogicFactory.getViewLogic().applyDynamicStyle(jetRptReport, string2, false);
        jetRptReport2.setAppliedStyle(string2);
        if (bl && (jSubReportEngineArray = reportViewCenter.getAllSubReportEngine()) != null && jSubReportEngineArray.length > 0) {
            for (int i = 0; i < jSubReportEngineArray.length; ++i) {
                ReportViewCenter reportViewCenter2 = jSubReportEngineArray[i].getReportViewCenter();
                ReportCenter reportCenter = reportViewCenter2.getRptCenter();
                JSubRSReportEngine jSubRSReportEngine = (JSubRSReportEngine)reportCenter.getRptSetCenter().getRptSetEngine().getReportEngine(reportCenter.getRptName());
                jSubRSReportEngine.applyStyle(reportViewCenter2.getViewName(), false);
            }
        }
        Tools.logTrace(6, "End of JRSReportEngine.applyStyle().");
    }

    public void createViewEngine(JetRptReport jetRptReport, int n) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "createViewEngine()..., rpt = " + jetRptReport + " rptStatus = " + n);
        }
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = new String[]{this.report.getCurViewName()};
                break;
            }
            case 1: {
                stringArray = this.report.getOpenedViewNames();
                break;
            }
            case 2: {
                stringArray = this.report.getAllViewName();
                break;
            }
            default: {
                if (JRLog.isError(1)) {
                    JRLog.error(1, "JRSReportEngine()...,invalid rpt status: " + n);
                }
                return;
            }
        }
        this.createViewEngine(jetRptReport, stringArray);
        Tools.logTrace(6, "End of createViewEngine()...");
    }

    Vector getRptViewNames() {
        Vector<String> vector = new Vector<String>();
        if (this.htViewEngine == null || this.report == null) {
            return vector;
        }
        String[] stringArray = this.report.getAllViewName();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.htViewEngine.containsKey(stringArray[i])) continue;
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public JReportEngine getViewEngine(String string) {
        if (this.htViewEngine == null) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            if (this.report == null) {
                return null;
            }
            string2 = this.report.getCurViewName();
        }
        return (JReportEngine)this.htViewEngine.get(string2);
    }

    public JReportEngine getViewEngine() {
        return this.getViewEngine(null);
    }

    public void setReportCenter(ReportCenter reportCenter) {
        this.rptCenter = reportCenter;
    }

    public JRptSetEngine getRptSetEngine() {
        return this.SEDU;
    }

    public JetRptReport getReport() {
        return this.report;
    }

    public ReportCenter getReportCenter() {
        return this.rptCenter;
    }

    public boolean isSingleThread() {
        return this.singleThread;
    }

    public String[] getViewNames() {
        Vector vector = new Vector();
        if (this.htViewEngine != null) {
            Iterator iterator = this.htViewEngine.keySet().iterator();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
        }
        return vector.toArray(new String[0]);
    }

    public void preinitEngine(String[] stringArray, boolean bl) throws EngingPreinitException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.preinitEngine()..., viewNames = " + Tools.toString(stringArray) + " forceInit: " + bl);
        }
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[i]);
            if (jReportEngine == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[i]);
                }
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            if (!bl && reportViewCenter.hasPreinit()) continue;
            reportViewCenter.setPreinit();
            if (this.SEDU.getType() == 1) {
                jReportEngine.setLinkInfo(this.SEDU.getAllLinkInfos());
            } else if (this.SEDU.getType() == 2) {
                jReportEngine.setDetailInfo(this.SEDU.getMasterDetailInfo());
            }
            jReportEngine.updateRptTemplate(reportViewCenter.getOriReportView());
            long l = System.currentTimeMillis();
            jReportEngine.preinitEngine();
            long l2 = System.currentTimeMillis();
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, "pre init report view:" + jReportEngine.getReportViewCenter().getViewName());
        }
        Tools.logTrace(6, "End of JRSReportEngine.preinitEngine()...");
    }

    public void preinitEngineAbsolute(String[] stringArray) throws EngingPreinitException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.preinitEngineAbsolute()..., viewNames = " + Tools.toString(stringArray));
        }
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[i]);
            if (jReportEngine == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[i]);
                }
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            reportViewCenter.setPreinit();
            long l = System.currentTimeMillis();
            jReportEngine.preinitEngine();
            long l2 = System.currentTimeMillis();
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, "pre init report view:" + jReportEngine.getReportViewCenter().getViewName());
        }
        Tools.logTrace(6, "End of JRSReportEngine.preinitEngineAbsolute()...");
    }

    public void initRunEngine(String[] stringArray, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.initRunEngine()..., viewNames = " + Tools.toString(stringArray));
        }
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[i]);
            if (jReportEngine == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[i]);
                }
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            if (!bl && reportViewCenter.hasInitRun()) continue;
            reportViewCenter.setInitRun();
            long l = System.currentTimeMillis();
            jReportEngine.initRun();
            long l2 = System.currentTimeMillis();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "init run report view: " + jReportEngine.getReportViewCenter().getViewName());
            }
            jReportEngine.getReportViewCenter().refreshDataSet();
        }
        Tools.logTrace(6, "End of JRSReportEngine.initRunEngine()...");
    }

    public void initRunEngineAbsolute(String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.initRunEngineAbsolute()..., viewNames = " + Tools.toString(stringArray));
        }
        if (stringArray == null) {
            return;
        }
        if (this.htViewEngine == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(stringArray[i]);
            if (jReportEngine == null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "view engine is not exists! viewName = " + stringArray[i]);
                }
                return;
            }
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            reportViewCenter.setInitRun();
            long l = System.currentTimeMillis();
            jReportEngine.initRun();
            long l2 = System.currentTimeMillis();
            if (!JRLog.isTrace(6)) continue;
            JRLog.trace(6, "init run report view: " + jReportEngine.getReportViewCenter().getViewName());
        }
        Tools.logTrace(6, "End of JRSReportEngine.initRunEngineAbsolute()...");
    }

    private void SEDU(String string, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.runReportView()..., viewName: " + string);
        }
        if (this.htViewEngine == null) {
            return;
        }
        JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
        if (jReportEngine == null) {
            return;
        }
        long l = System.currentTimeMillis();
        ReportViewCenter reportViewCenter = this.getReportCenter().getReportViewCenter(string);
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        try {
            if (!this.getRptSetEngine().isRsd()) {
                Tools.logTrace(6, "get nls view...");
                JetRptReport jetRptReport2 = null;
                if (bl) {
                    String string3 = jetRptReport.getAppliedStyle();
                    if (!Tools.equals(string2, string3)) {
                        jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(this.getRptSetEngine().getUniverse(), jetRptReport, string2, this.SEDU.getNLSParam(), true);
                        jetRptReport2.setAppliedStyle(string2);
                    } else {
                        jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, this.SEDU.getNLSParam());
                    }
                    if (jetRptReport2 != jetRptReport) {
                        jetRptReport2.setRuntimeReportAlias(jReportEngine.getReport().getRuntimeReportAlias());
                    }
                    Tools.logTrace(6, "free previous view...");
                    JetRptReport jetRptReport3 = reportViewCenter.getReportView();
                    if (jetRptReport3 != null && jetRptReport3 != jetRptReport2 && jetRptReport3 != jetRptReport && jetRptReport3 != this.report) {
                        jetRptReport3.clearReport();
                    }
                    reportViewCenter.setReportView(jetRptReport2);
                    Tools.logTrace(6, "update report template...");
                    jReportEngine.updateRptTemplate(jetRptReport2);
                    JSubReportEngine[] jSubReportEngineArray = reportViewCenter.getAllSubReportEngine();
                    if (jSubReportEngineArray != null && jSubReportEngineArray.length > 0) {
                        for (int i = 0; i < jSubReportEngineArray.length; ++i) {
                            this.add(string, jSubReportEngineArray[i]);
                        }
                    }
                }
            }
            reportViewCenter.getListener().reset();
        }
        catch (RuntimeException runtimeException) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, runtimeException);
            }
            this.SEDU.clearRunningReports(this.rptCenter.getRptName(), string);
            throw runtimeException;
        }
        if (JRLog.isTrace(6) && JRLog.isTrace(6)) {
            JRLog.trace(6, "start report view engine, view name: " + string + " viewEngine: " + jReportEngine);
        }
        jReportEngine.initEngineFlag();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "SCHEDULE_BEFORE_START, [ELAPSED]: " + (System.currentTimeMillis() - l) + " [ms]");
        }
        long l2 = System.currentTimeMillis();
        jReportEngine.start();
        if (JRLog.isTrace(4)) {
            long l3 = System.currentTimeMillis();
            JRLog.trace(4, "SCHEDULE_STARTRPTENGINE, [ELAPSED]: " + (l3 - l2) + " [ms]");
            JRLog.trace(4, "SCHEDULE_RUNRPTVIEW, [ELAPSED]: " + (l3 - l) + " [ms]");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.runReportView().");
        }
    }

    private void add(String string, JSubReportEngine jSubReportEngine) {
        ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        Tools.logTrace(6, "get nls view...");
        JetRptReport jetRptReport2 = null;
        String string3 = jetRptReport.getAppliedStyle();
        NLSApplyParam nLSApplyParam = jSubReportEngine.getRptSetEngine().getNLSParam();
        if (!Tools.equals(string2, string3)) {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(this.getRptSetEngine().getUniverse(), jetRptReport, string2, nLSApplyParam, true);
            jetRptReport2.setAppliedStyle(string2);
        } else {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, nLSApplyParam);
        }
        if (jetRptReport2 != jetRptReport) {
            jetRptReport2.setRuntimeReportAlias(jSubReportEngine.getReport().getRuntimeReportAlias());
        }
        Tools.logTrace(6, "free previous view...");
        JetRptReport jetRptReport3 = reportViewCenter.getReportView();
        if (jetRptReport3 != null && jetRptReport3 != jetRptReport2 && jetRptReport3 != jetRptReport && jetRptReport3 != jSubReportEngine.getReportCenter().getReport()) {
            jetRptReport3.clearReport();
        }
        reportViewCenter.setReportView(jetRptReport2);
        reportViewCenter.getListener().reset();
        Tools.logTrace(6, "update report template...");
        jSubReportEngine.updateRptTemplate(jetRptReport2);
    }

    public boolean applyStyleNls(String string) {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.applyStyleNls()..., viewName: " + string);
        }
        if (this.getRptSetEngine().isRsd()) {
            return false;
        }
        ReportViewCenter reportViewCenter = this.rptCenter.getReportViewCenter(string);
        if (reportViewCenter == null) {
            return false;
        }
        boolean bl = false;
        JetRptReport jetRptReport = reportViewCenter.getOriReportView();
        String string2 = reportViewCenter.getStyleGroup();
        JetRptReport jetRptReport2 = null;
        String string3 = jetRptReport.getAppliedStyle();
        if (!Tools.equals(string2, string3)) {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().getReportViewForNLSOrDynamicStyle(this.getRptSetEngine().getUniverse(), jetRptReport, string2, this.SEDU.getNLSParam(), true);
            jetRptReport2.setAppliedStyle(string2);
        } else {
            jetRptReport2 = ObjectLogicFactory.getViewLogic().applyNLSNeedCheck(jetRptReport, this.SEDU.getNLSParam());
        }
        if (jetRptReport2 != jetRptReport) {
            object = reportViewCenter.getReportViewEngine();
            jetRptReport2.setRuntimeReportAlias(((JEngineInitializer)object).getReport().getRuntimeReportAlias());
            bl = true;
        }
        Tools.logTrace(6, "free previous view...");
        object = reportViewCenter.getReportView();
        if (object != null && object != jetRptReport2 && object != jetRptReport && object != this.rptCenter.getReport()) {
            ((JetRptReport)object).clearReport();
        }
        reportViewCenter.setReportView(jetRptReport2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.applyStyleNls(), return: " + bl);
        }
        return bl;
    }

    boolean layoutReportView(String string) {
        boolean bl = JRLog.isTrace(6);
        if (bl) {
            JRLog.trace(6, "JRSReportEngine.layoutReportView()..., viewName: " + string);
        }
        if (this.htViewEngine == null) {
            if (bl) {
                JRLog.trace(6, "End of JRSReportEngine.layoutReportView(), no any report view engines, return false.");
            }
            return false;
        }
        JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
        if (jReportEngine == null) {
            if (bl) {
                JRLog.trace(6, "End of JRSReportEngine.layoutReportView(), report view engine don't exist, return false.");
            }
            return false;
        }
        long l = System.currentTimeMillis();
        ReportViewCenter reportViewCenter = this.getReportCenter().getReportViewCenter(string);
        reportViewCenter.getListener().reset();
        long l2 = System.currentTimeMillis();
        Tools.logTrace(6, "layout report view , view name...");
        jReportEngine.initEngineFlag();
        jReportEngine.restart();
        if (JRLog.isTrace(4)) {
            long l3 = System.currentTimeMillis();
            JRLog.trace(4, "SCHEDULE_STARTRPTENGINE, [ELAPSED]: " + (l3 - l2) + " [ms]");
            long l4 = System.currentTimeMillis();
            JRLog.trace(4, "SCHEDULE_RUNRPTVIEW, [ELAPSED]: " + (l4 - l) + " [ms]");
        }
        if (bl) {
            JRLog.trace(6, "End of layoutReportView(), return true.");
        }
        return true;
    }

    public void runReportView(String[] stringArray) {
        this.runReportView(stringArray, true);
    }

    public void runReportView(String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.SEDU(string, bl);
        }
    }

    public void runReportViewWithRefreshData(String[] stringArray, boolean bl) {
    }

    public Vector getViewEngines() {
        Vector vector = new Vector();
        if (this.htViewEngine == null) {
            return vector;
        }
        String[] stringArray = this.report.getAllViewName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.htViewEngine.containsKey(stringArray[i])) continue;
            vector.addElement(this.htViewEngine.get(stringArray[i]));
        }
        return vector;
    }

    public void clearMem(String string) {
        if (this.htViewEngine != null && this.htViewEngine.containsKey(string)) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
            jReportEngine.clearMem();
            this.htViewEngine.remove(string);
        }
    }

    public synchronized void clearMem() {
        Tools.logTrace(6, "JRSReportEngine.clearMem()...");
        if (this.htViewEngine != null) {
            Enumeration enumeration = this.htViewEngine.keys();
            while (enumeration.hasMoreElements()) {
                JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(enumeration.nextElement());
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, " clear memory of report view engine: " + jReportEngine);
                }
                jReportEngine.clearMem();
            }
            if (this.htViewEngine != null) {
                this.htViewEngine.clear();
                this.htViewEngine = null;
            }
        }
        this.report = null;
        this.SEDU = null;
        if (this.rptCenter != null) {
            this.rptCenter.clearMem();
            this.rptCenter = null;
        }
        Tools.logTrace(6, "End of JRSReportEngine.clearMem().");
    }

    public void stop(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.stop()..., viewName: " + string);
        }
        if (this.htViewEngine != null) {
            JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(string);
            if (jReportEngine != null) {
                jReportEngine.stop();
                ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
                reportViewCenter.cancelAllSubReportQueries();
            } else if (JRLog.isError(3)) {
                JRLog.error(3, "can't stop view engine, no such view engine, view name: " + string);
            }
        }
        Tools.logTrace(6, "End of JRSReportEngine.stop().");
    }

    public void clear(String string) {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.clear()..., viewName: " + string);
        }
        if ((jReportEngine = (JReportEngine)this.htViewEngine.get(string)) != null) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "clear view engine, view name: " + string);
            }
            jReportEngine.clear();
        } else if (JRLog.isTrace(5)) {
            JRLog.trace(5, "can't clear view engine, no such view engine, view name: " + string);
        }
        Tools.logTrace(6, "End of JRSReportEngine.clear().");
    }

    Thread[] getAllThreads() {
        Tools.logTrace(6, "JRSReportEngine.getAllThreads()...");
        Vector<Thread> vector = new Vector<Thread>();
        if (this.htViewEngine != null && !this.htViewEngine.isEmpty()) {
            Enumeration enumeration = this.htViewEngine.keys();
            while (enumeration.hasMoreElements()) {
                Thread[] threadArray;
                Object k = enumeration.nextElement();
                JReportEngine jReportEngine = (JReportEngine)this.htViewEngine.get(k);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get threads from JReportEngine, viewEngine: " + jReportEngine);
                }
                if ((threadArray = jReportEngine.getAllThreads()) == null || threadArray.length == 0) continue;
                for (int i = 0; i < threadArray.length; ++i) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "get threads from JReportEngine, thread: " + threadArray[i]);
                    }
                    vector.addElement(threadArray[i]);
                }
                Tools.logTrace(6, "end of get threads from JReportEngine.");
            }
        }
        Tools.logTrace(6, "End of JRSReportEngine.getAllThreads().");
        return vector.toArray(new Thread[vector.size()]);
    }

    protected void closeRelatedDataInstance(String string, String[] stringArray) {
        String[] stringArray2;
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.closeRelatedDataInstance()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray));
        }
        if (stringArray == null || stringArray.length == 0) {
            Tools.logTrace(6, "End of JRSReportEngine.closeRelatedDataInstance(), no data container names.");
        }
        if ((jReportEngine = this.getViewEngine(string)) == null) {
            Tools.logTrace(6, "End of JRSReportEngine.closeRelatedDataInstance(), no view engine.");
        }
        if ((stringArray2 = this.addElement(string, stringArray, true)) != null && stringArray2.length > 0) {
            String string2;
            Object object;
            int n;
            JSubReportEngine[] jSubReportEngineArray = this.addListener(string, stringArray2, false);
            if (jSubReportEngineArray != null && jSubReportEngineArray.length > 0) {
                for (n = 0; n < jSubReportEngineArray.length; ++n) {
                    object = jSubReportEngineArray[n].getReportViewCenter();
                    string2 = ((ReportViewCenter)object).getRptCenter().getRptName();
                    String string3 = jSubReportEngineArray[n].getReportViewCenter().getViewName();
                    String string4 = ((ReportViewCenter)object).getRootDataContainerName();
                    JRSReportEngine jRSReportEngine = jSubReportEngineArray[n].getRptSetEngine().getReportEngine(string2);
                    jRSReportEngine.closeRelatedDataInstance(string3, new String[]{string4});
                }
            }
            for (n = 0; n < stringArray2.length; ++n) {
                object = (IDataContainer)((Object)jReportEngine.getReport().nameToObject(stringArray2[n]));
                if (object == null) continue;
                string2 = object.getInstName();
                try {
                    jReportEngine.closeQuerysForSelf(string2, false);
                    jReportEngine.closeQuerysForSelf(string2, true);
                    continue;
                }
                catch (JRScheduleException jRScheduleException) {
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, jRScheduleException);
                }
            }
        }
        Tools.logTrace(6, "End of JRSReportEngine.closeRelatedDataInstance().");
    }

    private String[] addElement(String string, String[] stringArray, boolean bl) {
        String[] stringArray2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.getDescendantDataContainerNames()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray) + " includeSelf: " + bl);
        }
        if (stringArray == null || stringArray.length == 0) {
            Tools.logTrace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), no data container names, return null.");
            return null;
        }
        JReportEngine jReportEngine = this.getViewEngine(string);
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), no view engine, return null.");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3;
            if (bl && !arrayList.contains(stringArray[i])) {
                arrayList.add(stringArray[i]);
            }
            if ((stringArray3 = reportViewCenter.getDescendant(stringArray[i])) == null || stringArray3.length <= 0) continue;
            for (int j = 0; j < stringArray3.length; ++j) {
                if (arrayList.contains(stringArray3[j])) continue;
                arrayList.add(stringArray3[j]);
            }
        }
        String[] stringArray4 = stringArray2 = arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.getDescendantDataContainerNames(), return: " + Tools.toString(stringArray2));
        }
        return stringArray2;
    }

    private JSubReportEngine[] addListener(String string, String[] stringArray, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRSReportEngine.getSubViewEngines()..., viewName: " + string + " dcNames: " + Tools.toString(stringArray) + " includeDescendant: " + bl);
        }
        if (stringArray == null || stringArray.length == 0) {
            Tools.logTrace(6, "End of JRSReportEngine.getSubViewEngines(), no data container names, return null.");
            return null;
        }
        JReportEngine jReportEngine = this.getViewEngine(string);
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRSReportEngine.getSubViewEngines(), no view engine, return null.");
            return null;
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        JReportEngine jReportEngine2 = jReportEngine;
        if (this.SEDU instanceof JSubRptSetEngine) {
            jReportEngine2 = ((JSubRptSetEngine)this.SEDU).getMainViewEngine();
        }
        String[] stringArray2 = bl ? this.addElement(string, stringArray, true) : stringArray;
        ArrayList<JSubReportEngine> arrayList = new ArrayList<JSubReportEngine>();
        for (int i = 0; i < stringArray2.length; ++i) {
            Vector vector;
            ContainerInfo containerInfo = reportViewCenter.getContainerInfo(stringArray2[i]);
            if (containerInfo == null || (vector = containerInfo.getSubRptInstNames()) == null || vector.isEmpty()) continue;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = (String)vector.elementAt(j);
                JetRptSubReport jetRptSubReport = (JetRptSubReport)jReportEngine.getReport().nameToObject(string2);
                JSubReportEngine jSubReportEngine = null;
                try {
                    jSubReportEngine = jReportEngine2.getSubReportEngine(jetRptSubReport);
                }
                catch (JRSubReportMissedException jRSubReportMissedException) {
                    continue;
                }
                if (jSubReportEngine == null || arrayList.contains(jSubReportEngine)) continue;
                arrayList.add(jSubReportEngine);
            }
        }
        JSubReportEngine[] jSubReportEngineArray = arrayList.toArray(new JSubReportEngine[arrayList.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRSReportEngine.getSubViewEngines(), return: " + Tools.toString(jSubReportEngineArray));
        }
        return jSubReportEngineArray;
    }
}

