/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.acl.NotOwnerException;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.acl.ACLException;
import jet.acl.SecurityContextAdapter;
import jet.bean.JRCatalog;
import jet.bean.JREngine;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.JetColumnName;
import jet.controls.JetObject;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.Group;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.set.ISortExpression;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SpecialFields;
import jet.dataengine.groupengine.GroupEnd;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JDenyListProvider;
import jet.dataservice.api.JDenyListProviderFactory;
import jet.dataservice.api.JQueryFactory;
import jet.dataservice.api.ShareInfo;
import jet.datasource.InputStreamFactory;
import jet.exception.EngingPreinitException;
import jet.formula.JavaFormula;
import jet.formula.ParamDesc;
import jet.formula.fArray;
import jet.icontrols.QueryInfo;
import jet.ie.CLSInfo;
import jet.ireport.IDataContainer;
import jet.jetc.ReadFailureException;
import jet.parameter.UserInput;
import jet.report.JReportUtil;
import jet.report.JetRptCTHdDBField;
import jet.report.JetRptDBField;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptFilterControl;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptObject;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSortContainer;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSystemVariable;
import jet.report.JetRptView;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.convert.CvIExpression;
import jet.report.onTheFlyFormula.Scope;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.reportLogic.objectInfo.IOnScreenFilterValue;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.DataContainerConvertor;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.DataSetLogic;
import jet.reportLogic.objectLogic.JetFilterExpLogic;
import jet.reportLogic.objectLogic.NLSLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.SimpleComponentLogic;
import jet.reportLogic.objectLogic.ViewLogic;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportset.DataSet;
import jet.reportset.JSecurityEntryException;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptExtendsDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.ContainerInfo;
import jet.rptengine.EngineListener;
import jet.rptengine.EngineRefreshListener;
import jet.rptengine.JCommunicator;
import jet.rptengine.JEngineInitializer;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubReportEngine;
import jet.rptservice.agent.RuntimeInfoAgent;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.ExternalEnv;
import jet.rptservice.api.IQueryBuilder;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.IShareInfoProvider;
import jet.rptservice.api.ParameterInteractiveModeEnv;
import jet.rptservice.api.RSDBurstingProvidor;
import jet.rptservice.api.RawDataQueryCreator;
import jet.rptservice.api.ReportSetEnv;
import jet.rptservice.api.ReportSetProvider;
import jet.rptservice.api.ScheduleListener;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.api.infocenter.IDataSetCenter;
import jet.rptservice.api.infocenter.IReportCenter;
import jet.rptservice.api.infocenter.IReportSetCenter;
import jet.rptservice.api.infocenter.IReportViewCenter;
import jet.rptservice.api.infocenter.InfoCenterProvider;
import jet.rptservice.engine.DataSetQueryBuilder;
import jet.rptservice.engine.EngineQueryBuilder;
import jet.rptservice.engine.JRSReportEngine;
import jet.rptservice.engine.JSubRptSetEngine;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.infocenter.DataSetCenter;
import jet.rptservice.engine.infocenter.PartialData;
import jet.rptservice.engine.infocenter.ReportCenter;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.engine.infocenter.SubReportInfo;
import jet.rptservice.impl.EngineEnvImpl;
import jet.rptservice.impl.ParameterValueDescImpl;
import jet.rptservice.impl.RSDAccessDenyListProvider;
import jet.rptservice.listener.DataSetListener;
import jet.rptservice.manager.ParameterManager;
import jet.rptservice.pub.JColumnSecurityContainer;
import jet.rptservice.pub.KeyBusinessLogic;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.pub.LinkInfo;
import jet.rptservice.pub.MasterDetailInfo;
import jet.rptservice.pub.ParameterAdapter;
import jet.rptservice.pub.PrincipalAttributes;
import jet.rptservice.pub.RSDBurstingInfo;
import jet.rptservice.pub.RSDInfo;
import jet.rptservice.pub.RSDInfoForSingleRptSet;
import jet.rptservice.security.AccessController;
import jet.rptservice.security.AccessControllerFactory;
import jet.rptservice.util.ITemplateLoader;
import jet.rptservice.util.ITreeIterator;
import jet.rptservice.util.ITreeNode;
import jet.rptservice.util.MemoryCacheQueryParameterProvider;
import jet.rptservice.util.PreOrderIterator;
import jet.rptservice.util.QueryParameterProvider;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.SubReportCheckTool;
import jet.rptservice.util.SubRptEngineLoader;
import jet.rptservice.util.SubRptLoader;
import jet.rptservice.util.SubRptShareTool;
import jet.rptservice.util.Tools;
import jet.security.PageACL;
import jet.server.api.SecurityContext;
import jet.server.api.ServerInfo;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.JetUXMLConnection;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.tools.UniverseTools;
import jet.util.CPUToken;
import jet.util.Converter;
import jet.util.DataEngineInfo;
import jet.util.EngineErrorListener;
import jet.util.EngineExecuter;
import jet.util.JFieldValueNLSManager;
import jet.util.ParameterValueDesc;
import jet.util.ReportEngineInfo;
import jet.util.ReportsetEngineInfo;
import jet.util.ScheduleTools;
import jet.util.ThreadErrorListener;
import jet.util.nls.NLSApplyParam;

public class JRptSetEngine
implements EngineListener {
    public static final int LEVEL_PARAMETER = 0;
    public static final int LEVEL_RUN_REPORT = 1;
    public static final int ENGINE_TYPE_NORMAL = 0;
    public static final int ENGINE_TYPE_LINK = 1;
    public static final int ENGINE_TYPE_DETAIL = 2;
    public static final int ENGINE_TYPE_GOTODETAIL = 3;
    public static final String JAVA_FORMULA = "java_formula";
    public static final String IS_FAST_PASS = "is_fast_pass";
    public static final String PARAMETERS = "parameters";
    public static final String MAPPING_NAMES = "mapping_names";
    public static final String RPT_FORMULAS = "rpt_formulas";
    public static final String FILTER = "filter";
    public static final int PAINT = 0;
    public static final int RECREATE_DATASTREAM = 1;
    public static final int RELOAD_DATASOURCE = 2;
    public static final int DATASOURCE_ERROR = 4;
    public static final int REPORT_MODIFIED = 5;
    public static final int CATALOG_MODIFIED = 6;
    public static final int DATASET_MODIFIED = 32;
    public static final int QUERY_MODIFIED = 64;
    public static final String PARAM_ALL_VALUE = "\u0007";
    protected Hashtable htReportEngine = new Hashtable();
    protected ReportSetCenter rptSetCenter = null;
    private String LOCAL_LANGUAGE;
    private String REPORT_NAME;
    private String SEDU;
    private String ThreadException;
    private String UNKNOWN = null;
    private String __sys__USERNAME = null;
    private String access$100;
    private String access$300;
    private String access$400;
    private boolean add = false;
    private RSDInfo addAll = null;
    private int addElement = 0;
    protected RSDInfoForSingleRptSet rsdInforForRptSet = null;
    private boolean addIndexOfParentIndex;
    private int addParameterValue = 0;
    private JRCatalog addRefreshListener;
    private String addRptViewNames;
    private Hashtable afterInit = new Hashtable();
    private int afterInitParameter = Converter.UNKNOWN;
    private int append = Converter.UNKNOWN;
    private String applyNLS;
    private String applyNLSorDynamicStyle = null;
    private String applyStyleNls = null;
    private Map asList = null;
    private String asyncronizedSetPriority;
    private String backupDataStatus;
    private Hashtable beforeRun;
    private Hashtable buildCubeQuery;
    protected JDataService dataService = null;
    private boolean buildRawQuery = false;
    private boolean canApplyNLS = false;
    private boolean canSummary = false;
    private boolean cancelRawDataQueries = false;
    private ParameterManager cancelRawDataQuery = null;
    private ServerInfo catchError = null;
    private boolean checkSubReportLoop = false;
    private boolean clear = false;
    private CPUToken clearCubeId;
    protected JReportEngine parentReportEngine;
    private LinkInfo clearDataSetCenters = null;
    private List clearEngine = null;
    private MasterDetailInfo clearMem = null;
    private JetRptSystemVariable clearRawDataId = new JetRptSystemVariable();
    private Vector clearRunningReports;
    private int clearSubEngines = 0;
    private ArrayList clearSubRptInfoMap;
    private boolean clone;
    private boolean closeAllGroupDatas = false;
    private Object closeAllGroups = new Object();
    private EngineExecuter closeAllRawDatas = null;
    private JdbcDriversConfig closeAllSubReportDatas = null;
    private boolean closeQuery = false;
    private ScheduleListener closeRawData = null;
    private boolean closeRawDatas = false;
    public final Object priorityLocker = new Object();
    private int closeRelatedDataInstance = 5;
    private boolean closeUnusedRawQuery = false;
    private boolean columnName = false;
    private int compareTo = -1;
    private boolean contains = false;
    private String containsKey = null;
    private BurstingSchema[] createAccessController = null;
    private RSDBurstingProvidor createJDenyListProvider;
    private ReportSetProvider createNamingSystem;
    private HashMap createViewEngine = new HashMap();
    private _EngineEnvContainer currentThread;
    private HashMap currentTimeMillis = new HashMap();
    private boolean cvIExpresstion = false;
    private boolean deepDupWithName = false;
    private int denyAllColumns = 1;
    private Hashtable disable;
    private Hashtable displayStructure;
    private JDenyListProvider doCLS;

    protected JRptSetEngine(PrincipalAttributes principalAttributes, PrincipalAttributes principalAttributes2, CatalogKey catalogKey, JDataService jDataService, EngineEnv engineEnv, ExternalEnv externalEnv) {
        if (engineEnv == null) {
            throw new IllegalArgumentException("engineEnv is null.");
        }
        this.dataService = jDataService;
        this.currentThread = new _EngineEnvContainer(engineEnv);
        this.rptSetCenter = new ReportSetCenter(this, principalAttributes, principalAttributes2, catalogKey);
        this.setExternalEnv(externalEnv);
    }

    public JRptSetEngine(String string, PrincipalAttributes principalAttributes, PrincipalAttributes principalAttributes2, JDataService jDataService, CatalogKey catalogKey, EngineEnv engineEnv) throws JRScheduleException {
        this(principalAttributes, principalAttributes2, catalogKey, jDataService, engineEnv, null);
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine()..., rptSetName: " + string + " rptSetAttr: " + principalAttributes + " unvAttr: " + principalAttributes2 + " catKey: " + catalogKey + " dataService: " + jDataService + " engineEnv: " + engineEnv);
        }
        this.rptSetCenter.setRptSetName(Tools.getFileNameWithoutPath(string));
        this.cancelRawDataQuery = new ParameterManager(this.rptSetCenter);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "create report set engine, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine().");
        }
    }

    public JRptSetEngine(String string, PrincipalAttributes principalAttributes, PrincipalAttributes principalAttributes2, JDataService jDataService, CatalogKey catalogKey, EngineEnvImpl engineEnvImpl, boolean bl) throws JRScheduleException {
        this(string, principalAttributes, principalAttributes2, jDataService, catalogKey, engineEnvImpl);
        this.columnName = bl;
    }

    public EngineEnv getEngineEnv() {
        return this.currentThread.SEDU;
    }

    public void setParentEngine(JReportEngine jReportEngine) {
        this.parentReportEngine = jReportEngine;
    }

    public JReportEngine getParentEngine() {
        return this.parentReportEngine;
    }

    public void setLinkInfo(LinkInfo linkInfo) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setLinkInfo()..., info: " + linkInfo);
        }
        this.clearDataSetCenters = linkInfo;
    }

    public void setLinkInfos(List list) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setLinkInfos()..., infos: " + list);
        }
        this.clearEngine = list;
    }

    public LinkInfo getLinkInfo() {
        return this.clearDataSetCenters;
    }

    public List getLinkInfos() {
        return this.clearEngine;
    }

    public List getAllLinkInfos() {
        if (this.clearDataSetCenters == null && this.clearEngine == null) {
            return null;
        }
        ArrayList<LinkInfo> arrayList = new ArrayList<LinkInfo>();
        if (this.clearDataSetCenters != null) {
            arrayList.add(this.clearDataSetCenters);
        }
        if (this.clearEngine != null) {
            arrayList.addAll(this.clearEngine);
        }
        return arrayList;
    }

    public void setMasterDetailInfo(MasterDetailInfo masterDetailInfo) {
        this.clearMem = masterDetailInfo;
    }

    public MasterDetailInfo getMasterDetailInfo() {
        return this.clearMem;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setServerInfo()..., info: " + serverInfo);
        }
        this.catchError = serverInfo;
    }

    public ServerInfo getServerInfo() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getServerInfo()..., return: " + this.catchError);
        }
        return this.catchError;
    }

    public void setKey(String string) {
        this.ThreadException = string;
    }

    public String getKey() {
        return this.ThreadException;
    }

    public void setUID(String string) {
        this.UNKNOWN = string;
    }

    public String getUID() {
        return this.UNKNOWN;
    }

    public void setCallerId(String string) {
        this.__sys__USERNAME = string;
    }

    public String getCallerId() {
        return this.__sys__USERNAME;
    }

    public JRSReportEngine getReportEngine(String string) {
        return this.htReportEngine == null || string == null ? null : (JRSReportEngine)this.htReportEngine.get(string);
    }

    public JReportEngine getReportViewEngine(String string, String string2) {
        if (this.htReportEngine == null) {
            return null;
        }
        String string3 = string == null ? this.getReportSet().getCurReportId() : string;
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string3);
        return jRSReportEngine == null ? null : jRSReportEngine.getViewEngine(string2);
    }

    public Vector getAllReportEngines() {
        Vector<JRSReportEngine> vector = new Vector<JRSReportEngine>();
        if (this.htReportEngine == null) {
            return vector;
        }
        String[] stringArray = this.getReportSet().getAllReportsName();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) continue;
            vector.addElement(jRSReportEngine);
        }
        return vector;
    }

    public Vector getAllReportViewEngines() {
        Vector vector = new Vector();
        Vector vector2 = this.getAllReportEngines();
        for (int i = 0; i < vector2.size(); ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)vector2.elementAt(i);
            vector.addAll(jRSReportEngine.getViewEngines());
        }
        return vector;
    }

    public Vector getReportViewEngines(String[] stringArray, Vector[] vectorArray) {
        Vector<JReportEngine> vector = new Vector<JReportEngine>();
        if (this.htReportEngine == null) {
            return vector;
        }
        if (stringArray == null || stringArray.length == 0) {
            return vector;
        }
        if (vectorArray == null || vectorArray.length == 0) {
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                if (jReportEngine == null) continue;
                vector.addElement(jReportEngine);
            }
        }
        return vector;
    }

    public ReportSetCenter getReportSetCenter() {
        return this.rptSetCenter;
    }

    public void setReportSetCenter(ReportSetCenter reportSetCenter) {
        this.rptSetCenter = reportSetCenter;
    }

    public JRptSetEngine getMainRptSetEngine() {
        return this;
    }

    public void setCatalogBean(JRCatalog jRCatalog) {
        this.addRefreshListener = jRCatalog;
    }

    public void setConfigFile(String string) {
        this.addRptViewNames = string;
    }

    public String getUserName() {
        return this.getEngineEnv().getUserName();
    }

    public SecurityContext getSecurityContext() {
        return this.getEngineEnv().getSecurityContext();
    }

    public SecurityData getSecurityData() {
        return this.getEngineEnv().getSecurityData();
    }

    public void setDataDriver(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setDataDriver()..., url: " + string);
        }
        this.rptSetCenter.setDataDriver(string);
    }

    public void setDataDriver(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setDataDriver()..., dataSetName: " + string + " url: " + string2);
        }
        this.rptSetCenter.setDataDriver(string, string2);
    }

    public JetRptSystemVariable getSysVariable() {
        if (this.clearRawDataId != null) {
            this.clearRawDataId.setUserName(this.getEngineEnv().getUserName());
        }
        return this.clearRawDataId;
    }

    public void setSysVariable(JetRptSystemVariable jetRptSystemVariable) {
        this.clearRawDataId = jetRptSystemVariable;
    }

    public Date getModifyDate() {
        return this.getSysVariable().getModifiedDate();
    }

    public String[] getDataSourceNamesForDynamicInfo() {
        return this.afterInit == null || this.afterInit.isEmpty() ? null : this.afterInit.keySet().toArray(new String[0]);
    }

    public void setFromEncoding(int n) {
        this.afterInitParameter = n;
    }

    public int getFromEncoding() {
        return this.afterInitParameter;
    }

    public void setToEncoding(int n) {
        this.append = n;
    }

    public int getToEncoding() {
        return this.append;
    }

    public void setType(int n) {
        this.addParameterValue = n;
    }

    public int getType() {
        return this.addParameterValue;
    }

    public boolean isSingleThread() {
        return this.getEngineEnv().isSingleThread();
    }

    protected boolean isBatchRun() {
        return this.buildRawQuery;
    }

    public void setIsDHTML(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setIsDHTML()..., isDHTML: " + bl + " this: " + this);
        }
        this.canApplyNLS = bl;
    }

    public boolean isDHTML() {
        return this.canApplyNLS;
    }

    public void setPipe(boolean bl) {
        this.canSummary = bl;
    }

    public boolean isPipe() {
        return this.canSummary;
    }

    public boolean isRsd() {
        return this.add;
    }

    public boolean isBurstingRsd() {
        return this.createJDenyListProvider != null;
    }

    public boolean isReady() {
        return this.cancelRawDataQueries;
    }

    public int getRSDIndex() {
        return this.addElement++;
    }

    public void setIsReady(boolean bl) {
        this.cancelRawDataQueries = bl;
    }

    public String getEncoding() {
        return this.getEngineEnv() == null ? null : this.getEngineEnv().getEncoding();
    }

    public int getConvertFromEncoding() {
        return this.afterInitParameter;
    }

    public int getConvertToEncoding() {
        return this.append;
    }

    public void setConvertEncoding(int n, int n2) {
        this.afterInitParameter = n;
        this.append = n2;
    }

    public Locale getLocale() {
        return this.getEngineEnv().getLocale();
    }

    public TimeZone getTimeZone() {
        return this.getEngineEnv().getTimeZone();
    }

    public void setClientName(String string) {
        this.LOCAL_LANGUAGE = string;
    }

    public String getClientName() {
        return this.LOCAL_LANGUAGE;
    }

    public void setAllowFFP(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setAllowFFP()..., bAFFP: " + bl);
        }
        this.clear = bl;
    }

    public boolean isAllowFFP() {
        return this.clear;
    }

    public void setCPUToken(CPUToken cPUToken) {
        this.clearCubeId = cPUToken;
    }

    public CPUToken getCPUToken() {
        return this.clearCubeId;
    }

    public JDataService getDataService() {
        return this.dataService;
    }

    public CatalogKey getCatalogKey() {
        return this.rptSetCenter == null ? null : this.rptSetCenter.getCatalogKey();
    }

    public void setRSDInfo(RSDInfo rSDInfo) {
        this.addAll = rSDInfo;
    }

    public RSDInfo getRSDInfo() {
        return this.addAll;
    }

    public RSDBurstingProvidor getBurstingRSDProvidor() {
        return this.createJDenyListProvider;
    }

    public void setRSDInfoForRptSet(RSDInfoForSingleRptSet rSDInfoForSingleRptSet) {
        this.rsdInforForRptSet = rSDInfoForSingleRptSet;
    }

    public RSDInfoForSingleRptSet getRSDInfoForRptSet() {
        return this.rsdInforForRptSet;
    }

    public ReportSetEnv getReportSetEnv() {
        return this.isBurstingRsd() ? this.getBurstingRSDProvidor().getReportSetEnv(0) : null;
    }

    public NLSApplyParam getNLSParam() {
        return this.getEngineEnv().getNLSParam();
    }

    public void setEngineExecuter(EngineExecuter engineExecuter) {
        this.closeAllRawDatas = engineExecuter;
    }

    public EngineExecuter getEngineExecuter() {
        return this.closeAllRawDatas;
    }

    protected Vector getListeners() {
        return this.clearRunningReports;
    }

    protected void setListeners(Vector vector) {
        this.clearRunningReports = vector;
    }

    public void addEngineListener(EngineErrorListener engineErrorListener) {
        if (this.getListeners() == null) {
            this.setListeners(new Vector(3));
        }
        if (!this.getListeners().contains(engineErrorListener)) {
            this.getListeners().addElement(engineErrorListener);
        }
    }

    public void removeEngineListener(EngineErrorListener engineErrorListener) {
        if (this.getListeners() != null) {
            this.getListeners().removeElement(engineErrorListener);
            if (this.getListeners().isEmpty()) {
                this.setListeners(null);
            }
        }
    }

    public SpecialFields getSpecialFields(String string) {
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        SpecialFields specialFields = null;
        if (dataSetCenter != null) {
            specialFields = dataSetCenter.getSpecialFields();
        }
        return specialFields;
    }

    public synchronized int genAliasNo() {
        int n = ++this.clearSubEngines;
        return n;
    }

    protected String getFullPathForNlsManager() {
        String string = this.rptSetCenter.getCatLevelResourcePath();
        return string == null ? "" : string;
    }

    public JFieldValueNLSManager getNLSManager() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getNLSManager()...");
        }
        JFieldValueNLSManager jFieldValueNLSManager = null;
        if (this.isRsd()) {
            JRLog.trace(6, "get nls manager for rsd report set.");
            RSDInfo rSDInfo = this.getRSDInfo();
            jFieldValueNLSManager = rSDInfo.getNLSManager();
        } else {
            JRLog.trace(6, "get nls manager for not rsd report set.");
            JetUUniverse jetUUniverse = this.getUniverse();
            if (jetUUniverse != null) {
                jFieldValueNLSManager = jetUUniverse.getNLSManager(this.getLocale());
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getNLSManager()..., return: " + jFieldValueNLSManager);
        }
        return jFieldValueNLSManager;
    }

    public void setScheduleListener(ScheduleListener scheduleListener) {
        this.closeRawData = scheduleListener;
    }

    public boolean isCacheZip() {
        return this.closeRawDatas;
    }

    private void LOCAL_LANGUAGE(int n) {
        if (this.closeRawData != null) {
            this.closeRawData.notifyMessage(n);
        }
    }

    public void setStyleGroup(String string, String string2, String string3) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setStyleGroup()..., rptName: " + string + " viewName: " + string2 + " styleGroup: " + string3);
        }
        if (this.getEngineEnv() != null) {
            this.getEngineEnv().setStyleGroup(string, string3);
        }
    }

    public String[] getReportNames() {
        String[] stringArray = this.getReportSet().getAllReportsName();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.htReportEngine == null || !this.htReportEngine.containsKey(stringArray[i])) continue;
            vector.addElement(stringArray[i]);
        }
        return vector.toArray(new String[0]);
    }

    public Vector[] getViewNames(String[] stringArray) {
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            vectorArray[i] = new Vector();
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                vectorArray[i].addElement(stringArray2[j]);
            }
        }
        return vectorArray;
    }

    public Enumeration getAllDataSetName() {
        return this.rptSetCenter.getAllDataSetName();
    }

    public void setPageNumbers(String string, String string2, int[] nArray) {
    }

    public int[] getPageNumbers(String string, String string2) {
        return null;
    }

    public PageACL getPageACL(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getPageACL()..., rptName: " + string + " viewName: " + string2);
        }
        PageACL pageACL = null;
        JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
        if (jReportEngine != null) {
            pageACL = jReportEngine.getPageACL();
        } else {
            Tools.logTrace(6, "report view engine is null, return null.");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getPageACL(). return: " + pageACL);
        }
        return pageACL;
    }

    public boolean hasSecurity(String string, String string2) throws JRScheduleException {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.hasSecurity()..., rptName: " + string + " viewName: " + string2);
        }
        if ((jReportEngine = this.getReportViewEngine(string, string2)) == null) {
            throw new JRScheduleException(220049, (Object[])new String[]{string, string2}, null);
        }
        ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
        String[] stringArray = reportViewCenter.getAllDataContainerNames();
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0) {
            JetRptReport jetRptReport = reportViewCenter.getReportView();
            for (int i = 0; i < stringArray.length; ++i) {
                JetObject jetObject = jetRptReport.nameToObject(stringArray[i]);
                boolean bl2 = false;
                if (jetObject instanceof JetRptSectionObject) {
                    bl2 = ((JetRptSectionObject)jetObject).isSecurity();
                } else if (jetObject instanceof JetRptNewTable) {
                    bl2 = ((JetRptNewTable)jetObject).isSecurity();
                }
                if (!bl2) continue;
                bl = true;
                break;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.hasSecurity(). return: " + bl);
        }
        return bl;
    }

    private boolean REPORT_NAME(String string, String string2) {
        return false;
    }

    public boolean prepareReportEngines() {
        Tools.logTrace(6, "JRptSetEngine.prepareReportEngines()...");
        boolean bl = this.prepareReportEngines(1);
        Tools.logTrace(6, "End of JRptSetEngine.prepareReportEngines().");
        return bl;
    }

    public boolean prepareReportEngines(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()..., rptName: " + string + " viewName: " + string2);
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        boolean bl = this.prepareReportEngines(new String[]{string}, new Vector[]{vector});
        Tools.logTrace(6, "End of JRptSetEngine.prepareReportEngines().");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareReportEngines(int n) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()..., rptStatus = " + n);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        boolean bl = false;
        Object object = this.fromBl();
        if (object == null) {
            bl = this.ThreadException(n);
        } else {
            Object object2 = object;
            synchronized (object2) {
                bl = this.ThreadException(n);
            }
        }
        if (JRLog.isTrace(6)) {
            this.displayStructure();
            JRLog.trace(6, "prepare report engines, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines()...");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareReportEngines(String[] stringArray, Vector[] vectorArray) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,rptNames = " + Tools.toString(stringArray) + " vRptViews = " + Tools.toString(vectorArray));
        }
        if (stringArray == null || vectorArray == null) {
            Tools.logTrace(5, "warning: rptNames or vRptViews is null!");
            return true;
        }
        if (this.isBursting() && (stringArray.length != 1 || vectorArray.length != 1 || vectorArray[0].size() != 1)) {
            Tools.logTrace(5, "error: only support one bursting report!");
            return false;
        }
        Object object = this.fromBl();
        if (object == null) {
            this.SEDU(stringArray, vectorArray);
        } else {
            Object object2 = object;
            synchronized (object2) {
                this.SEDU(stringArray, vectorArray);
            }
        }
        if (JRLog.isTrace(6)) {
            this.displayStructure();
            JRLog.trace(6, "prepare report engines, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines()...");
        }
        return true;
    }

    private void SEDU(String[] stringArray, Vector[] vectorArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            JetRptReport jetRptReport = this.getReportSet().getReport(stringArray[i]);
            String[] stringArray2 = vectorArray[i].toArray(new String[0]);
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) {
                jRSReportEngine = new JRSReportEngine(jetRptReport, this);
                this.htReportEngine.put(stringArray[i], jRSReportEngine);
                ReportCenter reportCenter = new ReportCenter(jRSReportEngine, stringArray[i]);
                this.rptSetCenter.setReportCenter(stringArray[i], reportCenter);
            }
            jRSReportEngine.createViewEngine(jetRptReport, stringArray2);
        }
    }

    private boolean ThreadException(int n) {
        String[] stringArray = null;
        JetRptReportSet jetRptReportSet = this.getReportSet();
        switch (n) {
            case 0: {
                stringArray = new String[]{jetRptReportSet.getCurReportId()};
                break;
            }
            case 1: {
                stringArray = jetRptReportSet.getOpenedRptNames();
                break;
            }
            case 2: {
                stringArray = jetRptReportSet.getAllReportsName();
                break;
            }
            default: {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,invalid rpt status: " + n);
                }
                return false;
            }
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
                if (jRSReportEngine == null) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "create report engine for report: " + stringArray[i]);
                    }
                    jRSReportEngine = new JRSReportEngine(jetRptReport, this);
                    this.htReportEngine.put(stringArray[i], jRSReportEngine);
                    ReportCenter reportCenter = new ReportCenter(jRSReportEngine, stringArray[i]);
                    this.rptSetCenter.setReportCenter(stringArray[i], reportCenter);
                }
                jRSReportEngine.createViewEngine(jetRptReport, n);
            }
        }
        return true;
    }

    public boolean prepareReportEngines(RSDInfo rSDInfo) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines()...,rsdInfo = " + rSDInfo);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        this.addAll = rSDInfo;
        this.add = true;
        int n = this.getRSDIndex();
        this.rsdInforForRptSet = rSDInfo.getRSDInfoForRptSet(n);
        this.cancelRawDataQuery.setValidParamValues(this.UNKNOWN(rSDInfo.getParameter()));
        Map map = rSDInfo.getReportInfos(0);
        int n2 = map.size();
        String[] stringArray = new String[n2];
        Vector[] vectorArray = new Vector[n2];
        int n3 = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n3] = (String)iterator.next();
            vectorArray[n3] = (Vector)map.get(stringArray[n3]);
            ++n3;
        }
        boolean bl = this.prepareReportEngines(stringArray, vectorArray);
        String[] stringArray2 = rSDInfo.getRptSetNames();
        JetRptReportSet[] jetRptReportSetArray = new JetRptReportSet[stringArray2.length];
        for (int i = 0; i < jetRptReportSetArray.length; ++i) {
            jetRptReportSetArray[i] = rSDInfo.getRptSet(i);
        }
        Hashtable hashtable = rSDInfo.getImgMappingTable();
        if (hashtable != null) {
            this.catchError(jetRptReportSetArray, hashtable);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepare report engines, total cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines(rsdInfo).");
        }
        return bl;
    }

    public boolean prepareReportEngines(RSDBurstingProvidor rSDBurstingProvidor) {
        int n;
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareReportEngines(burstingRSDProvidor)...,providor = " + rSDBurstingProvidor);
        }
        if (this.isBursting()) {
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, new JRScheduleException(220075));
            }
            return false;
        }
        this.createJDenyListProvider = rSDBurstingProvidor;
        this.cancelRawDataQuery.setValidParamValues(this.UNKNOWN(this.createJDenyListProvider.getParamerValues()));
        ReportSetEnv reportSetEnv = this.createJDenyListProvider.getReportSetEnv(0);
        String[] stringArray = reportSetEnv.getReportNames();
        Vector[] vectorArray = new Vector[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            vectorArray[n] = new Vector<String>(Arrays.asList(reportSetEnv.getReportViewNames(stringArray[n])));
        }
        n = this.prepareReportEngines(stringArray, vectorArray) ? 1 : 0;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepare report engines, total cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareReportEngines(burstingRSDProvidor).");
        }
        return n != 0;
    }

    private Map UNKNOWN(Map map) {
        if (map == null) {
            return null;
        }
        HashMap<String, ParameterValueDesc> hashMap = new HashMap<String, ParameterValueDesc>();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (v instanceof ParameterValueDesc) {
                hashMap.put(string, (ParameterValueDesc)v);
                continue;
            }
            ParameterValueDesc parameterValueDesc = null;
            if (v instanceof ParameterValueDesc) {
                parameterValueDesc = (ParameterValueDesc)v;
            } else if (v instanceof String) {
                parameterValueDesc = new ParameterValueDescImpl((String)v);
            } else if (v instanceof String[]) {
                parameterValueDesc = new ParameterValueDescImpl((String[])v);
            }
            if (parameterValueDesc == null) continue;
            hashMap.put(string, parameterValueDesc);
        }
        return hashMap;
    }

    public void runReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptName: " + string + " viewName: " + string2);
        }
        this.runReport(string, string2, true);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public void runReport(String string, String string2, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptName: " + string + " viewName: " + string2 + " applyStyleNls: " + bl);
        }
        String[] stringArray = new String[]{string};
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        this.runReport(stringArray, vectorArray, bl);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public boolean relayout(String string, String string2) {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "JRptSetEngine.relayout()..., rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null) {
            Tools.logTrace(5, "End of JRptSetEngine.relayout(), no any report engines, return false.");
            return false;
        }
        if (!this.finished(string, string2)) {
            Tools.logTrace(5, "End of JRptSetEngine.relayout(), report view don't be requested to run, return false.");
            return false;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (jRSReportEngine == null) {
            Tools.logTrace(5, "End of JRptSetEngine.relayout(), report engine don't exist, return false.");
            return false;
        }
        ReportViewNames reportViewNames = new ReportViewNames();
        reportViewNames.addRptViewNames(string, string2);
        this.deepDupWithName(reportViewNames);
        boolean bl = jRSReportEngine.layoutReportView(string2);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "End of JRptSetEngine.relayout(), return " + bl);
        }
        return bl;
    }

    public void restore(String string, String string2) throws JRScheduleException, JRStopEngineException {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "JRptSetEngine.restore()..., rptName: " + string + " viewName: " + string2);
        }
        if ((jReportEngine = this.getReportViewEngine(string, string2)) == null) {
            Tools.logTrace(5, "End of JRptSetEngine.restore(), report engine doesn't exist.");
            return;
        }
        jReportEngine.restore();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "End of JRptSetEngine.restore().");
        }
    }

    public void runReport(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        this.runReport(stringArray, vectorArray, true);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    public void runReport(String[] stringArray, Vector[] vectorArray, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " applyStyleNls: " + bl);
        }
        if (!this.requestRunReport(stringArray, vectorArray)) {
            return;
        }
        this.LOCAL_LANGUAGE(7);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = vectorArray[i].toArray(new String[vectorArray[i].size()]);
            for (int j = 0; j < stringArray2.length; ++j) {
                this.doRequestRunReport(string, stringArray2[j], bl);
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDataSet(String string, boolean bl) throws JRScheduleException {
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runDataSet()..., rptSetEngine: " + this + " dataSetName: " + string + " refreshData: " + bl);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set center is null, dataSetName: " + string);
            }
            return;
        }
        if (dataSetCenter.getDataSet().getMappingListSrc() == 3) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set is hds, can't run data set, dataSetName: " + string);
            }
            return;
        }
        if (!dataSetCenter.hasDbFieldOrPass1Formula() && !dataSetCenter.hasConstantGlobalFormula()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "run data set: no db fields and formula. ");
                JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
            }
            return;
        }
        DataSetCenter dataSetCenter2 = dataSetCenter;
        synchronized (dataSetCenter2) {
            JCubeQuery jCubeQuery;
            if (bl) {
                dataSetCenter.setNeedInitQuery(true);
                dataSetCenter.setNeedRefresh(true);
                dataSetCenter.setNeedInitCubeQuery(true);
                dataSetCenter.setNeedRefreshCube(true);
            }
            if (!dataSetCenter.needRefresh() && !dataSetCenter.needRefreshCube()) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "run data set: it is not need to refresh data. ");
                    JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
                }
                return;
            }
            try {
                Tools.logTrace(6, "init raw data query.");
                this.initRawDataQuery(dataSetCenter);
            }
            catch (JRScheduleException jRScheduleException) {
                if (!this.catchError(string, jRScheduleException)) {
                    throw jRScheduleException;
                }
                return;
            }
            JRawDataQuery jRawDataQuery = dataSetCenter.needRefresh() ? dataSetCenter.getRawDataQuery() : null;
            JCubeQuery jCubeQuery2 = jCubeQuery = dataSetCenter.needRefreshCube() ? dataSetCenter.getCubeQuery() : null;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "begin run raw data query..., rawDataQueryId: " + dataSetCenter.getRawDataId() + " query: " + jRawDataQuery);
            }
            if (jRawDataQuery == null && jCubeQuery == null) {
                Tools.logTrace(6, "raw data query and cube query are all null.");
            } else {
                Object object;
                Tools.logTrace(6, "begin run data set..., " + string);
                long l = System.currentTimeMillis();
                Tools.logTrace(6, "rptSetName: " + this.rptSetCenter.getRptSetName());
                try {
                    object = this.getDataService();
                    if (jRawDataQuery != null) {
                        IShareInfoProvider iShareInfoProvider = this.rptSetCenter.getShareInfoProvider();
                        if (iShareInfoProvider == null) {
                            object.sendQuery(jRawDataQuery);
                        } else {
                            ShareInfo shareInfo = this.generateShareInfo(string, iShareInfoProvider);
                            if (shareInfo != null) {
                                jRawDataQuery.setShareInfo(shareInfo);
                            }
                            object.sendQuery(jRawDataQuery);
                        }
                        int n = jRawDataQuery.getRawDataId();
                        dataSetCenter.setRawDataId(n);
                        Tools.logTrace(6, "execute raw data query, id: " + n);
                    }
                    if (jCubeQuery != null) {
                        object.sendQuery(jCubeQuery);
                        int n = jCubeQuery.getCubeQueryId();
                        dataSetCenter.setCubeQueryId(n);
                        Tools.logTrace(6, "execute cubeId query, id: " + n);
                    }
                }
                catch (DSException dSException) {
                    JRScheduleException jRScheduleException = new JRScheduleException(220002, (Object[])new String[]{string}, (Throwable)dSException);
                    if (!this.catchError(string, jRScheduleException)) {
                        throw jRScheduleException;
                    }
                    return;
                }
                catch (JRStopEngineException jRStopEngineException) {
                    JRScheduleException jRScheduleException = new JRScheduleException(220002, (Object[])new String[]{string}, (Throwable)jRStopEngineException);
                    if (!this.catchError(string, jRScheduleException)) {
                        throw jRScheduleException;
                    }
                    return;
                }
                object = dataSetCenter.getRawDataListener();
                ((DataSetListener)object).disable();
                if (((DataSetListener)object).getError() != null && JRLog.isTrace(4)) {
                    JRLog.trace(4, new JRScheduleException(220002, (Object[])new String[]{string}, ((DataSetListener)object).getError()));
                }
                long l2 = System.currentTimeMillis();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "prepare raw data query of data set " + string);
                }
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "SCHEDULE_PRDQ, [ELAPSED]: " + (l2 - l));
                }
            }
            dataSetCenter.setNeedRefresh(false);
            dataSetCenter.setHasUsed(true);
            Tools.logTrace(6, "End of JRptSetEngine.runDataSet().");
        }
    }

    public ShareInfo generateShareInfo(String string, IShareInfoProvider iShareInfoProvider) {
        if ("virtual\u0007dataset\u0007name".equals(string)) {
            return null;
        }
        if (iShareInfoProvider == null) {
            return null;
        }
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        if (dataSetCenter == null) {
            return null;
        }
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        Scope scope = new Scope(this.rptSetCenter.getCatalog(), null, jetRptDataSet);
        String string2 = scope.getBVName();
        KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), this.getUniverse());
        String string3 = keyDataSourceQuery.getDataSourceName();
        String string4 = keyDataSourceQuery.getQueryName();
        return new ShareInfo(this.getCatalogKey(), this.getUserName(), iShareInfoProvider.getSessionId(), iShareInfoProvider.getReportId(), string2, string3, string4);
    }

    protected boolean catchError(String string, JRScheduleException jRScheduleException) {
        if (this instanceof JSubRptSetEngine) {
            ((JSubRptSetEngine)this).setThrowedError(string, jRScheduleException);
            return true;
        }
        return false;
    }

    public void resetRawDataQuery(String string, JRawDataQuery jRawDataQuery, Hashtable hashtable) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.resetRawDataQuery()..., dataSetName: " + string + "params: " + hashtable);
        }
        new DataSetQueryBuilder(this).resetRawDataQuery(string, jRawDataQuery, hashtable);
        Tools.logTrace(6, "End of JRptSetEngine.resetRawDataQuery().");
    }

    JRawDataQuery genRawDataQuery(JQueryFactory jQueryFactory, CatalogKey catalogKey, DataSetCenter dataSetCenter, ISortExpression iSortExpression, boolean bl) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.genRawDataQuery()..., dataSetName: " + dataSetCenter.getDataSetName() + " queryFactory: " + jQueryFactory + " catKey: " + catalogKey + " sort: " + iSortExpression + " useDataBlock: " + bl + " rptSetEngine: " + this);
        }
        String string = dataSetCenter.getDataSetName();
        JRawDataQuery jRawDataQuery = this.getQueryBuilder().buildRawQuery(jQueryFactory, catalogKey, string, iSortExpression, bl);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.genRawDataQuery(), return: " + jRawDataQuery);
        }
        return jRawDataQuery;
    }

    void getCFJavaFormulas(List list, String string) {
        JetRptDataSet jetRptDataSet = this.getReportSet().getDataSet(string);
        if (jetRptDataSet == null) {
            return;
        }
        String string2 = jetRptDataSet.getDataSourceName();
        String[] stringArray = this.getReportNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; stringArray2 != null && j < stringArray2.length; ++j) {
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[j]);
                JavaFormula javaFormula = jReportEngine.getCFJavaFormula(string2);
                if (javaFormula == null) continue;
                list.add(javaFormula);
            }
        }
    }

    Hashtable getRptLevelFormulas(DataSetCenter dataSetCenter) {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = dataSetCenter.getCFFormulas();
        Hashtable hashtable3 = dataSetCenter.getFlyFormulas();
        hashtable.putAll(hashtable2);
        hashtable.putAll(hashtable3);
        return hashtable;
    }

    void getFlyJavaFormulas(List list, String string) {
        JetRptDataSet jetRptDataSet = ScheduleTools.getRawQueryDataSet(string, this.getReportSet());
        if (jetRptDataSet == null) {
            return;
        }
        QueryInfo queryInfo = jetRptDataSet.fromBl() ? jetRptDataSet.getQueryInfo() : null;
        String[] stringArray = this.getReportNames();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; stringArray2 != null && j < stringArray2.length; ++j) {
                JavaFormula javaFormula;
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[j]);
                ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
                reportViewCenter.getDataContainerJavaFormula(list, string, reportViewCenter.getRootDataContainer());
                if (queryInfo == null || (javaFormula = jReportEngine.getFlyJavaFormula(queryInfo)) == null) continue;
                list.add(javaFormula);
            }
        }
    }

    public String[] getMappingNamesInRawQuery(String string) throws JRScheduleException {
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        if (dataSetCenter == null) {
            throw new JRScheduleException();
        }
        String[] stringArray = null;
        if (dataSetCenter.hasDbFieldOrPass1Formula()) {
            stringArray = this.rptSetCenter.getDbFieldFormulaMappingFields(string);
        } else if (dataSetCenter.hasConstantGlobalFormula()) {
            stringArray = dataSetCenter.getConstantGlobalFormulaNames();
        } else {
            Tools.logTrace(6, "no any mapping name used in data set " + string);
            stringArray = new String[]{};
        }
        return stringArray;
    }

    ParameterValueList getParameterValueList(String string, Hashtable hashtable) throws DSException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getParameterValueList()..., dataSetName: " + string + "params: " + hashtable);
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        Hashtable hashtable2 = this.getParamsBuffer();
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            for (String string2 : hashtable2.keySet()) {
                ParamDesc paramDesc = this.__sys__USERNAME(string2, hashtable, hashtable2);
                Tools.logTrace(6, "add to parameter list: " + paramDesc);
                parameterValueList.addParameterValue(paramDesc);
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.getParameterValueList().");
        return parameterValueList;
    }

    private ParamDesc __sys__USERNAME(String string, Hashtable hashtable, Hashtable hashtable2) {
        ParamDesc paramDesc = null;
        if (hashtable != null) {
            paramDesc = (ParamDesc)hashtable.get(string);
        }
        if (paramDesc == null) {
            paramDesc = (ParamDesc)hashtable2.get(string);
        }
        if (paramDesc == null) {
            paramDesc = UniverseTools.getParamDesc(string, this.getUniverse(), this.isRsd());
            this.getParamsBuffer().put(string, paramDesc);
        }
        return paramDesc;
    }

    public void initRawDataQuery(DataSetCenter dataSetCenter) throws JRScheduleException {
        CatalogKey catalogKey;
        String string;
        JetRptDataSet jetRptDataSet;
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.initRawDataQuery()..., dataSetName: " + dataSetCenter.getDataSetName());
        }
        if ((jetRptDataSet = ScheduleTools.getRawQueryDataSet(string = dataSetCenter.getDataSetName(), this.getReportSet())).getMappingListSrc() == 3) {
            Tools.logTrace(6, "data set is hds.");
            return;
        }
        if (!dataSetCenter.needInitQuery()) {
            this.initCubeQuery(dataSetCenter);
            Tools.logTrace(6, "return needInitQuery: " + dataSetCenter.needInitQuery());
            return;
        }
        this.access$100(dataSetCenter);
        if (!dataSetCenter.hasData()) {
            Tools.logTrace(6, "data set has not data, dataSetName: " + dataSetCenter.getDataSetName());
            return;
        }
        if (!dataSetCenter.hasDbFieldOrPass1Formula() && !dataSetCenter.hasConstantGlobalFormula()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no db fields and formula. ");
                JRLog.trace(6, "hasUsed():" + dataSetCenter.hasUsed());
            }
            return;
        }
        JQueryFactory jQueryFactory = this.getDataService().getQueryFactory();
        JRawDataQuery jRawDataQuery = this.genRawDataQuery(jQueryFactory, catalogKey = this.getCatalogKey(), dataSetCenter, null, true);
        if (jRawDataQuery == null) {
            return;
        }
        if (dataSetCenter.getRawDataId() != null) {
            Tools.logTrace(6, "init raw data query, close raw data query, id: " + dataSetCenter.getRawDataId());
            this.getDataService().closeQuery(dataSetCenter.getRawDataId());
        }
        dataSetCenter.clearRawDataId();
        dataSetCenter.setRawDataQuery(jRawDataQuery);
        dataSetCenter.setNeedInitQuery(false);
        dataSetCenter.setNeedRefresh(true);
        this.initCubeQuery(dataSetCenter);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init raw data query, cost time(include init cube query): " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.initRawDataQuery().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRawDataQuery getRawDataQuery(String string, JetRptSubReport jetRptSubReport) throws JRScheduleException {
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        if (dataSetCenter == null) {
            return null;
        }
        DataSetCenter dataSetCenter2 = dataSetCenter;
        synchronized (dataSetCenter2) {
            this.initRawDataQuery(dataSetCenter);
        }
        return dataSetCenter.getRawDataQuery();
    }

    public void initCubeQuery(DataSetCenter dataSetCenter) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.initCubeQuery()..., dataSetName: " + dataSetCenter.getDataSetName());
        }
        if (!dataSetCenter.needInitCubeQuery()) {
            Tools.logTrace(6, "don't need init cube query, return!");
            Tools.logTrace(6, "End of JRptSetEngine.initCubeQuery()...");
            return;
        }
        this.access$100(dataSetCenter);
        CubeModel cubeModel = dataSetCenter.getCubeModel();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "cube model: " + cubeModel);
        }
        if (cubeModel != null && cubeModel.getDimensions() != null && cubeModel.getDimensions().length > 0) {
            Tools.logTrace(6, "create cube., ");
            JQueryFactory jQueryFactory = this.getDataService().getQueryFactory();
            JCubeQuery jCubeQuery = this.getQueryBuilder().buildCubeQuery(jQueryFactory, dataSetCenter.getDataSetName());
            dataSetCenter.setCubeQuery(jCubeQuery);
            Tools.logTrace(6, "generated cube query.");
        } else {
            Tools.logTrace(6, "don't create cube. ");
        }
        dataSetCenter.setNeedInitCubeQuery(false);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init cube query, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.initCubeQuery().");
        }
    }

    private void access$100(DataSetCenter dataSetCenter) {
        Integer n = dataSetCenter.getCubeQueryId();
        if (n != null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "close cube query, id: " + n);
            }
            this.getDataService().closeQuery(n);
            dataSetCenter.setCubeQuery(null);
            dataSetCenter.clearCubeId();
        }
    }

    private String access$300(DataSetCenter dataSetCenter) {
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        if ("virtual\u0007dataset\u0007name".equals(jetRptDataSet.getName())) {
            return null;
        }
        JetUUniverse jetUUniverse = this.getUniverse();
        if (jetUUniverse != null) {
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jetUUniverse);
            if (keyDataSourceQuery == null) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "can't get data source query info for data set: " + jetRptDataSet.getName());
                }
            } else {
                String string = keyDataSourceQuery.getDataSourceName();
                String string2 = keyDataSourceQuery.getQueryName();
                return this.rptSetCenter.getWhereName(string, string2);
            }
        }
        return null;
    }

    private String access$400(DataSetCenter dataSetCenter) {
        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
        if ("virtual\u0007dataset\u0007name".equals(jetRptDataSet.getName())) {
            return null;
        }
        JetUUniverse jetUUniverse = this.getUniverse();
        if (jetUUniverse != null) {
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jetUUniverse);
            if (keyDataSourceQuery == null) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "can't get data source query info for data set: " + jetRptDataSet.getName());
                }
            } else {
                String string = keyDataSourceQuery.getDataSourceName();
                String string2 = keyDataSourceQuery.getQueryName();
                return this.rptSetCenter.getWherePortion(string, string2);
            }
        }
        return null;
    }

    String getFinalWherePortion(DataSetCenter dataSetCenter) {
        String string;
        String string2 = this.access$400(dataSetCenter);
        if ((string2 == null || string2.trim().length() == 0) && (string = this.access$300(dataSetCenter)) != null) {
            string2 = this.getUniverse().getWherePortion(string);
        }
        return string2;
    }

    public SpecialFields getSpecialFields() {
        SpecialFields specialFields = new SpecialFields();
        specialFields.setUserName(new DbChar(this.getUserName()));
        Date date = this.getSysVariable().getModifiedDate();
        specialFields.setModifiedDate(new DbDate(new java.sql.Date(date.getTime())));
        specialFields.setModifiedTime(new DbTime(new Time(date.getTime())));
        specialFields.setPrintDate(new DbDate(new java.sql.Date(date.getTime())));
        specialFields.setPrintTime(new DbTime(new Time(date.getTime())));
        return specialFields;
    }

    public int getEngineStatus(String string, String string2) {
        return 0;
    }

    public void runReport(Hashtable hashtable) {
    }

    public PrincipalAttributes getCataLogAttributes() {
        PrincipalAttributes principalAttributes;
        PrincipalAttributes principalAttributes2 = principalAttributes = this.rptSetCenter == null ? null : this.rptSetCenter.getCataLogAttributes();
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "JRptSetEngine.getCataLogAttributes(), return: " + principalAttributes);
        }
        return principalAttributes;
    }

    public JetUUniverse getUniverse() {
        PrincipalAttributes principalAttributes = this.getCataLogAttributes();
        return principalAttributes == null ? null : (JetUUniverse)principalAttributes.getPrincipal();
    }

    public void setParamFile(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamFile()..., paramFile: " + string);
        }
        this.applyNLSorDynamicStyle = string;
    }

    public String getParamFile() {
        return this.applyNLSorDynamicStyle;
    }

    public void setParamValues(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamValues()..., paramValues: " + string);
        }
        this.applyStyleNls = string;
    }

    public String getParamValues() {
        return this.applyStyleNls;
    }

    public void setParamValueDescs(Map map) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setParamProperty()..., pParamValue: " + map);
        }
        this.asList = map;
    }

    public Map getParamValueDescs() {
        return this.asList;
    }

    public Map getValidParamValues() {
        return this.cancelRawDataQuery.getValidParamValues();
    }

    public Hashtable getParamsBuffer() {
        return this.cancelRawDataQuery.getParamBuff();
    }

    public Hashtable getParamContxtBuff() {
        return this.getParameterManager().getParamAdapter().getParamContxtBuff();
    }

    public PrincipalAttributes getRptSetAttributes() {
        PrincipalAttributes principalAttributes;
        PrincipalAttributes principalAttributes2 = principalAttributes = this.rptSetCenter == null ? null : this.rptSetCenter.getRptSetAttributes();
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, "JRptSetEngine.getRptSetAttributes(), return: " + principalAttributes);
        }
        return principalAttributes;
    }

    public JetRptReportSet getReportSet() {
        PrincipalAttributes principalAttributes = this.getRptSetAttributes();
        return principalAttributes == null ? null : (JetRptReportSet)principalAttributes.getPrincipal();
    }

    public void setOnDemandReport(boolean bl) {
        this.checkSubReportLoop = bl;
    }

    public boolean isOnDemandReport() {
        return this.checkSubReportLoop;
    }

    public void setReportSet(JetRptReportSet jetRptReportSet) {
    }

    public boolean stop() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stop()...");
        }
        boolean bl = true;
        if (this.htReportEngine != null && !this.htReportEngine.isEmpty()) {
            this.closeAllGroupDatas = true;
            int n = this.htReportEngine.size();
            String[] stringArray = new String[n];
            Vector[] vectorArray = new Vector[n];
            int n2 = 0;
            Enumeration enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vectorArray[n2] = new Vector();
                stringArray[n2] = string;
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
                String[] stringArray2 = jRSReportEngine.getViewNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    vectorArray[n2].addElement(stringArray2[i]);
                }
                ++n2;
            }
            bl = this.stop(stringArray, vectorArray);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.stop(), return: " + bl);
        }
        return bl;
    }

    public boolean stop(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stop()..., rptName: " + string + " viewName: " + string2);
        }
        String[] stringArray = new String[]{string};
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        boolean bl = this.stop(stringArray, vectorArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.stop(), return: " + bl);
        }
        return bl;
    }

    public boolean stop(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stop()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        if (!this.isRunning()) {
            Tools.logTrace(5, "report set engine is not running, skip it, return true!");
            return true;
        }
        if (this.isStopping()) {
            Tools.logTrace(5, "report set engine is stopping, skip it, return false!");
            return false;
        }
        Tools.logTrace(6, "internal set bStopping as true.");
        this.clone = true;
        this.closeAllRawDatas();
        this.closeRawData(stringArray, vectorArray);
        HashMap hashMap = this.add();
        if (hashMap == null || hashMap.isEmpty()) {
            return true;
        }
        for (String string : hashMap.keySet()) {
            Vector vector = (Vector)hashMap.get(string);
            if (vector == null || vector.isEmpty()) continue;
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                jRSReportEngine.stop(string2);
            }
        }
        String[] stringArray2 = this.doConvertDataContainerInReport(stringArray, vectorArray);
        this.cancelRawDataQueries(stringArray2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.stop(). return: true.");
        }
        return true;
    }

    private HashMap add() {
        Tools.logTrace(6, "JRptSetEngine.getRealStopReports()...");
        if (this.disable == null || this.disable.isEmpty()) {
            Tools.logTrace(6, "no any report is running, can't stop any report.");
            return null;
        }
        if (this.displayStructure == null || this.displayStructure.isEmpty()) {
            Tools.logTrace(6, "no any report is stopping, can't stop any report.");
            return null;
        }
        Tools.logTrace(6, "running report: " + this.disable + " stopping report: " + this.displayStructure);
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        Enumeration enumeration = this.displayStructure.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.disable.containsKey(string)) continue;
            Vector vector = (Vector)((Vector)this.disable.get(string)).clone();
            Vector vector2 = (Vector)this.displayStructure.get(string);
            Tools.logTrace(6, "running: " + vector + " stoping: " + vector2);
            vector.retainAll(vector2);
            hashMap.put(string, vector);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getRealStopReports(), return: " + hashMap);
        }
        return hashMap;
    }

    public void clear() {
        Object object;
        Object object2;
        Tools.logTrace(6, "JRptSetEngine.clear()...");
        HashMap hashMap = this.add();
        this.waitRunFinished(hashMap);
        if (hashMap != null && !hashMap.isEmpty()) {
            for (String string : hashMap.keySet()) {
                object2 = (Vector)hashMap.get(string);
                if (object2 == null || ((Vector)object2).isEmpty()) {
                    Tools.logTrace(6, "views is " + (object2 == null ? "null." : "empty."));
                    continue;
                }
                object = (JRSReportEngine)this.htReportEngine.get(string);
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    String string2 = (String)((Vector)object2).elementAt(i);
                    ((JRSReportEngine)object).clear(string2);
                }
            }
        }
        if (this.closeAllGroupDatas) {
            Vector vector = this.getAllReportViewEngines();
            if (vector != null && !vector.isEmpty()) {
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = (JReportEngine)vector.elementAt(i);
                    object = ((JEngineInitializer)object2).getReportViewCenter();
                    ((ReportViewCenter)object).closeAllSubReportDatas();
                    ((JReportEngine)object2).closeAllGroups();
                }
            }
            String[] stringArray = this.rptSetCenter.getDataSetNames();
            for (int i = 0; i < stringArray.length; ++i) {
                object = this.rptSetCenter.getDataSetCenter(stringArray[i]);
                ((DataSetCenter)object).closeRawData(this.getDataService());
            }
        }
        this.closeAllGroupDatas = false;
        Tools.logTrace(6, "internal set bStopping as false.");
        this.clone = false;
        Tools.logTrace(6, "End of JRptSetEngine.clear().");
    }

    public Hashtable getReportParams(Vector vector) {
        return null;
    }

    public Hashtable getReportSetParams() {
        return null;
    }

    public void prepareMappingFields() {
    }

    public void refreshReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.refreshReport()..., rptName: " + string + " viewName: " + string2);
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (string2 == null) {
            string2 = this.rptSetCenter.getReportCenter(string).getReport().getCurViewName();
        }
        JReportEngine jReportEngine = jRSReportEngine.getViewEngine(string2);
        jReportEngine.initRun();
        this.runReport(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.refreshReport()...");
    }

    public Hashtable getUseRptView(int n, String string) {
        return this.rptSetCenter.getUseRptView(n, string);
    }

    public Hashtable getUseRptView(String string) {
        return this.rptSetCenter.getUseRptView(string);
    }

    public JetRptReport getReport(String string) {
        return this.getReportEngine(string).getReport();
    }

    public Hashtable getReportViewNames() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.htReportEngine.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
            String[] stringArray = jRSReportEngine.getViewNames();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < vector.size(); ++i) {
                vector.addElement(stringArray[i]);
            }
            hashtable.put(string, vector);
        }
        return hashtable;
    }

    public void preinitMainEngine(boolean bl) throws EngingPreinitException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitMainEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Vector[] vectorArray = this.htReportEngine.keys();
        while (vectorArray.hasMoreElements()) {
            vector.addElement(vectorArray.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) continue;
            vectorArray[i] = jRSReportEngine.getRptViewNames();
        }
        this.preinitMainEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.preinitMainEngine()");
    }

    public void preinitMainEngine(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException {
        this.preinitMainEngine(stringArray, vectorArray, false);
    }

    public void preinitMainEngine(String[] stringArray, Vector[] vectorArray, boolean bl) throws EngingPreinitException {
        String[] stringArray2;
        int n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitMainEngine()..., rptNames = " + Tools.toString(stringArray) + " vRptViews = " + Tools.toString(vectorArray) + " forceInit: " + bl);
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl) {
            this.rptSetCenter.resetParameterInDataSetInfo();
            this.rptSetCenter.resetParameterInQueryInfo();
            this.cancelRawDataQuery.reset();
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < vectorArray[n].size(); ++i) {
                    stringArray2 = (String)vectorArray[n].elementAt(i);
                    this.clearRawDataId(stringArray[n], (String)stringArray2);
                }
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            stringArray2 = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.preinitEngine(stringArray2, bl);
            jRSReportEngine.initRunEngine(stringArray2, bl);
        }
        Tools.logTrace(4, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitMainEngine()...");
    }

    public void preinitEngine(boolean bl) throws EngingPreinitException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Vector[] vectorArray = this.htReportEngine.keys();
        while (vectorArray.hasMoreElements()) {
            vector.addElement(vectorArray.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) continue;
            vectorArray[i] = jRSReportEngine.getRptViewNames();
        }
        this.preinitEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()");
    }

    public void preinitEngine(String[] stringArray, Vector[] vectorArray, boolean bl) throws EngingPreinitException, JRScheduleException {
        Object object;
        int n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngine()..., rptNames: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray) + " forceInit: " + bl);
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (bl) {
            this.rptSetCenter.resetParameterInDataSetInfo();
            this.rptSetCenter.resetParameterInQueryInfo();
            this.cancelRawDataQuery.reset();
            for (n = 0; n < stringArray.length; ++n) {
                for (int i = 0; i < vectorArray[n].size(); ++i) {
                    object = (String)vectorArray[n].elementAt(i);
                    this.reset(stringArray[n], (String)object);
                }
            }
            if (this.addAll(stringArray, vectorArray)) {
                String[] stringArray2 = this.getUsedDataSetNames();
                this.closeRawDatas(stringArray2);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[n]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[n]);
                return;
            }
            object = vectorArray[n].toArray(new String[0]);
            jRSReportEngine.preinitEngine((String[])object, bl);
        }
        Tools.logTrace(4, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        if (bl) {
            long l2 = System.currentTimeMillis();
            try {
                this.append(stringArray, vectorArray);
            }
            catch (EngingPreinitException engingPreinitException) {
                JRScheduleException jRScheduleException = new JRScheduleException(220013, (Throwable)engingPreinitException);
                if (JRLog.isError(1)) {
                    JRLog.error(1, jRScheduleException);
                }
                throw jRScheduleException;
            }
            catch (JRScheduleException jRScheduleException) {
                if (JRLog.isError(1)) {
                    JRLog.error(1, jRScheduleException);
                }
                throw jRScheduleException;
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, "pre init sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
            }
        }
        long l3 = System.currentTimeMillis();
        if (this.isRsd()) {
            // empty if block
        }
        if (bl) {
            this.rptSetCenter.clearDataSetCenters();
        }
        Tools.logTrace(4, "pre init whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()...");
    }

    private boolean addAll(String[] stringArray, Vector[] vectorArray) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        String[] stringArray2 = this.getReportNames();
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray2));
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        return arrayList.equals(arrayList2);
    }

    public void preinitEngineAbsolute(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.preinitEngineAbsolute()..., rptNames: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray));
        }
        this.LOCAL_LANGUAGE(3);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[i]);
                return;
            }
            String[] stringArray2 = vectorArray[i].toArray(new String[0]);
            jRSReportEngine.preinitEngineAbsolute(stringArray2);
        }
        Tools.logTrace(4, "pre init main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        try {
            this.append(stringArray, vectorArray);
        }
        catch (EngingPreinitException engingPreinitException) {
            JRScheduleException jRScheduleException = new JRScheduleException(220013, (Throwable)engingPreinitException);
            if (JRLog.isError(1)) {
                JRLog.error(1, jRScheduleException);
            }
            throw jRScheduleException;
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isError(1)) {
                JRLog.error(1, jRScheduleException);
            }
            throw jRScheduleException;
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "pre init sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        }
        long l3 = System.currentTimeMillis();
        if (this.isRsd()) {
            // empty if block
        }
        Tools.logTrace(4, "pre init whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.preinitEngine()...");
    }

    public void initRunEngine(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngine()..., forceInit: " + bl);
        }
        String[] stringArray = null;
        Vector vector = new Vector();
        Vector[] vectorArray = this.htReportEngine.keys();
        while (vectorArray.hasMoreElements()) {
            vector.addElement(vectorArray.nextElement());
        }
        stringArray = vector.toArray(new String[0]);
        vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) continue;
            vectorArray[i] = jRSReportEngine.getRptViewNames();
        }
        this.initRunEngine(stringArray, vectorArray, bl);
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngine()");
    }

    public void initRunEngine(String[] stringArray, Vector[] vectorArray, boolean bl) {
        Object[] objectArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngine()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray) + " forceInit: " + bl);
            JRLog.trace(6, "initRun..., parameter buf: " + this.getParamsBuffer().toString());
        }
        this.LOCAL_LANGUAGE(5);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[i]);
                return;
            }
            objectArray = vectorArray[i].toArray(new String[0]);
            jRSReportEngine.initRunEngine((String[])objectArray, bl);
        }
        Tools.logTrace(4, "init run main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        this.applyNLS(stringArray, vectorArray);
        Tools.logTrace(4, "init run sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        if (bl) {
            this.rptSetCenter.refreshAllRecSecurities(this.getEngineEnv());
            this.equals(stringArray, vectorArray);
            objectArray = this.rptSetCenter.getAllSubRptSetEngines();
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ReportSetCenter reportSetCenter = ((JRptSetEngine)objectArray[i]).getReportSetCenter();
                    reportSetCenter.getRptSetEngine().closeAllGroupDatas();
                    reportSetCenter.closeAllRawDatas();
                    reportSetCenter.refreshAllRecSecurities(this.getEngineEnv());
                    ((JSubRptSetEngine)objectArray[i]).initAllRawDataQuery();
                }
            }
        }
        Tools.logTrace(4, "init run whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngine()");
    }

    public void initRunEngineAbsolute(String[] stringArray, Vector[] vectorArray) {
        Object[] objectArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initRunEngineAbsolute()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
            JRLog.trace(6, "initRun..., parameter buf: " + this.getParamsBuffer().toString());
        }
        this.LOCAL_LANGUAGE(5);
        if (stringArray == null) {
            return;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            if (jRSReportEngine == null) {
                Tools.logTrace(6, "engine is not exists! rptName = " + stringArray[i]);
                return;
            }
            objectArray = vectorArray[i].toArray(new String[0]);
            jRSReportEngine.initRunEngineAbsolute((String[])objectArray);
        }
        Tools.logTrace(4, "init run main report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        long l2 = System.currentTimeMillis();
        this.applyNLS(stringArray, vectorArray);
        Tools.logTrace(4, "init run sub reports ELAPSED: " + (System.currentTimeMillis() - l2) + " [ms]");
        this.equals(stringArray, vectorArray);
        objectArray = this.rptSetCenter.getAllSubRptSetEngines(stringArray, vectorArray);
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                ReportSetCenter reportSetCenter = ((JRptSetEngine)objectArray[i]).getReportSetCenter();
                reportSetCenter.getRptSetEngine().closeAllGroupDatas();
                reportSetCenter.closeAllRawDatas();
                reportSetCenter.refreshAllRecSecurities(this.getEngineEnv());
                ((JSubRptSetEngine)objectArray[i]).initAllRawDataQuery();
            }
        }
        Tools.logTrace(4, "init run whole report set ELAPSED: " + (System.currentTimeMillis() - l) + " [ms]");
        Tools.logTrace(6, "end of JRptSetEngine.initRunEngineAbsolute()");
    }

    public void importParamValues(boolean bl, String[] stringArray, Vector[] vectorArray) throws JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.importParamValues()..., forceInit: " + bl + " rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        if (this.cancelRawDataQuery != null && (bl || !this.deepDupWithName)) {
            this.cancelRawDataQuery.initParamBuff(stringArray, vectorArray);
            this.cancelRawDataQuery.importParamValues(stringArray, vectorArray);
            this.deepDupWithName = true;
        }
        Tools.logTrace(6, "End of JRptSetEngine.importParamValues().");
    }

    public void prepareRunningEnv(String[] stringArray, Vector[] vectorArray) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.prepareRunningEnv()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        this.prepareRunningEnv(null, stringArray, vectorArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.prepareRunningEnv().");
        }
    }

    public void prepareRunningEnv(ParamDesc[] paramDescArray, String[] stringArray, Vector[] vectorArray) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.prepareRunningEnv()..., pds: " + Tools.toString(paramDescArray) + " rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        this.LOCAL_LANGUAGE(4);
        if (this.cancelRawDataQuery == null) {
            return;
        }
        this.cancelRawDataQuery.initParamBuff(paramDescArray, stringArray, vectorArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "init param buff, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        this.cancelRawDataQuery.importParamValues();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "import param values values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        if (!this.isRsd()) {
            this.cancelRawDataQuery.genValidValues(this.getParamValues(), this.getParamFile(), this.getParamValueDescs());
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "gen valid values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            }
        }
        this.cancelRawDataQuery.setValidValues();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "set valid values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "prepareRunningEnv, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.prepareRunningEnv().");
        }
    }

    public void prepareParamBuff(Hashtable hashtable) throws JRScheduleException {
        if (this.cancelRawDataQuery == null) {
            return;
        }
        this.cancelRawDataQuery.prepareParamBuff(hashtable);
    }

    public void notifyChangedParameter(String[] stringArray) {
        if (this.cancelRawDataQuery == null) {
            return;
        }
    }

    public void setLimitedRecNum(int n) {
        if (this.getEngineEnv() != null) {
            this.getEngineEnv().setLimitedRecordNumber(n);
        }
    }

    public int getLimitedRecNum() {
        return this.getEngineEnv().getLimitedRecordNumber();
    }

    public String[] getUsedDataSetNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.rptSetCenter.getAllDataSetName();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
            ++n;
        }
        return vector.toArray(new String[0]);
    }

    public String[] getAvailableDrillMappingName(String string, JetRptObject jetRptObject) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "getAvailableDrillMappingName..., rptName: " + string + " o: " + jetRptObject);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        JetRptDataSet jetRptDataSet = (JetRptDataSet)dataContainerLogic.getUsedDataSet(dataContainerLogic.getDataContainer(jetRptObject, true));
        if (jetRptDataSet == null) {
            Tools.logTrace(6, "data set is null.");
            return null;
        }
        if (jetRptObject instanceof JetRptCTHdDBField) {
            stringArray2 = this.getAllAvailableGroupFieldName(jetRptDataSet);
            stringArray = this.addRptViewNames((JetRptCTHdDBField)jetRptObject, stringArray2);
        } else {
            JetRptObject jetRptObject2 = jetRptObject;
            while (!(jetRptObject2 == null || jetRptObject2 instanceof JetRptGroupPanel || jetRptObject2 instanceof JetRptDetailPanel || jetRptObject2 instanceof JetRptTableDetail)) {
                if ((jetRptObject2 = (JetRptObject)((Object)jetRptObject2.getParent())) instanceof JetRptReport || !(jetRptObject2 instanceof JetRptGroupPanel)) continue;
                stringArray2 = this.getAllAvailableGroupFieldName(jetRptDataSet);
                stringArray = this.addElement((JetRptGroupPanel)jetRptObject2, stringArray2);
                break;
            }
        }
        return stringArray;
    }

    private String[] addElement(JetRptGroupPanel jetRptGroupPanel, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        String string = jetRptGroupPanel.groupBy.isChangeByOther() ? jetRptGroupPanel.groupBy.getChangeByObjectName() : ((JetColumnName)jetRptGroupPanel.groupBy).get();
        Vector vector2 = this.addIndexOfParentIndex(jetRptGroupPanel, new Vector());
        Vector vector3 = this.addRefreshListener(jetRptGroupPanel);
        if (vector2.size() == 0 || !vector2.contains(string) || vector2.contains(string) && vector3.contains(string)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.compareTo(stringArray[i]) == 0) continue;
                vector.addElement(stringArray[i]);
            }
        }
        return vector.toArray(new String[0]);
    }

    private Vector addIndexOfParentIndex(JetRptGroupPanel jetRptGroupPanel, Vector vector) {
        Vector vector2 = jetRptGroupPanel.getChildren();
        JetObject jetObject = null;
        SimpleComponentLogic simpleComponentLogic = ObjectLogicFactory.getSimpleComponentLogic();
        for (int i = 0; i < vector2.size(); ++i) {
            jetObject = (JetObject)vector2.elementAt(i);
            if (jetObject instanceof IDataContainer) {
                Vector vector3 = this.addParameterValue((IDataContainer)((Object)jetObject));
                for (int j = 0; j < vector3.size(); ++j) {
                    String string = simpleComponentLogic.getGroupByFld((JetRptDBField)vector3.elementAt(j), this.getUniverse());
                    if (string == null || string.trim().length() == 0) continue;
                    vector.add(string.toUpperCase());
                }
                continue;
            }
            if (!(jetObject instanceof JetRptGroupPanel)) continue;
            vector = this.addIndexOfParentIndex((JetRptGroupPanel)jetObject, vector);
        }
        return vector;
    }

    private Vector addParameterValue(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        Vector<JetRptObject> vector2 = new Vector<JetRptObject>();
        JetRptObject jetRptObject = null;
        for (int i = 0; i < vector.size(); ++i) {
            jetRptObject = (JetRptObject)vector.elementAt(i);
            if (!(jetRptObject instanceof JetRptDBField)) continue;
            vector2.add(jetRptObject);
        }
        return vector2;
    }

    private Vector addRefreshListener(JetRptGroupPanel jetRptGroupPanel) {
        Vector<String> vector = new Vector<String>();
        for (JetRptObject jetRptObject = (JetRptObject)((Object)jetRptGroupPanel.getParent()); jetRptObject != null; jetRptObject = (JetRptObject)((Object)jetRptObject.getParent())) {
            if (!(jetRptObject instanceof JetRptGroupPanel)) continue;
            String string = ((JetRptGroupPanel)jetRptObject).groupBy.isChangeByOther() ? ((JetRptGroupPanel)jetRptObject).groupBy.getChangeByObjectName() : ((JetColumnName)((JetRptGroupPanel)jetRptObject).groupBy).get();
            vector.add(string.toUpperCase());
        }
        return vector;
    }

    private String[] addRptViewNames(JetRptCTHdDBField jetRptCTHdDBField, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (jetRptCTHdDBField.columnName.get().compareTo(stringArray[i]) == 0) continue;
            vector.addElement(stringArray[i]);
        }
        return vector.toArray(new String[0]);
    }

    public String[] getDbFieldPass1FormulaNames(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDbFieldPass1FormulaNames()... dataSetName: " + string);
        }
        DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
        String[] stringArray = dataSetCenter.getDbFieldPass1FormulaNames();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDbFieldPass1FormulaNames(). return " + Tools.toString(stringArray));
        }
        return dataSetCenter.getDbFieldPass1FormulaNames();
    }

    public String[] getAllAvailableGroupFieldName(JetRptDataSet jetRptDataSet) {
        JetUUniverse jetUUniverse;
        if (jetRptDataSet == null || "virtual\u0007dataset\u0007name".equals(jetRptDataSet.getName())) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "dataSet: " + jetRptDataSet);
        }
        if ((jetUUniverse = this.getUniverse()) != null) {
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(jetRptDataSet.getQueryInfo(), jetUUniverse);
            if (keyDataSourceQuery == null) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "can't get data source query info for data set: " + jetRptDataSet.getName());
                }
            } else {
                String string = keyDataSourceQuery.getDataSourceName();
                String string2 = keyDataSourceQuery.getQueryName();
                Vector vector2 = this.getUniverse().getAvailableResourceEntitys(string, string2);
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector2.elementAt(i);
                    if (jetUResourceEntity instanceof JetUDBField) {
                        vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
                        continue;
                    }
                    if (jetUResourceEntity instanceof JetUFmlQueryField) {
                        vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
                        continue;
                    }
                    if (!(jetUResourceEntity instanceof JetUFormula) || !((JetUFormula)jetUResourceEntity).canSummary()) continue;
                    vector.addElement(jetUResourceEntity.getResourceNameInUpperCase());
                }
            }
        }
        return vector.toArray(new String[0]);
    }

    public JReportEngine getViewEngine(String string, String string2) {
        if (this.htReportEngine == null) {
            return null;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        if (jRSReportEngine == null) {
            return null;
        }
        return jRSReportEngine.getViewEngine(string2);
    }

    private void afterInit(String[] stringArray, Vector[] vectorArray) {
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            jReportEngine.getReportViewCenter().clearSubEngines();
        }
    }

    private void afterInitParameter(String[] stringArray, Vector[] vectorArray) throws JRScheduleException, EngingPreinitException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        Tools.logTrace(6, "JRptSetEngine.initSubReportEngine()...");
        this.afterInit(stringArray, vectorArray);
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        int n2 = vector.size();
        String string = this.getReportSet().getPath();
        for (n = 0; n < n2; ++n) {
            object6 = new SubReportCheckTool();
            object5 = (JReportEngine)vector.elementAt(n);
            object4 = new SubRptLoader(this, ((JEngineInitializer)object5).getReportCenter(), this.addAll);
            object3 = ((JEngineInitializer)object5).getReport();
            object2 = ((SubReportCheckTool)object6).checkSubReportLoop((JetRptReport)object3, string, (ITemplateLoader)object4, this.rptSetCenter.getExternalEnv(), ((JReportEngine)object5).getRptName());
            object = ((JEngineInitializer)object5).getReportViewCenter();
            ((ReportViewCenter)object).setSubRptInfo((SubReportInfo)object2);
            ((ReportViewCenter)object).setUpSubRptInfoMap();
        }
        for (n = 0; n < n2; ++n) {
            object6 = (JReportEngine)vector.elementAt(n);
            object5 = ((JEngineInitializer)object6).getReportViewCenter();
            object4 = ((JEngineInitializer)object6).getReport();
            object3 = ((ReportViewCenter)object5).getSubRptInfo();
            if (object3 == null) continue;
            object2 = new SubRptShareTool();
            ((SubRptShareTool)object2).initSubRptShareInfo((JetRptReport)object4, (ReportViewCenter)object5);
            ((ReportViewCenter)object5).clearSubRptInfoMap();
        }
        for (n = 0; n < n2; ++n) {
            object6 = (JReportEngine)vector.elementAt(n);
            object5 = ((JEngineInitializer)object6).getReportViewCenter();
            object4 = ((ReportViewCenter)object5).getSubRptInfo();
            if (object4 == null) continue;
            object3 = new PreOrderIterator((ITreeNode)object4);
            if (((ITreeIterator)object3).hasNext()) {
                ((ITreeIterator)object3).next();
            }
            while (((ITreeIterator)object3).hasNext()) {
                object2 = (SubReportInfo)((ITreeIterator)object3).next();
                object = (SubReportInfo)((SubReportInfo)object2).getParent();
                if (((SubReportInfo)object2).isShared()) {
                    ((ReportViewCenter)object5).initSubReportEngine(this, (SubReportInfo)object2, (JReportEngine)object6, true);
                    continue;
                }
                if (((SubReportInfo)object).isRoot()) {
                    ((ReportViewCenter)object5).initSubReportEngine(this, (SubReportInfo)object2, (JReportEngine)object6, false);
                    continue;
                }
                JSubReportEngine jSubReportEngine = ((SubReportInfo)object).getSubRptViewEngine();
                ReportViewCenter reportViewCenter = jSubReportEngine.getReportViewCenter();
                reportViewCenter.initSubReportEngine(this, (SubReportInfo)object2, (JReportEngine)object6, false);
            }
        }
        for (n = 0; n < n2; ++n) {
            object6 = (JReportEngine)vector.elementAt(n);
            object5 = ((JEngineInitializer)object6).getReportViewCenter();
            ((ReportViewCenter)object5).setUpSubRptShareMap();
        }
        for (n = 0; n < n2; ++n) {
            object6 = (JReportEngine)vector.elementAt(n);
            object5 = ((JEngineInitializer)object6).getReportViewCenter();
            object4 = ((ReportViewCenter)object5).getAllSubRptSetEngine();
            for (int i = 0; i < ((JSubRptSetEngine[])object4).length; ++i) {
                object4[i].asyncronizedSetPriority(this.getPriority());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String[] stringArray, Vector[] vectorArray) throws JRScheduleException, EngingPreinitException {
        Object object;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.initSubReportEngine()..., rptName: " + Tools.toString(stringArray) + " vRptViews: " + Tools.toString(vectorArray));
        }
        Object object2 = object = this.isDhtmlInteract() ? null : this.getPriorityLocker();
        if (object == null) {
            this.afterInitParameter(stringArray, vectorArray);
        } else {
            Object object3 = object;
            synchronized (object3) {
                this.afterInitParameter(stringArray, vectorArray);
            }
        }
        this.createViewEngine.clear();
        Tools.logTrace(6, "End of JRptSetEngine.initSubReportEngine().");
    }

    private void applyNLS(String[] stringArray, Vector[] vectorArray) {
        Tools.logTrace(6, "initRunSubReportEngine ...");
        Vector vector = this.getReportViewEngines(stringArray, vectorArray);
        ArrayList<JSubRptSetEngine> arrayList = new ArrayList<JSubRptSetEngine>(4);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            SubReportInfo subReportInfo = jReportEngine.getReportViewCenter().getSubRptInfo();
            if (subReportInfo == null) continue;
            PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
            if (((ITreeIterator)preOrderIterator).hasNext()) {
                ((ITreeIterator)preOrderIterator).next();
            }
            while (((ITreeIterator)preOrderIterator).hasNext()) {
                SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                JSubReportEngine jSubReportEngine = subReportInfo2.getSubRptViewEngine();
                JSubRptSetEngine jSubRptSetEngine = subReportInfo2.getSubRptSetEngine();
                if (!arrayList.contains(jSubRptSetEngine)) {
                    arrayList.add(jSubRptSetEngine);
                }
                jSubReportEngine.initRun();
                jSubReportEngine.getReportViewCenter().refreshDataSet();
            }
        }
    }

    public JReportEngine getDetailReportViewEngine() {
        if (this.addParameterValue != 2) {
            JRLog.error(1, "Inhibitory invoke, engine type does not match., error code: ENGINE_00006");
            return null;
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty() || this.htReportEngine.size() != 1) {
            if (JRLog.isError(1)) {
                JRLog.error(1, "report engine does not exist.");
            }
            return null;
        }
        Enumeration enumeration = this.htReportEngine.keys();
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(enumeration.nextElement());
        String string = jRSReportEngine.getReport().getCurViewName();
        return jRSReportEngine.getViewEngine(string);
    }

    public boolean prepareParamValues(Hashtable hashtable) throws JRScheduleException {
        return this.cancelRawDataQuery.prepareParamValues(hashtable);
    }

    Map getReportInfo(JetRptReportSet jetRptReportSet) {
        HashMap hashMap = new HashMap();
        String[] stringArray = jetRptReportSet.getAllReportsName();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            String[] stringArray2 = jetRptReport.getAllViewName();
            Vector<String> vector = new Vector<String>();
            vector.addAll(Arrays.asList(stringArray2));
            hashMap.put(stringArray[i], vector);
        }
        return hashMap;
    }

    Vector getDataSetInfo(JetRptReportSet jetRptReportSet) {
        Vector<String> vector = new Vector<String>();
        DataSet[] dataSetArray = jetRptReportSet.getAllDataSet();
        for (int i = 0; dataSetArray != null && i < dataSetArray.length; ++i) {
            vector.addElement(dataSetArray[i].getName());
        }
        return vector;
    }

    Map getResultSet(Vector vector) throws JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.getResultSet()...");
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        String[] stringArray = vector == null ? new String[]{} : vector.toArray(new String[vector.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            ResultSet resultSet;
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
            if (dataSetCenter.needRefresh()) {
                this.runDataSet(stringArray[i], false);
                if (dataSetCenter.needRefresh()) continue;
            }
            int n = dataSetCenter.getRawDataId();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "get result set, dataSetName: " + stringArray[i] + " query id: " + n);
            }
            try {
                resultSet = this.getDataService().getDataResult(n);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220005, (Object[])new String[]{stringArray[i]}, (Throwable)dSException);
            }
            catch (JRStopEngineException jRStopEngineException) {
                throw new JRScheduleException(220005, (Object[])new String[]{stringArray[i]}, (Throwable)jRStopEngineException);
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ResultSet: " + resultSet);
            }
            hashMap.put(stringArray[i], resultSet);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getResultSet(), return: " + hashMap);
        }
        return hashMap;
    }

    Map getBindInfo(Vector vector) throws JRScheduleException {
        HashMap<String, String[][]> hashMap = new HashMap<String, String[][]>();
        String[] stringArray = vector == null ? new String[]{} : vector.toArray(new String[vector.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            String[][] stringArray2;
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
            if (dataSetCenter.needRefresh()) continue;
            int n = dataSetCenter.getRawDataId();
            try {
                stringArray2 = this.getDataService().getBindInfo(n);
            }
            catch (DSException dSException) {
                throw new JRScheduleException(220006, (Object[])new String[]{stringArray[i]}, (Throwable)dSException);
            }
            hashMap.put(stringArray[i], stringArray2);
        }
        return hashMap;
    }

    private int applyNLSorDynamicStyle(RSDInfo rSDInfo) {
        ArrayList<JSubRptSetEngine> arrayList = new ArrayList<JSubRptSetEngine>();
        Vector vector = this.getAllReportViewEngines();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SubReportInfo subReportInfo;
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            SubReportInfo subReportInfo2 = jReportEngine.getReportViewCenter().getSubRptInfo();
            if (subReportInfo2 == null) continue;
            PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo2);
            if (((ITreeIterator)preOrderIterator).hasNext()) {
                subReportInfo = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                subReportInfo.setRSDIndex(0);
            }
            while (((ITreeIterator)preOrderIterator).hasNext()) {
                subReportInfo = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                SubReportInfo subReportInfo3 = (SubReportInfo)subReportInfo.getParent();
                JetRptSubReport jetRptSubReport = subReportInfo.getSubReport();
                JSubRptSetEngine jSubRptSetEngine = subReportInfo.getSubRptSetEngine();
                int n2 = jSubRptSetEngine.getRSDKey();
                subReportInfo.setRSDIndex(n2);
                String string = jetRptSubReport.report.get();
                String string2 = jetRptSubReport.view.get();
                rSDInfo.addIndexOfParentIndex(subReportInfo3.getRsdIndex(), string, string2, jetRptSubReport.getInstName(), n2);
                if (subReportInfo.isShared()) {
                    if (arrayList.contains(jSubRptSetEngine)) continue;
                    arrayList.add(jSubRptSetEngine);
                    continue;
                }
                arrayList.add(jSubRptSetEngine);
            }
        }
        return arrayList.size() + 1;
    }

    public int genRSDKey() {
        return this.denyAllColumns++;
    }

    public void setRSDKey(int n) {
        this.denyAllColumns = n;
    }

    public int getRSDKey() {
        return this.denyAllColumns;
    }

    private void applyStyleNls(RSDInfo rSDInfo) {
        String[] stringArray = this.getReportNames();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                RuntimeInfoAgent runtimeInfoAgent = this.getRuntimeInfo(stringArray[i], stringArray2[j]);
                rSDInfo.setHighPrecision(stringArray[i], stringArray2[j], runtimeInfoAgent.isHighPrecision());
            }
        }
    }

    private void asList(RSDInfo rSDInfo) {
        String[] stringArray = this.getReportNames();
        for (int i = 0; i < stringArray.length; ++i) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
            String[] stringArray2 = jRSReportEngine.getViewNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(stringArray2[j]);
                JCommunicator jCommunicator = jReportEngine.getCommunicator();
                Vector vector = jCommunicator.getListOfPicName();
                rSDInfo.setPictureNames(stringArray[i], stringArray2[j], vector);
            }
        }
    }

    private void asyncronizedSetPriority(RSDInfo rSDInfo, int n, ReportSetCenter reportSetCenter) throws JRScheduleException {
        ReportCenter[] reportCenterArray = reportSetCenter.getReportCenters();
        if (reportCenterArray != null) {
            for (int i = 0; i < reportCenterArray.length; ++i) {
                String[] stringArray;
                ReportViewCenter[] reportViewCenterArray = reportCenterArray[i].getReportViewCenters();
                ReportViewCenter reportViewCenter = reportViewCenterArray[0];
                JReportEngine jReportEngine = reportViewCenter.getReportViewEngine();
                String string = reportCenterArray[i].getRptName();
                Vector vector = reportViewCenter.getAllParamFormInstNames();
                String[] stringArray2 = stringArray = vector == null ? null : vector.toArray(new String[0]);
                if (stringArray == null || stringArray.length == 0) continue;
                rSDInfo.setParameterFormNames(n, string, stringArray);
                for (int j = 0; j < stringArray.length; ++j) {
                    Hashtable hashtable;
                    ParameterInteractiveModeEnv parameterInteractiveModeEnv = jReportEngine.getParameterFormEnv(stringArray[j]);
                    if (parameterInteractiveModeEnv == null || (hashtable = parameterInteractiveModeEnv.getAllParameters(false)) == null || hashtable.isEmpty()) continue;
                    for (String string2 : hashtable.keySet()) {
                        ParamDesc paramDesc = (ParamDesc)hashtable.get(string2);
                        String[] stringArray3 = this.beforeRun(paramDesc);
                        if (stringArray3 == null) continue;
                        rSDInfo.setParameterFormValue(n, string, stringArray[j], string2, stringArray3);
                    }
                }
            }
        }
    }

    private void backupDataStatus(RSDInfo rSDInfo, int n, ReportSetCenter reportSetCenter) throws JRScheduleException {
        ReportCenter[] reportCenterArray = reportSetCenter.getReportCenters();
        if (reportCenterArray != null) {
            BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
            for (int i = 0; i < reportCenterArray.length; ++i) {
                ReportViewCenter[] reportViewCenterArray = reportCenterArray[i].getReportViewCenters();
                ReportViewCenter reportViewCenter = reportViewCenterArray[0];
                JReportEngine jReportEngine = reportViewCenter.getReportViewEngine();
                String string = reportCenterArray[i].getRptName();
                JetRptReport jetRptReport = reportCenterArray[i].getReport();
                Vector vector = new Vector();
                basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReport, JetRptFilterControl.class, vector);
                if (vector.isEmpty()) continue;
                String[] stringArray = new String[vector.size()];
                for (int j = 0; j < vector.size(); ++j) {
                    JetRptFilterControl jetRptFilterControl = (JetRptFilterControl)vector.get(j);
                    stringArray[j] = jetRptFilterControl.getInstName();
                    IOnScreenFilterValue iOnScreenFilterValue = reportViewCenter.getOnScreenFilterValue(jetRptFilterControl);
                    if (iOnScreenFilterValue == null) continue;
                    rSDInfo.setFilterControlValue(n, string, stringArray[j], iOnScreenFilterValue);
                }
                rSDInfo.setFilterControlNames(n, string, stringArray);
            }
        }
    }

    private String[] beforeRun(ParamDesc paramDesc) {
        String[] stringArray;
        DbValue dbValue = paramDesc.getValue();
        DbValue[] dbValueArray = null;
        if (dbValue instanceof fArray) {
            stringArray = (String[])dbValue;
            dbValueArray = stringArray.value;
        } else {
            dbValueArray = new DbValue[]{dbValue};
        }
        if (dbValueArray == null || dbValueArray.length == 0) {
            return null;
        }
        stringArray = new String[dbValueArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = dbValueArray[i].toString();
        }
        return stringArray;
    }

    Map getCLSInfo(JetRptReportSet jetRptReportSet) throws JRScheduleException {
        Object object;
        JetRptObject jetRptObject;
        int n;
        String[] stringArray;
        HashMap<String, CLSInfo> hashMap = new HashMap<String, CLSInfo>();
        Vector vector = this.getDataSetInfo(jetRptReportSet);
        String[] stringArray2 = stringArray = vector == null ? null : vector.toArray(new String[vector.size()]);
        if (stringArray == null || stringArray.length == 0) {
            return hashMap;
        }
        String[] stringArray3 = jetRptReportSet.getAllReportsName();
        Vector[] vectorArray = new Vector[stringArray3.length];
        for (n = 0; n < stringArray3.length; ++n) {
            jetRptObject = jetRptReportSet.getReport(stringArray3[n]);
            object = jetRptObject.getAllViewName();
            vectorArray[n] = new Vector();
            vectorArray[n].addAll(Arrays.asList(object));
        }
        for (n = 0; n < stringArray.length; ++n) {
            jetRptObject = this.getReportSet().getDataSet(stringArray[n]);
            object = null;
            try {
                object = new JColumnSecurityContainer(this.getUniverse(), (DataSet)((Object)jetRptObject), this, stringArray3, vectorArray);
            }
            catch (JSecurityEntryException jSecurityEntryException) {
                throw new JRScheduleException(220073, (Object[])new String[]{stringArray[n]}, (Throwable)jSecurityEntryException);
            }
            catch (JPermissionLinkException jPermissionLinkException) {
                throw new JRScheduleException(220073, (Object[])new String[]{stringArray[n]}, (Throwable)jPermissionLinkException);
            }
            catch (JPolicyLinkException jPolicyLinkException) {
                throw new JRScheduleException(220073, (Object[])new String[]{stringArray[n]}, (Throwable)jPolicyLinkException);
            }
            catch (NotOwnerException notOwnerException) {
                throw new JRScheduleException(220073, (Object[])new String[]{stringArray[n]}, (Throwable)notOwnerException);
            }
            catch (ACLException aCLException) {
                throw new JRScheduleException(220073, (Object[])new String[]{stringArray[n]}, (Throwable)aCLException);
            }
            CLSInfo cLSInfo = new CLSInfo(((JColumnSecurityContainer)object).doCLS(), ((JColumnSecurityContainer)object).denyAllColumns(), ((JColumnSecurityContainer)object).getDeniedColumns());
            hashMap.put(stringArray[n], cLSInfo);
        }
        return hashMap;
    }

    private void buildCubeQuery(RSDInfo rSDInfo) throws DSException {
        String[] stringArray;
        int n;
        String[] stringArray2 = this.getReportNames();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray2.length; ++i) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray2[i]);
            Object object = jRSReportEngine.getViewNames();
            for (n = 0; n < ((String[])object).length; ++n) {
                stringArray = jRSReportEngine.getReportCenter().getReportViewCenter(object[n]);
                JSubReportEngine[] jSubReportEngineArray = stringArray.getAllSubReportEngine();
                for (int j = -1; j < jSubReportEngineArray.length; ++j) {
                    JReportEngine jReportEngine = null;
                    if (j == -1) {
                        if (i > 0 || n > 0) continue;
                        jReportEngine = stringArray.getReportViewEngine();
                    } else {
                        jReportEngine = jSubReportEngineArray[j];
                    }
                    JRptSetEngine jRptSetEngine = jReportEngine.getRptSetEngine();
                    ReportSetCenter reportSetCenter = jRptSetEngine.getReportSetCenter();
                    String[] stringArray3 = reportSetCenter.getDataSetNames();
                    for (int k = 0; k < stringArray3.length; ++k) {
                        DataSetCenter dataSetCenter = reportSetCenter.getDataSetCenter(stringArray3[k]);
                        JetRptDataSet jetRptDataSet = dataSetCenter.getDataSet();
                        this.canApplyNLS(arrayList, jetRptDataSet);
                    }
                }
            }
        }
        int[] nArray = new int[]{1, 2};
        for (Object object : arrayList) {
            for (n = 0; n < nArray.length; ++n) {
                stringArray = this.canSummary((KeyBusinessLogic)object, nArray[n]);
                if (stringArray == null || stringArray.length <= 0) continue;
                rSDInfo.setDeniedBLNames(nArray[n], ((KeyBusinessLogic)object).getDataSourceName(), ((KeyBusinessLogic)object).getUBVName(), stringArray);
            }
        }
    }

    private void buildRawQuery(RSDInfo rSDInfo) {
        rSDInfo.setNLSManager(this.getNLSManager());
    }

    private void canApplyNLS(List list, DataSet dataSet) {
        String string;
        String string2;
        KeyBusinessLogic keyBusinessLogic;
        int n = dataSet.getDataResourceType();
        if (n == 2 && !list.contains(keyBusinessLogic = new KeyBusinessLogic(string2 = dataSet.getDataSourceName(), string = dataSet.getBlName()))) {
            list.add(keyBusinessLogic);
        }
    }

    private String[] canSummary(KeyBusinessLogic keyBusinessLogic, int n) throws DSException {
        JetUUniverse jetUUniverse;
        UnifiedBusinessView unifiedBusinessView;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getDeniedBLColumns()..., kbl: " + keyBusinessLogic + " permission: " + n);
        }
        if ((unifiedBusinessView = (jetUUniverse = this.getUniverse()).getBV(keyBusinessLogic.getDataSourceName(), keyBusinessLogic.getUBVName())) == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "can't find bl, return array of zero length.");
            }
            return new String[0];
        }
        Vector vector = ResourceTool.getBusinessLogicResorceNames(jetUUniverse, keyBusinessLogic.getDataSourceName(), keyBusinessLogic.getUBVName());
        if (vector == null || vector.isEmpty()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "can't find any bl qualified names from bl, return array of zero length.");
            }
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        AccessController accessController = this.getAccessController(unifiedBusinessView);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            try {
                if (accessController.hasPermission(string, n)) continue;
                arrayList.add(string);
                continue;
            }
            catch (InvalidResource invalidResource) {
                Tools.logTrace(4, invalidResource);
                arrayList.add(string);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getDeniedBLColumns(), return: " + arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public RSDInfo genRSDInfo() throws JRScheduleException {
        return this.genRSDInfo(null, false);
    }

    public RSDInfo genRSDInfo(Map map, boolean bl) throws JRScheduleException {
        Cloneable cloneable;
        Tools.logTrace(6, "JRptSetEngine.genRSDInfo()...");
        if (this.disable != null) {
            cloneable = new HashMap();
            for (String string : this.disable.keySet()) {
                ((HashMap)cloneable).put(string, ((Vector)this.disable.get(string)).clone());
            }
            if (this.isOnDemandReport()) {
                this.closeUnusedRawQuery((Map)((Object)cloneable));
            }
            this.waitRunFinished((Map)((Object)cloneable));
        }
        if (map != null) {
            map.put(new Integer(0), this);
        }
        cloneable = new Vector();
        RSDInfo rSDInfo = bl ? new RSDBurstingInfo() : new RSDInfo();
        int n = this.applyNLSorDynamicStyle(rSDInfo);
        rSDInfo.setRptSetSize(n);
        rSDInfo.setRptSetName(this.rptSetCenter.getRptSetName(), 0);
        JetRptReportSet jetRptReportSet = this.shrinkRSDRptSet();
        this.putBorwseSortFilter(jetRptReportSet);
        this.putFilterControlValues(jetRptReportSet);
        rSDInfo.setRptSet(jetRptReportSet, 0);
        rSDInfo.setReportInfo(this.getReportInfo(jetRptReportSet), 0);
        Vector vector = this.getDataSetInfo(jetRptReportSet);
        rSDInfo.setDataSetInfo(vector, 0);
        rSDInfo.setResultSet(this.getResultSet(vector), 0);
        rSDInfo.setBindInfo(this.getBindInfo(vector), 0);
        rSDInfo.setUserId(this.getUserName());
        this.applyStyleNls(rSDInfo);
        rSDInfo.setCLSInfo(this.getCLSInfo(jetRptReportSet), 0);
        try {
            this.buildCubeQuery(rSDInfo);
        }
        catch (DSException dSException) {
            JRScheduleException jRScheduleException = new JRScheduleException(dSException);
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, jRScheduleException);
            }
            throw jRScheduleException;
        }
        this.asList(rSDInfo);
        this.asyncronizedSetPriority(rSDInfo, 0, this.rptSetCenter);
        this.backupDataStatus(rSDInfo, 0, this.rptSetCenter);
        rSDInfo.setLocale(this.getLocale());
        this.buildRawQuery(rSDInfo);
        Vector vector2 = this.getAllReportViewEngines();
        int n2 = vector2.size();
        ArrayList<JetRptReportSet> arrayList = new ArrayList<JetRptReportSet>();
        arrayList.add(this.getReportSet());
        for (int i = 0; i < n2; ++i) {
            SubReportInfo subReportInfo;
            block15: {
                JReportEngine jReportEngine = (JReportEngine)vector2.elementAt(i);
                SubReportCheckTool subReportCheckTool = new SubReportCheckTool();
                String string = jReportEngine.getRptName();
                SubRptEngineLoader subRptEngineLoader = new SubRptEngineLoader(jReportEngine);
                JetRptReport jetRptReport = jReportEngine.getReport();
                subReportInfo = null;
                try {
                    subReportInfo = subReportCheckTool.checkSubReportLoop(this.getReportSet().getReport(string), null, subRptEngineLoader, this.rptSetCenter.getExternalEnv(), string);
                }
                catch (NullPointerException nullPointerException) {
                    if (!JRLog.isTrace(4)) break block15;
                    JRLog.trace(4, nullPointerException);
                }
            }
            if (subReportInfo == null) continue;
            PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
            if (((ITreeIterator)preOrderIterator).hasNext()) {
                ((ITreeIterator)preOrderIterator).next();
            }
            while (((ITreeIterator)preOrderIterator).hasNext()) {
                Vector vector3;
                JetRptReportSet jetRptReportSet2;
                int n3;
                ReportSetCenter reportSetCenter;
                boolean bl2;
                SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                String string = subReportInfo2.getSubRptSetName();
                JSubRptSetEngine jSubRptSetEngine = subReportInfo2.getSubRptSetEngine();
                JetRptReportSet jetRptReportSet3 = jSubRptSetEngine.getReportSet();
                if (!arrayList.contains(jetRptReportSet3)) {
                    arrayList.add(jetRptReportSet3);
                }
                if (bl2 = jSubRptSetEngine.isShared()) {
                    if (((Vector)cloneable).contains(string)) continue;
                    ((Vector)cloneable).addElement(string);
                    reportSetCenter = jSubRptSetEngine.getReportSetCenter();
                    n3 = jSubRptSetEngine.getRSDKey();
                    rSDInfo.setRptSetName(reportSetCenter.getRptSetName(), n3);
                    jetRptReportSet2 = jSubRptSetEngine.shrinkRSDRptSet();
                    jSubRptSetEngine.putBorwseSortFilter(jetRptReportSet2);
                    this.putFilterControlValues(jetRptReportSet2);
                    rSDInfo.setRptSet(jetRptReportSet2, n3);
                    rSDInfo.setReportInfo(jSubRptSetEngine.getReportInfo(jetRptReportSet2), n3);
                    vector3 = jSubRptSetEngine.getDataSetInfo(jetRptReportSet2);
                    rSDInfo.setDataSetInfo(vector3, n3);
                    rSDInfo.setResultSet(jSubRptSetEngine.getResultSet(vector3), n3);
                    rSDInfo.setBindInfo(jSubRptSetEngine.getBindInfo(vector3), n3);
                    rSDInfo.setCLSInfo(jSubRptSetEngine.getCLSInfo(jetRptReportSet2), n3);
                    this.asyncronizedSetPriority(rSDInfo, n3, reportSetCenter);
                    this.backupDataStatus(rSDInfo, n3, reportSetCenter);
                    if (map == null) continue;
                    map.put(new Integer(n3), jSubRptSetEngine);
                    continue;
                }
                reportSetCenter = jSubRptSetEngine.getReportSetCenter();
                n3 = jSubRptSetEngine.getRSDKey();
                rSDInfo.setRptSetName(reportSetCenter.getRptSetName(), n3);
                jetRptReportSet2 = jSubRptSetEngine.shrinkRSDRptSet();
                jSubRptSetEngine.putBorwseSortFilter(jetRptReportSet2);
                this.putFilterControlValues(jetRptReportSet2);
                rSDInfo.setRptSet(jetRptReportSet2, n3);
                rSDInfo.setReportInfo(jSubRptSetEngine.getReportInfo(jetRptReportSet2), n3);
                vector3 = jSubRptSetEngine.getDataSetInfo(jetRptReportSet2);
                rSDInfo.setDataSetInfo(vector3, n3);
                rSDInfo.setResultSet(jSubRptSetEngine.getResultSet(vector3), n3);
                rSDInfo.setBindInfo(jSubRptSetEngine.getBindInfo(vector3), n3);
                rSDInfo.setCLSInfo(jSubRptSetEngine.getCLSInfo(jetRptReportSet2), n3);
                this.asyncronizedSetPriority(rSDInfo, n3, reportSetCenter);
                this.backupDataStatus(rSDInfo, n3, reportSetCenter);
                if (map == null) continue;
                map.put(new Integer(n3), jSubRptSetEngine);
            }
        }
        rSDInfo.setUniverse(this.cancelRawDataQueries());
        rSDInfo.setNLSApplyParam(this.getNLSParam());
        rSDInfo.setParameter(this.checkSubReportLoop());
        Hashtable hashtable = this.cancelRawDataQuery(arrayList.toArray(new JetRptReportSet[0]));
        rSDInfo.setImgMappingTable(hashtable);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.genRSDInfo(), return: " + rSDInfo);
        }
        return rSDInfo;
    }

    private JetUUniverse cancelRawDataQueries() {
        JetUUniverse jetUUniverse;
        block4: {
            jetUUniverse = this.getUniverse();
            if (jetUUniverse != null) {
                String string = jetUUniverse.getFullFileName();
                jetUUniverse = (JetUUniverse)jetUUniverse.deepDupWithName();
                if (string != null) {
                    jetUUniverse.setFullFileName(new File(string));
                }
                try {
                    jetUUniverse.applyNLS(this.getLocale());
                }
                catch (IOException iOException) {
                    if (!JRLog.isTrace(4)) break block4;
                    JRLog.trace(4, iOException);
                }
            }
        }
        return jetUUniverse;
    }

    private Hashtable cancelRawDataQuery(JetRptReportSet[] jetRptReportSetArray) {
        Hashtable hashtable = new Hashtable();
        String string = this.rptSetCenter.getCatLevelResourcePath();
        File file = new File(string == null ? "" : string);
        for (int i = 0; i < jetRptReportSetArray.length; ++i) {
            Hashtable hashtable2 = JReportUtil.getImgMappingTable(jetRptReportSetArray[i], file, this.getEngineEnv().getResourceStore().getMemoryStore());
            if (hashtable2 == null) continue;
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    private void catchError(JetRptReportSet[] jetRptReportSetArray, Hashtable hashtable) {
        for (int i = 0; i < jetRptReportSetArray.length; ++i) {
            JReportUtil.setImgMappingtable(jetRptReportSetArray[i], hashtable);
        }
    }

    private Map checkSubReportLoop() {
        String[] stringArray;
        Object object;
        Hashtable hashtable;
        Object object2;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        if (this.cancelRawDataQuery != null && (object2 = this.getParameters()) != null && !((Vector)object2).isEmpty()) {
            hashtable = ((Vector)object2).iterator();
            while (hashtable.hasNext()) {
                ParamDesc paramDesc = (ParamDesc)hashtable.next();
                String string = paramDesc.getName().toUpperCase();
                if (!this.cancelRawDataQuery.isExtParameter(string)) continue;
                object = this.clearCubeId(paramDesc);
                stringArray = paramDesc.getDisplayValues(this.getLocale());
                if (object == null || ((String[])object).length <= 0) continue;
                hashMap.put(string, (String[])object);
            }
        }
        if ((object2 = this.getValidParamValues()) != null && !object2.isEmpty()) {
            hashtable = this.cancelRawDataQuery.getParamBuff();
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            for (String string : object2.keySet()) {
                if (hashMap.containsKey(string) || (stringArray = this.clear((ParameterValueDesc)(object = (ParameterValueDesc)object2.get(string)), (ParamDesc)hashtable.get(string))) == null) continue;
                hashMap.put(string, stringArray);
            }
        }
        return hashMap.isEmpty() ? null : hashMap;
    }

    private String[] clear(ParameterValueDesc parameterValueDesc, ParamDesc paramDesc) {
        UserInput[] userInputArray = parameterValueDesc.getUserInputValue();
        if (userInputArray == null) {
            return null;
        }
        String[] stringArray = new String[userInputArray.length];
        for (int i = 0; i < userInputArray.length; ++i) {
            if (userInputArray[i].isExpression()) {
                stringArray = this.clearCubeId(paramDesc);
                break;
            }
            stringArray[i] = userInputArray[i].getUserInput();
        }
        return stringArray;
    }

    private String[] clearCubeId(ParamDesc paramDesc) {
        String[] stringArray = null;
        if (paramDesc.isMultipleValue()) {
            if (paramDesc.isAllSelected()) {
                return new String[]{PARAM_ALL_VALUE};
            }
            return paramDesc.getMultiDisplayValue((fArray)paramDesc.getValue(), this.getLocale());
        }
        String string = paramDesc.getDisplayValue(paramDesc.getValue(), this.getLocale());
        if (string != null) {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    public RSDBurstingInfo genRSDBurstingInfo() throws JRScheduleException {
        Tools.logTrace(6, "JRptSetEngine.genRSDBurstingInfo()...");
        HashMap hashMap = new HashMap();
        RSDBurstingInfo rSDBurstingInfo = (RSDBurstingInfo)this.genRSDInfo(hashMap, true);
        try {
            rSDBurstingInfo.initPLS(hashMap);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException(220079, (Throwable)jRStopEngineException);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(220079, (Throwable)dSException);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.genRSDBurstingInfo(), return: " + rSDBurstingInfo);
        }
        return rSDBurstingInfo;
    }

    private List clearDataSetCenters(Group group, int n) {
        Group group2;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (n <= 0) {
            return arrayList;
        }
        for (int i = 0; i < n && !((group2 = group.fetchGroup()) instanceof GroupEnd); ++i) {
            DbValue dbValue = group2.getGroupName();
            arrayList.add(dbValue);
        }
        return arrayList;
    }

    public JavaFormula buildJavaFormula(String string) throws JRScheduleException {
        String string2;
        JavaFormula javaFormula = ReportTools.loadJavaFormula(string, this.getUniverse());
        Hashtable<String, DbValue> hashtable = null;
        Hashtable hashtable2 = this.getParamsBuffer();
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            hashtable = new Hashtable<String, DbValue>(hashtable2.size());
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement();
                ParamDesc paramDesc = (ParamDesc)hashtable2.get(string2);
                hashtable.put(string2, paramDesc.getValue());
            }
        }
        javaFormula.LOCAL_LANGUAGE(this.getLocale().getLanguage());
        javaFormula.setParameters(hashtable);
        javaFormula.getSecurityContext().set(this.getSecurityContext());
        string2 = this.getUserName();
        javaFormula.REPORT_NAME(this.getReportSet().getInstName());
        javaFormula.__sys__USERNAME().set(string2);
        return javaFormula;
    }

    public JetRptReport getSubReport(JetRptSubReport jetRptSubReport) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getSubReport()..., subReport: " + jetRptSubReport);
        }
        Object var2_2 = null;
        Vector vector = this.getAllReportViewEngines();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            SubReportInfo subReportInfo = jReportEngine.getReportViewCenter().getSubRptInfo();
            PreOrderIterator preOrderIterator = new PreOrderIterator(subReportInfo);
            if (((ITreeIterator)preOrderIterator).hasNext()) {
                ((ITreeIterator)preOrderIterator).next();
            }
            while (((ITreeIterator)preOrderIterator).hasNext()) {
                SubReportInfo subReportInfo2 = (SubReportInfo)((ITreeIterator)preOrderIterator).next();
                JSubReportEngine jSubReportEngine = subReportInfo2.getSubRptViewEngine();
                if (jetRptSubReport != subReportInfo2.getSubReport()) continue;
                return jSubReportEngine.getReportViewCenter().getReportView();
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Can't find sub report, subReport: " + jetRptSubReport);
        }
        return null;
    }

    public Vector getParameters(String string) {
        String[] stringArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getParameters()..., rptName: " + string);
        }
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        String[] stringArray3 = stringArray;
        Vector vector = this.getParameters(stringArray3);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getParameters()..., return: " + vector);
        }
        return vector;
    }

    public Vector getParameters(String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getParameters()..., rptNames: " + stringArray);
        }
        Vector vector = new Vector();
        List list = null;
        try {
            list = stringArray == null || stringArray.length == 0 ? this.getParameterManager().getReportParameters() : this.cancelRawDataQuery.getReportParameters(stringArray);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, jRScheduleException);
            }
            return vector;
        }
        if (list == null || list.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.getParameters()..., return blank.");
            return vector;
        }
        vector = new Vector(list);
        Tools.logTrace(6, "End of JRptSetEngine.getParameters()..., don't sort, return: " + vector);
        return vector;
    }

    public String[] getParametersInRpt(String string) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        Vector<Object> vector = new Vector<Object>();
        ReportCenter reportCenter = this.rptSetCenter.getReportCenter(string);
        JetUUniverse jetUUniverse = this.getUniverse();
        Vector vector2 = reportCenter.getBindedDataSet();
        for (int i = 0; i < vector2.size(); ++i) {
            String string2;
            block12: {
                stringArray = null;
                object3 = (DataSet)((Object)this.getReportSet().nameToObject((String)vector2.elementAt(i)));
                object2 = object3.getQueryInfo();
                object = ScheduleTools.getAvailableKeyDataSourceQuery((QueryInfo)object2, jetUUniverse);
                if (object != null) {
                    string2 = ((KeyDataSourceQuery)object).getDataSourceName();
                    String string3 = ((KeyDataSourceQuery)object).getQueryName();
                    try {
                        stringArray = this.rptSetCenter.getQueryParamsWithCache(jetUUniverse, string2, string3);
                        if (stringArray != null && stringArray.length > 0) {
                            for (int j = 0; j < stringArray.length; ++j) {
                                String string4 = stringArray[j];
                                if (vector.contains(string4)) continue;
                                vector.addElement(string4);
                            }
                        }
                    }
                    catch (JRScheduleException jRScheduleException) {
                        if (!JRLog.isTrace(4)) break block12;
                        JRLog.trace(4, jRScheduleException);
                    }
                }
            }
            string2 = object3.getName();
            try {
                stringArray = this.rptSetCenter.getDataSetParamsWithCache(string2);
                if (stringArray == null || stringArray.length <= 0) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string5 = stringArray[j];
                    if (vector.contains(string5)) continue;
                    vector.addElement(string5);
                }
                continue;
            }
            catch (JRScheduleException jRScheduleException) {
                if (!JRLog.isTrace(4)) continue;
                JRLog.trace(4, jRScheduleException);
            }
        }
        ReportViewCenter reportViewCenter = reportCenter.getReportViewCenter(reportCenter.getReport().getCurViewName());
        stringArray = reportViewCenter.getParameters();
        object3 = stringArray.keys();
        while (object3.hasMoreElements()) {
            object2 = ((String)object3.nextElement()).toUpperCase();
            if (vector.contains(object2)) continue;
            vector.addElement(object2);
        }
        object2 = this.getParamsBuffer();
        if (object2 != null) {
            object = new HashMap();
            for (int i = 0; i < vector.size(); ++i) {
                String string6 = (String)vector.get(i);
                ParamDesc paramDesc = (ParamDesc)((Hashtable)object2).get(string6);
                if (paramDesc == null) continue;
                this.clearEngine((Map)object, (Map)object2, paramDesc);
            }
            vector.clear();
            vector.addAll(((HashMap)object).keySet());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Vector getParameters() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getParamsBuffer();
        if (hashtable == null || hashtable.isEmpty()) {
            return vector;
        }
        vector.addAll(hashtable.values());
        return vector;
    }

    private void clearEngine(Map map, Map map2, ParamDesc paramDesc) {
        Serializable serializable;
        String string;
        String string2 = paramDesc.getName().toUpperCase();
        if (!map.containsKey(string2)) {
            map.put(string2, paramDesc);
        }
        if ((string = paramDesc.getBinding()) != null && !string.equals("") && !map.containsKey(string2 = string.toUpperCase()) && (serializable = (ParamDesc)map2.get(string2)) != null) {
            map.put(string2, serializable);
        }
        if ((serializable = paramDesc.getImportParams()) != null && !serializable.isEmpty()) {
            for (int i = 0; i < serializable.size(); ++i) {
                ParamDesc paramDesc2;
                string2 = ((String)serializable.elementAt(i)).toUpperCase();
                if (map.containsKey(string2) || (paramDesc2 = (ParamDesc)map2.get(string2)) == null) continue;
                this.clearEngine(map, map2, paramDesc2);
            }
        }
    }

    public Vector getParamNamesUsedInQuery(String string, String string2) {
        return this.getMainRptSetEngine().getReportSetCenter().getQueryInfo(this.getUniverse(), string, string2).getUsedParameter();
    }

    public ParamDesc[] getInteractParameters() {
        List list;
        block2: {
            list = null;
            try {
                list = this.getParameterManager().getReportParameters();
            }
            catch (JRScheduleException jRScheduleException) {
                if (!JRLog.isTrace(5)) break block2;
                JRLog.trace(5, jRScheduleException);
            }
        }
        return list == null || list.isEmpty() ? new ParamDesc[]{} : list.toArray(new ParamDesc[0]);
    }

    public ParamDesc[] getAllParameters(ParamDesc[] paramDescArray) {
        if (paramDescArray == null) {
            return null;
        }
        String[] stringArray = new String[paramDescArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = paramDescArray[i].getName().toUpperCase();
        }
        Vector vector = this.getParameterManager().getParameters(stringArray);
        return vector.toArray(new ParamDesc[vector.size()]);
    }

    public void clearEngine(String string) {
        if (this.htReportEngine != null && this.htReportEngine.containsKey(string)) {
            this.htReportEngine.remove(string);
        }
    }

    public boolean beforeRun(String[] stringArray, Vector[] vectorArray, EngineExecuter engineExecuter) throws Exception {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.beforeRun()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                if (jReportEngine == null) {
                    Tools.logTrace(6, "no report view engine for report: " + stringArray[i] + " and view: " + string);
                    continue;
                }
                if (jReportEngine.beforeRun(engineExecuter)) continue;
                Tools.logTrace(6, "failed to beforRun for report: " + stringArray[i] + " and view: " + string);
                bl = false;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.beforeRun(), return: " + bl);
        }
        return bl;
    }

    public boolean afterInitParameter(String[] stringArray, Vector[] vectorArray, EngineExecuter engineExecuter) throws Exception {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.afterInitParameter()..., rptNames: " + Tools.toString(stringArray) + " viewNames: " + Tools.toString(vectorArray));
        }
        if (stringArray == null || this.htReportEngine == null) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                if (jReportEngine == null) {
                    Tools.logTrace(6, "no report view engine for report: " + stringArray[i] + " and view: " + string);
                    continue;
                }
                if (jReportEngine.afterInitParameter(engineExecuter)) continue;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "failed to afterInitParameter for report: " + stringArray[i] + " and view: " + string);
                }
                bl = false;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.afterInitParameter(), return: " + bl);
        }
        return bl;
    }

    public void clearMem(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this + " rptName: " + string);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            Tools.logTrace(6, "no any report engine in report set engine.");
            Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        Vector vector = jRSReportEngine.getRptViewNames();
        if (vector != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                this.clearSubEngines(string, string2);
            }
        }
        this.htReportEngine.remove(string);
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    private void clearRawDataId(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.resetParameter()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engine in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.resetParameter().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.resetParameter(string, string2);
        }
        Tools.logTrace(6, "End of JRptSetEngine.resetParameter().");
    }

    private void reset(String string, String string2) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.reset()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engine in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.reset().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.reset(string, string2);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "reset report set engine, cost time: " + (System.currentTimeMillis() - l) + " [ms]");
            JRLog.trace(6, "End of JRptSetEngine.reset().");
        }
    }

    private void clearSubEngines(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this + " rptName: " + string + " viewName: " + string2);
        }
        if (this.htReportEngine == null || !this.htReportEngine.containsKey(string)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "no any report engine in report set engine.");
                JRLog.trace(6, "End of JRptSetEngine.clearMem().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (this.rptSetCenter != null) {
            this.rptSetCenter.clearMem(string, string2);
        }
        jRSReportEngine.clearMem(string2);
        this.clearRunningReports(string, string2);
        this.clone(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    public synchronized void clearMem() {
        Object object;
        Enumeration enumeration;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.clearMem()..., rptSetEngine: " + this);
        }
        if (this.htReportEngine != null) {
            enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                object = (JRSReportEngine)this.htReportEngine.get(enumeration.nextElement());
                ((JRSReportEngine)object).clearMem();
            }
            if (this.htReportEngine != null) {
                this.htReportEngine.clear();
                this.htReportEngine = null;
            }
        }
        if (this.rptSetCenter != null) {
            this.rptSetCenter.clearMem();
            this.rptSetCenter = null;
        }
        if (this.asList != null) {
            this.asList = null;
        }
        if (this.beforeRun != null) {
            this.beforeRun.clear();
            this.beforeRun = null;
        }
        if (this.buildCubeQuery != null) {
            enumeration = this.buildCubeQuery.keys();
            while (enumeration.hasMoreElements()) {
                object = (Hashtable)this.buildCubeQuery.get(enumeration.nextElement());
                ((Hashtable)object).clear();
            }
            if (this.buildCubeQuery != null) {
                this.buildCubeQuery.clear();
                this.buildCubeQuery = null;
            }
        }
        if (!(this instanceof JSubRptSetEngine) && this.cancelRawDataQuery != null) {
            this.cancelRawDataQuery.clearMem();
        }
        this.parentReportEngine = null;
        this.clearDataSetCenters = null;
        this.clearMem = null;
        if (this.rsdInforForRptSet != null) {
            this.rsdInforForRptSet.clearMem();
            this.rsdInforForRptSet = null;
            if (!(this instanceof JSubRptSetEngine) && this.addAll != null) {
                this.addAll.clearMem();
                this.addAll = null;
            }
        }
        this.dataService = null;
        if (this.createViewEngine != null) {
            this.createViewEngine.clear();
        }
        Tools.logTrace(6, "End of JRptSetEngine.clearMem().");
    }

    @Override
    public void ThreadException(Thread thread, Throwable throwable) {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        for (int i = 0; i < this.getListeners().size(); ++i) {
            ThreadErrorListener threadErrorListener = (ThreadErrorListener)this.getListeners().elementAt(i);
            threadErrorListener.ThreadException(thread, throwable);
        }
    }

    @Override
    public void started() {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        for (int i = 0; i < this.getListeners().size(); ++i) {
            EngineListener engineListener = (EngineListener)this.getListeners().elementAt(i);
            engineListener.started();
        }
    }

    @Override
    public void finished() {
        if (this.getListeners() == null || this.getListeners().isEmpty()) {
            return;
        }
        for (int i = 0; i < this.getListeners().size(); ++i) {
            EngineListener engineListener = (EngineListener)this.getListeners().elementAt(i);
            engineListener.finished();
        }
    }

    public void displayStructure() {
        if (JRLog.isTrace(6)) {
            Object object;
            String string;
            JRLog.trace(6, "report set name: " + this.rptSetCenter.getRptSetName());
            JRLog.trace(6, "==>rptSetEngine: " + this + " rptSetCenter: " + this.rptSetCenter);
            Enumeration enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = (JRSReportEngine)this.htReportEngine.get(string);
                JRLog.trace(6, "  ==>rptName: " + string + " rptEngine: " + object + " reportCenter: " + this.rptSetCenter.getReportCenter(string));
            }
            JRLog.trace(6, "");
            JRLog.trace(6, "==>rptSetCenter: " + this.rptSetCenter + " rptCenters: ");
            enumeration = this.htReportEngine.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = ((JRSReportEngine)this.htReportEngine.get(string)).getReportCenter();
                JRLog.trace(6, "  ==>rptName: " + string + " reportCenter: " + object + " rptSetCenter: " + ((ReportCenter)object).getRptSetCenter() + " rptViewCenters: " + ((ReportCenter)object).getReportViewCenters());
                ReportViewCenter[] reportViewCenterArray = ((ReportCenter)object).getReportViewCenters();
                for (int i = 0; i < reportViewCenterArray.length; ++i) {
                    JRLog.trace(6, "    viewName: " + reportViewCenterArray[i].getViewName() + " viewCenter: " + reportViewCenterArray[i] + " rptCenter: " + reportViewCenterArray[i].getRptCenter());
                }
            }
        }
    }

    public void preinitMainEngine() throws EngingPreinitException {
        Tools.logTrace(6, "JRptSetEngine.preinitMainEngine()...");
        this.preinitMainEngine(false);
    }

    public void preinitEngine() throws EngingPreinitException, JRScheduleException {
        this.preinitEngine(false);
    }

    public void preinitEngine(String[] stringArray, Vector[] vectorArray) throws EngingPreinitException, JRScheduleException {
        this.preinitEngine(stringArray, vectorArray, false);
    }

    public void initRunEngine() {
        this.initRunEngine(false);
    }

    public void initRunEngine(String[] stringArray, Vector[] vectorArray) {
        this.initRunEngine(stringArray, vectorArray, false);
    }

    public Thread[] getAllThreads() {
        Object object;
        Tools.logTrace(6, "JRptSetEngine.getAllThreads()...");
        Vector<Thread> vector = new Vector<Thread>();
        if (this.htReportEngine != null && !this.htReportEngine.isEmpty()) {
            Tools.logTrace(6, "get threads from JReportEngine...");
            object = this.htReportEngine.keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(e);
                Thread[] threadArray = jRSReportEngine.getAllThreads();
                if (threadArray == null || threadArray.length == 0) continue;
                for (int i = 0; i < threadArray.length; ++i) {
                    Tools.logTrace(6, "thread: " + threadArray[i]);
                    vector.addElement(threadArray[i]);
                }
            }
            Tools.logTrace(6, "End of get threads from JReportEngine.");
        }
        object = vector.toArray(new Thread[vector.size()]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getAllThreads()..., return: " + Tools.toString(object));
        }
        return object;
    }

    private void clearSubRptInfoMap(Hashtable hashtable, String string, String string2) {
        if (hashtable != null && hashtable.containsKey(string)) {
            Vector vector = (Vector)hashtable.get(string);
            vector.remove(string2);
            if (vector.isEmpty()) {
                hashtable.remove(string);
            }
        }
    }

    void clearRunningReports(String string, String string2) {
        this.clearSubRptInfoMap(this.disable, string, string2);
    }

    private void clone(String string, String string2) {
        this.clearSubRptInfoMap(this.displayStructure, string, string2);
    }

    private void closeAllGroups() {
        if (this.disable != null && !this.disable.isEmpty()) {
            Enumeration enumeration = this.disable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)this.disable.get(string);
                vector.clear();
            }
            this.disable.clear();
        }
    }

    private void closeAllRawDatas() {
        this.closeAllSubReportDatas(this.displayStructure);
    }

    private void closeAllSubReportDatas(Hashtable hashtable) {
        if (hashtable != null && !hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(string);
                vector.clear();
            }
            hashtable.clear();
        }
    }

    private void closeQuery(String[] stringArray, Vector[] vectorArray) {
        if (this.disable == null) {
            this.disable = new Hashtable();
        }
        this.closeRawDatas(this.disable, stringArray, vectorArray);
    }

    private void closeRawData(String[] stringArray, Vector[] vectorArray) {
        if (this.displayStructure == null) {
            this.displayStructure = new Hashtable();
        }
        this.closeRawDatas(this.displayStructure, stringArray, vectorArray);
    }

    private void closeRawDatas(Hashtable hashtable, String[] stringArray, Vector[] vectorArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], vectorArray[i].clone());
        }
    }

    public boolean isRunning() {
        Tools.logTrace(6, "JRptSetEngine.isRunning()...");
        if (this.disable == null || this.disable.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.isRunning(), no any report engines, return false.");
            return false;
        }
        if (!this.cvIExpresstion) {
            Tools.logTrace(6, "End of JRptSetEngine.isRunning(), no any report engines is running, return false.");
            return false;
        }
        Enumeration enumeration = this.disable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this.disable.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                JCommunicator jCommunicator = jReportEngine.getCommunicator();
                if (jCommunicator == null) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "End of JRptSetEngine.isRunning(), communicator of [" + string + "," + string2 + "] is still not generated, return true.");
                    }
                    return true;
                }
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "rptName: " + string + " viewName: " + string2 + " communicator: " + jCommunicator);
                }
                if (!jCommunicator.isEngineFinished()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "End of JRptSetEngine.isRunning(), report [" + string + "," + string2 + "] is running, return true.");
                    }
                    return true;
                }
                Tools.logTrace(6, "engine is finished.");
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.isRunning(), return false.");
        return false;
    }

    private boolean closeRelatedDataInstance(String string, String string2) {
        if (this.disable == null) {
            return false;
        }
        Vector vector = (Vector)this.disable.get(string);
        return vector != null && vector.contains(string2);
    }

    public boolean isStopping() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.isStopping()...");
            JRLog.trace(6, "End of JRptSetEngine.isStopping(), return: " + this.clone);
        }
        return this.clone;
    }

    public void setParamValues(Map map) throws JRScheduleException {
        String[] stringArray = this.cancelRawDataQuery.setParamValues(map);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        String[] stringArray2 = this.rptSetCenter.getDataSetNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray3 = this.rptSetCenter.getUsedParamNamesInDataSet(stringArray2[i]);
            if (stringArray3 == null || stringArray3.length == 0) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray3.length; ++j) {
                if (!vector.contains(stringArray3)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.rptSetCenter.getDataSetCenter(stringArray2[i]).closeRawData(this.getDataService());
        }
    }

    public void waitRunFinished(Map map) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.waitRunFinished()..., mReports: " + map);
        }
        if (map == null || map.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.waitRunFinished().");
            return;
        }
        for (String string : map.keySet()) {
            Vector vector = (Vector)map.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "wait finished on view engine, viewName: " + string2 + " engine: " + jReportEngine);
                }
                jReportEngine.waitFinished();
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.waitRunFinished().");
    }

    private void closeUnusedRawQuery(Map map) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getOndemandLastPage()..., mReports: " + map);
        }
        if (map == null || map.isEmpty()) {
            Tools.logTrace(6, "End of JRptSetEngine.getOndemandLastPage().");
            return;
        }
        for (String string : map.keySet()) {
            Vector vector = (Vector)map.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                JCommunicator jCommunicator;
                block10: {
                    String string2 = (String)vector.elementAt(i);
                    JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "get ondemand last page, viewName: " + string2 + " engine: " + jReportEngine);
                    }
                    jCommunicator = null;
                    try {
                        while (this.closeRelatedDataInstance(string, string2) && (jCommunicator = jReportEngine.getCommunicator()) == null) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!JRLog.isError(2)) break block10;
                        JRLog.error(2, interruptedException);
                    }
                }
                if (jCommunicator == null) continue;
                try {
                    jCommunicator.getOnDemandLastPage();
                    continue;
                }
                catch (JRStopEngineException jRStopEngineException) {
                    Tools.logTrace(5, jRStopEngineException);
                }
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.getOndemandLastPage().");
    }

    protected void initAllRawDataQueries() throws JRScheduleException {
    }

    public void processEngineForClosedRpt(String string) {
        this.clearEngine(string);
        this.getReportSetCenter().removeRptCenter(string);
        if (this.disable != null) {
            this.disable.remove(string);
        }
        if (this.displayStructure != null) {
            this.displayStructure.remove(string);
        }
    }

    public boolean hasReportViewEngine(String string, String string2) {
        return this.getReportViewEngine(string, string2) != null;
    }

    JetRptReportSet shrinkRSDRptSet() throws JRScheduleException {
        int n;
        Object object2;
        Object object3;
        JetRptReportSet jetRptReportSet = this.getReportSet();
        if (this.htReportEngine == null) {
            return jetRptReportSet;
        }
        JetRptReportSet jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
        jetRptReportSet2.createNamingSystem();
        jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
        NLSLogic nLSLogic = ObjectLogicFactory.getNLSLogic();
        String[] stringArray = jetRptReportSet2.getAllReportsName();
        int n2 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n2; ++i) {
            JetRptReport jetRptReport = jetRptReportSet2.getReport(stringArray[i]);
            if (!this.htReportEngine.containsKey(stringArray[i])) {
                jetRptReportSet2.removeReport(stringArray[i]);
                continue;
            }
            object3 = jetRptReportSet2.getAllRptViewNames(stringArray[i]);
            object2 = (JRSReportEngine)this.htReportEngine.get(stringArray[i]);
            int n3 = object3 == null ? 0 : ((Object)object3).length;
            for (int j = 0; j < n3; ++j) {
                if (((JRSReportEngine)object2).getViewEngine((String)object3[j]) != null) continue;
                JetRptView object5 = jetRptReport.getViewObject((String)object3[j]);
                jetRptReport.remove(object5);
            }
            try {
                nLSLogic.doFullProcessNLS(this.getUniverse(), jetRptReport, this.getNLSParam(), this.getEngineEnv().getResourceStore());
                continue;
            }
            catch (IOException iOException) {
                throw new JRScheduleException(iOException);
            }
        }
        this.containsKey(jetRptReportSet2);
        ArrayList<String> arrayList = new ArrayList<String>();
        stringArray = jetRptReportSet2.getAllReportsName();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Object object4;
            object3 = jetRptReportSet2.getReport(stringArray[i]);
            object2 = ((JetRptReport)object3).getCurViewName();
            ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray[i], (String)object2);
            if (!this.isRsd() && !this.isBurstingRsd()) {
                object4 = ObjectLogicFactory.getViewLogic();
                object4.getReportViewForNLSOrDynamicStyle(this.getUniverse(), (JetRptReport)object3, reportViewCenter.getStyleGroup(), this.getNLSParam(), false);
                JetRptView jetRptView = ((JetRptReport)object3).getViewObject(reportViewCenter.getViewName());
                if (jetRptView.getChildren() != null) {
                    jetRptView.getChildren().clear();
                }
            }
            object4 = reportViewCenter.getUsedDataSet();
            ((Vector)object4).removeAll(arrayList);
            arrayList.addAll((Collection<String>)object4);
        }
        DataSet[] dataSetArray = jetRptReportSet2.getAllDataSet();
        object3 = new Hashtable();
        for (DataSet dataSet : dataSetArray) {
            object3.put(dataSet.getName(), dataSet);
        }
        object2 = new Vector();
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            DataSet dataSet;
            String string;
            String string2 = (String)arrayList.get(n);
            DataSet dataSet2 = (DataSet)object3.get(string2);
            if (!(dataSet2 instanceof JetRptExtendsDataSet) || arrayList.contains(string = (dataSet = ((JetRptExtendsDataSet)dataSet2).getBasedDataSet()).getName())) continue;
            arrayList.add(string);
        }
        for (n = 0; dataSetArray != null && n < dataSetArray.length; ++n) {
            String string = dataSetArray[n].getName();
            if (!arrayList.contains(string)) {
                jetRptReportSet2.remomeDataSet((JetRptDataSet)dataSetArray[n]);
                continue;
            }
            try {
                dataSetArray[n].setPreIExpression(null);
                dataSetArray[n].setIExpression(null);
                continue;
            }
            catch (ConditionException conditionException) {
                throw new JRScheduleException(220074, (Object[])new String[]{string}, (Throwable)conditionException);
            }
        }
        return jetRptReportSet2;
    }

    void putBorwseSortFilter(JetRptReportSet jetRptReportSet) {
        if (!this.isDHTML() || !this.isDhtmlInteract()) {
            return;
        }
        Vector vector = this.getAllReportViewEngines();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            JetObject jetObject;
            int n;
            String[] stringArray;
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            HashMap hashMap = reportViewCenter.getBrowseFilters();
            if (hashMap != null) {
                stringArray = hashMap.keySet().toArray(new String[0]);
                for (n = 0; n < stringArray.length; ++n) {
                    JetFilterExpression jetFilterExpression;
                    block7: {
                        jetObject = jetRptReportSet.nameToObject(stringArray[n]);
                        if (jetObject == null || !(jetObject instanceof IDataContainer)) continue;
                        object = reportViewCenter.getBrowseFilter(stringArray[n]);
                        CvIExpression cvIExpression = new CvIExpression();
                        jetFilterExpression = null;
                        try {
                            jetFilterExpression = cvIExpression.cvIExpresstion((IExpression)object);
                        }
                        catch (ConditionException conditionException) {
                            if (!JRLog.isError(2)) break block7;
                            JRLog.error(2, 220019, new Object[]{object}, (Throwable)conditionException);
                        }
                    }
                    ((JetFilterExpLogic)((Object)ObjectLogicFactory.getDataContainerLogic())).setBrowserJetFilterExpression((IDataContainer)((Object)jetObject), jetFilterExpression, 4098);
                }
            }
            if ((hashMap = reportViewCenter.getRptSortContainers()) == null) continue;
            stringArray = hashMap.keySet().toArray(new String[0]);
            for (n = 0; n < stringArray.length; ++n) {
                jetObject = jetRptReportSet.nameToObject(stringArray[n]);
                if (!ReportTools.supportBrowseAction(jetObject)) continue;
                object = reportViewCenter.getBrowseSortContainer(stringArray[n]);
                this.columnName((IDataContainer)((Object)jetObject), (JetRptSortContainer)object);
            }
        }
    }

    void putFilterControlValues(JetRptReportSet jetRptReportSet) {
        if (!this.isDHTML() || !this.isDhtmlInteract()) {
            return;
        }
        Vector vector = this.getAllReportViewEngines();
        for (int i = 0; i < vector.size(); ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            JetRptReport jetRptReport = reportViewCenter.getRptCenter().getReport();
            BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
            ArrayList arrayList = new ArrayList();
            basicComponentLogic.getAllPosterityComponentByClass((JetObject)jetRptReport, JetRptFilterControl.class, arrayList);
            for (JetRptFilterControl jetRptFilterControl : arrayList) {
                IOnScreenFilterValue iOnScreenFilterValue = reportViewCenter.getOnScreenFilterValue(jetRptFilterControl);
                if (iOnScreenFilterValue == null) continue;
                List list = iOnScreenFilterValue.getValues();
                ArrayList<String> arrayList2 = null;
                if (list != null) {
                    arrayList2 = new ArrayList<String>();
                    for (String[] stringArray : list) {
                        arrayList2.add(stringArray[0]);
                    }
                }
                jetRptFilterControl.setCurrentSelections(iOnScreenFilterValue.isSelectAll(), arrayList2);
                jetRptFilterControl.setConditionReversed(iOnScreenFilterValue.isReverse());
            }
        }
    }

    private JetRptSortContainer columnName(IDataContainer iDataContainer, JetRptSortContainer jetRptSortContainer) {
        JetRptSortContainer jetRptSortContainer2 = this.compareTo(iDataContainer);
        if (jetRptSortContainer2 != null) {
            this.contains(iDataContainer);
        }
        if (jetRptSortContainer == null) {
            return null;
        }
        return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().add(iDataContainer, jetRptSortContainer);
    }

    private JetRptSortContainer compareTo(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptSortContainer)) continue;
            return (JetRptSortContainer)e;
        }
        return null;
    }

    private JetRptSortContainer contains(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptSortContainer)) continue;
            return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)e);
        }
        return null;
    }

    private void containsKey(JetRptReportSet jetRptReportSet) {
        String string = jetRptReportSet.getCurReportId();
        String[] stringArray = jetRptReportSet.getAllReportsName();
        int n = stringArray == null ? 0 : stringArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            if (jetRptReport == null) continue;
            if (string.equals(stringArray[i])) {
                bl = true;
            }
            jetRptReport.setStatus(0);
            String[] stringArray2 = jetRptReportSet.getAllRptViewNames(stringArray[i]);
            int n2 = stringArray2 == null ? 0 : stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[j]);
                jetRptView.setStatus(0);
            }
        }
        if (!bl) {
            jetRptReportSet.setCurReportId(stringArray[0]);
        }
    }

    public void runReport(String[] stringArray, Vector[] vectorArray, int n, Map map) throws JRScheduleException {
        Object object;
        int n2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.runReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " level: " + n + " mParams: " + map);
            JRLog.trace(6, "parameter buffer: " + this.getParamsBuffer());
        }
        String[] stringArray2 = this.doRequestRunReport(stringArray, vectorArray);
        Vector<String> vector = new Vector<String>();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "used data set: " + Tools.toString(stringArray2));
        }
        for (n2 = 0; stringArray2 != null && n2 < stringArray2.length; ++n2) {
            object = this.rptSetCenter.getDataSetCenter(stringArray2[n2]);
            if (object == null || ((DataSetCenter)object).hasBackupedDataStatus()) continue;
            ((DataSetCenter)object).backupDataStatus(this.rptSetCenter);
            if (vector.contains(stringArray2[n2])) continue;
            vector.addElement(stringArray2[n2]);
        }
        switch (n) {
            case 0: {
                if (!this.disable(stringArray, vectorArray)) break;
                this.runReport(stringArray, vectorArray, 5, map);
                return;
            }
            case 1: {
                if (!this.disable(stringArray, vectorArray)) break;
                this.runReport(stringArray, vectorArray, 5, map);
                return;
            }
            case 2: 
            case 6: {
                this.displayStructure(stringArray, vectorArray);
                for (n2 = 0; stringArray2 != null && n2 < stringArray2.length; ++n2) {
                    object = this.rptSetCenter.getDataSetCenter(stringArray2[n2]);
                    ((DataSetCenter)object).backupDataStatus(this.rptSetCenter);
                }
                this.doFullProcessNLS(stringArray2);
                this.closeRawDatas(stringArray2);
                this.runReport(stringArray, vectorArray);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "after run report with reload_datasource level.");
                    JRLog.trace(6, "End of JRptSetEngine.runReport().");
                }
                return;
            }
            case 4: {
                throw new JRScheduleException(0, (Object[])new String[]{String.valueOf(n)}, null);
            }
            case 5: {
                this.displayStructure(stringArray, vectorArray);
                break;
            }
            default: {
                throw new JRScheduleException(0, (Object[])new String[]{String.valueOf(n)}, null);
            }
        }
        Tools.logTrace(6, "check data sets...");
        for (n2 = 0; stringArray2 != null && n2 < stringArray2.length; ++n2) {
            object = this.rptSetCenter.getDataSetCenter(stringArray2[n2]);
            if (object == null || ((DataSetCenter)object).equalsForRawData(this.rptSetCenter)) continue;
            ((DataSetCenter)object).backupDataStatus(this.rptSetCenter);
            if (vector.contains(stringArray2[n2])) continue;
            vector.addElement(stringArray2[n2]);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "modified data sets: " + vector);
        }
        if (!vector.isEmpty()) {
            String[] stringArray3 = vector.toArray(new String[0]);
            this.doFullProcessNLS(stringArray3);
            this.closeRawDatas(stringArray3);
            if (n == 0) {
                this.createJDenyListProvider(stringArray3, stringArray, vectorArray);
            }
        } else if (n == 0) {
            ReportViewNames reportViewNames = this.createViewEngine(stringArray, vectorArray);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "runReportViewNames: " + reportViewNames);
            }
            object = this.currentThread(stringArray, vectorArray, reportViewNames);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "resetRptViewNames: " + object);
            }
            if (!((ReportViewNames)object).isEmpty()) {
                this.deepDupWithName((ReportViewNames)object);
            }
            if (!reportViewNames.isEmpty()) {
                this.runReport(reportViewNames.getRptNames(), reportViewNames.getViewNames(), 1, map);
                return;
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "paint level and not use params, no equals dataDriver and record security, don't need apply nls, so don't need re-run");
                JRLog.trace(6, "End of JRptSetEngine.runReport().");
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            Vector vector2 = vectorArray[i];
            for (int j = 0; j < vector2.size(); ++j) {
                String string = (String)vector2.elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine((String)object, string);
                JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
                for (int k = 0; k < jSubReportEngineArray.length; ++k) {
                    ReportViewCenter reportViewCenter = jSubReportEngineArray[k].getReportViewCenter();
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "apply nls for sub report: rptSetName: " + reportViewCenter.getRptCenter().getRptSetCenter().getRptSetName() + " rptName: " + reportViewCenter.getRptCenter().getRptName() + " viewName: " + reportViewCenter.getViewName());
                    }
                    JSubReportEngine jSubReportEngine = jSubReportEngineArray[k];
                    jSubReportEngine.getReportViewCenter().applyNLSorDynamicStyle();
                }
            }
        }
        this.runReport(stringArray, vectorArray);
        Tools.logTrace(6, "End of JRptSetEngine.runReport().");
    }

    private void createAccessController(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return;
        }
        String[] stringArray = vector.toArray(new String[vector.size()]);
        this.doFullProcessNLS(stringArray);
        this.closeRawDatas(stringArray);
    }

    private void createJDenyListProvider(String[] stringArray, String[] stringArray2, Vector[] vectorArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
            dataSetCenter.clear();
            dataSetCenter.refresh(this.getUniverse());
            for (int j = 0; j < stringArray2.length; ++j) {
                ReportCenter reportCenter = this.rptSetCenter.getReportCenter(stringArray2[j]);
                for (int k = 0; k < vectorArray[j].size(); ++k) {
                    String string = (String)vectorArray[j].elementAt(k);
                    ReportViewCenter reportViewCenter = reportCenter.getReportViewCenter(string);
                    dataSetCenter.refresh(reportViewCenter);
                }
            }
        }
    }

    private void createNamingSystem(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
            if (dataSetCenter == null) continue;
            dataSetCenter.clear();
            dataSetCenter.refresh(this.getUniverse());
        }
    }

    private ReportViewNames createViewEngine(String[] stringArray, Vector[] vectorArray) {
        ReportViewNames reportViewNames = new ReportViewNames();
        ViewLogic viewLogic = ObjectLogicFactory.getViewLogic();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                JReportEngine jReportEngine;
                String string = (String)vectorArray[i].elementAt(j);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get report view names to run, rptName: " + stringArray[i] + " viewName: " + string);
                }
                if (!this.currentTimeMillis(jReportEngine = this.getReportViewEngine(stringArray[i], string), viewLogic)) continue;
                reportViewNames.addRptViewNames(stringArray[i], string);
            }
        }
        return reportViewNames;
    }

    private ReportViewNames currentThread(String[] stringArray, Vector[] vectorArray, ReportViewNames reportViewNames) {
        ReportViewNames reportViewNames2 = new ReportViewNames();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get report view names to reset flag, rptName: " + stringArray[i] + " viewName: " + string + " exceptRptViewNames: " + reportViewNames);
                }
                if (reportViewNames.contains(stringArray[i], string) || !this.dataService(jReportEngine)) continue;
                reportViewNames2.addRptViewNames(stringArray[i], string);
            }
        }
        return reportViewNames2;
    }

    private boolean currentTimeMillis(JReportEngine jReportEngine, ViewLogic viewLogic) {
        boolean bl;
        Object object;
        Tools.logTrace(6, "JRptSetEngine.needReRun()...");
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), view engine is null, return true.");
            return true;
        }
        JCommunicator jCommunicator = jReportEngine.getCommunicator();
        if (jCommunicator == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), communicator is null, return true.");
            return true;
        }
        if (!(!(jCommunicator instanceof JCommunicator) || ((JCommunicator)(object = jCommunicator)).isSuccess() && ((JCommunicator)object).isEngineFinished())) {
            Tools.logTrace(6, "End of JRptSetEngine.needRun(), communicator is not sucess or not finished, return true.");
            return true;
        }
        Tools.logTrace(6, "check nls.");
        if (viewLogic.canApplyNLS(jReportEngine.getReportViewCenter().getOriReportView(), this.getNLSParam())) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), need apply nls, return true.");
            return true;
        }
        Tools.logTrace(6, "check style group.");
        object = jReportEngine.getReportViewCenter();
        ReportCenter reportCenter = ((ReportViewCenter)object).getRptCenter();
        if (viewLogic.isCanApplyDynamicStyle(jReportEngine.getRptSetEngine().getUniverse(), ((ReportViewCenter)object).getOriReportView(), this.cvIExpresstion(reportCenter.getRptName(), ((ReportViewCenter)object).getViewName()))) {
            Tools.logTrace(6, "End of JRptSetEngine.needReRun(), need apply style group, return true.");
            return true;
        }
        boolean bl2 = bl = ((ReportViewCenter)object).getReportView() != ((ReportViewCenter)object).getOriReportView();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.needReRun(), return " + bl);
        }
        return bl;
    }

    private String cvIExpresstion(String string, String string2) {
        return this.getEngineEnv() != null ? null : this.getEngineEnv().getStyleGroup(string);
    }

    private boolean dataService(JReportEngine jReportEngine) {
        Tools.logTrace(6, "JRptSetEngine.needResetFlag()...");
        if (jReportEngine == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), view engine is null, return false.");
            return false;
        }
        JCommunicator jCommunicator = jReportEngine.getCommunicator();
        if (jCommunicator == null) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), communicator is null, return false.");
            return false;
        }
        if (jCommunicator instanceof JCommunicator) {
            Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), is JCommunicator, return true.");
            return true;
        }
        Tools.logTrace(6, "End of JRptSetEngine.needResetFlag(), return false.");
        return false;
    }

    private void deepDupWithName(ReportViewNames reportViewNames) {
        if (reportViewNames.isEmpty()) {
            return;
        }
        String[] stringArray = reportViewNames.getRptNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = reportViewNames.getViewNames(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], stringArray2[j]);
                JCommunicator jCommunicator = jReportEngine.getCommunicator();
                jCommunicator.setBeStopping(false);
            }
        }
    }

    private int denyAllColumns(String[] stringArray, String string) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean disable(String[] stringArray, Vector[] vectorArray) {
        Object object;
        Object object2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.hasUsedParameters()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                object2 = (String)vectorArray[i].elementAt(j);
                ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray[i], (String)object2);
                object = reportViewCenter.getMappingFields(1);
                boolean bl2 = bl = object != null && !((Vector)object).isEmpty();
                if (bl) break;
            }
            if (bl) break;
        }
        if (bl) {
            return bl;
        }
        String[] stringArray2 = this.doRequestRunReport(stringArray, vectorArray);
        if (stringArray2 != null) {
            MemoryCacheQueryParameterProvider memoryCacheQueryParameterProvider = new MemoryCacheQueryParameterProvider(new QueryParameterProvider(this.getEngineEnv(), false));
            object2 = this.getUniverse();
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3;
                block11: {
                    if ("virtual\u0007dataset\u0007name".equals(stringArray2[i])) continue;
                    object = this.rptSetCenter.getRptSet().getDataSet(stringArray2[i]);
                    DataSetLogic dataSetLogic = ObjectLogicFactory.getDataSetLogic();
                    List list = ResourceTool.getDataSetParamNames(this.getUniverse(), (DataSet)object);
                    if (list != null && !list.isEmpty()) {
                        bl = true;
                        break;
                    }
                    KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(((JetRptDataSet)object).getQueryInfo(), (JetUUniverse)object2);
                    if (keyDataSourceQuery == null) {
                        if (!JRLog.isTrace(4)) continue;
                        JRLog.trace(4, "can't get data source query info for data set: " + ((JetRptDataSet)object).getName());
                        continue;
                    }
                    String string = keyDataSourceQuery.getDataSourceName();
                    String string2 = keyDataSourceQuery.getQueryName();
                    stringArray3 = null;
                    try {
                        stringArray3 = memoryCacheQueryParameterProvider.getQueryParamNames(this.getUniverse(), string, string2);
                    }
                    catch (DSException dSException) {
                        if (!JRLog.isTrace(4)) break block11;
                        JRLog.trace(4, dSException);
                    }
                }
                if (stringArray3 == null || stringArray3.length <= 0) continue;
                bl = true;
                break;
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.hasUsedParameters(). return: " + bl);
        }
        return bl;
    }

    private void displayStructure(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.closeGroupDatas()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                jReportEngine.closeAllGroups();
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeGroupDatas().");
    }

    public void closeAllGroupDatas() {
        Tools.logTrace(6, "JRptSetEngine.closeAllGroupDatas()...");
        Vector vector = this.getAllReportViewEngines();
        if (vector != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
                jReportEngine.closeAllGroups();
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeAllGroupDatas().");
    }

    public void closeRawDatas(String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.closeRawDatas()..., dataSetNames: " + Tools.toString(stringArray) + " rptSetEngine: " + this);
        }
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
                dataSetCenter.closeRawData(this.getDataService());
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.closeRawDatas().");
    }

    private String[] doCLS(String[] stringArray, Vector[] vectorArray) {
        String[] stringArray2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getUsedDataSetNamesByOtherReports()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        if (this.htReportEngine != null && !this.htReportEngine.isEmpty()) {
            stringArray2 = new ArrayList(Arrays.asList(stringArray));
            ArrayList<Vector> arrayList4 = new ArrayList<Vector>(Arrays.asList(vectorArray));
            Iterator iterator = this.htReportEngine.keySet().iterator();
            while (iterator.hasNext()) {
                int n;
                Vector<String> vector = new Vector<String>();
                String string = (String)iterator.next();
                JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
                String[] stringArray3 = jRSReportEngine.getViewNames();
                int n2 = stringArray2.indexOf(string);
                if (n2 == -1) {
                    for (n = 0; n < stringArray3.length; ++n) {
                        vector.addElement(stringArray3[n]);
                    }
                } else {
                    for (n = 0; n < stringArray3.length; ++n) {
                        String string2 = stringArray3[n];
                        if (arrayList4.get(n2).contains(string2)) continue;
                        vector.addElement(stringArray3[n]);
                    }
                }
                if (vector.isEmpty()) continue;
                arrayList2.add(string);
                arrayList3.add(vector);
            }
        }
        stringArray2 = this.doRequestRunReport(arrayList2.toArray(new String[0]), arrayList3.toArray(new Vector[0]));
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getUsedDataSetNamesByOtherReports(). return: " + Tools.toString(stringArray2));
        }
        return stringArray2;
    }

    private String[] doConvertDataContainerInReport(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getExclusiveDataSetNames()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " rptSetEngine: " + this);
        }
        String[] stringArray2 = this.doRequestRunReport(stringArray, vectorArray);
        String[] stringArray3 = this.doCLS(stringArray, vectorArray);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray3));
        arrayList.removeAll(arrayList2);
        String[] stringArray4 = arrayList.toArray(new String[0]);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getExclusiveDataSetNames(), return: " + Tools.toString(stringArray4));
        }
        return stringArray4;
    }

    public void cancelRawDataQueries(String[] stringArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.cancelRawDataQueries()..., dataSetNames: " + Tools.toString(stringArray) + " rptSetEngine: " + this);
        }
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
                dataSetCenter.cancelRawDataQuery(this.getDataService());
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.cancelRawDataQueries().");
    }

    public void closeUnusedRawQueries() {
        if (this instanceof JSubRptSetEngine || this.getType() != 1) {
            String string = "engine: " + this + " type: " + this.getType();
            throw new UnsupportedOperationException(string);
        }
        String[] stringArray = this.rptSetCenter.getDataSetNames();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i]);
                dataSetCenter.closeUnusedRawQuery(this.getDataService());
            }
        }
    }

    private void doFullProcessNLS(String[] stringArray) {
        String[] stringArray2;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
        String[] stringArray3 = this.getReportNames();
        if (stringArray3 != null && stringArray3.length > 0) {
            for (int i = 0; i < stringArray3.length; ++i) {
                JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray3[i]);
                stringArray2 = jRSReportEngine.getViewNames();
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                block1: for (int j = 0; j < stringArray2.length; ++j) {
                    ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray3[i], stringArray2[j]);
                    Vector vector = reportViewCenter.getUsedDataSet();
                    for (int k = 0; k < stringArray.length; ++k) {
                        if (vector == null || !vector.contains(stringArray[k])) continue;
                        Vector vector2 = hashMap.containsKey(stringArray3[i]) ? (Vector)hashMap.get(stringArray3[i]) : new Vector();
                        vector2.addElement(stringArray2[j]);
                        hashMap.put(stringArray3[i], vector2);
                        continue block1;
                    }
                }
            }
        }
        if (!hashMap.isEmpty()) {
            stringArray3 = new String[hashMap.size()];
            Vector[] vectorArray = new Vector[hashMap.size()];
            int n = 0;
            stringArray2 = hashMap.keySet().iterator();
            while (stringArray2.hasNext()) {
                stringArray3[n] = (String)stringArray2.next();
                vectorArray[n] = (Vector)hashMap.get(stringArray3[n]);
                ++n;
            }
            this.displayStructure(stringArray3, vectorArray);
        }
    }

    private String[] doRequestRunReport(String[] stringArray, Vector[] vectorArray) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getUsedDataSetNames()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray));
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                ReportViewCenter reportViewCenter = this.rptSetCenter.getReportViewCenter(stringArray[i], string);
                Vector vector2 = reportViewCenter.getUsedDataSet();
                for (int k = 0; k < vector2.size(); ++k) {
                    String string2 = (String)vector2.elementAt(k);
                    if (vector.contains(string2)) continue;
                    vector.addElement(string2);
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getUsedDataSetNames(). return: " + vector);
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected ParameterManager getParameterManager() {
        return this.cancelRawDataQuery;
    }

    public ParameterAdapter getParamAdapter() {
        return this.cancelRawDataQuery == null ? null : this.cancelRawDataQuery.getParamAdapter();
    }

    public void refreshParameter(Hashtable hashtable) {
        if (hashtable != null && !hashtable.isEmpty()) {
            Hashtable hashtable2 = this.getParamsBuffer();
            for (String string : hashtable.keySet()) {
                String string2 = string.toUpperCase();
                if (hashtable2.containsKey(string2)) continue;
                hashtable2.put(string2, hashtable.get(string));
            }
        }
    }

    public PrincipalAttributes createSubReportSet(String string, JetUUniverse jetUUniverse) throws ResourceNotFoundException, ResourceLoadException, ReadFailureException {
        PrincipalAttributes principalAttributes;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.createSubReportSet()..., subFullRptSetName: " + string + " extUnv: " + jetUUniverse);
        }
        if ((principalAttributes = (PrincipalAttributes)this.createViewEngine.get(string)) != null) {
            return principalAttributes;
        }
        JetRptReportSet jetRptReportSet = null;
        JetRptReportSet jetRptReportSet2 = this.getReportSet();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.createSubReportSet()..., subFullRptSetName: " + string);
            JRLog.trace(6, "main full rpt set name: " + jetRptReportSet2.getFullFileName());
        }
        if (string.equals(jetRptReportSet2.getFullFileName())) {
            Tools.logTrace(6, "clone from main report set.");
            jetRptReportSet = this.elementAt(jetRptReportSet2);
        } else {
            Tools.logTrace(6, "load from file system.");
            boolean bl = !this.isDHTML();
            JetRptReportSet jetRptReportSet3 = ReportTools.loadReportSet(string, "", bl, this.getUniverse(), this.getEngineEnv().getResourceStore().getMemoryStore());
            if (bl) {
                jetRptReportSet = this.elementAt(jetRptReportSet3);
                jetRptReportSet3.free();
            } else {
                jetRptReportSet = jetRptReportSet3;
            }
            if (this.isDHTML() || this.isDhtmlInteract()) {
                JetUUniverse jetUUniverse2 = jetUUniverse == null ? this.getUniverse() : jetUUniverse;
                Vector vector = jetRptReportSet.getReports().getChildren();
                DataContainerConvertor dataContainerConvertor = DataContainerConvertor.getConvertInstant();
                for (int i = 0; i < vector.size(); ++i) {
                    JetObject jetObject = (JetObject)vector.get(i);
                    if (!(jetObject instanceof JetRptReport)) continue;
                    dataContainerConvertor.doConvertDataContainerInReport(jetUUniverse2, (JetRptReport)jetObject);
                }
            }
        }
        principalAttributes = new PrincipalAttributes(jetRptReportSet);
        principalAttributes.setDiskPath(string);
        this.createViewEngine.put(string, principalAttributes);
        Tools.logTrace(6, "End of JRptSetEngine.createSubReportSet(), return: " + principalAttributes);
        return principalAttributes;
    }

    public PrincipalAttributes removeSubRptSet(String string) {
        return (PrincipalAttributes)this.createViewEngine.remove(string);
    }

    private JetRptReportSet elementAt(JetRptReportSet jetRptReportSet) {
        JetRptReportSet jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
        jetRptReportSet2.setPath(jetRptReportSet.getPath());
        jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
        jetRptReportSet2.createNamingSystem();
        jetRptReportSet2.afterInit();
        return jetRptReportSet2;
    }

    public void addEngineRefreshListner(String string, String string2, EngineRefreshListener engineRefreshListener) {
        this.getReportEngine(string).getViewEngine(string2).addRefreshListener(engineRefreshListener);
    }

    public void initParamRuntimeEnv(ParamDesc paramDesc) {
        this.cancelRawDataQuery.initParamRuntimeEnv(paramDesc);
    }

    public void initParamRuntimeEnv(Hashtable hashtable) {
        this.cancelRawDataQuery.initParamRuntimeEnv(hashtable);
    }

    private void equals(String[] stringArray, Vector[] vectorArray) {
        Vector vector;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.refreshPartialData(), this: " + this);
        }
        if ((vector = this.getReportViewEngines(stringArray, vectorArray)) == null || vector.isEmpty()) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "view engines is " + (vector == null ? "null." : "empty."));
                JRLog.trace(6, "End of JRptSetEngine.refreshPartialData()!");
            }
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            JSubReportEngine[] jSubReportEngineArray = jReportEngine.getReportViewCenter().getAllSubReportEngine();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "subEngins: " + Tools.toString(jSubReportEngineArray));
            }
            if (jSubReportEngineArray == null) continue;
            for (int j = 0; j < jSubReportEngineArray.length; ++j) {
                ReportViewCenter reportViewCenter = jSubReportEngineArray[j].getReportViewCenter();
                JetRptSubReport[] jetRptSubReportArray = jSubReportEngineArray[j].getReportViewCenter().getSubReportsOfSubEngine();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "subReports: " + Tools.toString(jetRptSubReportArray));
                }
                if (jetRptSubReportArray == null) continue;
                ReportSetCenter reportSetCenter = reportViewCenter.getRptCenter().getRptSetCenter();
                for (int k = 0; k < jetRptSubReportArray.length; ++k) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "for viewEngine: " + i + " subEngine: " + j + " subReport: " + k);
                    }
                    JetRptSubReport jetRptSubReport = jetRptSubReportArray[k];
                    String[] stringArray2 = this.equalsForRawData(reportViewCenter, jetRptSubReport);
                    for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        JetRptDataSet jetRptDataSet = reportViewCenter.getDataSet(stringArray2[i2]);
                        PartialData partialData = new PartialData(stringArray2[i2], reportViewCenter.getOriReportView(), jetRptSubReport);
                        if (JRLog.isTrace(6)) {
                            JRLog.trace(6, "put PartialData for data set: " + stringArray2[i2]);
                            JRLog.trace(6, "PartialData: " + partialData);
                        }
                        reportSetCenter.getDataSetCenter(stringArray2[i2]).putPartialData(partialData, this.getUniverse());
                    }
                    if (!JRLog.isTrace(6)) continue;
                    JRLog.trace(6, "end for viewEngine: " + i + " subEngine: " + j + " subReport: " + k);
                }
            }
        }
        Tools.logTrace(6, "End of JRptSetEngine.refreshPartialData()!");
    }

    private String[] equalsForRawData(ReportViewCenter reportViewCenter, JetRptSubReport jetRptSubReport) {
        Vector<String> vector = new Vector<String>();
        List list = jetRptSubReport.getSubLinkContainers();
        if (list != null && !list.isEmpty()) {
            List list2 = this.error(reportViewCenter);
            for (int i = 0; i < list.size(); ++i) {
                Vector vector2;
                JetRptSubLinkContainer jetRptSubLinkContainer = (JetRptSubLinkContainer)list.get(i);
                if (jetRptSubLinkContainer.targetCompInst == null || (vector2 = jetRptSubLinkContainer.targetCompInst.get()) == null || vector2.isEmpty()) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    DataSet dataSet;
                    String string = (String)vector2.elementAt(j);
                    JetRptObject jetRptObject = (JetRptObject)reportViewCenter.getOriReportView().nameToObject(string);
                    if (jetRptObject == null || !list2.contains(string) || (dataSet = ReportTools.getDataSet(jetRptObject)) == null || vector.contains(dataSet.getName())) continue;
                    vector.addElement(dataSet.getName());
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    private List error(ReportViewCenter reportViewCenter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ContainerInfo[] containerInfoArray = reportViewCenter.getContainerInfos();
        if (containerInfoArray != null) {
            for (int i = 0; i < containerInfoArray.length; ++i) {
                String[] stringArray = containerInfoArray[i].getAllDataContainerInstNames();
                if (stringArray == null || stringArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(stringArray));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestRunReport(String[] stringArray, Vector[] vectorArray) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.requestRunReport()..., rptNames: " + Tools.toString(stringArray) + " vViewNames: " + Tools.toString(vectorArray) + " this: " + this);
        }
        Object object = this.closeAllGroups;
        synchronized (object) {
            if (this.isDHTML() && (this.isDhtmlPipeline() || this.isOnDemandReport())) {
                for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < vectorArray[i].size(); ++j) {
                        JCommunicator jCommunicator;
                        String string = (String)vectorArray[i].elementAt(j);
                        JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                        if (jReportEngine == null || (jCommunicator = jReportEngine.getCommunicator()) == null || jCommunicator.isEngineFinished()) continue;
                        if (this.isOnDemandReport()) {
                            jReportEngine.stopLayoutOnly();
                        }
                        jCommunicator.waitStreamEngineFinished();
                    }
                }
            } else {
                if (this.isRunning()) {
                    this.ThreadException(Thread.currentThread(), new JRScheduleException(220038));
                    Tools.logTrace(6, "End of JRptSetEngine.requestRunReport(), isRunning, return false!");
                    return false;
                }
                if (this.isStopping()) {
                    this.ThreadException(Thread.currentThread(), new JRScheduleException(220040));
                    Tools.logTrace(6, "End of JRptSetEngine.requestRunReport(), isStopping, return false!");
                    return false;
                }
            }
            this.cvIExpresstion = true;
            this.closeAllGroups();
            this.closeQuery(stringArray, vectorArray);
            this.LOCAL_LANGUAGE(6);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "requestRunReport, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.requestRunReport(), return true!");
        }
        return true;
    }

    private void fetchGroup(String[] stringArray, Vector[] vectorArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < vectorArray[i].size(); ++j) {
                String string = (String)vectorArray[i].elementAt(j);
                JReportEngine jReportEngine = this.getReportViewEngine(stringArray[i], string);
                if (jReportEngine == null) continue;
                jReportEngine.setErrorFlag();
            }
        }
    }

    public void ignoreRequestRunReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.ignoreRequestRunReport()..., rptName: " + string + " viewName: " + string2 + " this: " + this);
        }
        this.clearRunningReports(string, string2);
        Vector[] vectorArray = new Vector[]{new Vector()};
        vectorArray[0].addElement(string2);
        this.fetchGroup(new String[]{string}, vectorArray);
        Tools.logTrace(6, "End of JRptSetEngine.ignoreRequestRunReport().");
    }

    public void doRequestRunReport(String string, String string2, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.doRequestRunReport()..., this: " + this + " rptName: " + string + " viewName: " + string2 + " applyStyleNls: " + bl);
        }
        if (this.htReportEngine == null) {
            return;
        }
        if (!this.finished(string, string2)) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "report view don't be requested to run.");
                JRLog.trace(6, "End of JRptSetEngine.doRequestRunReport().");
            }
            return;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        jRSReportEngine.runReportView(new String[]{string2}, bl);
        Tools.logTrace(6, "End of JRptSetEngine.doRequestRunReport().");
    }

    public void doRequestRunReport(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.doRequestRunReport()..., this: " + this + " rptName: " + string + " viewName: " + string2);
        }
        this.doRequestRunReport(string, string2, true);
        Tools.logTrace(6, "End of JRptSetEngine.doRequestRunReport().");
    }

    private boolean finished(String string, String string2) {
        Vector vector;
        boolean bl = false;
        if (this.disable != null && this.disable.containsKey(string) && (vector = (Vector)this.disable.get(string)).contains(string2)) {
            bl = true;
        }
        return bl;
    }

    public void free(String string, String string2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.free()..., rptName: " + string + " viewName: " + string2);
        }
        if (!this.finished(string, string2)) {
            return;
        }
        if (this.htReportEngine == null) {
            return;
        }
        JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(string);
        jRSReportEngine.stop(string2);
        String[] stringArray = this.doConvertDataContainerInReport(new String[]{string}, new Vector[]{new Vector<String>(Arrays.asList(string2))});
        this.cancelRawDataQueries(stringArray);
        HashMap hashMap = new HashMap();
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        hashMap.put(string, vector);
        this.waitRunFinished(hashMap);
        jRSReportEngine.clear(string2);
        this.clearRunningReports(string, string2);
        Tools.logTrace(6, "End of JRptSetEngine.free().");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Tools.logTrace(6, "JRptSetEngine.free()...");
        if (this.htReportEngine == null) {
            return;
        }
        Object object = this.closeAllGroups;
        synchronized (object) {
            this.stop();
            this.clear();
        }
        this.clearMem();
        Tools.logTrace(6, "End of JRptSetEngine.free().");
    }

    public void fillRptSetEngineInfo(ReportsetEngineInfo reportsetEngineInfo) {
        String[] stringArray;
        if (reportsetEngineInfo == null) {
            throw new NullPointerException();
        }
        if (!(this instanceof JSubRptSetEngine)) {
            stringArray = new DataEngineInfo();
            reportsetEngineInfo.setDataEngineInfo((DataEngineInfo)stringArray);
            if (this.dataService != null) {
                this.dataService.getEngineInfo((DataEngineInfo)stringArray);
            }
        }
        if (this.htReportEngine == null || this.htReportEngine.isEmpty()) {
            return;
        }
        stringArray = this.getReportNames();
        reportsetEngineInfo.setUser(this.getUserName());
        reportsetEngineInfo.setRunningReportName(stringArray);
        Object var3_3 = null;
        Vector<ReportEngineInfo> vector = new Vector<ReportEngineInfo>();
        if (this.htReportEngine != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Vector vector2;
                JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray[i]);
                if (jRSReportEngine == null || (vector2 = jRSReportEngine.getRptViewNames()) == null) continue;
                for (int j = 0; j < vector2.size(); ++j) {
                    String string = (String)vector2.elementAt(i);
                    JReportEngine jReportEngine = jRSReportEngine.getViewEngine(string);
                    if (jReportEngine == null) continue;
                    ReportEngineInfo reportEngineInfo = new ReportEngineInfo();
                    vector.addElement(reportEngineInfo);
                    jReportEngine.getReportEngineInfo(reportEngineInfo);
                    reportEngineInfo.setEngineName(stringArray[i]);
                }
            }
        }
        reportsetEngineInfo.setReportEngineInfo(vector.toArray(new ReportEngineInfo[0]));
    }

    public void setRuntimeInfo(String string, String string2, RuntimeInfoAgent runtimeInfoAgent) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.setRuntimeInfo()..., rptName: " + string + " viewName: " + string2 + " runtimeInfoAgent: " + runtimeInfoAgent);
        }
        if (this.getEngineEnv() != null) {
            this.getEngineEnv().setRuntimeInfo(string, runtimeInfoAgent);
        }
    }

    public RuntimeInfoAgent getRuntimeInfo(String string, String string2) {
        return this.getEngineEnv().getRuntimeInfo(string);
    }

    public void setStreamFactory(String string, InputStreamFactory inputStreamFactory) throws JRScheduleException {
        JetUDatabase jetUDatabase = this.getUniverse().getDatabase(string);
        if (jetUDatabase == null) {
            throw new JRScheduleException(220058, (Object[])new String[]{string}, null);
        }
        JetUConnection jetUConnection = jetUDatabase.getConnection();
        if (jetUConnection == null) {
            throw new JRScheduleException(220059, (Object[])new String[]{string}, null);
        }
        if (!(jetUConnection instanceof JetUXMLConnection)) {
            throw new JRScheduleException(220060, (Object[])new String[]{string}, null);
        }
        this.rptSetCenter.getDataSourceInfo(this.getUniverse(), string).setStreamFactory(inputStreamFactory);
    }

    protected InputStreamFactory getStreamFactory(String string) {
        return this.rptSetCenter.getDataSourceInfo(this.getUniverse(), string).getStreamFactory();
    }

    public void setStreamFactory(String string, String string2, InputStreamFactory inputStreamFactory) throws JRScheduleException {
        JetUQueriable jetUQueriable = this.getUniverse().getQueriableByResourceName(string, string2);
        if (jetUQueriable == null) {
            throw new JRScheduleException(220061, (Object[])new String[]{string, string2}, null);
        }
        if (!(jetUQueriable instanceof JetUHierDataSource)) {
            throw new JRScheduleException(220062, (Object[])new String[]{string, string2}, null);
        }
        this.rptSetCenter.getQueryInfo(this.getUniverse(), string, string2).setStreamFactory(inputStreamFactory);
    }

    public InputStreamFactory getStreamFactory(String string, String string2) {
        return this.rptSetCenter.getQueryInfo(this.getUniverse(), string, string2).getStreamFactory();
    }

    public JdbcDriversConfig getJdbcDriversCfg() {
        return this.closeAllSubReportDatas;
    }

    public void applyStyleNls(String string, String string2) {
        JRSReportEngine jRSReportEngine = this.getReportEngine(string);
        if (jRSReportEngine != null) {
            jRSReportEngine.applyStyleNls(string2, true);
        }
    }

    public void registReportView(JetRptReport jetRptReport) {
        if (jetRptReport == null) {
            throw new NullPointerException();
        }
        if (this.clearSubRptInfoMap == null) {
            this.clearSubRptInfoMap = new ArrayList();
        } else if (this.clearSubRptInfoMap.contains(jetRptReport)) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "schedule error, can't regist same view multi times, detail info:\n" + new Exception());
            }
            return;
        }
        this.clearSubRptInfoMap.add(jetRptReport);
    }

    public boolean hasRegisted(JetRptReport jetRptReport) {
        return this.clearSubRptInfoMap != null && this.clearSubRptInfoMap.contains(jetRptReport);
    }

    public AccessController getAccessController(JUnifiedBusinessView jUnifiedBusinessView) throws DSException {
        AccessController accessController = null;
        QueryInfo queryInfo = ResourceTool.getQueryInfo(jUnifiedBusinessView);
        if (this.isRsd()) {
            RSDInfo rSDInfo = this.getRSDInfo();
            String[] stringArray = rSDInfo.getDeniedBLNames(1, queryInfo.getDatasourceName(), queryInfo.getBLName());
            String[] stringArray2 = rSDInfo.getDeniedBLNames(2, queryInfo.getDatasourceName(), queryInfo.getBLName());
            accessController = AccessControllerFactory.createAccessController(stringArray, stringArray2);
        } else if (jUnifiedBusinessView != null) {
            accessController = AccessControllerFactory.createAccessController(jUnifiedBusinessView, queryInfo, this.getEngineEnv(), this.getCatalogKey(), this.getAccessDenyListProvider());
        }
        return accessController;
    }

    public void setIsDhtmlPipeline(boolean bl) {
        this.closeQuery = bl;
    }

    public boolean isDhtmlPipeline() {
        return this.closeQuery;
    }

    private Object fromBl() {
        return this.isDhtmlInteract() ? null : (this.getType() == 1 || this.getType() == 2 ? null : this.getPriorityLocker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPriority(int n) {
        Object object = this.fromBl();
        if (object == null) {
            this.asyncronizedSetPriority(n);
        } else {
            Object object2 = object;
            synchronized (object2) {
                this.asyncronizedSetPriority(n);
            }
        }
    }

    protected void asyncronizedSetPriority(int n) {
        this.closeRelatedDataInstance = n;
        Vector vector = this.getAllReportViewEngines();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            JReportEngine jReportEngine = (JReportEngine)vector.elementAt(i);
            jReportEngine.setThreadPriority(n);
            ReportViewCenter reportViewCenter = jReportEngine.getReportViewCenter();
            JSubRptSetEngine[] jSubRptSetEngineArray = reportViewCenter.getAllSubRptSetEngine();
            for (int j = 0; j < jSubRptSetEngineArray.length; ++j) {
                jSubRptSetEngineArray[j].asyncronizedSetPriority(n);
            }
            JREngine[] jREngineArray = reportViewCenter.getAllLinkReportEngine();
            for (int j = 0; j < jREngineArray.length; ++j) {
                JRptSetEngine jRptSetEngine = jREngineArray[j].getRptSetEngine();
                if (jRptSetEngine == null) continue;
                jRptSetEngine.asyncronizedSetPriority(n);
            }
        }
    }

    public int getPriority() {
        return this.closeRelatedDataInstance;
    }

    public void setDhtmlInteract(boolean bl) {
        this.closeUnusedRawQuery = bl;
    }

    public boolean isDhtmlInteract() {
        return this.closeUnusedRawQuery;
    }

    public Object getPriorityLocker() {
        switch (this.getType()) {
            case 0: {
                return this.priorityLocker;
            }
            case 2: {
                return this.priorityLocker;
            }
            case 1: {
                JRptSetEngine jRptSetEngine = this.getRootRptSetEngine();
                return jRptSetEngine == null ? null : jRptSetEngine.priorityLocker;
            }
        }
        return null;
    }

    protected JRptSetEngine getRootRptSetEngine() {
        JRptSetEngine jRptSetEngine = this;
        while (jRptSetEngine != null && (jRptSetEngine.getType() == 1 || jRptSetEngine.getType() == 2)) {
            JReportEngine jReportEngine = jRptSetEngine.getParentEngine();
            jRptSetEngine = jReportEngine == null ? null : jReportEngine.getRptSetEngine();
        }
        return jRptSetEngine;
    }

    public void getAllReports(Map map) {
        Vector vector = this.getAllReportEngines();
        JRSReportEngine[] jRSReportEngineArray = vector.toArray(new JRSReportEngine[vector.size()]);
        for (int i = 0; i < jRSReportEngineArray.length; ++i) {
            map.put(jRSReportEngineArray[i].getReport(), jRSReportEngineArray[i].getReport().getDisplayName());
            Vector vector2 = jRSReportEngineArray[i].getViewEngines();
            JReportEngine[] jReportEngineArray = vector2 == null ? new JReportEngine[]{} : vector2.toArray(new JReportEngine[vector2.size()]);
            for (int j = 0; j < jReportEngineArray.length; ++j) {
                JSubReportEngine[] jSubReportEngineArray = jReportEngineArray[j].getReportViewCenter().getAllSubReportEngine();
                if (jSubReportEngineArray == null) continue;
                for (int k = 0; k < jSubReportEngineArray.length; ++k) {
                    JetRptReport jetRptReport = jSubReportEngineArray[k].getReportCenter().getReport();
                    map.put(jetRptReport, jetRptReport.getDisplayName());
                }
            }
        }
    }

    protected boolean isBursting() {
        return this.columnName;
    }

    public boolean requestRunBurstingReport(BurstingSchema[] burstingSchemaArray, DataBlock[] dataBlockArray, boolean bl) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "JRptSetEngine.requestRunBurstingReport()...,  bs: " + Tools.toString(burstingSchemaArray) + " dataBlocks: " + Tools.toString(dataBlockArray) + " isBurstingFunction: " + bl + " this: " + this);
        }
        if (!this.isBursting()) {
            throw new JRScheduleException(220075);
        }
        this.genRSDInfo(burstingSchemaArray, dataBlockArray, true);
        this.contains = bl;
        if (dataBlockArray != null) {
            for (int i = 0; i < dataBlockArray.length; ++i) {
                if (dataBlockArray[i] == null) continue;
                String string = dataBlockArray[i].getDataSetName();
                DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(string);
                dataSetCenter.setDataBlock(dataBlockArray[i]);
            }
        }
        this.cvIExpresstion = true;
        this.closeAllGroups();
        String[] stringArray = this.getReportNames();
        this.closeQuery(stringArray, this.getViewNames(stringArray));
        this.createAccessController = burstingSchemaArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "requestRunBurstingReport, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            JRLog.trace(6, "End of JRptSetEngine.requestRunBurstingReport(), return true!");
        }
        return true;
    }

    public void doRequestRunBurstingReport(DataBlock[] dataBlockArray, String string) {
        String string2;
        int n;
        int n2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.doRequestRunBurstingReport()...,  dataBlocks: " + Tools.toString(dataBlockArray) + " currentBurstingSchemaName: " + string + " this: " + this);
        }
        if (!this.isBursting()) {
            Tools.logTrace(4, new JRScheduleException(220075));
            return;
        }
        if (this.htReportEngine == null) {
            return;
        }
        try {
            this.genRSDInfo(this.createAccessController, dataBlockArray, false);
        }
        catch (JRScheduleException jRScheduleException) {
            Tools.logTrace(5, jRScheduleException);
            if (this.clearRunningReports != null && !this.clearRunningReports.isEmpty()) {
                for (int i = 0; i < this.clearRunningReports.size(); ++i) {
                    EngineErrorListener engineErrorListener = (EngineErrorListener)this.clearRunningReports.elementAt(i);
                    engineErrorListener.noteError(Thread.currentThread(), jRScheduleException, 1, "Data blocks for bursting data sets are not enough.");
                }
            }
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport().");
            }
            this.closeAllGroups();
            return;
        }
        String[] stringArray = new String[dataBlockArray.length];
        for (int i = 0; i < dataBlockArray.length; ++i) {
            stringArray[i] = dataBlockArray[i].getDataSetName();
        }
        String[] stringArray2 = this.getReportNames();
        Vector[] vectorArray = this.getViewNames(stringArray2);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            for (int i = 0; i < vectorArray[n2].size(); ++i) {
                if (this.finished(stringArray2[n2], (String)vectorArray[n2].elementAt(i))) continue;
                this.closeAllGroups();
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "report view don't be requested to run.");
                    JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport().");
                }
                return;
            }
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            JRSReportEngine jRSReportEngine = this.getReportEngine(stringArray2[n2]);
            for (n = 0; n < vectorArray[n2].size(); ++n) {
                string2 = (String)vectorArray[n2].elementAt(n);
                JReportEngine jReportEngine = jRSReportEngine.getViewEngine(string2);
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
                String[] stringArray3 = jReportEngine.getReportViewCenter().getAllDataContainerNames();
                for (int i = 0; i < stringArray3.length; ++i) {
                    DataSet dataSet;
                    IDataContainer iDataContainer = (IDataContainer)((Object)jReportEngine.getReport().nameToObject(stringArray3[i]));
                    if (iDataContainer == null || arrayList.contains(stringArray3[i]) || (dataSet = ReportTools.getDataSet((JetObject)((Object)iDataContainer))) == null || !arrayList2.contains(dataSet.getName())) continue;
                    arrayList.add(stringArray3[i]);
                }
                jRSReportEngine.closeRelatedDataInstance(string2, arrayList.toArray(new String[arrayList.size()]));
            }
        }
        this.closeRawDatas(stringArray);
        this.containsKey = string;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            DataSetCenter dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[n2]);
            dataSetCenter.setDataBlock(dataBlockArray[n2]);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            JRSReportEngine jRSReportEngine = (JRSReportEngine)this.htReportEngine.get(stringArray2[n2]);
            for (n = 0; n < vectorArray[n2].size(); ++n) {
                string2 = (String)vectorArray[n2].elementAt(n);
                jRSReportEngine.runReportView(new String[]{string2});
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.doRequestRunBurstingReport()!");
        }
    }

    private void genRSDInfo(BurstingSchema[] burstingSchemaArray, DataBlock[] dataBlockArray, boolean bl) throws JRScheduleException {
        String[] stringArray;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.checkDataBlocks()..., burstingSchemas: " + Tools.toString(burstingSchemaArray) + " dataBlocks: " + Tools.toString(dataBlockArray) + " isShared: " + bl);
        }
        Vector vector = this.getAllReportViewEngines();
        JReportEngine jReportEngine = null;
        for (int i = 0; i < vector.size(); ++i) {
            JReportEngine jReportEngine2 = (JReportEngine)vector.elementAt(i);
            if (!ObjectLogicFactory.getReportLogic().isBurstingReport(jReportEngine2.getReport())) continue;
            jReportEngine = jReportEngine2;
            break;
        }
        if (jReportEngine == null) {
            Tools.logTrace(5, "no bursting report, failed to check data blocks. ");
            return;
        }
        String[] stringArray2 = stringArray = bl ? this.genRawDataQuery(burstingSchemaArray) : this.genValidValues(burstingSchemaArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "check data blocks for data sets: " + Tools.toString(stringArray));
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            DataSetCenter dataSetCenter;
            if (bl && !(dataSetCenter = this.rptSetCenter.getDataSetCenter(stringArray[i])).hasDbFieldOrPass1Formula() && !dataSetCenter.hasConstantGlobalFormula()) continue;
            boolean bl2 = false;
            for (int j = 0; dataBlockArray != null && j < dataBlockArray.length; ++j) {
                if (!stringArray[i].equals(dataBlockArray[j].getDataSetName())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            throw new JRScheduleException(bl ? 220077 : 220078, (Object[])new String[]{stringArray[i]}, null);
        }
        Tools.logTrace(6, "End of JRptSetEngine.checkDataBlocks().");
    }

    private String[] genRawDataQuery(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < burstingSchemaArray.length; ++i) {
            String[] stringArray = burstingSchemaArray[i].getBurstingDataSetNames();
            if (i == 0) {
                String[] stringArray2 = burstingSchemaArray[i].getSharedDataSetNames();
                vector.addAll(Arrays.asList(stringArray));
                vector.addAll(Arrays.asList(stringArray2));
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector2.contains(stringArray[j])) continue;
                vector2.addElement(stringArray[j]);
            }
        }
        vector.removeAll(vector2);
        return vector.toArray(new String[vector.size()]);
    }

    private String[] genValidValues(BurstingSchema[] burstingSchemaArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < burstingSchemaArray.length; ++i) {
            String[] stringArray = burstingSchemaArray[i].getBurstingDataSetNames();
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector.contains(stringArray[j])) continue;
                vector.addElement(stringArray[j]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public RawDataQueryCreator getRawDataQueryCreator(String string) throws JRScheduleException {
        DataSetCenter dataSetCenter;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.getRawDataQueryCreator()..., dataSetName: " + string);
        }
        if ((dataSetCenter = this.rptSetCenter.getDataSetCenter(string)) == null) {
            throw new JRScheduleException(250009, (Object[])new String[]{string}, null);
        }
        EngineRawDataQueryCreator engineRawDataQueryCreator = new EngineRawDataQueryCreator(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of JRptSetEngine.getRawDataQueryCreator(), return: " + engineRawDataQueryCreator);
        }
        return engineRawDataQueryCreator;
    }

    public IQueryBuilder getQueryBuilder() {
        return new EngineQueryBuilder(this);
    }

    public synchronized void setSortMemorySize(int n) {
        this.compareTo = n;
    }

    public synchronized int getSortMemorySize() {
        return this.compareTo;
    }

    public void stopLayout(String string, String string2) {
        JReportEngine jReportEngine;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.stopLayout()..., rptName: " + string + " viewName: " + string2);
        }
        if ((jReportEngine = this.getReportViewEngine(string, string2)) != null) {
            Tools.logTrace(6, "stop layout for report view engine");
            jReportEngine.stopLayoutOnly();
        }
        Tools.logTrace(6, "End of JRptSetEngine.stopLayout().");
    }

    public boolean isBurstingFunction() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "JRptSetEngine.isBurstingFunction()..., return: " + this.contains);
        }
        return this.contains;
    }

    public String getCurrentBurstingSchemaName() {
        return this.containsKey;
    }

    public IRuntimeQueryInfoProvider getIRuntimeQueryInfoProvider() {
        return this.getMainRptSetEngine().getEngineEnv().getRuntimeQueryInfoProvider();
    }

    public void setReportSetProvider(ReportSetProvider reportSetProvider) {
        this.getMainRptSetEngine().createNamingSystem = reportSetProvider;
    }

    public ReportSetProvider getReportSetProvider() {
        return this.getMainRptSetEngine().createNamingSystem;
    }

    public InfoCenterProvider getInfoCenterProvider() {
        return new InfoCenterProviderImpl();
    }

    public void setExternalEnv(ExternalEnv externalEnv) {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "JRptSetEngine.setExternalEnv()..., this: " + this + " env: " + externalEnv);
        }
        if (this.rptSetCenter != null) {
            this.rptSetCenter.setExternalEnv(externalEnv);
        } else {
            Tools.logTrace(5, "rptSetCenter is null, can't set external env.");
        }
    }

    public String getImgResourceId() {
        return this.addAll == null ? null : this.addAll.getImgResourceId();
    }

    public void resetParamsBaseline() {
        ParameterManager parameterManager = this.getParameterManager();
        if (parameterManager != null) {
            parameterManager.resetParamsBaseline();
        }
    }

    protected Observable getEngineEnvObservable() {
        return this.currentThread;
    }

    protected Observer getEngineEnvObserver() {
        return this.currentThread;
    }

    private void generateShareInfo(NLSApplyParam nLSApplyParam) {
        this.currentThread.SEDU().setLocale(nLSApplyParam.getLocale());
        this.currentThread.SEDU(nLSApplyParam);
    }

    public void changeNLSParam(NLSApplyParam nLSApplyParam) {
        this.generateShareInfo(nLSApplyParam);
        ParameterManager parameterManager = this.getParameterManager();
        if (parameterManager != null) {
            parameterManager.redoParameterPromptNLS();
        }
    }

    public boolean hasSpecPahInTemplate(String string, String string2, int n) {
        JReportEngine jReportEngine = this.getReportViewEngine(string, string2);
        return jReportEngine == null ? false : jReportEngine.hasSpecPahInTemplate(n);
    }

    public synchronized JDenyListProvider getAccessDenyListProvider() throws DSException {
        ExternalEnv externalEnv = this.rptSetCenter.getExternalEnv();
        return externalEnv == null || externalEnv.getAccessDenyListProvider() == null ? this.get() : externalEnv.getAccessDenyListProvider();
    }

    private JDenyListProvider get() throws DSException {
        if (this.doCLS == null) {
            if (this.isRsd()) {
                this.doCLS = new RSDAccessDenyListProvider(this.addAll);
            } else {
                String string = null;
                SecurityData securityData = null;
                SecurityContext securityContext = this.getSecurityContext();
                if (securityContext == null) {
                    securityData = this.getSecurityData();
                    string = this.getUserName();
                } else {
                    securityData = new SecurityContextAdapter(securityContext);
                    string = securityContext.getUserName();
                }
                this.doCLS = JDenyListProviderFactory.createJDenyListProvider(securityData, this.getDataService(), string);
            }
        }
        return this.doCLS;
    }

    private static class KeyNLSManager {
        private final String SEDU;
        private final Locale append;

        private KeyNLSManager(String string, Locale locale) {
            this.SEDU = string;
            this.append = locale;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object == this) {
                return true;
            }
            if (!(object instanceof KeyNLSManager)) {
                return false;
            }
            KeyNLSManager keyNLSManager = (KeyNLSManager)object;
            boolean bl2 = this.SEDU == null ? keyNLSManager.SEDU == null : (bl = this.SEDU.equals(keyNLSManager.SEDU));
            return bl && (this.append == null ? keyNLSManager.append == null : this.append.equals(keyNLSManager.append));
        }

        public int hashCode() {
            int n = this.SEDU == null ? 0 : this.SEDU.hashCode();
            return 31 * n + (this.append == null ? 0 : this.append.hashCode());
        }

        public String toString() {
            return "path: " + this.SEDU + " locale: " + this.append;
        }
    }

    private static class _EngineEnvContainer
    extends Observable
    implements Observer {
        private EngineEnv SEDU;

        private _EngineEnvContainer(EngineEnv engineEnv) {
            this.SEDU = engineEnv;
        }

        private EngineEnv SEDU() {
            return this.SEDU;
        }

        private void SEDU(NLSApplyParam nLSApplyParam) {
            this.SEDU.setNLSParam(nLSApplyParam);
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        public void update(Observable observable, Object object) {
            this.SEDU.setNLSParam(null);
        }
    }

    private class InfoCenterProviderImpl
    implements InfoCenterProvider {
        private InfoCenterProviderImpl() {
        }

        @Override
        public IReportSetCenter getRptSetCenter() {
            return JRptSetEngine.this.rptSetCenter;
        }

        @Override
        public IReportCenter getReportCenter(String string) {
            return JRptSetEngine.this.rptSetCenter.getReportCenter(string);
        }

        @Override
        public IDataSetCenter getDataSetCenter(String string) {
            return JRptSetEngine.this.rptSetCenter.getDataSetCenter(string);
        }

        @Override
        public IReportViewCenter getReportViewCenter(String string, String string2) {
            return JRptSetEngine.this.rptSetCenter.getReportViewCenter(string, string2);
        }
    }

    private class ReportViewNames {
        private Vector SEDU = new Vector();
        private HashMap addElement = new HashMap();

        ReportViewNames() {
        }

        void addRptViewNames(String string, String string2) {
            if (!this.SEDU.contains(string)) {
                this.SEDU.addElement(string);
                this.addElement.put(string, new String[]{string2});
            } else {
                String[] stringArray = (String[])this.addElement.get(string);
                String[] stringArray2 = new String[stringArray.length + 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = stringArray[i];
                }
                stringArray2[stringArray.length] = string2;
                this.addElement.put(string, stringArray2);
            }
        }

        boolean contains(String string, String string2) {
            if (!this.SEDU.contains(string)) {
                return false;
            }
            String[] stringArray = (String[])this.addElement.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
            return false;
        }

        String[] getRptNames() {
            return this.SEDU.toArray(new String[this.SEDU.size()]);
        }

        Vector[] getViewNames() {
            Vector[] vectorArray = new Vector[this.SEDU.size()];
            for (int i = 0; i < vectorArray.length; ++i) {
                vectorArray[i] = new Vector();
                String[] stringArray = (String[])this.addElement.get(this.SEDU.elementAt(i));
                for (int j = 0; j < stringArray.length; ++j) {
                    vectorArray[i].addElement(stringArray[j]);
                }
            }
            return vectorArray;
        }

        String[] getViewNames(String string) {
            return (String[])this.addElement.get(string);
        }

        boolean isEmpty() {
            return this.SEDU == null || this.SEDU.isEmpty();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ReportViewNames:\n");
            stringBuffer.append(Tools.toString(this.SEDU) + "\n");
            int n = this.SEDU.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(Tools.toString((String[])this.addElement.get(this.SEDU.elementAt(i))));
                stringBuffer.append(i < n - 1 ? "," : "\n");
            }
            stringBuffer.append("End of ReportViewNames:\n");
            return stringBuffer.toString();
        }
    }

    private class EngineRawDataQueryCreator
    implements RawDataQueryCreator {
        private String SEDU = null;

        EngineRawDataQueryCreator(String string) {
            this.SEDU = string;
        }

        @Override
        public JRawDataQuery createRawDataQuery(JQueryFactory jQueryFactory, CatalogKey catalogKey, ISortExpression iSortExpression) throws JRScheduleException {
            DataSetCenter dataSetCenter;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "EngineRawDataQueryCreator.createRawDataQuery()..., sort: " + iSortExpression + " dataSetName: " + this.SEDU);
            }
            if ((dataSetCenter = JRptSetEngine.this.rptSetCenter.getDataSetCenter(this.SEDU)) == null) {
                throw new JRScheduleException(250009, (Object[])new String[]{this.SEDU}, null);
            }
            JRawDataQuery jRawDataQuery = JRptSetEngine.this.genRawDataQuery(jQueryFactory, catalogKey, dataSetCenter, iSortExpression, false);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "End of EngineRawDataQueryCreator.createRawDataQuery(), return: " + jRawDataQuery);
            }
            return jRawDataQuery;
        }
    }
}

