/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.cube;

import com.jinfonet.util.JRLog;
import java.sql.Timestamp;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.schema.olap.cursor.CubeCursor;
import jet.dataservice.api.JDataService;
import jet.report.JetRptCTCrossTab;
import jet.rptengine.ContainerInfo;
import jet.rptengine.JReportEngine;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.accessor.cube.CursorManager;
import jet.rptservice.engine.infocenter.CubeViewInfo;
import jet.rptservice.engine.infocenter.ForceExpiredTable;
import jet.util.ScheduleTools;

public class CubeCursorAccessor {
    JReportEngine rptEngine;
    JDataService dataService;
    CursorManager cursorManager;

    public CubeCursorAccessor(JReportEngine jReportEngine) {
        this.rptEngine = jReportEngine;
        this.dataService = jReportEngine.getDataService();
        this.cursorManager = new CursorManager();
    }

    public void init() {
        this.cursorManager.preprocess(null);
    }

    public synchronized CubeCursor getCubeViewCursor(JetRptCTCrossTab jetRptCTCrossTab) throws JRScheduleException, JRStopEngineException {
        if (this.rptEngine.isStopping()) {
            throw new JRStopEngineException(220041, (Object[])new String[]{"engine is stopped when getting cube view cursor."}, null);
        }
        long l = 0L;
        if (JRLog.isTrace(5)) {
            l = System.currentTimeMillis();
            JRLog.trace(5, new String("\n&&&&&&&&&&&&Cube Process:get CubeViewCursor:" + jetRptCTCrossTab + "\n"));
        }
        CubeCursor cubeCursor = null;
        String string = jetRptCTCrossTab.getInstName();
        ContainerInfo containerInfo = this.getContainerInfo(string);
        int n = this.cursorManager.getStatus(string);
        try {
            if (n == 0) {
                int n2 = this.getCubeQueryId(jetRptCTCrossTab);
                String string2 = ScheduleTools.getRawQueryDataSet(jetRptCTCrossTab).getName();
                this.getRptSetEngine().runDataSet(string2, false);
                IBooleanExpression iBooleanExpression = this.rptEngine.getReportViewCenter().getBrowseFilter(jetRptCTCrossTab.getInstName());
                CubeViewInfo cubeViewInfo = containerInfo.getCubeViewInfo();
                this.cursorManager.registerDataContainer(string, n2, cubeViewInfo, this.dataService, iBooleanExpression);
            } else {
                this.cursorManager.resetCubeCursor(string);
            }
            cubeCursor = this.cursorManager.getCursor(string);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException(225002, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)conditionException);
        }
        if (JRLog.isTrace(5)) {
            long l2 = System.currentTimeMillis();
            JRLog.trace(5, new String("#####Get CubeView Cursor: " + string + " : " + (l2 - l)));
        }
        return cubeCursor;
    }

    protected int getCubeQueryId(JetRptCTCrossTab jetRptCTCrossTab) {
        return -1;
    }

    protected JRptSetEngine getRptSetEngine() {
        return this.rptEngine.getRptSetEngine();
    }

    protected ContainerInfo getContainerInfo(String string) {
        return this.rptEngine.getContainerInfo(string);
    }

    public ForceExpiredTable getFET() {
        return null;
    }

    public void submit() throws JRScheduleException {
        if (this.cursorManager != null) {
            this.cursorManager.submitCubeWorkingTable();
        }
    }

    public void closeAllCubeViewCursor() {
        this.cursorManager.closeAllCubeViewCursor();
    }

    public void closeCubeViewCursor(String string) throws JRScheduleException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " closeCubeViewCursor(" + string + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        this.cursorManager.closeCubeViewCursor(string);
    }

    String name() {
        String string = "";
        if (this.rptEngine != null) {
            string = this.rptEngine.name();
        }
        if (string != null && string.length() > 0) {
            string = "of " + string;
        }
        return "CubeCursorAccessor " + string + " ";
    }
}

