/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.cube;

import com.jinfonet.util.JRLog;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.schema.olap.cursor.CubeCursor;
import jet.dataengine.api.schema.olap.cursor.DimensionCursor;
import jet.dataengine.api.schema.olap.cursor.EdgeCursor;
import jet.dataengine.api.schema.olap.enumerations.DimensionStepType;
import jet.dataengine.api.schema.olap.metadata.JMemberList;
import jet.dataengine.api.schema.olap.query.dimensionfilters.MemberListFilter;
import jet.dataengine.api.schema.olap.query.querycoremodel.CubeView;
import jet.dataengine.api.schema.olap.query.querycoremodel.DimensionStepManager;
import jet.dataengine.api.schema.olap.query.querycoremodel.DimensionView;
import jet.dataengine.api.schema.olap.query.querycoremodel.EdgeView;
import jet.dataengine.api.schema.olap.query.querycoremodel.MeasureView;
import jet.dataservice.api.JDataService;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.accessor.cube.CubeViewModel;
import jet.rptservice.engine.accessor.cube.CubeWorkingTable;
import jet.rptservice.engine.accessor.cube.CursorBuilder;
import jet.rptservice.engine.accessor.cube.subject.RptDimensionView;
import jet.rptservice.engine.accessor.cube.subject.RptMeasureView;
import jet.rptservice.engine.infocenter.CubeViewInfo;
import jet.rptservice.engine.infocenter.DimensionDesc;
import jet.rptservice.engine.infocenter.ForceExpiredTable;
import jet.rptservice.engine.infocenter.MDimensionDesc;

public class CursorManager {
    public static final int STATUS_NOTEXIST = 0;
    public static final int STATUS_EXIST = 1;
    private CubeWorkingTable MEMBERLISTFILTER = new CubeWorkingTable();

    CursorManager() {
    }

    void preprocess(ForceExpiredTable forceExpiredTable) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Cube CursorManager.preprocess()..");
        }
        if (forceExpiredTable == null) {
            return;
        }
        List list = forceExpiredTable.getExpiredDataContainers();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            this.closeCubeViewCursor(string);
        }
    }

    void closeCubeViewCursor(String string) {
        block4: {
            CubeCursor cubeCursor = this.MEMBERLISTFILTER.getCursor(string);
            if (cubeCursor != null) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "Cube CursorManager.closeCubeViewCursor(..)   dcinsname: " + string + "  CubeViewCursor: " + cubeCursor);
                }
                try {
                    cubeCursor.close();
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) break block4;
                    JRLog.error(2, dSException);
                }
            }
        }
        this.MEMBERLISTFILTER.removeDataContainer(string);
    }

    void registerDataContainer(String string, int n, CubeViewInfo cubeViewInfo, JDataService jDataService, IExpression iExpression) throws DSException, ConditionException, JRScheduleException, JRStopEngineException {
        if (this.MEMBERLISTFILTER.containsKey(string)) {
            return;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Cube CurosrManager.registerDataContainer(..)..  cubeQueryId: " + n);
        }
        CubeView cubeView = jDataService.createCubeView(n);
        CubeViewModel cubeViewModel = this.MEMBERLISTFILTER(cubeViewInfo);
        if (iExpression != null) {
            this.SEDU(cubeView, cubeViewModel, iExpression);
        }
        CubeCursor cubeCursor = CursorBuilder.builder(cubeView, cubeViewModel);
        this.MEMBERLISTFILTER.addItem(string, cubeView, cubeCursor);
    }

    private CubeViewModel MEMBERLISTFILTER(CubeViewInfo cubeViewInfo) {
        List list = cubeViewInfo.getRowDimDescs();
        List list2 = cubeViewInfo.getColDimDescs();
        List list3 = cubeViewInfo.getMDimDescs();
        int n = list.size();
        int n2 = list2.size();
        int n3 = list3.size();
        RptDimensionView[] rptDimensionViewArray = new RptDimensionView[n];
        for (int i = 0; i < n; ++i) {
            DimensionDesc dimensionDesc = (DimensionDesc)list.get(i);
            int n4 = dimensionDesc.getDepth();
            rptDimensionViewArray[n4] = new RptDimensionView(dimensionDesc.getDimensionName(), dimensionDesc.getBasedFieldName(), dimensionDesc.getSortType());
        }
        RptDimensionView[] rptDimensionViewArray2 = new RptDimensionView[n2];
        for (int i = 0; i < n2; ++i) {
            DimensionDesc dimensionDesc = (DimensionDesc)list2.get(i);
            int n5 = dimensionDesc.getDepth();
            rptDimensionViewArray2[n5] = new RptDimensionView(dimensionDesc.getDimensionName(), dimensionDesc.getBasedFieldName(), dimensionDesc.getSortType());
        }
        RptMeasureView[] rptMeasureViewArray = new RptMeasureView[n3];
        for (int i = 0; i < n3; ++i) {
            MDimensionDesc mDimensionDesc = (MDimensionDesc)list3.get(i);
            rptMeasureViewArray[i] = new RptMeasureView(mDimensionDesc.getMdimensionName(), mDimensionDesc.getBasedFieldName(), mDimensionDesc.getFunctionType(), mDimensionDesc.getCaculateType());
        }
        return new CubeViewModel(rptDimensionViewArray, rptDimensionViewArray2, rptMeasureViewArray);
    }

    private void SEDU(CubeView cubeView, CubeViewModel cubeViewModel, IExpression iExpression) throws DSException, ConditionException, JRScheduleException {
        DimensionView dimensionView;
        String string;
        String string2;
        int n;
        EdgeView edgeView = cubeView.createOrdinateEdge();
        EdgeView edgeView2 = cubeView.createOrdinateEdge();
        RptDimensionView[] rptDimensionViewArray = cubeViewModel.getColDimensions();
        RptDimensionView[] rptDimensionViewArray2 = cubeViewModel.getRowDimensions();
        RptMeasureView[] rptMeasureViewArray = cubeViewModel.getMeasures();
        HashMap hashMap = new HashMap();
        this.analyzeFilterInfo(iExpression, hashMap);
        int n2 = rptDimensionViewArray.length;
        for (n = 0; n < n2; ++n) {
            string2 = rptDimensionViewArray[n].getName();
            string = rptDimensionViewArray[n].getmappingName();
            dimensionView = edgeView.createDimensionView(string2);
            this.add(dimensionView, hashMap, string);
            edgeView.addDimensionView(dimensionView);
        }
        n2 = rptDimensionViewArray2.length;
        for (n = 0; n < n2; ++n) {
            string2 = rptDimensionViewArray2[n].getName();
            string = rptDimensionViewArray2[n].getmappingName();
            dimensionView = edgeView2.createDimensionView(string2);
            this.add(dimensionView, hashMap, string);
            edgeView2.addDimensionView(dimensionView);
        }
        MeasureView measureView = edgeView.createMeasreView();
        edgeView.addDimensionView(measureView);
    }

    private void add(DimensionView dimensionView, HashMap hashMap, String string) throws DSException {
        if (!hashMap.containsKey(string)) {
            return;
        }
        List list = (List)hashMap.get(string);
        DimensionStepManager dimensionStepManager = dimensionView.createDimensionStepManager();
        MemberListFilter memberListFilter = (MemberListFilter)dimensionStepManager.createDimensionStep(DimensionStepType.MEMBERLISTFILTER);
        JMemberList jMemberList = memberListFilter.getMemberList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            jMemberList.addMember((String)list.get(i));
        }
        memberListFilter.setMemberList(jMemberList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void analyzeFilterInfo(IExpression iExpression, HashMap hashMap) throws ConditionException, JRScheduleException {
        int n = iExpression.expressionType();
        if (!ExpressionToolKit.isBooleanExp(n)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
        if (ExpressionToolKit.isLogicExp(n)) {
            if (!ExpressionToolKit.isBinaryLogicExp(n)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
            IBinaryLogicExpression iBinaryLogicExpression = (IBinaryLogicExpression)iExpression;
            IExpression iExpression2 = iBinaryLogicExpression.getExpression1();
            IExpression iExpression3 = iBinaryLogicExpression.getExpression2();
            int n2 = iBinaryLogicExpression.getOperator().operatorType();
            if (!OperatorToolKit.isAnd(n2)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
            this.analyzeFilterInfo(iExpression2, hashMap);
            this.analyzeFilterInfo(iExpression3, hashMap);
            return;
        } else {
            if (!ExpressionToolKit.isBinaryConditionExp(n)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
            IBinaryConditionExpression iBinaryConditionExpression = (IBinaryConditionExpression)iExpression;
            IExpression iExpression4 = iBinaryConditionExpression.getExpression1();
            IExpression iExpression5 = iBinaryConditionExpression.getExpression2();
            int n3 = iBinaryConditionExpression.getOperator().operatorType();
            if (!OperatorToolKit.isEquals(n3)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
            String string = this.addDimensionView(iExpression4);
            String string2 = this.addDimensionView(iExpression5);
            this.addItem(hashMap, string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String addDimensionView(IExpression iExpression) throws ConditionException, JRScheduleException {
        int n = iExpression.expressionType();
        String string = new String();
        if (!ExpressionToolKit.isVariableExp(n)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
        if (ExpressionToolKit.isReference(n)) {
            IReference iReference = (IReference)iExpression;
            return iReference.getAttributeName();
        }
        if (ExpressionToolKit.isConstant(n)) {
            IConstant iConstant = (IConstant)iExpression;
            return iConstant.getName();
        }
        if (ExpressionToolKit.isFormula(n)) {
            IFormula iFormula = (IFormula)iExpression;
            return iFormula.getName();
        }
        if (!ExpressionToolKit.isParameter(n)) throw new JRScheduleException(0x225521, (Object[])new String[]{"IExpression format error while doing cube drill filter"}, null);
        IParameter iParameter = (IParameter)iExpression;
        return iParameter.getName();
    }

    private void addItem(HashMap hashMap, String string, String string2) {
        if (hashMap.containsKey(string)) {
            List list = (List)hashMap.get(string);
            list.add(string2);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string2);
            hashMap.put(string, string2);
        }
    }

    CubeCursor getCursor(String string) {
        CubeCursor cubeCursor = this.MEMBERLISTFILTER.getCursor(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CursorManager.getCursor(..):  dcInsName" + string + "  CubeViewCurosr: " + cubeCursor);
        }
        this.MEMBERLISTFILTER.setNeedResetCursor(string, true);
        return cubeCursor;
    }

    void resetCubeCursor(String string) throws DSException {
        if (this.MEMBERLISTFILTER.isNeedResetCursor(string)) {
            CubeCursor cubeCursor = this.MEMBERLISTFILTER.getCursor(string);
            List list = cubeCursor.getOrdinateEdge();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                EdgeCursor edgeCursor = (EdgeCursor)list.get(i);
                List list2 = edgeCursor.getDimensionCursor();
                int n2 = list2.size();
                for (int j = 0; j < n2; ++j) {
                    DimensionCursor dimensionCursor = (DimensionCursor)list2.get(j);
                    dimensionCursor.beforeFirst();
                }
            }
        }
        this.MEMBERLISTFILTER.setNeedResetCursor(string, false);
    }

    void submitCubeWorkingTable() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Cube CursorManager.submitCubeWorkingTable()");
        }
        this.MEMBERLISTFILTER.submit();
    }

    int getStatus(String string) {
        return this.MEMBERLISTFILTER.getStatus(string);
    }

    void closeAllCubeViewCursor() {
        this.addMember();
    }

    private void addMember() {
        List list = this.MEMBERLISTFILTER.getAllDCInsname();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.closeCubeViewCursor(string);
        }
        this.MEMBERLISTFILTER.clear();
    }
}

