/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.group;

import com.jinfonet.util.JRLog;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.dataengine.api.DSException;
import jet.dataengine.api.GoProcessor;
import jet.dataengine.api.Group;
import jet.dataengine.api.SortInfo;
import jet.dataengine.api.SortProcessor;
import jet.dataengine.api.config.DbBufferConfig;
import jet.dataengine.api.config.DbBufferConfigImpl;
import jet.dataengine.api.crosstabdata.CrosstabDataResult;
import jet.dataengine.api.dbbuffer.RecordModelInfo;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.query.JCrossTableQuery;
import jet.dataengine.api.query.JCubeViewQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.groupengine.GroupModel;
import jet.dataservice.api.JDataService;
import jet.exception.InvalidParameterException;
import jet.formula.FormulaQueue;
import jet.formula.JavaFormula;
import jet.formula.JavaFormulaContainer;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptObject;
import jet.report.JetRptSort;
import jet.report.JetRptSortContainer;
import jet.report.onTheFlyFormula.Scope;
import jet.reportset.DataSet;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.rptengine.ContainerInfo;
import jet.rptengine.JCommunicator;
import jet.rptengine.JReportEngine;
import jet.rptengine.JSubLinkContainer;
import jet.rptengine.RptFilterInfoContainer;
import jet.rptengine.componentLayoutInfo.LayoutInfo;
import jet.rptengine.util.EngineTools;
import jet.rptservice.IQueryIDFetcher;
import jet.rptservice.api.IDataResultInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.accessor.group.GTManager;
import jet.rptservice.engine.accessor.group.GTResuleInfo;
import jet.rptservice.engine.accessor.group.InheritQueryIdManager;
import jet.rptservice.engine.accessor.group.QueryBuilder;
import jet.rptservice.engine.accessor.group.QueryIdRelationManager;
import jet.rptservice.engine.accessor.group.QueryManager;
import jet.rptservice.engine.accessor.group.QueryRuntimeInfo;
import jet.rptservice.engine.infocenter.GoToInfo;
import jet.rptservice.impl.DCResourceInfoImpl;
import jet.rptservice.impl.DataResultInfoImpl;
import jet.rptservice.pub.ContainerGTManagerInfo;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.SubLinkProcessor;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.exception.CannotFindEntity;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;
import jet.va.vctData.VCTCubeViewResult;

public class GTAccessor
implements IQueryIDFetcher {
    JReportEngine rptEngine;
    private QueryManager DATASET_HDS;
    GTManager gtManager;
    GoProcessor goToProcessor;
    SortProcessor sortProcessor;
    QueryBuilder queryBuilder;
    QueryIdRelationManager idManager = new QueryIdRelationManager();
    IntKeyHashtable htRptQueryInfos = new IntKeyHashtable();
    IntVector vecNoCachedByPValue = new IntVector();
    IntVector vecPreparedId = null;
    Hashtable htExceptions;
    HashMap reUsedQueryIds = null;
    InheritQueryIdManager inheritIdManager = new InheritQueryIdManager();
    Hashtable params = null;
    IntVector vecGId_commGT = null;
    IntVector vecCId_commGT = null;

    public GTAccessor(JReportEngine jReportEngine, Hashtable hashtable) {
        this(jReportEngine, hashtable, true);
    }

    public GTAccessor(JReportEngine jReportEngine, Hashtable hashtable, boolean bl) {
        this.rptEngine = jReportEngine;
        JDataService jDataService = jReportEngine.getRptSetEngine().getDataService();
        this.DATASET_HDS = new QueryManager(jDataService, jDataService.getQueryFactory());
        this.params = hashtable;
        if (bl) {
            this.gtManager = new GTManager();
        }
    }

    QueryManager getQueryManager() {
        return this.DATASET_HDS;
    }

    public void init(Hashtable hashtable) throws JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " init(...) begin at:" + new Timestamp(System.currentTimeMillis()) + " , htDCContexts = " + hashtable);
        }
        if (hashtable != null) {
            this.gtManager.init(hashtable, this.DATASET_HDS);
        }
        List list = this.gtManager.preprocess();
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)list.get(i);
            this.htRptQueryInfos.remove(n);
            this.vecNoCachedByPValue.removeElement(n);
        }
        this.build(list);
        if (this.vecPreparedId != null) {
            this.vecPreparedId.removeAllElements();
            this.vecPreparedId = null;
        }
        this.reUsedQueryIds = this.gtManager.getAllQueryIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess() throws JRScheduleException, JRStopEngineException {
        if (this.vecPreparedId == null) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, this.name() + " preprocess() begin at:" + new Timestamp(System.currentTimeMillis()));
            }
            this.vecPreparedId = new IntVector();
            HashMap hashMap = this.reUsedQueryIds;
            String string = null;
            ArrayList arrayList = null;
            int n = hashMap.size();
            if (n > 0) {
                if (this.goToProcessor == null) {
                    this.goToProcessor = new GoProcessor();
                }
                String[] stringArray = hashMap.keySet().toArray(new String[0]);
                Group group = null;
                IDataContainer iDataContainer = null;
                JavaFormulaContainer javaFormulaContainer = null;
                JQuery jQuery = null;
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = stringArray[i];
                        arrayList = (ArrayList)hashMap.get(string);
                        ContainerInfo containerInfo = this.rptEngine.getContainerInfo(string);
                        iDataContainer = containerInfo.getContainer();
                        GoToInfo goToInfo = null;
                        for (int j = 0; j < arrayList.size(); ++j) {
                            int n2 = (Integer)arrayList.get(j);
                            jQuery = this.DATASET_HDS.getQuery(n2);
                            boolean bl = true;
                            if (jQuery instanceof JCrossTableQuery || jQuery instanceof JGroupQuery && ((JGroupQuery)jQuery).isRealtimeQuery()) {
                                bl = false;
                            }
                            if (bl) {
                                int n3;
                                group = this.DATASET_HDS.getResult(n2);
                                if (group != null) {
                                    if (this.rptEngine.isRestart()) {
                                        group.resetCursor();
                                    } else {
                                        javaFormulaContainer = containerInfo.getJavaFormula();
                                        goToInfo = this.I(iDataContainer);
                                        if (JRLog.isTrace(5)) {
                                            String string2 = this.name();
                                            JRLog.trace(5, string2 + " goToProcessor.doProcess on Data Container [" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()) + ", group = " + group + ", gotoInfo = " + goToInfo + ", needReSet = " + true + ", javaFormula = " + javaFormulaContainer);
                                        }
                                        try {
                                            this.goToProcessor.doProcess(goToInfo, group, javaFormulaContainer, true);
                                        }
                                        catch (DSException dSException) {
                                            n3 = dSException.getPartMessKey();
                                            if (n3 == 4081) {
                                                if (JRLog.isTrace(6)) {
                                                    JRLog.trace(6, dSException);
                                                }
                                            }
                                            throw dSException;
                                        }
                                    }
                                }
                                int n4 = ((DbBigInt)this.DATASET_HDS.getSpecialField(n2, 4)).intValue();
                                n3 = ((DbBigInt)this.DATASET_HDS.getSpecialField(n2, 5)).intValue();
                                JCommunicator jCommunicator = this.rptEngine.getCommunicator();
                                if (jCommunicator != null) {
                                    jCommunicator.storeTotalRecords(n2, true, n4);
                                    jCommunicator.storeTotalRecords(n2, false, n3);
                                }
                                if (JRLog.isTrace(5)) {
                                    JRLog.trace(5, this.name() + " reset group trees: for data container [" + string + "], queryIndex = " + j);
                                }
                            }
                            this.vecPreparedId.addElement(n2);
                            if (this.isSingleThread()) continue;
                            GTAccessor gTAccessor = this;
                            synchronized (gTAccessor) {
                                this.notifyAll();
                                continue;
                            }
                        }
                        if (!JRLog.isTrace(5)) continue;
                        JRLog.trace(5, this.name() + " preprocess() end at:" + new Timestamp(System.currentTimeMillis()) + ", vecPreparedId = " + this.vecPreparedId);
                    }
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IDataResultInfo getDataResultInfo(IDataContainer iDataContainer, JSubLinkContainer jSubLinkContainer, boolean bl, Group group) throws JRScheduleException, JRStopEngineException {
        DataResultInfoImpl dataResultInfoImpl = new DataResultInfoImpl();
        Group group2 = null;
        CrosstabDataResult crosstabDataResult = null;
        VCTCubeViewResult vCTCubeViewResult = null;
        String string = iDataContainer.getInstName();
        int n = -1;
        int n2 = -1;
        JRScheduleException jRScheduleException = null;
        ContainerInfo containerInfo = this.getContainerInfo(string);
        int n3 = -1;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getDataResultInfo(" + string + ") begin at:" + new Timestamp(System.currentTimeMillis()) + ", subLinkContainer = " + jSubLinkContainer + ", bCached = " + bl + ", inheritCurrGroup = " + group);
        }
        try {
            long l;
            block93: {
                if (this.rptEngine.isStopping()) {
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, this.name() + " STOP In GTAccessor.getDataResultInfo().");
                    }
                    throw new JRStopEngineException(225026, (Object[])new String[]{"engine is stopped when getting data result info."}, null);
                }
                boolean bl2 = containerInfo.canGetQuery();
                if (!bl2) {
                    throw new JRScheduleException(225012, (Object[])new String[]{string, " canGetQuery is false. Please layout group to check the schedule logic."}, null);
                }
                l = 0L;
                if (JRLog.isTrace(5)) {
                    l = System.currentTimeMillis();
                }
                JQuery jQuery = null;
                JQuery[] jQueryArray = null;
                int n4 = this.gtManager.getStatus(string);
                try {
                    IntKeyHashtable[] intKeyHashtableArray;
                    String string2;
                    long l2;
                    long l3;
                    if (n4 == 1 && !this.gtManager.canMoveGTCursor(string)) {
                        this.gtManager.prepareReCreating(string);
                        n4 = this.gtManager.getStatus(string);
                    }
                    this.buildCommGroup(containerInfo, jSubLinkContainer);
                    if (n4 != 1) {
                        if (this.queryBuilder == null) {
                            this.queryBuilder = new QueryBuilder(this);
                        }
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, this.name() + " prepare to build new query In GTAccessor.getDataResultInfo(). Now the status in GTManager is " + n4);
                        }
                        jQueryArray = this.queryBuilder.build(iDataContainer, jSubLinkContainer, bl, containerInfo, -1, group);
                        jQuery = jQueryArray[jQueryArray.length - 1];
                    } else if (this.gtManager.canMoveGTCursor(string)) {
                        Object object;
                        n3 = this.gtManager.getCursorPosition(string);
                        if (!this.gtManager.hasMoreDataQuery(string)) {
                            int n5 = this.gtManager.getNextCompQueryId(string);
                            object = this.queryBuilder.build(iDataContainer, jSubLinkContainer, bl, containerInfo, n5, group);
                            jQuery = object[((JQuery[])object).length - 1];
                        } else {
                            n = this.gtManager.getNextDataQueryId(string);
                            if (!this.isSingleThread()) {
                                while (this.vecPreparedId == null || !this.vecPreparedId.contains(n)) {
                                    if (this.rptEngine.isError() || this.rptEngine.isStopping()) {
                                        if (JRLog.isTrace(5)) {
                                            JRLog.trace(5, this.name() + " STOP In GTAccessor.getDataResultInfo().");
                                        }
                                        throw new JRStopEngineException(225026, (Object[])new String[]{"engine is stopped when getting dataResultInfo because occur error on JReportEngine or engine has stopped!"}, null);
                                    }
                                    this.wait(100L);
                                }
                            }
                            FormulaQueue formulaQueue = null;
                            object = this.DATASET_HDS.getQuery(n);
                            if (object instanceof JCubeViewQuery) {
                                vCTCubeViewResult = this.DATASET_HDS.getVCTCubeViewResult(n);
                                dataResultInfoImpl.setCubeViewDataResult(vCTCubeViewResult);
                            } else if (object instanceof JCrossTableQuery) {
                                crosstabDataResult = this.DATASET_HDS.getCrosstabResult(n);
                                dataResultInfoImpl.setCrosstabDataResult(crosstabDataResult);
                            } else {
                                group2 = this.DATASET_HDS.getResult(n);
                                dataResultInfoImpl.setGroupTree(group2);
                                boolean bl3 = this.rptEngine.isRestart();
                                if (group2 != null) {
                                    this.DATASET_HDS.dataProcess(new GTResuleInfo(n, bl3));
                                }
                                if (object instanceof JGroupQuery) {
                                    formulaQueue = ((JGroupQuery)object).getFormulaQueue();
                                } else if (object instanceof JHDSQuery) {
                                    formulaQueue = ((JHDSQuery)object).getFormulaQueue();
                                }
                                if (formulaQueue != null) {
                                    containerInfo.setFormulaQueue(formulaQueue);
                                }
                                if (group2 != null) {
                                    containerInfo.setGroupModel(group2.getGroupModel());
                                }
                            }
                            dataResultInfoImpl.setLayoutInfo(this.gtManager.getNextDataQueryLayoutInfo(string));
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, this.name() + "...  status In GTAccessor.getDataResultInfo() is " + n4 + ", queryIndex = " + n3 + " (reuse data result)");
                            }
                            this.gtManager.moveDataQueryCursor(string);
                        }
                    } else {
                        throw new JRScheduleException(225016, (Object[])new String[]{string}, null);
                    }
                    long l4 = 0L;
                    long l5 = 0L;
                    long l6 = 0L;
                    boolean bl4 = false;
                    JavaFormula javaFormula = null;
                    if (jQuery != null) {
                        n = jQuery.getQueryId();
                        if (JRLog.isTrace(4)) {
                            l4 = System.currentTimeMillis();
                        }
                        if (jQueryArray != null) {
                            this.DATASET_HDS.prepareQuery(jQueryArray);
                        } else if (jQuery != null) {
                            this.DATASET_HDS.prepareQuery(new JQuery[]{jQuery});
                        }
                        if (JRLog.isTrace(4)) {
                            l5 = System.currentTimeMillis();
                            l6 = l5 - l4;
                            String string3 = this.name();
                            JRLog.trace(4, 5225013, new Object[]{string3, string, new Integer(n), new Long(l6).toString()});
                        }
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, this.name() + " register data container[" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()) + ", queryId = " + n);
                        }
                        if (jQueryArray != null) {
                            int n6 = jQueryArray[0].getQueryId();
                            int n7 = jQueryArray[1].getQueryId();
                            n3 = this.gtManager.registerDataContainer(string, n6, true, n7, null, true);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, this.name() + " \tPrint Query(cQuery) infor for data container[" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()));
                                ContainerInfo.printQuery(jQueryArray[0]);
                                JRLog.trace(5, this.name() + " \tPrint Query(dataQuery) infor for data container[" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()));
                                ContainerInfo.printQuery(jQueryArray[1]);
                            }
                        } else if (jQuery != null) {
                            int n8 = jQuery.getQueryId();
                            n3 = this.gtManager.registerDataContainer(string, n8, null, true);
                            if (JRLog.isTrace(5)) {
                                JRLog.trace(5, this.name() + " \tPrint Query(dataQuery) infor for data container[" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()));
                                ContainerInfo.printQuery(jQuery);
                            }
                        }
                        if (JRLog.isTrace(4)) {
                            l4 = System.currentTimeMillis();
                        }
                        if (jQuery instanceof JCubeViewQuery) {
                            vCTCubeViewResult = this.DATASET_HDS.getVCTCubeViewResult(n);
                            dataResultInfoImpl.setCubeViewDataResult(vCTCubeViewResult);
                        } else if (jQuery instanceof JCrossTableQuery) {
                            crosstabDataResult = this.DATASET_HDS.getCrosstabResult(n);
                            dataResultInfoImpl.setCrosstabDataResult(crosstabDataResult);
                        } else {
                            group2 = this.DATASET_HDS.getResult(n);
                            dataResultInfoImpl.setGroupTree(group2);
                        }
                        dataResultInfoImpl.setLayoutInfo(null);
                        if (JRLog.isTrace(4)) {
                            l5 = System.currentTimeMillis();
                            l6 = l5 - l4;
                            String string4 = this.name();
                            JRLog.trace(4, 5225022, new Object[]{string4, string, new Integer(n), new Long(l6).toString()});
                        }
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, this.name() + "...  status In GTAccessor.getDataResultInfo() is " + n4 + ", queryIndex = " + n3 + " (build new query to get data result)");
                        }
                        if (group2 != null) {
                            GoToInfo goToInfo = null;
                            goToInfo = this.I(iDataContainer);
                            if (goToInfo != null) {
                                long l7 = 0L;
                                l3 = 0L;
                                l2 = 0L;
                                if (JRLog.isTrace(5)) {
                                    l7 = System.currentTimeMillis();
                                }
                                if (this.goToProcessor == null) {
                                    this.goToProcessor = new GoProcessor();
                                }
                                group2.waitWholeReady();
                                if (this.rptEngine.isStopping()) {
                                    if (JRLog.isTrace(5)) {
                                        JRLog.trace(5, this.name() + " STOP In GTAccessor.getDataResultInfo().");
                                    }
                                    throw new JRStopEngineException(225026, (Object[])new String[]{"engine is stopped when getting group  tree."}, null);
                                }
                                if (JRLog.isTrace(5)) {
                                    string2 = this.name();
                                    JRLog.trace(5, string2 + " goToProcessor.doProcess on Data Container [" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()) + ", group = " + group2 + ", gotoInfo = " + goToInfo + ", needReSet = " + bl4);
                                }
                                this.goToProcessor.doProcess(goToInfo, group2, javaFormula, bl4);
                                if (JRLog.isTrace(5)) {
                                    l3 = System.currentTimeMillis();
                                    l2 = l3 - l7;
                                    string2 = this.name();
                                    JRLog.trace(5, string2 + " process goToInfo on Data Container [" + string + "] , [ELAPSED]: " + l2 + " ms.");
                                }
                            }
                        }
                    } else if (JRLog.isTrace(5)) {
                        String string5 = this.name();
                        JRLog.trace(5, string5 + " get reuse data result on Data Container [" + string + "] begin at:" + new Timestamp(System.currentTimeMillis()) + ", dataResultInfo = " + dataResultInfoImpl + ", queryId = " + n);
                    }
                    if (group2 != null && !this.rptEngine.isRestart() && (intKeyHashtableArray = this.SEDU(iDataContainer, containerInfo)) != null && intKeyHashtableArray.length > 0) {
                        long l8 = 0L;
                        l3 = 0L;
                        l2 = 0L;
                        if (JRLog.isTrace(5)) {
                            l8 = System.currentTimeMillis();
                        }
                        this.DATASET_HDS(intKeyHashtableArray, group2);
                        if (JRLog.isTrace(5)) {
                            l3 = System.currentTimeMillis();
                            l2 = l3 - l8;
                            string2 = this.name();
                            JRLog.trace(5, string2 + " process sortInfo on Data Container [" + string + "] , [ELAPSED]: " + l2 + " ms.");
                        }
                    }
                    if (n != -1) {
                        IntVector intVector;
                        JRawDataQuery jRawDataQuery = this.DATASET_HDS.getRootRawQuery(n);
                        if (jRawDataQuery != null) {
                            n2 = jRawDataQuery.getQueryId();
                        }
                        if (n2 != -1 && (intVector = containerInfo.getDelayClosedRQueryIds()) != null && !intVector.contains(n2)) {
                            for (int i = 0; i < intVector.size(); ++i) {
                                int n9 = intVector.elementAt(i);
                                if (JRLog.isTrace(5)) {
                                    String string6 = this.name();
                                    l2 = System.currentTimeMillis();
                                    JRLog.trace(5, string6 + "\t... delay to close all of rawQueries, which need to be closed:  on Data Container [" + string + "] , rid = " + n9);
                                }
                                this.closeLocalRQueryByRawId(n9);
                            }
                            intVector.removeAllElements();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) break block93;
                    JRLog.error(2, interruptedException);
                }
            }
            if (JRLog.isTrace(5)) {
                String string7 = this.name();
                long l9 = System.currentTimeMillis();
                JRLog.trace(5, 5225020, new Object[]{string7, string, new Integer(n), new Long(l9 - l).toString()});
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof JRStopEngineException) {
                throw (JRStopEngineException)throwable;
            }
            if (throwable instanceof JRScheduleException) {
                jRScheduleException = (JRScheduleException)throwable;
            } else {
                GTAccessor gTAccessor;
                int n10;
                if (throwable instanceof DSException && (n10 = ((DSException)throwable).getPartMessKey()) == 4081) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, throwable);
                    }
                    gTAccessor = null;
                }
                if (gTAccessor != null) {
                    jRScheduleException = new JRScheduleException(225023, (Object[])new String[]{string}, (Throwable)((Object)gTAccessor));
                }
            }
        }
        finally {
            containerInfo.setCurrQid(n);
            containerInfo.setCurrRQId(n2);
            if (this.htExceptions == null) {
                this.htExceptions = new Hashtable();
            }
            if (jRScheduleException != null) {
                this.htExceptions.put(string, jRScheduleException);
                throw jRScheduleException;
            }
            this.htExceptions.remove(string);
            if (!this.isSingleThread()) {
                GTAccessor gTAccessor = this;
                synchronized (gTAccessor) {
                    this.notifyAll();
                }
            }
        }
        DCResourceInfoImpl dCResourceInfoImpl = new DCResourceInfoImpl();
        dCResourceInfoImpl.setDisplayRoundingMode(EngineTools.getDisplayRoundingMode(iDataContainer, this.getUniverse()));
        dCResourceInfoImpl.setDenyList(containerInfo.getDenyList());
        dataResultInfoImpl.setDCResourceInfo(dCResourceInfoImpl);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getDataResultInfo(" + string + "): queryId = " + n + ", dataResultInfo = " + dataResultInfoImpl);
        }
        return dataResultInfoImpl;
    }

    private void DATASET_HDS(IntKeyHashtable[] intKeyHashtableArray, Group group) throws JRStopEngineException, InterruptedException {
        Object object;
        if (this.sortProcessor == null) {
            this.sortProcessor = new SortProcessor();
        }
        group.waitWholeReady();
        if (this.rptEngine.isStopping()) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, this.name() + " STOP In GTAccessor.doSortProcessor().");
            }
            throw new JRStopEngineException(225026, (Object[])new String[]{"engine is stopped when do sort processor."}, null);
        }
        int n = this.rptEngine.getSortMemorySize();
        if (JRLog.isTrace(5)) {
            object = this.name();
            JRLog.trace(5, (String)object + " sortProcessor.doSort begin at:" + new Timestamp(System.currentTimeMillis()) + ", group = " + group + ", sortInfo = " + intKeyHashtableArray + ", sortMemorySize = " + n);
        }
        object = new DbBufferConfigImpl(this.rptEngine.getReportEngineEnv().getResourceStore());
        this.sortProcessor.doSort(intKeyHashtableArray, group, n, (DbBufferConfig)object);
    }

    public HashMap getreUsedQueryIds() {
        return this.gtManager == null ? null : this.gtManager.getAllQueryIds();
    }

    protected void RegisterLocalRawQueryId(int n, int n2, int n3) {
        this.idManager.registQueryIds(n, n2, n3);
    }

    protected void collectDataQueryId(int n, int n2) {
        this.idManager.collectDataQueryId(n, n2);
    }

    protected void collectLocalRawQueryInfo(int n, int n2, int n3) {
        this.idManager.collectQueryIds(n, n2, n3);
    }

    protected void collectRuntimeQueryInfo(int n, QueryRuntimeInfo queryRuntimeInfo) {
        if (n != -1 && queryRuntimeInfo != null) {
            this.htRptQueryInfos.put(n, queryRuntimeInfo);
        }
    }

    public boolean isCacheRQuery(int n) {
        boolean bl = true;
        QueryRuntimeInfo queryRuntimeInfo = (QueryRuntimeInfo)this.htRptQueryInfos.get(n);
        if (queryRuntimeInfo != null) {
            bl = queryRuntimeInfo.isCacheRQuery();
        }
        return bl;
    }

    protected void collectNoCachedQIdByPValue(int n) {
        if (n != -1) {
            this.vecNoCachedByPValue.addElement(n);
        }
    }

    public boolean isNoCachedByPValue(int n) {
        boolean bl = false;
        if (this.vecNoCachedByPValue != null && this.vecNoCachedByPValue.contains(n)) {
            bl = true;
        }
        return bl;
    }

    protected IntVector getAllLocalRawQuerys() {
        return this.idManager.getAllFirstIds();
    }

    private GoToInfo I(IDataContainer iDataContainer) {
        return this.rptEngine.getReportViewCenter().getGotoInfo(iDataContainer.getInstName());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private IntKeyHashtable[] SEDU(IDataContainer iDataContainer, ContainerInfo containerInfo) throws DSException, CannotFindEntity {
        if (JRLog.isTrace(5)) {
            JRLog.trace(6, this.name() + " getSortInfo... for Data Container [" + iDataContainer.getInstName() + "] begin...");
        }
        JetRptSortContainer jetRptSortContainer = this.rptEngine.getReportEngineEnv().getBrowseSortContainer(iDataContainer.getInstName());
        JetRptDataSet jetRptDataSet = (JetRptDataSet)ReportTools.getDataSet((JetRptObject)((Object)iDataContainer));
        if (jetRptSortContainer == null) {
            return null;
        }
        Vector vector = jetRptSortContainer.getChildren();
        IntKeyHashtable[] intKeyHashtableArray = null;
        int n = vector.size();
        if (n > 0) {
            Object object;
            Object object2;
            Object object3;
            intKeyHashtableArray = new IntKeyHashtable[]{new IntKeyHashtable(), new IntKeyHashtable()};
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            HashMap<RecordModelInfo, Integer> hashMap2 = new HashMap<RecordModelInfo, Integer>();
            for (GroupModel groupModel = containerInfo.getGroupModel(); groupModel != null; groupModel = groupModel.nextToMe()) {
                object3 = new Integer(groupModel.getGroupIndex());
                if (groupModel.getPreprocess() != null) {
                    String string = groupModel.getGroupByName();
                    object2 = new Integer(groupModel.prevGroupModel().getGroupIndex());
                    if (!hashMap.containsKey(string)) {
                        hashMap.put(string, (Integer)object2);
                    }
                }
                if (groupModel.nextGroupModel() != null) continue;
                hashMap2.put(groupModel.getRecordModelInfo(), (Integer)object3);
            }
            object3 = null;
            int n2 = -1;
            object2 = null;
            boolean bl = false;
            IntKeyHashtable intKeyHashtable = new IntKeyHashtable();
            Hashtable hashtable = this.getParameters();
            Scope scope = new Scope(this.getUniverse(), this.getRptReport(), jetRptDataSet);
            HashSet hashSet = containerInfo.getDenyList();
            for (int i = 0; i < n; ++i) {
                Object object4;
                ParamDesc paramDesc;
                Object object5;
                block22: {
                    object2 = (JetRptSort)vector.elementAt(i);
                    if (((JetRptSort)object2).isBLColumnName()) {
                        object5 = ((JetRptSort)object2).getColumn();
                        if (hashSet == null || !hashSet.contains(object5)) {
                            BLNode bLNode = scope.getBLNodeByQualifiedDisplayName((String)object5);
                            object3 = ((DataElementInfo)bLNode).getRefMappingName();
                            break block22;
                        } else {
                            if (!JRLog.isTrace(5)) continue;
                            JRLog.trace(6, this.name() + " getSortInfo... " + i + " *** columnName = " + ((JetRptSort)object2).getColumn() + ", isBLColumnName = " + ((JetRptSort)object2).isBLColumnName() + ", name = " + (String)object3 + ", sortType = " + n2 + " ****** ignore it, for denyList in it.");
                            continue;
                        }
                    }
                    object3 = ((JetRptSort)object2).getColumn();
                }
                if ((paramDesc = (ParamDesc)hashtable.get(object3)) != null) {
                    object3 = paramDesc.getValue().toString().toUpperCase();
                }
                int n3 = n2 = ((JetRptSort)object2).isAsc() ? 0 : 1;
                if (JRLog.isTrace(5)) {
                    JRLog.trace(6, this.name() + " getSortInfo... " + i + " *** columnName = " + ((JetRptSort)object2).getColumn() + ", isBLColumnName = " + ((JetRptSort)object2).isBLColumnName() + ", name = " + (String)object3 + ", sortType = " + n2);
                }
                if ((object5 = this.addElement(containerInfo, (String)object3)) == null) {
                    throw new CannotFindEntity((String)object3);
                }
                ((DbColDesc)object5).setColName((String)object3);
                bl = false;
                int n4 = -1;
                if (hashMap.containsKey(object3)) {
                    n4 = (Integer)hashMap.get(object3);
                    object4 = new SortInfo(n4, new DbColDesc[]{object5}, new int[]{n2});
                    intKeyHashtableArray[0].put(n4, object4);
                    bl = true;
                } else {
                    object4 = hashMap2.keySet();
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        void var26_33;
                        object = (RecordModelInfo)iterator.next();
                        if (((RecordModelInfo)object).indexOfCell((String)object3) == -1) continue;
                        n4 = (Integer)hashMap2.get(object);
                        Object var26_34 = null;
                        if (!intKeyHashtable.containsKey(n4)) {
                            ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
                            intKeyHashtable.put(n4, arrayListArray);
                        } else {
                            ArrayList[] arrayListArray = (ArrayList[])intKeyHashtable.get(n4);
                        }
                        var26_33[0].add(object5);
                        var26_33[1].add(new Integer(n2));
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                throw new DSException(4084, new String[]{object3});
            }
            if (intKeyHashtable.size() > 0) {
                IntVector intVector = intKeyHashtable.keys();
                int n5 = -1;
                ArrayList[] arrayListArray = null;
                for (int i = 0; i < intVector.size(); ++i) {
                    void var26_39;
                    n5 = intVector.elementAt(i);
                    arrayListArray = (ArrayList[])intKeyHashtable.get(n5);
                    int n6 = arrayListArray[0].size();
                    object = new DbColDesc[n6];
                    boolean bl2 = false;
                    while (var26_39 < n6) {
                        object[var26_39] = (DbColDesc)arrayListArray[0].get((int)var26_39);
                        ++var26_39;
                    }
                    int[] nArray = new int[n6];
                    for (int j = 0; j < n6; ++j) {
                        nArray[j] = (Integer)arrayListArray[1].get(j);
                    }
                    SortInfo sortInfo = new SortInfo(n5, (DbColDesc[])object, nArray);
                    intKeyHashtableArray[1].put(n5, sortInfo);
                }
            }
        }
        return intKeyHashtableArray;
    }

    protected int getNewSeriaNo() {
        return this.rptEngine.getNewSeriaNo();
    }

    protected SubLinkProcessor getSubLinkProcessor() {
        return this.rptEngine.getSubLinkProcessor();
    }

    protected Hashtable getParameters() {
        return this.rptEngine.getReportEngineEnv().getParameters();
    }

    protected JRawDataQuery getShareRawDataQuery(IDataContainer iDataContainer) throws JRScheduleException {
        return this.rptEngine.getShareRawDataQuery(iDataContainer);
    }

    JetUUniverse getUniverse() {
        return this.rptEngine.getReportEngineEnv().getUniverse();
    }

    private FormulaQueue TYPE_CONTAINER_FILTER_SUBLINK(IDataContainer iDataContainer) {
        return this.rptEngine.getFormulaQueue(iDataContainer);
    }

    JRptSetEngine getRptSetEngine() {
        return this.rptEngine.getRptSetEngine();
    }

    private Hashtable add(IDataContainer iDataContainer, int n, ContainerInfo containerInfo) throws JRScheduleException {
        return this.rptEngine.getBranchToFilter(iDataContainer, n, containerInfo);
    }

    JetRptReport getRptReport() {
        return this.rptEngine.getReport();
    }

    boolean isSingleThread() {
        return this.rptEngine.getReportEngineEnv().isSingleThread();
    }

    Vector getListeners() {
        return this.rptEngine.getListeners();
    }

    boolean isDbBufferFast() {
        return this.rptEngine.isDbBufferFast();
    }

    private DbColDesc addElement(ContainerInfo containerInfo, String string) {
        return this.rptEngine.getSQLType(containerInfo, string);
    }

    ContainerInfo getContainerInfo(String string) {
        return this.rptEngine.getContainerInfo(string);
    }

    public int getQueryIndex(IDataContainer iDataContainer, Group group) throws JRScheduleException, JRStopEngineException {
        String string = iDataContainer.getInstName();
        int n = -1;
        try {
            n = this.gtManager.getQueryIndex(string, group, this.DATASET_HDS);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
        }
        return n;
    }

    public int getQueryIndex(IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        return this.gtManager.getQueryIndex(iDataContainer.getInstName(), n);
    }

    public synchronized int getCurrQueryId(IDataContainer iDataContainer) throws JRScheduleException, JRStopEngineException {
        int n = -1;
        String string = iDataContainer.getInstName();
        ContainerInfo containerInfo = this.getContainerInfo(string);
        if (containerInfo != null) {
            if (!containerInfo.canGetQuery()) {
                throw new JRScheduleException(225012, (Object[])new String[]{string, " canGetQuery is false. Please layout group to check the schedule logic. "}, null);
            }
        } else {
            throw new JRScheduleException(225004, (Object[])new String[]{string}, null);
        }
        n = containerInfo.getCurrQId();
        if (n == -1) {
            JRScheduleException jRScheduleException = null;
            if (this.htExceptions != null) {
                jRScheduleException = (JRScheduleException)this.htExceptions.get(string);
            }
            throw new JRScheduleException(225012, new Object[]{string, " The query maybe has not been built, yet. Or the query has been deleted."}, (Throwable)jRScheduleException);
        }
        return n;
    }

    public DataResultInfoImpl getDataResultInfo(IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        DataResultInfoImpl dataResultInfoImpl = null;
        String string = iDataContainer.getInstName();
        try {
            dataResultInfoImpl = this.gtManager.getDataResultInfo(string, n, this.DATASET_HDS);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
        }
        DCResourceInfoImpl dCResourceInfoImpl = new DCResourceInfoImpl();
        dCResourceInfoImpl.setDisplayRoundingMode(EngineTools.getDisplayRoundingMode(iDataContainer, this.getUniverse()));
        ContainerInfo containerInfo = this.getContainerInfo(string);
        if (containerInfo != null) {
            dCResourceInfoImpl.setDenyList(containerInfo.getDenyList());
        }
        dataResultInfoImpl.setDCResourceInfo(dCResourceInfoImpl);
        return dataResultInfoImpl;
    }

    public List getComponentQueryIds(IDataContainer iDataContainer) {
        return this.gtManager.getComponentQueryIds(iDataContainer.getInstName());
    }

    public List getDataQueryIds(IDataContainer iDataContainer) {
        return this.gtManager.getDataQueryIds(iDataContainer.getInstName());
    }

    public boolean isApplyBrowserFilter(IDataContainer iDataContainer) {
        return this.rptEngine.isApplyBrowserFilter(iDataContainer);
    }

    public void submit() {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " submit() begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        if (this.gtManager != null) {
            this.gtManager.submitGTWorkingTable();
        }
    }

    public void closeAllDataResults() {
        if (this.gtManager != null) {
            this.gtManager.closeAllDataResults(this.DATASET_HDS);
        }
        this.htRptQueryInfos.clear();
        this.vecNoCachedByPValue.removeAllElements();
        this.inheritIdManager.clear();
        IntVector intVector = this.idManager.getAllFirstIds();
        if (intVector != null) {
            for (int i = 0; i < intVector.size(); ++i) {
                int n = intVector.elementAt(i);
                try {
                    JQuery jQuery = this.DATASET_HDS.getQuery(n);
                    if (jQuery == null) continue;
                    this.DATASET_HDS.closeQuery(n);
                    if (!JRLog.isTrace(5)) continue;
                    String string = this.name();
                    JRLog.trace(5, string + "... Close local rQuery after close all componentQuerys/dataQuerys, rid = " + n);
                    continue;
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, " Close raw data query (id: " + n + " ) error! ", (Throwable)dSException);
                }
            }
        }
        this.idManager.clear();
    }

    public IntVector closeDataBuffer(String string, int n, int n2) {
        if (JRLog.isTrace(5)) {
            String string2 = this.name();
            long l = System.currentTimeMillis();
            JRLog.trace(5, string2 + "\t... closeDataBuffer begin at: " + new Timestamp(l) + " , rptDataContainer =  " + string + ", queryId = " + n + ", with rid = " + n2);
        }
        int n3 = -1;
        if (this.gtManager != null) {
            n3 = this.gtManager.closeDataBuffer(string, n, this.DATASET_HDS);
        }
        if (n != -1) {
            this.idManager.removeQueryId(n);
        }
        if (n3 != -1) {
            this.idManager.removeQueryId(n3);
        }
        IntVector intVector = this.idManager.getDataQueryIds(n2);
        this.htRptQueryInfos.remove(n);
        this.vecNoCachedByPValue.removeElement(n);
        return intVector;
    }

    public void clearMem() {
        block3: {
            try {
                this.closeAllDataResults();
                if (this.htExceptions != null) {
                    this.htExceptions.clear();
                }
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, exception);
            }
        }
    }

    public void closeComponentQuery(String string) throws JRScheduleException {
        String string2 = string;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " closeComponentQuery(" + string2 + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        List list = this.gtManager.closeCompQuery(string2, this.DATASET_HDS);
        this.inheritIdManager.removeCompQuerys(string, list);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " close component query ids: " + list);
        }
        this.build(list);
    }

    public void closeDataQuery(String string) throws JRScheduleException {
        String string2 = string;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " closeDataQuery(" + string2 + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        this.append(string);
        List list = this.gtManager.closeDataQuery(string2, this.DATASET_HDS);
        this.inheritIdManager.removeDataQuerys(string, list);
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)list.get(i);
            this.htRptQueryInfos.remove(n);
            this.vecNoCachedByPValue.removeElement(n);
            this.idManager.removeQueryId(n);
        }
    }

    private void append(String string) {
        ArrayList arrayList = this.inheritIdManager.getInheritDcNames(string);
        String string2 = null;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                List<Integer> list;
                Object object;
                string2 = (String)arrayList.get(i);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, this.name() + " closeAllInheritRelationQuerys(...) begin ... for parentDC: " + string + ", inheritDCInstName: " + string2);
                }
                this.append(string2);
                IntVector intVector = this.inheritIdManager.getDataQuerys(string, string2);
                if (intVector != null && intVector.size() > 0) {
                    object = new Vector();
                    for (int j = 0; j < intVector.size(); ++j) {
                        ((Vector)object).addElement(intVector.elementAt(j));
                    }
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, this.name() + " closeAllInheritRelationQuerys(..) close inherit relationed dataQuery ---for dataContainer:" + string2 + ", qids = " + object);
                    }
                    list = this.gtManager.closeDataQuery(string2, (List)object, this.DATASET_HDS);
                    this.inheritIdManager.removeDataQuerys(string, string2, list);
                }
                if ((object = this.inheritIdManager.getCompQuerys(string, string2)) != null && ((IntVector)object).size() > 0) {
                    list = new Vector<Integer>();
                    for (int j = 0; j < ((IntVector)object).size(); ++j) {
                        list.addElement(((IntVector)object).elementAt(j));
                    }
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, this.name() + " closeAllInheritRelationQuerys(..) close inherit relationed compQuery ---for dataContainer:" + string2 + ", qids = " + list);
                    }
                    List list2 = this.gtManager.closeCompQuery(string2, list, this.DATASET_HDS);
                    this.inheritIdManager.removeCompQuerys(string, string2, list2);
                }
                if (!JRLog.isTrace(5)) continue;
                JRLog.trace(5, this.name() + " closeAllInheritRelationQuerys(...) end. for parentDC: " + string + ", inheritDCInstName: " + string2);
            }
        }
    }

    private void build(List list) {
        int n;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " closeLocalRQuerysBasedQueryIds(" + list + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        IntVector intVector = new IntVector(list.size());
        for (n = 0; n < list.size(); ++n) {
            intVector.addElement((Integer)list.get(n));
        }
        IntVector intVector2 = this.idManager.getAllFirstIds();
        for (int i = 0; intVector2 != null && i < intVector2.size(); ++i) {
            n = intVector2.elementAt(i);
            IntVector intVector3 = this.idManager.getCompnentQueryIds(n);
            for (int j = 0; intVector3 != null && j < intVector3.size(); ++j) {
                int n2 = intVector3.elementAt(j);
                if (!intVector.contains(n2)) continue;
                this.idManager.removeQueryId(n2);
            }
            intVector3 = this.idManager.getCompnentQueryIds(n);
            if (intVector3 != null && !intVector3.isEmpty()) continue;
            this.idManager.removeQueryId(n);
            try {
                JQuery jQuery = this.DATASET_HDS.getQuery(n);
                if (jQuery == null) continue;
                this.DATASET_HDS.closeQuery(n);
                jQuery = null;
                if (!JRLog.isTrace(5)) continue;
                String string = this.name();
                JRLog.trace(5, string + "... Close rQuery after close compQuerys: " + list + ", rid = " + n);
                continue;
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, "Close raw data query (id: " + n + " ) error! ", (Throwable)dSException);
            }
        }
    }

    public void closeLocalRQueryByRawId(int n) {
        block4: {
            try {
                JRawDataQuery jRawDataQuery = (JRawDataQuery)this.DATASET_HDS.getQuery(n);
                if (jRawDataQuery != null) {
                    this.DATASET_HDS.closeQuery(n);
                    if (JRLog.isTrace(5)) {
                        String string = this.name();
                        JRLog.trace(5, string + "... Close rQuery, rid = " + n);
                    }
                }
                this.idManager.removeQueryId(n);
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) break block4;
                JRLog.error(2, "Close raw data query (id: " + n + " ) error! ", (Throwable)dSException);
            }
        }
    }

    public List getCurQueryIds(IDataContainer iDataContainer) {
        String string = iDataContainer.getInstName();
        return this.gtManager.getDataQueryIds(string);
    }

    String name() {
        String string = "";
        if (this.rptEngine != null) {
            string = this.rptEngine.name();
        }
        if (string != null && string.length() > 0) {
            string = "of " + string;
        }
        return "GTAccessor " + string + " ";
    }

    public void stopRunning() {
        IntVector intVector;
        if (this.gtManager != null) {
            this.gtManager.stopRunning(this.DATASET_HDS);
        }
        int n = (intVector = this.idManager.getAllFirstIds()) == null ? 0 : intVector.size();
        for (int i = 0; i < n; ++i) {
            int n2 = intVector.elementAt(i);
            try {
                this.DATASET_HDS.cancelQuery(n2);
                if (!JRLog.isTrace(5)) continue;
                String string = this.name();
                JRLog.trace(5, string + "... stop local rQuery after stop all componentQuerys/dataQuerys, rid = " + n2);
                continue;
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, " stop raw data query (id: " + n2 + " ) error! ", (Throwable)dSException);
            }
        }
    }

    private void buildCommGroup(ContainerInfo containerInfo, JSubLinkContainer jSubLinkContainer) throws ConditionException, JRScheduleException {
        if (containerInfo != null) {
            Object object;
            IDataContainer iDataContainer = containerInfo.getContainer();
            String string = iDataContainer.getInstName();
            if (jSubLinkContainer != null) {
                DataSet dataSet = ReportTools.getDataSet((JetRptObject)((Object)iDataContainer));
                jSubLinkContainer.setDataSet(dataSet);
            }
            int n = -1;
            ContainerInfo containerInfo2 = null;
            if (ReportTools.isRealDataInherit(iDataContainer) && (object = this.rptEngine.getGroupRootContainer(iDataContainer)) != null) {
                containerInfo2 = this.getContainerInfo(object.getInstName());
            }
            if (containerInfo.getDataSetType() != ContainerInfo.DATASET_HDS) {
                object = this.getSubLinkProcessor();
                IExpression iExpression = ReportTools.getIExpression(iDataContainer, jSubLinkContainer, object, this.getUniverse());
                n = RptFilterInfoContainer.TYPE_CONTAINER_FILTER_SUBLINK;
                IExpression iExpression2 = null;
                if (containerInfo2 != null) {
                    iExpression2 = (IExpression)containerInfo2.getFilterInfo(n);
                }
                if (iExpression2 instanceof IBooleanExpression) {
                    iExpression = ReportTools.getAndExpression(iExpression, (IBooleanExpression)iExpression2);
                }
                containerInfo.setFilterInfo(n, iExpression);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, this.name() + ", Get record level filter(TYPE_CONTAINER_FILTER_SUBLINK) for dataContainer [" + string + "] : " + iExpression);
                }
            } else if (iDataContainer instanceof JetRptCTCrossTab && ReportTools.isRealDataInherit(iDataContainer)) {
                object = this.getSubLinkProcessor();
                IExpression iExpression = ReportTools.getIExpression(iDataContainer, jSubLinkContainer, (SubLinkProcessor)object, this.getUniverse());
                n = RptFilterInfoContainer.TYPE_CONTAINER_FILTER_SUBLINK;
                Object var9_14 = null;
                containerInfo.setFilterInfo(n, iExpression);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, this.name() + ", Get record level filter(TYPE_CONTAINER_FILTER_SUBLINK) for dataContainer [" + string + "] : " + iExpression);
                }
            } else {
                object = new Hashtable();
                n = RptFilterInfoContainer.TYPE_CONTAINER_FILTER_SUBLINK;
                try {
                    ReportTools.getBranchToFilter(iDataContainer.getInstName(), containerInfo.getFldToBranch(), containerInfo.getFmlToBranch(), jSubLinkContainer, (Hashtable)object, this.getParameters(), this.getUniverse());
                }
                catch (InvalidParameterException invalidParameterException) {
                    throw new JRScheduleException(invalidParameterException);
                }
                Hashtable hashtable = null;
                if (containerInfo2 != null) {
                    hashtable = (Hashtable)containerInfo2.getFilterInfo(n);
                }
                object = ReportTools.mergeBranchToFilter((Hashtable)object, hashtable);
                containerInfo.setFilterInfo(n, object);
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, this.name() + ", Get record level filter(TYPE_CONTAINER_FILTER_SUBLINK):  for dataContainer [" + string + "] : " + object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Group getCommGroupTree(IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        Group group = null;
        String string = iDataContainer.getInstName();
        int n2 = -1;
        JRScheduleException jRScheduleException = null;
        ContainerInfo containerInfo = this.getContainerInfo(string);
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getCommGroupTree(" + string + ") begin at:" + new Timestamp(System.currentTimeMillis()));
        }
        try {
            if (this.rptEngine.isStopping()) {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, this.name() + " STOP In GTAccessor.getGroupTree().");
                }
                throw new JRStopEngineException(225026, (Object[])new String[]{"engine is stopped when getting common group  tree."}, null);
            }
            boolean bl = containerInfo.canGetQuery();
            if (!bl) {
                throw new JRScheduleException(225012, (Object[])new String[]{string, " canGetQuery is false. Please rpt set engine to check the schedule logic."}, null);
            }
            JQuery jQuery = null;
            JQuery[] jQueryArray = null;
            if (this.queryBuilder == null) {
                this.queryBuilder = new QueryBuilder(this);
            }
            jQueryArray = this.queryBuilder.buildCommGroup(iDataContainer, containerInfo, n);
            jQuery = jQueryArray[jQueryArray.length - 1];
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            if (jQuery != null) {
                String string2;
                if (JRLog.isTrace(4)) {
                    l = System.currentTimeMillis();
                }
                n2 = jQuery.getQueryId();
                if (jQueryArray != null) {
                    this.DATASET_HDS.prepareQuery(jQueryArray);
                    if (this.vecGId_commGT == null) {
                        this.vecGId_commGT = new IntVector();
                    }
                    if (this.vecCId_commGT == null) {
                        this.vecCId_commGT = new IntVector();
                    }
                    this.vecGId_commGT.addElement(n2);
                    this.vecCId_commGT.addElement(((JGroupQuery)jQuery).getOriginalBaseId());
                }
                if (JRLog.isTrace(4)) {
                    l2 = System.currentTimeMillis();
                    l3 = l2 - l;
                    string2 = this.name();
                    JRLog.trace(4, 5225013, new Object[]{string2, string, new Integer(n2), new Long(l3).toString()});
                }
                if (jQueryArray != null && JRLog.isTrace(5)) {
                    ContainerInfo.printQuery(jQueryArray[0]);
                    ContainerInfo.printQuery(jQueryArray[1]);
                }
                if (JRLog.isTrace(4)) {
                    l = System.currentTimeMillis();
                }
                group = this.DATASET_HDS.getResult(n2);
                if (JRLog.isTrace(4)) {
                    l2 = System.currentTimeMillis();
                    l3 = l2 - l;
                    string2 = this.name();
                    JRLog.trace(4, 5225022, new Object[]{string2, string, new Integer(n2), new Long(l3).toString()});
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof JRStopEngineException) {
                throw (JRStopEngineException)throwable;
            }
            if (throwable instanceof JRScheduleException) {
                jRScheduleException = (JRScheduleException)throwable;
            } else {
                GTAccessor gTAccessor;
                int n3;
                if (throwable instanceof DSException && (n3 = ((DSException)throwable).getPartMessKey()) == 4081) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, throwable);
                    }
                    gTAccessor = null;
                }
                if (gTAccessor != null) {
                    jRScheduleException = new JRScheduleException(225023, (Object[])new String[]{string}, (Throwable)((Object)gTAccessor));
                }
            }
        }
        finally {
            if (jRScheduleException != null) {
                throw jRScheduleException;
            }
            if (!this.isSingleThread()) {
                GTAccessor gTAccessor = this;
                synchronized (gTAccessor) {
                    this.notifyAll();
                }
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getGroupTreeInfo(" + string + "): queryId = " + n2 + ", group = " + group);
        }
        return group;
    }

    public void closeAllQuerysNonReUsedForCommGT() {
        JQuery jQuery;
        int n;
        int n2;
        if (this.vecGId_commGT != null) {
            for (n2 = 0; n2 < this.vecGId_commGT.size(); ++n2) {
                n = this.vecGId_commGT.elementAt(n2);
                try {
                    jQuery = this.DATASET_HDS.getQuery(n);
                    if (jQuery == null) continue;
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, this.name() + " closeAllQuerysNonReUsedForCommGT(..)    groupQueryId:" + n);
                    }
                    this.DATASET_HDS.closeQuery(n);
                    continue;
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, dSException);
                }
            }
            this.vecGId_commGT.removeAllElements();
            this.vecGId_commGT = null;
        }
        if (this.vecCId_commGT != null) {
            for (n2 = 0; n2 < this.vecCId_commGT.size(); ++n2) {
                n = this.vecCId_commGT.elementAt(n2);
                try {
                    jQuery = this.DATASET_HDS.getQuery(n);
                    if (jQuery == null) continue;
                    if (JRLog.isTrace(5)) {
                        JRLog.trace(5, this.name() + " GTAccessor.closeAllQuerysNonReUsedForCommGT(..)    compQuery:" + n);
                    }
                    this.DATASET_HDS.closeQuery(n);
                    continue;
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, dSException);
                }
            }
            this.vecCId_commGT.removeAllElements();
            this.vecCId_commGT = null;
        }
    }

    public JavaFormula buildJavaFormulaContainer(IDataContainer iDataContainer, ContainerInfo containerInfo, QueryInfo queryInfo) throws JRScheduleException {
        return this.rptEngine.buildJavaFormulaContainer(iDataContainer, containerInfo, queryInfo);
    }

    @Override
    public int[] getComponentQueryIDs(String string) {
        List list = this.gtManager.getComponentQueryIds(string);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }

    @Override
    public int[] getGroupQueryIDs(String string) {
        List list = this.gtManager.getDataQueryIds(string);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }

    public JQuery getDataQuery(IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        JQuery jQuery = null;
        String string = iDataContainer.getInstName();
        try {
            jQuery = this.gtManager.getDataQuery(string, n, this.DATASET_HDS);
        }
        catch (DSException dSException) {
            throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
        }
        return jQuery;
    }

    public LayoutInfo getDataQueryLayoutInfo(IDataContainer iDataContainer, int n) throws JRScheduleException, JRStopEngineException {
        return this.gtManager.getDataQueryLayoutInfo(iDataContainer.getInstName(), n);
    }

    public Hashtable getContainerGTManagerInfos() {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getContainerGTManagerInfos() begin...");
        }
        Hashtable<String, ContainerGTManagerInfo> hashtable = new Hashtable<String, ContainerGTManagerInfo>();
        if (this.gtManager != null) {
            HashMap hashMap = this.gtManager.getAllCursorIndexs();
            String[] stringArray = hashMap.keySet().toArray(new String[0]);
            String string = null;
            ContainerGTManagerInfo containerGTManagerInfo = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                Integer n = (Integer)hashMap.get(string);
                containerGTManagerInfo = new ContainerGTManagerInfo();
                containerGTManagerInfo.setGTManagerCursor(n);
                containerGTManagerInfo.setGTManagerFlag(this.gtManager.getStatus(string));
                hashtable.put(string, containerGTManagerInfo);
                if (!JRLog.isTrace(5)) continue;
                JRLog.trace(5, this.name() + " ***getContainerGTManagerInfos()  the Data Container: " + string + " , index = " + containerGTManagerInfo.getGTManagerCursor() + " , flag = " + containerGTManagerInfo.getGTManagerStatus());
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " getContainerGTManagerInfos() end.");
        }
        return hashtable;
    }

    public void restoreGTManager(Hashtable hashtable) throws JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " setGTManagerInfos() begin... the old containerGTManagerInfos like: ");
        }
        Hashtable hashtable2 = this.getContainerGTManagerInfos();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " setGTManagerInfos() ...after restore, the current containerGTManagerInfos like: ");
        }
        if (this.gtManager != null) {
            int n = -1;
            int n2 = -1;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    Object object;
                    if (hashtable.containsKey(string)) {
                        object = (ContainerGTManagerInfo)hashtable.get(string);
                        n = ((ContainerGTManagerInfo)object).getGTManagerCursor();
                    } else {
                        n = 0;
                    }
                    n2 = 1;
                    object = this.gtManager.getDataQueryIds(string);
                    int n3 = object.size();
                    Group group = null;
                    for (int i = n; i < n3; ++i) {
                        DataResultInfoImpl dataResultInfoImpl = this.gtManager.getDataResultInfo(string, n, this.DATASET_HDS);
                        if (dataResultInfoImpl.getDataResultType() != 0) continue;
                        group = dataResultInfoImpl.getGroupTree();
                        group.resetCursor();
                    }
                    this.gtManager.setCursorFlag(string, n, n2);
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, this.name() + " ***setGTManagerInfos()  the Data Container: " + string + " , index = " + n + " , flag = " + n2);
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
                }
            }
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, this.name() + " setGTManagerInfos() end. ");
        }
    }

    protected void registerInheritIdRelation(String string, String string2, int n, int n2, int n3) {
        this.inheritIdManager.registerInheritIdRelation(string, string2, n, n2, n3);
    }

    protected void collectInheritIdRelation(String string, int n, int n2) {
        this.inheritIdManager.collectInheritIdRelation(string, n, n2);
    }
}

