/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.group;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.crosstabdata.CrosstabDataResult;
import jet.dataengine.api.query.JComponentFilterQuery;
import jet.dataengine.api.query.JCrossTableQuery;
import jet.dataengine.api.query.JCubeViewQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.rptengine.componentLayoutInfo.LayoutInfo;
import jet.rptservice.api.IDataContainerContext;
import jet.rptservice.api.IQueryInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.accessor.group.GTWorkingTable;
import jet.rptservice.engine.accessor.group.QueryManager;
import jet.rptservice.impl.ComponentQueryInfoImpl;
import jet.rptservice.impl.DataQueryInfoImpl;
import jet.rptservice.impl.DataResultInfoImpl;
import jet.va.vctData.VCTCubeViewResult;

class GTManager {
    private GTWorkingTable SEDU = new GTWorkingTable();

    GTManager() {
    }

    int registerDataContainer(String string, int n, LayoutInfo layoutInfo, boolean bl) throws DSException, JRScheduleException, JRStopEngineException {
        this.SEDU.addDataQueryItem(string, n, null, bl);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.registerDataContainer(..)---dataContainer:" + string + "    dataQueryId:" + n);
        }
        try {
            return this.SEDU.getCursorPosition(string);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Should never reach here,unpredictable error happen!!");
            }
            throw new RuntimeException("Should never reach here,unpredictable error happen!!");
        }
    }

    int registerDataContainer(String string, int n, boolean bl, int n2, LayoutInfo layoutInfo, boolean bl2) throws DSException, JRScheduleException, JRStopEngineException {
        this.SEDU.addDataQueryItem(string, n, bl, n2, layoutInfo, bl2);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.registerDataContainer(..)---dataContainer:" + string + "    componentQueryId: " + n + "   dataQueryId:" + n2);
        }
        try {
            return this.SEDU.getCursorPosition(string);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Should never reach here,unpredictable error happen!!");
            }
            throw new RuntimeException("Should never reach here,unpredictable error happen!!");
        }
    }

    int getCursorPosition(String string) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.getCursorPosition(..)---dataContainer:" + string);
        }
        try {
            return this.SEDU.getCursorPosition(string);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Should never reach here,unpredictable error happen!!");
            }
            throw new RuntimeException("Should never reach here,unpredictable error happen!!");
        }
    }

    List preprocess() {
        this.SEDU();
        return new ArrayList();
    }

    void init(Hashtable hashtable, QueryManager queryManager) throws JRScheduleException, JRStopEngineException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.init()! reset query infor in workingTable");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                List list = (List)hashtable.get(string);
                if (list == null || list.size() <= 0) continue;
                this.closeDataQuery(string, queryManager);
                this.closeCompQuery(string, queryManager);
                for (IDataContainerContext iDataContainerContext : list) {
                    int n = iDataContainerContext.getDataQueryId();
                    JQuery jQuery = queryManager.getQuery(n);
                    if (jQuery == null) continue;
                    JQuery jQuery2 = jQuery.getBaseQuery();
                    int n2 = jQuery2.getQueryId();
                    this.registerDataContainer(string, n2, false, n, iDataContainerContext.getLayoutInfo(), false);
                }
            }
            catch (DSException dSException) {
                throw new JRScheduleException(225001, (Object[])new String[]{" DataContainer [" + string + "]"}, (Throwable)dSException);
            }
        }
        this.submitGTWorkingTable();
    }

    List closeDataQuery(String string, List list, QueryManager queryManager) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        List list2 = this.SEDU.getDataQueryInfos(string);
        int n = list2 == null ? 0 : list2.size();
        for (int i = 0; i < n; ++i) {
            DataQueryInfoImpl dataQueryInfoImpl = (DataQueryInfoImpl)list2.get(i);
            int n2 = dataQueryInfoImpl.getQueryId();
            if (!list.contains(new Integer(n2))) continue;
            try {
                JQuery jQuery = queryManager.getQuery(n2);
                if (jQuery == null) continue;
                if (dataQueryInfoImpl.canBeClosed()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "GTManager.closeDataQuery(..)---dataContainer:" + string + "    dataQueryId:" + n2 + "    JQuery:" + jQuery);
                    }
                    queryManager.closeQuery(n2);
                    arrayList.add(n2);
                }
                this.SEDU.removeDataQueryItem(string, dataQueryInfoImpl);
                continue;
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, dSException);
            }
        }
        return arrayList;
    }

    List closeCompQuery(String string, List list, QueryManager queryManager) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        List list2 = this.SEDU.getCompQueryInfos(string);
        int n = list2 == null ? 0 : list2.size();
        for (int i = 0; i < n; ++i) {
            ComponentQueryInfoImpl componentQueryInfoImpl = (ComponentQueryInfoImpl)list2.get(i);
            int n2 = componentQueryInfoImpl.getQueryId();
            if (!list.contains(new Integer(n2))) continue;
            try {
                JQuery jQuery = queryManager.getQuery(n2);
                if (jQuery == null) continue;
                if (componentQueryInfoImpl.canBeClosed()) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "GTManager.closeCompQuery(..)---dataContainer:" + string + "    CompQueryId:" + n2 + "    JQuery:" + jQuery);
                    }
                    if (jQuery instanceof JComponentFilterQuery) {
                        JComponentFilterQuery jComponentFilterQuery = (JComponentFilterQuery)jQuery;
                        int n3 = jComponentFilterQuery.getBaseId();
                        queryManager.closeQuery(jComponentFilterQuery.getQueryId());
                        JQuery jQuery2 = queryManager.getQuery(n3);
                        while (jQuery2 instanceof JIterativeQuery) {
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "GTManager.closeCompQuery(..)---dataContainer:" + string + ".. closing JIterativeQuery: " + n3);
                            }
                            n3 = ((JIterativeQuery)jQuery2).getBaseId();
                            queryManager.closeQuery(jQuery2.getQueryId());
                            jQuery2 = queryManager.getQuery(n3);
                        }
                    } else {
                        queryManager.closeQuery(jQuery.getQueryId());
                    }
                    arrayList.add(n2);
                }
                this.SEDU.removeCompQueryItem(string, componentQueryInfoImpl);
                continue;
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, dSException);
            }
        }
        return arrayList;
    }

    private void SEDU() {
        List list = this.SEDU.getAllDCInsName();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            this.SEDU.resetWTCursor(string);
        }
    }

    DataResultInfoImpl getDataResultInfo(String string, int n, QueryManager queryManager) throws DSException, JRScheduleException, JRStopEngineException {
        DataResultInfoImpl dataResultInfoImpl = new DataResultInfoImpl();
        DataQueryInfoImpl dataQueryInfoImpl = this.SEDU.getDataQueryInfo(string, n);
        int n2 = dataQueryInfoImpl.getQueryId();
        JQuery jQuery = queryManager.getQuery(n2);
        if (jQuery != null) {
            if (jQuery instanceof JCubeViewQuery) {
                VCTCubeViewResult vCTCubeViewResult = queryManager.getVCTCubeViewResult(n2);
                dataResultInfoImpl.setCubeViewDataResult(vCTCubeViewResult);
            } else if (jQuery instanceof JCrossTableQuery) {
                CrosstabDataResult crosstabDataResult = queryManager.getCrosstabResult(n2);
                dataResultInfoImpl.setCrosstabDataResult(crosstabDataResult);
            } else {
                Group group = queryManager.getResult(n2);
                dataResultInfoImpl.setGroupTree(group);
            }
        } else {
            if (JRLog.isError(2)) {
                JRLog.error(2, "GTWorkingTable error: data container :" + string + " can not get data result info.");
            }
            throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " can not get data result info!!!"}, null);
        }
        dataResultInfoImpl.setLayoutInfo(dataQueryInfoImpl.getLayoutInfo());
        return dataResultInfoImpl;
    }

    boolean canMoveGTCursor(String string) {
        return this.SEDU.canMoveGTCursor(string);
    }

    void moveDataQueryCursor(String string) {
        this.SEDU.moveGTCursor(string);
    }

    void submitGTWorkingTable() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.submitGTWorkingTable()!");
        }
        this.SEDU.submitWorkingTable();
    }

    int getStatus(String string) {
        return this.SEDU.getStatus(string);
    }

    void closeAllDataResults(QueryManager queryManager) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.closeAllDataResults()..., param: " + queryManager);
        }
        List list = this.SEDU.getAllDCInsName();
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = (String)list.get(i);
            this.add(string, queryManager);
            this.addDataQueryItem(string, queryManager);
        }
        this.SEDU.clear();
    }

    private List add(String string, QueryManager queryManager) {
        List list = this.SEDU.getDataQueryIds(string);
        List list2 = this.closeDataQuery(string, list, queryManager);
        return list2;
    }

    private List addDataQueryItem(String string, QueryManager queryManager) {
        List list = null;
        list = this.SEDU.getComponentQueryIds(string);
        List list2 = this.closeCompQuery(string, list, queryManager);
        this.SEDU.removeDataContainer(string);
        return list2;
    }

    int getNextDataQueryId(String string) throws JRScheduleException {
        return this.SEDU.getNextDataQueryId(string);
    }

    LayoutInfo getNextDataQueryLayoutInfo(String string) throws JRScheduleException {
        return this.SEDU.getNextDataQueryLayoutInfo(string);
    }

    int getQueryIndex(String string, Group group, QueryManager queryManager) throws DSException, JRScheduleException, JRStopEngineException {
        List list = this.SEDU.getDataQueryIds(string);
        if (list == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
            }
            throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
        }
        for (int i = 0; i < list.size(); ++i) {
            int n = (Integer)list.get(i);
            try {
                int n2;
                JQuery jQuery = queryManager.getQuery(n);
                if (jQuery == null || queryManager.getQuery(n) instanceof JCrossTableQuery || queryManager.getResult(n2 = n) != group) continue;
                return i;
            }
            catch (DSException dSException) {
                // empty catch block
            }
        }
        throw new JRScheduleException(220048, (Object[])new String[]{"fail to find group query id of the specified group tree in workingTable."}, null);
    }

    int getQueryIndex(String string, int n) throws JRScheduleException, JRStopEngineException {
        List list = this.SEDU.getDataQueryIds(string);
        if (list == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
            }
            throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if ((Integer)list.get(i) != n) continue;
            return i;
        }
        throw new JRScheduleException(220048, (Object[])new String[]{"fail to find query index of the specified query id in workingTable."}, null);
    }

    HashMap getAllQueryIds() {
        HashMap<String, List> hashMap = new HashMap<String, List>();
        List list = this.SEDU.getAllDCInsName();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            List list2 = this.SEDU.getDataQueryIds(string);
            hashMap.put(string, list2);
        }
        return hashMap;
    }

    List getComponentQueryIds(String string) {
        List list = this.SEDU.getComponentQueryIds(string);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    List getDataQueryIds(String string) {
        List list = this.SEDU.getDataQueryIds(string);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    void stopRunning(QueryManager queryManager) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.stopRunning()..., param: " + queryManager);
        }
        List list = this.SEDU.getAllDCInsName();
        for (int i = list.size() - 1; i >= 0; --i) {
            String string = (String)list.get(i);
            this.append(string, queryManager);
            this.canBeClosed(string, queryManager);
        }
    }

    private void append(String string, QueryManager queryManager) {
        List list = this.SEDU.getDataQueryInfos(string);
        this.canMoveGTCursor(string, list, queryManager);
    }

    private void canBeClosed(String string, QueryManager queryManager) {
        List list = this.SEDU.getCompQueryInfos(string);
        this.canMoveGTCursor(string, list, queryManager);
    }

    private void canMoveGTCursor(String string, List list, QueryManager queryManager) {
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            IQueryInfo iQueryInfo = (IQueryInfo)list.get(i);
            if (!iQueryInfo.canBeClosed()) continue;
            int n2 = iQueryInfo.getQueryId();
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "GTManager.stopQuery(..)---dataContainer:" + string + "    QueryId:" + n2);
                }
                queryManager.cancelQuery(n2);
                continue;
            }
            catch (DSException dSException) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, dSException);
            }
        }
    }

    List closeDataQuery(String string, QueryManager queryManager) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.closeDataBuffer().. for the Data Container: " + string);
        }
        return this.add(string, queryManager);
    }

    List closeCompQuery(String string, QueryManager queryManager) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.closeCompQuery().. for the Data Container: " + string);
        }
        return this.addDataQueryItem(string, queryManager);
    }

    int closeDataBuffer(String string, int n, QueryManager queryManager) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.closeDataBuffer()..  the Data Container: " + string + "  QueryIdToClose: " + n);
        }
        int n2 = -1;
        List list = this.SEDU.getDataQueryInfos(string);
        List list2 = this.SEDU.getCompQueryInfos(string);
        if (list == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "GTManager.closeDataBuffer()..  the Data Container: " + string + "  does not exist");
            }
            return n2;
        }
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            block18: {
                DataQueryInfoImpl dataQueryInfoImpl = (DataQueryInfoImpl)list.get(i);
                int n4 = dataQueryInfoImpl.getQueryId();
                if (n4 != n) continue;
                try {
                    JQuery jQuery = queryManager.getQuery(n4);
                    if (jQuery != null) {
                        Object object;
                        if (dataQueryInfoImpl.canBeClosed()) {
                            if (jQuery instanceof JGroupQuery) {
                                object = (JGroupQuery)jQuery;
                                if (JRLog.isTrace(6)) {
                                    JRLog.trace(6, "GTManager.closeDataBuffer(..).. closing GroupQuery: " + n4);
                                }
                                object.closeWithoutGroupTree();
                            } else {
                                if (!(jQuery instanceof JHDSQuery)) continue;
                                object = (JHDSQuery)jQuery;
                                if (JRLog.isTrace(6)) {
                                    JRLog.trace(6, "GTManager.closeDataBuffer(..).. closing HDSQuery: " + n4);
                                }
                                object.closeWithGroupTree();
                            }
                        }
                        this.SEDU.removeDataQueryItem(string, dataQueryInfoImpl);
                        object = (ComponentQueryInfoImpl)list2.get(i);
                        n2 = ((ComponentQueryInfoImpl)object).getQueryId();
                        JQuery jQuery2 = queryManager.getQuery(n2);
                        if (jQuery2 != null && ((ComponentQueryInfoImpl)object).canBeClosed()) {
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "GTManager.closeDataBuffer(..).. closing compQuery: " + n2);
                            }
                            if (jQuery2 instanceof JComponentFilterQuery) {
                                JComponentFilterQuery jComponentFilterQuery = (JComponentFilterQuery)jQuery2;
                                int n5 = jComponentFilterQuery.getBaseId();
                                queryManager.closeQuery(jComponentFilterQuery.getQueryId());
                                JQuery jQuery3 = queryManager.getQuery(n5);
                                while (jQuery3 instanceof JIterativeQuery) {
                                    if (JRLog.isTrace(6)) {
                                        JRLog.trace(6, "GTManager.closeDataBuffer(..).. closing JIterativeQuery: " + n5);
                                    }
                                    n5 = ((JIterativeQuery)jQuery3).getBaseId();
                                    queryManager.closeQuery(jQuery3.getQueryId());
                                    jQuery3 = queryManager.getQuery(n5);
                                }
                            } else {
                                queryManager.closeQuery(jQuery2.getQueryId());
                            }
                        }
                        this.SEDU.removeCompQueryItem(string, (ComponentQueryInfoImpl)object);
                    }
                }
                catch (DSException dSException) {
                    if (!JRLog.isError(2)) break block18;
                    JRLog.error(2, "Error occur in GTManager.closeDataBuffer(..)", (Throwable)dSException);
                }
            }
            return n2;
        }
        return n2;
    }

    void prepareReCreating(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.prepareReCreating(..).. the Data Container: " + string);
        }
        this.SEDU.prepareReCreating(string);
    }

    boolean hasMoreDataQuery(String string) {
        return this.SEDU.hasMoreDataQuery(string);
    }

    int getNextCompQueryId(String string) throws JRScheduleException {
        return this.SEDU.getNextCompQueryId(string);
    }

    JQuery getDataQuery(String string, int n, QueryManager queryManager) throws DSException, JRScheduleException {
        DataQueryInfoImpl dataQueryInfoImpl = this.SEDU.getDataQueryInfo(string, n);
        int n2 = dataQueryInfoImpl.getQueryId();
        JQuery jQuery = queryManager.getQuery(n2);
        return jQuery;
    }

    LayoutInfo getDataQueryLayoutInfo(String string, int n) throws JRScheduleException {
        return this.SEDU.getDataQueryLayoutInfo(string, n);
    }

    HashMap getAllCursorIndexs() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List list = this.SEDU.getAllDCInsName();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            try {
                int n = this.SEDU.getCursorPosition(string);
                hashMap.put(string, new Integer(n));
                continue;
            }
            catch (JRScheduleException jRScheduleException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    void setCursorFlag(String string, int n, int n2) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "GTManager.setCursorFlag(..).. the Data Container: " + string + " , index = " + n + " , flag = " + n2);
        }
        this.SEDU.setCursorFlag(string, n, n2);
    }
}

