/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.group;

import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jet.rptengine.componentLayoutInfo.LayoutInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.impl.ComponentQueryInfoImpl;
import jet.rptservice.impl.DataQueryInfoImpl;
import jet.util.HashVector;

class GTWorkingTable {
    private HashVector SEDU = new HashVector();

    GTWorkingTable() {
    }

    private StatusQueue SEDU(String string) {
        return (StatusQueue)this.SEDU.get(string);
    }

    int getCursorPosition(String string) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return statusQueue.canMoveCursor;
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    int getStatus(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return statusQueue.getStatus();
        }
        return 2;
    }

    void addDataQueryItem(String string, int n, LayoutInfo layoutInfo, boolean bl) throws JRScheduleException {
        if (string == null) {
            throw new NullPointerException("error : data container instance name is null");
        }
        StatusQueue statusQueue = null;
        if (this.SEDU.containsKey(string)) {
            statusQueue = this.SEDU(string);
        } else {
            statusQueue = new StatusQueue(string);
            this.SEDU.put(string, statusQueue);
        }
        statusQueue.addDataQueryInfo(n, layoutInfo, bl);
    }

    void addDataQueryItem(String string, int n, boolean bl, int n2, LayoutInfo layoutInfo, boolean bl2) throws JRScheduleException {
        if (string == null) {
            throw new NullPointerException("error : data container instance name is null");
        }
        StatusQueue statusQueue = null;
        if (this.SEDU.containsKey(string)) {
            statusQueue = this.SEDU(string);
        } else {
            statusQueue = new StatusQueue(string);
            this.SEDU.put(string, statusQueue);
        }
        statusQueue.addComponentQueryInfo(n, bl);
        statusQueue.addDataQueryInfo(n2, layoutInfo, bl2);
    }

    void removeDataContainer(String string) {
        this.SEDU.remove(string);
    }

    int getNextDataQueryId(String string) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            int n = -1;
            try {
                n = statusQueue.getNextDataQueryInfo().getQueryId();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, " getNextGroupQueryId... GTWorkingTable error: data container :" + string + " have no more group query to get!!!  cursor index = " + statusQueue.canMoveCursor);
                }
                throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " have no more group query to get!!!"}, null);
            }
            return n;
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, " getNextGroupQueryId... GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    LayoutInfo getNextDataQueryLayoutInfo(String string) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            LayoutInfo layoutInfo = null;
            try {
                layoutInfo = statusQueue.getNextDataQueryInfo().getLayoutInfo();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, " getNextGroupQueryId... GTWorkingTable error: data container :" + string + " have no more group query to get!!!  cursor index = " + statusQueue.canMoveCursor);
                }
                throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " have no more group query to get!!!"}, null);
            }
            return layoutInfo;
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, " getNextGroupQueryId... GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    DataQueryInfoImpl getDataQueryInfo(String string, int n) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return (DataQueryInfoImpl)statusQueue.append.get(n);
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    LayoutInfo getDataQueryLayoutInfo(String string, int n) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return ((DataQueryInfoImpl)statusQueue.append.get(n)).getLayoutInfo();
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    boolean canMoveGTCursor(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return statusQueue.canMoveCursor();
        }
        return false;
    }

    void moveGTCursor(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            statusQueue.moveCursor();
        }
    }

    void submitWorkingTable() {
        Enumeration enumeration = this.SEDU.keys();
        while (enumeration.hasMoreElements()) {
            StatusQueue statusQueue = this.SEDU((String)enumeration.nextElement());
            statusQueue.setStatus(1);
        }
    }

    List getAllDCInsName() {
        Enumeration enumeration = this.SEDU.keys();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    List getDataQueryIds(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            List list = statusQueue.getDataQueryInfos();
            if (list != null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    int n = ((DataQueryInfoImpl)list.get(i)).getQueryId();
                    arrayList.add(new Integer(n));
                }
                return arrayList;
            }
            return null;
        }
        return null;
    }

    List getDataQueryInfos(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            List list = statusQueue.getDataQueryInfos();
            if (list != null) {
                ArrayList<DataQueryInfoImpl> arrayList = new ArrayList<DataQueryInfoImpl>();
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add((DataQueryInfoImpl)list.get(i));
                }
                return arrayList;
            }
            return null;
        }
        return null;
    }

    List getComponentQueryIds(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            List list = statusQueue.getComponentQueryInfos();
            if (list != null) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    int n = ((ComponentQueryInfoImpl)list.get(i)).getQueryId();
                    arrayList.add(new Integer(n));
                }
                return arrayList;
            }
            return null;
        }
        return null;
    }

    List getCompQueryInfos(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            List list = statusQueue.getComponentQueryInfos();
            if (list != null) {
                ArrayList<ComponentQueryInfoImpl> arrayList = new ArrayList<ComponentQueryInfoImpl>();
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add((ComponentQueryInfoImpl)list.get(i));
                }
                return arrayList;
            }
            return null;
        }
        return null;
    }

    void resetWTCursor(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            statusQueue.resetCursor();
        }
    }

    void clear() {
        this.SEDU.clear();
    }

    void removeDataQueryItem(String string, DataQueryInfoImpl dataQueryInfoImpl) {
        if (this.SEDU.containsKey(string)) {
            StatusQueue statusQueue = this.SEDU(string);
            statusQueue.removeDataQueryInfo(dataQueryInfoImpl);
            if (statusQueue.isEmpty()) {
                this.SEDU.remove(string);
            }
        }
    }

    void removeCompQueryItem(String string, ComponentQueryInfoImpl componentQueryInfoImpl) {
        if (this.SEDU.containsKey(string)) {
            StatusQueue statusQueue = this.SEDU(string);
            statusQueue.removeComponentQueryInfo(componentQueryInfoImpl);
            if (statusQueue.isEmpty()) {
                this.SEDU.remove(string);
            }
        }
    }

    void prepareReCreating(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            statusQueue.setStatus(3);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "GTWorkingTable.prepareReCreating(..).. the Data Container: " + string + ", adjust status is RECREATING, and current index is " + statusQueue.canMoveCursor);
            }
        }
    }

    boolean hasMoreDataQuery(String string) {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            return statusQueue.hasMoreDataQuery();
        }
        return false;
    }

    int getNextCompQueryId(String string) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            int n = -1;
            try {
                n = statusQueue.getNextCompQueryInfo().getQueryId();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, " getNextCompQueryId... GTWorkingTable error: data container :" + string + " have no more component query to get!!!  cursor index = " + statusQueue.canMoveCursor);
                }
                throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " have no more component query to get!!!"}, null);
            }
            return n;
        }
        if (JRLog.isError(2)) {
            JRLog.error(2, " getNextGroupQueryId... GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
        }
        throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
    }

    void setCursorFlag(String string, int n, int n2) throws JRScheduleException {
        StatusQueue statusQueue = this.SEDU(string);
        if (statusQueue != null) {
            statusQueue.setStatus(n2);
            statusQueue.canMoveCursor = n;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "setCursorFlag(..).. the Data Container: " + string + ", adjust status is " + n2 + " ; and current index is " + statusQueue.canMoveCursor);
            }
        } else {
            if (JRLog.isError(2)) {
                JRLog.error(2, "GTWorkingTable error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!");
            }
            throw new JRScheduleException(220047, (Object[])new String[]{"error: data container :" + string + " does not exist in workingTable!!,you must register it first!!!"}, null);
        }
    }

    private class StatusQueue {
        String dcInsName;
        private int SEDU;
        private List add;
        private List append;
        private int canMoveCursor = -1;

        StatusQueue(String string) {
            this.dcInsName = string;
            this.add = new ArrayList();
            this.append = new ArrayList();
            this.SEDU = 0;
        }

        void setStatus(int n) {
            this.SEDU = n;
        }

        int getStatus() {
            return this.SEDU;
        }

        DataQueryInfoImpl getNextDataQueryInfo() {
            return (DataQueryInfoImpl)this.append.get(this.canMoveCursor + 1);
        }

        void addDataQueryInfo(int n, LayoutInfo layoutInfo, boolean bl) throws JRScheduleException {
            DataQueryInfoImpl dataQueryInfoImpl = new DataQueryInfoImpl(n, layoutInfo, bl);
            if (this.append.contains(dataQueryInfoImpl)) {
                throw new JRScheduleException(220046, (Object[])new String[]{"error : " + this.dcInsName + " : duplicate group query id in workingTable!!!"}, null);
            }
            this.append.add(dataQueryInfoImpl);
            ++this.canMoveCursor;
        }

        void addComponentQueryInfo(int n, boolean bl) throws JRScheduleException {
            ComponentQueryInfoImpl componentQueryInfoImpl = new ComponentQueryInfoImpl(n, bl);
            if (this.add.contains(componentQueryInfoImpl)) {
                throw new JRScheduleException(220046, (Object[])new String[]{"error : " + this.dcInsName + " : duplicate component query id in workingTable!!!"}, null);
            }
            this.add.add(componentQueryInfoImpl);
        }

        void removeDataQueryInfo(DataQueryInfoImpl dataQueryInfoImpl) {
            this.append.remove(dataQueryInfoImpl);
        }

        void removeComponentQueryInfo(ComponentQueryInfoImpl componentQueryInfoImpl) {
            this.add.remove(componentQueryInfoImpl);
        }

        boolean isEmpty() {
            return this.append.isEmpty() && this.add.isEmpty();
        }

        boolean hasMoreDataQuery() {
            return this.canMoveCursor + 1 <= this.append.size() - 1;
        }

        boolean hasMoreCompQuery() {
            return this.canMoveCursor + 1 <= this.add.size() - 1;
        }

        ComponentQueryInfoImpl getNextCompQueryInfo() {
            return (ComponentQueryInfoImpl)this.add.get(this.canMoveCursor + 1);
        }

        boolean canMoveCursor() {
            return this.hasMoreDataQuery() || this.hasMoreCompQuery();
        }

        void moveCursor() {
            if (this.canMoveCursor()) {
                ++this.canMoveCursor;
            }
        }

        void resetCursor() {
            this.canMoveCursor = -1;
        }

        List getDataQueryInfos() {
            return this.append;
        }

        List getComponentQueryInfos() {
            return this.add;
        }
    }
}

