/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.accessor.group;

import com.jinfonet.api.objectmanager.CatalogKey;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.Group;
import jet.dataengine.api.crosstabdata.CrosstabDataResult;
import jet.dataengine.api.query.JComponentFilterQuery;
import jet.dataengine.api.query.JCrossTableQuery;
import jet.dataengine.api.query.JCubeViewQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JHDSQuery;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine8.query.HDSRawDataQuery;
import jet.dataservice.api.JDataInfo;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JQueryFactory;
import jet.va.vctData.VCTCubeViewResult;

public class QueryManager {
    private JQueryFactory SEDU;
    private JDataService cancel;

    public QueryManager(JDataService jDataService, JQueryFactory jQueryFactory) {
        this.SEDU = jQueryFactory;
        this.cancel = jDataService;
    }

    void prepareQuery(JQuery[] jQueryArray) throws DSException, JRStopEngineException {
        for (int i = 0; i < jQueryArray.length; ++i) {
            JQuery jQuery = jQueryArray[i];
            this.cancel.sendQuery(jQuery);
        }
    }

    void closeQuery(int n) {
        this.cancel.closeQuery(n);
    }

    JIterativeQuery createIterativeQuery(CatalogKey catalogKey) throws DSException, JRStopEngineException {
        JIterativeQuery jIterativeQuery = this.SEDU.createIteativeQuery(catalogKey);
        return jIterativeQuery;
    }

    HDSRawDataQuery createHDSRawDataQuery() throws DSException, JRStopEngineException {
        HDSRawDataQuery hDSRawDataQuery = this.SEDU.createHDSRawDataQuery();
        return hDSRawDataQuery;
    }

    JComponentFilterQuery createComponentFilterQuery() throws DSException, JRStopEngineException {
        JComponentFilterQuery jComponentFilterQuery = this.SEDU.createComponentFilterQuery();
        return jComponentFilterQuery;
    }

    JGroupQuery createGroupQuery() throws DSException, JRStopEngineException {
        JGroupQuery jGroupQuery = this.SEDU.createGroupQuery();
        return jGroupQuery;
    }

    JCrossTableQuery createCrossTabQuery() throws DSException, JRStopEngineException {
        JCrossTableQuery jCrossTableQuery = this.SEDU.createCrossTabQuery();
        return jCrossTableQuery;
    }

    JHDSQuery createHDSQuery(CatalogKey catalogKey) throws DSException, JRStopEngineException {
        JHDSQuery jHDSQuery = this.SEDU.createHDSQuery(catalogKey);
        return jHDSQuery;
    }

    JQuery getQuery(int n) throws DSException {
        return this.cancel.getQuery(n);
    }

    JRawDataQuery getRootRawQuery(int n) throws DSException {
        JRawDataQuery jRawDataQuery = null;
        JQuery jQuery = this.cancel.getQuery(n);
        if (jQuery != null) {
            jRawDataQuery = jQuery.getRootQuery();
        }
        return jRawDataQuery;
    }

    JQuery copyQuery(JQuery jQuery) throws DSException, JRStopEngineException {
        return this.SEDU.copy(jQuery);
    }

    Group getResult(int n) throws DSException, JRStopEngineException {
        return this.cancel.getResult(n);
    }

    CrosstabDataResult getCrosstabResult(int n) throws DSException, JRStopEngineException {
        return this.cancel.getCrosstabResult(n);
    }

    DbValue getSpecialField(int n, int n2) throws DSException, JRStopEngineException {
        return this.cancel.getSpecialField(n, n2);
    }

    void dataProcess(JDataInfo jDataInfo) throws DSException, JRStopEngineException {
        this.cancel.dataProcess(jDataInfo);
    }

    void cancelQuery(int n) throws DSException {
        this.cancel.cancel(n);
    }

    VCTCubeViewResult getVCTCubeViewResult(int n) throws DSException, JRStopEngineException {
        return this.cancel.getCubeResult(n);
    }

    JCubeViewQuery createCubeViewQuery() throws DSException, JRStopEngineException {
        JCubeViewQuery jCubeViewQuery = this.SEDU.createCubeViewQuery();
        return jCubeViewQuery;
    }
}

