/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.infocenter;

import com.jinfonet.util.JRLog;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.DataBlock;
import jet.dataengine.api.Group;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.query.JCubeQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.api.query.SpecialFields;
import jet.dataservice.api.JDataService;
import jet.formula.JetRptFormula;
import jet.icontrols.QueryInfo;
import jet.reportLogic.objectInfo.bursting.BurstingRecipientSchema;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.reportLogic.objectInfo.bursting.RecipientMappingIdentifier;
import jet.reportLogic.objectLogic.DataSetLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptQueryDataSet;
import jet.rptservice.api.IQueryBuilder;
import jet.rptservice.api.RuntimeEnv;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.api.infocenter.IDataSetCenter;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.accessor.cube.CubeModel;
import jet.rptservice.engine.accessor.cube.subject.RptDimension;
import jet.rptservice.engine.infocenter.DataSetInfo;
import jet.rptservice.engine.infocenter.DimensionDesc;
import jet.rptservice.engine.infocenter.MDimensionDesc;
import jet.rptservice.engine.infocenter.PartialData;
import jet.rptservice.engine.infocenter.PartialDataSet;
import jet.rptservice.engine.infocenter.ReportSetCenter;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.listener.DataSetListener;
import jet.rptservice.pub.JRecordSecurityContainer;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.pub.KeyReportView;
import jet.rptservice.pub.RSDResultSet;
import jet.rptservice.util.Tools;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.tools.UniverseTools;
import jet.util.ScheduleTools;

public class DataSetCenter
implements IDataSetCenter {
    private Integer SEDU = null;
    private String add = null;
    private Vector addAll;
    private Vector addDimension;
    private Vector addElement;
    private Vector addMeasure;
    private Vector append;
    private Vector cancel;
    private Vector clear;
    private Vector clearAllColumnValues;
    private JetRptDataSet closeCubeData;
    private boolean closeQuery = true;
    private boolean contains = true;
    private boolean containsKey = true;
    private boolean createNewJetRptFmlInstance = true;
    private IExpression currentTimeMillis = null;
    private JetUUniverse destroy;
    private boolean elementAt = false;
    private JRecordSecurityContainer equalsForRawData;
    private DataSetInfo equalsIgnoreCase;
    private SpecialFields error;
    private JRawDataQuery get;
    private HashMap getAvailableKeyDataSourceQuery;
    private boolean getBasedFieldName = true;
    private HashMap getBindInfo;
    private boolean getBurstingDataSetNames = true;
    private boolean getBurstingKeyColumn = false;
    private CubeModel getBurstingRecipientSchema = null;
    private JCubeQuery getBurstingSchemas = null;
    private Integer getCFFormulas = null;
    private DataSetListener getCatalog;
    private DataSetListener getConstantFormulas;
    private DataSetStatus getDataSetAdditionalMappingNames = null;
    private HashMap getDataSetCubeViewInfo;
    private DataBlock getDataSetInfo;
    private HashMap getDataSetLogic = null;
    private Hashtable getDataSetMappingFields;
    private Hashtable getDataSourceName;
    private IQueryBuilder getDbFieldFormulaMappingNames;

    public DataSetCenter(String string, ReportSetCenter reportSetCenter) {
        JRptSetEngine jRptSetEngine = reportSetCenter.getRptSetEngine();
        this.add = string;
        this.closeCubeData = ScheduleTools.getRawQueryDataSet(string, jRptSetEngine.getReportSet());
        this.destroy = jRptSetEngine.getUniverse();
        this.equalsIgnoreCase = reportSetCenter.getDataSetInfo(string);
        this.getDbFieldFormulaMappingNames = jRptSetEngine.getQueryBuilder();
        this.refreshRecSecurity(jRptSetEngine.getEngineEnv(), jRptSetEngine.isRsd() || jRptSetEngine.isBurstingRsd());
        this.refresh(this.destroy);
    }

    public Integer getRawDataId() {
        return this.SEDU;
    }

    public void setRawDataId(int n) {
        this.SEDU = new Integer(n);
    }

    public void clearRawDataId() {
        this.SEDU = null;
    }

    public Integer getCubeQueryId() {
        return this.getCFFormulas;
    }

    public void setCubeQueryId(int n) {
        this.getCFFormulas = new Integer(n);
    }

    public void clearCubeId() {
        this.getCFFormulas = null;
    }

    public void setRawDataQuery(JRawDataQuery jRawDataQuery) {
        this.get = jRawDataQuery;
    }

    public JRawDataQuery getRawDataQuery() {
        return this.get;
    }

    public void setCubeQuery(JCubeQuery jCubeQuery) {
        this.getBurstingSchemas = jCubeQuery;
    }

    public JCubeQuery getCubeQuery() {
        return this.getBurstingSchemas;
    }

    @Override
    public CubeModel getCubeModel() {
        return this.getBurstingRecipientSchema;
    }

    @Override
    public boolean needRefresh() {
        return this.closeQuery;
    }

    public void setNeedRefresh(boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.setNeedRefresh()..., set: " + bl);
        }
        this.closeQuery = bl;
    }

    @Override
    public boolean needRefreshCube() {
        return this.containsKey;
    }

    public void setNeedRefreshCube(boolean bl) {
        this.containsKey = bl;
    }

    @Override
    public boolean needInitCubeQuery() {
        return this.createNewJetRptFmlInstance;
    }

    public void setNeedInitCubeQuery(boolean bl) {
        this.createNewJetRptFmlInstance = bl;
    }

    @Override
    public boolean needInitQuery() {
        return this.contains;
    }

    public void setNeedInitQuery(boolean bl) {
        this.contains = bl;
    }

    public IExpression getFilter() {
        return this.currentTimeMillis;
    }

    @Override
    public JetRptDataSet getDataSet() {
        return this.closeCubeData;
    }

    @Override
    public String getDataSetName() {
        return this.add;
    }

    public JRecordSecurityContainer getSecContainer() {
        return this.equalsForRawData;
    }

    public void setRsdResultSet(RSDResultSet rSDResultSet) {
        this.equalsIgnoreCase.setRsdResultSet(rSDResultSet);
    }

    public RSDResultSet getRsdResultSet() {
        return this.equalsIgnoreCase.getRsdResultSet();
    }

    public void setBindInfo(String[][] stringArray) {
        this.equalsIgnoreCase.setBindInfo(stringArray);
    }

    public String[][] getBindInfo() {
        return this.equalsIgnoreCase.getBindInfo();
    }

    public void setSpecialFields(SpecialFields specialFields) {
        this.error = specialFields;
    }

    public SpecialFields getSpecialFields() {
        return this.error;
    }

    public Hashtable getCFFormulas() {
        Hashtable hashtable = new Hashtable();
        for (Hashtable hashtable2 : this.getDataSetMappingFields.values()) {
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    public Hashtable getFlyFormulas() {
        Hashtable hashtable = new Hashtable();
        for (Hashtable hashtable2 : this.getDataSourceName.values()) {
            hashtable.putAll(hashtable2);
        }
        return hashtable;
    }

    public void putPartialData(PartialData partialData, JetUUniverse jetUUniverse) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.putPartialData()..., pd: " + partialData + " unv: " + jetUUniverse);
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        if (this.getDataSetCubeViewInfo == null) {
            this.getDataSetCubeViewInfo = new HashMap();
        }
        if (!this.getDataSetCubeViewInfo.containsKey(partialData)) {
            PartialDataSet partialDataSet = new PartialDataSet(partialData, jetUUniverse);
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "put PartialDataSet: " + partialDataSet);
            }
            this.getDataSetCubeViewInfo.put(partialData, partialDataSet);
        }
        Tools.logTrace(6, "End of DataSetCenter.putPartialData().");
    }

    public PartialDataSet getPartialDataSet(PartialData partialData) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.getPartialDataSet()..., pd: " + partialData);
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        PartialDataSet partialDataSet = null;
        if (this.getDataSetCubeViewInfo != null) {
            partialDataSet = (PartialDataSet)this.getDataSetCubeViewInfo.get(partialData);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getPartialDataSet(), return: " + partialDataSet);
        }
        return partialDataSet;
    }

    private void SEDU(List list, List list2) {
        if (list2 == null) {
            return;
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            if (list.contains(string = string.toUpperCase())) continue;
            list.add(string);
        }
    }

    private void add(List list, String string) {
        String string2;
        if (string != null && !list.contains(string2 = string.toUpperCase())) {
            list.add(string2);
        }
    }

    public void refresh(JetUUniverse jetUUniverse) {
        block23: {
            KeyDataSourceQuery keyDataSourceQuery;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DataSetCenter.refresh()..., unv: " + jetUUniverse);
            }
            if ((keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(this.closeCubeData.getQueryInfo(), jetUUniverse)) == null) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "can't get data source query info for data set: " + this.closeCubeData.getName());
                }
                Tools.logTrace(6, "End of DataSetCenter.refresh(), return directly.");
                return;
            }
            String string = keyDataSourceQuery.getDataSourceName();
            String string2 = keyDataSourceQuery.getQueryName();
            DataSetLogic dataSetLogic = ObjectLogicFactory.getDataSetLogic();
            block0 : switch (this.closeCubeData.getMappingListSrc()) {
                case 1: {
                    int n = this.closeCubeData.getMappingListType();
                    switch (n) {
                        case 0: {
                            JetRptQueryDataSet jetRptQueryDataSet = (JetRptQueryDataSet)this.closeCubeData;
                            this.addElement = UniverseTools.getFieldResourceNames(jetUUniverse, string, string2);
                            if (JRLog.isTrace(6)) {
                                JRLog.trace(6, "all field names: " + Tools.toString(this.addElement));
                                break;
                            }
                            break block23;
                        }
                        case 2: {
                            List list = dataSetLogic.getDataSetAdditionalMappingNames(jetUUniverse, null, this.closeCubeData);
                            if (list != null) {
                                for (int i = 0; i < list.size(); ++i) {
                                    String string3 = (String)list.get(i);
                                    JetUResourceEntity jetUResourceEntity = jetUUniverse.getResourceByName(string, string2, string3);
                                    if (jetUResourceEntity instanceof JetUFormula) {
                                        JetRptFormula jetRptFormula = ((JetUFormula)jetUResourceEntity).getRptFormula();
                                        if (jetRptFormula.isConstant()) {
                                            if (this.clear == null) {
                                                this.clear = new Vector();
                                            }
                                            this.add(this.clear, string3);
                                            continue;
                                        }
                                        if (jetRptFormula.isGlobal()) {
                                            if (this.clearAllColumnValues == null) {
                                                this.clearAllColumnValues = new Vector();
                                            }
                                            this.add(this.clearAllColumnValues, string3);
                                            continue;
                                        }
                                        if (this.cancel == null) {
                                            this.cancel = new Vector();
                                        }
                                        this.add(this.cancel, string3);
                                        continue;
                                    }
                                    if (this.addDimension == null) {
                                        this.addDimension = new Vector();
                                    }
                                    this.add(this.addDimension, string3);
                                }
                                break block0;
                            }
                            break block23;
                        }
                        case 1: {
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    this.addDimension = new Vector();
                    List list = dataSetLogic.getDataSetAdditionalMappingNames(jetUUniverse, null, this.closeCubeData);
                    if (list == null) break;
                    if (this.addDimension == null) {
                        this.addDimension = new Vector();
                    }
                    this.SEDU(this.addDimension, list);
                    break;
                }
            }
        }
        Tools.logTrace(6, "End of DataSetCenter.refresh().");
    }

    public void refresh(ReportViewCenter reportViewCenter) {
        Object object;
        RecipientMappingIdentifier[] recipientMappingIdentifierArray;
        Object[] objectArray;
        Object object2;
        Object object3;
        RptDimension[] rptDimensionArray;
        Vector<RecipientMappingIdentifier[]> vector;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refresh()..., viewCenter: " + reportViewCenter);
            JRLog.trace(6, "rptName: " + reportViewCenter.getRptCenter().getRptName() + " viewName: " + reportViewCenter.getViewName());
            JRLog.trace(6, "dataSetName: " + this.add);
        }
        long l = System.currentTimeMillis();
        int[] nArray = null;
        int n = this.closeCubeData.getMappingListType();
        if (this.closeCubeData.getMappingListSrc() == 3 && n == 0) {
            n = 1;
        }
        switch (n) {
            case 0: {
                nArray = new int[]{1, 2, 3, 4};
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                nArray = new int[]{0, 1, 2, 3, 4};
                break;
            }
            default: {
                nArray = new int[]{};
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            vector = reportViewCenter.getDataSetMappingFields(nArray[i], this.add);
            this.refreshMappingFields(nArray[i], vector);
        }
        this.refreshCubeModel(reportViewCenter);
        Vector<RecipientMappingIdentifier[]> vector2 = new Vector<RecipientMappingIdentifier[]>();
        vector = new Vector<RecipientMappingIdentifier[]>();
        Vector<Object> vector3 = new Vector<Object>();
        JetUUniverse jetUUniverse = reportViewCenter.getRptCenter().getRptSetCenter().getCatalog();
        if (this.getBurstingRecipientSchema != null) {
            int n2;
            rptDimensionArray = this.getBurstingRecipientSchema.getDimensions();
            int n3 = n2 = rptDimensionArray == null ? 0 : rptDimensionArray.length;
            if (rptDimensionArray != null && rptDimensionArray.length > 0) {
                object3 = ScheduleTools.getAvailableKeyDataSourceQuery(this.closeCubeData.getQueryInfo(), jetUUniverse);
                if (object3 == null) {
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, "can't get data source query info for data set: " + this.closeCubeData.getName());
                    }
                } else {
                    object2 = ((KeyDataSourceQuery)object3).getDataSourceName();
                    objectArray = ((KeyDataSourceQuery)object3).getQueryName();
                    for (int i = 0; i < n2; ++i) {
                        recipientMappingIdentifierArray = rptDimensionArray[i].getmappingName();
                        if (this.addAll((String)recipientMappingIdentifierArray)) continue;
                        DataSetLogic dataSetLogic = ObjectLogicFactory.getDataSetLogic();
                        object = jetUUniverse.getResourceByName((String)object2, (String)objectArray, (String)recipientMappingIdentifierArray);
                        if (object instanceof JetUParameter) {
                            vector.add(recipientMappingIdentifierArray);
                            continue;
                        }
                        if (object instanceof JetUFormula) {
                            vector3.add(recipientMappingIdentifierArray);
                            continue;
                        }
                        vector2.add(recipientMappingIdentifierArray);
                    }
                }
            }
        }
        if ((rptDimensionArray = ObjectLogicFactory.getReportLogic()).isBurstingReport(reportViewCenter.getOriReportView())) {
            BurstingSchema[] burstingSchemaArray = rptDimensionArray.getBurstingSchemas(reportViewCenter.getOriReportView());
            for (int i = 0; burstingSchemaArray != null && i < burstingSchemaArray.length; ++i) {
                BurstingRecipientSchema burstingRecipientSchema;
                object2 = burstingSchemaArray[i];
                objectArray = object2.getBurstingDataSetNames();
                if (!Tools.contains(objectArray, this.add) || (recipientMappingIdentifierArray = (burstingRecipientSchema = object2.getBurstingRecipientSchema()).getRecipientMappingIdentifiers()) == null) continue;
                for (int j = 0; j < recipientMappingIdentifierArray.length; ++j) {
                    String string;
                    object = null;
                    String string2 = recipientMappingIdentifierArray[j].getBurstingKeyColumn();
                    JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(this.closeCubeData.getDataSourceName(), string2);
                    if (jetUResourceEntity == null || ((Vector)(object = jetUResourceEntity instanceof JetUParameter ? vector : (jetUResourceEntity instanceof JetUFormula ? vector3 : vector2))).contains(string = string2.toUpperCase())) continue;
                    ((Vector)object).addElement(string);
                }
            }
        }
        this.refreshMappingFields(1, vector);
        this.refreshMappingFields(2, vector3);
        this.refreshMappingFields(0, vector2);
        if (this.getDataSetMappingFields == null) {
            this.getDataSetMappingFields = new Hashtable();
        }
        Hashtable hashtable = reportViewCenter.getCFFormulas(this.add);
        object3 = new KeyReportView(reportViewCenter.getRptCenter().getRptName(), reportViewCenter.getViewName());
        if (hashtable != null && !hashtable.isEmpty()) {
            this.getDataSetMappingFields.put(object3, hashtable);
        } else {
            this.getDataSetMappingFields.remove(object3);
        }
        if (this.getDataSourceName == null) {
            this.getDataSourceName = new Hashtable();
        }
        if ((hashtable = reportViewCenter.getFlyFormulas(this.add)) != null && !hashtable.isEmpty()) {
            this.getDataSourceName.put(object3, hashtable);
        } else {
            this.getDataSourceName.remove(object3);
        }
        Tools.logTrace(6, "End of DataSetCenter.refresh().");
    }

    private boolean addAll(String string) {
        if (this.addAll != null && this.addAll.contains(string)) {
            return true;
        }
        if (this.cancel != null && this.cancel.contains(string)) {
            return true;
        }
        return this.addMeasure != null && this.addMeasure.contains(string);
    }

    public void refreshCubeModel(ReportViewCenter reportViewCenter) {
        List list = reportViewCenter.getDataSetCubeViewInfo(this.add);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (this.getBurstingRecipientSchema == null) {
            this.getBurstingRecipientSchema = new CubeModel();
        }
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object e = list.get(i);
            boolean bl2 = false;
            if (e instanceof MDimensionDesc) {
                object = (MDimensionDesc)e;
                bl2 = this.getBurstingRecipientSchema.addMeasure(((MDimensionDesc)object).getMdimensionName(), ((MDimensionDesc)object).getBasedFieldName(), ((MDimensionDesc)object).getFunctionType());
            } else {
                object = (DimensionDesc)e;
                bl2 = this.getBurstingRecipientSchema.addDimension(((DimensionDesc)object).getDimensionName(), ((DimensionDesc)object).getBasedFieldName());
            }
            bl = bl || bl2;
        }
        if (bl) {
            this.setNeedInitCubeQuery(true);
            this.setNeedRefreshCube(true);
        }
    }

    public void refreshMappingFields(int n, Vector vector) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refreshMappingFields()..., data set name: " + this.add + " type = " + n + " vMappingName: " + vector);
        }
        if (vector == null) {
            return;
        }
        Vector vector2 = null;
        switch (n) {
            case 0: {
                if (this.closeCubeData.getMappingListType() == 0 && this.closeCubeData.getMappingListSrc() != 3) {
                    Tools.logTrace(6, "not refresh db field because the type is all.");
                    return;
                }
                if (this.addAll == null) {
                    this.addAll = new Vector();
                }
                vector2 = this.addAll;
                break;
            }
            case 1: {
                if (this.addMeasure == null) {
                    this.addMeasure = new Vector();
                }
                vector2 = this.addMeasure;
                break;
            }
            case 2: {
                if (this.cancel == null) {
                    this.cancel = new Vector();
                }
                vector2 = this.cancel;
                break;
            }
            case 3: {
                if (this.clear == null) {
                    this.clear = new Vector();
                }
                vector2 = this.clear;
                break;
            }
            case 4: {
                if (this.clearAllColumnValues == null) {
                    this.clearAllColumnValues = new Vector();
                }
                vector2 = this.clearAllColumnValues;
                break;
            }
            default: {
                JRLog.error(3, "Invalid type: " + n);
                return;
            }
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (vector2.contains(string)) continue;
            this.contains = true;
            this.setNeedRefresh(true);
            vector2.addElement(string);
        }
    }

    public String[] getAllMappingName() {
        Vector vector = new Vector();
        Vector[] vectorArray = null;
        int n = this.closeCubeData.getMappingListType();
        if (this.closeCubeData.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.addMeasure, this.cancel, this.clear};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.addMeasure, this.cancel, this.clear};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.addMeasure, this.cancel, this.clear};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.addMeasure, this.cancel, this.clear};
        }
        if (vectorArray != null) {
            for (int i = 0; i < vectorArray.length; ++i) {
                if (vectorArray[i] == null) continue;
                for (int j = 0; j < vectorArray[i].size(); ++j) {
                    Object e = vectorArray[i].elementAt(j);
                    if (vector.contains(e)) continue;
                    vector.addElement(e);
                }
            }
        }
        return vector.toArray(new String[0]);
    }

    public String[] getDbFieldFormulaMappingNames() {
        return this.getDbFieldFormulaMappingNames(true);
    }

    @Override
    public String[] getMappingNames(int n) {
        int n2;
        Vector vector = new Vector();
        Vector[] vectorArray = null;
        block0 : switch (n) {
            case 0: {
                if (this.closeCubeData.getMappingListSrc() == 1) {
                    n2 = this.closeCubeData.getMappingListType();
                    switch (n2) {
                        case 0: {
                            vectorArray = new Vector[]{this.addElement};
                            break block0;
                        }
                        case 2: {
                            vectorArray = new Vector[]{this.addAll, this.addDimension};
                            break block0;
                        }
                        case 1: {
                            vectorArray = new Vector[]{this.addAll};
                            break block0;
                        }
                    }
                    return null;
                }
                vectorArray = new Vector[]{this.addAll};
                break;
            }
            case 1: {
                vectorArray = new Vector[]{this.addMeasure};
                break;
            }
            case 2: {
                vectorArray = new Vector[]{this.cancel};
                break;
            }
            case 3: {
                vectorArray = new Vector[]{this.clear};
                break;
            }
            case 4: {
                vectorArray = new Vector[]{this.clearAllColumnValues};
                break;
            }
            default: {
                return null;
            }
        }
        if (vectorArray != null) {
            for (n2 = 0; n2 < vectorArray.length; ++n2) {
                if (vectorArray[n2] == null) continue;
                vector.addAll(vectorArray[n2]);
            }
        }
        return vector.toArray(new String[0]);
    }

    public JetRptFormula[] getConstantFormulas(JetUUniverse jetUUniverse, Hashtable hashtable) {
        return this.addElement(this.clear, jetUUniverse, hashtable);
    }

    private JetRptFormula[] addDimension(JetUUniverse jetUUniverse, Hashtable hashtable) {
        return this.addElement(this.clearAllColumnValues, jetUUniverse, hashtable);
    }

    private JetRptFormula[] addElement(Vector vector, JetUUniverse jetUUniverse, Hashtable hashtable) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        String string = this.closeCubeData.getDataSourceName();
        Vector vector2 = jetUUniverse.getFormulasInDatabase(string);
        JetRptFormula[] jetRptFormulaArray = new JetRptFormula[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            JetUFormula jetUFormula;
            String string3 = (String)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                jetUFormula = (JetUFormula)vector2.elementAt(j);
                if (!string3.equalsIgnoreCase(jetUFormula.getResourceNameInUpperCase())) continue;
                jetRptFormulaArray[i] = jetUFormula.createNewJetRptFmlInstance();
                break;
            }
            if (jetRptFormulaArray[i] != null || (jetUFormula = (JetUFormula)hashtable.get(string2 = string3.toUpperCase())) == null) continue;
            jetRptFormulaArray[i] = jetUFormula.createNewJetRptFmlInstance();
        }
        return jetRptFormulaArray;
    }

    public JetRptFormula[] getConstantGlobalFormulas(JetUUniverse jetUUniverse, Hashtable hashtable) {
        JetRptFormula[] jetRptFormulaArray;
        int n;
        JetRptFormula[] jetRptFormulaArray2 = this.getConstantFormulas(jetUUniverse, hashtable);
        int n2 = jetRptFormulaArray2 == null ? 0 : jetRptFormulaArray2.length;
        int n3 = n2 + (n = (jetRptFormulaArray = this.addDimension(jetUUniverse, hashtable)) == null ? 0 : jetRptFormulaArray.length);
        if (n3 == 0) {
            return null;
        }
        JetRptFormula[] jetRptFormulaArray3 = new JetRptFormula[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            jetRptFormulaArray3[n4] = jetRptFormulaArray2[n5];
            ++n5;
            ++n4;
        }
        n5 = 0;
        while (n5 < n) {
            jetRptFormulaArray3[n4] = jetRptFormulaArray[n5];
            ++n5;
            ++n4;
        }
        return jetRptFormulaArray3;
    }

    public boolean hasUsed() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.hasUsed()..., dataSetCenter: " + this + " hasUsed: " + this.elementAt);
        }
        return this.elementAt;
    }

    public void setHasUsed(boolean bl) {
        this.elementAt = bl;
    }

    public boolean hasData() {
        Vector[] vectorArray = null;
        int n = this.closeCubeData.getMappingListType();
        if (this.closeCubeData.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.addMeasure, this.cancel, this.clear, this.clearAllColumnValues};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.addMeasure, this.cancel, this.clear, this.clearAllColumnValues};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.addMeasure, this.cancel, this.clear, this.clearAllColumnValues};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.addMeasure, this.cancel, this.clear, this.clearAllColumnValues};
        }
        for (int i = 0; i < vectorArray.length; ++i) {
            if (vectorArray[i] == null || vectorArray[i].size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasDbFieldOrPass1Formula() {
        String[] stringArray = this.getDbFieldPass1FormulaNames();
        return stringArray != null && stringArray.length > 0;
    }

    public String[] getDbFieldPass1FormulaNames() {
        Vector vector;
        Tools.logTrace(6, "DataSetCenter.getDbFieldPass1FormulaNames()...");
        Vector[] vectorArray = null;
        int n = this.closeCubeData.getMappingListType();
        if (this.closeCubeData.getMappingListSrc() == 1) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "data set mapping list src: data_query.");
                JRLog.trace(6, "data set mapping list type: 0");
            }
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.cancel};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.cancel};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.cancel};
                    break;
                }
            }
        } else {
            Tools.logTrace(6, "data set mapping list src: others.");
            vectorArray = new Vector[]{this.addAll, this.cancel};
        }
        Vector vector2 = new Vector();
        if (vectorArray != null) {
            for (int i = 0; i < vectorArray.length; ++i) {
                if (vectorArray[i] == null) continue;
                vector2.addAll(vectorArray[i]);
            }
        }
        if ((vector = this.clearAllColumnValues()) != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                if (vector2.contains(e)) continue;
                vector2.add(e);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getDbFieldPass1FormulaNames(), return: " + vector2);
        }
        return vector2.toArray(new String[vector2.size()]);
    }

    public boolean hasConstantFormula() {
        return this.clear != null && !this.clear.isEmpty();
    }

    private boolean addMeasure() {
        return this.clearAllColumnValues != null && !this.clearAllColumnValues.isEmpty();
    }

    public boolean hasConstantGlobalFormula() {
        return this.hasConstantFormula() || this.addMeasure();
    }

    public String[] getConstantGlobalFormulaNames() {
        Tools.logTrace(6, "DataSetCenter.getConstantGlobalFormulaNames()...");
        String[] stringArray = this.clear == null ? new String[]{} : this.clear.toArray(new String[this.clear.size()]);
        String[] stringArray2 = this.clearAllColumnValues == null ? new String[]{} : this.clearAllColumnValues.toArray(new String[this.clearAllColumnValues.size()]);
        int n = stringArray.length;
        int n2 = stringArray2.length;
        int n3 = n + n2;
        if (n3 == 0) {
            return null;
        }
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            stringArray3[n4] = stringArray[n5];
            ++n5;
            ++n4;
        }
        n5 = 0;
        while (n5 < n2) {
            stringArray3[n4] = stringArray2[n5];
            ++n5;
            ++n4;
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of DataSetCenter.getConstantGlobalFormulaNames(), return: " + Tools.toString(stringArray3));
        }
        return stringArray3;
    }

    public void setDataSetGroupQuery(String string, JGroupQuery jGroupQuery) {
        if (this.getAvailableKeyDataSourceQuery == null) {
            this.getAvailableKeyDataSourceQuery = new HashMap();
        }
        GroupValueContainer groupValueContainer = new GroupValueContainer(jGroupQuery);
        this.getAvailableKeyDataSourceQuery.put(string, groupValueContainer);
    }

    public List getDataSetValues(String string) {
        if (this.getAvailableKeyDataSourceQuery == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getAvailableKeyDataSourceQuery.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.getValues();
    }

    public void setDataSetValues(String string, List list) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getAvailableKeyDataSourceQuery.get(string);
        groupValueContainer.setValues(list);
    }

    public Group getDataSetValueTree(String string) {
        if (this.getAvailableKeyDataSourceQuery == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getAvailableKeyDataSourceQuery.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.getGroup();
    }

    public void setDataSetValueTree(String string, Group group) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getAvailableKeyDataSourceQuery.get(string);
        groupValueContainer.setGroup(group);
    }

    public void setComponentGroupQuery(String string, JGroupQuery jGroupQuery) {
        if (this.getBindInfo == null) {
            this.getBindInfo = new HashMap();
        }
        GroupValueContainer groupValueContainer = new GroupValueContainer(jGroupQuery);
        this.getBindInfo.put(string, groupValueContainer);
    }

    public List getComponentValues(String string) {
        if (this.getBindInfo == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBindInfo.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.getValues();
    }

    public void setComponentValues(String string, List list) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBindInfo.get(string);
        groupValueContainer.setValues(list);
    }

    public Group getComponentValueTree(String string) {
        if (this.getBindInfo == null) {
            return null;
        }
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBindInfo.get(string);
        if (groupValueContainer == null) {
            return null;
        }
        return groupValueContainer.getGroup();
    }

    public void setComponentValueTree(String string, Group group) {
        GroupValueContainer groupValueContainer = (GroupValueContainer)this.getBindInfo.get(string);
        groupValueContainer.setGroup(group);
    }

    public boolean isNewDataSetValues() {
        return this.getBasedFieldName;
    }

    public void setNewDataSetValues(boolean bl) {
        this.getBasedFieldName = bl;
    }

    public boolean isNewComponentValues() {
        return this.getBurstingDataSetNames;
    }

    public void setNewComponentValues(boolean bl) {
        this.getBurstingDataSetNames = bl;
    }

    public void closeRawData(JDataService jDataService) {
        Tools.logTrace(6, "DataSetCenter.closeRawData()...");
        this.getBasedFieldName = true;
        this.getBurstingDataSetNames = true;
        this.clearAllColumnValues(jDataService);
        this.closeCubeData(jDataService);
        if (this.SEDU != null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "close raw data query, id: " + this.SEDU);
            }
            this.cancel(this.SEDU, jDataService);
            this.SEDU = null;
        }
        if (this.get != null) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "destroy raw data query, id: " + this.get.getQueryId() + " query: " + this.get);
                }
                this.get.destroy();
            }
            catch (DSException dSException) {
                JRLog.trace(5, dSException);
            }
            this.get = null;
        }
        this.contains = true;
        this.setNeedRefresh(true);
        Tools.logTrace(6, "End of DataSetCenter.closeRawData().");
    }

    private void append(int n, JDataService jDataService) {
        try {
            jDataService.cancel(n);
        }
        catch (DSException dSException) {
            JRLog.trace(4, dSException);
        }
    }

    public void cancelRawDataQuery(JDataService jDataService) {
        Tools.logTrace(6, "DataSetCenter.cancelRawDataQuery()...");
        if (this.SEDU != null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "cancel raw data query, id: " + this.SEDU);
            }
            this.append(this.SEDU, jDataService);
        }
        Tools.logTrace(6, "End of DataSetCenter.cancelRawDataQuery().");
    }

    public void closeUnusedRawQuery(JDataService jDataService) {
        if (this.SEDU == null) {
            this.closeCubeData(jDataService);
            if (this.get != null) {
                try {
                    this.get.destroy();
                }
                catch (DSException dSException) {
                    JRLog.trace(5, dSException);
                }
                this.get = null;
                this.contains = true;
                this.setNeedRefresh(true);
            }
        }
    }

    public void closeCubeData(JDataService jDataService) {
        Tools.logTrace(6, "DataSetCenter.closeCubeData()...");
        if (this.getCFFormulas != null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "close cube query, id: " + this.getCFFormulas);
            }
            this.cancel(this.getCFFormulas, jDataService);
            this.getBurstingSchemas = null;
            this.getCFFormulas = null;
        }
        this.setNeedInitCubeQuery(true);
        this.setNeedRefreshCube(true);
        Tools.logTrace(6, "End of DataSetCenter.closeCubeData().");
    }

    private void cancel(int n, JDataService jDataService) {
        jDataService.closeQuery(n);
    }

    public void clearAllColumnValues(JDataService jDataService) {
        HashMap[] hashMapArray = new HashMap[]{this.getAvailableKeyDataSourceQuery, this.getBindInfo};
        for (int i = 0; i < hashMapArray.length; ++i) {
            if (hashMapArray[i] == null || hashMapArray[i].isEmpty()) continue;
            for (GroupValueContainer groupValueContainer : hashMapArray[i].values()) {
                try {
                    jDataService.closeQuery(groupValueContainer.getGroupQuery().getQueryId());
                }
                catch (DSException dSException) {
                    JRLog.error(3, dSException);
                }
            }
            hashMapArray[i].clear();
        }
    }

    public void clearMem() {
        if (this.addAll != null) {
            this.addAll.clear();
            this.addAll = null;
        }
        if (this.addDimension != null) {
            this.addDimension.clear();
            this.addDimension = null;
        }
        if (this.addElement != null) {
            this.addElement.clear();
            this.addElement = null;
        }
        if (this.addMeasure != null) {
            this.addMeasure.clear();
            this.addMeasure = null;
        }
        if (this.cancel != null) {
            this.cancel.clear();
            this.cancel = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        this.closeCubeData = null;
        this.destroy = null;
        if (this.currentTimeMillis != null) {
            this.currentTimeMillis = null;
        }
        this.equalsForRawData = null;
        this.equalsIgnoreCase = null;
        this.get = null;
        if (this.getDataSetLogic != null) {
            this.getDataSetLogic.clear();
            this.getDataSetLogic = null;
        }
    }

    public boolean isApplyBrowseFilter() {
        return this.getBurstingKeyColumn;
    }

    public void setApplyBrowseFilter(boolean bl) {
        this.getBurstingKeyColumn = bl;
    }

    public void setRawDataListener(DataSetListener dataSetListener) {
        this.getCatalog = dataSetListener;
    }

    public DataSetListener getRawDataListener() {
        return this.getCatalog;
    }

    public void setGeneralRawDataListener(DataSetListener dataSetListener) {
        this.getConstantFormulas = dataSetListener;
    }

    public DataSetListener getGeneralRawDataListener() {
        return this.getConstantFormulas;
    }

    public void refreshRecSecurity(RuntimeEnv runtimeEnv, boolean bl) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "DataSetCenter.refreshRecSecurity()..., userName: " + runtimeEnv.getUserName() + " secData: " + runtimeEnv.getSecurityData() + " secCxt: " + runtimeEnv.getSecurityContext() + " secProvider: " + runtimeEnv.getSecurityProvider() + " ignoreSecurity: " + bl);
        }
        if (bl) {
            this.equalsForRawData = new JRecordSecurityContainer(true);
        } else {
            try {
                this.equalsForRawData = new JRecordSecurityContainer(this.destroy, this.closeCubeData, runtimeEnv);
            }
            catch (ParseException parseException) {
                JRLog.error(3, parseException);
                this.equalsForRawData = new JRecordSecurityContainer();
            }
        }
        Tools.logTrace(6, "End of DataSetCenter.refreshRecSecurity().");
    }

    @Override
    public void clear() {
        if (this.addAll != null) {
            this.addAll.clear();
            this.addAll = null;
        }
        if (this.addDimension != null) {
            this.addDimension.clear();
            this.addDimension = null;
        }
        if (this.addElement != null) {
            this.addElement.clear();
            this.addElement = null;
        }
        if (this.addMeasure != null) {
            this.addMeasure.clear();
            this.addMeasure = null;
        }
        if (this.cancel != null) {
            this.cancel.clear();
            this.cancel = null;
        }
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.clearAllColumnValues != null) {
            this.clearAllColumnValues.clear();
            this.clearAllColumnValues = null;
        }
        this.getBurstingRecipientSchema = null;
    }

    public void backupDataStatus(ReportSetCenter reportSetCenter) {
        this.getDataSetAdditionalMappingNames = new DataSetStatus(reportSetCenter, this.add);
    }

    public boolean hasBackupedDataStatus() {
        return this.getDataSetAdditionalMappingNames != null;
    }

    public boolean equalsForRawData(ReportSetCenter reportSetCenter) {
        return this.getDataSetAdditionalMappingNames == null ? false : this.getDataSetAdditionalMappingNames.equalsForRawData(new DataSetStatus(reportSetCenter, this.add));
    }

    public String[] getDbFieldFormulaMappingNames(boolean bl) {
        Vector vector;
        Vector vector2 = new Vector();
        Vector[] vectorArray = null;
        int n = this.closeCubeData.getMappingListType();
        Vector vector3 = vector = bl ? this.clearAllColumnValues() : null;
        if (this.closeCubeData.getMappingListSrc() == 1) {
            switch (n) {
                case 0: {
                    vectorArray = new Vector[]{this.addElement, this.cancel, this.clear, vector};
                    break;
                }
                case 2: {
                    vectorArray = new Vector[]{this.addAll, this.addDimension, this.cancel, this.clear, vector};
                    break;
                }
                case 1: {
                    vectorArray = new Vector[]{this.addAll, this.cancel, this.clear, vector};
                    break;
                }
            }
        } else {
            vectorArray = new Vector[]{this.addAll, this.cancel, this.clear, vector};
        }
        if (vectorArray != null) {
            for (int i = 0; i < vectorArray.length; ++i) {
                if (vectorArray[i] == null) continue;
                for (int j = 0; j < vectorArray[i].size(); ++j) {
                    Object e = vectorArray[i].elementAt(j);
                    if (vector2.contains(e)) continue;
                    vector2.addElement(e);
                }
            }
        }
        return vector2.toArray(new String[0]);
    }

    private Vector clearAllColumnValues() {
        Vector vector = new Vector();
        if (this.getDataSetCubeViewInfo != null && !this.getDataSetCubeViewInfo.isEmpty()) {
            Iterator iterator = this.getDataSetCubeViewInfo.keySet().iterator();
            while (iterator.hasNext()) {
                PartialDataSet partialDataSet = (PartialDataSet)this.getDataSetCubeViewInfo.get(iterator.next());
                this.closeCubeData(vector, new String[][]{partialDataSet.getDbFields(), partialDataSet.getPass1Formulas(), partialDataSet.getPass2Formulas()});
            }
        }
        return vector;
    }

    private void closeCubeData(Vector vector, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            for (int j = 0; j < stringArray[i].length; ++j) {
                String string = stringArray[i][j];
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
    }

    Vector getMappingNameOfPartialData(int[] nArray) {
        Vector vector = new Vector();
        if (nArray != null && nArray.length > 0 && this.getDataSetCubeViewInfo != null && !this.getDataSetCubeViewInfo.isEmpty()) {
            Iterator iterator = this.getDataSetCubeViewInfo.keySet().iterator();
            while (iterator.hasNext()) {
                PartialDataSet partialDataSet = (PartialDataSet)this.getDataSetCubeViewInfo.get(iterator.next());
                String[][] stringArray = new String[nArray.length][];
                block10: for (int i = 0; i < nArray.length; ++i) {
                    switch (nArray[i]) {
                        case 0: {
                            stringArray[i] = partialDataSet.getDbFields();
                            continue block10;
                        }
                        case 1: {
                            stringArray[i] = partialDataSet.getParameters();
                            continue block10;
                        }
                        case 2: {
                            stringArray[i] = partialDataSet.getPass1Formulas();
                            continue block10;
                        }
                        case 5: {
                            stringArray[i] = partialDataSet.getPass2Formulas();
                            continue block10;
                        }
                        case 3: {
                            stringArray[i] = partialDataSet.getConstantFormulas();
                            continue block10;
                        }
                        case 4: {
                            stringArray[i] = partialDataSet.getGlobalFormulas();
                            continue block10;
                        }
                        case 6: {
                            stringArray[i] = partialDataSet.getGroupFormulas();
                            continue block10;
                        }
                    }
                }
                this.closeCubeData(vector, stringArray);
            }
        }
        return vector;
    }

    public void setDataBlock(DataBlock dataBlock) {
        this.getDataSetInfo = dataBlock;
    }

    public DataBlock getDataBlock() {
        return this.getDataSetInfo;
    }

    public void cacheDisplayNameValues(Map map) {
        if (map != null) {
            this.getDataSetLogic = new HashMap();
            this.getDataSetLogic.putAll(map);
        }
    }

    public Hashtable getCachedDisplayNameValues() {
        if (this.getDataSetLogic == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.getDataSetLogic);
        return hashtable;
    }

    public boolean hasCachedDisplayNameValues() {
        return this.getDataSetLogic != null;
    }

    public void clearCachedDisplayNameValuese() {
        this.getDataSetLogic = null;
    }

    private class DataSetStatus {
        private int[] SEDU = new int[]{0, 1, 2, 3, 4};
        private String[][] addElement;
        private CubeModel append = null;
        private int equals = -1;
        private int error = -1;
        private int get = -1;
        private QueryInfo getBlName = null;
        private IExpression getCatalogName = null;
        private String getCategory = null;
        private JRecordSecurityContainer getCubeModel = null;
        private boolean getDataDriver = false;

        DataSetStatus(ReportSetCenter reportSetCenter, String string) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DataSetStatus()... rptSetCenter: " + reportSetCenter + " dataSetName: " + string);
            }
            DataSetCenter dataSetCenter2 = reportSetCenter.getDataSetCenter(string);
            this.addElement = new String[this.SEDU.length][];
            for (int i = 0; i < this.addElement.length; ++i) {
                this.addElement[i] = dataSetCenter2.getMappingNames(this.SEDU[i]);
                Arrays.sort(this.addElement[i]);
            }
            this.append = dataSetCenter2.getCubeModel();
            JetRptDataSet jetRptDataSet = dataSetCenter2.getDataSet();
            this.equals = jetRptDataSet.maxRecords.get();
            this.error = jetRptDataSet.maxPageNumber.get();
            this.get = jetRptDataSet.recordsPerPage.get();
            this.getBlName = new QueryInfoImpl(jetRptDataSet.getCatalogName(), jetRptDataSet.getDataSourceName(), jetRptDataSet.getQueryName(), jetRptDataSet.getBlName(), jetRptDataSet.getDataResourceType());
            try {
                this.getCatalogName = jetRptDataSet.getIExpression();
            }
            catch (ConditionException conditionException) {
                JRLog.error(2, conditionException);
            }
            this.getCategory = reportSetCenter.getDataDriver(string);
            this.getCubeModel = dataSetCenter2.getSecContainer();
            this.getDataDriver = jetRptDataSet.hasRecSec();
            Tools.logTrace(6, "End of DataSetStatus().");
        }

        boolean equalsForRawData(DataSetStatus dataSetStatus) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "DataSetCenter.equalsForRawData()... dss: " + dataSetStatus);
            }
            for (int i = 0; i < this.addElement.length; ++i) {
                if (this.append(this.addElement[i], dataSetStatus.addElement[i])) continue;
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), names don't equals, return false!");
                return false;
            }
            if (this.equals != dataSetStatus.equals) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), maxRecords don't equals, return false!");
                return false;
            }
            if (this.error != dataSetStatus.error) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), maxPageNumber don't equals, return false!");
                return false;
            }
            if (this.get != dataSetStatus.get) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), recordsPerPage don't equals, return false!");
                return false;
            }
            if (!this.getBlName.isEquals(dataSetStatus.getBlName)) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), queryInfo don't equals, return false!");
                return false;
            }
            if (!ExpressionToolKit.equals(this.getCatalogName, dataSetStatus.getCatalogName)) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), filter don't equals, return false!");
                return false;
            }
            if (!this.SEDU(this.getCategory, dataSetStatus.getCategory)) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), dataDriver don't equals, return false!");
                return false;
            }
            if (this.getDataDriver || this.getDataDriver != dataSetStatus.getDataDriver) {
                Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), hasRecordSecurity don't equals, return false!");
                return false;
            }
            Tools.logTrace(6, "End of DataSetCenter.equalsForRawData(), return true!");
            return true;
        }

        private boolean SEDU(String string, String string2) {
            if (string != null && string2 == null || string == null && string2 != null) {
                return false;
            }
            if (string == null && string2 == null) {
                return true;
            }
            return string.equals(string2);
        }

        private boolean addElement(JRecordSecurityContainer jRecordSecurityContainer, JRecordSecurityContainer jRecordSecurityContainer2, JetUUniverse jetUUniverse, String string, String string2) {
            if (jRecordSecurityContainer != null && jRecordSecurityContainer2 == null || jRecordSecurityContainer == null && jRecordSecurityContainer2 != null) {
                return false;
            }
            if (jRecordSecurityContainer == null && jRecordSecurityContainer2 == null) {
                return true;
            }
            int n = jRecordSecurityContainer.getCategory();
            if (n != jRecordSecurityContainer2.getCategory()) {
                return false;
            }
            if (n != 0) {
                boolean bl = jRecordSecurityContainer.isNoRecordForSecurity();
                if (bl ^ jRecordSecurityContainer2.isNoRecordForSecurity()) {
                    return false;
                }
                if (!bl) {
                    IBooleanExpression iBooleanExpression = null;
                    IBooleanExpression iBooleanExpression2 = null;
                    try {
                        iBooleanExpression = jRecordSecurityContainer.getIExpressionForRecord(jetUUniverse, string, string2);
                        iBooleanExpression2 = jRecordSecurityContainer2.getIExpressionForRecord(jetUUniverse, string, string2);
                    }
                    catch (JRScheduleException jRScheduleException) {
                        JRLog.error(2, jRScheduleException);
                        return false;
                    }
                    catch (ConditionException conditionException) {
                        JRLog.error(2, conditionException);
                        return false;
                    }
                    String string3 = jRecordSecurityContainer.getWhereStringForAcl();
                    String string4 = jRecordSecurityContainer2.getWhereStringForAcl();
                    try {
                        if (!this.SEDU(string3, string4) || this.SEDU(iBooleanExpression.toExpString(), iBooleanExpression2.toExpString())) {
                            return false;
                        }
                    }
                    catch (ConditionException conditionException) {
                        JRLog.error(2, conditionException);
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean append(String[] stringArray, String[] stringArray2) {
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            if (stringArray.length == 0) {
                return true;
            }
            List list = this.equals(stringArray);
            List list2 = this.equals(stringArray2);
            return ((Object)list).equals(list2);
        }

        private List equals(String[] stringArray) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            return vector;
        }
    }

    class GroupValueContainer {
        private JGroupQuery SEDU = null;
        private Group I = null;
        private List Z = null;

        GroupValueContainer(JGroupQuery jGroupQuery) {
            this.SEDU = jGroupQuery;
        }

        JGroupQuery getGroupQuery() {
            return this.SEDU;
        }

        void setGroup(Group group) {
            this.I = group;
        }

        Group getGroup() {
            return this.I;
        }

        void setValues(List list) {
            this.Z = list;
        }

        List getValues() {
            return this.Z;
        }
    }
}

