/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.engine.infocenter;

import com.jinfonet.util.JRLog;
import java.util.Vector;
import jet.datasource.InputStreamFactory;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUDBField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;

public class QueryInfo {
    private String SEDU;
    private String addElement;
    private Vector append = null;
    private Vector canSummary;
    private boolean clear = false;
    private InputStreamFactory clone;

    public QueryInfo(String string, String string2) {
        this.SEDU = string;
        this.addElement = string2;
    }

    public String getDataSourceName() {
        return this.SEDU;
    }

    public String getQueryName() {
        return this.addElement;
    }

    public Vector getUsedParameter() {
        return this.canSummary == null ? null : (Vector)this.canSummary.clone();
    }

    public void addUsedParameter(String string) {
        if (this.canSummary == null) {
            this.canSummary = new Vector();
        }
        if (!this.canSummary.contains(string)) {
            this.canSummary.addElement(string);
        }
    }

    public boolean containsUsedParameter(String string) {
        return this.canSummary == null ? false : this.canSummary.contains(string);
    }

    public void setHasInitParams(boolean bl) {
        this.clear = bl;
    }

    public boolean hasInitParams() {
        return this.clear;
    }

    public Vector getAvlGroupFields(JetUUniverse jetUUniverse) {
        if (this.append == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "QueryInfo.getAvlGroupFields()..., dataSourceName: " + this.SEDU + " queryName: " + this.addElement);
            }
            this.append = new Vector();
            Vector vector = jetUUniverse.getAvailableResourceEntitys(this.SEDU, this.addElement);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)vector.elementAt(i);
                if (jetUResourceEntity instanceof JetUDBField) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "db field, name: " + (jetUResourceEntity == null ? "NULL" : jetUResourceEntity.getResourceName()) + " re: " + jetUResourceEntity);
                    }
                    this.append.addElement(jetUResourceEntity.getResourceName());
                    continue;
                }
                if (jetUResourceEntity instanceof JetUFmlQueryField) {
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "JetUFmlQueryField, name: " + (jetUResourceEntity == null ? "NULL" : jetUResourceEntity.getResourceName()) + " re: " + jetUResourceEntity);
                    }
                    this.append.addElement(jetUResourceEntity.getResourceName());
                    continue;
                }
                if (!(jetUResourceEntity instanceof JetUFormula)) continue;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "formula, name: " + (jetUResourceEntity == null ? "NULL" : jetUResourceEntity.getResourceName()) + " re: " + jetUResourceEntity);
                }
                if (!((JetUFormula)jetUResourceEntity).canSummary()) continue;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "formula and can summary, name: " + (jetUResourceEntity == null ? "NULL" : jetUResourceEntity.getResourceName()));
                }
                if (ReportTools.getFormulaType(jetUUniverse, this.SEDU, (JetUFormula)jetUResourceEntity) == 101) continue;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "formula and can summary and not page level formula, name: " + (jetUResourceEntity == null ? "NULL" : jetUResourceEntity.getResourceName()));
                }
                this.append.addElement(jetUResourceEntity.getResourceName());
            }
        }
        return this.append;
    }

    public void resetInitUsedParameter() {
        this.clear = false;
        if (this.canSummary != null) {
            this.canSummary.clear();
            this.canSummary = null;
        }
    }

    public void setStreamFactory(InputStreamFactory inputStreamFactory) {
        this.clone = inputStreamFactory;
    }

    public InputStreamFactory getStreamFactory() {
        return this.clone;
    }
}

