/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.impl;

import com.jinfonet.util.JRLog;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.parameter.definition.BindColumn;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.impl.CatalogParameterEnvInfo;
import jet.rptservice.impl.ParameterEnvInfo;
import jet.rptservice.impl.ParameterInteractiveModeEnvImpl;
import jet.rptservice.util.ParameterSortor;
import jet.rptservice.util.Tools;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUParameter;
import jet.universe.tools.UniverseTools;
import jet.util.ParameterValueDesc;

public class CatalogDataSourceParameterEnvImpl
extends ParameterInteractiveModeEnvImpl {
    private Hashtable SEDU = new Hashtable();
    private String add;
    private List addReferedParameters;

    public CatalogDataSourceParameterEnvImpl(ParameterEnvInfo parameterEnvInfo) throws JRScheduleException {
        this.info = parameterEnvInfo;
        this.init();
    }

    @Override
    protected void init() throws JRScheduleException {
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "CatalogDataSourceParameterEnvImpl init():" + this.info);
        }
        super.init();
        this.add = ((CatalogParameterEnvInfo)this.info).getDataSource();
        String[] stringArray = this.unv.getOrderedParameterNames();
        this.addReferedParameters = ((CatalogParameterEnvInfo)this.info).getOfferedParamNames();
        if (stringArray != null) {
            this.vFinalOrderParamNames = new Vector<String>(Arrays.asList(stringArray));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, this.getClass().getName() + " catalog Params order: " + this.vFinalOrderParamNames);
        }
        this.SEDU();
        this.initParamGraph();
        this.initConstantFormulaExecuteInfoProvider();
    }

    @Override
    void initParamGraph() {
        this.paramGraph = this.buildParamGraph(this.paramBuff);
    }

    private void SEDU() throws JRScheduleException {
        this.SEDU.clear();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CatalogDataSourceParameterEnvImpl.initPramBuff(" + this.add + ")");
        }
        if (this.paramBuff == null) {
            this.paramBuff = new Hashtable();
        } else {
            this.paramBuff.clear();
        }
        this.initParameters();
        this.addReferedParameters(this.paramBuff, this.paramBuff);
        String[] stringArray = this.paramBuff.keySet().toArray(new String[0]);
        if (!this.paramBuff.isEmpty()) {
            this.buildQueryParameterReference(stringArray, this.paramBuff);
        }
        this.add(true);
        this.SEDU.put(this.add, this.sortParams(this.initParametersTypeParams((Vector)this.SEDU.get(this.add), null, null, this.paramBuff)));
        this.initParameterPromptNLS();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ParameterEnv.initPramBuff(), all param: " + this.paramBuff);
        }
    }

    public void initParameters() throws JRScheduleException {
        Vector<ParamDesc> vector;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CatalogDataSourceParameterEnvImpl.initParameters(" + this.add + ") ");
        }
        if ((vector = (Vector<ParamDesc>)this.SEDU.get(this.add)) == null) {
            vector = new Vector<ParamDesc>();
            this.SEDU.put(this.add, vector);
        }
        Vector<JetUParameter> vector2 = null;
        if (this.addReferedParameters != null && !this.addReferedParameters.isEmpty()) {
            vector2 = new Vector<JetUParameter>();
            for (Object object : this.addReferedParameters) {
                JetUParameter jetUParameter = this.unv.getDatabase(this.add).getParameterByResourceName((String)object);
                vector2.add(jetUParameter);
            }
        } else {
            vector2 = this.unv.getParameters(this.add);
        }
        if (vector2 != null) {
            Object object;
            Object object2 = null;
            object = null;
            for (int i = 0; i < vector2.size(); ++i) {
                object = (JetUParameter)vector2.get(i);
                object2 = ((JetUDBTreeNode)object).getResourceName();
                ParamDesc paramDesc = ((JetUParameter)object).getParamDesc();
                if (paramDesc == null) continue;
                this.paramBuff.put(((String)object2).toUpperCase(), paramDesc);
                vector.add(paramDesc);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CatalogDataSourceParameterEnvImpl.initParameters(), all param: " + this.paramBuff);
        }
    }

    private boolean add(boolean bl) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CatalogDataSourceParameterEnvImpl.importParamValues()..., getShowValues: " + bl);
        }
        if (bl) {
            try {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "get show value...");
                }
                this.append();
            }
            catch (SQLException sQLException) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, sQLException);
                }
                throw new JRScheduleException(220052, (Object[])new String[]{sQLException.getMessage()}, (Throwable)sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, classNotFoundException);
                }
                throw new JRScheduleException(220014, (Throwable)classNotFoundException);
            }
            catch (InvalidParameterException invalidParameterException) {
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, invalidParameterException);
                }
                throw new JRScheduleException(220014, (Throwable)invalidParameterException);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CatalogDataSourceParameterEnvImpl.importParamValues(), all param: " + this.paramBuff);
        }
        return true;
    }

    private String[] addReferedParameters() {
        if (this.paramBuff == null || this.paramBuff.isEmpty()) {
            return new String[0];
        }
        String[] stringArray = new String[this.paramBuff.size()];
        int n = 0;
        String[] stringArray2 = this.paramBuff.keySet().iterator();
        while (stringArray2.hasNext()) {
            stringArray[n++] = (String)stringArray2.next();
        }
        stringArray2 = new ParameterSortor(stringArray, this.paramBuff).sort();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CatalogDataSourceParameterEnvImpl.sortParameters(), result: " + Tools.toString(stringArray2));
        }
        return stringArray2;
    }

    private void append() throws SQLException, ClassNotFoundException, InvalidParameterException {
        Iterator iterator = this.paramBuff.keySet().iterator();
        while (iterator.hasNext()) {
            ParamDesc paramDesc = (ParamDesc)this.paramBuff.get(iterator.next());
            if (paramDesc == null) continue;
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "for parameter + " + paramDesc.getName());
            }
            this.initParamRuntime(paramDesc, this.paramBuff);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CatalogDataSourceParameterEnvImpl.initParamValue().");
        }
    }

    private void asList(Vector vector, Hashtable hashtable) {
        ParamDesc paramDesc = null;
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            paramDesc = (ParamDesc)vector.get(i);
            if (!paramDesc.isCascading() || !hashtable.containsKey(paramDesc.getPreviousLevel().toUpperCase()) || vector.contains(hashtable.get(paramDesc.getPreviousLevel().toUpperCase()))) continue;
            vector.add(hashtable.get(paramDesc.getPreviousLevel().toUpperCase()));
        }
    }

    @Override
    protected ParamDesc[] processParametersTypeParams(String string, ParameterValueDesc parameterValueDesc) {
        return new ParamDesc[0];
    }

    public Hashtable getAllParameters() throws JRScheduleException {
        return this.getAllParameters(false);
    }

    @Override
    public Hashtable getAllParameters(boolean bl) throws JRScheduleException {
        if (bl) {
            this.init();
        }
        return this.getReturnBuff(this.paramBuff);
    }

    private boolean buildParamGraph(Hashtable hashtable, Hashtable hashtable2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "CatalogDataSourceParameterEnv.putReferencedParameters()..., dest: " + hashtable + " src: " + hashtable2);
        }
        boolean bl = true;
        if (hashtable2 != null && !hashtable2.isEmpty()) {
            Hashtable hashtable3 = new Hashtable(hashtable2);
            for (ParamDesc paramDesc : hashtable3.values()) {
                bl = bl && this.buildQueryParameterReference(hashtable, paramDesc);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CatalogDataSourceParameterEnv.putReferencedParameters()..., return: " + bl);
        }
        return bl;
    }

    private boolean buildQueryParameterReference(Hashtable hashtable, ParamDesc paramDesc) {
        BindColumn bindColumn;
        Object object;
        Object object2;
        Object object3;
        String string;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "putParameter()..., dest: " + hashtable + " pd: " + paramDesc);
        }
        if (!hashtable.containsKey(string = paramDesc.getName().toUpperCase())) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "put referenced parameter: " + paramDesc);
            }
            hashtable.put(string, paramDesc);
        }
        String string2 = paramDesc.getDataSource();
        boolean bl = true;
        String string3 = paramDesc.getBinding();
        if (string3 != null && !string3.equals("") && !hashtable.containsKey(object3 = string3.toUpperCase())) {
            ParamDesc paramDesc2 = UniverseTools.getParamDesc((String)object3, this.unv, string2);
            if (paramDesc2 == null) {
                paramDesc2 = UniverseTools.getParamDesc((String)object3, this.unv);
            }
            if (paramDesc2 == null) {
                bl = false;
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "parameter: " + (String)object3 + " don't exist!");
                }
            } else {
                hashtable.put(object3, paramDesc2);
            }
        }
        if ((object3 = paramDesc.getImportParams()) != null && !object3.isEmpty()) {
            for (int i = 0; i < object3.size(); ++i) {
                String string4 = ((String)object3.get(i)).toUpperCase();
                if (hashtable.containsKey(string4)) continue;
                object2 = UniverseTools.getParamDesc(string4, this.unv, string2);
                if (object2 == null) {
                    object2 = UniverseTools.getParamDesc(string4, this.unv);
                }
                if (object2 == null) {
                    bl = false;
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, "parameter: " + string4 + " don't exist!");
                    continue;
                }
                bl = bl && this.buildQueryParameterReference(hashtable, (ParamDesc)object2);
            }
        }
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        vector.add(paramDesc);
        object3 = ResourceTool.getOnParameterValueChangeUsedParameterNames(this.unv, null, vector);
        if (object3 != null && !object3.isEmpty()) {
            for (int i = 0; i < object3.size(); ++i) {
                object2 = ((String)object3.get(i)).toUpperCase();
                if (hashtable.containsKey(object2)) continue;
                object = UniverseTools.getParamDesc((String)object2, this.unv, string2);
                if (object == null) {
                    object = UniverseTools.getParamDesc((String)object2, this.unv);
                }
                if (object == null) {
                    bl = false;
                    if (!JRLog.isTrace(5)) continue;
                    JRLog.trace(5, "parameter: " + (String)object2 + " don't exist!");
                    continue;
                }
                bl = bl && this.buildQueryParameterReference(hashtable, (ParamDesc)object);
            }
        }
        if ((bindColumn = paramDesc.getDefinition().getBindColumn()) != null && bindColumn.getBindType() == 0) {
            block24: {
                object2 = bindColumn.getQueryName();
                object = null;
                try {
                    object = this.getQueryParamNames(paramDesc.getDataSource(), (String)object2, null, null);
                }
                catch (JRScheduleException jRScheduleException) {
                    if (!JRLog.isTrace(5)) break block24;
                    JRLog.trace(5, jRScheduleException);
                }
            }
            if (object != null && ((String[])object).length > 0) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (hashtable.containsKey(object[i].toUpperCase())) continue;
                    ParamDesc paramDesc3 = UniverseTools.getParamDesc(object[i], this.unv, paramDesc.getDataSource());
                    if (paramDesc3 == null) {
                        paramDesc3 = UniverseTools.getParamDesc(object[i], this.unv);
                    }
                    if (paramDesc3 == null) {
                        bl = false;
                        if (!JRLog.isTrace(5)) continue;
                        JRLog.trace(5, "Get parameter bind of query parameter: " + string + " of " + (String)object2 + " don't exist!");
                        continue;
                    }
                    bl = bl && this.buildQueryParameterReference(hashtable, paramDesc3);
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of CatalogDataSourceParameterEnv.putParameter()..., return: " + bl);
        }
        return bl;
    }

    @Override
    void initConstantFormulaExecuteInfoProvider() {
        this.fep = this.createvConstantFormulaExecuteInfoProvider(null, null, this.getParamNames(this.paramBuff), this.paramBuff);
    }
}

