/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.pub;

import com.jinfonet.util.JRLog;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.exception.InvalidParameterException;
import jet.formula.JavaFormula;
import jet.formula.ParamDesc;
import jet.parameter.runtime.ParameterRuntime;
import jet.reportLogic.objectInfo.SubRptParamInfo;
import jet.rptservice.api.IAvailableGroupFieldsProvider;
import jet.rptservice.api.IDynamicConnectionInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.ParamInitRadicle;
import jet.rptservice.pub.ParameterRuntimeEnv;
import jet.rptservice.util.Tools;
import jet.server.intf.engine.ConnectionInfoProvider;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.util.ImportParamValues;
import jet.util.ValueListFetcherContextImpl;
import toolkit.db.ConnectionInfo;

public class ParameterIntegrator {
    private static String[] SEDU = new String[]{"ASCENDING", "DESCENDING"};
    private final ParameterRuntimeEnv add;
    private IAvailableGroupFieldsProvider addElement;

    public ParameterIntegrator(ParameterRuntimeEnv parameterRuntimeEnv, IAvailableGroupFieldsProvider iAvailableGroupFieldsProvider) {
        if (parameterRuntimeEnv == null) {
            throw new IllegalArgumentException("env == null!");
        }
        this.add = parameterRuntimeEnv;
        this.addElement = iAvailableGroupFieldsProvider;
    }

    public ParamDesc initParameter(ParamDesc paramDesc, ParamInitRadicle paramInitRadicle, ParamInitRadicle[] paramInitRadicleArray, SubRptParamInfo subRptParamInfo) throws JRScheduleException {
        String string;
        Iterator iterator;
        Object object;
        Object object2;
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "ParameterAdapter.initParameter()..., radicle: " + paramInitRadicle + " allRadicles: " + Tools.toString(paramInitRadicleArray) + " subRptParamInfo: " + subRptParamInfo);
        }
        String string2 = paramInitRadicle.getParamName();
        int n = paramInitRadicle.getParamType();
        if (n != 1) {
            paramDesc.setBeColumn(n);
        }
        if (n == 5) {
            try {
                this.addReferParamToVsortParams(paramDesc);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new JRScheduleException(220057, (Object[])new String[]{string2}, (Throwable)invalidParameterException);
            }
        }
        if (paramInitRadicle.inGroupParams() && n == 1) {
            paramDesc.setBeColumn(1);
        }
        HashMap hashMap = new HashMap();
        if (!paramInitRadicle.inParamToSubRpt()) {
            object2 = this.addReferedParameters(paramInitRadicleArray);
            object = paramInitRadicle.getImportParamValuesNames();
            if (object != null && !object.isEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.cascadeParams(paramDesc, string, (List)object2, hashMap);
                }
            }
        } else if (n == 1) {
            paramDesc.setBeColumn(1);
        }
        if (paramInitRadicle.inSubRptParams()) {
            object2 = this.append(paramInitRadicleArray);
            object = paramInitRadicle.getImportParamValuesNames();
            if (object != null && !object.isEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    this.cascadeParams(paramDesc, string, (List)object2, hashMap);
                }
            }
        }
        if (paramInitRadicle.inParamToSubRpt()) {
            object2 = subRptParamInfo.getSubRptAvlGrp();
            if (object2 != null && !((Hashtable)object2).isEmpty() && (object = paramInitRadicle.getBeColInSubRptNames()) != null && !object.isEmpty()) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Map map = (Map)((Hashtable)object2).get(string);
                    if (!map.containsKey(string2)) continue;
                    Vector vector = (Vector)map.get(string2);
                    try {
                        this.containsKey(vector, new ParamDesc[]{paramDesc});
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        throw new JRScheduleException(220014, (Throwable)invalidParameterException);
                    }
                }
            }
        } else if (paramInitRadicle.inGroupParams()) {
            object2 = paramInitRadicle.getQueryNames();
            object = paramDesc.getDataSource();
            iterator = this.createValueListFetcher((String)object, (List)object2);
            try {
                this.containsKey((Vector)((Object)iterator), new ParamDesc[]{paramDesc});
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new JRScheduleException(220014, (Throwable)invalidParameterException);
            }
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "End of ParameterAdapter.initParameter(), return: " + paramDesc);
        }
        return paramDesc;
    }

    boolean matchType(ParamDesc paramDesc, ParamInitRadicle paramInitRadicle) {
        int n;
        int n2;
        boolean bl;
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "ParameterAdapter.matchType()..., pd: " + paramDesc + " radicle: " + paramInitRadicle);
        }
        boolean bl2 = bl = (n2 = paramInitRadicle.getParamType()) == (n = paramDesc.getBeColumn());
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "radicle.type: " + n2 + " pd.beColumn: " + n);
            JRLog.trace(6, "End of ParameterAdapter.matchType(), return: " + bl);
        }
        return bl;
    }

    public void buildRuntimeReference(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null || hashtable.isEmpty()) {
            return;
        }
        for (ParamDesc paramDesc : hashtable.values()) {
            this.initParamRuntimeEnv(paramDesc, hashtable2);
        }
        this.addReferedParameters(hashtable, hashtable2);
    }

    public void initParamRuntimeEnv(ParamDesc paramDesc, Hashtable hashtable) {
        ParameterRuntime parameterRuntime = paramDesc.getParameterRuntime();
        if (parameterRuntime != null) {
            JavaFormula javaFormula;
            ValueListFetcherContextImpl valueListFetcherContextImpl;
            block5: {
                valueListFetcherContextImpl = new ValueListFetcherContextImpl();
                valueListFetcherContextImpl.setUniverse(this.add.getUniverse());
                valueListFetcherContextImpl.setRelatedParameters(ParameterIntegrator.SEDU(paramDesc, hashtable));
                valueListFetcherContextImpl.setUserName(this.add.getUserName());
                valueListFetcherContextImpl.setSecurityContext(paramDesc.getSecurityEntry(), this.add.getSecurityContext());
                valueListFetcherContextImpl.setSecurityData(this.add.getSecurityData());
                valueListFetcherContextImpl.setMaxItemCount(this.add.getLimitedRecNum());
                valueListFetcherContextImpl.setLocale(this.add.getLocale());
                String string = paramDesc.getDataSource();
                this.addElement(valueListFetcherContextImpl, string, this.add.getRuntimeQueryInfoProvider());
                valueListFetcherContextImpl.setParamUsedByQuery(this.add(paramDesc, hashtable));
                String string2 = paramDesc.getName().toUpperCase();
                Hashtable hashtable2 = this.add.getFlyFormulas(string2);
                if (hashtable2 != null) {
                    valueListFetcherContextImpl.setReportFormulas(hashtable2);
                }
                javaFormula = null;
                try {
                    javaFormula = this.add.getFlyJavaFormula(string2);
                }
                catch (JRScheduleException jRScheduleException) {
                    if (!JRLog.isTrace(4)) break block5;
                    JRLog.trace(4, jRScheduleException);
                }
            }
            if (javaFormula != null) {
                valueListFetcherContextImpl.setFlyJavaFormula(javaFormula);
            }
            parameterRuntime.createValueListFetcher(this.add.getDataService(), this.add.getCatalogKey(), valueListFetcherContextImpl);
        }
    }

    public void addReferedParameters(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == null) {
            return;
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.elements();
        ParamDesc paramDesc = null;
        while (enumeration.hasMoreElements()) {
            ParameterRuntime parameterRuntime;
            paramDesc = (ParamDesc)enumeration.nextElement();
            if (paramDesc.getImportParams().size() != 0) {
                paramDesc.addReferParamToVsortParams(hashtable2, hashtable, vector);
            }
            if ((parameterRuntime = paramDesc.getParameterRuntime()) == null) continue;
            parameterRuntime.cascadeParams(hashtable2, hashtable, vector);
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (hashtable.get(((String)vector.get(i)).toUpperCase()) != null) continue;
            hashtable.put(((String)vector.get(i)).toUpperCase(), vector.get(i));
        }
    }

    private static Hashtable SEDU(ParamDesc paramDesc, Hashtable hashtable) {
        Hashtable<String, ParamDesc> hashtable2 = new Hashtable<String, ParamDesc>();
        Vector vector = paramDesc.getImportParams();
        ParamDesc paramDesc2 = null;
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                paramDesc2 = (ParamDesc)hashtable.get(((String)vector.get(i)).toUpperCase());
                if (paramDesc2 == null) continue;
                hashtable2.put(paramDesc2.getName().toUpperCase(), paramDesc2);
            }
        }
        return hashtable2;
    }

    private Vector add(ParamDesc paramDesc, Hashtable hashtable) {
        Vector<ParamDesc> vector = new Vector<ParamDesc>();
        Vector vector2 = paramDesc.getParameterRuntime().getParamsUsedInQuery();
        if (vector2 == null || vector2.isEmpty()) {
            return null;
        }
        for (String string : vector2) {
            String string2 = string.toUpperCase();
            ParamDesc paramDesc2 = (ParamDesc)hashtable.get(string2);
            if (paramDesc2 == null || vector.contains(paramDesc2)) continue;
            vector.add(paramDesc2);
        }
        return vector;
    }

    private void addElement(ValueListFetcherContextImpl valueListFetcherContextImpl, String string, IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider) {
        if (iRuntimeQueryInfoProvider != null) {
            JetUDatabase jetUDatabase = this.add.getUniverse().getDatabase(string);
            if (jetUDatabase == null) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "invalid data source name: " + string);
                }
                return;
            }
            Vector vector = jetUDatabase.getConnections();
            if (vector == null || vector.isEmpty()) {
                Tools.logTrace(4, "no any connections.");
                return;
            }
            for (JetUConnection jetUConnection : vector) {
                Object object;
                String string2 = jetUConnection.getResourceName();
                IDynamicConnectionInfo iDynamicConnectionInfo = iRuntimeQueryInfoProvider.getDynamicConnectionInfo(string, string2);
                if (iDynamicConnectionInfo != null) {
                    object = new Properties();
                    int n = iDynamicConnectionInfo.getType();
                    switch (n) {
                        case 1: {
                            valueListFetcherContextImpl.setConnection(string2, iDynamicConnectionInfo.getConnection());
                            break;
                        }
                        case 3: {
                            ConnectionInfoProvider connectionInfoProvider = iDynamicConnectionInfo.getConnectionInfoProvider();
                            try {
                                object = connectionInfoProvider.getConnectionInfo(string2);
                            }
                            catch (RemoteException remoteException) {
                                if (!JRLog.isTrace(5)) break;
                                JRLog.trace(5, remoteException);
                                break;
                            }
                            if (object == null) break;
                            valueListFetcherContextImpl.setConnectionInfo(string2, (Properties)object);
                            break;
                        }
                        case 2: {
                            Object object2;
                            String string3 = iDynamicConnectionInfo.getJdbcDriver();
                            String string4 = iDynamicConnectionInfo.getUrl();
                            if (jetUConnection instanceof JetUJDBCConnection) {
                                object2 = (JetUJDBCConnection)jetUConnection;
                                if (string3 == null) {
                                    string3 = ((JetUJDBCConnection)object2).getJdbcDriver();
                                }
                                if (string4 == null) {
                                    string4 = ((JetUJDBCConnection)object2).getURL();
                                }
                            }
                            ((Properties)object).put("jrs.catalog_connection_type", "JDBC");
                            if (string4 != null) {
                                ((Properties)object).put("jrs.jdbc_url", string4);
                            }
                            if (string3 != null) {
                                ((Properties)object).put("jrs.jdbc_driver", string3);
                            }
                            if (iDynamicConnectionInfo.getUserId() != null) {
                                ((Properties)object).put("jrs.ds_user", iDynamicConnectionInfo.getUserId());
                            }
                            if (iDynamicConnectionInfo.getPassword() != null) {
                                ((Properties)object).put("jrs.ds_pswd", iDynamicConnectionInfo.getPassword());
                            }
                            object2 = new ConnectionInfo(string4, iDynamicConnectionInfo.getUserId(), iDynamicConnectionInfo.getPassword());
                            if (string3 != null) {
                                ((ConnectionInfo)object2).setDriver(string3);
                            }
                            valueListFetcherContextImpl.setConnectionInfo(string2, (Properties)object);
                            break;
                        }
                    }
                }
                if ((object = iRuntimeQueryInfoProvider.getDatabaseMetadataInfo(string, string2)) == null) continue;
                valueListFetcherContextImpl.setDatabaseMetadataInfo(string2, (DatabaseMetadataInfo)object);
            }
        }
    }

    private boolean addReferParamToVsortParams(ParamDesc paramDesc) throws InvalidParameterException {
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "ParameterAdapter.initSortOrderParameter()..., pd: " + paramDesc);
        }
        String string = paramDesc.getName().toUpperCase();
        if (paramDesc.getBeColumn() != 5) {
            if (JRLog.isTrace(6)) {
                Tools.logTrace(6, "pd.getBeColumn(): " + paramDesc.getBeColumn());
                Tools.logTrace(6, "End of ParameterAdapter.initSortOrderParameter(), not sort order parameter, return false!");
            }
            return false;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < SEDU.length; ++i) {
            vector.addElement(SEDU[i]);
        }
        paramDesc.setValues(vector, this.add.getLocale());
        ParameterIntegrator.setDefaultIndex(paramDesc, 0);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ParameterAdapter.initSortOrderParameter(), return true.");
        }
        return false;
    }

    public static void setDefaultIndex(ParamDesc paramDesc, int n) {
        if (!paramDesc.isMultipleValue() || !paramDesc.isAllSelected()) {
            paramDesc.setDefaultIndex(n);
        }
    }

    private List addReferedParameters(ParamInitRadicle[] paramInitRadicleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < paramInitRadicleArray.length; ++i) {
            if (paramInitRadicleArray[i].inParamToSubRpt()) continue;
            arrayList.add(paramInitRadicleArray[i].getParamName());
        }
        return arrayList;
    }

    private List append(ParamInitRadicle[] paramInitRadicleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < paramInitRadicleArray.length; ++i) {
            if (!paramInitRadicleArray[i].inSubRptParams()) continue;
            arrayList.add(paramInitRadicleArray[i].getParamName());
        }
        return arrayList;
    }

    private void cascadeParams(ParamDesc paramDesc, String string, List list, HashMap hashMap) throws JRScheduleException {
        String string2;
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            Tools.logTrace(6, "ParameterAdapter.importValues()..., pd: " + paramDesc + " className: " + string + " listParamName: " + list);
        }
        if (!this.contains(string2 = paramDesc.getName(), list)) {
            return;
        }
        Hashtable hashtable = this.elementAt(string, list, hashMap);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string3.equalsIgnoreCase(string2)) continue;
                Vector vector = (Vector)hashtable.get(string3);
                if (paramDesc.getBeColumn() == 5 || paramDesc.isUseCurrentDate() || paramDesc.isUseCurrentDateWhenBlank()) continue;
                String string4 = string3.toUpperCase();
                boolean bl = vector.isEmpty();
                boolean bl2 = paramDesc.isColumn();
                try {
                    if (!bl2 || bl2 && !bl) {
                        if (paramDesc.getBeColumn() == 4 && !bl) {
                            try {
                                Vector vector2 = null;
                                Vector vector3 = (Vector)vector.elementAt(0);
                                if (vector.size() > 1) {
                                    vector2 = (Vector)vector.elementAt(1);
                                }
                                paramDesc.setValues(vector3, null);
                                paramDesc.setShowValues(vector2 != null && vector3.size() == vector2.size() ? vector2 : vector3);
                            }
                            catch (ClassCastException classCastException) {
                                Tools.logTrace(5, classCastException);
                            }
                        } else {
                            paramDesc.setValues(vector, null);
                            if (paramDesc.getBeColumn() == 1) {
                                paramDesc.setBeColumn(3);
                            }
                        }
                    }
                }
                catch (InvalidParameterException invalidParameterException) {
                    throw new JRScheduleException(220014, (Throwable)invalidParameterException);
                }
                if (bl) continue;
                ParameterIntegrator.setDefaultIndex(paramDesc, 0);
            }
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "import values, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            Tools.logTrace(6, "End of ParameterAdapter.importValues().");
        }
    }

    private boolean contains(String string, List list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private void containsKey(Vector vector, ParamDesc[] paramDescArray) throws InvalidParameterException {
        if (vector != null) {
            int n = vector.size();
            int n2 = paramDescArray.length;
            while (n2-- > 0) {
                ParamDesc paramDesc = paramDescArray[n2];
                if (paramDesc == null || paramDesc.getBeColumn() != 1) continue;
                String string = paramDesc.getDefaultValue();
                paramDesc.setValues(vector, null);
                int n3 = vector.indexOf(string);
                if (n3 == -1) {
                    n3 = 0;
                }
                paramDesc.setDefaultIndex(n3);
                paramDesc.setBeColumn(2);
            }
        }
    }

    private Vector createValueListFetcher(String string, List list) {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "ParameterAdapter.getMainGroupFields()..., dataSourceName: " + string + " queryNames: " + list);
        }
        if (list == null || list.isEmpty()) {
            Tools.logTrace(6, "End of ParameterAdapter.getMainGroupFields(), return null.");
            return null;
        }
        Vector vector = null;
        for (String string2 : list) {
            if (string2 == null) continue;
            List list2 = this.currentTimeMillis(string, string2);
            if (list2 == null || list2.isEmpty()) {
                return new Vector();
            }
            if (vector == null) {
                vector = new Vector(list2);
                continue;
            }
            if (!vector.retainAll(list2) || !vector.isEmpty()) continue;
            break;
        }
        if (JRLog.isTrace(6)) {
            Tools.logTrace(6, "get group fields, cost time: " + (System.currentTimeMillis() - l) + "[ms]");
            Tools.logTrace(6, "End of ParameterAdapter.getMainGroupFields(), return: " + vector);
        }
        return vector;
    }

    private List currentTimeMillis(String string, String string2) {
        return this.addElement == null ? null : this.addElement.getAvailableGroupFields(string, string2);
    }

    private Hashtable elementAt(String string, List list, HashMap hashMap) throws JRScheduleException {
        String[] stringArray = list == null || list.isEmpty() ? null : list.toArray(new String[0]);
        KeyImportParamValues keyImportParamValues = new KeyImportParamValues(string, stringArray);
        if (hashMap.containsKey(keyImportParamValues)) {
            return (Hashtable)hashMap.get(keyImportParamValues);
        }
        Hashtable hashtable = this.elements(string, stringArray);
        hashMap.put(keyImportParamValues, hashtable);
        return hashtable;
    }

    private Hashtable elements(String string, String[] stringArray) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParameterAdapter.executeImportParamValues()..., className: " + string + " paramNames: " + Tools.toString(stringArray));
        }
        Hashtable hashtable = null;
        if (stringArray != null && stringArray.length > 0) {
            ImportParamValues importParamValues = null;
            try {
                importParamValues = (ImportParamValues)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRScheduleException(220014, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new JRScheduleException(220014, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JRScheduleException(220014, (Throwable)illegalAccessException);
            }
            hashtable = importParamValues.promptValues(stringArray);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ParameterAdapter.executeImportParamValues()..., return: " + hashtable);
        }
        return hashtable;
    }

    private class KeyImportParamValues {
        private String SEDU;
        private ArrayList append = null;

        private KeyImportParamValues(String string, String[] stringArray) {
            this.SEDU = string;
            if (stringArray != null && stringArray.length > 0) {
                this.append = new ArrayList<String>(Arrays.asList(stringArray));
                Collections.sort(this.append);
            }
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object == this) {
                return true;
            }
            if (!(object instanceof KeyImportParamValues)) {
                return false;
            }
            KeyImportParamValues keyImportParamValues = (KeyImportParamValues)object;
            boolean bl2 = this.SEDU == null ? keyImportParamValues.SEDU == null : (bl = this.SEDU.equals(keyImportParamValues.SEDU));
            return bl && (this.append == null ? keyImportParamValues.append == null : this.append.equals(keyImportParamValues.append));
        }

        public int hashCode() {
            int n = this.SEDU == null ? 0 : this.SEDU.hashCode();
            return 31 * n + (this.append == null ? 0 : this.append.hashCode());
        }

        public String toString() {
            return "className: " + this.SEDU + " alParamName: " + this.append;
        }
    }
}

