/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.pub;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import jet.controls.QueryInfoImpl;
import jet.cs.jacl.SecurityData;
import jet.dataservice.api.JDataService;
import jet.formula.JavaFormula;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.IReportFormulaProvider;
import jet.rptservice.api.IReportFormulaProviderFactory;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.pub.ParamDescContext;
import jet.rptservice.util.Tools;
import jet.server.api.SecurityContext;
import jet.universe.JetUUniverse;

public class ParameterRuntimeEnv {
    private JetUUniverse SEDU;
    private CatalogKey add;
    private String append;
    private SecurityContext clear;
    private SecurityData containsKey;
    private int createMemoryCacheProvider;
    private Locale get;
    private JDataService getBVName;
    private IRuntimeQueryInfoProvider getBeColumn;
    private JetRptReportSet getCatalogKey;
    private ResourceStore getDataService;
    private Hashtable getDataSource;
    private HashMap getDefault = new HashMap();

    public ParameterRuntimeEnv(JRptSetEngine jRptSetEngine) {
        this(jRptSetEngine.getMainRptSetEngine().getReportSet(), jRptSetEngine.getUniverse(), jRptSetEngine.getCatalogKey(), jRptSetEngine.getUserName(), jRptSetEngine.getSecurityContext(), jRptSetEngine.getSecurityData(), jRptSetEngine.getLimitedRecNum(), jRptSetEngine.getLocale(), jRptSetEngine.getDataService(), jRptSetEngine.getMainRptSetEngine().getIRuntimeQueryInfoProvider(), jRptSetEngine.getEngineEnv().getResourceStore(), jRptSetEngine.getParamContxtBuff());
    }

    private ParameterRuntimeEnv(JetRptReportSet jetRptReportSet, JetUUniverse jetUUniverse, CatalogKey catalogKey, String string, SecurityContext securityContext, SecurityData securityData, int n, Locale locale, JDataService jDataService, IRuntimeQueryInfoProvider iRuntimeQueryInfoProvider, ResourceStore resourceStore, Hashtable hashtable) {
        this.SEDU = jetUUniverse;
        this.add = catalogKey;
        this.append = string;
        this.clear = securityContext;
        this.containsKey = securityData;
        this.createMemoryCacheProvider = n;
        this.get = locale;
        this.getBVName = jDataService;
        this.getBeColumn = iRuntimeQueryInfoProvider;
        this.getCatalogKey = jetRptReportSet;
        this.getDataSource = hashtable;
    }

    public JetUUniverse getUniverse() {
        return this.SEDU;
    }

    public String getUserName() {
        return this.append;
    }

    public SecurityContext getSecurityContext() {
        return this.clear;
    }

    public SecurityData getSecurityData() {
        return this.containsKey;
    }

    public int getLimitedRecNum() {
        return this.createMemoryCacheProvider;
    }

    public Locale getLocale() {
        return this.get == null ? Locale.getDefault() : this.get;
    }

    public JDataService getDataService() {
        return this.getBVName;
    }

    public CatalogKey getCatalogKey() {
        return this.add;
    }

    public IRuntimeQueryInfoProvider getRuntimeQueryInfoProvider() {
        return this.getBeColumn;
    }

    public synchronized Hashtable getFlyFormulas(String string) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParameterRuntimeEnv.getFlyFormulas()..., paramName: " + string);
        }
        Hashtable hashtable = null;
        if (this.getDataSource != null && this.getDataSource.containsKey(string)) {
            Tools.logTrace(6, "has parameter context.");
            ParamDescContext paramDescContext = (ParamDescContext)this.getDataSource.get(string);
            IReportFormulaProvider iReportFormulaProvider = this.SEDU(paramDescContext);
            if (iReportFormulaProvider != null) {
                hashtable = iReportFormulaProvider.getFlyFormulas();
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "end of ParameterRuntimeEnv.getFlyFormulas(), return: " + hashtable);
        }
        return hashtable;
    }

    public synchronized JavaFormula getFlyJavaFormula(String string) throws JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParameterRuntimeEnv.getFlyJavaFormula()..., paramName: " + string);
        }
        JavaFormula javaFormula = null;
        if (this.getDataSource != null && this.getDataSource.containsKey(string)) {
            Tools.logTrace(6, "has parameter context.");
            ParamDescContext paramDescContext = (ParamDescContext)this.getDataSource.get(string);
            IReportFormulaProvider iReportFormulaProvider = this.SEDU(paramDescContext);
            if (iReportFormulaProvider != null) {
                javaFormula = iReportFormulaProvider.getFlyJavaFormula();
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ParameterRuntimeEnv.getFlyJavaFormula(), return: " + javaFormula);
        }
        return javaFormula;
    }

    private synchronized IReportFormulaProvider SEDU(ParamDescContext paramDescContext) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ParameterRuntimeEnv.getRptFmlProvider()..., pdc: " + paramDescContext);
        }
        IReportFormulaProvider iReportFormulaProvider = null;
        int n = paramDescContext.getSourceType();
        if (n == 2) {
            Tools.logTrace(6, "parameter come from report.");
            ParamDesc paramDesc = paramDescContext.getParamDesc();
            if (paramDesc.getBeColumn() == 4) {
                Tools.logTrace(6, "bind column.");
                String string = paramDescContext.getReportName();
                QueryInfoImpl queryInfoImpl = new QueryInfoImpl("", paramDesc.getDataSource(), null, paramDesc.getBVName(), 2);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(queryInfoImpl);
                iReportFormulaProvider = (IReportFormulaProvider)this.getDefault.get(arrayList);
                if (iReportFormulaProvider == null) {
                    Tools.logTrace(6, "no cached provider.");
                    JetRptReport jetRptReport = this.getCatalogKey.getReport(string);
                    iReportFormulaProvider = IReportFormulaProviderFactory.createMemoryCacheProvider(jetRptReport, (QueryInfo)queryInfoImpl, this.getDataService);
                    this.getDefault.put(arrayList, iReportFormulaProvider);
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ParameterRuntimeEnv.getRptFmlProvider(), return: " + iReportFormulaProvider);
        }
        return iReportFormulaProvider;
    }

    public ParameterRuntimeEnv cloneIt() {
        ParameterRuntimeEnv parameterRuntimeEnv = new ParameterRuntimeEnv(this.getCatalogKey, this.SEDU, this.add, this.append, this.clear, this.containsKey, this.createMemoryCacheProvider, this.get, this.getBVName, this.getBeColumn, this.getDataService, this.getDataSource);
        parameterRuntimeEnv.getDefault = new HashMap(this.getDefault);
        return parameterRuntimeEnv;
    }

    public void clearMem() {
        this.getCatalogKey = null;
        this.SEDU = null;
        this.append = null;
        this.clear = null;
        this.containsKey = null;
        this.get = null;
        this.getBVName = null;
        this.add = null;
        this.getBeColumn = null;
        this.getDataService = null;
        this.getDataSource = null;
        this.getDefault.clear();
    }
}

