/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.security;

import com.jinfonet.security.api.exception.InvalidResource;
import com.jinfonet.util.JRLog;
import java.util.HashSet;
import jet.rptservice.util.Tools;

public abstract class AccessController {
    public static final int PERMISSION_VISIBLE = 1;
    public static final int PERMISSION_ACCESS = 2;
    private HashSet SEDU;

    protected AccessController(HashSet hashSet) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "AccessController()..., this: " + this + " deniedAccessBlNames: " + hashSet);
        }
        this.SEDU = hashSet;
    }

    protected abstract boolean hasVisiblePermission(String var1) throws InvalidResource;

    protected boolean hasAccessPermission(String string) {
        boolean bl;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "AccessController.hasAccessPermission()..., resourceName: " + string);
        }
        boolean bl2 = bl = this.SEDU == null || !this.SEDU.contains(string);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of AccessController.hasAccessPermission()..., return: " + bl);
        }
        return bl;
    }

    public boolean hasPermission(String string, int n) throws InvalidResource {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "AccessController.hasPermission()..., this: " + this + " resourceName: " + string + " permission: " + n);
        }
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = this.hasVisiblePermission(string);
                break;
            }
            case 2: {
                bl = this.hasAccessPermission(string);
                break;
            }
            default: {
                Tools.logTrace(6, "End of NormalAccessController.hasPermission(), not available permission.");
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of AccessController.hasPermission(), return " + bl);
        }
        return bl;
    }
}

