/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.security;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import jet.acl.SecurityContextAdapter;
import jet.cs.jacl.SecurityData;
import jet.dataservice.api.JDenyListProvider;
import jet.icontrols.QueryInfo;
import jet.rptservice.api.IRuntimeQueryInfoProvider;
import jet.rptservice.api.ISecurityProvider;
import jet.rptservice.api.RuntimeEnv;
import jet.rptservice.security.AccessController;
import jet.rptservice.security.NormalAccessController;
import jet.rptservice.security.RSDAccessController;
import jet.server.api.SecurityContext;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MemberSecurityEntry;
import jet.util.nls.NLSApplyParam;

public final class AccessControllerFactory {
    public static final AccessController createAccessController(JUnifiedBusinessView jUnifiedBusinessView, QueryInfo queryInfo, RuntimeEnv runtimeEnv, CatalogKey catalogKey, JDenyListProvider jDenyListProvider) {
        _RuntimeEnv _RuntimeEnv2 = new _RuntimeEnv(runtimeEnv);
        MemberSecurityEntry memberSecurityEntry = null;
        ISecurityProvider iSecurityProvider = runtimeEnv.getSecurityProvider();
        if (iSecurityProvider != null) {
            memberSecurityEntry = iSecurityProvider.getMemberSecurity(queryInfo);
        }
        HashSet hashSet = jDenyListProvider == null ? null : jDenyListProvider.getDenyList(catalogKey, queryInfo.getDatasourceName(), queryInfo.getBLName(), memberSecurityEntry);
        return new NormalAccessController(jUnifiedBusinessView, queryInfo, _RuntimeEnv2, hashSet);
    }

    public static final AccessController createAccessController(String[] stringArray, String[] stringArray2) {
        HashSet<String> hashSet = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            hashSet = new HashSet<String>(Arrays.asList(stringArray2));
        }
        return new RSDAccessController(stringArray, hashSet);
    }

    private static class _RuntimeEnv
    implements RuntimeEnv {
        RuntimeEnv oriEnv;
        private String SEDU;
        private SecurityData getLimitedRecordNumber;

        private _RuntimeEnv(RuntimeEnv runtimeEnv) {
            this.oriEnv = runtimeEnv;
            SecurityContext securityContext = runtimeEnv.getSecurityContext();
            if (securityContext == null) {
                this.getLimitedRecordNumber = runtimeEnv.getSecurityData();
                this.SEDU = runtimeEnv.getUserName();
            } else {
                this.getLimitedRecordNumber = new SecurityContextAdapter(securityContext);
                this.SEDU = securityContext.getUserName();
            }
        }

        @Override
        public Locale getLocale() {
            return this.oriEnv.getLocale();
        }

        @Override
        public String getUserName() {
            return this.SEDU;
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.oriEnv.getSecurityContext();
        }

        @Override
        public SecurityData getSecurityData() {
            return this.getLimitedRecordNumber;
        }

        @Override
        public NLSApplyParam getNLSParam() {
            return this.oriEnv.getNLSParam();
        }

        @Override
        public int getLimitedRecordNumber() {
            return this.oriEnv.getLimitedRecordNumber();
        }

        @Override
        public String getWhereName(String string, String string2) {
            return this.oriEnv.getWhereName(string, string2);
        }

        @Override
        public String getWherePortion(String string, String string2) {
            return this.oriEnv.getWherePortion(string, string2);
        }

        @Override
        public IRuntimeQueryInfoProvider getRuntimeQueryInfoProvider() {
            return this.oriEnv.getRuntimeQueryInfoProvider();
        }

        @Override
        public ISecurityProvider getSecurityProvider() {
            return this.oriEnv.getSecurityProvider();
        }
    }
}

