/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import com.jinfonet.util.JRLog;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.rptservice.util.Tools;
import jet.util.IntStack;
import jet.util.IntVector;

public class DirectedGraph {
    private Object[] SEDU;
    private int[][] add;

    protected DirectedGraph(Object[] objectArray) {
        this.SEDU = objectArray;
        if (objectArray != null) {
            int n = objectArray.length;
            this.add = new int[n][n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.add[i][j] = 0;
                }
            }
        }
    }

    protected boolean addVertex(Object object) {
        if (this.SEDU == null) {
            this.SEDU = (Object[])Array.newInstance(object.getClass(), 1);
            this.SEDU[0] = object;
            this.add = new int[1][1];
            this.add[0][0] = 0;
        } else {
            int n;
            if (this.indexOf(object, this.SEDU) >= 0) {
                return false;
            }
            Object[] objectArray = this.SEDU;
            int[][] nArray = this.add;
            int n2 = this.SEDU.length;
            this.SEDU = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2 + 1);
            this.add = (int[][])Array.newInstance(nArray.getClass().getComponentType(), n2 + 1);
            for (n = 0; n < n2; ++n) {
                this.SEDU[n] = objectArray[n];
                this.add[n] = Arrays.copyOf(nArray[n], n2 + 1);
                this.add[n][n2] = 0;
            }
            this.SEDU[n2] = object;
            this.add[n2] = new int[n2 + 1];
            for (n = 0; n < n2 + 1; ++n) {
                this.add[n2][n] = 0;
            }
        }
        return true;
    }

    public boolean addEdge(int n, int n2) {
        if (this.SEDU == null) {
            return false;
        }
        if (n < 0 || n >= this.SEDU.length || n2 < 0 || n2 >= this.SEDU.length) {
            return false;
        }
        boolean bl = false;
        if (this.add[n][n2] == 0) {
            this.add[n][n2] = 1;
            bl = true;
        }
        return bl;
    }

    protected boolean removeEdge(int n, int n2) {
        if (!this.hasEdge(n, n2)) {
            return false;
        }
        this.add[n][n2] = 0;
        return true;
    }

    protected boolean hasEdge(int n, int n2) {
        if (this.SEDU == null) {
            return false;
        }
        if (n < 0 || n >= this.SEDU.length || n2 < 0 || n2 >= this.SEDU.length) {
            return false;
        }
        return this.add[n][n2] > 0;
    }

    public Object[] getVertexes() {
        if (this.SEDU == null) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.SEDU.getClass().getComponentType(), this.SEDU.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.SEDU[i];
        }
        return objectArray;
    }

    private int[][] SEDU(int[][] nArray) {
        if (nArray == null || nArray.length == 0) {
            return nArray;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null || nArray[i].length == 0) {
                nArrayArray[i] = nArray[i];
                continue;
            }
            nArrayArray[i] = new int[nArray[i].length];
            for (int j = 0; j < nArray[i].length; ++j) {
                nArrayArray[i][j] = nArray[i][j];
            }
        }
        return nArrayArray;
    }

    private int[] add() {
        if (this.SEDU == null) {
            return null;
        }
        int[] nArray = new int[this.SEDU.length];
        for (int i = 0; i < this.add.length; ++i) {
            nArray[i] = 0;
            for (int j = 0; j < this.add[i].length; ++j) {
                if (this.add[j][i] <= 0) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
        }
        return nArray;
    }

    protected int getIndegree(int n) {
        if (n < 0 || n >= this.add.length) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < this.add.length; ++i) {
            if (this.add[i][n] <= 0) continue;
            ++n2;
        }
        return n2;
    }

    public int getOutDegree(Object object) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.add.length; ++n) {
            if (!Tools.equals(object, this.SEDU[n])) continue;
            n2 = n;
            break;
        }
        n = -1;
        if (n2 != -1) {
            for (int i = 0; i < this.add.length; ++i) {
                if (this.add[n2][i] <= 0) continue;
                ++n;
            }
        }
        return n;
    }

    private void addEdge(int[][] nArray, int[] nArray2, int n, IntStack intStack) {
        for (int i = 0; i < this.SEDU.length; ++i) {
            if (nArray[n][i] <= 0) continue;
            nArray[n][i] = 0;
            int n2 = i;
            nArray2[n2] = nArray2[n2] - 1;
            if (nArray2[i] != 0) continue;
            intStack.push(i);
        }
    }

    public Object[] topoSort() {
        int n;
        if (this.SEDU == null) {
            return null;
        }
        int[] nArray = this.add();
        int[][] nArray2 = this.SEDU(this.add);
        IntStack intStack = new IntStack();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0) continue;
            intStack.push(i);
        }
        IntVector intVector = new IntVector();
        while (!intStack.isEmpty()) {
            int n2 = intStack.pop();
            intVector.addElement(n2);
            this.addEdge(nArray2, nArray, n2, intStack);
        }
        if (intVector.size() != this.SEDU.length && JRLog.isTrace(5)) {
            Vector<Object> vector = new Vector<Object>();
            for (n = 0; n < this.SEDU.length; ++n) {
                if (intVector.contains(n)) continue;
                vector.addElement(this.SEDU[n]);
            }
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "waring: there exists circle in following vertexes!!!!");
                JRLog.trace(5, Tools.toString(vector));
            }
        }
        Object[] objectArray = new Object[intVector.size()];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = this.SEDU[intVector.elementAt(n)];
        }
        return objectArray;
    }

    public Object[] getCircle() {
        if (this.SEDU == null) {
            return null;
        }
        Object[] objectArray = null;
        Object[] objectArray2 = this.topoSort();
        if (objectArray2.length != this.SEDU.length) {
            objectArray = (Object[])Array.newInstance(this.SEDU.getClass().getComponentType(), this.SEDU.length - objectArray2.length);
            int n = 0;
            for (int i = 0; i < this.SEDU.length; ++i) {
                int n2 = this.indexOf(this.SEDU[i], objectArray2);
                if (n2 != -1) continue;
                objectArray[n++] = this.SEDU[i];
            }
        }
        return objectArray;
    }

    protected int indexOf(Object object, Object[] objectArray) {
        int n = -1;
        if (objectArray == null || objectArray.length == 0) {
            return n;
        }
        if (object == null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                n = i;
                break;
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    protected DirectedGraph getReverseReachableSet(Object object) {
        int n = this.indexOf(object, this.SEDU);
        if (n < 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        this.addElement(n, arrayList, hashMap);
        Object[] objectArray = this.addVertex(arrayList);
        DirectedGraph directedGraph = new DirectedGraph(objectArray);
        for (Integer n2 : hashMap.keySet()) {
            int n3 = n2;
            int n4 = this.indexOf(this.SEDU[n3], objectArray);
            List list = (List)hashMap.get(n2);
            if (list == null) continue;
            for (Integer n5 : list) {
                int n6 = n5;
                int n7 = this.indexOf(this.SEDU[n6], objectArray);
                directedGraph.addEdge(n4, n7);
            }
        }
        return directedGraph;
    }

    private void addElement(int n, List list, Map map) {
        Integer n2 = new Integer(n);
        if (!list.contains(n2)) {
            list.add(n2);
            for (int i = 0; i < this.add[n].length; ++i) {
                if (i == n || this.add[i][n] <= 0) continue;
                Integer n3 = new Integer(i);
                ArrayList<Integer> arrayList = (ArrayList<Integer>)map.get(n3);
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                    map.put(n3, arrayList);
                }
                if (arrayList.contains(n2)) continue;
                arrayList.add(n2);
                this.addElement(i, list, map);
            }
        }
    }

    private Object[] addVertex(List list) {
        Object[] objectArray = (Object[])Array.newInstance(this.SEDU.getClass().getComponentType(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = this.SEDU[(Integer)list.get(i)];
        }
        return objectArray;
    }

    protected void merge(DirectedGraph directedGraph) {
        Object[] objectArray;
        if (directedGraph != null && (objectArray = directedGraph.SEDU) != null) {
            int n;
            int n2;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = this.indexOf(objectArray[n2], this.SEDU);
                if (n >= 0) continue;
                this.addVertex(objectArray[n2]);
            }
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                for (n = 0; n < objectArray.length; ++n) {
                    if (n2 == n || directedGraph.add[n2][n] != 1) continue;
                    int n3 = this.indexOf(objectArray[n2], this.SEDU);
                    int n4 = this.indexOf(objectArray[n], this.SEDU);
                    this.addEdge(n3, n4);
                }
            }
        }
    }

    public void traceStructure(int n) {
        if (JRLog.isTrace(n)) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder("Graph structure:\nvertexes: ");
            for (n2 = 0; n2 < this.SEDU.length; ++n2) {
                stringBuilder.append(this.SEDU[n2] + (n2 < this.SEDU.length - 1 ? "," : "\n"));
            }
            stringBuilder.append("edges: ");
            n2 = 0;
            for (int i = 0; i < this.add.length; ++i) {
                for (int j = 0; j < this.add[i].length; ++j) {
                    if (i == j || this.add[i][j] <= 0) continue;
                    if (n2 != 0) {
                        stringBuilder.append(", ");
                        if (n2 % 5 == 0) {
                            stringBuilder.append("\n");
                        }
                    }
                    stringBuilder.append(this.SEDU[i] + "-->" + this.SEDU[j]);
                    ++n2;
                }
            }
            JRLog.trace(n, stringBuilder.toString());
        }
    }
}

