/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.List;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SpecialFields;
import jet.exception.InvalidParameterException;
import jet.formula.JavaFormula;
import jet.icontrols.QueryInfo;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnTheFlyFormulaMeasureLogic;
import jet.reportset.JetRptReport;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUUniverse;
import jet.util.ScheduleTools;

public abstract class RawDataQueryEnv {
    protected JetUUniverse unv;
    protected QueryInfo queryInfo;

    protected RawDataQueryEnv(JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        this.unv = jetUUniverse;
        this.queryInfo = queryInfo;
    }

    public JetUUniverse getUniverse() {
        return this.unv;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public String getQueryName() {
        String string = null;
        if (this.queryInfo.getDataResoureType() == 2) {
            KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(this.queryInfo, this.unv);
            if (keyDataSourceQuery != null) {
                string = keyDataSourceQuery.getQueryName();
            }
        } else {
            string = this.queryInfo.getQueryName();
        }
        return string;
    }

    protected abstract JetRptReport getReportView();

    public abstract CatalogKey getCatalogKey();

    public Hashtable getReportFormulas() {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "RawDataQueryEnv.getReportFormulas()...");
        }
        if (this.queryInfo.getDataResoureType() != 2) {
            return null;
        }
        JetRptReport jetRptReport = this.getReportView();
        Scope scope = new Scope(jetRptReport, this.unv, this.queryInfo);
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        Hashtable<String, JetUFormula> hashtable = new Hashtable<String, JetUFormula>();
        if (list != null && !list.isEmpty()) {
            for (JetRptAbstractFormula jetRptAbstractFormula : list) {
                JetUFormula jetUFormula = jetRptAbstractFormula.getJetUFormula();
                String string = ((JetRptFlyFormula)jetRptAbstractFormula).getMappingName().toUpperCase();
                hashtable.put(string, jetUFormula);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of RawDataQueryEnv.getReportFormulas().");
        }
        return hashtable;
    }

    public abstract JavaFormula getJavaFormula() throws JRScheduleException;

    public abstract ParameterValueList getParamValues() throws DSException, InvalidParameterException;

    public abstract SpecialFields getSpecialFields();

    public static RawDataQueryEnv getDefaultEnv(JetUUniverse jetUUniverse, QueryInfo queryInfo) {
        return new _RawDataQueryEnv(jetUUniverse, queryInfo);
    }

    private static class _RawDataQueryEnv
    extends RawDataQueryEnv {
        private _RawDataQueryEnv(JetUUniverse jetUUniverse, QueryInfo queryInfo) {
            super(jetUUniverse, queryInfo);
        }

        @Override
        protected JetRptReport getReportView() {
            return null;
        }

        @Override
        public CatalogKey getCatalogKey() {
            return null;
        }

        @Override
        public JavaFormula getJavaFormula() throws JRScheduleException {
            return null;
        }

        @Override
        public ParameterValueList getParamValues() throws DSException, InvalidParameterException {
            return null;
        }

        @Override
        public SpecialFields getSpecialFields() {
            return null;
        }
    }
}

