/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.MemoryStore;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.Env;
import jet.acl.JetAcl;
import jet.acl.JetAclEntry;
import jet.acl.JetGroup;
import jet.acl.JetPermission;
import jet.acl.JetPrincipal;
import jet.acl.JetRole;
import jet.acl.JetUser;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbTime;
import jet.connect.DbValue;
import jet.controls.ColumnableMapping;
import jet.controls.JetBLColumnName;
import jet.controls.JetBLColumnable;
import jet.controls.JetColumnName;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetVector;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.ExpressionToolKit;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.OperatorToolKit;
import jet.dataengine.api.expression.set.ISetExpression;
import jet.dataengine.api.expression.tuple.IBinaryConditionExpression;
import jet.dataengine.api.expression.tuple.IBinaryLogicExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.expression.tuple.IMultiLogicExpression;
import jet.dataengine.api.expression.tuple.ISingleConditionExpression;
import jet.dataengine.api.expression.tuple.ISingleLogicExpression;
import jet.dataengine.api.expression.tuple.ITripleConditionExpression;
import jet.dataengine.api.expression.tuple.ITupleExpression;
import jet.dataengine.api.expression.tuple.op.IBinaryLogicOperator;
import jet.dataengine.api.expression.tuple.op.IMultiLogicOperator;
import jet.dataengine.api.expression.tuple.op.ISingleLogicOperator;
import jet.dataengine.api.expression.variable.IConstant;
import jet.dataengine.api.expression.variable.IFormula;
import jet.dataengine.api.expression.variable.IParameter;
import jet.dataengine.api.expression.variable.IReference;
import jet.dataengine.api.expression.variable.IVariableExpression;
import jet.dataengine.api.expression.variable.IVariableList;
import jet.dataengine.api.query.IncrementalInfo;
import jet.dataengine.api.query.JComponentFilterQuery;
import jet.dataengine.api.query.JGroupQuery;
import jet.dataengine.api.query.JIterativeQuery;
import jet.dataengine.api.query.JQuery;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataengine.groupengine.GroupModel;
import jet.dataservice.api.JDataService;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.InvalidParameterException;
import jet.exception.UserException;
import jet.formula.Aggregation;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.FormulaQueue;
import jet.formula.FormulatoJava;
import jet.formula.JavaFormula;
import jet.formula.JetRptFormula;
import jet.formula.JetRptSummary;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.jetc.WriteFailureException;
import jet.naming.EnumerationConstant;
import jet.naming.PropertyNames;
import jet.report.JRObjectTemplate;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptColAttr;
import jet.report.JetRptContainer;
import jet.report.JetRptCrosstab;
import jet.report.JetRptDetailPanel;
import jet.report.JetRptGroupPanel;
import jet.report.JetRptMultiValueContainer;
import jet.report.JetRptObject;
import jet.report.JetRptPageEnd;
import jet.report.JetRptPagePanel;
import jet.report.JetRptPageStart;
import jet.report.JetRptParamLink;
import jet.report.JetRptReportBody;
import jet.report.JetRptReportPanel;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubLink;
import jet.report.JetRptSubLinkContainer;
import jet.report.JetRptSubReport;
import jet.report.JetRptSubReturnValueContainer;
import jet.report.JetRptView;
import jet.report.JetRptViews;
import jet.report.chart.JetRptChartPlatform;
import jet.report.conditionalFormatting.JetRptReportFormulaClass;
import jet.report.conditionalFormatting.JetRptReportFormulaClassSet;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.formula.JetRptAbstractFormulaClass;
import jet.report.geomap.JetRptGeoMap;
import jet.report.gmap.JetRptGMap;
import jet.report.link.Linkable;
import jet.report.onTheFlyFormula.DCScope;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormulaClass;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.table.JetRptNewTable;
import jet.report.table.JetRptTableDetail;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.reportLogic.objectInfo.BusinessEntityInfo;
import jet.reportLogic.objectInfo.CrosstabEditInfo;
import jet.reportLogic.objectInfo.FlyFormulaInfo;
import jet.reportLogic.objectInfo.FlyMeasureInfo;
import jet.reportLogic.objectInfo.SubRptParamInfo;
import jet.reportLogic.objectLogic.BasicComponentLogic;
import jet.reportLogic.objectLogic.CrosstabLogic;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.DataSetLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnTheFlyFormulaMeasureLogic;
import jet.reportLogic.objectLogic.OnTheFlyParameterLogic;
import jet.reportLogic.objectLogic.ReportLogic;
import jet.reportLogic.objectLogic.ReportSetLogic;
import jet.reportLogic.objectLogic.SubReportLogic;
import jet.reportset.DataSet;
import jet.reportset.JSecurityEntryException;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptExtendsDataSet;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptengine.JEngineInitializer;
import jet.rptengine.JSubLinkContainer;
import jet.rptengine.RptFormulaContainer;
import jet.rptengine.util.EngineTools;
import jet.rptservice.agent.RuntimeInfoAgent;
import jet.rptservice.api.DrillFilterInfo;
import jet.rptservice.api.FlyResourceScope;
import jet.rptservice.api.IDrillFilter;
import jet.rptservice.api.ISecurityProvider;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.RptSetStatus;
import jet.rptservice.design.util.GetValueTools;
import jet.rptservice.engine.JRptSetEngine;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.pub.ColumnAttributes;
import jet.rptservice.pub.LinkToReportContext;
import jet.rptservice.pub.LinkValueEntry;
import jet.rptservice.util.SubLinkProcessor;
import jet.rptservice.util.Tools;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.DataElementInfo;
import jet.universe.businesslogic.DimensionInfo;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.DetailInfo;
import jet.universe.businesslogic.impl.Dimension;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.upgrade.JUpgradeException;
import jet.upgrade.UpgradeUtil;
import jet.util.DbValueComparer;
import jet.util.HashVector;
import jet.util.JStringToolKit;
import jet.util.RuntimeInfo;
import jet.util.TreeIterater;

public final class ReportTools {
    public static final int DATA_CONTAINER_COMMON = 0;
    public static final int DATA_CONTAINER_SECTION_OBJECT = 1;
    public static final int DATA_CONTAINER_CROSSTABLE = 2;
    public static final int DATA_CONTAINER_TABLE = 3;
    public static final int DATA_CONTAINER_REPORT_BODY = 4;
    public static final int DATA_CONTAINER_PARAGRAPH = 5;
    public static final int DATA_CONTAINER_TABULAR = 6;
    public static final int DATA_CONTAINER_TABULAR_CELL = 7;
    public static final int DATA_CONTAINER_MULTIVALUE_CONTAINER = 8;
    public static final int FORMULA_TYPE_CONSTANT_LEVER = 100;
    public static final int FORMULA_TYPE_PAGE_LEVER = 101;
    public static final int FORMULA_TYPE_GLOBAL_LEVER = 102;
    public static final int FORMULA_TYPE_GROUP_LEVER = 103;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS1 = 104;
    public static final int FORMULA_TYPE_RECORD_LEVER_PASS2 = 105;
    public static final int MAPPING_TYPE_DBFIELD = 0;
    public static final int MAPPING_TYPE_PARAMETER = 1;
    public static final int MAPPING_TYPE_FORMULA = 2;
    private static Hashtable AnchorDispValue = new Hashtable();
    private static Vector Background = new Vector();
    private static Vector BorderColor;
    public static String RuntimeColName_DELIMITER;
    public static final int VALIDCOL_FIRSTANDCTLINK = 0;
    private static final int Elements = 1;
    public static final int VALIDCOL_FIRSTANDNORMAL = 2;
    public static final int VALIDCOL_FIRSTANDPARAMETER = 3;
    private static final int ExportToCSV = 17;
    public static final int VALIDCOL_SECONDANDQUALIFY = 18;
    public static final int VALIDCOL_SECONDANDPARAMETER = 19;
    public static final int VALIDCOL_ERR_ALLEMPTY = 33;
    public static final int VALIDCOL_ERR_SECONDANDCTLINK = 34;

    public static DataContainerLogic getDataContainerLogic(int n) {
        DataContainerLogic dataContainerLogic = null;
        String string = String.valueOf(n);
        if (AnchorDispValue.contains(string)) {
            return (DataContainerLogic)AnchorDispValue.get(string);
        }
        switch (n) {
            case 0: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            case 1: {
                dataContainerLogic = ObjectLogicFactory.getSectionObjectLogic();
                break;
            }
            case 2: {
                dataContainerLogic = ObjectLogicFactory.getCrosstabLogic();
                break;
            }
            case 4: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            case 3: {
                dataContainerLogic = ObjectLogicFactory.getTableLogic();
                break;
            }
            case 5: {
                dataContainerLogic = ObjectLogicFactory.getParagraphLogic();
                break;
            }
            case 6: {
                dataContainerLogic = ObjectLogicFactory.getTabularLogic();
                break;
            }
            case 7: {
                dataContainerLogic = ObjectLogicFactory.getMultiValueContainerLogic();
                break;
            }
            case 8: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
                break;
            }
            default: {
                dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
            }
        }
        AnchorDispValue.put(string, dataContainerLogic);
        return dataContainerLogic;
    }

    private static int AnchorDispValue(IDataContainer iDataContainer) {
        int n;
        if (iDataContainer instanceof JetRptSectionObject) {
            n = 1;
        } else if (iDataContainer instanceof JetRptCrosstab) {
            n = 2;
        } else if (iDataContainer instanceof JetRptReportBody) {
            n = 4;
        } else if (iDataContainer instanceof JetRptNewTable) {
            n = 3;
        } else if (iDataContainer instanceof JetRptParagraph) {
            n = 5;
        } else if (iDataContainer instanceof JetRptTabular) {
            n = 6;
        } else if (iDataContainer instanceof JetRptTabularCell) {
            n = 7;
        } else if (iDataContainer instanceof JetRptMultiValueContainer) {
            n = 8;
        } else {
            return -1;
        }
        return n;
    }

    public static DataContainerLogic getDataContainerLogic(IDataContainer iDataContainer) {
        int n = ReportTools.AnchorDispValue(iDataContainer);
        return ReportTools.getDataContainerLogic(n);
    }

    public static DataSet getDataSet(JetObject jetObject) {
        if (jetObject == null) {
            return null;
        }
        IDataContainer iDataContainer = null;
        iDataContainer = jetObject instanceof IDataContainer ? (IDataContainer)((Object)jetObject) : ReportTools.getDataContainerLogic(0).getDataContainer(jetObject, true);
        if (iDataContainer == null) {
            return null;
        }
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(iDataContainer);
        return dataContainerLogic.getUsedDataSet(iDataContainer);
    }

    public static IDataContainer getDataContainer(JetObject jetObject, boolean bl) {
        if (bl && jetObject instanceof IDataContainer) {
            return (IDataContainer)((Object)jetObject);
        }
        return ReportTools.getDataContainerLogic(0).getDataContainer(jetObject, true);
    }

    public static String getDataSourceName(IDataContainer iDataContainer) {
        DataContainerLogic dataContainerLogic = ReportTools.getDataContainerLogic(iDataContainer);
        return dataContainerLogic.getUsedDatasourceName(iDataContainer);
    }

    public static JetUUniverse loadUniverse(String string, MemoryStore memoryStore) throws ResourceNotFoundException, ResourceLoadException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.loadUniverse()... catName=" + string);
        }
        JetUUniverse jetUUniverse = memoryStore.loadCatalog(new File(string));
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ReportTools.loadUniverse()... catName = " + string + " universe = " + jetUUniverse);
        }
        return jetUUniverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JetRptReportSet loadReportSet(String string, String string2, boolean bl, JetUUniverse jetUUniverse, MemoryStore memoryStore) throws ResourceNotFoundException, ResourceLoadException, ReadFailureException {
        JetRptReportSet jetRptReportSet;
        long l;
        block20: {
            l = System.currentTimeMillis();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.loadReportSet()... rptSetName: " + string + " styleGroupName: " + string2 + " bCache: " + bl + " universe: " + jetUUniverse + " store: " + memoryStore);
            }
            jetRptReportSet = null;
            boolean bl2 = bl && jetUUniverse != null;
            File file = new File(string);
            try {
                JetObject jetObject = bl2 ? memoryStore.loadReport(file, string2, null) : memoryStore.loadReportNoCache(file, string2, null);
                int n = Env.getFileType(string);
                if (jetObject instanceof JetRptReportSet) {
                    Tools.logTrace(6, "convert reportset to current reportset.");
                    try {
                        jetRptReportSet = ReportTools.Background(jetUUniverse, (JetRptReportSet)jetObject, n);
                        break block20;
                    }
                    finally {
                        if (jetObject != jetRptReportSet) {
                            ((JetRptReportSet)jetObject).free();
                            if (jetRptReportSet != null) {
                                jetRptReportSet.refer();
                            }
                        }
                    }
                }
                if (jetObject instanceof JetRptReportPanel) {
                    Tools.logTrace(6, "convert report panel to report set.");
                    try {
                        jetRptReportSet = ReportTools.Background(jetUUniverse, (JetRptObject)jetObject, n);
                    }
                    finally {
                        if (jetObject != jetRptReportSet) {
                            ((JetRptReportPanel)jetObject).free();
                            if (jetRptReportSet != null) {
                                jetRptReportSet.refer();
                            }
                        }
                    }
                    jetRptReportSet.setFullFileName(file.getAbsolutePath());
                    jetRptReportSet.setDefaultReportLevelResourcesPath(file.getParentFile().getAbsolutePath());
                    break block20;
                }
                throw new ReadFailureException();
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, resourceNotFoundException);
                }
                throw resourceNotFoundException;
            }
            catch (ResourceLoadException resourceLoadException) {
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, resourceLoadException);
                }
                throw resourceLoadException;
            }
        }
        if (jetRptReportSet.isBoundled()) {
            jetRptReportSet.getBindUniverse().setFullFileName(new File(string));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.loadReportSet()#######! cost time =" + (System.currentTimeMillis() - l));
            JRLog.trace(6, "End of ReportTools.loadReportSet()! rptSet=" + jetRptReportSet);
        }
        return jetRptReportSet;
    }

    private static JetRptReportSet Background(JetUUniverse jetUUniverse, JetRptObject jetRptObject, int n) throws ReadFailureException {
        JetRptReportSet jetRptReportSet = null;
        try {
            jetRptReportSet = (JetRptReportSet)UpgradeUtil.upgradeRpt(jetRptObject, jetUUniverse, n);
        }
        catch (JUpgradeException jUpgradeException) {
            throw new ReadFailureException(jUpgradeException);
        }
        return jetRptReportSet;
    }

    public static String[] getCurrentReportName(JetRptReportSet jetRptReportSet) {
        String[] stringArray = new String[2];
        String string = jetRptReportSet.getCurReportId();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        String string2 = jetRptReport.getCurViewName();
        stringArray[0] = string;
        stringArray[1] = string2;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openAllReportView(JetRptReportSet jetRptReportSet) {
        JetRptReportSet jetRptReportSet2 = jetRptReportSet;
        synchronized (jetRptReportSet2) {
            String[] stringArray = jetRptReportSet.getAllReportsName();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
                jetRptReport.setStatus(0);
                JetRptViews jetRptViews = jetRptReport.getViews();
                String[] stringArray2 = jetRptViews.getAllViewNames();
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    JetRptView jetRptView = jetRptViews.getRptView(stringArray2[j]);
                    jetRptView.setStatus(0);
                }
            }
        }
    }

    public static Vector[] getOpenReportViews(JetRptReportSet jetRptReportSet, String[] stringArray) {
        if (jetRptReportSet == null) {
            Tools.logTrace(6, "ReportTools.getOperReportViews()..., Error: rptSet can't be null.");
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            vectorArray[i] = new Vector();
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            String[] stringArray2 = jetRptReport.getOpenedViewNames();
            if (stringArray2 == null || stringArray2.length == 0) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                vectorArray[i].addElement(stringArray2[j]);
            }
        }
        return vectorArray;
    }

    public static void openReports(JetRptReportSet jetRptReportSet, String[] stringArray) {
        if (jetRptReportSet == null || stringArray == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptSet = " + jetRptReportSet + " rptNames = " + stringArray);
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            jetRptReport.setStatus(0);
            String[] stringArray2 = jetRptReport.getAllViewName();
            for (int j = 0; j < stringArray2.length; ++j) {
                JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[i]);
                jetRptView.setStatus(0);
            }
        }
    }

    public static void openReportViews(JetRptReportSet jetRptReportSet, String[] stringArray, Vector[] vectorArray) {
        if (jetRptReportSet == null || stringArray == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptSet = " + jetRptReportSet + " rptNames = " + stringArray + " vRptViews = " + vectorArray);
            }
            return;
        }
        if (stringArray.length != vectorArray.length) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "ReportTools.openReports(), rptNames.length = " + stringArray.length + " vRptViews.length = " + vectorArray.length);
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            jetRptReport.setStatus(0);
            String[] stringArray2 = vectorArray[i].toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                JetRptView jetRptView = jetRptReport.getViewObject(stringArray2[i]);
                jetRptView.setStatus(0);
            }
        }
    }

    public static void setCurrentReportView(JetRptReportSet jetRptReportSet, String string, String string2) {
        jetRptReportSet.setCurReportId(string);
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        if (jetRptReport.getStatus() != 0) {
            jetRptReport.setStatus(0);
        }
        jetRptReport.setCurViewName(string2);
        JetRptView jetRptView = jetRptReport.getViewObject(string2);
        if (jetRptView.getStatus() != 0) {
            jetRptView.setStatus(0);
        }
    }

    public static IBooleanExpression getExpression(JSubLinkContainer jSubLinkContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        Tools.logTrace(6, "ReportTools.getExpression(JSubLinkContainer,JetUUniverse)...");
        List list = jSubLinkContainer.getSubLinks();
        if (list == null || list.size() == 0) {
            Tools.logTrace(6, "return: null.");
            Tools.logTrace(6, "End of ReportTools.getExpression(JSubLinkContainer,JetUUniverse).");
            return null;
        }
        DataSet dataSet = jSubLinkContainer.getDataSet();
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getQueryName();
        Object object = null;
        for (int i = 0; i < list.size(); ++i) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(i);
            object = ReportTools.getAndExpression((IBooleanExpression)object, ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2));
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "return: " + object.toString());
            JRLog.trace(6, "End of ReportTools.getExpression(JSubLinkContainer,JetUUniverse).");
        }
        return object;
    }

    public static IExpression getExpression(IExpression iExpression, JSubLinkContainer jSubLinkContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        return ReportTools.getAndExpression(iExpression, ReportTools.getExpression(jSubLinkContainer, jetUUniverse));
    }

    public static IExpression getExpression(IBooleanExpression iBooleanExpression, List list, JetUUniverse jetUUniverse, String string, String string2) throws JRScheduleException, ConditionException {
        return ReportTools.getExpression(iBooleanExpression, list, jetUUniverse, string, string2, null, false);
    }

    public static IExpression getExpression(IBooleanExpression iBooleanExpression, List list, JetUUniverse jetUUniverse, String string, String string2, String string3, boolean bl) throws JRScheduleException, ConditionException {
        if (list == null || list.size() == 0) {
            return iBooleanExpression;
        }
        IBooleanExpression iBooleanExpression2 = iBooleanExpression;
        for (int i = 0; i < list.size(); ++i) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(i);
            IBooleanExpression iBooleanExpression3 = ReportTools.ExportToCSV(dbValueComparer, jetUUniverse, string, string2, string3, bl);
            iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression3 : ReportTools.getAndExpression(iBooleanExpression2, iBooleanExpression3);
        }
        return iBooleanExpression2;
    }

    public static IExpression getOrExpression(IBooleanExpression iBooleanExpression, List list, JetUUniverse jetUUniverse, String string, String string2) throws JRScheduleException, ConditionException {
        if (list == null || list.size() == 0) {
            return iBooleanExpression;
        }
        IBooleanExpression iBooleanExpression2 = iBooleanExpression;
        for (int i = 0; i < list.size(); ++i) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(i);
            IBooleanExpression iBooleanExpression3 = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
            iBooleanExpression2 = iBooleanExpression2 == null ? iBooleanExpression3 : ReportTools.getOrExpression(iBooleanExpression2, iBooleanExpression3);
        }
        return iBooleanExpression2;
    }

    public static String getWhereString(JSubLinkContainer jSubLinkContainer) {
        List list = jSubLinkContainer.getSubLinks();
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i = 0; i < list.size(); ++i) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(i);
            stringBuffer.append(dbValueComparer.getColumnName() + " ");
            stringBuffer.append(dbValueComparer.getOperString() + " ");
            stringBuffer.append(dbValueComparer.getValueString() + " ");
            if (i == n - 1) continue;
            stringBuffer.append("and ");
        }
        return stringBuffer.toString();
    }

    public static IBooleanExpression getAndExpression(IBooleanExpression iBooleanExpression, IBooleanExpression iBooleanExpression2) throws ConditionException {
        if (iBooleanExpression == null) {
            return iBooleanExpression2;
        }
        if (iBooleanExpression2 == null) {
            return iBooleanExpression;
        }
        return ExpressionToolKit.buildAndExpression(iBooleanExpression, iBooleanExpression2);
    }

    public static IBooleanExpression getOrExpression(IBooleanExpression iBooleanExpression, IBooleanExpression iBooleanExpression2) throws ConditionException {
        if (iBooleanExpression == null) {
            return iBooleanExpression2;
        }
        if (iBooleanExpression2 == null) {
            return iBooleanExpression;
        }
        return (IBooleanExpression)ExpressionToolKit.buildOrExpression(iBooleanExpression, iBooleanExpression2);
    }

    public static IExpression getAndExpression(IExpression iExpression, IBooleanExpression iBooleanExpression) throws ConditionException {
        if (iExpression == null) {
            return iBooleanExpression;
        }
        if (iBooleanExpression == null) {
            return iExpression;
        }
        ISetExpression iSetExpression = null;
        IBooleanExpression iBooleanExpression2 = null;
        IMultiLogicExpression iMultiLogicExpression = null;
        if (ExpressionToolKit.isBooleanExp(iExpression.expressionType())) {
            return ExpressionToolKit.buildAndExpression((IBooleanExpression)iExpression, iBooleanExpression);
        }
        if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            iSetExpression = ReportTools.BorderColor(iExpression);
        }
        if ((iBooleanExpression2 = ReportTools.Elements(iExpression)) == null) {
            iSetExpression.setExpression(iBooleanExpression);
        } else {
            iMultiLogicExpression = ExpressionToolKit.buildAndExpression(iBooleanExpression2, iBooleanExpression);
            iSetExpression.setExpression(iMultiLogicExpression);
        }
        return iExpression;
    }

    private static ISetExpression BorderColor(IExpression iExpression) {
        if (!ExpressionToolKit.isSetExp(iExpression.expressionType())) {
            return null;
        }
        IExpression iExpression2 = ((ISetExpression)iExpression).getExpression();
        IExpression iExpression3 = iExpression;
        while (iExpression2 != null && !ExpressionToolKit.isTupleExp(iExpression2.expressionType())) {
            iExpression3 = iExpression2;
            iExpression2 = ((ISetExpression)iExpression2).getExpression();
        }
        return (ISetExpression)iExpression3;
    }

    private static IBooleanExpression Elements(IExpression iExpression) {
        if (iExpression == null) {
            return null;
        }
        while (iExpression != null && !ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            if (ExpressionToolKit.isSetExp(iExpression.expressionType())) {
                iExpression = ((ISetExpression)iExpression).getExpression();
                continue;
            }
            throw new RuntimeException();
        }
        return (IBooleanExpression)iExpression;
    }

    public static IBooleanExpression getExpression(DbValueComparer dbValueComparer, JetUUniverse jetUUniverse, String string, String string2) throws ConditionException, JRScheduleException {
        return ReportTools.ExportToCSV(dbValueComparer, jetUUniverse, string, string2, null, false);
    }

    private static IBooleanExpression ExportToCSV(DbValueComparer dbValueComparer, JetUUniverse jetUUniverse, String string, String string2, String string3, boolean bl) throws ConditionException, JRScheduleException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.getExpression(DbValueComparer,JetUUniverse,String,String,String,int)...");
            JRLog.trace(6, "colName: " + dbValueComparer.getColumnName() + " op: " + dbValueComparer.getOperString() + " value: " + Tools.toString(ReportTools.ExportToXLS(dbValueComparer.getValue()).toArray()) + " dataSourceName: " + string + " queryName: " + string2 + " blName: " + string3 + " isQualifyName: " + bl);
        }
        String string4 = dbValueComparer.getColumnName();
        DbValue dbValue = dbValueComparer.getValue();
        int n = ReportTools.getBinaryConditionOpForDbValueComparer(dbValueComparer.operator);
        int n2 = bl ? 2 : 0;
        Scope scope = new Scope(null, jetUUniverse, new QueryInfoImpl(null, string, string2, string3, n2));
        IBooleanExpression iBooleanExpression = ExpressionToolKit.buildExpression(string4, bl, n, dbValue, scope);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ReportTools.getExpression(), return: " + (iBooleanExpression == null ? "null" : iBooleanExpression.toExpString()));
        }
        return iBooleanExpression;
    }

    public static int getBinaryConditionOpForDbValueComparer(int n) throws JRScheduleException {
        switch (n) {
            case 0: {
                return 556793872;
            }
            case 1: {
                return 556793888;
            }
            case 2: {
                return 556794112;
            }
            case 4: {
                return 556794368;
            }
            case 3: {
                return 556793920;
            }
            case 5: {
                return 556793984;
            }
            case 6: {
                return 556793857;
            }
            case 7: {
                return 556793858;
            }
        }
        throw new JRScheduleException(220004, (Object[])new String[]{String.valueOf(n)}, null);
    }

    public static void saveToXml(DiskStore diskStore, JetRptObject jetRptObject, String string) throws WriteFailureException {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "saveToXml.saveToXml()..., o: " + jetRptObject + " file: " + string);
        }
        try {
            ReportLoader.save(diskStore, jetRptObject, "", string);
        }
        catch (WriteFailureException writeFailureException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, writeFailureException);
            }
            throw writeFailureException;
        }
        Tools.logTrace(6, "save sucessfully!");
    }

    public static Vector getLinkedTargetComp(JRObjectTemplate jRObjectTemplate) {
        return null;
    }

    public static JetRptReportSet shrinkReportSet(JetRptReportSet jetRptReportSet, Vector vector, boolean bl) {
        ReportSetLogic reportSetLogic = ObjectLogicFactory.getReportSetLogic();
        JetRptReportSet jetRptReportSet2 = jetRptReportSet;
        if (bl) {
            jetRptReportSet2 = (JetRptReportSet)jetRptReportSet.deepDupWithName();
        }
        return reportSetLogic.shrinkReportSet(jetRptReportSet2, vector);
    }

    private static List ExportToXLS(DbValue dbValue) {
        if (dbValue.bNull) {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        if (dbValue instanceof DbArray) {
            return ReportTools.Invisible((DbArray)dbValue);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (dbValue instanceof DbDateTime) {
            String string2 = null;
            string2 = dbValue instanceof DbDate ? "yyyy-MM-dd HH:mm:ss.SSS z" : (dbValue instanceof DbTime ? "HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS z");
            string = ((DbDateTime)dbValue).toFormatString(string2);
        } else {
            string = dbValue.toString();
        }
        arrayList.add(string);
        return arrayList;
    }

    private static List Invisible(DbArray dbArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = dbArray.getColDesc().sqlType;
        switch (n) {
            case -7: {
                boolean[] blArray = (boolean[])dbArray.getValue();
                for (int i = 0; i < blArray.length; ++i) {
                    arrayList.add(String.valueOf(blArray[i]));
                }
                break;
            }
            case -6: {
                byte[] byArray = (byte[])dbArray.getValue();
                for (int i = 0; i < byArray.length; ++i) {
                    arrayList.add(String.valueOf(byArray[i]));
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])dbArray.getValue();
                for (int i = 0; i < sArray.length; ++i) {
                    arrayList.add(String.valueOf(sArray[i]));
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])dbArray.getValue();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(String.valueOf(nArray[i]));
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])dbArray.getValue();
                for (int i = 0; i < lArray.length; ++i) {
                    arrayList.add(String.valueOf(lArray[i]));
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long[] lArray = (long[])dbArray.getValue();
                int[] nArray = null;
                SimpleDateFormat simpleDateFormat = null;
                if (n == 91) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                } else if (n == 92) {
                    simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                } else {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    nArray = dbArray.getNanos();
                }
                if (n == 93) {
                    if (nArray != null) {
                        for (int i = 0; i < lArray.length; ++i) {
                            arrayList.add(simpleDateFormat.format(new Date(lArray[i] + (long)(nArray[i] / 1000000))));
                        }
                    } else {
                        for (int i = 0; i < lArray.length; ++i) {
                            arrayList.add(simpleDateFormat.format(new Date(lArray[i])));
                        }
                    }
                } else {
                    for (int i = 0; i < lArray.length; ++i) {
                        arrayList.add(simpleDateFormat.format(new Date(lArray[i])));
                    }
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])dbArray.getValue();
                for (int i = 0; i < fArray2.length; ++i) {
                    arrayList.add(String.valueOf(fArray2[i]));
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])dbArray.getValue();
                for (int i = 0; i < dArray.length; ++i) {
                    arrayList.add(String.valueOf(dArray[i]));
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])dbArray.getValue();
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    arrayList.add(String.valueOf(bigDecimalArray));
                }
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                String[] stringArray = (String[])dbArray.getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                break;
            }
            default: {
                if (!JRLog.isTrace(6)) break;
                JRLog.trace(6, "invalid sql type: " + n);
            }
        }
        return arrayList;
    }

    public static boolean hasSubLink(JetRptSubReport jetRptSubReport) {
        return ReportTools.hasSubLink(jetRptSubReport, null);
    }

    public static boolean hasSubLink(JetRptSubReport jetRptSubReport, IDataContainer iDataContainer) {
        Object object;
        boolean bl = false;
        List list = jetRptSubReport.getSubLinkContainers();
        String string = null;
        if (iDataContainer != null) {
            string = iDataContainer.getInstName();
        }
        if (list != null) {
            object = null;
            for (int i = 0; i < list.size(); ++i) {
                List list2;
                object = (JetRptSubLinkContainer)list.get(i);
                if (!(string != null ? ((JetRptSubLinkContainer)object).targetCompInst != null && ((JetRptSubLinkContainer)object).targetCompInst.get().contains(string) : (list2 = ((JetRptSubLinkContainer)object).getSubLinks()) != null && list2.size() > 0)) continue;
                return true;
            }
        }
        if (string == null && (object = jetRptSubReport.getParameterLinks()) != null && object.size() > 0) {
            return true;
        }
        object = jetRptSubReport.getSubReturnValueContainers();
        if (object != null) {
            for (int i = 0; i < object.size(); ++i) {
                List list3;
                JetRptSubReturnValueContainer jetRptSubReturnValueContainer = (JetRptSubReturnValueContainer)object.get(i);
                if (!(string != null ? jetRptSubReturnValueContainer.returnValueComponent != null && jetRptSubReturnValueContainer.returnValueComponent.get().equals(string) : (list3 = jetRptSubReturnValueContainer.getReturnVlaues()) != null && list3.size() > 0)) continue;
                return true;
            }
        }
        return bl;
    }

    public static List getDBFieldNameList(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface) {
        Vector vector = new Vector();
        ReportTools.IsSum(jetUUniverse, string, jetUFormulaInterface, vector);
        return vector;
    }

    private static void IsSum(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface, Vector vector) {
        int n;
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        Vector vector2 = formulaInfo.refDBfield;
        Vector vector3 = formulaInfo.refFormula;
        for (n = 0; n < vector2.size(); ++n) {
            String string2 = ((String)vector2.elementAt(n)).toUpperCase();
            if (vector.contains(string2)) continue;
            vector.addElement(string2);
        }
        n = vector3.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector3.elementAt(i);
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
            if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUFormulaInterface)) continue;
            ReportTools.IsSum(jetUUniverse, string, (JetUFormulaInterface)((Object)jetUResourceEntity), vector);
        }
    }

    public static List getParamNameList(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface) {
        Vector vector = new Vector();
        ReportTools.LOGIC_PAGE(jetUUniverse, string, jetUFormulaInterface, vector);
        return vector;
    }

    private static void LOGIC_PAGE(JetUUniverse jetUUniverse, String string, JetUFormulaInterface jetUFormulaInterface, Vector vector) {
        int n;
        FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
        Vector vector2 = formulaInfo.refParameter;
        Vector vector3 = formulaInfo.refFormula;
        for (n = 0; n < vector2.size(); ++n) {
            String string2 = ((String)vector2.elementAt(n)).toUpperCase();
            if (vector.contains(string2)) continue;
            vector.addElement(string2);
        }
        n = vector3.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector3.elementAt(i);
            JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
            if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUFormulaInterface)) continue;
            ReportTools.LOGIC_PAGE(jetUUniverse, string, (JetUFormulaInterface)((Object)jetUResourceEntity), vector);
        }
    }

    public static HashVector getRefUFmls(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula) {
        HashVector hashVector = new HashVector();
        ReportTools.RECORDLOCATION_STR_NAMES(jetUUniverse, string, jetUFormula, hashVector);
        return hashVector;
    }

    private static void RECORDLOCATION_STR_NAMES(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula, HashVector hashVector) {
        String string2 = jetUFormula.getResourceName().toUpperCase();
        if (!hashVector.contains(string2)) {
            hashVector.put(string2, jetUFormula);
            FormulaInfo formulaInfo = jetUFormula.getFormulaInfo();
            Vector vector = formulaInfo.refFormula;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.elementAt(i);
                JetUResourceEntity jetUResourceEntity = jetUUniverse.getMaterialByName(string, string3);
                if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUFormula)) continue;
                ReportTools.RECORDLOCATION_STR_NAMES(jetUUniverse, string, (JetUFormula)jetUResourceEntity, hashVector);
            }
        }
    }

    public static int getFormulaType(JetUUniverse jetUUniverse, String string, JetUFormula jetUFormula) {
        int n = -1;
        if (!jetUFormula.isParsedOK()) {
            return n;
        }
        FormulaInfo formulaInfo = jetUFormula.formulainfo;
        n = formulaInfo.formulatype.getAttr() == 9 ? 100 : (formulaInfo.isUsePageVar() || formulaInfo.isNextPrev() || formulaInfo.isNoRecordCalled() ? 101 : (formulaInfo.formulatype.IsSum() ? 103 : (formulaInfo.isGlobal && !formulaInfo.isSysVar() && formulaInfo.refDBfield.size() < 1 && formulaInfo.refFormula.size() < 1 ? 102 : (formulaInfo.isGroupby ? 105 : 104))));
        return n;
    }

    public static IExpression getIExpression(IDataContainer iDataContainer, JSubLinkContainer jSubLinkContainer, SubLinkProcessor subLinkProcessor, JetUUniverse jetUUniverse) throws JRScheduleException {
        List list;
        String string = iDataContainer.getInstName();
        IBooleanExpression iBooleanExpression = null;
        if (jSubLinkContainer != null && (list = jSubLinkContainer.getDataContainerNames()) != null && list.contains(string)) {
            try {
                iBooleanExpression = subLinkProcessor.getExpression(jSubLinkContainer, jetUUniverse);
            }
            catch (ConditionException conditionException) {
                throw new JRScheduleException(225002, (Object[])new String[]{" DataContainer [" + iDataContainer.getInstName() + "]"}, (Throwable)conditionException);
            }
        }
        return iBooleanExpression;
    }

    public static int getMappingNameType(JetUUniverse jetUUniverse, String string, String string2, String string3) throws JRScheduleException {
        JetUDBTreeNode jetUDBTreeNode;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable != null && (jetUDBTreeNode = jetUQueriable.getFieldByResourceName(string3)) != null) {
            return 0;
        }
        jetUDBTreeNode = jetUUniverse.getDatabase(string);
        if (jetUDBTreeNode == null) {
            throw new JRScheduleException(220021, (Object[])new String[]{string3, string, string2}, null);
        }
        JetUResourceEntity jetUResourceEntity = ((JetUDatabase)jetUDBTreeNode).getResourceByName(string3);
        if (jetUResourceEntity == null) {
            throw new JRScheduleException(220021, (Object[])new String[]{string3, string, string2}, null);
        }
        if (jetUResourceEntity instanceof JetUParameter) {
            return 1;
        }
        if (jetUResourceEntity instanceof JetUFormula) {
            return 2;
        }
        throw new JRScheduleException(220021, (Object[])new String[]{string3, string, string2}, null);
    }

    public static void addMappingNames(Vector vector, String string) {
        if (string != null && string.trim().length() > 0 && !vector.contains(string)) {
            vector.add(string);
        }
    }

    public static Hashtable getBranchToFmls(Vector vector, Hashtable hashtable, int n) {
        Hashtable<String, Vector<Object>> hashtable2 = new Hashtable<String, Vector<Object>>();
        if (vector == null) {
            return hashtable2;
        }
        for (int i = 0; i < vector.size(); ++i) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(i);
            String string = jetRptFormula.getName();
            String string2 = hashtable != null && hashtable.containsKey(string) ? (String)hashtable.get(string) : "";
            Vector<Object> vector2 = (Vector<Object>)hashtable2.get(string2);
            if (vector2 == null) {
                vector2 = new Vector<Object>();
                hashtable2.put(string2, vector2);
            }
            if (n == 0) {
                vector2.addElement(jetRptFormula.name.get());
                continue;
            }
            vector2.addElement(jetRptFormula.getColDesc());
        }
        return hashtable2;
    }

    public static void getBranchToFilter(String string, Hashtable hashtable, Hashtable hashtable2, JSubLinkContainer jSubLinkContainer, Hashtable hashtable3, Hashtable hashtable4, JetUUniverse jetUUniverse) throws InvalidParameterException {
        List list;
        if (jSubLinkContainer != null && (list = jSubLinkContainer.getDataContainerNames()) != null && list.contains(string)) {
            ReportTools.getBranchToDbValueComparer(hashtable, hashtable2, jSubLinkContainer.getSubLinks(), hashtable3, hashtable4);
        }
    }

    public static void getBranchToFilter(String string, Hashtable hashtable, Hashtable hashtable2, LinkToReportContext linkToReportContext, Hashtable hashtable3, Hashtable hashtable4, DataSet dataSet, JetRptReport jetRptReport, JetUUniverse jetUUniverse) throws JRScheduleException {
        if (linkToReportContext != null) {
            List list = linkToReportContext.getFlatSubLinks(string, dataSet, jetRptReport, jetUUniverse);
            try {
                ReportTools.getBranchToDbValueComparer(hashtable, hashtable2, list, hashtable3, hashtable4);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new JRScheduleException(invalidParameterException);
            }
        }
    }

    public static void getBranchToDbValueComparer(Hashtable hashtable, Hashtable hashtable2, List list, Hashtable hashtable3, Hashtable hashtable4) throws InvalidParameterException {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                Object e = list.get(i);
                DbValueComparer dbValueComparer = e instanceof LinkValueEntry ? ReportTools.RecordLocation((LinkValueEntry)e) : (DbValueComparer)list.get(i);
                String string = dbValueComparer.columnName;
                if (hashtable4.containsKey(string.toUpperCase())) {
                    object = (ParamDesc)hashtable4.get(string.toUpperCase());
                    ((ParamDesc)object).set(dbValueComparer.getValue());
                    continue;
                }
                String string2 = ReportTools.getAvailableBranch(string, hashtable, hashtable2);
                Vector<Object> vector = (Vector<Object>)hashtable3.get(string2);
                if (vector == null) {
                    vector = new Vector<Object>();
                    hashtable3.put(string2, vector);
                }
                object = new DbValueComparer();
                ((DbValueComparer)object).columnName = dbValueComparer.columnName;
                ((DbValueComparer)object).value = (DbValue)dbValueComparer.value.clone();
                ((DbValueComparer)object).operator = dbValueComparer.operator;
                vector.addElement(object);
            }
        }
    }

    private static DbValueComparer RecordLocation(LinkValueEntry linkValueEntry) {
        if (linkValueEntry == null) {
            return null;
        }
        DbValueComparer dbValueComparer = new DbValueComparer();
        dbValueComparer.columnName = linkValueEntry.getColumnAttributes().getMappingName();
        dbValueComparer.operator = linkValueEntry.getOp();
        dbValueComparer.value = linkValueEntry.getValue() != null ? linkValueEntry.getValue() : linkValueEntry.getParamDesc().getValue();
        return dbValueComparer;
    }

    public static String getAvailableBranch(String string, Hashtable hashtable, Hashtable hashtable2) {
        String string2 = "";
        if (hashtable != null) {
            String string3 = (String)hashtable.get(string);
            if (string3 != null) {
                string2 = string3;
            } else if (hashtable2 != null && (string3 = (String)hashtable2.get(string)) != null) {
                string2 = string3;
            }
        }
        return string2;
    }

    public static Hashtable mergeBranchToFilter(Hashtable hashtable, Hashtable hashtable2) {
        int n;
        Vector vector;
        Vector vector2;
        String string;
        Enumeration enumeration;
        Hashtable hashtable3 = new Hashtable();
        if (hashtable != null && hashtable.size() > 0) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector2 = (Vector)hashtable.get(string);
                vector = new Vector();
                for (n = 0; n < vector2.size(); ++n) {
                    vector.addElement(vector2.elementAt(n));
                }
                hashtable3.put(string, vector);
            }
        }
        if (hashtable2 != null && hashtable2.size() > 0) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector2 = (Vector)hashtable2.get(string);
                vector = (Vector)hashtable3.get(string);
                if (vector == null) {
                    vector = new Vector();
                    hashtable3.put(string, vector);
                }
                for (n = 0; n < vector2.size(); ++n) {
                    vector.addElement(vector2.elementAt(n));
                }
            }
        }
        return hashtable3;
    }

    public static Map divideIExpressionByBranch(ITupleExpression iTupleExpression, Map map) throws UserException, ConditionException {
        Hashtable hashtable = new Hashtable(map.size());
        for (Map.Entry entry : map.entrySet()) {
            ITupleExpression iTupleExpression2 = ReportTools.checkITupleExpression(iTupleExpression, (List)entry.getValue());
            if (iTupleExpression2 == null) continue;
            hashtable.put(entry.getKey(), iTupleExpression2);
        }
        return hashtable;
    }

    private static IBinaryConditionExpression RuntimeColName_DELIMITER(IBinaryConditionExpression iBinaryConditionExpression, List list) throws UserException, ConditionException {
        IExpression iExpression = iBinaryConditionExpression.getExpression2();
        int n = iExpression.expressionType();
        if (ExpressionToolKit.isConstant(n) || ExpressionToolKit.isVariableList(n)) {
            IExpression iExpression2 = iBinaryConditionExpression.getExpression1();
            n = iExpression2.expressionType();
            if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                if (list.contains(ReportTools.SuppressedIfNoRecords((IVariableExpression)iExpression2))) {
                    return iBinaryConditionExpression;
                }
                return null;
            }
            if (ExpressionToolKit.isParameter(n)) {
                return iBinaryConditionExpression;
            }
            throw new UserException(210508);
        }
        throw new UserException(210509);
    }

    private static ISingleConditionExpression SEDU(ISingleConditionExpression iSingleConditionExpression, List list) throws UserException, ConditionException {
        if (OperatorToolKit.isNotNull(iSingleConditionExpression.getOperator().operatorType()) || OperatorToolKit.isNull(iSingleConditionExpression.getOperator().operatorType())) {
            IExpression iExpression = iSingleConditionExpression.getExpression();
            int n = iExpression.expressionType();
            if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                if (list.contains(ReportTools.SuppressedIfNoRecords((IVariableExpression)iExpression))) {
                    return iSingleConditionExpression;
                }
                return null;
            }
            if (ExpressionToolKit.isParameter(n)) {
                return iSingleConditionExpression;
            }
            throw new UserException(210508);
        }
        throw new UserException(210505);
    }

    private static ITupleExpression SYSTEM_FIELD_TYPE(ISingleLogicExpression iSingleLogicExpression, List list) throws UserException, ConditionException {
        IExpression iExpression;
        if (OperatorToolKit.isNot(iSingleLogicExpression.getOperator().operatorType()) && ExpressionToolKit.isBooleanExp((iExpression = iSingleLogicExpression.getExpression()).expressionType())) {
            ITupleExpression iTupleExpression = ReportTools.checkITupleExpression((ITupleExpression)iExpression, list);
            if (iTupleExpression == null) {
                return null;
            }
            if (iTupleExpression == iExpression) {
                return iSingleLogicExpression;
            }
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            return (ITupleExpression)iExpressionFactory.createSingleLogicExp((ISingleLogicOperator)iSingleLogicExpression.getOperator(), (IBooleanExpression)iTupleExpression);
        }
        throw new UserException(210505);
    }

    private static ITripleConditionExpression SelectStartPosition(ITripleConditionExpression iTripleConditionExpression, List list) throws UserException, ConditionException {
        if (OperatorToolKit.isBetween(iTripleConditionExpression.getOperator().operatorType()) || OperatorToolKit.isNotBetween(iTripleConditionExpression.getOperator().operatorType())) {
            IExpression iExpression;
            IExpression iExpression2 = iTripleConditionExpression.getExpression2();
            int n = iExpression2.expressionType();
            if ((ExpressionToolKit.isConstant(n) || ExpressionToolKit.isVariableList(n)) && (ExpressionToolKit.isConstant(n = (iExpression = iTripleConditionExpression.getExpression3()).expressionType()) || ExpressionToolKit.isVariableList(n))) {
                IExpression iExpression3 = iTripleConditionExpression.getExpression1();
                n = iExpression3.expressionType();
                if (ExpressionToolKit.isReference(n) || ExpressionToolKit.isFormula(n)) {
                    if (list.contains(ReportTools.SuppressedIfNoRecords((IVariableExpression)iExpression3))) {
                        return iTripleConditionExpression;
                    }
                    return null;
                }
                if (ExpressionToolKit.isParameter(n)) {
                    return iTripleConditionExpression;
                }
                throw new UserException(210508);
            }
            throw new UserException(210509);
        }
        throw new UserException(210505);
    }

    private static ITupleExpression SuppressEmpty(IMultiLogicExpression iMultiLogicExpression, List list) throws UserException, ConditionException {
        int n;
        int n2;
        IExpression[] iExpressionArray = iMultiLogicExpression.getExpressions();
        IExpression[] iExpressionArray2 = new IExpression[iExpressionArray.length];
        for (n2 = 0; n2 < iExpressionArray.length; ++n2) {
            if (!ExpressionToolKit.isTupleExp(iExpressionArray[n2].expressionType())) {
                throw new UserException(210505);
            }
            iExpressionArray2[n2] = ReportTools.checkITupleExpression((ITupleExpression)iExpressionArray[n2], list);
        }
        n2 = 0;
        Vector<IExpression> vector = new Vector<IExpression>();
        for (n = 0; n < iExpressionArray.length; ++n) {
            if (iExpressionArray2[n] == null) continue;
            if (iExpressionArray[n] != iExpressionArray2[n]) {
                n2 = 1;
            }
            vector.add(iExpressionArray2[n]);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (ITupleExpression)vector.get(0);
        }
        if (vector.size() < iExpressionArray2.length || vector.size() == iExpressionArray2.length && n2 != 0) {
            iExpressionArray2 = new IExpression[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                iExpressionArray2[n] = (IExpression)vector.get(n);
            }
            IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
            return iExpressionFactory.createMultiLogicExp((IMultiLogicOperator)iMultiLogicExpression.getOperator(), iExpressionArray2);
        }
        return iMultiLogicExpression;
    }

    private static ITupleExpression Suppressed(IBinaryLogicExpression iBinaryLogicExpression, List list) throws UserException, ConditionException {
        IExpression iExpression = iBinaryLogicExpression.getExpression1();
        IExpression iExpression2 = iBinaryLogicExpression.getExpression2();
        if (!ExpressionToolKit.isTupleExp(iExpression.expressionType())) {
            throw new UserException(210506);
        }
        ITupleExpression iTupleExpression = ReportTools.checkITupleExpression((ITupleExpression)iExpression, list);
        if (!ExpressionToolKit.isTupleExp(iExpression2.expressionType())) {
            throw new UserException(210507);
        }
        ITupleExpression iTupleExpression2 = ReportTools.checkITupleExpression((ITupleExpression)iExpression2, list);
        if (iTupleExpression == null && iTupleExpression2 == null) {
            return null;
        }
        if (iTupleExpression != null && iTupleExpression2 != null) {
            if (iTupleExpression != iExpression || iTupleExpression2 != iExpression2) {
                IExpressionFactory iExpressionFactory = ExpressionFactoryCreator.getIExpressionFactory();
                return iExpressionFactory.createBinaryLogicExp((IBinaryLogicOperator)iBinaryLogicExpression.getOperator(), (IBooleanExpression)iTupleExpression, (IBooleanExpression)iTupleExpression2);
            }
            return iBinaryLogicExpression;
        }
        return iTupleExpression == null ? iTupleExpression2 : iTupleExpression;
    }

    public static ITupleExpression checkITupleExpression(ITupleExpression iTupleExpression, List list) throws ConditionException, UserException {
        int n = iTupleExpression.expressionType();
        if (ExpressionToolKit.isBinaryTupleExp(n)) {
            if (ExpressionToolKit.isBinaryConditionExp(n)) {
                return ReportTools.RuntimeColName_DELIMITER((IBinaryConditionExpression)iTupleExpression, list);
            }
            if (ExpressionToolKit.isBinaryLogicExp(n)) {
                return ReportTools.Suppressed((IBinaryLogicExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isTripleTupleExp(n)) {
            if (ExpressionToolKit.isTripleConditonExp(n)) {
                return ReportTools.SelectStartPosition((ITripleConditionExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isSingleTupleExp(n)) {
            if (ExpressionToolKit.isSingleConditionExp(n)) {
                return ReportTools.SEDU((ISingleConditionExpression)iTupleExpression, list);
            }
            if (ExpressionToolKit.isSingleLogicExp(n)) {
                return ReportTools.SYSTEM_FIELD_TYPE((ISingleLogicExpression)iTupleExpression, list);
            }
        } else if (ExpressionToolKit.isMultiExp(n) && ExpressionToolKit.isMultiLogicExp(n)) {
            return ReportTools.SuppressEmpty((IMultiLogicExpression)iTupleExpression, list);
        }
        throw new UserException(210505);
    }

    private static String SuppressedIfNoRecords(IVariableExpression iVariableExpression) throws ConditionException, UserException {
        int n = iVariableExpression.expressionType();
        if (ExpressionToolKit.isConstant(n)) {
            return ((IConstant)iVariableExpression).getValue();
        }
        if (ExpressionToolKit.isFormula(n)) {
            return ((IFormula)iVariableExpression).getName();
        }
        if (ExpressionToolKit.isParameter(n)) {
            return ((IParameter)iVariableExpression).getName();
        }
        if (ExpressionToolKit.isReference(n)) {
            return ((IReference)iVariableExpression).getAttributeName();
        }
        if (ExpressionToolKit.isVariableList(n)) {
            int n2 = ((IVariableList)iVariableExpression).size();
            if (n2 == 0) {
                throw new UserException(210510);
            }
            StringBuffer stringBuffer = new StringBuffer(n2 * 4);
            for (int i = 0; i < n2 - 1; ++i) {
                String string = ReportTools.SuppressedIfNoRecords(((IVariableList)iVariableExpression).getVariableExp(i));
                stringBuffer.append(string).append(String.valueOf('\u0007'));
            }
            stringBuffer.append(ReportTools.SuppressedIfNoRecords(((IVariableList)iVariableExpression).getVariableExp(n2 - 1)));
            return stringBuffer.toString();
        }
        throw new UserException(210511);
    }

    public static JetRptSummary buildRptFormula(String string, MeasureInfo measureInfo, FormulaContainer formulaContainer) throws FormulaSyntaxErrorException {
        String string2 = string.toUpperCase();
        JetRptSummary jetRptSummary = new JetRptSummary();
        jetRptSummary.setName(string2);
        jetRptSummary.setDataSource(formulaContainer);
        String string3 = null;
        String string4 = measureInfo.getAggFunction();
        String string5 = "0";
        String string6 = measureInfo.getRefMappingName().toUpperCase();
        if (string4 == null || string4.length() == 0) {
            string4 = "NONE";
        }
        if (string3 != null && string3.length() > 0) {
            jetRptSummary.setExpression(string4, string6, string5, string3);
        } else {
            jetRptSummary.setExpression(string4, string6, string5);
        }
        jetRptSummary.parseFormula(new FormulatoJava("", null));
        int n = jetRptSummary.getColDesc().getSqlType();
        if (n == 3) {
            Vector vector = jetRptSummary.formulainfo.refAggregation;
            for (int i = 0; i < vector.size(); ++i) {
                Aggregation aggregation = (Aggregation)vector.elementAt(i);
                aggregation.getAggDesc().setSumSqlType(n);
            }
            if (jetRptSummary.formulainfo.aggdesc != null) {
                jetRptSummary.formulainfo.aggdesc.setSumSqlType(n);
            }
        }
        return jetRptSummary;
    }

    public static JetRptFormula buildRptFormula(String string, JetUFormulaInterface jetUFormulaInterface, FormulaContainer formulaContainer) throws FormulaSyntaxErrorException {
        JetRptFormula jetRptFormula = null;
        boolean bl = ReportTools.isUseDynamicSummary(jetUFormulaInterface);
        if (jetUFormulaInterface instanceof JetUSummary) {
            JetUSummary jetUSummary = (JetUSummary)jetUFormulaInterface;
            jetRptFormula = new JetRptSummary();
            jetRptFormula.setDataSource(formulaContainer);
            jetRptFormula.setName(string);
            String string2 = jetUSummary.getSpecFuncKey();
            String string3 = jetUSummary.getGroupByFld();
            if (bl) {
                try {
                    int n = Integer.parseInt(string3);
                    if (n > 0) {
                        n = 0;
                    }
                    string3 = new Integer(n).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormulaSyntaxErrorException(string, " Group by value error. It is not integer value for dynamic summary!");
                }
            }
            if (string2 != null && string2.length() > 0) {
                ((JetRptSummary)jetRptFormula).setExpression(jetUSummary.getFunction(), jetUSummary.getFieldName(), string3, string2);
            } else {
                ((JetRptSummary)jetRptFormula).setExpression(jetUSummary.getFunction(), jetUSummary.getFieldName(), string3);
            }
            jetRptFormula.parseFormula(new FormulatoJava("", null));
        } else {
            jetRptFormula = new JetRptFormula(string, jetUFormulaInterface.getExpression(), formulaContainer);
            jetRptFormula.formulainfo = (FormulaInfo)jetUFormulaInterface.getFormulaInfo().clone();
            jetRptFormula.formulainfo.formulatype.setSymName(string);
            DbColDesc dbColDesc = (DbColDesc)((JetUResourceEntity)((Object)jetUFormulaInterface)).getColDesc().clone();
            dbColDesc.setColName(string);
            jetRptFormula.setColDesc(dbColDesc);
        }
        return jetRptFormula;
    }

    public static boolean isUseDynamicSummary(JetUFormulaInterface jetUFormulaInterface) {
        boolean bl = false;
        if (jetUFormulaInterface != null && jetUFormulaInterface instanceof JetUSummary) {
            FormulaInfo formulaInfo = jetUFormulaInterface.getFormulaInfo();
            Vector vector = formulaInfo.refAggregation;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Aggregation aggregation = (Aggregation)vector.elementAt(i);
                if (!aggregation.getAggDesc().isDynamicSummary()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static JetProperty getBLPropertyUseColumnName(JetObject jetObject, String string) {
        JetProperty jetProperty;
        JetProperty jetProperty2 = null;
        String string2 = ColumnableMapping.getBLColumnNameByColumnName(jetObject, string);
        if (string2 != null && (jetProperty = jetObject.nameToProperty(string2)) != null && jetProperty instanceof JetBLColumnable && ReportTools.useProperty(jetProperty)) {
            jetProperty2 = jetProperty;
        }
        return jetProperty2;
    }

    public static boolean useProperty(JetProperty jetProperty) {
        boolean bl = false;
        if (jetProperty != null) {
            Vector vector;
            String string = null;
            if (jetProperty instanceof JetBLColumnName || jetProperty instanceof JetColumnName) {
                string = jetProperty.toString();
            } else if (jetProperty instanceof JetVector && (vector = ((JetVector)jetProperty).get()) != null && vector.size() > 0) {
                string = (String)vector.firstElement();
            }
            if (string != null && !string.equals("")) {
                bl = true;
            }
        }
        return bl;
    }

    public static JUnifiedBusinessView getBV(JetUUniverse jetUUniverse, String string, String string2, String string3) {
        return jetUUniverse.getBV(string, string3);
    }

    public static BLNode getBLNode(IReport iReport, JetUUniverse jetUUniverse, String string, String string2, String string3, int n, String string4) {
        Scope scope = new Scope(iReport, jetUUniverse, string, string2, string3, n);
        return scope.getBLNodeByQualifiedDisplayName(string4);
    }

    public static JUnifiedBusinessView getBusinessLogic(DataSet dataSet, JetUUniverse jetUUniverse) {
        return jetUUniverse.getBV(dataSet.getDataSourceName(), dataSet.getBlName());
    }

    public static GroupModel getGroupModelByGMIndex(GroupModel groupModel, int n) {
        GroupModel groupModel2 = null;
        if (n >= 0) {
            for (GroupModel groupModel3 = groupModel; groupModel3 != null; groupModel3 = groupModel3.nextToMe()) {
                if (groupModel3.getGroupIndex() != n) continue;
                groupModel2 = groupModel3;
                break;
            }
        }
        return groupModel2;
    }

    public static String getDisplayName(DataSet dataSet, String string, boolean bl, ReportViewCenter reportViewCenter) throws JRScheduleException {
        if (string == null) {
            return null;
        }
        JetUUniverse jetUUniverse = reportViewCenter.getReportViewEngine().getRptSetEngine().getUniverse();
        String string2 = string.toUpperCase();
        BLNode bLNode = null;
        String string3 = "";
        if (bl) {
            bLNode = ObjectLogicFactory.getDataSetLogic().getRefDataElement(jetUUniverse, null, dataSet, string);
            if (bLNode != null && bLNode instanceof DataElementInfo) {
                string3 = ((DataElementInfo)bLNode).getDisplayName();
                string2 = ((DataElementInfo)bLNode).getRefMappingName();
            }
        } else {
            string3 = dataSet.hasDisplayName() ? ReportTools.TOCAnchor(dataSet, string2, reportViewCenter) : string2;
            if (string3 == null || string3.equals("")) {
                string3 = string2;
            }
        }
        return string3;
    }

    private static String TOCAnchor(DataSet dataSet, String string, ReportViewCenter reportViewCenter) throws JRScheduleException {
        Vector vector = dataSet.getResourceAttrs();
        for (int i = 0; i < vector.size(); ++i) {
            JetRptColAttr jetRptColAttr = (JetRptColAttr)vector.elementAt(i);
            if (string.compareToIgnoreCase(jetRptColAttr.resourceName.get()) != 0) continue;
            String string2 = "";
            if (jetRptColAttr.displayName.isChangeByOther()) {
                JRptSetEngine jRptSetEngine = reportViewCenter.getReportViewEngine().getRptSetEngine();
                List list = null;
                try {
                    list = GetValueTools.getFormulaValueList(jRptSetEngine, dataSet, jetRptColAttr.displayName.getChangeByObjectName().toUpperCase(), 0, 1);
                }
                catch (DSException dSException) {
                    throw new JRScheduleException(dSException);
                }
                catch (JRScheduleException jRScheduleException) {
                    throw jRScheduleException;
                }
                if (list != null && list.size() > 0) {
                    string2 = list.get(list.size() - 1).toString();
                }
            } else {
                string2 = jetRptColAttr.displayName.get();
            }
            return string2;
        }
        return null;
    }

    public static boolean isDrillPathComponent(IDataContainer iDataContainer) {
        if (iDataContainer == null) {
            return false;
        }
        if (!(iDataContainer instanceof JetRptSectionObject) && !(iDataContainer instanceof JetRptNewTable)) {
            return false;
        }
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        return !dataContainerLogic.isParallel(iDataContainer);
    }

    public static IExpression cloneIExpression(IExpression iExpression) throws ConditionException {
        return ExpressionToolKit.cloneExpression(iExpression);
    }

    public static boolean supportBrowseAction(JetObject jetObject) {
        return Background.contains(jetObject.getClass().getName());
    }

    public static boolean supportBrowseSort(JetObject jetObject) {
        return BorderColor.contains(jetObject.getClass().getName());
    }

    public static Vector getGroupLevelValue(FormulaQueue formulaQueue, int n) {
        Vector vector = new Vector();
        if (formulaQueue != null) {
            for (int i = n; i < formulaQueue.getGroupSize(); ++i) {
                Vector vector2 = formulaQueue.getSumFmlQueue(1, i);
                Vector vector3 = formulaQueue.getGlobalHSumQueue(i);
                Vector vector4 = formulaQueue.getGlobalFSumQueue(i);
                ReportTools.X(vector, vector2);
                ReportTools.X(vector, vector3);
                ReportTools.X(vector, vector4);
            }
        }
        return vector;
    }

    private static void X(Vector vector, Vector vector2) {
        int n = vector2 == null ? 0 : vector2.size();
        for (int i = 0; i < n; ++i) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector2.elementAt(i);
            if (vector.contains(jetRptFormula.getName())) continue;
            vector.addElement(jetRptFormula.getName());
        }
    }

    public static final String getActualExportStyleGroup(String string, JetRptReport jetRptReport) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = string;
        String[] stringArray = new String[]{"defined\u0007dhtml\u0007export\u0007style", "defined\u0007rst\u0007export\u0007style", "defined\u0007html\u0007export\u0007style", "defined\u0007excel\u0007export\u0007style", "defined\u0007pdf\u0007export\u0007style", "defined\u0007text\u0007export\u0007style", "defined\u0007rtf\u0007export\u0007style", "defined\u0007xml\u0007export\u0007style", "defined\u0007ps\u0007export\u0007style", "defined\u0007fax\u0007export\u0007style"};
        for (n = 0; n < stringArray.length; ++n) {
            vector.addElement(stringArray[n]);
        }
        n = vector.indexOf(string2);
        if (n != -1) {
            if (jetRptReport == null) {
                throw new UnsupportedOperationException("report view is null.");
            }
            switch (n) {
                case 0: {
                    string2 = jetRptReport.stlGrpOfDHTML.get();
                    break;
                }
                case 1: {
                    string2 = jetRptReport.stlGrpOfRST.get();
                    break;
                }
                case 2: {
                    string2 = jetRptReport.stlGrpOfHTML.get();
                    break;
                }
                case 3: {
                    string2 = jetRptReport.stlGrpOfExcel.get();
                    break;
                }
                case 4: {
                    string2 = jetRptReport.stlGrpOfPDF.get();
                    break;
                }
                case 5: {
                    string2 = jetRptReport.stlGrpOfText.get();
                    break;
                }
                case 6: {
                    string2 = jetRptReport.stlGrpOfRTF.get();
                    break;
                }
                case 7: {
                    string2 = jetRptReport.stlGrpOfXML.get();
                    break;
                }
                case 8: {
                    string2 = jetRptReport.stlGrpOfPS.get();
                    break;
                }
                case 9: {
                    string2 = jetRptReport.stlGrpOfFax.get();
                    break;
                }
            }
        }
        return "".equals(string2) ? null : string2;
    }

    public static final boolean equals(RuntimeInfoAgent runtimeInfoAgent, RuntimeInfoAgent runtimeInfoAgent2, JetRptReport jetRptReport) {
        if (jetRptReport == null) {
            throw new NullPointerException();
        }
        RuntimeInfoAgent runtimeInfoAgent3 = runtimeInfoAgent;
        if (!jetRptReport.precisionSense.get() && runtimeInfoAgent.isHighPrecision() != runtimeInfoAgent2.isHighPrecision()) {
            runtimeInfoAgent3 = (RuntimeInfoAgent)runtimeInfoAgent.clone();
            runtimeInfoAgent3.setHighPrecision(runtimeInfoAgent2.isHighPrecision());
        }
        if (Tools.equals(runtimeInfoAgent3, runtimeInfoAgent2)) {
            return true;
        }
        if (runtimeInfoAgent3.isHighPrecision() != runtimeInfoAgent2.isHighPrecision()) {
            return false;
        }
        if (runtimeInfoAgent3.runLinkReport() != runtimeInfoAgent2.runLinkReport()) {
            return false;
        }
        String string = ReportTools.getActualExportStyleGroup(runtimeInfoAgent3.getExportStyleGroup(), jetRptReport);
        String string2 = ReportTools.getActualExportStyleGroup(runtimeInfoAgent2.getExportStyleGroup(), jetRptReport);
        return Tools.equals(string, string2);
    }

    public static final String getStyleGroup(RuntimeInfo runtimeInfo, String string, JetRptReport jetRptReport) {
        return ReportTools.getStyleGroup(runtimeInfo, string, jetRptReport, jetRptReport);
    }

    public static final String getStyleGroup(RuntimeInfo runtimeInfo, String string, JetRptReport jetRptReport, JetRptReport jetRptReport2) {
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.getStyleGroup()..., info: " + runtimeInfo + " userStyleGroup: " + string + " view: " + jetRptReport + " mainView: " + jetRptReport2);
        }
        String string2 = "";
        if (jetRptReport != null) {
            string2 = jetRptReport.stlGroup.get();
        }
        if (jetRptReport != jetRptReport2 && (string2 == null || string2.equals("") || string2.equals("None"))) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "sub report: " + (jetRptReport != jetRptReport2));
                JRLog.trace(6, "subStyle: " + string2);
                JRLog.trace(6, "return: None");
            }
            return "None";
        }
        String string3 = null;
        if (runtimeInfo != null) {
            string3 = runtimeInfo.getExportStyleGroup();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "style group get from runtimeInfo is: " + string3);
        }
        if (string3 != null && !string3.equals("")) {
            if (string3.equals("None")) {
                return "None";
            }
            string3 = ReportTools.getActualExportStyleGroup(string3, jetRptReport2);
        }
        if ((string3 == null || string3.equals("")) && "None".equals(string3 = string)) {
            return "None";
        }
        if (string3 == null || string3.equals("")) {
            if (jetRptReport2 == null) {
                throw new UnsupportedOperationException("main report view is null.");
            }
            string3 = jetRptReport2.stlGroup.get();
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "style group get from main report is: " + string3);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ReportTools.getStyleGroup()..., return: " + string3);
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    public static final JetRptReportSet createReportSet(JetRptReportSet jetRptReportSet, JetRptReport jetRptReport, String string, String[] stringArray) {
        void var16_22;
        JetObject jetObject;
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        JetRptReportSet jetRptReportSet2 = ObjectLogicFactory.getReportSetLogic().createReportSet();
        JetRptReport jetRptReport2 = (JetRptReport)jetRptReport.deepDupWithName();
        Vector vector = jetRptReport2.getRptBody().getChildren();
        if (vector != null) {
            int n = vector.size();
            while (n-- > 0) {
                basicComponentLogic.remove((JetObject)vector.elementAt(n));
            }
        }
        jetRptReport2.getRptBody().dataSet.set(null);
        jetRptReport2.getRptBody().suppressed.set(false);
        jetRptReport2.getRptBody().invisible.set(false);
        IDataContainer iDataContainer = (IDataContainer)((Object)jetRptReport.nameToObject(string));
        DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
        JetRptDataSet jetRptDataSet = (JetRptDataSet)((JetRptDataSet)dataSet).deepDupWithName();
        try {
            jetRptDataSet.setIExpression(null);
            jetRptDataSet.setPreIExpression(null);
        }
        catch (ConditionException conditionException) {
            Tools.logTrace(5, conditionException);
        }
        jetRptDataSet.setMappingListType(1);
        IDataContainer iDataContainer2 = (IDataContainer)((Object)((JetObject)((Object)iDataContainer)).deepDupWithName());
        ReportTools.add(iDataContainer2);
        TreeIterater treeIterater = new TreeIterater(iDataContainer2, false);
        Vector<JetRptSubReport> vector2 = new Vector<JetRptSubReport>();
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptSubReport) {
                vector2.add((JetRptSubReport)jetObject);
                continue;
            }
            ReportTools.access$900(jetObject);
        }
        for (JetRptSubReport jetRptObject2 : vector2) {
            basicComponentLogic.remove(jetRptObject2);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                jetObject = ReportTools.access$300((JetObject)((Object)iDataContainer2), stringArray[i]);
                if (jetObject == null) continue;
                basicComponentLogic.remove(jetObject);
            }
        }
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        dataContainerLogic.clearBrowserIExpression(iDataContainer2, 4098);
        dataContainerLogic.clearDrillIExpression(iDataContainer2);
        dataContainerLogic.clearIExpression(iDataContainer2);
        iDataContainer2.setBindedDataSet(false, jetRptDataSet);
        ReportTools.Y(iDataContainer2);
        jetRptReportSet2.addReport(jetRptReport2);
        Object var16_20 = null;
        if (iDataContainer instanceof JetRptObject) {
            JetRptPagePanel jetRptPagePanel = ObjectLogicFactory.getPageLogic().getPage((JetRptObject)((Object)iDataContainer));
        }
        if (var16_22 != null) {
            JetRptPagePanel jetRptPagePanel = new JetRptPagePanel();
            jetRptPagePanel.setEditable();
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2, jetRptPagePanel);
            JetRptPageStart jetRptPageStart = new JetRptPageStart();
            jetRptPageStart.setPagePanel(jetRptPagePanel);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), jetRptPageStart);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), (JetObject)((Object)iDataContainer2));
            JetRptPageEnd jetRptPageEnd = new JetRptPageEnd();
            jetRptPageEnd.setPagePanel(jetRptPagePanel);
            ObjectLogicFactory.getBasicComponentLogic().add(jetRptReport2.getRptBody(), jetRptPageEnd);
            String string2 = jetRptReport2.getCurrentViewObject().getPageMode();
            jetRptReport2.getCurrentViewObject().setPageMode(JetRptView.LOGIC_PAGE);
            if (!string2.equals(JetRptView.LOGIC_PAGE)) {
                ReportTools.access$100(iDataContainer2);
            }
            ReportTools.access$200(jetRptPagePanel, var16_22.getProperties());
        }
        jetRptReportSet2.addDataSet(jetRptDataSet);
        jetRptReportSet2.setFullFileName(jetRptReportSet.getFullFileName());
        return jetRptReportSet2;
    }

    private static final void Y(IDataContainer iDataContainer) {
        JetObject jetObject = (JetObject)((Object)iDataContainer);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.Background)), "Transparent", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.Invisible)), "false", true);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.Suppressed)), "false", true);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.SuppressedIfNoRecords)), "false", true);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.TOCAnchor)), "false", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.ExportToCSV)), "true", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.ExportToXLS)), "true", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.AnchorDispValue)), jetObject.getInstancePrefix(), false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.BorderColor)), "0x000000", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.SelectStartPosition)), "1", false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.RecordLocation)), EnumerationConstant.RECORDLOCATION_STR_NAMES[0], false);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.SuppressEmpty)), "false", true);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.X)), "0", true);
        ReportTools.Z(jetObject.nameToProperty(PropertyNames.getDefinitionName(PropertyNames.Y)), "0", true);
    }

    private static void Z(JetProperty jetProperty, String string, boolean bl) {
        boolean bl2;
        if (jetProperty == null) {
            return;
        }
        boolean bl3 = bl2 = jetProperty.isChagneByFmtt() || jetProperty.isChangeByBL() || jetProperty.isChangeByOther();
        if (jetProperty.isChagneByFmtt()) {
            jetProperty.setChangeByFmtt(null);
        }
        if (jetProperty.isChangeByBL()) {
            jetProperty.setChangeByBL(null);
        }
        if (jetProperty.isChangeByOther()) {
            jetProperty.setChangeByObject(null);
        }
        if (bl || bl2) {
            jetProperty.setUnitValue(string);
        }
    }

    private static final void access$100(IDataContainer iDataContainer) {
        JetObject jetObject;
        TreeIterater treeIterater = new TreeIterater(iDataContainer, true);
        while ((jetObject = (JetObject)treeIterater.next()) != null) {
            if (jetObject instanceof JetRptGroupPanel) {
                ((JetRptGroupPanel)jetObject).currentBlockIndex.set(0);
                ((JetRptGroupPanel)jetObject).itemsPerBlock.set(-1);
                continue;
            }
            if (jetObject instanceof JetRptDetailPanel) {
                ((JetRptDetailPanel)jetObject).currentBlockIndex.set(0);
                ((JetRptDetailPanel)jetObject).itemsPerBlock.set(-1);
                continue;
            }
            if (!(jetObject instanceof JetRptTableDetail)) continue;
            ((JetRptTableDetail)jetObject).currentBlockIndex.set(0);
            ((JetRptTableDetail)jetObject).itemsPerBlock.set(-1);
        }
    }

    private static final void access$200(JetRptPagePanel jetRptPagePanel, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            JetProperty jetProperty;
            String string = (String)enumeration.nextElement();
            JetProperty jetProperty2 = (JetProperty)hashtable.get(string);
            if (jetProperty2.isChangeByOther() || (jetProperty = jetRptPagePanel.nameToProperty(string)) == null) continue;
            jetProperty.setUnitValue(jetProperty2.toUnitString());
        }
    }

    public static final void doGoToDetail(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string);
        while ((jetObject = (JetObject)goToComponentInfo.getAllPosterityComponentByClass.next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (goToComponentInfo.access$400.contains(jetObject)) {
                ReportTools.access$800((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.access$800((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoTo(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string);
        while ((jetObject = (JetObject)goToComponentInfo.getAllPosterityComponentByClass.next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (goToComponentInfo.access$400.contains(jetObject)) {
                if (!goToComponentInfo.SEDU.getChildren().contains(jetObject)) continue;
                ReportTools.access$800((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.access$800((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoUp(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string);
        while ((jetObject = (JetObject)goToComponentInfo.getAllPosterityComponentByClass.next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (goToComponentInfo.access$400.contains(jetObject)) {
                if (!goToComponentInfo.SEDU.getChildren().contains(jetObject)) continue;
                ReportTools.access$800((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.access$800((JetRptSection)jetObject, true, true);
        }
    }

    public static final void doGoDown(JetRptReport jetRptReport, String string) {
        JetObject jetObject;
        GoToComponentInfo goToComponentInfo = new GoToComponentInfo(jetRptReport, string);
        while ((jetObject = (JetObject)goToComponentInfo.getAllPosterityComponentByClass.next()) != null) {
            if (!(jetObject instanceof JetRptSection)) continue;
            if (goToComponentInfo.access$400.contains(jetObject)) {
                if (!goToComponentInfo.SEDU.getChildren().contains(jetObject)) continue;
                ReportTools.access$800((JetRptSection)jetObject, false, false);
                continue;
            }
            ReportTools.access$800((JetRptSection)jetObject, true, true);
        }
    }

    private static final JetObject access$300(JetObject jetObject, String string) {
        JetObject jetObject2;
        TreeIterater treeIterater = new TreeIterater(jetObject, false);
        JetObject jetObject3 = null;
        while ((jetObject2 = (JetObject)treeIterater.next()) != null) {
            if (!jetObject2.getInstName().equals(string)) continue;
            jetObject3 = jetObject2;
            break;
        }
        return jetObject3;
    }

    private static final void access$800(JetRptSection jetRptSection, boolean bl, boolean bl2) {
        jetRptSection.suppressed.set(bl);
        jetRptSection.invisible.set(bl2);
    }

    private static final void access$900(JetObject jetObject) {
        if (jetObject == null) {
            return;
        }
        if (jetObject instanceof Linkable) {
            ((Linkable)((Object)jetObject)).getLinkableSetor().setSimpleLinkValue(null, true, null);
            ((Linkable)((Object)jetObject)).getLinkableSetor().setConditionalLinkValue(null, null);
        }
    }

    private static void add(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.get(n2);
            if (e instanceof JetRptSubLink) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetRptSubLink)e);
                --n;
                continue;
            }
            if (e instanceof JetRptSubLinkContainer) {
                ObjectLogicFactory.getBasicComponentLogic().remove((JetRptSubLinkContainer)e);
                --n;
                continue;
            }
            ++n2;
        }
    }

    public static int getGroupPanelType(JetRptGroupPanel jetRptGroupPanel) {
        return jetRptGroupPanel.groupType.get();
    }

    public static boolean isSummaryRefernced(JetRptFormula jetRptFormula, Scope scope) {
        FormulaInfo formulaInfo = jetRptFormula.formulainfo;
        if (formulaInfo.refAggregation.size() > 0) {
            return true;
        }
        for (int i = 0; i < formulaInfo.refFormula.size(); ++i) {
            String string = (String)formulaInfo.refFormula.elementAt(i);
            JetUResourceEntity jetUResourceEntity = scope.getResourceEntity(string, false);
            if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUFormula)) continue;
            if (jetUResourceEntity instanceof JetUSummary) {
                return true;
            }
            JetUFormula jetUFormula = (JetUFormula)jetUResourceEntity;
            JetRptFormula jetRptFormula2 = jetUFormula.getRptFormula();
            if (!ReportTools.isSummaryRefernced(jetRptFormula2, scope)) continue;
            return true;
        }
        return false;
    }

    public static boolean canCacheQueryForDefault(JetUUniverse jetUUniverse, String string, String string2) {
        boolean bl = true;
        JetUQueriable jetUQueriable = jetUUniverse.getQueriableByResourceName(string, string2);
        if (jetUQueriable instanceof JetUQuery) {
            if (((JetUQuery)jetUQueriable).enableSQLStmtCreator.get()) {
                bl = false;
            }
        } else if (jetUQueriable instanceof JetUHDSTable && jetUQueriable instanceof JetUHierDataSource) {
            bl = false;
        }
        return bl;
    }

    public static boolean isRealDataInherit(IDataContainer iDataContainer) {
        boolean bl = false;
        if (iDataContainer instanceof JetRptSection || iDataContainer.isInheritDataSet()) {
            bl = true;
        } else {
            int n;
            DataSet dataSet = ObjectLogicFactory.getDataContainerLogic().getUsedDataSet(iDataContainer);
            if (dataSet != null && dataSet.isExtends() && (n = ((JetRptExtendsDataSet)dataSet).getExtendsType()) == 1) {
                bl = true;
            }
        }
        return bl;
    }

    public static JRawDataQuery getRawQuery(int n, JDataService jDataService) throws DSException {
        int n2;
        int n3;
        JQuery jQuery;
        int n4 = -1;
        JRawDataQuery jRawDataQuery = null;
        JQuery jQuery2 = jDataService.getQuery(n);
        if (jQuery2 instanceof JGroupQuery && (jQuery = jDataService.getQuery(n3 = ((JComponentFilterQuery)jDataService.getQuery(n2 = ((JGroupQuery)jQuery2).getBaseId())).getBaseId())) instanceof JRawDataQuery) {
            jRawDataQuery = (JRawDataQuery)jQuery;
            n4 = jRawDataQuery.getQueryId();
            while (jRawDataQuery instanceof JIterativeQuery) {
                n4 = ((JIterativeQuery)jRawDataQuery).getBaseId();
                jRawDataQuery = (JRawDataQuery)jDataService.getQuery(n4);
            }
        }
        return jRawDataQuery;
    }

    public static JavaFormula loadJavaFormula(String string, JetUUniverse jetUUniverse) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(5)) {
            l = System.currentTimeMillis();
        }
        JavaFormula javaFormula = null;
        Throwable throwable = null;
        try {
            javaFormula = jetUUniverse.loadJavaFormula(string);
        }
        catch (GenerateFormulasCodeException generateFormulasCodeException) {
            throwable = generateFormulasCodeException;
        }
        catch (ReadFailureException readFailureException) {
            throwable = readFailureException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throwable = fileNotFoundException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (LoadJavaFormulaException loadJavaFormulaException) {
            throwable = loadJavaFormulaException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            throw new JRScheduleException(225010, (Object[])new String[]{string}, throwable);
        }
        if (JRLog.isTrace(5)) {
            long l2 = System.currentTimeMillis();
            JRLog.trace(5, "ReportTools.loadJavaFormula(...) for catalog level: load catalog JavaFormula for dataSource: " + string + ", [ELAPSED]: " + new Long(l2 - l).toString() + " ms.");
        }
        return javaFormula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadOnTheFlyJavaFormulaClass(Scope scope) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(5)) {
            l = System.currentTimeMillis();
        }
        Class clazz = null;
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        JetRptFlyFormulaClass jetRptFlyFormulaClass = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaClass(scope);
        Throwable throwable = null;
        if (jetRptFlyFormulaClass != null) {
            block8: {
                Object object;
                try {
                    object = DynamicClassManager.getInstance();
                    clazz = ((DynamicClassManager)object).bytesToClass(jetRptFlyFormulaClass.getClassName(), jetRptFlyFormulaClass.getClassBytes(), false);
                    if (clazz != null && throwable == null) break block8;
                    object = scope.toString();
                }
                catch (Throwable throwable2) {
                    String string;
                    try {
                        throwable = throwable2;
                        if (clazz != null && throwable == null) break block8;
                        string = scope.toString();
                    }
                    catch (Throwable throwable3) {
                        if (clazz == null || throwable != null) {
                            String string2 = scope.toString();
                            throw new JRScheduleException(225030, (Object[])new String[]{string2}, throwable);
                        }
                        throw throwable3;
                    }
                    throw new JRScheduleException(225030, (Object[])new String[]{string}, throwable);
                }
                throw new JRScheduleException(225030, (Object[])new String[]{object}, throwable);
            }
            if (JRLog.isTrace(5)) {
                long l2 = System.currentTimeMillis();
                JRLog.trace(5, " ReportTools.loadOnTheFlyJavaFormulaClass(...): load JavaFormula for on the fly formula about scope:" + scope + ", [ELAPSED]: " + new Long(l2 - l).toString() + " ms. theClass = " + clazz);
            }
        }
        return clazz;
    }

    public static JavaFormula loadBVJavaFormula(QueryInfo queryInfo, JetUUniverse jetUUniverse) throws JRScheduleException {
        long l = 0L;
        if (JRLog.isTrace(5)) {
            l = System.currentTimeMillis();
        }
        JavaFormula javaFormula = null;
        Throwable throwable = null;
        if (jetUUniverse != null && queryInfo.getDataResoureType() == 2) {
            Scope scope = new Scope(null, jetUUniverse, queryInfo);
            UnifiedBusinessView unifiedBusinessView = scope.getBusinessView();
            if (unifiedBusinessView != null) {
                try {
                    javaFormula = unifiedBusinessView.loadJavaFormula();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (throwable != null) {
                String string = scope.toString();
                throw new JRScheduleException(225039, (Object[])new String[]{string}, throwable);
            }
            if (javaFormula != null && JRLog.isTrace(5)) {
                long l2 = System.currentTimeMillis();
                JRLog.trace(5, " ReportTools.loadBVJavaFormulaClass(...): get JavaFormula for BV formula: universe = " + jetUUniverse + ", dataSourceName = " + queryInfo.getDatasourceName() + ", uQueryName = " + queryInfo.getQueryName() + ", type = " + queryInfo.getDataResoureType() + ", bvName = " + queryInfo.getBLName() + ", [ELAPSED]: " + new Long(l2 - l).toString() + " ms. javaFormula = " + javaFormula);
            }
        }
        return javaFormula;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class loadRptFormulaClass(String string, JetRptReport jetRptReport) throws JRScheduleException {
        Class clazz;
        long l;
        block10: {
            Serializable serializable;
            l = 0L;
            if (JRLog.isTrace(5)) {
                l = System.currentTimeMillis();
            }
            clazz = null;
            JetRptAbstractFormulaClass jetRptAbstractFormulaClass = null;
            JetRptReportFormulaClassSet jetRptReportFormulaClassSet = jetRptReport.getConditionalFormatClassSet();
            if (jetRptReportFormulaClassSet != null) {
                serializable = jetRptReportFormulaClassSet.getChildren();
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    if (!((JetRptReportFormulaClass)((Vector)serializable).get(i)).getdataSourceName().equals(string)) continue;
                    jetRptAbstractFormulaClass = (JetRptReportFormulaClass)((Vector)serializable).get(i);
                    break;
                }
            }
            if (jetRptAbstractFormulaClass == null) return clazz;
            serializable = null;
            try {
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                clazz = dynamicClassManager.bytesToClass(jetRptAbstractFormulaClass.getClassName(), jetRptAbstractFormulaClass.getClassBytes(), false);
                if (clazz != null && serializable == null) break block10;
                throw new JRScheduleException(225010, (Object[])new String[]{string}, (Throwable)serializable);
            }
            catch (Throwable throwable) {
                try {
                    serializable = throwable;
                    if (clazz == null || serializable != null) {
                        throw new JRScheduleException(225010, (Object[])new String[]{string}, (Throwable)serializable);
                    }
                }
                catch (Throwable throwable2) {
                    if (clazz == null || serializable != null) throw new JRScheduleException(225010, (Object[])new String[]{string}, (Throwable)serializable);
                    throw throwable2;
                }
            }
        }
        if (!JRLog.isTrace(5)) return clazz;
        long l2 = System.currentTimeMillis();
        JRLog.trace(5, "ReportTools.loadRptFormulaClass(...): load ReportFormula javaformula for dataSource: " + string + ", [ELAPSED]: " + new Long(l2 - l).toString() + " ms.");
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JavaFormula loadJavaFormulaForCrosstabFormula(JetUUniverse jetUUniverse, JetRptCTCrossTab jetRptCTCrossTab) throws JRScheduleException {
        String string;
        JavaFormula javaFormula;
        long l;
        block8: {
            l = 0L;
            if (JRLog.isTrace(5)) {
                l = System.currentTimeMillis();
            }
            javaFormula = null;
            string = jetRptCTCrossTab.getInstName();
            CrosstabLogic crosstabLogic = ObjectLogicFactory.getCrosstabLogic();
            CrosstabEditInfo crosstabEditInfo = new CrosstabEditInfo(jetUUniverse, null, jetRptCTCrossTab, null, null);
            JetRptFlyFormulaClass jetRptFlyFormulaClass = crosstabLogic.getCTFormulaClass(crosstabEditInfo);
            Throwable throwable = null;
            if (jetRptFlyFormulaClass == null) return javaFormula;
            try {
                byte[] byArray = jetRptFlyFormulaClass.getClassBytes();
                DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
                Class clazz = dynamicClassManager.bytesToClass(jetRptFlyFormulaClass.getClassName(), byArray);
                javaFormula = (JavaFormula)clazz.newInstance();
                if (javaFormula != null && throwable == null) break block8;
                throw new JRScheduleException(225035, (Object[])new String[]{string}, throwable);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    if (javaFormula == null || throwable != null) {
                        throw new JRScheduleException(225035, (Object[])new String[]{string}, throwable);
                    }
                }
                catch (Throwable throwable3) {
                    if (javaFormula == null || throwable != null) throw new JRScheduleException(225035, (Object[])new String[]{string}, throwable);
                    throw throwable3;
                }
            }
        }
        if (!JRLog.isTrace(5)) return javaFormula;
        long l2 = System.currentTimeMillis();
        JRLog.trace(5, "ReportTools.loadJavaFormulaForCrosstabFormula(...): load crosstab formula javaformula for crosstab: " + string + ", [ELAPSED]: " + new Long(l2 - l).toString() + " ms.");
        return javaFormula;
    }

    public static Hashtable getHtJetRptFlyFormulaCollection(Scope scope) {
        Hashtable<String, JetUFormula> hashtable = new Hashtable<String, JetUFormula>();
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        for (JetRptAbstractFormula jetRptAbstractFormula : list) {
            JetUFormula jetUFormula = jetRptAbstractFormula.getJetUFormula();
            String string = jetRptAbstractFormula.getMappingName().toUpperCase();
            hashtable.put(string, jetUFormula);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, " ReportTools.getHtJetRptFlyFormulaCollection is " + hashtable + ",  for scope:  dataSourceName = " + scope.getDataSourceName() + " , queryName = " + scope.getQueryName() + " , bvName = " + scope.getBVName() + " , dataResourceType = " + scope.getScopeType());
        }
        return hashtable;
    }

    public static Hashtable getOnTheFlyParameterCollection(Scope scope) {
        Hashtable<String, JetUParameter> hashtable = new Hashtable<String, JetUParameter>();
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        List list = onTheFlyParameterLogic.getDynamicParameterList(scope);
        for (JetUParameter jetUParameter : list) {
            String string = jetUParameter.name.get().toUpperCase();
            hashtable.put(string, jetUParameter);
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, " ReportTools.getOnTheFlyParameterCollection is " + hashtable + ",  for scope:  dataSourceName = " + scope.getDataSourceName() + " , queryName = " + scope.getQueryName() + " , blName = " + scope.getBVName() + " , dataResourceType = " + scope.getScopeType());
        }
        return hashtable;
    }

    public static DbColDesc getSQLType(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, String string, boolean bl, List list, Hashtable hashtable) {
        DbColDesc dbColDesc = null;
        Object object = ReportTools.getResourceObject(jetUUniverse, iReport, queryInfo, string, bl, list, hashtable);
        String string2 = string;
        if (object instanceof JetUResourceEntity) {
            dbColDesc = ((JetUResourceEntity)object).getColDesc();
        } else if (object instanceof DataElementInfo) {
            DataElementInfo dataElementInfo = (DataElementInfo)object;
            int n = dataElementInfo.getElementType();
            switch (n) {
                case 4: {
                    Dimension dimension = (Dimension)dataElementInfo;
                    string2 = dimension.getRefMappingName();
                    dbColDesc = EngineTools.getSQLType(jetUUniverse, queryInfo, string2);
                    break;
                }
                case 5: {
                    dbColDesc = ReportTools.getMeasureSQLType(iReport, jetUUniverse, queryInfo.getDatasourceName(), queryInfo.getQueryName(), queryInfo.getBLName(), queryInfo.getDataResoureType(), string, (MeasureInfo)dataElementInfo);
                    if (dbColDesc == null) break;
                    string2 = dbColDesc.getColName();
                    break;
                }
                case 7: {
                    if (dataElementInfo instanceof JetRptFlyFormula) {
                        JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)object;
                        JetUFormula jetUFormula = jetRptFlyFormula.getJetUFormula();
                        string2 = jetRptFlyFormula.getMappingName();
                        if (jetUFormula == null) break;
                        dbColDesc = jetUFormula.getColDesc();
                        break;
                    }
                    DetailInfo detailInfo = (DetailInfo)dataElementInfo;
                    string2 = detailInfo.getRefMappingName();
                    dbColDesc = EngineTools.getSQLType(jetUUniverse, queryInfo, string2);
                    break;
                }
            }
        }
        if (dbColDesc == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Can not find SQLType for: colName = " + string + "  , dataSource = " + queryInfo.getDatasourceName() + ", queryName = " + queryInfo.getQueryName() + ", blName = " + queryInfo.getBLName() + ", scopeType = " + queryInfo.getDataResoureType(), null);
            }
        } else {
            dbColDesc.setColName(string2);
        }
        return dbColDesc;
    }

    public static Object getResourceObject(JetUUniverse jetUUniverse, IReport iReport, QueryInfo queryInfo, String string, boolean bl, List list, Hashtable hashtable) {
        Object object;
        Object object2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "ReportTools.getResourceObject()..., resourceName: " + string + " isBlColumnName: " + bl + " report: " + iReport + " universe: " + jetUUniverse + ", queryInfo = " + queryInfo + " dcNames: " + list + ", htNameToRptUFmls = " + hashtable);
        }
        Object object3 = null;
        Scope scope = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object2 = (String)list.get(i);
                object = (IDataContainer)((Object)iReport.nameToObject((String)object2));
                if (object == null || (object3 = (scope = new DCScope(null, null, (IDataContainer)object)).getResourceObject(string, bl)) == null) continue;
                if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "End of ReportTools.getResourceObject()..., from : " + object.getInstName() + " return: " + object3);
                }
                return object3;
            }
        }
        if ((object3 = (scope = new Scope(iReport, jetUUniverse, queryInfo)).getResourceObject(string, bl)) == null) {
            Object var9_10 = null;
            if (hashtable != null) {
                var9_10 = hashtable.get(string.toUpperCase());
            }
            if (var9_10 != null) {
                object3 = var9_10;
            } else if (iReport != null && (object2 = iReport.getUFormulaSet(queryInfo.getDatasourceName())) != null) {
                object = ((JetRptContainer)object2).getChildren();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Object e = ((Vector)object).get(i);
                    if (!(e instanceof JetUFormula) || !((JetUFormula)e).getResourceName().equalsIgnoreCase(string)) continue;
                    if (hashtable != null) {
                        hashtable.put(((JetUFormula)e).getResourceName().toUpperCase(), e);
                    }
                    object3 = e;
                    break;
                }
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of ReportTools.getResourceObject()..., from report/unv, return: " + object3);
        }
        return object3;
    }

    public static String getRuntimeColumnName(String string, JetUFormulaInterface jetUFormulaInterface, String string2) {
        String string3 = string;
        if (jetUFormulaInterface != null && ReportTools.isUseDynamicSummary(jetUFormulaInterface)) {
            string3 = string3 + RuntimeColName_DELIMITER + string2.toUpperCase();
            string3 = string3.toUpperCase();
        }
        return string3;
    }

    public static DbColDesc getMeasureSQLType(IReport iReport, JetUUniverse jetUUniverse, String string, String string2, String string3, int n, String string4, MeasureInfo measureInfo) {
        DbColDesc dbColDesc = null;
        if (measureInfo.isCustomized()) {
            dbColDesc = (DbColDesc)measureInfo.getJetUFormula().getColDesc().clone();
        } else {
            Object object;
            JetRptSummary jetRptSummary = null;
            try {
                object = null;
                Scope scope = new Scope(iReport, jetUUniverse, string, string2, string3, n);
                object = new RptFormulaContainer(iReport, jetUUniverse, scope.getQueryInfo());
                Hashtable hashtable = ReportTools.getHtJetRptFlyFormulaCollection(scope);
                ((RptFormulaContainer)object).setHtOnTheFlyFlms(hashtable);
                List list = scope.getDynamicParameterList();
                Hashtable<String, JetUParameter> hashtable2 = new Hashtable<String, JetUParameter>();
                for (JetUParameter jetUParameter : list) {
                    hashtable2.put(jetUParameter.name.get().toUpperCase(), jetUParameter);
                }
                ((RptFormulaContainer)object).setOnTheFlyParameter(hashtable2);
                jetRptSummary = ReportTools.buildRptFormula(string4, measureInfo, (FormulaContainer)object);
            }
            catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, formulaSyntaxErrorException);
                }
                return null;
            }
            if (jetRptSummary != null) {
                object = jetRptSummary.formulainfo;
                if (((FormulaInfo)object).parseOK) {
                    dbColDesc = jetRptSummary.getColDesc();
                }
            }
        }
        if (dbColDesc != null) {
            dbColDesc.setColName(string4);
        }
        return dbColDesc;
    }

    public static boolean hasTotalRecordInFormulas(HashVector hashVector) {
        boolean bl = false;
        int n = hashVector.size();
        JetRptFormula jetRptFormula = null;
        Vector vector = null;
        String string = EnumerationConstant.SYSTEM_FIELD_TYPE[17];
        String string2 = EnumerationConstant.SYSTEM_FIELD_TYPE[18];
        for (int i = 0; i < n; ++i) {
            jetRptFormula = (JetRptFormula)hashVector.get(hashVector.elementAt(i));
            vector = jetRptFormula.formulainfo.getRefSysVars();
            if (!vector.contains(string.toUpperCase()) && !vector.contains(string2.toUpperCase())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static DrillFilterInfo getDrillFilterInfo(JetUUniverse jetUUniverse, JetRptReportSet jetRptReportSet, String string, String string2) throws ConditionException {
        int n;
        IExpression[] iExpressionArray;
        Object object;
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        if (jetRptReport == null) {
            return null;
        }
        JetObject jetObject = jetRptReport.nameToObject(string2);
        IDataContainer iDataContainer = null;
        if (jetObject instanceof IDataContainer) {
            iDataContainer = (IDataContainer)((Object)jetObject);
        }
        if (iDataContainer == null) {
            return null;
        }
        DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
        DataSet dataSet = dataContainerLogic.getUsedDataSet(iDataContainer);
        if (dataSet == null) {
            return null;
        }
        IExpression iExpression = dataContainerLogic.getDrillIExpression(iDataContainer);
        if (iExpression == null) {
            return null;
        }
        ArrayList<DrillFilterImpl> arrayList = new ArrayList<DrillFilterImpl>();
        int n2 = iExpression.expressionType();
        if (ExpressionToolKit.isBinaryConditionExp(n2)) {
            object = (IBinaryConditionExpression)iExpression;
            arrayList.add(new DrillFilterImpl((IBinaryConditionExpression)object, jetUUniverse, dataSet));
        } else if (ExpressionToolKit.isBinaryLogicExp(n2)) {
            object = (IBinaryLogicExpression)iExpression;
            iExpressionArray = object.getExpressions();
            for (n = 0; n < iExpressionArray.length; ++n) {
                arrayList.add(new DrillFilterImpl((IBinaryConditionExpression)iExpressionArray[n], jetUUniverse, dataSet));
            }
        } else if (ExpressionToolKit.isMultiExp(n2)) {
            object = (IMultiLogicExpression)iExpression;
            iExpressionArray = object.getExpressions();
            for (n = 0; n < iExpressionArray.length; ++n) {
                if (ExpressionToolKit.isSingleBooleanExp(iExpressionArray[n].expressionType())) {
                    arrayList.add(new DrillFilterImpl((ISingleConditionExpression)iExpressionArray[n], jetUUniverse, dataSet));
                    continue;
                }
                arrayList.add(new DrillFilterImpl((IBinaryConditionExpression)iExpressionArray[n], jetUUniverse, dataSet));
            }
        } else if (ExpressionToolKit.isSingleBooleanExp(n2)) {
            object = (ISingleConditionExpression)iExpression;
            arrayList.add(new DrillFilterImpl((ISingleConditionExpression)object, jetUUniverse, dataSet));
        }
        object = new DrillFilterInfo();
        for (int i = 0; i < arrayList.size(); ++i) {
            IDrillFilter iDrillFilter = (IDrillFilter)arrayList.get(i);
            ((DrillFilterInfo)object).addDrillFilter(iDrillFilter);
            BusinessEntityInfo businessEntityInfo = ReportTools.addDrillFilter(jetUUniverse, dataSet, iDrillFilter.getResourceName());
            ((DrillFilterInfo)object).setBusinessEntityInfo(iDrillFilter.getResourceName(), businessEntityInfo);
        }
        return object;
    }

    private IDrillFilter addDataSet(JetUUniverse jetUUniverse, DataSet dataSet, IExpression iExpression) throws ConditionException {
        if (ExpressionToolKit.isBinaryConditionExp(iExpression.expressionType())) {
            IBinaryConditionExpression iBinaryConditionExpression = (IBinaryConditionExpression)iExpression;
            return new DrillFilterImpl(iBinaryConditionExpression, jetUUniverse, dataSet);
        }
        if (ExpressionToolKit.isSingleBooleanExp(iExpression.expressionType())) {
            ISingleConditionExpression iSingleConditionExpression = (ISingleConditionExpression)iExpression;
            return new DrillFilterImpl(iSingleConditionExpression, jetUUniverse, dataSet);
        }
        return null;
    }

    private static BusinessEntityInfo addDrillFilter(JetUUniverse jetUUniverse, DataSet dataSet, String string) {
        if (dataSet.getDataResourceType() != 2) {
            return null;
        }
        UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(dataSet.getDataSourceName(), dataSet.getBlName());
        BLNode bLNode = unifiedBusinessView == null ? null : unifiedBusinessView.getByDisplayName(string);
        BusinessEntityInfo businessEntityInfo = null;
        if (bLNode != null) {
            businessEntityInfo = new BusinessEntityInfo(unifiedBusinessView.getDisplayName(), string, bLNode.getDisplayName());
        }
        return businessEntityInfo;
    }

    public static JetRptReportSet createReportsetWithSubs(JetUUniverse jetUUniverse, List list, ResourceStore resourceStore) {
        ReportSetLogic reportSetLogic = ObjectLogicFactory.getReportSetLogic();
        SubReportLogic subReportLogic = ObjectLogicFactory.getSubReportLogic();
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        BasicComponentLogic basicComponentLogic = ObjectLogicFactory.getBasicComponentLogic();
        JetRptReportSet jetRptReportSet = reportSetLogic.createReportSet();
        JetRptReport jetRptReport = reportSetLogic.createReport();
        reportSetLogic.addReport(jetRptReportSet, jetRptReport, resourceStore);
        JetRptReportBody jetRptReportBody = jetRptReport.getRptBody();
        for (JetRptReportSet jetRptReportSet2 : list) {
            if (jetRptReportSet2 == null) continue;
            String string = new File(jetRptReportSet2.getFullFileName()).getName();
            for (JetRptReport jetRptReport2 : jetRptReportSet2.getReports().getChildren()) {
                Object object;
                Hashtable hashtable;
                if (jetRptReport2.getStatus() != 0 || (hashtable = reportLogic.getParameters(jetUUniverse, jetRptReport2, true, false)).size() <= 0) continue;
                Iterator iterator = hashtable.keySet().iterator();
                Vector<JetRptParamLink> vector = new Vector<JetRptParamLink>();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    JetRptParamLink jetRptParamLink = new JetRptParamLink();
                    jetRptParamLink.setEditable();
                    jetRptParamLink.mainColumn.set((String)object);
                    jetRptParamLink.operator.set(DbValueComparer.strOper[0]);
                    jetRptParamLink.subColumn.set((String)object);
                    vector.add(jetRptParamLink);
                }
                object = subReportLogic.createSubReport(string, jetRptReport2.getInstNameDirectly(), "", jetRptReport2.getDisplayName(), new Vector(), vector, new Vector());
                basicComponentLogic.add(jetRptReportBody, (JetObject)object);
            }
        }
        return jetRptReportSet;
    }

    public static SubRptParamInfo mergeSubRptParamInfos(List list) {
        return JEngineInitializer.mergeSubRptParamInfos(list);
    }

    public static String[] getDataPara(FlyResourceScope flyResourceScope) throws JRScheduleException {
        String string = flyResourceScope.getBLName();
        String[] stringArray = JStringToolKit.splitString(string, ".");
        if (stringArray.length < 2) {
            throw new JRSInvalidParameterException(250004, (Object[])new String[]{string}, null);
        }
        String string2 = "";
        try {
            string2 = flyResourceScope.getDataSourceName();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string2 = stringArray[0];
        }
        String string3 = "";
        try {
            string3 = flyResourceScope.getQueryName();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string3 = stringArray[1];
        }
        String[] stringArray2 = new String[]{string2, string3, stringArray[2], String.valueOf(flyResourceScope.getResourceType())};
        return stringArray2;
    }

    public static Scope generateScope(JetRptReport jetRptReport, JetUUniverse jetUUniverse, FlyResourceScope flyResourceScope) throws JRScheduleException {
        String[] stringArray = ReportTools.getDataPara(flyResourceScope);
        return new Scope(jetRptReport, jetUUniverse, stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
    }

    public static FlyFormulaInfo getFlyFormulaInfo(JetRptFlyFormula jetRptFlyFormula, Scope scope) {
        FlyFormulaInfo flyFormulaInfo = new FlyFormulaInfo(scope.getBVName(), jetRptFlyFormula.getQualifiedDisplayName(), jetRptFlyFormula.getDisplayName(), jetRptFlyFormula.getFormulaExpression());
        flyFormulaInfo.setSqlType(jetRptFlyFormula.getJetUFormula().getSqlType());
        flyFormulaInfo.setCanBeUsedInDynamicMeasure(scope.isReferenceDynamicResource(jetRptFlyFormula));
        flyFormulaInfo.setMappingName(jetRptFlyFormula.getRefMappingName());
        return flyFormulaInfo;
    }

    public static FlyMeasureInfo getFlyMeasureInfo(JetRptFlyMeasure jetRptFlyMeasure, Scope scope) {
        FlyMeasureInfo flyMeasureInfo = new FlyMeasureInfo(scope.getBVName(), jetRptFlyMeasure.getQualifiedDisplayName(), jetRptFlyMeasure.getDisplayName(), jetRptFlyMeasure.getAggFunction());
        flyMeasureInfo.setBasedQualifyDisplayName(jetRptFlyMeasure.getBasedFieldName());
        flyMeasureInfo.setMappingName(jetRptFlyMeasure.getRefMappingName());
        return flyMeasureInfo;
    }

    public static boolean isCrosstabQualifyName(String string) {
        return string.startsWith("[");
    }

    public static void restoreRptSetStatus(JetRptReportSet jetRptReportSet, RptSetStatus rptSetStatus) {
        if (jetRptReportSet == null || rptSetStatus == null) {
            return;
        }
    }

    public static int getValidColumnUseArgumentIndex(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string, String string2) {
        if (queryInfo == null) {
            return -1;
        }
        int n = ReportTools.getValidColumnUseArgumentFlag(jetUUniverse, queryInfo, string, string2);
        if (n < 16) {
            return 0;
        }
        if (n < 32) {
            return 1;
        }
        return -1;
    }

    public static int getValidColumnUseArgumentFlag(JetUUniverse jetUUniverse, QueryInfo queryInfo, String string, String string2) {
        int n = ReportTools.addElement(jetUUniverse, string, true);
        if (n == 0) {
            return 0;
        }
        int n2 = queryInfo.getDataResoureType();
        if (n2 == 0) {
            if (n == 1) {
                int n3 = ReportTools.addElement(jetUUniverse, string2, false);
                if (n3 == 17) {
                    return 33;
                }
                return n3;
            }
            return n;
        }
        int n4 = ReportTools.addElement(jetUUniverse, string2, false);
        if (n4 == 17) {
            if (n == 1) {
                return 33;
            }
            return n;
        }
        return n4;
    }

    private static int addElement(JetUUniverse jetUUniverse, String string, boolean bl) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return bl ? 1 : 17;
            }
        } else {
            return bl ? 1 : 17;
        }
        if (string.startsWith("[") && string.endsWith("]") && string.indexOf("][") > 0) {
            return bl ? 0 : 34;
        }
        if (bl) {
            return 2;
        }
        if (jetUUniverse != null && jetUUniverse.getAnyResourceByName(string) != null) {
            return 19;
        }
        return 18;
    }

    public static ColumnAttributes getSubLinkSubColumnAttributes(JetRptSubLink jetRptSubLink, JetUUniverse jetUUniverse, QueryInfo queryInfo, IReport iReport) throws JRScheduleException {
        String string = jetRptSubLink.sNSubColumn.toUpperCase();
        String string2 = jetRptSubLink.blSubColumn.get().toUpperCase();
        return ReportTools.getSubLinkColumnAttributes(string, string2, jetUUniverse, queryInfo, iReport);
    }

    public static ColumnAttributes getSubLinkColumnAttributes(String string, String string2, JetUUniverse jetUUniverse, QueryInfo queryInfo, IReport iReport) throws JRScheduleException {
        ColumnAttributes columnAttributes;
        int n = ReportTools.getValidColumnUseArgumentFlag(jetUUniverse, queryInfo, string, string2);
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                columnAttributes = new ColumnAttributes(string);
                break;
            }
            case 19: {
                columnAttributes = new ColumnAttributes(string2);
                break;
            }
            case 18: {
                DataSetLogic dataSetLogic = ObjectLogicFactory.getDataSetLogic();
                BLNode bLNode = dataSetLogic.getRefDataElementByBLQualifyName(jetUUniverse, iReport, queryInfo.getDatasourceName(), queryInfo.getQueryName(), queryInfo.getBLName(), queryInfo.getDataResoureType(), string2);
                String string3 = ((DataElementInfo)bLNode).getRefMappingName();
                columnAttributes = new ColumnAttributes(string2, string3);
                break;
            }
            default: {
                throw new JRScheduleException(220081);
            }
        }
        return columnAttributes;
    }

    public static boolean bindBusinessLogic(DataSet dataSet) {
        boolean bl = false;
        int n = dataSet.getDataResourceType();
        switch (n) {
            case 2: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static int getBusinessLogicTypeForRawQuery(DataSet dataSet) {
        int n = -1;
        int n2 = dataSet.getDataResourceType();
        switch (n2) {
            case 2: {
                n = 3;
                break;
            }
        }
        return n;
    }

    public static Vector getParamsOfIncrementalInfo(JetUUniverse jetUUniverse, JetRptReport jetRptReport, DataSet dataSet, String string, IncrementalInfo incrementalInfo) {
        Vector<String> vector = new Vector<String>();
        if (dataSet.getDataResourceType() == 2) {
            try {
                if (incrementalInfo != null) {
                    Vector vector2;
                    Object object;
                    JetUFormula jetUFormula;
                    String[] stringArray = ExpressionToolKit.getDependentParNames(incrementalInfo.getIncrementalCondition());
                    String[] stringArray2 = ExpressionToolKit.getDependentForNames(incrementalInfo.getIncrementalCondition());
                    String[] stringArray3 = ExpressionToolKit.getDependentRefNames(incrementalInfo.getIncrementalCondition());
                    if (JRLog.isTrace(6)) {
                        JRLog.trace(6, "ReportTools getParamsOfIncrementalInfo(ParNames :" + Tools.toString(stringArray) + ",fields: " + Tools.toString(stringArray2) + ", refs:" + Tools.toString(stringArray3) + ") ");
                    }
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            vector.add(stringArray[i]);
                        }
                    }
                    JetUResourceEntity jetUResourceEntity = null;
                    if (stringArray2 != null) {
                        jetUFormula = null;
                        for (int i = 0; i < stringArray2.length; ++i) {
                            jetUFormula = jetUUniverse.getDatabase(string).getFormulaByResourceName(stringArray2[i]);
                            HashVector hashVector = ReportTools.getRefUFmls(jetUUniverse, string, jetUFormula);
                            if (hashVector == null) continue;
                            object = hashVector.Elements();
                            while (object.hasMoreElements()) {
                                jetUFormula = (JetUFormula)object.nextElement();
                                vector2 = jetUFormula.getRefAllParamFld();
                                if (vector2 == null) continue;
                                for (int j = 0; j < vector2.size(); ++j) {
                                    jetUResourceEntity = jetUUniverse.getDatabase(string).getResourceByName((String)vector2.get(j));
                                    if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUParameter)) continue;
                                    vector.add(jetUResourceEntity.getResourceName());
                                }
                            }
                        }
                    }
                    if (stringArray3 != null) {
                        jetUFormula = null;
                        Scope scope = new Scope(jetUUniverse, jetRptReport, dataSet);
                        for (int i = 0; i < stringArray3.length; ++i) {
                            object = scope.getOnTheFlyFormulaByMappingName(stringArray3[i]);
                            if (object == null || (vector2 = ReportTools.getRefUFmls(jetUUniverse, string, jetUFormula = ((JetRptAbstractFormula)object).getJetUFormula())) == null) continue;
                            Enumeration enumeration = ((HashVector)vector2).Elements();
                            while (enumeration.hasMoreElements()) {
                                jetUFormula = (JetUFormula)enumeration.nextElement();
                                Vector vector3 = jetUFormula.getRefAllParamFld();
                                if (vector3 == null) continue;
                                for (int j = 0; j < vector3.size(); ++j) {
                                    jetUResourceEntity = jetUUniverse.getDatabase(string).getResourceByName((String)vector3.get(j));
                                    if (jetUResourceEntity == null || !(jetUResourceEntity instanceof JetUParameter)) continue;
                                    vector.add(jetUResourceEntity.getResourceName());
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public static JetAcl getEffectiveACL(DataSet dataSet, JetUUniverse jetUUniverse, ISecurityProvider iSecurityProvider) throws JSecurityEntryException {
        JetAcl jetAcl = dataSet.getAcl(jetUUniverse);
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getSecuName();
        JetAcl jetAcl2 = iSecurityProvider == null ? null : (string2 == null ? null : iSecurityProvider.getACL(string, string2));
        return ReportTools.overrideAcl(jetAcl, jetAcl2);
    }

    public static JetAcl overrideAcl(JetAcl jetAcl, JetAcl jetAcl2) {
        if (jetAcl2 == null) {
            return jetAcl;
        }
        if (jetAcl == null) {
            return jetAcl2;
        }
        JetAcl jetAcl3 = jetAcl2.copy();
        JetAcl jetAcl4 = jetAcl.copy();
        jetAcl4.setRLSValid(jetAcl4.isValidRLS());
        jetAcl4.setCLSValid(jetAcl3.isValidCLS());
        Vector vector = jetAcl3.getPincipals();
        if (vector == null || vector.isEmpty()) {
            return jetAcl4;
        }
        for (JetPrincipal jetPrincipal : vector) {
            JetObject jetObject;
            JetAclEntry jetAclEntry = jetAcl4.getAclEntry(jetPrincipal);
            if (jetAclEntry != null && (jetObject = jetAclEntry.getPrincipal()).getSourceType() != jetPrincipal.getSourceType()) {
                ReportTools.addReport(jetAcl4, jetObject, true);
                jetAclEntry = null;
            }
            if (jetAclEntry == null) {
                jetAcl4.add(jetAcl3.getAclEntry(jetPrincipal));
                continue;
            }
            jetObject = jetAcl3.getAclEntry(jetPrincipal);
            ReportTools.addPermission(jetAclEntry, (JetAclEntry)jetObject, 1);
            ReportTools.addPermission(jetAclEntry, (JetAclEntry)jetObject, 2);
        }
        jetAcl4.afterInit();
        return jetAcl4;
    }

    private static void addPermission(JetAclEntry jetAclEntry, JetAclEntry jetAclEntry2, int n) {
        Vector vector = jetAclEntry2.getPermissions();
        _PermissionContainer _PermissionContainer2 = new _PermissionContainer(vector);
        if (_PermissionContainer2.SEDU(n)) {
            Vector vector2 = jetAclEntry.getPermissions();
            _PermissionContainer _PermissionContainer3 = new _PermissionContainer(vector2);
            List list = _PermissionContainer3.add(n);
            for (JetPermission jetPermission : list) {
                jetAclEntry.removePermission(jetPermission);
            }
            list = _PermissionContainer2.add(n);
            for (JetPermission jetPermission : list) {
                jetAclEntry.addPermission(jetPermission);
            }
        }
    }

    private static void addReport(JetAcl jetAcl, JetPrincipal jetPrincipal, boolean bl) {
        if (jetPrincipal instanceof JetUser) {
            jetAcl.deleteUser(((JetUser)jetPrincipal).getName(), bl);
        } else if (jetPrincipal instanceof JetRole) {
            jetAcl.deleteRole(((JetRole)jetPrincipal).getName(), bl);
        } else if (jetPrincipal instanceof JetGroup) {
            jetAcl.deleteGroup(((JetGroup)jetPrincipal).getName(), bl);
        }
    }

    static {
        Background.addElement(JetRptSectionObject.class.getName());
        Background.addElement(JetRptNewTable.class.getName());
        Background.addElement(JetRptCTCrossTab.class.getName());
        Background.addElement(JetRptChartPlatform.class.getName());
        Background.addElement(JetRptGMap.class.getName());
        Background.addElement(JetRptGeoMap.class.getName());
        BorderColor = new Vector();
        BorderColor.addElement(JetRptSectionObject.class.getName());
        BorderColor.addElement(JetRptNewTable.class.getName());
        BorderColor.addElement(JetRptChartPlatform.class.getName());
        BorderColor.addElement(JetRptGMap.class.getName());
        BorderColor.addElement(JetRptGeoMap.class.getName());
        RuntimeColName_DELIMITER = "@_@";
    }

    private static class _PermissionContainer {
        private List SEDU;

        private _PermissionContainer(List list) {
            this.SEDU = list == null ? new ArrayList() : list;
        }

        private boolean SEDU(int n) {
            for (JetPermission jetPermission : this.SEDU) {
                if (jetPermission.getType() != n || !jetPermission.isHavePolicy()) continue;
                return true;
            }
            return false;
        }

        private List add(int n) {
            ArrayList<JetPermission> arrayList = new ArrayList<JetPermission>();
            for (JetPermission jetPermission : this.SEDU) {
                if (jetPermission.getType() != n) continue;
                arrayList.add(jetPermission);
            }
            return arrayList;
        }
    }

    private static class DrillFilterImpl
    implements IDrillFilter {
        private String SEDU;
        private String equalsIgnoreCase;

        private DrillFilterImpl(String string, String string2) {
            this.SEDU = string;
            this.equalsIgnoreCase = string2;
        }

        private DrillFilterImpl(IBinaryConditionExpression iBinaryConditionExpression, JetUUniverse jetUUniverse, DataSet dataSet) throws ConditionException {
            IExpression iExpression;
            IExpression iExpression2 = iBinaryConditionExpression.getExpression1();
            IExpression iExpression3 = iBinaryConditionExpression.getExpression2();
            int n = iExpression2.expressionType();
            if (!ExpressionToolKit.isReference(n)) {
                iExpression = iExpression2;
                iExpression2 = iExpression3;
                iExpression3 = iExpression;
            }
            n = iExpression2.expressionType();
            iExpression = (IReference)iExpression2;
            if (iExpression.isQualifyName()) {
                this.SEDU = iExpression.getName();
            } else {
                String string = iExpression.getName();
                this.SEDU = this.SEDU(string, jetUUniverse, dataSet);
                if (this.SEDU == null) {
                    throw new ConditionException(103020, new String[]{string});
                }
            }
            this.equalsIgnoreCase = ((IConstant)iExpression3).getValue();
        }

        private DrillFilterImpl(ISingleConditionExpression iSingleConditionExpression, JetUUniverse jetUUniverse, DataSet dataSet) throws ConditionException {
            IExpression iExpression = iSingleConditionExpression.getExpression();
            int n = iExpression.expressionType();
            IReference iReference = (IReference)iExpression;
            if (iReference.isQualifyName()) {
                this.SEDU = iReference.getName();
            } else {
                String string = iReference.getName();
                this.SEDU = this.SEDU(string, jetUUniverse, dataSet);
                if (this.SEDU == null) {
                    throw new ConditionException(103020, new String[]{string});
                }
            }
            this.equalsIgnoreCase = null;
        }

        @Override
        public String getResourceName() {
            return this.SEDU;
        }

        @Override
        public String getValue() {
            return this.equalsIgnoreCase;
        }

        private String SEDU(String string, JetUUniverse jetUUniverse, DataSet dataSet) {
            DimensionInfo[] dimensionInfoArray;
            if (dataSet.getDataResourceType() != 2) {
                return null;
            }
            UnifiedBusinessView unifiedBusinessView = jetUUniverse.getBV(dataSet.getDataSourceName(), dataSet.getBlName());
            String string2 = null;
            if (unifiedBusinessView != null && (dimensionInfoArray = unifiedBusinessView.getDimensions()) != null && dimensionInfoArray.length > 0) {
                for (int i = 0; i < dimensionInfoArray.length; ++i) {
                    if (!string.equalsIgnoreCase(dimensionInfoArray[i].getRefMappingName())) continue;
                    string2 = dimensionInfoArray[i].getQualifyDisplayName();
                    break;
                }
            }
            return string2;
        }
    }

    private static final class GoToComponentInfo {
        private JetRptObject SEDU = null;
        private Vector access$400 = new Vector();
        private TreeIterater getAllPosterityComponentByClass = null;

        private GoToComponentInfo(JetRptReport jetRptReport, String string) {
            JetObject jetObject = this.SEDU = (JetRptObject)ReportTools.access$300(jetRptReport, string);
            if (!(jetObject instanceof JetRptSectionObject) && !(jetObject instanceof JetRptNewTable)) {
                while (jetObject != null && !((jetObject = (JetObject)((Object)jetObject.getParent())) instanceof JetRptSectionObject) || jetObject instanceof JetRptNewTable) {
                }
            }
            this.SEDU(this.access$400, this.SEDU);
            this.getAllPosterityComponentByClass = new TreeIterater(jetObject, false);
        }

        private void SEDU(Vector vector, JetObject jetObject) {
            ObjectLogicFactory.getBasicComponentLogic().getAllPosterityComponentByClass(jetObject, JetRptSection.class, (List)vector);
        }
    }
}

