/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.List;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.reportset.DataSet;
import jet.rptengine.JSubLinkContainer;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.pub.KeyDataSourceQuery;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUUniverse;
import jet.util.DbValueComparer;
import jet.util.ScheduleTools;

public class SubLinkProcessor {
    private Hashtable SEDU;

    public SubLinkProcessor(Hashtable hashtable) {
        this.SEDU = hashtable;
    }

    public IBooleanExpression getExpression(JSubLinkContainer jSubLinkContainer, JetUUniverse jetUUniverse) throws JRScheduleException, ConditionException {
        List list;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "SubLinkProcessor.getExpression()..., processor: " + this.toString());
        }
        if ((list = jSubLinkContainer.getSubLinks()) == null) {
            if (JRLog.isTrace(6)) {
                JRLog.trace(6, "list get from subLinkContainer is null, return null");
            }
            return null;
        }
        IBooleanExpression iBooleanExpression = null;
        DataSet dataSet = jSubLinkContainer.getDataSet();
        String string = dataSet.getDataSourceName();
        String string2 = dataSet.getQueryName();
        KeyDataSourceQuery keyDataSourceQuery = ScheduleTools.getAvailableKeyDataSourceQuery(dataSet.getQueryInfo(), jetUUniverse);
        if (keyDataSourceQuery != null) {
            string2 = keyDataSourceQuery.getQueryName();
        }
        for (int i = 0; i < list.size(); ++i) {
            DbValueComparer dbValueComparer = (DbValueComparer)list.get(i);
            String string3 = dbValueComparer.getColumnName().toUpperCase();
            if (this.SEDU != null && this.SEDU.containsKey(string3)) continue;
            IBooleanExpression iBooleanExpression2 = ReportTools.getExpression(dbValueComparer, jetUUniverse, string, string2);
            iBooleanExpression = ReportTools.getAndExpression(iBooleanExpression, iBooleanExpression2);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "End of SubLinkProcessor.getExpression()... return: " + iBooleanExpression);
        }
        return iBooleanExpression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@" + this.hashCode());
        stringBuffer.append(", parameterBuffer: ");
        stringBuffer.append(this.SEDU == null ? "null" : this.SEDU.toString());
        return stringBuffer.toString();
    }
}

