/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.report.JetRptReportBody;
import jet.report.JetRptSection;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubReport;
import jet.report.tabular.JetRptTabular;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.engine.infocenter.ReportViewCenter;
import jet.rptservice.engine.infocenter.SubReportInfo;
import jet.rptservice.engine.infocenter.SubRptShareInfo;
import jet.rptservice.engine.infocenter.SubRptShareInfoSet;

public class SubRptShareTool {
    public void initSubRptShareInfo(JetRptReport jetRptReport, ReportViewCenter reportViewCenter) {
        SubRptShareInfoSet subRptShareInfoSet = this.SEDU(jetRptReport, reportViewCenter);
        if (subRptShareInfoSet == null) {
            return;
        }
        SubRptShareInfo[] subRptShareInfoArray = subRptShareInfoSet.getAllSubRptShareInfos();
        for (int i = 0; i < subRptShareInfoArray.length; ++i) {
            int n = subRptShareInfoArray[i].getSubRptKey();
            SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n);
            subReportInfo.setShare(true);
        }
    }

    private SubRptShareInfoSet SEDU(JetRptReport jetRptReport, ReportViewCenter reportViewCenter) {
        JetRptReportBody jetRptReportBody = this.getChildren(jetRptReport);
        if (jetRptReportBody == null) {
            return null;
        }
        List list = this.addSubRptShareInfo(jetRptReportBody, reportViewCenter);
        SubRptShareInfoSet subRptShareInfoSet = this.getPrincipal(list);
        subRptShareInfoSet.removePseudShareInfos();
        return subRptShareInfoSet;
    }

    private SubRptShareInfoSet add(JetContainable jetContainable, ReportViewCenter reportViewCenter) {
        if (jetContainable instanceof JetRptSectionObject) {
            JetRptSectionObject jetRptSectionObject = (JetRptSectionObject)jetContainable;
            return this.booleanValue(jetRptSectionObject, reportViewCenter);
        }
        if (jetContainable instanceof JetRptSubReport) {
            JetRptSubReport jetRptSubReport = (JetRptSubReport)jetContainable;
            int n = jetRptSubReport.hashCode();
            SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n);
            if (subReportInfo == null) {
                return new SubRptShareInfoSet();
            }
            String string = subReportInfo.getSubRptSetName();
            String string2 = subReportInfo.getSubRptName();
            SubRptShareInfo subRptShareInfo = new SubRptShareInfo(n, string, string2);
            SubRptShareInfoSet subRptShareInfoSet = this.get(jetRptSubReport, reportViewCenter);
            subRptShareInfoSet.addSubRptShareInfo(subRptShareInfo);
            return subRptShareInfoSet;
        }
        if (jetContainable instanceof JetRptTabular) {
            return new SubRptShareInfoSet();
        }
        List list = this.addSubRptShareInfo(jetContainable, reportViewCenter);
        SubRptShareInfoSet subRptShareInfoSet = this.getPrincipal(list);
        subRptShareInfoSet.removePseudShareInfos();
        return subRptShareInfoSet;
    }

    private List addSubRptShareInfo(JetContainable jetContainable, ReportViewCenter reportViewCenter) {
        Vector vector = jetContainable.getChildren();
        int n = vector == null ? 0 : vector.size();
        ArrayList<SubRptShareInfoSet> arrayList = new ArrayList<SubRptShareInfoSet>();
        for (int i = 0; i < n; ++i) {
            JetContainable jetContainable2;
            SubRptShareInfoSet subRptShareInfoSet;
            Object e = vector.get(i);
            if (!(e instanceof JetContainable) || (subRptShareInfoSet = this.add(jetContainable2 = (JetContainable)e, reportViewCenter)).isEmpty()) continue;
            arrayList.add(subRptShareInfoSet);
        }
        return arrayList;
    }

    private SubRptShareInfoSet booleanValue(JetRptSectionObject jetRptSectionObject, ReportViewCenter reportViewCenter) {
        Vector vector = jetRptSectionObject.getSections();
        ArrayList<SubRptShareInfoSet> arrayList = new ArrayList<SubRptShareInfoSet>();
        int n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            JetRptSection jetRptSection = (JetRptSection)vector.get(i);
            SubRptShareInfoSet subRptShareInfoSet = null;
            if (jetRptSection == null || jetRptSection.underlay.isChangeByOther() || jetRptSection.underlay.booleanValue() || (subRptShareInfoSet = this.add(jetRptSection, reportViewCenter)) == null || subRptShareInfoSet.isEmpty()) continue;
            arrayList.add(subRptShareInfoSet);
        }
        SubRptShareInfoSet subRptShareInfoSet = this.getReportView(arrayList);
        return subRptShareInfoSet;
    }

    private SubRptShareInfoSet get(JetRptSubReport jetRptSubReport, ReportViewCenter reportViewCenter) {
        JetRptReport jetRptReport = this.getAllSubRptShareInfos(jetRptSubReport, reportViewCenter);
        return this.SEDU(jetRptReport, reportViewCenter);
    }

    private JetRptReport getAllSubRptShareInfos(JetRptSubReport jetRptSubReport, ReportViewCenter reportViewCenter) {
        int n = jetRptSubReport.hashCode();
        SubReportInfo subReportInfo = reportViewCenter.getSubRptInfo(n);
        JetRptReportSet jetRptReportSet = (JetRptReportSet)subReportInfo.getRptSetAttributes().getPrincipal();
        String string = subReportInfo.getSubRptName();
        String string2 = subReportInfo.getSubRptViewName();
        return jetRptReportSet.getReportView(string, string2);
    }

    private JetRptReportBody getChildren(JetRptReport jetRptReport) {
        Vector vector = jetRptReport.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof JetRptReportBody)) continue;
            return (JetRptReportBody)e;
        }
        return null;
    }

    private SubRptShareInfoSet getPrincipal(List list) {
        if (list.isEmpty()) {
            return new SubRptShareInfoSet();
        }
        SubRptShareInfoSet subRptShareInfoSet = (SubRptShareInfoSet)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            SubRptShareInfoSet subRptShareInfoSet2 = (SubRptShareInfoSet)list.get(i);
            subRptShareInfoSet = subRptShareInfoSet.uniteInABand(subRptShareInfoSet2);
        }
        return subRptShareInfoSet;
    }

    private SubRptShareInfoSet getReportView(List list) {
        if (list.isEmpty()) {
            return new SubRptShareInfoSet();
        }
        SubRptShareInfoSet subRptShareInfoSet = (SubRptShareInfoSet)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            SubRptShareInfoSet subRptShareInfoSet2 = (SubRptShareInfoSet)list.get(i);
            subRptShareInfoSet = subRptShareInfoSet.unitAmongBands(subRptShareInfoSet2);
        }
        return subRptShareInfoSet;
    }
}

