/*
 * Decompiled with CFR 0.152.
 */
package jet.security;

import java.awt.Rectangle;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.ZipToolkit;
import jet.ie.io.PJFDataOutput;

public class DataStreamFilter
extends DataStream {
    private DataStream GZip;
    private int[] SEDU;

    public DataStreamFilter(Communicator communicator, DataStream dataStream, int[] nArray) {
        super(communicator);
        this.GZip = dataStream;
        this.SEDU = nArray;
    }

    @Override
    public DSPage getPage(int n) throws IOException, JRStopEngineException {
        if (n > 0 && n <= this.SEDU.length) {
            return this.GZip.getPage(this.SEDU[n - 1]);
        }
        return null;
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, Communicator communicator) throws JRStopEngineException, IOException {
        return this.saveTo(pJFDataOutput, communicator, false);
    }

    public long[] saveTo(PJFDataOutput pJFDataOutput, Communicator communicator, boolean bl) throws JRStopEngineException, IOException {
        int n = communicator.getPageNum();
        long[] lArray = new long[n];
        if (lArray.length > 0) {
            lArray[0] = pJFDataOutput.getPosition();
        }
        for (int i = 1; i <= n; ++i) {
            DSPage dSPage = communicator.getPage(i);
            RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage.length());
            dSPage.write(new PJFDataOutput(randomByteArrayOutputStream));
            byte[] byArray = randomByteArrayOutputStream.toByteArray();
            if (bl) {
                byArray = ZipToolkit.GZip(byArray);
            }
            pJFDataOutput.write(byArray);
            if (i != n) {
                lArray[i] = lArray[i - 1] + (long)byArray.length;
            }
            randomByteArrayOutputStream.close();
        }
        return lArray;
    }

    @Override
    public boolean isEngineFinished() {
        return this.GZip.isEngineFinished();
    }

    @Override
    public Rectangle getPageArea() {
        return this.GZip.getPageArea();
    }

    @Override
    public Rectangle getPrintableArea() {
        return this.GZip.getPrintableArea();
    }

    @Override
    public int ie() {
        return this.GZip.ie();
    }

    @Override
    public Long getPageEntry(int n) {
        return this.GZip.getPageEntry(this.SEDU[n - 1]);
    }

    @Override
    public void clearMem() {
        this.GZip.clearMem();
    }

    @Override
    public void sort(DSSection dSSection, DbValue dbValue, boolean bl) throws JRStopEngineException {
        this.GZip.sort(dSSection, dbValue, bl);
    }
}

