/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.swingviewer.MouseWheelHandler;
import jet.thinviewer.JReportViewer;

public class DesignerViewerPane
extends JPanel
implements AdjustmentListener,
MouseListener {
    private final int SEDU = 1;
    private final int add = 3;
    private final int addAdjustmentListener = 4;
    private final int convertUnitToPixel = 5;
    private final int firstViewReport = 5;
    protected JViewport viewPort = new JViewport();
    protected JReportViewer viewer;
    protected Communicator communicator;
    private JPanel getCurrentPage = new JPanel();
    private Rectangle getPageArea;
    JScrollBar vsb;
    JScrollBar hsb;
    int totalPage = 0;
    int curPage = 0;
    boolean mouseIn = true;

    public DesignerViewerPane(Communicator communicator, boolean bl) {
        this.setLayout(new ViewerLayout());
        this.vsb = new JScrollBar(1);
        this.hsb = new JScrollBar(0);
        this.communicator = communicator;
        this.run(bl);
    }

    public void run(boolean bl) {
        this.viewer = new JReportViewer(this.communicator){

            @Override
            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                for (int i = 0; i < 1; ++i) {
                    graphics.drawRect(i, i, dimension.width - 4 - 2 - i * 2, dimension.height - 4 - 2 - i * 2);
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }

            @Override
            public void setLocation(int n, int n2) {
                if (DesignerViewerPane.this.mouseIn) {
                    super.setLocation(n, n2);
                }
            }
        };
        this.viewer.setIsApplet(bl);
        int n = 100;
        this.setZoom(n);
        this.setBackground(Color.gray);
        this.getCurrentPage.setLayout(null);
        this.getCurrentPage.setBackground(Color.gray);
        this.getCurrentPage.add(this.viewPort);
        this.add(this.getCurrentPage);
        this.add(this.vsb);
        this.add(this.hsb);
        this.addMouseWheelListener(new MouseWheelHandler(this.vsb));
        this.addMouseWheelListener(new MouseWheelHandler(this.hsb));
        this.validate();
        this.viewer.firstViewReport(0, 0, this.getPageArea.width, this.getPageArea.height);
        this.vsb.addAdjustmentListener(this);
        this.hsb.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.hsb) {
            this.mouseIn = true;
            Point point = this.viewPort.getViewPosition();
            point.x = this.hsb.getValue();
            this.viewPort.setViewPosition(point);
            point = this.viewPort.getViewPosition();
            this.mouseIn = false;
        } else if (object == this.vsb) {
            if (!this.vsb.isVisible()) {
                return;
            }
            this.mouseIn = true;
            Point point = this.viewPort.getViewPosition();
            point.y = this.vsb.getValue();
            this.viewPort.setViewPosition(point);
            point = this.viewPort.getViewPosition();
            this.mouseIn = false;
        }
    }

    public void setZoom(int n) {
        if (this.communicator != null) {
            int n2 = (int)((double)Unit.getResolution() * ((double)n / 100.0));
            this.communicator.setResolution(n2);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            CommEnumeration commEnumeration = new CommEnumeration(this.communicator);
            Rectangle rectangle = null;
            if (commEnumeration.hasMoreElements()) {
                DSPage dSPage = (DSPage)commEnumeration.nextElement();
                rectangle = dSPage.getPageArea();
                this.getPageArea = new Rectangle(rectangle.x, rectangle.y, 0, 0);
            }
            this.getPageArea.width = Unit.convertUnitToPixel(rectangle.width, n2) + 2 + 4;
            this.getPageArea.height = Unit.convertUnitToPixel(rectangle.height, n2) + 2 + 4;
            this.viewer.setSize(this.getPageArea.width, this.getPageArea.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, this.getPageArea.width, this.getPageArea.height);
            this.viewPort.setBackground(Color.gray);
            this.vsb.setValue(0);
            this.hsb.setValue(0);
        }
    }

    public void _setZoom() {
        if (this.communicator != null) {
            int n = Unit.getResolution();
            this.communicator.setResolution(n);
            this.viewer.setUsingThread(false);
            this.viewer.setDataStream(null);
            this.getPageArea = this.viewer.getCurrentPage().getPageArea();
            Rectangle rectangle = new Rectangle(this.getPageArea.x, this.getPageArea.y, this.getPageArea.width, this.getPageArea.height);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n) + 2 + 4;
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n) + 2 + 4;
            this.viewer.setSize(rectangle.width, rectangle.height);
            this.viewPort.setView(this.viewer);
            this.viewPort.setBounds(5, 5, rectangle.width, rectangle.height);
            this.viewPort.setBackground(Color.gray);
            this.vsb.setValue(0);
            this.hsb.setValue(0);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIn = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseIn = false;
    }

    class ViewerLayout
    implements LayoutManager {
        ViewerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Dimension dimension2 = DesignerViewerPane.this.viewer.getSize();
            int n2 = DesignerViewerPane.this.vsb.getPreferredSize().width;
            int n3 = DesignerViewerPane.this.hsb.getPreferredSize().height;
            if (dimension.width >= dimension2.width + 10 && dimension.height >= dimension2.height + 10) {
                DesignerViewerPane.this.hsb.setVisible(false);
                DesignerViewerPane.this.vsb.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < dimension2.width + 10) {
                    if (!DesignerViewerPane.this.hsb.isVisible()) {
                        DesignerViewerPane.this.hsb.setVisible(true);
                    }
                    if (dimension.height >= dimension2.height + 10 + n3) {
                        n2 = 0;
                        DesignerViewerPane.this.vsb.setVisible(false);
                    } else if (!DesignerViewerPane.this.vsb.isVisible()) {
                        DesignerViewerPane.this.vsb.setVisible(true);
                    }
                }
                if (dimension.height < dimension2.height + 10) {
                    if (!DesignerViewerPane.this.vsb.isVisible()) {
                        DesignerViewerPane.this.vsb.setVisible(true);
                    }
                    if (dimension.width >= dimension2.width + 10 + n2) {
                        n3 = 0;
                        DesignerViewerPane.this.hsb.setVisible(false);
                    } else if (!DesignerViewerPane.this.hsb.isVisible()) {
                        DesignerViewerPane.this.hsb.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            DesignerViewerPane.this.getCurrentPage.setBounds(0, 0, n4, n5);
            if (DesignerViewerPane.this.vsb.isVisible()) {
                n = Math.min(DesignerViewerPane.this.vsb.getValue(), dimension2.height + 10 + n3 - dimension.height);
                DesignerViewerPane.this.vsb.setBounds(n4, 0, n2, n5);
                DesignerViewerPane.this.vsb.setValue(n);
                DesignerViewerPane.this.vsb.setMaximum(dimension2.height + 10);
                DesignerViewerPane.this.vsb.setVisibleAmount(n5);
                DesignerViewerPane.this.vsb.setBlockIncrement(n5);
                DesignerViewerPane.this.vsb.setUnitIncrement(n5 / 10);
            }
            if (DesignerViewerPane.this.hsb.isVisible()) {
                n = Math.min(DesignerViewerPane.this.hsb.getValue(), dimension2.width + 10 + n2 - dimension.width);
                DesignerViewerPane.this.hsb.setBounds(0, n5, n4, n3);
                DesignerViewerPane.this.hsb.setValue(n);
                DesignerViewerPane.this.hsb.setMaximum(dimension2.width + 10);
                DesignerViewerPane.this.hsb.setVisibleAmount(n4);
                DesignerViewerPane.this.hsb.setBlockIncrement(n4);
                DesignerViewerPane.this.hsb.setUnitIncrement(n4 / 10);
            }
            Point point = DesignerViewerPane.this.viewPort.getViewPosition();
            if (point.x != DesignerViewerPane.this.hsb.getValue()) {
                point.x = DesignerViewerPane.this.hsb.getValue();
                DesignerViewerPane.this.viewPort.setViewPosition(point);
            }
            if (point.y != DesignerViewerPane.this.vsb.getValue()) {
                point.y = DesignerViewerPane.this.vsb.getValue();
                DesignerViewerPane.this.viewPort.setViewPosition(point);
            }
        }
    }
}

