/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.toolkit.TPaintBoard;
import guitools.toolkit.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.thinviewer.JReportDrillDownViewer;
import jet.thinviewer.viewerSizeChangedListener;

public class DrillDownView
extends JFrame
implements viewerSizeChangedListener {
    private static final int SEDU = 1;
    private static final int add = 3;
    private static final int addAdjustmentListener = 4;
    int HGAP = 5;
    int VGAP = 5;
    protected ImageIcon titleImage = null;
    Communicator communicator;
    private DataStream changeContentsSize;
    private String convertUnitToPixel;
    Timer timer = null;
    JPanel sheet;
    JScrollBar vsb = new JScrollBar(1);
    JScrollBar hsb = new JScrollBar(0);
    DSPage dspage;
    protected JReportDrillDownViewer drillDownViewer;
    TPaintBoard painter = new TPaintBoard();
    boolean bInApplet;
    boolean isFinished = false;
    Scroller scroller;
    Dimension viewerSize;

    public DrillDownView(Communicator communicator, DataStream dataStream, DSPage dSPage, String string, boolean bl) {
        super(string);
        this.communicator = communicator;
        this.changeContentsSize = dataStream;
        this.dspage = dSPage;
        this.convertUnitToPixel = string;
        this.bInApplet = bl;
        this.setBounds(20, 20, 800, 400);
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void setViewer(JReportDrillDownViewer jReportDrillDownViewer) {
        this.drillDownViewer = jReportDrillDownViewer;
        jReportDrillDownViewer.setLocation(this.HGAP, this.VGAP);
    }

    public JReportDrillDownViewer getDrillDownViwer() {
        this.initViewer(this.dspage, this.convertUnitToPixel, this.changeContentsSize);
        return this.drillDownViewer;
    }

    public void initViewer(DSPage dSPage, String string, DataStream dataStream) {
        this.drillDownViewer = new JReportDrillDownViewer(dataStream, string){

            @Override
            public Insets getInsets() {
                return new Insets(1, 1, 5, 5);
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                Dimension dimension = this.getSize();
                graphics.setColor(Color.black);
                for (int i = 0; i < 1; ++i) {
                    graphics.drawRect(i, i, dimension.width - 4 - 2 - i * 2, dimension.height - 4 - 2 - i * 2);
                }
                graphics.setColor(Color.black);
                graphics.fillRect(3, dimension.height - 4 - 1, dimension.width - 3 - 1, 4);
                graphics.fillRect(dimension.width - 4 - 1, 3, 4, dimension.height - 3 - 1);
            }
        };
        this.drillDownViewer.setCurPage(dSPage);
        Rectangle rectangle = dataStream.getPageArea();
        this.drillDownViewer.setBounds(0, 0, rectangle.width, rectangle.height);
        this.viewerSize = new Dimension(rectangle.width / 10, rectangle.height / 10);
        this.painter.add(this.drillDownViewer);
        this.painter.setBackground(Color.gray);
        this.scroller = new Scroller();
        this.hsb.addAdjustmentListener(this.scroller);
        this.vsb.addAdjustmentListener(this.scroller);
        this.sheet = new JPanel();
        this.sheet.add((Component)this.painter, "Center");
        this.sheet.add((Component)this.vsb, "East");
        this.sheet.add((Component)this.hsb, "South");
        this.sheet.setBackground(Color.gray);
        Rectangle rectangle2 = this.drillDownViewer.getViewerArea();
        this.painter.add(this.drillDownViewer);
        this.painter.setBackground(Color.gray);
        this.getContentPane().add(this.sheet);
        this.drillDownViewer.runThread();
        this.sheet.setBounds(5, 5, rectangle2.width, rectangle2.height);
        this.sheet.setLayout(new ViewerLayout());
        this.sheet.setBounds(15, 15, rectangle2.width, rectangle2.height);
        this.show();
        this.startTime();
    }

    public Communicator getCommunicator() {
        return this.communicator;
    }

    public void refresh() {
        int n = this.communicator.getResolution();
        try {
            DataStream dataStream = (DataStream)this.communicator.getDataStream(0);
            Rectangle rectangle = dataStream.getPageArea();
            rectangle.x = Unit.convertUnitToPixel(rectangle.x, n);
            rectangle.y = Unit.convertUnitToPixel(rectangle.y, n);
            rectangle.width = Unit.convertUnitToPixel(rectangle.width, n);
            rectangle.height = Unit.convertUnitToPixel(rectangle.height, n);
        }
        catch (JRStopEngineException jRStopEngineException) {
            jRStopEngineException.printStackTrace();
        }
    }

    public boolean setTitleImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.titleImage = imageIcon;
            this.setIconImage(imageIcon.getImage());
            return true;
        }
        return false;
    }

    public void setCommunicator(Communicator communicator) {
        this.communicator = communicator;
    }

    public void setDataStream(DataStream dataStream) {
        this.changeContentsSize = dataStream;
    }

    public void setGroupBy(String string) {
        this.convertUnitToPixel = string;
    }

    @Override
    public void setScrollPosition(int n, int n2) {
        this.hsb.setValue(n);
        this.vsb.setValue(n2);
    }

    @Override
    public void viewerSizeChanged(Dimension dimension) {
        this.invalidate();
        this.validate();
    }

    @Override
    public void changeContentsSize() {
        this.hsb.setMaximumSize(new Dimension((int)this.drillDownViewer.getSize().getWidth(), 25));
        this.vsb.setMaximumSize(new Dimension(25, (int)this.drillDownViewer.getSize().getHeight()));
    }

    @Override
    public void scrolls(int n, int n2) {
        this.hsb.setValue(n);
        this.vsb.setValue(n2);
        this.changeContentsSize();
    }

    @Override
    public int[] getScrollPosition() {
        int[] nArray = new int[]{this.hsb.getValue(), this.vsb.getValue()};
        return nArray;
    }

    private synchronized void startTime() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrillDownView.this.isFinished = DrillDownView.this.communicator.isEngineFinished();
                if (DrillDownView.this.timer != null) {
                    DrillDownView.this.viewerSize = DrillDownView.this.drillDownViewer.getSize();
                    DrillDownView.this.vsb.setMaximum(DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP);
                    DrillDownView.this.hsb.setMaximum(DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP);
                    DrillDownView.this.drillDownViewer.reload();
                    DrillDownView.this.timer.stop();
                    DrillDownView.this.timer = null;
                }
            }
        });
        this.timer.start();
    }

    class ViewerLayout
    implements LayoutManager {
        ViewerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            if (DrillDownView.this.isFinished) {
                DrillDownView.this.viewerSize = DrillDownView.this.drillDownViewer.getSize().height != 67351 ? DrillDownView.this.drillDownViewer.getSize() : DrillDownView.this.drillDownViewer.getSize();
            }
            DrillDownView.this.isFinished = true;
            Point point = DrillDownView.this.drillDownViewer.getLocation();
            int n2 = DrillDownView.this.vsb.getPreferredSize().width;
            int n3 = DrillDownView.this.hsb.getPreferredSize().height;
            if (dimension.width >= DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP && dimension.height >= DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP) {
                DrillDownView.this.hsb.setVisible(false);
                DrillDownView.this.vsb.setVisible(false);
                n2 = 0;
                n3 = 0;
            } else {
                if (dimension.width < DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP) {
                    if (!DrillDownView.this.hsb.isVisible()) {
                        point.x = DrillDownView.this.HGAP;
                        DrillDownView.this.hsb.setVisible(true);
                    }
                    if (dimension.height >= DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP + n3) {
                        n2 = 0;
                        DrillDownView.this.vsb.setVisible(false);
                    } else if (!DrillDownView.this.vsb.isVisible()) {
                        point.y = DrillDownView.this.VGAP;
                        DrillDownView.this.vsb.setVisible(true);
                    }
                }
                if (dimension.height < DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP) {
                    if (!DrillDownView.this.vsb.isVisible()) {
                        point.y = DrillDownView.this.VGAP;
                        DrillDownView.this.vsb.setVisible(true);
                    }
                    if (dimension.width >= DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP + n2) {
                        n3 = 0;
                        DrillDownView.this.hsb.setVisible(false);
                    } else if (!DrillDownView.this.hsb.isVisible()) {
                        point.x = DrillDownView.this.HGAP;
                        DrillDownView.this.hsb.setVisible(true);
                    }
                }
            }
            int n4 = dimension.width - n2;
            int n5 = dimension.height - n3;
            DrillDownView.this.hsb.setMaximumSize(new Dimension((int)DrillDownView.this.drillDownViewer.getSize().getWidth(), 25));
            DrillDownView.this.vsb.setMaximumSize(new Dimension(25, (int)DrillDownView.this.drillDownViewer.getSize().getHeight()));
            DrillDownView.this.painter.setBounds(0, 0, n4, n5);
            if (DrillDownView.this.vsb.isVisible()) {
                n = Math.min(DrillDownView.this.vsb.getValue(), DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP + n3 - dimension.height);
                point.y = DrillDownView.this.VGAP - n;
                DrillDownView.this.vsb.setBounds(n4, 0, n2, n5);
                DrillDownView.this.vsb.setValue(n);
                DrillDownView.this.vsb.setMaximum(DrillDownView.this.viewerSize.height + 2 * DrillDownView.this.VGAP);
                DrillDownView.this.vsb.setVisibleAmount(n5);
                DrillDownView.this.vsb.setBlockIncrement(n5);
                DrillDownView.this.vsb.setUnitIncrement(n5 / 10);
            } else {
                point.y = (dimension.height - DrillDownView.this.viewerSize.height - n3) / 2;
            }
            if (DrillDownView.this.hsb.isVisible()) {
                n = Math.min(DrillDownView.this.hsb.getValue(), DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP + n2 - dimension.width);
                point.x = DrillDownView.this.HGAP - n;
                DrillDownView.this.hsb.setBounds(0, n5, n4, n3);
                DrillDownView.this.hsb.setValue(n);
                DrillDownView.this.hsb.setMaximum(DrillDownView.this.viewerSize.width + 2 * DrillDownView.this.HGAP);
                DrillDownView.this.hsb.setVisibleAmount(n4);
                DrillDownView.this.hsb.setBlockIncrement(n4);
                DrillDownView.this.hsb.setUnitIncrement(n4 / 10);
            } else {
                point.x = (dimension.width - DrillDownView.this.viewerSize.width - n2) / 2;
            }
            if (!DrillDownView.this.drillDownViewer.getLocation().equals(point)) {
                DrillDownView.this.painter.scrolls(point.x - DrillDownView.this.HGAP, point.y - DrillDownView.this.VGAP);
            }
            DrillDownView.this.painter.unlockUpdate();
        }
    }

    class Scroller
    implements AdjustmentListener {
        Scroller() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Dimension dimension = DrillDownView.this.drillDownViewer.getSize();
            Point point = DrillDownView.this.painter.getClientAreaOffsets();
            int n = DrillDownView.this.hsb.isVisible() ? Math.min(DrillDownView.this.hsb.getValue(), dimension.width + 2 * DrillDownView.this.HGAP) : -point.x;
            int n2 = DrillDownView.this.vsb.isVisible() ? Math.min(DrillDownView.this.vsb.getValue(), dimension.height + 2 * DrillDownView.this.VGAP) : -point.y;
            DrillDownView.this.painter.scrolls(-n, -n2);
        }
    }
}

